/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeArrowStore;
import com.raphtory.arrowcore.implementation.EdgeHistoryPartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.EdgePropertyPartition;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedProperty;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.util.LRUListItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class EdgePartition
implements LRUListItem<EdgePartition> {
    protected final int _partitionId;
    protected final EdgePartitionManager _aepm;
    private VectorSchemaRoot _rootRO;
    private EdgeArrowStore _store;
    private ArrowFileReader _reader;
    private boolean _modified = false;
    private boolean _loaded = false;
    private int _currentSize = 0;
    protected EdgeHistoryPartition _history;
    protected SchemaFieldAccessor[] _fieldAccessors;
    protected int _nProperties;
    protected VersionedProperty[] _propertyFields;
    protected EdgePropertyPartition[] _propertyStores;
    protected IntVector[] _propertyPrevPtrVector;
    private EdgePartition _prev = null;
    private EdgePartition _next = null;

    public EdgePartition(EdgePartitionManager edgePartitionManager, int n) {
        this._aepm = edgePartitionManager;
        this._partitionId = n;
        this._store = new EdgeArrowStore();
        this._history = new EdgeHistoryPartition(this._partitionId, this);
        ArrayList<VersionedProperty> arrayList = this._aepm._raphtoryPartition._propertySchema.versionedEdgeProperties();
        int n2 = this._nProperties = arrayList == null ? 0 : arrayList.size();
        if (this._nProperties > 0) {
            this._propertyFields = this._aepm._raphtoryPartition._propertySchema.versionedEdgeProperties().toArray(new VersionedProperty[this._nProperties]);
            this._propertyStores = new EdgePropertyPartition[this._nProperties];
            this._propertyPrevPtrVector = new IntVector[this._nProperties];
            for (int i = 0; i < this._nProperties; ++i) {
                this._propertyStores[i] = new EdgePropertyPartition(this._aepm, this._partitionId, i, this._propertyFields[i]);
            }
        }
    }

    private void initialize() {
        Schema schema = this._aepm._raphtoryPartition._arrowEdgeSchema;
        this._rootRO = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this._aepm.getAllocator());
        this._rootRO.setRowCount(this._aepm.PARTITION_SIZE);
        this._fieldAccessors = this._aepm._raphtoryPartition.createSchemaFieldAccessors(this._rootRO, this._aepm._raphtoryPartition._propertySchema.nonversionedEdgeProperties());
        this._store.init(this._partitionId, this._rootRO, this._fieldAccessors);
        this._history.initialize();
        for (int i = 0; i < this._nProperties; ++i) {
            this._propertyPrevPtrVector[i] = (IntVector)this._rootRO.getVector(this._propertyFields[i]._prevPtrFieldIndexInEntitySchema);
            this._propertyStores[i].initialize();
        }
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public synchronized int getEdgesCount() {
        return this._currentSize;
    }

    public synchronized long getNextFreeEdgeId() {
        if (this._currentSize < this._aepm.PARTITION_SIZE) {
            return (long)this._partitionId * (long)this._aepm.PARTITION_SIZE + (long)this._currentSize;
        }
        return -1L;
    }

    public synchronized int addEdge(Edge edge, long l, long l2) {
        int n = this._aepm.getRowId(edge.getLocalId());
        boolean bl = this._store.addEdge(n, edge, l, l2);
        this._modified = true;
        for (int i = 0; i < this._nProperties; ++i) {
            VersionedEntityPropertyAccessor versionedEntityPropertyAccessor = edge.getProperty(i);
            if (versionedEntityPropertyAccessor == null || !versionedEntityPropertyAccessor.isSet()) continue;
            VersionedEntityPropertyAccessor versionedEntityPropertyAccessor2 = edge.getProperty(i);
            IntVector intVector = this._propertyPrevPtrVector[i];
            int n2 = intVector.isSet(n) == 0 ? -1 : intVector.get(n);
            int n3 = this._propertyStores[i].addProperty(n2, versionedEntityPropertyAccessor2);
            intVector.set(n, n3);
        }
        if (n >= this._currentSize) {
            this._currentSize = n + 1;
        }
        return n;
    }

    public synchronized int addProperty(long l, int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        if (!versionedEntityPropertyAccessor.isSet()) {
            return -1;
        }
        int n2 = this._aepm.getRowId(l);
        IntVector intVector = this._propertyPrevPtrVector[versionedEntityPropertyAccessor.getEntityPrevPtrFieldId()];
        int n3 = intVector.isSet(n2) == 0 ? -1 : intVector.get(n2);
        int n4 = this._propertyStores[n].addProperty(n3, versionedEntityPropertyAccessor);
        intVector.set(n2, n4);
        return n4;
    }

    public synchronized int addHistory(long l, long l2, boolean bl, boolean bl2) {
        long l3;
        int n = this._aepm.getRowId(l);
        int n2 = this._history.addHistory(n, l2, bl, bl2, this._store.getHistoryPtr(n));
        this._store.setHistoryPtr(n, n2);
        long l4 = this._store._oldestPoints.get(n);
        if (l4 > l2) {
            this._store._oldestPoints.set(n, l2);
        }
        if (bl && (l3 = this._store._creationTimes.get(n)) > l2) {
            this._store._creationTimes.set(n, l2);
        }
        this._modified = true;
        return n2;
    }

    public synchronized void setOutgoingEdgePtrByRow(int n, long l) {
        this._store._prevOutgoingEdgesPtr.set(n, l);
        this._modified = true;
    }

    public synchronized void setIncomingEdgePtrByRow(int n, long l) {
        this._store._prevIncomingEdgesPtr.set(n, l);
        this._modified = true;
    }

    public Edge getEdge(long l) {
        if (this._rootRO == null) {
            return null;
        }
        int n = this._aepm.getRowId(l);
        if (this.isValidRow(n)) {
            Edge edge = this._aepm._raphtoryPartition.getEdge();
            this._store.retrieveEdge(n, edge);
            edge.incRefCount();
            for (int i = 0; i < this._nProperties; ++i) {
                IntVector intVector = this._propertyPrevPtrVector[i];
                if (intVector.isSet(n) == 0) continue;
                int n2 = intVector.get(n);
                this._propertyStores[i].retrieveProperty(n2, edge.getProperty(i));
            }
            return edge;
        }
        return null;
    }

    public VersionedEntityPropertyAccessor getPropertyByPropertyRow(int n, int n2, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        this._propertyStores[n].retrieveProperty(n2, versionedEntityPropertyAccessor);
        return versionedEntityPropertyAccessor;
    }

    protected EntityFieldAccessor getFieldByVertexRow(int n, int n2, EntityFieldAccessor entityFieldAccessor) {
        this._fieldAccessors[n].load(entityFieldAccessor, n2);
        return entityFieldAccessor;
    }

    @Override
    public void setNext(EdgePartition edgePartition) {
        this._next = edgePartition;
    }

    @Override
    public void setPrev(EdgePartition edgePartition) {
        this._prev = edgePartition;
    }

    @Override
    public EdgePartition getNext() {
        return this._next;
    }

    @Override
    public EdgePartition getPrev() {
        return this._prev;
    }

    public synchronized void close() {
        this.clearReader();
        this._history.close();
        this.closeProperties();
    }

    public synchronized void saveToFile() {
        try {
            if (this._modified) {
                long l = System.currentTimeMillis();
                this._rootRO.syncSchema();
                this._rootRO.setRowCount(this._currentSize);
                File file = this._aepm.getEdgeFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._rootRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
                long l2 = System.currentTimeMillis();
            }
            this._history.saveToFile();
            this.saveProperties();
            this._modified = false;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public synchronized void ensureLoaded() {
        while (!this._loaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void loadFromFile() {
        this.loadFromFile(false);
    }

    public synchronized void loadFromFile(boolean bl) {
        if (!bl && this._rootRO != null && this._loaded) {
            return;
        }
        File file = this._aepm.getEdgeFile(this._partitionId);
        if (!file.exists()) {
            this.initialize();
            this.notifyAll();
            return;
        }
        try {
            this.clearReader();
            this._reader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._aepm.getAllocator(), this._aepm.getCompressionFactory());
            this._reader.loadNextBatch();
            this._rootRO = this._reader.getVectorSchemaRoot();
            this._rootRO.syncSchema();
            this._fieldAccessors = this._aepm._raphtoryPartition.createSchemaFieldAccessors(this._rootRO, this._aepm._raphtoryPartition._propertySchema.nonversionedEdgeProperties());
            this._store.init(this._partitionId, this._rootRO, this._fieldAccessors);
            this._modified = false;
            this._currentSize = this._rootRO.getRowCount();
            this._rootRO.setRowCount(this._aepm.PARTITION_SIZE);
            if (!this._history.loadFromFile()) {
                this._history.initialize();
            }
            this.loadProperties();
            this._loaded = true;
            this.notifyAll();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void clearReader() {
        try {
            this._loaded = false;
            if (this._store != null) {
                this._store.init(this._partitionId, null, null);
            }
            if (this._rootRO != null) {
                this._rootRO.clear();
                this._rootRO.close();
                this._rootRO = null;
                this._fieldAccessors = null;
            }
            if (this._reader != null) {
                this._reader.close();
                this._reader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void saveProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            if (this._propertyStores[i] == null) continue;
            this._propertyStores[i].saveToFile();
        }
    }

    private void loadProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            this._propertyPrevPtrVector[i] = (IntVector)this._rootRO.getVector(this._propertyFields[i]._prevPtrFieldIndexInEntitySchema);
            if (this._propertyStores[i] == null || this._propertyStores[i].loadFromFile()) continue;
            this._propertyStores[i].initialize();
        }
    }

    private void closeProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            if (this._propertyStores[i] == null) continue;
            this._propertyStores[i].close();
        }
    }

    protected long _getPrevIncomingPtrByRow(int n) {
        return this._store._prevIncomingEdgesPtr.get(n);
    }

    protected boolean isValidRow(int n) {
        return n < this._currentSize && this._store._localIds.isSet(n) != 0;
    }

    protected long _getPrevOutgoingPtrByRow(int n) {
        return this._store._prevOutgoingEdgesPtr.get(n);
    }

    protected long getSrcVertexId(int n) {
        return this._store._srcVertexIds.get(n);
    }

    protected long getDstVertexId(int n) {
        return this._store._dstVertexIds.get(n);
    }

    protected boolean isSrcVertexLocal(int n) {
        return this._store._srcIsGlobals.get(n) == 0;
    }

    protected boolean isDstVertexLocal(int n) {
        return this._store._dstIsGlobals.get(n) == 0;
    }

    protected long _getCreationTime(int n) {
        return this._store._creationTimes.get(n);
    }

    protected long _getLocalEdgeIdByRow(int n) {
        return this._store._localIds.get(n);
    }

    protected int getPropertyPrevPtrByRow(int n, int n2) {
        int n3 = this._propertyPrevPtrVector[n].get(n2);
        return n3;
    }

    public long getEdgeMaxHistoryTime(long l) {
        int n = this._aepm.getRowId(l);
        return this._history.getEdgeMaxHistoryTime(n);
    }

    public long getEdgeMinHistoryTime(long l) {
        int n = this._aepm.getRowId(l);
        return this._history.getEdgeMinHistoryTime(n);
    }
}

