/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class EdgeHistoryStore {
    protected static Schema HISTORY_SCHEMA = new Schema(EdgeHistoryStore.createHistoryFields());
    protected IntVector _edgeRowIds;
    protected BigIntVector _times;
    protected BitVector _states;
    protected BitVector _updates;
    protected IntVector _prevPtrs;
    protected IntVector _sortedTimeIndices;
    protected IntVector _sortedEdgeTimeIndices;
    protected VectorSchemaRoot _root;
    protected int _maxRow = 0;

    protected static List<Field> createHistoryFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("edge_row", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("active", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("update", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("prev_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("sorted_edge_time_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("sorted_time_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    public void init(VectorSchemaRoot vectorSchemaRoot) {
        this._root = vectorSchemaRoot;
        if (this._root != null) {
            this._edgeRowIds = (IntVector)this._root.getVector("edge_row");
            this._times = (BigIntVector)this._root.getVector("time");
            this._states = (BitVector)this._root.getVector("active");
            this._updates = (BitVector)this._root.getVector("update");
            this._prevPtrs = (IntVector)this._root.getVector("prev_ptr");
            this._sortedEdgeTimeIndices = (IntVector)this._root.getVector("sorted_edge_time_index");
            this._sortedTimeIndices = (IntVector)this._root.getVector("sorted_time_index");
        } else {
            this._edgeRowIds = null;
            this._times = null;
            this._states = null;
            this._updates = null;
            this._prevPtrs = null;
            this._sortedTimeIndices = null;
            this._sortedEdgeTimeIndices = null;
        }
    }

    public int addHistory(int n, long l, boolean bl, boolean bl2, int n2) {
        int n3 = this._maxRow++;
        this._edgeRowIds.setSafe(n3, n);
        this._times.setSafe(n3, l);
        this._states.setSafe(n3, bl ? 1 : 0);
        this._updates.setSafe(n3, bl2 ? 1 : 0);
        this._prevPtrs.setSafe(n3, n2);
        return n3;
    }

    public long getPrevPtr(int n) {
        return this._prevPtrs.get(n);
    }
}

