/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import com.raphtory.arrowcore.model.Edge;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class EdgeArrowStore {
    protected int _partitionId;
    protected VectorSchemaRoot _edgeRoot;
    protected BigIntVector _localIds;
    protected BigIntVector _srcVertexIds;
    protected BigIntVector _dstVertexIds;
    protected BitVector _srcIsGlobals;
    protected BitVector _dstIsGlobals;
    protected BitVector _initialValues;
    protected BigIntVector _creationTimes;
    protected BigIntVector _oldestPoints;
    protected BigIntVector _prevIncomingEdgesPtr;
    protected BigIntVector _prevOutgoingEdgesPtr;
    protected IntVector _historyPtr;
    protected SchemaFieldAccessor[] _accessors;
    protected int _nAccessors;

    public static List<Field> createEdgeFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("local_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("src_vertex_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("dst_vertex_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("src_is_global", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("dst_is_global", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("initial_value", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("creation_time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("oldest_point", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("prev_inc_edge_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("prev_out_edge_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("history_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    protected void init(int n, VectorSchemaRoot vectorSchemaRoot, SchemaFieldAccessor[] schemaFieldAccessorArray) {
        this._partitionId = n;
        this._edgeRoot = vectorSchemaRoot;
        this._accessors = schemaFieldAccessorArray;
        int n2 = this._nAccessors = this._accessors == null ? 0 : this._accessors.length;
        if (vectorSchemaRoot != null) {
            this._localIds = (BigIntVector)this._edgeRoot.getVector("local_id");
            this._srcVertexIds = (BigIntVector)this._edgeRoot.getVector("src_vertex_id");
            this._dstVertexIds = (BigIntVector)this._edgeRoot.getVector("dst_vertex_id");
            this._srcIsGlobals = (BitVector)this._edgeRoot.getVector("src_is_global");
            this._dstIsGlobals = (BitVector)this._edgeRoot.getVector("dst_is_global");
            this._initialValues = (BitVector)this._edgeRoot.getVector("initial_value");
            this._creationTimes = (BigIntVector)this._edgeRoot.getVector("creation_time");
            this._oldestPoints = (BigIntVector)this._edgeRoot.getVector("oldest_point");
            this._prevIncomingEdgesPtr = (BigIntVector)this._edgeRoot.getVector("prev_inc_edge_ptr");
            this._prevOutgoingEdgesPtr = (BigIntVector)this._edgeRoot.getVector("prev_out_edge_ptr");
            this._historyPtr = (IntVector)this._edgeRoot.getVector("history_ptr");
        } else {
            this._localIds = null;
            this._srcVertexIds = null;
            this._dstVertexIds = null;
            this._srcIsGlobals = null;
            this._dstIsGlobals = null;
            this._initialValues = null;
            this._creationTimes = null;
            this._oldestPoints = null;
            this._prevIncomingEdgesPtr = null;
            this._prevOutgoingEdgesPtr = null;
            this._historyPtr = null;
        }
    }

    protected boolean addEdge(int n, Edge edge, long l, long l2) {
        boolean bl;
        boolean bl2 = bl = this._localIds.isSet(n) == 0;
        if (bl) {
            this._localIds.set(n, edge.getLocalId());
            this._srcVertexIds.set(n, edge.getSrcVertex());
            this._dstVertexIds.set(n, edge.getDstVertex());
            this._srcIsGlobals.set(n, edge.isSrcGlobal() ? 1 : 0);
            this._dstIsGlobals.set(n, edge.isDstGlobal() ? 1 : 0);
        }
        this._initialValues.set(n, edge.getInitialValue() ? 1 : 0);
        this._creationTimes.set(n, edge.getCreationTime());
        this._oldestPoints.set(n, edge.getOldestPoint());
        this._prevIncomingEdgesPtr.set(n, l);
        this._prevOutgoingEdgesPtr.set(n, l2);
        for (int i = 0; i < this._nAccessors; ++i) {
            this._accessors[i].store(edge.getField(i), n);
        }
        return bl;
    }

    protected Edge retrieveEdge(int n, Edge edge) {
        long l = this._localIds.get(n);
        edge.reset(l, l, this._initialValues.get(n) != 0, this._creationTimes.get(n));
        edge.resetEdgeData(this._srcVertexIds.get(n), this._dstVertexIds.get(n), this._prevIncomingEdgesPtr.get(n), this._prevOutgoingEdgesPtr.get(n), this._srcIsGlobals.get(n) != 0, this._dstIsGlobals.get(n) != 0);
        edge.resetHistoryData(this._historyPtr.get(n));
        for (int i = 0; i < this._nAccessors; ++i) {
            this._accessors[i].load(edge.getField(i), n);
        }
        return edge;
    }

    public void setHistoryPtr(int n, int n2) {
        this._historyPtr.set(n, n2);
    }

    public int getHistoryPtr(int n) {
        if (this._historyPtr.isSet(n) != 0) {
            return this._historyPtr.get(n);
        }
        return -1;
    }
}

