'''
Because the metameta network - metameta_2_7_22_nl2_hs20_b32_v3.pt - 
(which was trained on scores generated by meta_predict_disorder.meta_predict_hybrid())
used a different version of PARROT, need to use py_predictor_v2.

'''

import os 
from metapredict.backend import py_predictor_v2


# if predictor changes, update here 
predictor_string = 'metameta_2_7_22_nl2_hs20_b32_V3.pt'

def get_metapredict_network_version():
    """
    Function that returns a string with the current predictor version. Note that this requires trained weight
    files to have a format that ends in "<anything>_v<version info>.pt". 
    
    For example, 'meta_predict_disorder_100e_v1.pt', 'meta_predict_disorder_best_v1.4.pt' etc.

    Returns
    ----------
    str 
        Returns a string with the current metapredict trained network being used

    """
    return ".".join(predictor_string.split('_')[-1].split('.')[:-1])


def metameta_predict(sequence, normalized=True):

    # get path to network
    PATH = os.path.dirname(os.path.realpath(__file__))
    
    # select the chosen network, kept as separate line of code in 
    used_predictor = predictor_string
    
    # set location of chosen network
    predictor_path = f'{PATH}/networks/{used_predictor}'
    
    # set predictor value using py_predictor_V2
    my_predictor = py_predictor_v2.Predictor(predictor_path, 
                                            dtype="residues")    
    # get values of prediction
    output_values = my_predictor.predict(sequence)
    
    # if normalized=True (defualt)
    if normalized == True:
        # initialize empty list to populate normalized values
        normalized_IDR_values = []
        
        # if the max / min is greater or less than one, normalize
        if min(output_values) < 0 or max(output_values) > 1:
            for cur_value in output_values:
                if cur_value < 0:
                    normalized_IDR_values.append(0)
                elif cur_value > 1:
                    normalized_IDR_values.append(1)
                else:
                    normalized_IDR_values.append(round(float(cur_value), 4))

            # overwrite output_values with normalized_IDR_values (which are now all non-negative).
            output_values = normalized_IDR_values

        # if not out of range still round vals
        else:
            # list to append values rounded to 3 decimals
            rounded_values = []            
            for cur_value in output_values:
                rounded_values.append(round(float(cur_value), 4))
            # overwrite output values
            output_values = rounded_values                

        # return output_values
        return output_values
    
    # if normalized = False, just return the rounded output_values.
    else:
        # list to append values rounded to 3 decimals
        rounded_values = []
        # go through vals and round them
        for cur_value in output_values:
            rounded_values.append(round(float(cur_value), 4))
        # overwrite output values
        output_values = rounded_values

        # return output_values
        return output_values

