# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbt_coverage']

package_data = \
{'': ['*']}

install_requires = \
['typer>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['dbt-coverage = dbt_coverage.__init__:app']}

setup_kwargs = {
    'name': 'dbt-coverage',
    'version': '0.1.1',
    'description': 'A package for computing coverage of dbt-managed data warehouses',
    'long_description': '# dbt-coverage\n\nA CLI library with Python backend for computing docs and test coverage of dbt\nmanaged data warehouses.\n\n## Installation\n\n```\npip install dbt-coverage\n```\n\n## Usage\n\n`dbt-coverage` comes with two basic commands: `compute` and `compare`. The\ndocumentation for the individual commands can be shown by using the `--help`\noption.\n\n### Compute\n\nComputes coverage from `target/catalog.json` and `target/manifest.json` files\nfound in a dbt project. You need to select documentation or test coverage by\nusing the respective CLI argument.\n\n```\n$ cd my-dbt-project\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc  # Compute doc coverage, print it and write it to coverage.json file\n$ dbt-coverage compute test  # Compute test coverage\n\n# Coverage summary\n# =======================================\n# my-table-1               8/20     40.0%\n# my-table-2              20/20    100.0%\n# my-table-3               2/8      25.0%\n# =======================================\n# Total                   30/48     62.5%\n```\n\n### Compare\n\nCompares two `coverage.json` files generated by the `compute` command.\n\n```\n$ dbt-coverage compare coverage-after.json coverage-before.json\n\n# Coverage delta summary\n#               before     after            +/-\n# =============================================\n# Coverage      62.50%    60.00%         -2.50%\n# =============================================\n# Tables             3         4          +1/+0\n# Columns           48        50          +2/+0\n# =============================================\n# Hits              30        30          +0/+0\n# Misses            18        20          +2/+0\n# =============================================\n\n# New misses\n# Catalog                  30/48   (62.50%)  ->    30/50   (60.00%) \n# ==================================================================\n# - my-table-4              -/-       (-)    ->     0/2     (0.00%) \n# -- my-column-1            -/-       (-)    ->     0/1     (0.00%) \n# -- my-column-2            -/-       (-)    ->     0/1     (0.00%) \n# ==================================================================\n```\n\n### Combined use-case\n\n```\n$ cd my-dbt-project\n\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc --cov-report before.json --cov-fail-under 0.5 # Fail if coverage is lower than 50%\n\n# Make changes to the dbt project, e.g. add some columns to the DWH, document some columns, etc.\n\n$ dbt docs generate\n$ dbt-coverage compute doc --cov-report after.json --cov-fail-compare before.json  # Fail if the current coverage is lower than coverage in before.json\n$ dbt-coverage compare after.json before.json  # Generate a detailed coverage delta report\n```\n\n## Related packaged\n\nhttps://github.com/mikaelene/dbt-test-coverage\n\n## License\n\nLicensed under the MIT license (see [LICENSE.md](LICENSE.md) file for more\ndetails).',
    'author': 'Andrej Švec',
    'author_email': 'asvec@slido.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
