/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.filter;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.unidata.util.StringUtil2;

public class StreamFilter
implements DirectoryStream.Filter<Path> {
    private Pattern pattern;
    private boolean nameOnly;

    public StreamFilter(Pattern pattern, boolean nameOnly) {
        this.pattern = pattern;
        this.nameOnly = nameOnly;
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        String matchOn = this.nameOnly ? entry.getName(entry.getNameCount() - 1).toString() : StringUtil2.replace(entry.toString(), "\\", "/");
        Matcher matcher = this.pattern.matcher(matchOn);
        boolean ok = matcher.matches();
        return ok;
    }
}

