# Session Manager
# Allows the application to store products, alter products, and gracefully exit
#
from typing import Optional

from audit_tools.core.session import Session


class SessionManager:
    def __init__(self, file_path: Optional[str] = None, testing: bool = False):
        self.file_path = file_path
        self.session = None
        self.testing = testing

    def __enter__(self) -> Session:
        if self.file_path:
            self.session = Session(self.file_path)
        else:
            self.session = Session()
        return self.session

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.session.products.empty:
            self.session.logger.error("No products found in session")
        else:
            if not self.testing:
                self.session.shutdown(self.file_path)
