# Generated by Django 3.2.10 on 2021-12-25 10:59

import aleksis.core.mixins
from django.conf import settings
from django.contrib.auth import get_user_model
from django.db import migrations, models
import django.db.models.deletion


def assume_ldap_authenticated_true(apps, schema_editor):
    """Set ldap_authenticated user attribute to True to protect existing sites."""
    if not hasattr(settings, "AUTH_LDAP_SERVER_URI"):
        # Skip if LDAP is not used on site
        return

    User = get_user_model()
    UserAdditionalAttributes = apps.get_model("core", "UserAdditionalAttributes")

    db_alias = schema_editor.connection.alias

    attributes = [
        UserAdditionalAttributes(user_id=user.pk, attributes={"ldap_authenticated": True})
        for user in User.objects.using(db_alias).all()
    ]
    UserAdditionalAttributes.objects.using(db_alias).bulk_create(attributes)


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0029_invitations'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserAdditionalAttributes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attributes', models.JSONField(default=dict, verbose_name='Additional attributes')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='additional_attributes', to=settings.AUTH_USER_MODEL, verbose_name='Linked user')),
            ],
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.RunPython(assume_ldap_authenticated_true, lambda a, s: None),
    ]
