-- Table to store selected FITS header
-- information.  Note that the id and
-- filename columns have been added.
--
-- KWS 20091002 - Changed fpa_latitude and fpa_longitude to be
--                Doubles.  These were previously strings.  This is
--                because the CMF file FITS header has changed.
-- 2010-11-11 KWS Added pslib_v, ppsub_v, phot_v, module_v, stats_v, subtraction_mode, fpa_zp, mag_zp
-- 2011-03-09 KWS Added index on mjd_obs
-- 2014-01-06 KWS Added tessellation and skycell, and added an index to filename
-- 2014-06-10 KWS Added input image, output image (diff image) and template image filenames.
--                Note that unlike the CMF filename, the full image filename and directory is
--                preserved.  We need this to make the stamps.  If the filename needs to be
--                truncated, we should probably truncate from the left.
-- 2016-06-15 KWS Added deteff_magref, deteff_calculated_offset, deteff_counts
-- 2019-03-29 KWS The _v columns were incorrectly set to type int. Changed to varchar(20).
-- 2019-08-27 KWS Added 40 new varchar columns that allow us to calculate the chip from the
--                input warp and diff image.

drop table if exists `tcs_cmf_metadata`;

CREATE TABLE `tcs_cmf_metadata` (
  `id` bigint(20) unsigned not null auto_increment,
  `filename` varchar(256),
  `airmass` double,
  `angle` double,
  `cell_bad` double,
  `cell_biassec` varchar(80),
  `cell_darktime` double,
  `cell_gain` double,
  `cell_readnoise` double,
  `cell_saturation` double,
  `cell_trimsec` varchar(80),
  `cell_varfactor` double,
  `cell_xbin` int,
  `cell_xsize` int,
  `cell_xwindow` int,
  `cell_ybin` int,
  `cell_ysize` int,
  `cell_ywindow` int,
  `chip_id` varchar(80),
  `chip_temp` varchar(80),
  `chip_xsize` int,
  `chip_ysize` int,
  `dt_phot` double,
  `exptime` double,
  `extdata` varchar(80),
  `exttype` varchar(80),
  `flimit` double,
  `fpa_alt` double,
  `fpa_az` double,
  `fpa_comment` varchar(80),
  `fpa_dec` varchar(80),
  `fpa_detector` varchar(80),
  `fpa_elevation` double,
  `fpa_env_dir` double,
  `fpa_env_humid` double,
  `fpa_env_temp` double,
  `fpa_env_wind` double,
  `fpa_filterid` varchar(80),
  `fpa_filter` varchar(80),
  `fpa_focus` double,
  `fpa_instrument` varchar(80),
  `fpa_latitude` double,  -- KWS 20091002 - Changed from varchar to double
  `fpa_longitude` double, -- KWS 20091002 - Changed from varchar to double
  `fpa_m1tilt` double,
  `fpa_m1tip` double,
  `fpa_m1x` double,
  `fpa_m1y` double,
  `fpa_m1z` double,
  `fpa_m2tilt` double,
  `fpa_m2tip` double,
  `fpa_m2x` double,
  `fpa_m2y` double,
  `fpa_m2z` double,
  `fpa_object` varchar(80),
  `fpa_obs_group` varchar(80),
  `fpa_obs_mode` varchar(80),
  `fpa_obstype` varchar(80),
  `fpa_obs` varchar(80),
  `fpa_pon_time` double,
  `fpa_posangle` double,
  `fpa_radecsys` varchar(80),
  `fpa_ra` varchar(80),
  `fpa_rotangle` double,
  `fpa_telescope` varchar(80),
  `fpa_teltemp_extra` double,
  `fpa_teltemp_m1cell` double,
  `fpa_teltemp_m1` double,
  `fpa_teltemp_m2` double,
  `fpa_teltemp_spider` double,
  `fpa_teltemp_truss` double,
  `fpa_temp` double,
  `fsatur` double,
  `fwhm_maj` double,
  `fwhm_min` double,
  `fw_mj_lq` double,
  `fw_mj_sg` double,
  `fw_mj_uq` double,
  `fw_mn_lq` double,
  `fw_mn_sg` double,
  `fw_mn_uq` double,
  `imageid` int,
  `imnaxis1` int,
  `imnaxis2` int,
  `mjd_obs` double,
  `msky_max` double,
  `msky_min` double,
  `msky_mn` double,
  `msky_nx` int,
  `msky_ny` int,
  `msky_sig` double,
  `ndet_cr` int,
  `ndet_ext` int,
  `npsfstar` int,
  `nstars` int,
  `photcode` varchar(80),
  `ppsub_input` varchar(80),
  `ppsub_kernel` varchar(80),
  `ppsub_reference` varchar(80),
  `pscamera` varchar(80),
  `psformat` varchar(80),
  `sourceid` int,
  `zero_pt` double,
  `fpa_zp` double,
  `pslib_v` varchar(20),
  `ppsub_v` varchar(20),
  `phot_v` varchar(20),
  `module_v` varchar(20),
  `stats_v` varchar(20),
  `subtraction_mode` int,
  `tessellation` varchar(30),
  `skycell` varchar(30),
  `inputim` varchar(255),
  `diffim` varchar(255),
  `templim` varchar(255),
  `deteff_magref` float,
  `deteff_calculated_offset` float,
  `deteff_counts` smallint unsigned,
  `src_0000` varchar(10),
  `src_0001` varchar(10),
  `src_0002` varchar(10),
  `src_0003` varchar(10),
  `src_0004` varchar(10),
  `src_0005` varchar(10),
  `src_0006` varchar(10),
  `src_0007` varchar(10),
  `src_0008` varchar(10),
  `src_0009` varchar(10),
  `sec_0000` varchar(40),
  `sec_0001` varchar(40),
  `sec_0002` varchar(40),
  `sec_0003` varchar(40),
  `sec_0004` varchar(40),
  `sec_0005` varchar(40),
  `sec_0006` varchar(40),
  `sec_0007` varchar(40),
  `sec_0008` varchar(40),
  `sec_0009` varchar(40),
  `mpx_0000` varchar(40),
  `mpx_0001` varchar(40),
  `mpx_0002` varchar(40),
  `mpx_0003` varchar(40),
  `mpx_0004` varchar(40),
  `mpx_0005` varchar(40),
  `mpx_0006` varchar(40),
  `mpx_0007` varchar(40),
  `mpx_0008` varchar(40),
  `mpx_0009` varchar(40),
  `mpy_0000` varchar(40),
  `mpy_0001` varchar(40),
  `mpy_0002` varchar(40),
  `mpy_0003` varchar(40),
  `mpy_0004` varchar(40),
  `mpy_0005` varchar(40),
  `mpy_0006` varchar(40),
  `mpy_0007` varchar(40),
  `mpy_0008` varchar(40),
  `mpy_0009` varchar(40),
  PRIMARY KEY `key_id` (`id`),
  UNIQUE KEY `key_filename_mjd_obs` (`filename`,`mjd_obs`),
  KEY `idx_mjd_obs` (`mjd_obs`),
  KEY `idx_filename` (`filename`),
  KEY `idx_inputim` (`inputim`),
  KEY `idx_diffim` (`diffim`),
  KEY `idx_templim` (`templim`),
  KEY `idx_tessellation` (`tessellation`),
  KEY `idx_skycell` (`skycell`)
) ENGINE=MyISAM;
