drop table if exists `tcs_cat_gaia_dr1`;

create table `tcs_cat_gaia_dr1` (
`id` bigint unsigned not null, -- aka source_id
`solution_id` bigint unsigned,
`random_index` bigint unsigned,
`ref_epoch` double,
`ra` double not null,
`ra_error` double,
`dec` double not null,
`dec_error` double,
`parallax` double,
`parallax_error` double,
`pmra` double,
`pmra_error` double,
`pmdec` double,
`pmdec_error` double,
`ra_dec_corr` float,
`ra_parallax_corr` float,
`ra_pmra_corr` float,
`ra_pmdec_corr` float,
`dec_parallax_corr` float,
`dec_pmra_corr` float,
`dec_pmdec_corr` float,
`parallax_pmra_corr` float,
`parallax_pmdec_corr` float,
`pmra_pmdec_corr` float,
`astrometric_n_obs_al` int unsigned,
`astrometric_n_obs_ac` int unsigned,
`astrometric_n_good_obs_al` int unsigned,
`astrometric_n_good_obs_ac` int unsigned,
`astrometric_n_bad_obs_al` int unsigned,
`astrometric_n_bad_obs_ac` int unsigned,
`astrometric_delta_q` float,
`astrometric_excess_noise` double,
`astrometric_excess_noise_sig` double,
`astrometric_primary_flag` bool,
`astrometric_relegation_factor` float,
`astrometric_weight_al` float,
`astrometric_weight_ac` float,
`astrometric_priors_used` int unsigned,
`matched_observations` smallint unsigned,
`duplicated_source` bool,
`scan_direction_strength_k1` float,
`scan_direction_strength_k2` float,
`scan_direction_strength_k3` float,
`scan_direction_strength_k4` float,
`scan_direction_mean_k1` float,
`scan_direction_mean_k2` float,
`scan_direction_mean_k3` float,
`scan_direction_mean_k4` float,
`phot_g_n_obs` int unsigned,
`phot_g_mean_flux` double,
`phot_g_mean_flux_error` double,
`phot_g_mean_mag` double,
-- `phot_variable_flag` varchar(30),
`l` double,
`b` double,
`ecl_lon` double,
`ecl_lat` double,
-- Extra columns for local indexing
`htm20ID` bigint unsigned not null,
`htm16ID` bigint unsigned not null,
`cx` double not null,
`cy` double not null,
`cz` double not null,
PRIMARY KEY `key_id` (`id`),
KEY `idx_htm16ID` (`htm16ID`),
KEY `idx_htm20ID` (`htm20ID`),
KEY `idx_ra_dec` (`ra`,`dec`)
) ENGINE=MyISAM;
