# MDV Tools Lite

This is a lightweight version of MDV, designed to simplify project creation and deployment. It provides:

- Tools for creating and manipulating MDV projects
- A **lightweight server** for viewing and modifying projects 
- A method to  **create static websites**, making it ideal for projects that require minimal server-side dependencies.


To install:-
```
pip install mdvtools
```

To test, run the script below, which creates and serves a project from the pbmc3k test data. `folder` is the location where the project will be stored and can be any location that you have write access. A new folder will be created if one does not exist already.

```python
import scanpy
from mdvtools.conversions import convert_scanpy_to_mdv
from mdvtools.serverlite import serve_project
folder = "/path/to/mytestproject"
data = scanpy.datasets.pbmc3k_processed()
proj= convert_scanpy_to_mdv(folder,data)
serve_project(proj)
```

The MDV project will be in the folder you specified and you can view it by pointing your browser to localhost:5050


