# Generated by Django 4.0.4 on 2022-06-26 15:05

import dcim.fields
import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import ipam.fields
import taggit.managers


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("extras", "0073_journalentry_tags_custom_fields"),
        ("dcim", "0153_created_datetimefield"),
        ("ipam", "0057_created_datetimefield"),
    ]

    operations = [
        migrations.CreateModel(
            name="Credential",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("username", models.CharField(blank=True, max_length=100)),
                ("password", models.CharField(blank=True, max_length=100)),
                ("enable_password", models.CharField(blank=True, max_length=100)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Credential",
                "verbose_name_plural": "Credentials",
                "ordering": ("name",),
                "unique_together": {("name",)},
            },
        ),
        migrations.CreateModel(
            name="Discoverable",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("address", models.GenericIPAddressField()),
                ("mode", models.CharField(max_length=30)),
                ("discoverable", models.BooleanField(default=False)),
                (
                    "last_discovered_at",
                    models.DateTimeField(blank=True, editable=False, null=True),
                ),
                (
                    "credential",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="discoverables",
                        to="netdoc.credential",
                    ),
                ),
                (
                    "device",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="dcim.device",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dcim.site",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Device",
                "verbose_name_plural": "Devices",
                "ordering": ("mode", "address"),
                "unique_together": {("address", "mode")},
            },
        ),
        migrations.CreateModel(
            name="DiscoveryLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("command", models.CharField(editable=False, max_length=255)),
                ("configuration", models.BooleanField(default=False, editable=False)),
                ("parsed_output", models.JSONField(default=list, editable=False)),
                (
                    "raw_output",
                    models.TextField(blank=True, default="", editable=False),
                ),
                ("request", models.CharField(editable=False, max_length=255)),
                ("success", models.BooleanField(default=False, editable=False)),
                ("parsed", models.BooleanField(default=False, editable=False)),
                ("ingested", models.BooleanField(default=False, editable=False)),
                (
                    "discoverable",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="discoverylogs",
                        to="netdoc.discoverable",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Log",
                "verbose_name_plural": "Logs",
                "ordering": ("created",),
            },
        ),
        migrations.CreateModel(
            name="RouteTableEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("destination", ipam.fields.IPAddressField(editable=False)),
                ("distance", models.IntegerField(editable=False)),
                ("metric", models.IntegerField(editable=False)),
                (
                    "nexthop_ip",
                    ipam.fields.IPAddressField(blank=True, editable=False, null=True),
                ),
                ("type", models.CharField(editable=False, max_length=30)),
                (
                    "device",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dcim.device",
                    ),
                ),
                (
                    "nexthop_if",
                    models.ForeignKey(
                        blank=True,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dcim.interface",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "vrf",
                    models.ForeignKey(
                        blank=True,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="ipam.vrf",
                    ),
                ),
            ],
            options={
                "verbose_name": "Route ",
                "verbose_name_plural": "Routes",
                "ordering": ("device", "type", "metric"),
                "unique_together": {
                    (
                        "device",
                        "destination",
                        "distance",
                        "metric",
                        "nexthop_if",
                        "nexthop_ip",
                        "type",
                    )
                },
            },
        ),
        migrations.CreateModel(
            name="MacAddressTableEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("mac_address", dcim.fields.MACAddressField(editable=False)),
                (
                    "vendor",
                    models.CharField(
                        blank=True, editable=False, max_length=255, null=True
                    ),
                ),
                ("vvid", models.IntegerField()),
                (
                    "interface",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dcim.interface",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "MAC Address table entry",
                "verbose_name_plural": "MAC Address table entries",
                "ordering": ("mac_address", "vvid"),
                "unique_together": {("interface", "mac_address", "vvid")},
            },
        ),
        migrations.CreateModel(
            name="ArpTableEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("ip_address", ipam.fields.IPAddressField(editable=False)),
                ("mac_address", dcim.fields.MACAddressField(editable=False)),
                (
                    "vendor",
                    models.CharField(
                        blank=True, editable=False, max_length=255, null=True
                    ),
                ),
                (
                    "interface",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dcim.interface",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "ARP table entry",
                "verbose_name_plural": "ARP table entries",
                "ordering": ("ip_address",),
                "unique_together": {("interface", "ip_address", "mac_address")},
            },
        ),
    ]
