from sokoenginepy.game import BaseTessellation, Direction, PusherStep, Tessellation

from .autogenerated_tessellation import SokobanTessellationAutogeneratedSpecMixin
from .tessellation_spec_mixin import TessellationSpecMixin


class DescribeSokobanTessellation(
    TessellationSpecMixin, SokobanTessellationAutogeneratedSpecMixin
):

    illegal_directions = [
        Direction.NORTH_WEST,
        Direction.NORTH_EAST,
        Direction.SOUTH_WEST,
        Direction.SOUTH_EAST,
    ]

    legal_directions = [Direction.LEFT, Direction.RIGHT, Direction.UP, Direction.DOWN]

    legal_moves = [
        PusherStep(Direction.LEFT, False),
        PusherStep(Direction.RIGHT, False),
        PusherStep(Direction.UP, False),
        PusherStep(Direction.DOWN, False),
        PusherStep(Direction.LEFT, True),
        PusherStep(Direction.RIGHT, True),
        PusherStep(Direction.UP, True),
        PusherStep(Direction.DOWN, True),
    ]

    legal_characters = ["l", "r", "u", "d", "L", "R", "U", "D"]

    tessellation = BaseTessellation.instance(Tessellation.SOKOBAN)
