from sokoenginepy.game import BaseTessellation, Direction, PusherStep, Tessellation

from .autogenerated_tessellation import HexobanTessellationAutogeneratedSpecMixin
from .tessellation_spec_mixin import TessellationSpecMixin


class DescribeHexobanTessellation(
    TessellationSpecMixin, HexobanTessellationAutogeneratedSpecMixin
):

    illegal_directions = [Direction.UP, Direction.DOWN]

    legal_directions = [
        Direction.LEFT,
        Direction.RIGHT,
        Direction.NORTH_WEST,
        Direction.NORTH_EAST,
        Direction.SOUTH_WEST,
        Direction.SOUTH_EAST,
    ]

    legal_moves = [
        PusherStep(Direction.LEFT, False),
        PusherStep(Direction.RIGHT, False),
        PusherStep(Direction.NORTH_WEST, False),
        PusherStep(Direction.NORTH_EAST, False),
        PusherStep(Direction.SOUTH_WEST, False),
        PusherStep(Direction.SOUTH_EAST, False),
        PusherStep(Direction.LEFT, True),
        PusherStep(Direction.RIGHT, True),
        PusherStep(Direction.NORTH_WEST, True),
        PusherStep(Direction.NORTH_EAST, True),
        PusherStep(Direction.SOUTH_WEST, True),
        PusherStep(Direction.SOUTH_EAST, True),
    ]

    legal_characters = ["l", "r", "u", "n", "s", "d", "L", "R", "U", "N", "S", "D"]

    tessellation = BaseTessellation.instance(Tessellation.HEXOBAN)
