# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class ConfigurationEntry(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'path': 'str',
        'default_value': 'Object',
        'value_data_type': 'ConfigurationValueDataType'
    }

    attribute_map = {
        'name': 'name',
        'path': 'path',
        'default_value': 'defaultValue',
        'value_data_type': 'valueDataType'
    }

    def __init__(self, name=None, path=None, default_value=None, value_data_type=None, _configuration=None):  # noqa: E501
        """ConfigurationEntry - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._path = None
        self._default_value = None
        self._value_data_type = None
        self.discriminator = None

        self.name = name
        self.path = path
        self.default_value = default_value
        self.value_data_type = value_data_type

    @property
    def name(self):
        """Gets the name of this ConfigurationEntry.  # noqa: E501

        the name of this entry which is displayed in the UI  # noqa: E501

        :return: The name of this ConfigurationEntry.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ConfigurationEntry.

        the name of this entry which is displayed in the UI  # noqa: E501

        :param name: The name of this ConfigurationEntry.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def path(self):
        """Gets the path of this ConfigurationEntry.  # noqa: E501

        the path is the dotnotation which is used to easily access the customMetadata JSON structure of a sample e.g myArray[0].myObject.field  # noqa: E501

        :return: The path of this ConfigurationEntry.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this ConfigurationEntry.

        the path is the dotnotation which is used to easily access the customMetadata JSON structure of a sample e.g myArray[0].myObject.field  # noqa: E501

        :param path: The path of this ConfigurationEntry.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def default_value(self):
        """Gets the default_value of this ConfigurationEntry.  # noqa: E501

        the default value used if its not possible to extract the value using the path or if the value extracted is nullish  # noqa: E501

        :return: The default_value of this ConfigurationEntry.  # noqa: E501
        :rtype: Object
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this ConfigurationEntry.

        the default value used if its not possible to extract the value using the path or if the value extracted is nullish  # noqa: E501

        :param default_value: The default_value of this ConfigurationEntry.  # noqa: E501
        :type: Object
        """
        if self._configuration.client_side_validation and default_value is None:
            raise ValueError("Invalid value for `default_value`, must not be `None`")  # noqa: E501

        self._default_value = default_value

    @property
    def value_data_type(self):
        """Gets the value_data_type of this ConfigurationEntry.  # noqa: E501


        :return: The value_data_type of this ConfigurationEntry.  # noqa: E501
        :rtype: ConfigurationValueDataType
        """
        return self._value_data_type

    @value_data_type.setter
    def value_data_type(self, value_data_type):
        """Sets the value_data_type of this ConfigurationEntry.


        :param value_data_type: The value_data_type of this ConfigurationEntry.  # noqa: E501
        :type: ConfigurationValueDataType
        """
        if self._configuration.client_side_validation and value_data_type is None:
            raise ValueError("Invalid value for `value_data_type`, must not be `None`")  # noqa: E501

        self._value_data_type = value_data_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConfigurationEntry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConfigurationEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConfigurationEntry):
            return True

        return self.to_dict() != other.to_dict()
