"""Attribute Tags for IPP."""
from .enums import IppTag

ATTRIBUTE_TAG_MAP = {
    "attributes-charset": IppTag.CHARSET,
    "attributes-natural-language": IppTag.LANGUAGE,
    "document-number": IppTag.INTEGER,
    "printer-uri": IppTag.URI,
    "requesting-user-name": IppTag.NAME,
    "job-id": IppTag.INTEGER,
    "document-name": IppTag.NAME,
    "job-name": IppTag.NAME,
    "document-format": IppTag.MIME_TYPE,
    "last-document": IppTag.BOOLEAN,
    "copies": IppTag.INTEGER,
    "job-hold-until": IppTag.KEYWORD,
    "job-priority": IppTag.INTEGER,
    "number-up": IppTag.INTEGER,
    "job-sheets": IppTag.NAME,
    "job-uri": IppTag.URI,
    "job-state": IppTag.ENUM,
    "job-state-reason": IppTag.KEYWORD,
    "requested-attributes": IppTag.KEYWORD,
    "member-uris": IppTag.URI,
    "operations-supported": IppTag.ENUM,
    "ppd-name": IppTag.NAME,
    "printer-state-reason": IppTag.KEYWORD,
    "printer-is-shared": IppTag.BOOLEAN,
    "printer-error-policy": IppTag.NAME,
    "printer-info": IppTag.TEXT,
    "which-jobs": IppTag.KEYWORD,
    "my-jobs": IppTag.BOOLEAN,
    "purge-jobs": IppTag.BOOLEAN,
    "hold-job-until": IppTag.KEYWORD,
    "job-printer-uri": IppTag.URI,
    "printer-location": IppTag.TEXT,
    "printer-state": IppTag.ENUM,
    "document-state": IppTag.ENUM,
    "device-uri": IppTag.URI,
}
