"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const apprunner_generated_1 = require("./apprunner.generated");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner.Cpu", version: "1.166.1" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner.Memory", version: "1.166.1" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner.Runtime", version: "1.166.1" };
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner.Source", version: "1.166.1" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner.GithubSource", version: "1.166.1" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner.EcrSource", version: "1.166.1" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner.EcrPublicSource", version: "1.166.1" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner.AssetSource", version: "1.166.1" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner.GitHubConnection", version: "1.166.1" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service
         */
        this.environment = {};
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        // generate an IAM role only when ImageRepositoryType is ECR and props.role is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ? this.props.accessRole : this.generateDefaultRole() : undefined;
        if (source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new apprunner_generated_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: props.cpu?.unit,
                memory: props.memory?.unit,
                instanceRoleArn: props.instanceRole?.roleArn,
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: source.imageRepository ? this.renderImageRepository() : undefined,
                codeRepository: source.codeRepository ? this.renderCodeConfiguration() : undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (source.ecrRepository && this.accessRole) {
            source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration() {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(this.source.codeRepository.codeConfiguration.configurationValues) : undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        this.environment = props.environment;
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            startCommand: props.startCommand,
        };
    }
    renderImageRepository() {
        const repo = this.source.imageRepository;
        this.environment = repo.imageConfiguration?.environment;
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            },
        });
    }
    renderEnvironmentVariables() {
        if (this.environment) {
            let env = [];
            for (const [key, value] of Object.entries(this.environment)) {
                if (key.startsWith('AWSAPPRUNNER')) {
                    throw new Error(`Environment variable key ${key} with a prefix of AWSAPPRUNNER is not allowed`);
                }
                env.push({ name: key, value: value });
            }
            return env;
        }
        else {
            return undefined;
        }
    }
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
}
exports.Service = Service;
_k = JSII_RTTI_SYMBOL_1;
Service[_k] = { fqn: "@aws-cdk/aws-apprunner.Service", version: "1.166.1" };
//# sourceMappingURL=data:application/json;base64,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