from typing import Any


def named_repr(obj: Any) -> str:
    """Enhance the standard repr() with the object's name attribute."""
    s = f"<{obj.__module__}.{type(obj).__name__}: {str(obj.name)} at {id(obj)}>"
    return s
