# KtM960x Definitions
#
#   These have been copy/pasted out of KtM960x.h provided by Keysite
#
IVI_ATTR_BASE = 1000000

IVI_INHERENT_ATTR_BASE = (
    IVI_ATTR_BASE + 50000
)  # base for inherent capability attributes

# base for IVI-defined class attributes
IVI_CLASS_ATTR_BASE = IVI_ATTR_BASE + 250000

# base for IviLxiSync attributes
IVI_LXISYNC_ATTR_BASE = IVI_ATTR_BASE + 950000

IVI_SPECIFIC_ATTR_BASE = (
    IVI_ATTR_BASE + 150000
)  # base for attributes of specific drivers


# #===== IVI Inherent Instrument Attributes ==============================

# - Driver Identification

KTM960X_ATTR_SPECIFIC_DRIVER_DESCRIPTION = (
    IVI_INHERENT_ATTR_BASE + 514
)  # ViString, read-only
KTM960X_ATTR_SPECIFIC_DRIVER_PREFIX = (
    IVI_INHERENT_ATTR_BASE + 302
)  # ViString, read-only
KTM960X_ATTR_SPECIFIC_DRIVER_VENDOR = (
    IVI_INHERENT_ATTR_BASE + 513
)  # ViString, read-only
KTM960X_ATTR_SPECIFIC_DRIVER_REVISION = (
    IVI_INHERENT_ATTR_BASE + 551
)  # ViString, read-only
KTM960X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION = (
    IVI_INHERENT_ATTR_BASE + 515
)  # ViInt32, read-only
KTM960X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION = (
    IVI_INHERENT_ATTR_BASE + 516
)  # ViInt32, read-only

# - User Options
# ViBoolean, read-write
KTM960X_ATTR_RANGE_CHECK = IVI_INHERENT_ATTR_BASE + 2
KTM960X_ATTR_QUERY_INSTRUMENT_STATUS = (
    IVI_INHERENT_ATTR_BASE + 3
)  # ViBoolean, read-write
# ViBoolean, read-write
KTM960X_ATTR_CACHE = IVI_INHERENT_ATTR_BASE + 4
# ViBoolean, read-write
KTM960X_ATTR_SIMULATE = IVI_INHERENT_ATTR_BASE + 5
# ViBoolean, read-write
KTM960X_ATTR_RECORD_COERCIONS = IVI_INHERENT_ATTR_BASE + 6
# ViBoolean, read-write
KTM960X_ATTR_INTERCHANGE_CHECK = IVI_INHERENT_ATTR_BASE + 21

# - Advanced Session Information
# ViString, read-only
KTM960X_ATTR_LOGICAL_NAME = IVI_INHERENT_ATTR_BASE + 305
KTM960X_ATTR_IO_RESOURCE_DESCRIPTOR = (
    IVI_INHERENT_ATTR_BASE + 304
)  # ViString, read-only
# ViString, read-only
KTM960X_ATTR_DRIVER_SETUP = IVI_INHERENT_ATTR_BASE + 7

# - Driver Capabilities
# ViString, read-only
KTM960X_ATTR_GROUP_CAPABILITIES = IVI_INHERENT_ATTR_BASE + 401
KTM960X_ATTR_SUPPORTED_INSTRUMENT_MODELS = (
    IVI_INHERENT_ATTR_BASE + 327
)  # ViString, read-only

# - Instrument Identification

KTM960X_ATTR_INSTRUMENT_FIRMWARE_REVISION = (
    IVI_INHERENT_ATTR_BASE + 510
)  # ViString, read-only
KTM960X_ATTR_INSTRUMENT_MANUFACTURER = (
    IVI_INHERENT_ATTR_BASE + 511
)  # ViString, read-only
# ViString, read-only
KTM960X_ATTR_INSTRUMENT_MODEL = IVI_INHERENT_ATTR_BASE + 512


# ===== Instrument-Specific Attributes ===========

# - System
# ViString, read-only
KTM960X_ATTR_SERIAL_NUMBER = IVI_SPECIFIC_ATTR_BASE + 3
# ViString, read-only
KTM960X_ATTR_SYSTEM_ABOUT = IVI_SPECIFIC_ATTR_BASE + 4
KTM960X_ATTR_SYSTEM_GC_TIMING_OPTIMIZATION_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 5
)  # ViBoolean, read-write
KTM960X_ATTR_SYSTEM_IDENTIFY_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 6
)  # ViBoolean, read-write
# ViInt32, read-only
KTM960X_ATTR_SYSTEM_INSTANCE_ID = IVI_SPECIFIC_ATTR_BASE + 7
# ViString, read-only
KTM960X_ATTR_SYSTEM_OPTIONS = IVI_SPECIFIC_ATTR_BASE + 8
KTM960X_ATTR_SYSTEM_AUTO_TIMER_RESET_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 435
)  # ViBoolean, read-write
# ViString, read-only
KTM960X_ATTR_SYSTEM_DATE = IVI_SPECIFIC_ATTR_BASE + 436
KTM960X_ATTR_SYSTEM_INTERLOCK_THRESHOLD_VOLTAGE = (
    IVI_SPECIFIC_ATTR_BASE + 437
)  # ViReal64, read-write
KTM960X_ATTR_SYSTEM_INTERLOCK_TRIPPED = (
    IVI_SPECIFIC_ATTR_BASE + 438
)  # ViBoolean, read-only
# ViInt32, read-write
KTM960X_ATTR_SYSTEM_LINE_FREQUENCY = IVI_SPECIFIC_ATTR_BASE + 439
# ViReal64, read-only
KTM960X_ATTR_SYSTEM_TIMER_COUNT = IVI_SPECIFIC_ATTR_BASE + 440
# ViInt32, read-only
KTM960X_ATTR_SYSTEM_CHANNEL_COUNT = IVI_SPECIFIC_ATTR_BASE + 514
# ViInt32, read-only
KTM960X_ATTR_SYSTEM_MODULE_COUNT = IVI_SPECIFIC_ATTR_BASE + 518

# - Licensing

KTM960X_ATTR_LICENSING_HOST_IDENTIFIER = (
    IVI_SPECIFIC_ATTR_BASE + 11
)  # ViString, read-only
KTM960X_ATTR_LICENSING_INSTALLED_LICENSES = (
    IVI_SPECIFIC_ATTR_BASE + 12
)  # ViString, read-only

# - SFP

KTM960X_ATTR_SYSTEM_SFP_CONTROLS_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 15
)  # ViBoolean, read-write

# - AutoRefresh

KTM960X_ATTR_SYSTEM_SFP_AUTOREFRESH_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 13
)  # ViBoolean, read-write
KTM960X_ATTR_SYSTEM_SFP_AUTOREFRESH_PERIOD = (
    IVI_SPECIFIC_ATTR_BASE + 14
)  # ViReal64, read-write

# - Group

KTM960X_ATTR_SYSTEM_GROUP_SYNC_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 515
)  # ViBoolean, read-write
KTM960X_ATTR_SYSTEM_GROUP_SYNC_MASTER_MODULE = (
    IVI_SPECIFIC_ATTR_BASE + 516
)  # ViInt32, read-write
KTM960X_ATTR_SYSTEM_GROUP_SYNC_TRIGGER_LINE = (
    IVI_SPECIFIC_ATTR_BASE + 517
)  # ViInt32, read-write

# - Module
# ViInt32, read-only
KTM960X_ATTR_MODULE_COUNT = IVI_SPECIFIC_ATTR_BASE + 23
KTM960X_ATTR_MODULE_INSTRUMENT_CAPABILITY = (
    IVI_SPECIFIC_ATTR_BASE + 24
)  # ViString, read-only
KTM960X_ATTR_MODULE_MAXIMUM_RECORDED_TEMPERATURE = (
    IVI_SPECIFIC_ATTR_BASE + 25
)  # ViReal64, read-only
# ViString, read-only
KTM960X_ATTR_MODULE_OPTIONS = IVI_SPECIFIC_ATTR_BASE + 26
# ViString, read-only
KTM960X_ATTR_MODULE_SERIAL_NUMBER = IVI_SPECIFIC_ATTR_BASE + 27
# ViInt32, read-only
KTM960X_ATTR_MODULE_SLOT = IVI_SPECIFIC_ATTR_BASE + 28
# ViReal64, read-only
KTM960X_ATTR_MODULE_TEMPERATURE = IVI_SPECIFIC_ATTR_BASE + 29
# ViInt32, read-only
KTM960X_ATTR_MODULE_CHASSIS_NUMBER = IVI_SPECIFIC_ATTR_BASE + 490
KTM960X_ATTR_MODULE_IDENTIFY_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 491
)  # ViBoolean, read-write
KTM960X_ATTR_MODULE_INSTALLED_LICENSES = (
    IVI_SPECIFIC_ATTR_BASE + 492
)  # ViString, read-only
KTM960X_ATTR_MODULE_MANUFACTURING_NUMBER = (
    IVI_SPECIFIC_ATTR_BASE + 508
)  # ViString, read-only
# ViString, read-only
KTM960X_ATTR_MODULE_MODEL_NUMBER = IVI_SPECIFIC_ATTR_BASE + 509
# ViInt64, read-only
KTM960X_ATTR_MODULE_UPTIME = IVI_SPECIFIC_ATTR_BASE + 511
# ViInt32, read-only
KTM960X_ATTR_MODULE_CHANNEL_COUNT = IVI_SPECIFIC_ATTR_BASE + 526
# ViBoolean, read-write
KTM960X_ATTR_MODULE_POWER_STATE = IVI_SPECIFIC_ATTR_BASE + 527
# ViString, read-only
KTM960X_ATTR_MODULE_VENDOR = IVI_SPECIFIC_ATTR_BASE + 528
KTM960X_ATTR_MODULE_INTERLOCK_TRIPPED = (
    IVI_SPECIFIC_ATTR_BASE + 529
)  # ViBoolean, read-only

# - Calibration

KTM960X_ATTR_MODULE_CALIBRATION_ADJUSTMENT_INFORMATION = (
    IVI_SPECIFIC_ATTR_BASE + 30
)  # ViString, read-only
KTM960X_ATTR_MODULE_CALIBRATION_DUE_DATE = (
    IVI_SPECIFIC_ATTR_BASE + 31
)  # ViString, read-only
KTM960X_ATTR_MODULE_CALIBRATION_STATUS = (
    IVI_SPECIFIC_ATTR_BASE + 524
)  # ViInt32, read-only
KTM960X_ATTR_MODULE_CALIBRATION_VERIFICATION_INFORMATION = (
    IVI_SPECIFIC_ATTR_BASE + 525
)  # ViString, read-only

# - Nonvolatile

KTM960X_ATTR_NONVOLATILE_ASSET_NUMBER = (
    IVI_SPECIFIC_ATTR_BASE + 34
)  # ViString, read-write
KTM960X_ATTR_NONVOLATILE_CAL_DUE_REMINDER = (
    IVI_SPECIFIC_ATTR_BASE + 35
)  # ViInt32, read-write
KTM960X_ATTR_NONVOLATILE_ENABLE_INSTRUMENT_CAL_WARNINGS = (
    IVI_SPECIFIC_ATTR_BASE + 36
)  # ViBoolean, read-write
KTM960X_ATTR_NONVOLATILE_ENABLE_MODULE_CAL_WARNINGS = (
    IVI_SPECIFIC_ATTR_BASE + 37
)  # ViBoolean, read-write
KTM960X_ATTR_NONVOLATILE_ENABLE_PERIODIC_CAL = (
    IVI_SPECIFIC_ATTR_BASE + 38
)  # ViBoolean, read-write
KTM960X_ATTR_NONVOLATILE_INSTRUMENT_CAL_INTERVAL = (
    IVI_SPECIFIC_ATTR_BASE + 39
)  # ViInt32, read-write
KTM960X_ATTR_NONVOLATILE_MODULE_CAL_INTERVAL = (
    IVI_SPECIFIC_ATTR_BASE + 40
)  # ViInt32, read-write
KTM960X_ATTR_NONVOLATILE_PASSPHRASE = (
    IVI_SPECIFIC_ATTR_BASE + 41
)  # ViString, read-write
KTM960X_ATTR_NONVOLATILE_SYSTEM_IDENTIFICATION = (
    IVI_SPECIFIC_ATTR_BASE + 42
)  # ViString, read-write

# - External
# ViInt32, read-only
KTM960X_ATTR_EXTERNAL_COUNT = IVI_SPECIFIC_ATTR_BASE + 493
KTM960X_ATTR_MODULE_IO_EXTERNAL_EDGE_POSITION = (
    IVI_SPECIFIC_ATTR_BASE + 496
)  # ViInt32, read-write
KTM960X_ATTR_MODULE_IO_EXTERNAL_EDGE_WIDTH = (
    IVI_SPECIFIC_ATTR_BASE + 497
)  # ViReal64, read-write
KTM960X_ATTR_MODULE_IO_EXTERNAL_FUNCTION = (
    IVI_SPECIFIC_ATTR_BASE + 498
)  # ViInt32, read-write
KTM960X_ATTR_MODULE_IO_EXTERNAL_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 499
)  # ViInt32, read-write
KTM960X_ATTR_MODULE_IO_EXTERNAL_POLARITY = (
    IVI_SPECIFIC_ATTR_BASE + 500
)  # ViInt32, read-write
KTM960X_ATTR_MODULE_IO_EXTERNAL_TYPE = (
    IVI_SPECIFIC_ATTR_BASE + 501
)  # ViInt32, read-write

# - PXIe
# ViInt32, read-only
KTM960X_ATTR_PXIE_COUNT = IVI_SPECIFIC_ATTR_BASE + 495
KTM960X_ATTR_MODULE_IO_PXIE_EDGE_POSITION = (
    IVI_SPECIFIC_ATTR_BASE + 503
)  # ViInt32, read-write
# ViInt32, read-write
KTM960X_ATTR_MODULE_IO_PXIE_LEVEL = IVI_SPECIFIC_ATTR_BASE + 504
# ViInt32, read-write
KTM960X_ATTR_MODULE_IO_PXIE_TYPE = IVI_SPECIFIC_ATTR_BASE + 505
KTM960X_ATTR_MODULE_IO_PXIE_EDGE_WIDTH = (
    IVI_SPECIFIC_ATTR_BASE + 506
)  # ViReal64, read-write
KTM960X_ATTR_MODULE_IO_PXIE_FUNCTION = (
    IVI_SPECIFIC_ATTR_BASE + 507
)  # ViInt32, read-write
KTM960X_ATTR_MODULE_IO_PXIE_POLARITY = (
    IVI_SPECIFIC_ATTR_BASE + 530
)  # ViInt32, read-write

# - Calibration

KTM960X_ATTR_CALIBRATION_ADJUSTMENT_INFORMATION = (
    IVI_SPECIFIC_ATTR_BASE + 480
)  # ViString, read-only
# ViString, read-only
KTM960X_ATTR_CALIBRATION_DUE_DATE = IVI_SPECIFIC_ATTR_BASE + 481
KTM960X_ATTR_CALIBRATION_INSTRUMENT_IDENTIFIER = (
    IVI_SPECIFIC_ATTR_BASE + 482
)  # ViString, read-only
# ViString, read-only
KTM960X_ATTR_CALIBRATION_LAST_DATE = IVI_SPECIFIC_ATTR_BASE + 483
# ViInt32, read-only
KTM960X_ATTR_CALIBRATION_STATUS = IVI_SPECIFIC_ATTR_BASE + 484
KTM960X_ATTR_CALIBRATION_VERIFICATION_INFORMATION = (
    IVI_SPECIFIC_ATTR_BASE + 485
)  # ViString, read-only

# - Measurement
# ViInt32, read-only
KTM960X_ATTR_MEASUREMENT_COUNT = IVI_SPECIFIC_ATTR_BASE + 327
KTM960X_ATTR_MEASUREMENT_ACQUISITION_MODE = (
    IVI_SPECIFIC_ATTR_BASE + 486
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 489
)  # ViBoolean, read-write

# - Arm

KTM960X_ATTR_MEASUREMENT_ARM_BYPASS = (
    IVI_SPECIFIC_ATTR_BASE + 328
)  # ViInt32, read-write
# ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_ARM_COUNT = IVI_SPECIFIC_ATTR_BASE + 329
KTM960X_ATTR_MEASUREMENT_ARM_DELAY = (
    IVI_SPECIFIC_ATTR_BASE + 330
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_ARM_SOURCE = (
    IVI_SPECIFIC_ATTR_BASE + 331
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_ARM_TIMER = (
    IVI_SPECIFIC_ATTR_BASE + 332
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_ARM_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 333
)  # ViBoolean, read-write

# - Current

KTM960X_ATTR_MEASUREMENT_CURRENT_APERTURE = (
    IVI_SPECIFIC_ATTR_BASE + 334
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_APERTURE_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 335
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_IS_COMPLIANCE = (
    IVI_SPECIFIC_ATTR_BASE + 340
)  # ViBoolean, read-only
KTM960X_ATTR_MEASUREMENT_CURRENT_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 341
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_NEGATIVE_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 342
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_NPLC = (
    IVI_SPECIFIC_ATTR_BASE + 343
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_NPLC_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 344
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_POSITIVE_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 345
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_CURRENT_RANGE = (
    IVI_SPECIFIC_ATTR_BASE + 346
)  # ViReal64, read-write

# - Function

KTM960X_ATTR_MEASUREMENT_FUNCTION_DISABLE_COUNT = (
    IVI_SPECIFIC_ATTR_BASE + 348
)  # ViInt32, read-only
KTM960X_ATTR_MEASUREMENT_FUNCTION_ENABLE_COUNT = (
    IVI_SPECIFIC_ATTR_BASE + 349
)  # ViInt32, read-only

# - Trigger

KTM960X_ATTR_MEASUREMENT_TRIGGER_BYPASS = (
    IVI_SPECIFIC_ATTR_BASE + 366
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_COUNT = (
    IVI_SPECIFIC_ATTR_BASE + 367
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_DELAY = (
    IVI_SPECIFIC_ATTR_BASE + 368
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_SOURCE = (
    IVI_SPECIFIC_ATTR_BASE + 369
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_TIMER = (
    IVI_SPECIFIC_ATTR_BASE + 370
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_TRIGGER_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 371
)  # ViBoolean, read-write

# - Voltage

KTM960X_ATTR_MEASUREMENT_VOLTAGE_APERTURE = (
    IVI_SPECIFIC_ATTR_BASE + 372
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_APERTURE_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 373
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_IS_COMPLIANCE = (
    IVI_SPECIFIC_ATTR_BASE + 378
)  # ViBoolean, read-only
KTM960X_ATTR_MEASUREMENT_VOLTAGE_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 379
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_NEGATIVE_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 380
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_NPLC = (
    IVI_SPECIFIC_ATTR_BASE + 381
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_NPLC_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 382
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_POSITIVE_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 383
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_VOLTAGE_RANGE = (
    IVI_SPECIFIC_ATTR_BASE + 384
)  # ViReal64, read-write

# - WaitTime

KTM960X_ATTR_MEASUREMENT_WAIT_TIME_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 386
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_WAIT_TIME_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 387
)  # ViBoolean, read-write
KTM960X_ATTR_MEASUREMENT_WAIT_TIME_GAIN = (
    IVI_SPECIFIC_ATTR_BASE + 388
)  # ViReal64, read-write
KTM960X_ATTR_MEASUREMENT_WAIT_TIME_OFFSET = (
    IVI_SPECIFIC_ATTR_BASE + 389
)  # ViReal64, read-write

# - Sampling

KTM960X_ATTR_MEASUREMENT_SAMPLING_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 487
)  # ViInt32, read-write
KTM960X_ATTR_MEASUREMENT_SAMPLING_TOTAL_TIME = (
    IVI_SPECIFIC_ATTR_BASE + 488
)  # ViReal64, read-write

# - Output
# ViInt32, read-only
KTM960X_ATTR_OUTPUT_COUNT = IVI_SPECIFIC_ATTR_BASE + 390
KTM960X_ATTR_OUTPUT_AUTO_OFF_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 391
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_AUTO_ON_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 392
)  # ViBoolean, read-write
# ViBoolean, read-write
KTM960X_ATTR_OUTPUT_ENABLED = IVI_SPECIFIC_ATTR_BASE + 403
# ViInt32, read-write
KTM960X_ATTR_OUTPUT_OFF_CONDITION = IVI_SPECIFIC_ATTR_BASE + 410
# ViInt32, read-write
KTM960X_ATTR_OUTPUT_PRIORITY_MODE = IVI_SPECIFIC_ATTR_BASE + 411
# ViInt32, read-write
KTM960X_ATTR_OUTPUT_SHAPE = IVI_SPECIFIC_ATTR_BASE + 419
# ViInt32, read-write
KTM960X_ATTR_OUTPUT_OPERATION_MODE = IVI_SPECIFIC_ATTR_BASE + 479

# - Current

KTM960X_ATTR_OUTPUT_CURRENT_AUTO_RANGE_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 393
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_CURRENT_BASE_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 394
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_CURRENT_BASE_TYPE = (
    IVI_SPECIFIC_ATTR_BASE + 395
)  # ViInt32, read-write
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_CURRENT_LEVEL = IVI_SPECIFIC_ATTR_BASE + 396
KTM960X_ATTR_OUTPUT_CURRENT_POST_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 397
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_CURRENT_POST_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 398
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_CURRENT_POST_TYPE = (
    IVI_SPECIFIC_ATTR_BASE + 399
)  # ViInt32, read-write
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_CURRENT_RANGE = IVI_SPECIFIC_ATTR_BASE + 400
KTM960X_ATTR_OUTPUT_CURRENT_RANGE_LOWER_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 401
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_CURRENT_TRIGGERED_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 402
)  # ViReal64, read-write

# - Filter

KTM960X_ATTR_OUTPUT_FILTER_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 404
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_FILTER_CUT_OFF_FREQUENCY = (
    IVI_SPECIFIC_ATTR_BASE + 405
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_FILTER_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 406
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_FILTER_TIME_CONSTANT = (
    IVI_SPECIFIC_ATTR_BASE + 407
)  # ViReal64, read-write

# - Pulse

# ViReal64, read-write
KTM960X_ATTR_OUTPUT_PULSE_DELAY = IVI_SPECIFIC_ATTR_BASE + 413
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_PULSE_WIDTH = IVI_SPECIFIC_ATTR_BASE + 414

# - Voltage

KTM960X_ATTR_OUTPUT_VOLTAGE_AUTO_RANGE_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 420
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_BASE_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 421
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_BASE_TYPE = (
    IVI_SPECIFIC_ATTR_BASE + 422
)  # ViInt32, read-write
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_LEVEL = IVI_SPECIFIC_ATTR_BASE + 423
KTM960X_ATTR_OUTPUT_VOLTAGE_POST_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 424
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_POST_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 425
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_POST_TYPE = (
    IVI_SPECIFIC_ATTR_BASE + 426
)  # ViInt32, read-write
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_RANGE = IVI_SPECIFIC_ATTR_BASE + 427
KTM960X_ATTR_OUTPUT_VOLTAGE_RANGE_LOWER_LIMIT = (
    IVI_SPECIFIC_ATTR_BASE + 428
)  # ViReal64, read-write
KTM960X_ATTR_OUTPUT_VOLTAGE_TRIGGERED_LEVEL = (
    IVI_SPECIFIC_ATTR_BASE + 429
)  # ViReal64, read-write

# - WaitTime

KTM960X_ATTR_OUTPUT_WAITTIME_AUTO_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 430
)  # ViBoolean, read-write
KTM960X_ATTR_OUTPUT_WAITTIME_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 431
)  # ViBoolean, read-write
# ViReal64, read-write
KTM960X_ATTR_OUTPUT_WAITTIME_GAIN = IVI_SPECIFIC_ATTR_BASE + 432
KTM960X_ATTR_OUTPUT_WAITTIME_OFFSET = (
    IVI_SPECIFIC_ATTR_BASE + 433
)  # ViReal64, read-write

# - Transient

# ViInt32, read-only
KTM960X_ATTR_TRANSIENT_COUNT = IVI_SPECIFIC_ATTR_BASE + 441
KTM960X_ATTR_TRANSIENT_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 521
)  # ViBoolean, read-write

# - Arm
# ViInt32, read-write
KTM960X_ATTR_TRANSIENT_ARM_BYPASS = IVI_SPECIFIC_ATTR_BASE + 442
# ViInt32, read-write
KTM960X_ATTR_TRANSIENT_ARM_COUNT = IVI_SPECIFIC_ATTR_BASE + 443
# ViReal64, read-write
KTM960X_ATTR_TRANSIENT_ARM_DELAY = IVI_SPECIFIC_ATTR_BASE + 444
# ViInt32, read-write
KTM960X_ATTR_TRANSIENT_ARM_SOURCE = IVI_SPECIFIC_ATTR_BASE + 445
# ViReal64, read-write
KTM960X_ATTR_TRANSIENT_ARM_TIMER = IVI_SPECIFIC_ATTR_BASE + 446
KTM960X_ATTR_TRANSIENT_ARM_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 447
)  # ViBoolean, read-write

# - Current

KTM960X_ATTR_TRANSIENT_CURRENT_CENTER = (
    IVI_SPECIFIC_ATTR_BASE + 448
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_LIST_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 449
)  # ViInt32, read-only
KTM960X_ATTR_TRANSIENT_CURRENT_LIST_START_POINT = (
    IVI_SPECIFIC_ATTR_BASE + 450
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_MODE = (
    IVI_SPECIFIC_ATTR_BASE + 451
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_SPAN = (
    IVI_SPECIFIC_ATTR_BASE + 452
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_START = (
    IVI_SPECIFIC_ATTR_BASE + 453
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_STEP = (
    IVI_SPECIFIC_ATTR_BASE + 454
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_STOP = (
    IVI_SPECIFIC_ATTR_BASE + 455
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_SWEEP_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 456
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_LIST_OUTPUT_TRIGGER_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 519
)  # ViBoolean, read-write
KTM960X_ATTR_TRANSIENT_CURRENT_TRIGGER_LIST_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 520
)  # ViInt32, read-only

# - Sweep

KTM960X_ATTR_TRANSIENT_SWEEP_DIRECTION = (
    IVI_SPECIFIC_ATTR_BASE + 457
)  # ViInt32, read-write
# ViInt32, read-write
KTM960X_ATTR_TRANSIENT_SWEEP_MODE = IVI_SPECIFIC_ATTR_BASE + 458
KTM960X_ATTR_TRANSIENT_SWEEP_OUTPUT_RANGING_MODE = (
    IVI_SPECIFIC_ATTR_BASE + 459
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_SWEEP_OUTPUT_SCALE = (
    IVI_SPECIFIC_ATTR_BASE + 460
)  # ViInt32, read-write

# - Trigger

KTM960X_ATTR_TRANSIENT_TRIGGER_BYPASS = (
    IVI_SPECIFIC_ATTR_BASE + 461
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_CONTINUOUS_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 462
)  # ViBoolean, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_COUNT = (
    IVI_SPECIFIC_ATTR_BASE + 463
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_DELAY = (
    IVI_SPECIFIC_ATTR_BASE + 464
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_SOURCE = (
    IVI_SPECIFIC_ATTR_BASE + 465
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_TIMER = (
    IVI_SPECIFIC_ATTR_BASE + 466
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_TRIGGER_TRIGGER_OUTPUT_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 467
)  # ViBoolean, read-write

# - Voltage

KTM960X_ATTR_TRANSIENT_VOLTAGE_CENTER = (
    IVI_SPECIFIC_ATTR_BASE + 468
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_LIST_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 469
)  # ViInt32, read-only
KTM960X_ATTR_TRANSIENT_VOLTAGE_LIST_START_POINT = (
    IVI_SPECIFIC_ATTR_BASE + 470
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_MODE = (
    IVI_SPECIFIC_ATTR_BASE + 471
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_SPAN = (
    IVI_SPECIFIC_ATTR_BASE + 472
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_START = (
    IVI_SPECIFIC_ATTR_BASE + 473
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_STEP = (
    IVI_SPECIFIC_ATTR_BASE + 474
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_STOP = (
    IVI_SPECIFIC_ATTR_BASE + 475
)  # ViReal64, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_SWEEP_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 476
)  # ViInt32, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_LIST_OUTPUT_TRIGGER_ENABLED = (
    IVI_SPECIFIC_ATTR_BASE + 522
)  # ViBoolean, read-write
KTM960X_ATTR_TRANSIENT_VOLTAGE_TRIGGER_LIST_POINTS = (
    IVI_SPECIFIC_ATTR_BASE + 523
)  # ViInt32, read-only


# *------------------------ Attribute Value Defines -------------------------*

# - Defined values for

KTM960X_VAL_STATUS_BYTE_FLAGS_USER0 = 1
KTM960X_VAL_STATUS_BYTE_FLAGS_USER1 = 2
KTM960X_VAL_STATUS_BYTE_FLAGS_USER2 = 4
KTM960X_VAL_STATUS_BYTE_FLAGS_USER3 = 8
KTM960X_VAL_STATUS_BYTE_FLAGS_MESSAGE_AVAILABLE = 16
KTM960X_VAL_STATUS_BYTE_FLAGS_EVENT_STATUS_REGISTER = 32
KTM960X_VAL_STATUS_BYTE_FLAGS_REQUESTING_SERVICE = 64
KTM960X_VAL_STATUS_BYTE_FLAGS_USER7 = 128

# - Defined values for
# 	parameter Buttons in function KtM960x_SystemSfpMessageBox

KTM960X_VAL_MESSAGE_BOX_BUTTONS_OK = 0
KTM960X_VAL_MESSAGE_BOX_BUTTONS_OK_CANCEL = 1
KTM960X_VAL_MESSAGE_BOX_BUTTONS_YES_NO = 2

# - Defined values for
# 	parameter Val in function KtM960x_SystemSfpMessageBox

KTM960X_VAL_MESSAGE_BOX_RESULTS_NONE = 0
KTM960X_VAL_MESSAGE_BOX_RESULTS_OK = 1
KTM960X_VAL_MESSAGE_BOX_RESULTS_CANCEL = 2
KTM960X_VAL_MESSAGE_BOX_RESULTS_YES = 3
KTM960X_VAL_MESSAGE_BOX_RESULTS_NO = 4

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_CALIBRATION_STATUS
# 	attribute KTM960X_ATTR_CALIBRATION_STATUS

KTM960X_VAL_CALIBRATION_STATUS_DUE = 1
KTM960X_VAL_CALIBRATION_STATUS_EXPIRED = 2
KTM960X_VAL_CALIBRATION_STATUS_INSTRUMENT_CALIBRATED = 0
KTM960X_VAL_CALIBRATION_STATUS_MODULES_CALIBRATED = 3
KTM960X_VAL_CALIBRATION_STATUS_NOT_CALIBRATED = 4
KTM960X_VAL_CALIBRATION_STATUS_NOT_SUBJECT_TO_CALIBRATION = 5

# - Defined values for

KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_MASTER_PRODUCER = 0
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_MASTER_CONSUMER = 1
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_SLAVE_PRODUCER = 2
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_SLAVE_CONSUMER = 3
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_STREAMING_MASTER_PRODUCER = 4
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_STREAMING_MASTER_CONSUMER = 5
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_STREAMING_SLAVE_PRODUCER = 6
KTM960X_VAL_PEER_TO_PEER_PORT_ROLE_STREAMING_SLAVE_CONSUMER = 7

# - Defined values for

KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_OPAQUE = 0
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_I8 = 1
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_I16 = 2
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_I32 = 3
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_F32 = 4
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_F64 = 5
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_K_I32V1 = 101
KTM960X_VAL_PEER_TO_PEER_DATA_FORMAT_K_I24M8 = 102

# - Defined values for

KTM960X_VAL_DEVICE_SYNC_RESOURCES_FP_SYNC = 32768
KTM960X_VAL_DEVICE_SYNC_RESOURCES_NONE = 0
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_LBL6 = 2048
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_LBR6 = 1024
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_STAR = 512
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG0 = 1
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG1 = 2
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG2 = 4
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG3 = 8
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG4 = 16
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG5 = 32
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG6 = 64
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXI_TRIG7 = 128
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXIE_DSTARA = 4096
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXIE_DSTARB = 8192
KTM960X_VAL_DEVICE_SYNC_RESOURCES_PXIE_DSTARC = 16384

# - Defined values for

KTM960X_VAL_DEVICE_SYNC_STATE_ARM = 1
KTM960X_VAL_DEVICE_SYNC_STATE_IDLE = 0
KTM960X_VAL_DEVICE_SYNC_STATE_RUN = 3
KTM960X_VAL_DEVICE_SYNC_STATE_TRIGGER = 2
KTM960X_VAL_DEVICE_SYNC_STATE_UNKNOWN = 4

# - Defined values for

KTM960X_VAL_DEVICE_SYNC_ROLE_GROUP_MASTER = 2
KTM960X_VAL_DEVICE_SYNC_ROLE_LOCAL_MASTER = 4
KTM960X_VAL_DEVICE_SYNC_ROLE_OFF = 0
KTM960X_VAL_DEVICE_SYNC_ROLE_SLAVE = 3
KTM960X_VAL_DEVICE_SYNC_ROLE_SYSTEM_MASTER = 1
KTM960X_VAL_DEVICE_SYNC_ROLE_NOT_SUPPORTED = -1

# - Defined values for

KTM960X_VAL_ODI_LANE_RATE_12R5G = 1
KTM960X_VAL_ODI_LANE_RATE_14R1G = 2

# - Defined values for

KTM960X_VAL_ODI_DIRECTIONALITY_BIDIRECTIONAL = 1
KTM960X_VAL_ODI_DIRECTIONALITY_PRODUCER = 2
KTM960X_VAL_ODI_DIRECTIONALITY_CONSUMER = 3
KTM960X_VAL_ODI_DIRECTIONALITY_DUAL_UNIDIRECTIONAL = 4

# - Defined values for

KTM960X_VAL_ODI_FLOW_CONTROL_NONE = 1
KTM960X_VAL_ODI_FLOW_CONTROL_INBAND = 2
KTM960X_VAL_ODI_FLOW_CONTROL_INBAND_PER_CHANNEL = 3
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_1WIRE = 4
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_0 = 100
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_1 = 101
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_2 = 102
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_3 = 103
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_4 = 104
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_5 = 105
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_6 = 106
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_7 = 107
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_8 = 108
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_9 = 109
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_10 = 110
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_11 = 111
KTM960X_VAL_ODI_FLOW_CONTROL_OUTOFBAND_BACKPLANE_12 = 112

# - Defined values for

KTM960X_VAL_ODI_PORT_STATUS_ACTIVE = 1
KTM960X_VAL_ODI_PORT_STATUS_TX_READY = 2
KTM960X_VAL_ODI_PORT_STATUS_RX_READY = 4
KTM960X_VAL_ODI_PORT_STATUS_RX_LANE_ERROR = 8
KTM960X_VAL_ODI_PORT_STATUS_RX_BURST_MAX_ERROR = 16
KTM960X_VAL_ODI_PORT_STATUS_RX_CRC_ERROR = 32
KTM960X_VAL_ODI_PORT_STATUS_RX_OVERRUN = 64
KTM960X_VAL_ODI_PORT_STATUS_RX_FC_STATUS = 65536
KTM960X_VAL_ODI_PORT_STATUS_RX_FC_STATUS_0 = 131072
KTM960X_VAL_ODI_PORT_STATUS_RX_SIGNAL_LOSS = 128
KTM960X_VAL_ODI_PORT_STATUS_RX_SYNC_PENDING = 256

# - Defined values for

KTM960X_VAL_ODI_PACKET_FORMAT_NO_HEADER = 1
KTM960X_VAL_ODI_PACKET_FORMAT_VITA49_DATA = 2
KTM960X_VAL_ODI_PACKET_FORMAT_VITA49_WITH_CONTEXT = 3
KTM960X_VAL_ODI_PACKET_FORMAT_VITA49_ONCE = 1001
KTM960X_VAL_ODI_PACKET_FORMAT_VITA49_EXTENSION = 4

# - Defined values for

KTM960X_VAL_ODI_TIMESTAMP_FORMAT_NO_TIMESTAMP = 1
KTM960X_VAL_ODI_TIMESTAMP_FORMAT_GPS = 2
KTM960X_VAL_ODI_TIMESTAMP_FORMAT_RELATIVE = 3
KTM960X_VAL_ODI_TIMESTAMP_FORMAT_SAMPLE_COUNT = 4
KTM960X_VAL_ODI_TIMESTAMP_FORMAT_UTC = 5

# - Defined values for

KTM960X_VAL_ARB_DATA_FORMAT_ENUM_ARB_DATA_FORMATIQ24 = 10
KTM960X_VAL_ARB_DATA_FORMAT_ENUM_ARB_DATA_FORMATIQ32 = 2
KTM960X_VAL_ARB_DATA_FORMAT_ENUM_ARB_DATA_FORMATIQ64 = 3
KTM960X_VAL_ARB_DATA_FORMAT_ENUM_ARB_DATA_FORMAT_OPAQUE = 11

# - Defined values for

KTM960X_VAL_MARKER_ENUM_MARKER1 = 1
KTM960X_VAL_MARKER_ENUM_MARKER2 = 2
KTM960X_VAL_MARKER_ENUM_MARKER3 = 3
KTM960X_VAL_MARKER_ENUM_MARKER4 = 4
KTM960X_VAL_MARKER_ENUM_MARKER_NONE = 0

# - Defined values for

KTM960X_VAL_ARB_MEMORY_MODE_ENUM_ARB_MEMORY_MODE_AUTO = 0
KTM960X_VAL_ARB_MEMORY_MODE_ENUM_ARB_MEMORY_MODE_MANUAL = 1

# - Defined values for

KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARB_AUTO = 99
KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARBDP = 1
KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARBDP_PLUS_MARKERS = 0
KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARB_KEYSIGHT = 4
KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARB_SHORT = 3
KTM960X_VAL_BINARY_ARB_ENUM_BINARY_ARBSP = 2

# - Defined values for
# parameter FetchType in function KtM960x_MeasurementFetchArrayData
# parameter FetchType in function KtM960x_MeasurementFetchScalarData
# parameter FetchType in function KtM960x_MeasurementReadArrayData
# parameter FetchType in function KtM960x_MeasurementReadScalarData
# parameter FetchType in function KtM960x_MeasurementFetchLatestScalarData

KTM960X_VAL_MEASUREMENT_FETCH_TYPE_CURRENT = 2
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_RESISTANCE = 3
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_SOURCE = 6
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_STATUS = 4
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_TIME = 5
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_VOLTAGE = 1
KTM960X_VAL_MEASUREMENT_FETCH_TYPE_ALL = 0

# - Defined values for
# attribute KTM960X_ATTR_MEASUREMENT_ARM_SOURCE
# attribute KTM960X_ATTR_MEASUREMENT_TRIGGER_SOURCE
# attribute KTM960X_ATTR_TRANSIENT_ARM_SOURCE
# attribute KTM960X_ATTR_TRANSIENT_TRIGGER_SOURCE

KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_AINT = 0
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_BUS = 1
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_TIMER = 2
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI0 = 3
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI1 = 4
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI2 = 5
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI3 = 6
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI4 = 7
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI5 = 8
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI6 = 9
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PXI7 = 10
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_EXTERNAL1 = 11
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_EXTERNAL2 = 12
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_INTERNAL1 = 13
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_INTERNAL2 = 14
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PEER1 = 15
KTM960X_VAL_MEASUREMENT_TRIGGER_SOURCE_PEER2 = 16

# - Defined values for
# parameter MeasureType in function KtM960x_MeasurementMeasure
# parameter Val in function KtM960x_MeasurementFunctionGetDisabled
# parameter Val in function KtM960x_MeasurementFunctionGetEnabled
# parameter MeasureType in function KtM960x_MeasurementFunctionGetState
# parameter MeasureType in function KtM960x_MeasurementFunctionSetDisabled
# parameter MeasureType in function KtM960x_MeasurementFunctionSetEnabled

KTM960X_VAL_MEASUREMENT_TYPE_CURRENT = 2
KTM960X_VAL_MEASUREMENT_TYPE_RESISTANCE = 3
KTM960X_VAL_MEASUREMENT_TYPE_VOLTAGE = 1
KTM960X_VAL_MEASUREMENT_TYPE_ALL = 0

# - Defined values for
# parameter Val in function KtM960x_MeasurementGetOutputTrigger
# parameter Triggers in function KtM960x_MeasurementSetOutputTrigger
# parameter Val in function KtM960x_MeasurementArmGetOutputTrigger
# parameter Triggers in function KtM960x_MeasurementArmSetOutputTrigger
# parameter Val in function KtM960x_MeasurementTriggerGetOutputTrigger
# parameter Triggers in function KtM960x_MeasurementTriggerSetOutputTrigger
# parameter Val in function KtM960x_TransientGetOutputTrigger
# parameter Triggers in function KtM960x_TransientSetOutputTrigger
# parameter Val in function KtM960x_TransientArmGetOutputTrigger
# parameter Triggers in function KtM960x_TransientArmSetOutputTrigger
# parameter Val in function KtM960x_TransientCurrentGetListOutputTrigger
# parameter Triggers in function KtM960x_TransientCurrentSetListOutputTrigger
# parameter Val in function KtM960x_TransientTriggerGetOutputTrigger
# parameter Triggers in function KtM960x_TransientTriggerSetOutputTrigger
# parameter Val in function KtM960x_TransientVoltageGetListOutputTrigger
# parameter Triggers in function KtM960x_TransientVoltageSetListOutputTrigger

KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI0 = 0
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI1 = 1
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI2 = 2
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI3 = 3
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI4 = 4
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI5 = 5
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI6 = 6
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PXI7 = 7
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_EXTERNAL1 = 8
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_EXTERNAL2 = 9
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_INTERNAL1 = 10
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_INTERNAL2 = 11
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PEER1 = 12
KTM960X_VAL_OUTPUT_TRIGGER_SIGNAL_PEER2 = 13

# - Defined values for
# attribute KTM960X_ATTR_MEASUREMENT_ARM_BYPASS
# attribute KTM960X_ATTR_MEASUREMENT_TRIGGER_BYPASS
# attribute KTM960X_ATTR_TRANSIENT_ARM_BYPASS
# attribute KTM960X_ATTR_TRANSIENT_TRIGGER_BYPASS

KTM960X_VAL_BYPASS_OFF = 0
KTM960X_VAL_BYPASS_ONCE = 1

# - Defined values for

KTM960X_VAL_FORCE_RANGING_MODE_NORMAL = 0
KTM960X_VAL_FORCE_RANGING_MODE_SPEED = 1
KTM960X_VAL_FORCE_RANGING_MODE_RESOLUTION = 2

# - Defined values for

KTM960X_VAL_BUFFER_CONTROL_NEXT = 0
KTM960X_VAL_BUFFER_CONTROL_NEVER = 1

# - Defined values for

KTM960X_VAL_TRACE_OPERATION_MEAN = 0
KTM960X_VAL_TRACE_OPERATION_STANDARD_DEVIATION = 1
KTM960X_VAL_TRACE_OPERATION_MAXIMUM = 2
KTM960X_VAL_TRACE_OPERATION_MINIMUM = 3
KTM960X_VAL_TRACE_OPERATION_PEAK_TO_PEAK = 4

# - Defined values for

KTM960X_VAL_TIME_STAMP_FORMAT_ABSOLUTE = 0
KTM960X_VAL_TIME_STAMP_FORMAT_DELTA = 1

# - Defined values for
# attribute KTM960X_ATTR_OUTPUT_CURRENT_BASE_TYPE
# attribute KTM960X_ATTR_OUTPUT_VOLTAGE_BASE_TYPE

KTM960X_VAL_OUTPUT_BASE_TYPE_MANUAL = 0
KTM960X_VAL_OUTPUT_BASE_TYPE_IMMEDIATE = 1
KTM960X_VAL_OUTPUT_BASE_TYPE_TRIGGERED = 2
KTM960X_VAL_OUTPUT_BASE_TYPE_START = 3
KTM960X_VAL_OUTPUT_BASE_TYPE_STOP = 4

# - Defined values for
# attribute KTM960X_ATTR_OUTPUT_CURRENT_POST_TYPE
# attribute KTM960X_ATTR_OUTPUT_VOLTAGE_POST_TYPE

KTM960X_VAL_OUTPUT_POST_TYPE_TRIGGERED = 0
KTM960X_VAL_OUTPUT_POST_TYPE_START = 1
KTM960X_VAL_OUTPUT_POST_TYPE_STOP = 2
KTM960X_VAL_OUTPUT_POST_TYPE_BASE = 3
KTM960X_VAL_OUTPUT_POST_TYPE_MANUAL = 4
KTM960X_VAL_OUTPUT_POST_TYPE_IMMEDIATE = 5

# - Defined values for
# attribute KTM960X_ATTR_OUTPUT_OFF_CONDITION

KTM960X_VAL_OFF_CONDITION_ZERO = 0
KTM960X_VAL_OFF_CONDITION_HIZ = 1
KTM960X_VAL_OFF_CONDITION_NORMAL = 2

# - Defined values for
# 	attribute KTM960X_ATTR_OUTPUT_PRIORITY_MODE

KTM960X_VAL_PRIORITY_MODE_VOLTAGE = 0
KTM960X_VAL_PRIORITY_MODE_CURRENT = 1

# - Defined values for
# 	attribute KTM960X_ATTR_OUTPUT_SHAPE

KTM960X_VAL_SHAPE_MODE_DC = 0
KTM960X_VAL_SHAPE_MODE_PULSE = 1

# - Defined values for
# 	attribute KTM960X_ATTR_TRANSIENT_CURRENT_MODE
# 	attribute KTM960X_ATTR_TRANSIENT_VOLTAGE_MODE

KTM960X_VAL_OUTPUT_MODE_FIXED = 0
KTM960X_VAL_OUTPUT_MODE_LIST = 1
KTM960X_VAL_OUTPUT_MODE_SWEEP = 2

# - Defined values for
# 	attribute KTM960X_ATTR_TRANSIENT_SWEEP_MODE

KTM960X_VAL_SWEEP_MODE_SINGLE = 0
KTM960X_VAL_SWEEP_MODE_DOUBLE = 1

# - Defined values for
# 	attribute KTM960X_ATTR_TRANSIENT_SWEEP_OUTPUT_RANGING_MODE

KTM960X_VAL_OUTPUT_RANGING_MODE_BEST = 0
KTM960X_VAL_OUTPUT_RANGING_MODE_FIXED = 2

# - Defined values for
# 	attribute KTM960X_ATTR_TRANSIENT_SWEEP_OUTPUT_SCALE

KTM960X_VAL_OUTPUT_SCALE_LINEAR = 0

# - Defined values for
# 	attribute KTM960X_ATTR_TRANSIENT_SWEEP_DIRECTION
#
KTM960X_VAL_SWEEP_DIRECTION_UP = 0
KTM960X_VAL_SWEEP_DIRECTION_DOWN = 1

# - Defined values for
# 	attribute KTM960X_ATTR_OUTPUT_OPERATION_MODE
KTM960X_VAL_OUTPUT_OPERATION_MODE_STANDARD = 0
KTM960X_VAL_OUTPUT_OPERATION_MODE_POWER_SUPPLY = 1

# - Defined values for
# 	attribute KTM960X_ATTR_MEASUREMENT_ACQUISITION_MODE

KTM960X_VAL_ACQUISITION_MODE_NORMAL = 0
KTM960X_VAL_ACQUISITION_MODE_SAMPLING = 1

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_IO_EXTERNAL_EDGE_POSITION
# 	attribute KTM960X_ATTR_MODULE_IO_PXIE_EDGE_POSITION

KTM960X_VAL_IO_EDGE_POSITION_BEFORE = 0
KTM960X_VAL_IO_EDGE_POSITION_AFTER = 1
KTM960X_VAL_IO_EDGE_POSITION_BOTH = 2

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_IO_EXTERNAL_FUNCTION
# 	attribute KTM960X_ATTR_MODULE_IO_PXIE_FUNCTION

KTM960X_VAL_IO_FUNCTION_TRIGGER_OUTPUT = 0
KTM960X_VAL_IO_FUNCTION_TRIGGER_INPUT = 1
KTM960X_VAL_IO_FUNCTION_DIGITAL_OUTPUT = 2

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_IO_EXTERNAL_LEVEL
# 	attribute KTM960X_ATTR_MODULE_IO_PXIE_LEVEL
# 	parameter Val in function KtM960x_ModuleIOExternalRead
# 	parameter Val in function KtM960x_ModuleIOPxieRead

KTM960X_VAL_IO_LEVEL_HIGH = 0
KTM960X_VAL_IO_LEVEL_LOW = 1

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_IO_EXTERNAL_POLARITY
# 	attribute KTM960X_ATTR_MODULE_IO_PXIE_POLARITY

KTM960X_VAL_IO_POLARITY_POSITIVE = 0
KTM960X_VAL_IO_POLARITY_NEGATIVE = 1

# - Defined values for
# 	attribute KTM960X_ATTR_MODULE_IO_EXTERNAL_TYPE
# 	attribute KTM960X_ATTR_MODULE_IO_PXIE_TYPE

KTM960X_VAL_IO_TYPE_EDGE = 0
KTM960X_VAL_IO_TYPE_LEVEL = 1

# - Defined values for
# 	attribute KTM960X_ATTR_SYSTEM_GROUP_SYNC_TRIGGER_LINE

KTM960X_VAL_SYNC_TRIGGER_LINE_PXI0 = 0
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI1 = 1
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI2 = 2
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI3 = 3
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI4 = 4
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI5 = 5
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI6 = 6
KTM960X_VAL_SYNC_TRIGGER_LINE_PXI7 = 7
KTM960X_VAL_SYNC_TRIGGER_LINE_EXTERNAL1 = 8
KTM960X_VAL_SYNC_TRIGGER_LINE_EXTERNAL2 = 9


# ***************************************************************************
# *---------------- Instrument Driver Function Declarations -----------------*
# ***************************************************************************

# ***************************************************************************
# *----------------- Instrument Error And Completion Codes ------------------*
# ***************************************************************************


IVIC_WARN_BASE = 0x3FFA0000
IVIC_CROSS_CLASS_WARN_BASE = IVIC_WARN_BASE + 0x1000
IVIC_CLASS_WARN_BASE = IVIC_WARN_BASE + 0x2000
IVIC_SPECIFIC_WARN_BASE = IVIC_WARN_BASE + 0x4000

IVIC_ERROR_BASE = 0xBFFA0000
IVIC_CROSS_CLASS_ERROR_BASE = IVIC_ERROR_BASE + 0x1000
IVIC_CLASS_ERROR_BASE = IVIC_ERROR_BASE + 0x2000
IVIC_SPECIFIC_ERROR_BASE = IVIC_ERROR_BASE + 0x4000
IVIC_LXISYNC_ERROR_BASE = IVIC_ERROR_BASE + 0x2000

KTM960X_ERROR_CANNOT_RECOVER = IVIC_ERROR_BASE + 0x0000
KTM960X_ERROR_INSTRUMENT_STATUS = IVIC_ERROR_BASE + 0x0001
KTM960X_ERROR_CANNOT_OPEN_FILE = IVIC_ERROR_BASE + 0x0002
KTM960X_ERROR_READING_FILE = IVIC_ERROR_BASE + 0x0003
KTM960X_ERROR_WRITING_FILE = IVIC_ERROR_BASE + 0x0004
KTM960X_ERROR_INVALID_PATHNAME = IVIC_ERROR_BASE + 0x000B
KTM960X_ERROR_INVALID_ATTRIBUTE = IVIC_ERROR_BASE + 0x000C
KTM960X_ERROR_IVI_ATTR_NOT_WRITABLE = IVIC_ERROR_BASE + 0x000D
KTM960X_ERROR_IVI_ATTR_NOT_READABLE = IVIC_ERROR_BASE + 0x000E
KTM960X_ERROR_INVALID_VALUE = IVIC_ERROR_BASE + 0x0010
KTM960X_ERROR_FUNCTION_NOT_SUPPORTED = IVIC_ERROR_BASE + 0x0011
KTM960X_ERROR_ATTRIBUTE_NOT_SUPPORTED = IVIC_ERROR_BASE + 0x0012
KTM960X_ERROR_VALUE_NOT_SUPPORTED = IVIC_ERROR_BASE + 0x0013
KTM960X_ERROR_TYPES_DO_NOT_MATCH = IVIC_ERROR_BASE + 0x0015
KTM960X_ERROR_NOT_INITIALIZED = IVIC_ERROR_BASE + 0x001D
KTM960X_ERROR_UNKNOWN_CHANNEL_NAME = IVIC_ERROR_BASE + 0x0020
KTM960X_ERROR_TOO_MANY_OPEN_FILES = IVIC_ERROR_BASE + 0x0023
KTM960X_ERROR_CHANNEL_NAME_REQUIRED = IVIC_ERROR_BASE + 0x0044
KTM960X_ERROR_MISSING_OPTION_NAME = IVIC_ERROR_BASE + 0x0049
KTM960X_ERROR_MISSING_OPTION_VALUE = IVIC_ERROR_BASE + 0x004A
KTM960X_ERROR_BAD_OPTION_NAME = IVIC_ERROR_BASE + 0x004B
KTM960X_ERROR_BAD_OPTION_VALUE = IVIC_ERROR_BASE + 0x004C
KTM960X_ERROR_OUT_OF_MEMORY = IVIC_ERROR_BASE + 0x0056
KTM960X_ERROR_OPERATION_PENDING = IVIC_ERROR_BASE + 0x0057
KTM960X_ERROR_NULL_POINTER = IVIC_ERROR_BASE + 0x0058
KTM960X_ERROR_UNEXPECTED_RESPONSE = IVIC_ERROR_BASE + 0x0059
KTM960X_ERROR_FILE_NOT_FOUND = IVIC_ERROR_BASE + 0x005B
KTM960X_ERROR_INVALID_FILE_FORMAT = IVIC_ERROR_BASE + 0x005C
KTM960X_ERROR_STATUS_NOT_AVAILABLE = IVIC_ERROR_BASE + 0x005D
KTM960X_ERROR_ID_QUERY_FAILED = IVIC_ERROR_BASE + 0x005E
KTM960X_ERROR_RESET_FAILED = IVIC_ERROR_BASE + 0x005F
KTM960X_ERROR_RESOURCE_UNKNOWN = IVIC_ERROR_BASE + 0x0060
KTM960X_ERROR_ALREADY_INITIALIZED = IVIC_ERROR_BASE + 0x0061
KTM960X_ERROR_CANNOT_CHANGE_SIMULATION_STATE = IVIC_ERROR_BASE + 0x0062
KTM960X_ERROR_INVALID_NUMBER_OF_LEVELS_IN_SELECTOR = IVIC_ERROR_BASE + 0x0063
KTM960X_ERROR_INVALID_RANGE_IN_SELECTOR = IVIC_ERROR_BASE + 0x0064
KTM960X_ERROR_UNKOWN_NAME_IN_SELECTOR = IVIC_ERROR_BASE + 0x0065
KTM960X_ERROR_BADLY_FORMED_SELECTOR = IVIC_ERROR_BASE + 0x0066
KTM960X_ERROR_UNKNOWN_PHYSICAL_IDENTIFIER = IVIC_ERROR_BASE + 0x0067
KTM960X_ERROR_INVALID_SESSION_HANDLE = IVIC_ERROR_BASE + 0x1190


KTM960X_SUCCESS = 0
KTM960X_WARN_NSUP_ID_QUERY = IVIC_WARN_BASE + 0x0065
KTM960X_WARN_NSUP_RESET = IVIC_WARN_BASE + 0x0066
KTM960X_WARN_NSUP_SELF_TEST = IVIC_WARN_BASE + 0x0067
KTM960X_WARN_NSUP_ERROR_QUERY = IVIC_WARN_BASE + 0x0068
KTM960X_WARN_NSUP_REV_QUERY = IVIC_WARN_BASE + 0x0069


KTM960X_ERROR_IO_GENERAL = IVIC_SPECIFIC_ERROR_BASE + 0x0214
KTM960X_ERROR_IO_TIMEOUT = IVIC_SPECIFIC_ERROR_BASE + 0x0215
KTM960X_ERROR_CALIBRATION_VERSION = IVIC_SPECIFIC_ERROR_BASE + 0x0217
KTM960X_ERROR_CHECK_ERROR_QUEUE = IVIC_SPECIFIC_ERROR_BASE + 0x0218
KTM960X_ERROR_FILE_TYPE_NOT_RECOGNIZED = IVIC_SPECIFIC_ERROR_BASE + 0x0219
KTM960X_ERROR_FIRMWARE_UPDATE_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x021A
KTM960X_ERROR_FIRMWARE_UPDATE_REQUIRED = IVIC_SPECIFIC_ERROR_BASE + 0x021B
KTM960X_ERROR_FPGA_PROGRAMMING_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x021C
KTM960X_ERROR_HARDWARE_TIMEOUT = IVIC_SPECIFIC_ERROR_BASE + 0x021D
KTM960X_ERROR_HW_RESOURCE_NOT_AVAILABLE = IVIC_SPECIFIC_ERROR_BASE + 0x021E
KTM960X_ERROR_INCOMPATIBLE_SOFTWARE_VERSION_ERROR = \
    IVIC_SPECIFIC_ERROR_BASE + 0x021F
KTM960X_ERROR_INSTRUMENT_CALIBRATION_DUE = \
    IVIC_SPECIFIC_ERROR_BASE + 0x0220
KTM960X_ERROR_INSTRUMENT_CALIBRATION_EXPIRED = \
    IVIC_SPECIFIC_ERROR_BASE + 0x0221
KTM960X_ERROR_INSTRUMENT_NOT_CALIBRATED = IVIC_SPECIFIC_ERROR_BASE + 0x0222
KTM960X_ERROR_INTERNAL_APPLICATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x0223
KTM960X_ERROR_LICENSE_SYSTEM_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x0224
KTM960X_ERROR_LICENSE_VALIDATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x0225
KTM960X_ERROR_MAX_TIME_EXCEEDED = IVIC_SPECIFIC_ERROR_BASE + 0x0226
KTM960X_ERROR_MISSING_CLOCK_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x0227
KTM960X_ERROR_MODEL_NOT_SUPPORTED = IVIC_SPECIFIC_ERROR_BASE + 0x0228
KTM960X_ERROR_MODULE_CALIBRATION_DUE = IVIC_SPECIFIC_ERROR_BASE + 0x0229
KTM960X_ERROR_MODULE_CALIBRATION_EXPIRED = IVIC_SPECIFIC_ERROR_BASE + 0x022A
KTM960X_ERROR_MODULE_NOT_CALIBRATED = IVIC_SPECIFIC_ERROR_BASE + 0x022B
KTM960X_ERROR_MODULE_VALIDATE_FAILED = IVIC_SPECIFIC_ERROR_BASE + 0x022C
KTM960X_ERROR_OPERATION_ABORTED = IVIC_SPECIFIC_ERROR_BASE + 0x022D
KTM960X_ERROR_OPERATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x022E
KTM960X_ERROR_OUT_OF_MEMORY_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x022F
KTM960X_ERROR_PARAMETER_VALIDATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x0230
KTM960X_ERROR_PERSONALITY_NOT_ACTIVE = IVIC_SPECIFIC_ERROR_BASE + 0x0231
KTM960X_ERROR_PERSONALITY_NOT_INSTALLED = IVIC_SPECIFIC_ERROR_BASE + 0x0232
KTM960X_ERROR_PERSONALITY_NOT_LICENSED = IVIC_SPECIFIC_ERROR_BASE + 0x0233
KTM960X_ERROR_SELFTEST_FAILED = IVIC_SPECIFIC_ERROR_BASE + 0x0234
KTM960X_ERROR_SOFTWARE_TIMEOUT = IVIC_SPECIFIC_ERROR_BASE + 0x0235
KTM960X_ERROR_TEST_FAILED_INCORRECT_VERSION = IVIC_SPECIFIC_ERROR_BASE + 0x0236
KTM960X_ERROR_THERMAL_SHUTDOWN = IVIC_SPECIFIC_ERROR_BASE + 0x0237
KTM960X_ERROR_THERMAL_WARNING = IVIC_SPECIFIC_ERROR_BASE + 0x0238
KTM960X_ERROR_UNABLE_TO_INITIALIZE_HARDWARE = IVIC_SPECIFIC_ERROR_BASE + 0x0239
KTM960X_ERROR_UNRECOGNIZED_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x023A
KTM960X_ERROR_UNSUPPORTED_FEATURE = IVIC_SPECIFIC_ERROR_BASE + 0x023B
KTM960X_ERROR_UNSUPPORTED_PROPERTY = IVIC_SPECIFIC_ERROR_BASE + 0x023C
KTM960X_ERROR_VALIDATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x023D
KTM960X_ERROR_VERIFY_OPERATION_ERROR = IVIC_SPECIFIC_ERROR_BASE + 0x023E
KTM960X_ERROR_WAIT_ABORTED = IVIC_SPECIFIC_ERROR_BASE + 0x023F
KTM960X_ERROR_NOT_IMPLEMENTED = IVIC_SPECIFIC_ERROR_BASE + 0x0240
