# Changelog

- 2024-08-22 2.2.0
    - cutting release for ENLIGHTEN 4.1.0
- 2024-06-27 2.1.73
    - update demo.py to support multiple spectrometers
    - add optional `callback` parameter to WrapperWorker for Inversion of Control (IoC)
- 2024-06-27 2.1.72
    - temporarily disable GET_LASER_ENABLED on XS
- 2024-06-19 2.1.71
    - disable applog to stdout if stdout missing
- 2024-06-12 2.1.70
    - force laser to disable on perc/PWM zero
- 2024-05-30 2.1.69
    - added avg_resolution to edittable EEPROM fields
- 2024-05-24 2.1.68
    - added horizontal ROI to XL virtual EEPROM
    - Raspberry Pi testing (no change)
- 2024-05-22 2.1.67
    - relax thread logging 10sec after successful connection
    - display connected spectrometer properties in demo.py
- 2024-05-07 2.1.66
    - gave TakeOneRequest a copy-ctor
- 2024-05-02 2.1.65
    - updated README links to work on pypi servers
- 2024-05-02 2.1.64
    - added wasatch.FirmwareRequirements
    - added wasatch.PollStatus
    - added FID.get_poll_status() and .is_sensor_stable()
    - added util.vercmp()
    - added microcontroller serial number
- 2024-03-23 2.1.63
    - CSVLoader 
        - store x-axes in ProcessedReading rather than metadata
        - support "intensity" header
        - simplified
- 2024-03-22 2.1.62
    - ignore 3 consecutive USB errors when reading spectra (R&D)
    - ignore None responses in WasatchDevice func/attr calls
    - skip ambient temperature readout on ARM 1.0.2.9
- 2024-03-19 2.1.61
    - handle either 3-byte or 2-byte FPGA_COMPILATION_OPTIONS response
- 2024-03-18 2.1.60
    - added get_ambient_temperature_degC_arm
- 2024-03-15 2.1.59
    - changed XS get_detector_gain to big-endian
    - added clarity around XS laser_tec_mode -vs- enabled
- 2024-03-15 2.1.58
    - added set/get_laser_tec_mode
    - sanity-check XS laser TEC setpoint to 700-900 range
- 2024-03-14 2.1.57
    - added laser temperature calibration for XS
    - added EDC for XS
    - clarified FPGAOptions as 24-bit (but ignore for XS)
- 2024-03-13 2.1.56
    - double-check to prevent div-by-zero in InGaAs gain correction
    - decline to parse FPGAOptions for ARM (leave at initialized values)
- 2024-03-13 2.1.55
    - don't use FPGAOptions on ARM
    - return "Sensor Stabilizing" message on ARM when intTime/gain changes
- 2024-03-07 2.1.54
    - return "sensor stabilizing" message
- 2024-02-28 2.1.53
    - enriched ProcessedReading.dump 
- 2024-02-28 2.1.52
    - fixed ProcessedReading bug
- 2024-02-27 2.1.51
    - added ProcessedReading.get_pixel_axis
- 2024-02-20 2.1.50
    - fixed AndorDevice temperature
- 2024-02-19 2.1.49
    - return state.laser_enabled from FID.get_laser_enabled on SiG until FW fixed
- 2024-02-14 2.1.48
    - ProcessedReading: force to np.array on load_from_dict, clear .interpolated on set_processed
- 2024-02-07 2.1.47
    - ProcessedReading always takes wavelengths/wavenumbers from settings if empty and available
- 2024-02-06 2.1.46
    - removed enlighten.SaveOptions(?) from wasatch.CSVLoader(?!?)
    - made ProcessedReading smarter about loading wavelengths/wavenumbers from SpectrometerSettings
- 2024-02-05 2.1.45
    - clarified scan averaging a bit
    - added TakeOneRequest.scans_to_average
- 2024-01-30 2.1.44
    - Auto-Raman fix: store laser-related attributes in Reading before auto-disabling laser
    - notation updates
- 2024-01-26 2.1.43
    - utils bugfix
- 2024-01-25 2.1.42
    - TakeOneRequest.take_dark + .enable_laser_before now implies laser disable + 1sec delay
- 2024-01-23 2.1.41
    - moved to TakeOneRequest
    - deprecated acquisition_laser_trigger_enable, self.acquisition_take_dark_enable and acquisition_laser_trigger_delay_ms
- 2024-01-15 2.1.40
    - better UTF-8 support
    - support cropped/interpolated ProcessedReading in dict conversions
- 2024-01-11 2.1.39
    - refactored ProcessedReading with new .cropped and .interpolated nodes
    - fixed small PWM bug
- 2023-12-18 2.1.38
    - fixed iterable bug in ProcessedReading dict ctor
- 2023-12-14 2.1.37
    - ProcessedReading tweak
- 2023-12-07 2.1.36
    - add throwaways around IMX sensor commands
    - treat flat IMX spectra as keepalives
- 2023-11-01 2.1.35
    - auto-generate raman_intensity_calibration_order in AndorDevice virtual EEPROM if missing
    - added ProcessedReading.to_dict()
- 2023-09-20 2.1.34
    - added applog(append)
- 2023-09-20 2.1.33
    - enforce FPGA version number length
    - log USB results in hex
    - check for "bad data" in EEPROM
    - XS-Series
        - added set_laser_power_attenuator
        - added support for startup laser TEC setpoint
        - read battery @ 0.2Hz
- 2023-07-10 2.1.32
    - offset gettors now return SpectrometerResponse 
    - fixed display of gettors returning SpectrometerResponse in WasatchShell 
- 2023-07-04 2.1.31
    - clarify methods returning bool vs SpectrometerResponse
    - remove return type annotations
    - s/vignette/crop/
- 2023-06-13 2.1.30
    - invert x-axis for 1064XL
    - don't enable TEC with default / invalid TEC calibration
    - restore ability for CSVLoader.parse_metadata to support single-measurement
      CSVs where metadata fields are expected to be scalars rather than lists
- 2023-05-10 2.1.29
    - support for 1064XL
- 2023-05-03 2.1.28
    - better handling of rare null-buffer EEPROM readout
- 2023-01-13 2.1.27
    - is_andor fix
    - laser watchdog fix (disable on older EEPROMs)
- 2022-12-14 2.1.26
    - default InGaAs detectors to high-gain mode
    - forget disconnected USB devices
- 2022-12-13 2.1.25
    - disable laserEnable verification loop for Series-XS
- 2022-12-07 2.1.24
    - update EEPROM to Rev15
    - default laser power calibration to high-resolution
- 2022-10-26 2.1.23
    - fix connect bug
    - added scripts/dark-vs-integ.py
- 2022-10-17 2.1.22
    - updates to MockUSBDevice to support ENLIGHTEN regression tests
- 2022-10-12 2.1.21
    - add is_sml and is_mml functions
    - fix floating-point array index lookup
- 2022-10-11 2.1.20
    - added demo-virtual and readme for virtual spectrometers
- 2022-09-19 2.1.19
    - track reset tries within WasatchDeviceWrapper
    - stop sending bools upstream from WasatchDeviceWrapper.acquire_data
- 2022-09-19 2.1.18
    - added WasatchDevice.reset()
    - added utils.check_admin()
- 2022-08-31 2.1.17
    - fix name error in external trigger control flow
    - Add pyusb reset for disconnect on error robustness
- 2022-08-16 2.1.16
    - Restructure DeviceID to no longer carry other classes
    - Move control logic for BLE from ENLIGHTEN to here
    - Change Mock spec creation so that it can be done by info in DeviceID
- 2022-08-04 2.1.15
    - fixed bug affecting spectra loaded from file and thus missing SpectrometerSettings.hardware_info
- 2022-07-28 2.1.14
    - change all Device.connect() methods to return SpectrometerResponse so 
      caller can display appropriate error message
- 2022-07-21 2.1.13
    - SPIDevice upgrades
    - deprecated laser power ramping
    - ignore laser PWM return codes
    - Andor fixes
- 2022-07-11 2.1.12
    - added get_dark and set_raman_intensity_correction_enable in WasatchShell
- 2022-06-23 2.1.11
    - remove := to allow more backwards compatibility
- 2022-06-13 2.1.10
    - add high gain mode for andor
- 2022-06-10 2.1.9
    - add check to prevent vertical binning for legacy sig vis
- 2022-06-06 2.1.8
    - support encoding in CSVLoader
    - fix Andor fan control
- 2022-05-11 2.1.7
    - populate laser attributes on Readings
    - fixed bug in can_laser_fire
- 2022-04-28 2.1.6
    - Resolve SPI eeprom read and write issues
- 2022-04-27 2.1.5
    - Andor updates
        - added error codes
        - support "detector" override from .json
        - increase shutter time per Newton testing
    - fixed WrapperWorker bug
- 2022-04-22 2.1.4
    - Andor updates
        - search for DLL in various locations
        - support startup_integration_time_ms and startup_temp_degC in JSON 
        - default startup_temp_degC to -60C if not specified in JSON
        - added DeviceID.is_andor()
        - populate SpectrometerState.shutter_enable
    - respect array length in EEPROM.generate_write_buffers 
- 2022-04-21 2.1.3
    - fix break in BLE functions
    - refactor wrapper worker to not use if, elif, elif ... for each device type
- 2022-04-19 2.1.2
    - added NaN check to has_linearity_coeffs (and made public)
- 2022-04-19 2.1.1
    - restored automatic laser disable at connect
    - restored automatic TEC enable at connect
    - added demo-workflow.py
    - added 'make pip-install-local'
    - Setup SPI device
- 2022-04-06 2.1.0
    - Setup interface devices in new architecture
- 2022-03-21 2.0.3
    - renamed has_laser_tec to sig_laser_tec
    - added has_interlock_feedback
- 2022-03-17 2.0.2
    - explicitly prefer libusb0 backend (needed for 64-bit)
    - fixed potential EEPROM logging bug
- 2022-01-28 2.0.1
    - fixed logging bug
- 2022-01-18 2.0.0
    - add support for Andor Spectrometers
- 2021-12-13 1.1.37
    - dropped FeatureMask support from EEPROM format 9 (only support on format 10+)
- 2021-10-28 1.1.36
    - added FID.can_laser_fire() and is_laser_firing() (and corresponding Reading flags)
    - grouped laser commands in FID
    - switched some FID getters from returning 1/0 to True/False
- 2021-10-18 1.1.35
    - added OceanDevice.py
    - Changed DeviceFinderUSB.py to use usb.core
- 2021-10-13 1.1.34
    - added get_fpga_configuration_register
    - trap for 0ms integration time
- 2021-09-21 1.1.33
    - added DetectorROI.enabled
    - added SpectrometerSettings.init_regions
    - added FID.clear_regions, set_single_region
    - fixed bin2x2 bug
    - added SpectrometerState.ignore_timeouts_for
- 2021-09-20 1.1.32
    - many ROI updates
- 2021-09-16 1.1.31
    - DetectorRegions working from ENLIGHTEN
- 2021-09-16 1.1.30
    - don't try to configure/claim interface on Windows
- 2021-09-13 1.1.29
    - fixed untethered uint16s
- 2021-09-01 1.1.28
    - replaced set_pixel_depth with set_pixel_mode
    - updated opcodes for set_pixel_mode and set_detector_roi
    - removed FileSpectrometer
    - removed Overrides
    - removed FileBus
- 2021-08-31 1.1.27
    - added DetectorRegions
    - added DetectorROI
    - added set_detector_roi
    - added set_pixel_depth
- 2021-08-20 1.1.26
    - untethered
- 2021-08-12 1.1.25
    - extracted WrapperWorker
    - docs
- 2021-08-12 1.1.24
    - many changes to area scan
- 2021-08-11 1.1.23
    - get_detector_gain\* only updates session eeprom if update_session_eeprom=True
- 2021-08-04 1.1.22
    - auto-apply startup_integration_time_ms on connect
- 2021-07-28 1.1.21
    - added utils.to_bool
- 2021-07-20 1.1.20
    - fixed setting gain to 0.99999999
- 2021-07-15 1.1.19
    - InGaAs fix
- 2021-07-15 1.1.18
    - merged customer fix
    - removed rounding from even-odd correction
- 2021-07-15 1.1.17
    - more consistent rounding / casting to ints
    - removed heartbeat logs
    - removed EEPROM serial number validation on write
    - docs
- 2021-07-14 1.1.16
    - debugs
- 2021-07-14 1.1.15
    - added hardwareEvenOdd
- 2021-07-14 1.1.14
    - moved float_to_uint16 to EEPROM
    - bumped EEPROM.format to 12
- 2021-07-14 1.1.13
    - made FID.py return values more consistent
    - added utils.float_to_uint16
- 2021-07-06 1.1.12
    - removed regex from SpectrometerSettings.full_model
- 2021-06-21 1.1.11
    - store retrieved detector_offset to cached EEPROM after read from FPGA
    - updated gettors in WasatchShell
- 2021-06-21 1.1.10
    - fixed "detctor" typos in FID gettors
- 2021-06-18 1.1.9
    - cache battery percentage
- 2021-05-25 1.1.8
    - updates for cross-platform logging
- 2021-05-25 1.1.7
    - changed SpectrometerState.laser_power_in_mW to use_mW
    - changed SpectrometerState.laser_power to laser_power_perc and _mW
    - changed Reading          .laser_power to laser_power_perc and _mW
    - removed bare_readings
- 2021-05-24 1.1.6
    - fixed laser_power_in_mW bug
- 2021-05-19 1.1.5
    - demo version logging
    - log SRM coefficients on math exception
- 2021-05-14 1.1.4
    - added ROI
- 2021-04-28 1.1.3
    - fixed poison-pill bug on IMX
- 2021-04-15 1.1.2
    - fixed settings.is_arm bug
- 2021-04-14 1.1.1
    - downleveled some error messages
    - clarified state.gain_db vs eeprom.detector_gain
    - enforced that is_sig implies is_arm
    - log format tweak
- 2021-04-09 1.1.0
    - changing WasatchDeviceWrapper from multiprocess to multithreaded
- 2021-04-05 1.0.73
    - fixed get_ambient_temperature_degC
    - renamed get_ccd_trigger_source -> get_trigger_source
    - renamed get_mod_duration -> get_mod_duration_us
    - renamed get_mod_period -> get_mod_period_us
    - renamed get_mod_width -> get_mod_width_us
    - renamed get_mod_pulse_delay -> get_mod_delay_us
    - renamed set_cont_strobe_enable -> set_strobe_enable (just simplified set_laser_enable)
- 2021-03-30 1.0.72
    - added EEPROM.update_digest()
- 2021-03-30 1.0.71
    - update state.gain_db during get_detector_gain
- 2021-03-30 1.0.70
    - prevent vertical binning start/stop lines from matching (stop must be > start)
- 2021-03-25 1.0.69
    - restored even/odd InGaAs gain/offset correction
- 2021-03-23 1.0.68
    - added macOS to Darwin exclusion in applog.py
- 2021-03-18 1.0.67
    - fixed InGaAs bug on get_high_gain_mode_enabled
- 2021-03-15 1.0.66
    - added FeatureMask.cutoff_filter_installed
    - added EEPROM.laser_warmup_sec
    - added Gen 1.5 to WasatchShell
    - made Fast Area Scan the default
- 2021-02-24 1.0.65
    - docs
    - accessory connector 
        - added get/set_fan_enable
        - added get/set_lamp_enable
        - added FeatureMask.gen15
- 2021-02-02 1.0.64
    - consolidated spectrometer feature queries into SpectrometerSettings
    - added support for "fast" area scan
    - added support for raman_correction
    - fixed invert_x_axis bug
    - accessory connector (initial ICD, testing pending FW)
        - SpectrometerState
            - shutter_enabled
            - cont_strobe_enabled
            - cont_strobe_width_us
            - cont_strobe_period_us
        - FeatureIdentificationDevice (and WasatchShell)
            - set_shutter_enable
            - get_shutter_enable
            - set_cont_strobe_enable
            - get_cont_strobe_enable
            - set_cont_strobe_period_us
            - get_cont_strobe_period_us
            - set_cont_strobe_width_us
            - get_cont_strobe_width_us
            - get_ambient_temperature_degC
- 2021-01-05 1.0.63
    - added get_high_gain_mode_enable()
    - added G9206 and G14237 to InGaAs detection
    - made InGaAs detection more robust
    - added parabolic approximation
- 2020-11-20 1.0.62
    - added docs about Unicode logger warnings
- 2020-11-12 1.0.61
    - added demo.py --version, stdev, debug output
- 2020-??-?? 1.0.60
    - added invertXAxis, bin2x2 to EEPROM.dump
- 2020-08-06 1.0.59
    - removed SiG Area Scan "stomp first 125px" kludge
- 2020-08-04 1.0.58
    - reduced area scan "prefix overwrite" for non-IMX detectors
- 2020-07-28 1.0.57
    - deprecated get_raman_mode from WasatchShell
    - simplified retry logic
    - simplified set_high_gain_mode
    - increased laser watchdog on micro
    - drafted get/set_analog_state/value
    - disabled I2C overrides
- 2020-06-24 1.0.56
    - removed SW implementation of odd gain/offset
    - added get_line profiling
    - automatically update laser watchdog timeout on ramanMicro
    - deprecated HW laserDelay and ramanMode on ramanMicro
    - added throwaways in TakeOne for ramanMicro
    - added SpectrometerState.gainDb for ramanMicro
- 2020-06-11 1.0.55
    - moved settings to lambdas
    - added vertical ROI
    - clamp offset
    - move area scan from 0xe9 to 0xeb
    - support 2048px ARM
    - moved bad pixel correction into get_line
    - added Reading.__str__
- 2020-05-15 1.0.54
    - added EEPROM.feature_mask
    - added FeatureMask.invert_x_axis
    - added FeatureMask.bin2x2
    - bumped EEPROM to rev 9
    - support start-of-frame markers
    - schedule_disconnect on DFU mode
    - added Raman Mode, Raman Delay, Laser Watchdog
- 2020-04-26 1.0.53
    - added raman_mode_enable
    - support subformat 0
    - better handling of 5th wavecal coeff
    - extend timeouts for SiG sensor waking
    - allow external triggering on FX2
    - added SpectrometerSettings.full_model()
    - added SpectrometerSettings.is_sig()
- 2020-03-27 1.0.52
    - increased timeout for multiple devices
    - added gain/offset initialization from EEPROM
    - zero NaN wavecal coeffs
- 2020-03-25 1.0.51
    - increased timeout for multiple devices
    - added EEPROM.avg_resolution
- 2020-03-23 1.0.50
    - added SpectrometerState.acquisition_take_dark_enable
    - moved 5th wavecal coeff to EEPROM rev 8
    - added retries on read of spectral bulk endpoint
    - stubbing retry logic for FID.send_code 
    - fixed some bugs from moving coeffs_look_valid to utils
- 2020-02-28 1.0.49
    - EEPROM fix
- 2020-02-27 1.0.48
    - refactored spline
    - updated laser ramping docs
    - added connection state checks
    - updated raman intensity calibration definition
    - added DFU docs
- 2020-01-15 1.0.47
    - added demo-simple.py
- 2020-01-10 1.0.46
    - updated EEPROM to format 7
- 2019-10-11 1.0.45
    - added Raman Intensity calibration
    - added get_battery_register
    - added SpectrometerSettings.lock_wavecal, has_excitation()
    - added utils.generate_wavelengths_from_wavenumbers
    - added utils.generate_excitation
    - removed unused response_queue
    - Doxygen
- 2019-10-08 1.0.44
    - raman intensity calibration fixes
- 2019-10-08 1.0.43
    - added raman intensity calibration
    - added README_SETTINGS.md
- 2019-09-30 1.0.42
    - added timout to applog listener
    - fixed horizontal ROI limits
    - added take_one, cancel_take_one, reset_scan_averaging
    - added README_CHANGELOG.md
- 2019-09-19 1.0.41
    - added various to_dict() methods to better-support JSON serialization
- 2019-09-16 1.0.40
    - WasatchShell updates
    - fixed demo.py with --max and --scans-to-average
- 2019-09-16 1.0.39
    - added EEPROM.get_horizontal_roi()
- 2019-08-20 1.0.38
    - WasatchShell updates
    - added laser_power_require_modulation
- 2019-07-30 1.0.37
    - added laser_power_high_resolution
    - stopped sending FX2 fake buffers on laser pulse width/period
- 2019-07-16 1.0.36
    - added allow_nan to EEPROM.json()
- 2019-07-16 1.0.35
    - added --eod to WasatchShell 
- 2019-06-17 1.0.34
    - round negatives to zero when writing unsigned EEPROM fields
- 2019-06-05 1.0.33
    - made write_eeprom 2nd-tier on ARM, legacy offset on FX2
- 2019-06-05 1.0.32
    - disable "fake buffer length from value" on ARM
- 2019-05-31 1.0.31
    - updated scripts/deploy
    - still working on reading.laser_enabled
- 2019-05-31 1.0.30
    - moved write_eeprom to 2nd-tier command
- 2019-05-29 1.0.29
    - enable Area Scan for IMX detectors
    - added EEPROM.product_configuration
    - changed min/max_integration_time_ms to 32-bit
- 2019-05-15 1.0.28
    - fixed DeviceFinderUSB bug in Linux
- 2019-05-13 1.0.27
    - fallback bus/addr implementation
- 2019-05-10 1.0.26
    - README-RPI.md
    - added conda-rpi.yml
    - cleanup Queue references in exception cases
    - added DeviceID.__repr__()
- 2019-04-30 1.0.25
    - made linearity_coeffs, laser_power_coeffs and min/max_laser_power_mW customer-editable
- 2019-04-29 1.0.24
    - support for area scan on FX2
- 2019-04-25 1.0.23
    - fixed utils.truthy() (Py3)
- 2019-04-24 1.0.22
    - added max_tries and max_integration_time_ms to balance_acquisition
    - WasatchShell updates
    - logging fixes for ENLIGHTEN under Windows
- 2019-04-18 1.0.21
    - added get_detector_tec_setpoint_degC
    - added get_detector_tec_setpoint_raw
    - added get_selected_laser
- 2019-04-15 1.0.20
    - merging Pipes and Py3
- 2019-04-15 1.0.19
    - moved multiprocessing.Queue to .Pipe
- 2019-04-11 py3-1.1.0
    - initial Python 3 version (works on Linux)
- 2019-04-10 1.0.18
    - fixed for Windows (reverted multiprocessing.Manager to multiprocessing)
- 2019-04-10 1.0.17
    - memory profiling
    - removed Zynq delay
- 2019-04-05 1.0.16
    - made allow_default_gain_reset default
- 2019-04-04 1.0.15
    - added swap_alternating_pixels
    - added allow_default_gain_reset
- 2019-04-02 1.0.14
    - clear response queue when disabling free-running mode
    - Zynq fix
- 2019-04-01 1.0.13
    - Enable ENG-0034 Rev 4
- 2019-03-29 1.0.12
    - disable select_laser if no laser present
    - kludge SiG-VIS to bare_readings
- 2019-03-28 1.0.11
    - validate set_laser_enable with gettor
    - replace WasatchDevice internal multiprocessing.Queue with array
- 2019-03-26 1.0.10
    - added set_selected_laser to WasatchShell
    - add is_zynq() with 250ms min USB interval
    - ignore NULLs/control chars in reading FPGA revision string
- 2019-03-22 1.0.9
    - added set_selected_laser
    - improved robustness when recovering from disabled triggering
- 2019-03-15 1.0.8
    - added bare_readings so WasatchShell wouldn't double-sample photodiode
    - added immediate_mode so WasatchShell could use change_setting
    - fixed BalanceAcquisition to support non-free-running mode
    - moved auto-triggered laser disable to after laser temperature and photodiode readouts
- 2019-03-14 1.0.7
    - stubbed select_laser
    - tweaked poison-pill logic
- 2019-02-16 1.0.6
    - added DeviceID
    - renamed DeviceListFID -> DeviceFinderUSB
    - removed bus_order
- 2019-02-16 1.0.5
    - disabled EEPROM range-checks on integration time
- 2019-02-07 1.0.4
    - added default_detector_setpoint_degC
    - tweaked auto-laser behavior
    - default to DEBUG logging until initialized
- 2019-02-04 1.0.3
    - fixed demo.py
    - renamed get_interlock to get_laser_interlock
- 2019-01-21 1.0.2
    - improved hotplug support
- 2019-01-18 1.0.1
    - better support for hotplug / unplug events (poison pill updates)
    - added SpectrometerSettings.excitation()
- 2019-01-16 1.0.0
    - added UUID for tracking multiple spectrometers
    - deprecated StrokerProtocol devices
- 2018-01-04 0.9.18
    - updated EEPROM field definitions to latest draft of ENG-0034 Rev 4
    - added battery support
- 2018-11-28 0.9.17
    - fixed scan averaging in non-free-running mode
- 2018-11-27 0.9.16
    - bugfixes
- 2018-11-27 0.9.15
    - changed detector_offset to SInt16
    - added SpectrometerState.free_running_mode, .acquisition_laser_trigger_enable, .acquisition_laser_trigger_delay_ms
    - added "acquire" device command (letting ENLIGHTEN trigger individual acquisitions)
- 2018-10-03 0.9.14
    - fixed demo.py --outfile
- 2018-09-27 0.9.13
    - fixed demo.py integration time
- 2018-09-25 0.9.12
    - ARM triggering
- 2018-08-22 0.9.11
    - improved exception handling
- 2018-08-14 0.9.10
    - InGaAs offset/gain processing in software
- 2018-07-31 0.9.9
    - added dependency on pexpect for testing
- 2018-07-31 0.9.8
    - added utils.interpolate_array
- 2018-07-13 0.9.7
    - converted WasatchShell into a wrapper over Wasatch.PY
    - added numerous getters
    - added BalanceAcquisition
- 2018-07-13 0.9.6
    - added Doxyfile
    - moved class/method docs to Doxygen format
- 2018-07-11 0.9.5
    - added comms_init
- 2018-07-10 0.9.4
    - added StatusMessage
- 2018-07-05 0.9.3
    - added graph_alternating_pixels
- 2018-06-13 0.9.2
    - internally track FileSpectrometer integration time state
- 2018-06-12 0.9.1
    - fixed shell.py's "get_config"
- 2018-06-12 0.9.0
    - taking spectra from IMX
- 2018-06-08 0.8.9
    - detector_ccd/offset_odd stubbed
    - fixed command de-dupping
- 2018-06-07 0.8.8
    - peak math
- 2018-06-06 0.8.7
    - added area_under_peak
- 2018-06-04 0.8.6
    - added CommandSettings.py
    - added wasatch.applog.MainLogger(enable_stdout=True)
- 2018-06-04 0.8.5
    - added shell.py
- 2018-06-01 0.8.4
    - added Overrides
- 2018-05-31 0.8.3
    - FileSpectrometer mostly working
- 2018-05-29 0.8.2
    - initial version of FileSpectrometer
    - added JSON support
- 2018-05-17 0.8.1
    - ARM debugs
    - added set_laser_power_mW
- 2018-05-15 0.8.0
    - EEPROM writing works
- 2018-05-14 0.7.4
    - fixed get_ccd_gain in StrokerProtocol devices
- 2018-05-09 0.7.3
    - raise exception on reading unexpected pixel count
- 2018-05-09 0.7.2
    - added support for 2048-pixel FID spectrometers
- 2018-05-08 0.7.1
    - updates for ENLIGHTEN 1.3.0
- 2018-04-30 0.7.0
    - added SpectrometerSettings
    - added SpectrometerState
    - added EEPROM
- 2018-04-21 0.6.10
    - Reading.session_count
    - Reading.laser_power
    - robustness
- 2018-04-20 0.6.9
    - additional lasersec
- 2018-04-19 0.6.8
    - fixed laser ramp rounding
- 2018-04-18 0.6.7
    - draft area scan implementation
- 2018-04-17 0.6.6
    - parameterized laser_ramp_increments
- 2018-04-16 0.6.5
    - updated laser power ramping
- 2018-04-13 0.6.4
    - initial laser power ramping
- 2018-04-12 0.6.3
    - added get_secondary_adc_calibrated
    - reads linearity, ROI from EEPROM
- 2018-04-06 0.6.2
    - fixed secondary ADC endian order
- 2018-04-05 0.6.1
    - StrokerProtocolDevice fixes
    - FPGAOptions fixes to laser_control and laser_type
    - added enable_secondary_adc
    - added invert_x_axis
    - better FID USB logging
- 2018-03-22 0.6.0
    - starting multi-spectrometer support
    - tagging before attempting switch to MonoLibUsb
- 2018-03-06 0.5.6
    - added FPGAOptions
    - supported more EEPROM options
    - added fpga_reset()
    - don't read laser temp unless has_laser
- 2018-03-02 0.5.5
    - added "max_usb_interval_ms"
    - de-dupe USB commands
- 2018-02-15 0.5.4
    - added "min_usb_interval_ms"
- 2018-02-14 0.5.3
    - added set_ccd_offset()
- 2018-01-26 0.5.2
    - added set_ccd_trigger() 
- 2018-01-24 0.5.1
    - added get/set_laser_temperature_setpoint_raw() 
- 2018-01-22 0.5.0
    - initial customer release
    - analyzed non-blocking issue on MacOS
    - default TEC to min 
- 2018-01-22 0.2.2 
    - tested and documented for Linux
- 2018-01-22 0.2.1 
    - tested and documented for MacOS
- 2018-01-22 0.2.0 
    - added demo.py, Windows run instructions
- 2018-01-08 0.1.2 
    - swapped LSB/MSB on high-gain mode
- 2018-01-05 0.1.1 
    - fixed laser_enable
    - updated NIR high-gain mode
- 2018-01-05 0.1.0 
    - initial import from ENLIGHTEN
