//! File automatically generated by `examples/generate_check_code_prefix.rs`.

use colored::Colorize;
use serde::{Deserialize, Serialize};
use strum_macros::EnumString;

use crate::checks::CheckCode;

#[derive(EnumString, Debug, PartialEq, Eq, PartialOrd, Ord, Clone, Serialize, Deserialize)]
pub enum CheckCodePrefix {
    A,
    A0,
    A00,
    A001,
    A002,
    A003,
    ANN,
    ANN0,
    ANN00,
    ANN001,
    ANN002,
    ANN003,
    ANN1,
    ANN10,
    ANN101,
    ANN102,
    ANN2,
    ANN20,
    ANN201,
    ANN202,
    ANN204,
    ANN205,
    ANN206,
    ANN4,
    ANN40,
    ANN401,
    B,
    B0,
    B00,
    B002,
    B003,
    B004,
    B005,
    B006,
    B007,
    B008,
    B009,
    B01,
    B010,
    B011,
    B012,
    B013,
    B014,
    B015,
    B016,
    B017,
    B018,
    B019,
    B02,
    B020,
    B021,
    B022,
    B023,
    B024,
    B025,
    B026,
    B027,
    B9,
    B90,
    B904,
    BLE,
    BLE0,
    BLE00,
    BLE001,
    C,
    C4,
    C40,
    C400,
    C401,
    C402,
    C403,
    C404,
    C405,
    C406,
    C408,
    C409,
    C41,
    C410,
    C411,
    C413,
    C414,
    C415,
    C416,
    C417,
    C9,
    C90,
    C901,
    D,
    D1,
    D10,
    D100,
    D101,
    D102,
    D103,
    D104,
    D105,
    D106,
    D107,
    D2,
    D20,
    D200,
    D201,
    D202,
    D203,
    D204,
    D205,
    D206,
    D207,
    D208,
    D209,
    D21,
    D210,
    D211,
    D212,
    D213,
    D214,
    D215,
    D3,
    D30,
    D300,
    D4,
    D40,
    D400,
    D402,
    D403,
    D404,
    D405,
    D406,
    D407,
    D408,
    D409,
    D41,
    D410,
    D411,
    D412,
    D413,
    D414,
    D415,
    D416,
    D417,
    D418,
    D419,
    E,
    E4,
    E40,
    E402,
    E5,
    E50,
    E501,
    E7,
    E71,
    E711,
    E712,
    E713,
    E714,
    E72,
    E721,
    E722,
    E73,
    E731,
    E74,
    E741,
    E742,
    E743,
    E9,
    E90,
    E902,
    E99,
    E999,
    ERA,
    ERA0,
    ERA00,
    ERA001,
    F,
    F4,
    F40,
    F401,
    F402,
    F403,
    F404,
    F405,
    F406,
    F407,
    F5,
    F50,
    F501,
    F502,
    F503,
    F504,
    F505,
    F506,
    F507,
    F508,
    F509,
    F52,
    F521,
    F522,
    F523,
    F524,
    F525,
    F54,
    F541,
    F6,
    F60,
    F601,
    F602,
    F62,
    F621,
    F622,
    F63,
    F631,
    F632,
    F633,
    F634,
    F7,
    F70,
    F701,
    F702,
    F704,
    F706,
    F707,
    F72,
    F722,
    F8,
    F82,
    F821,
    F822,
    F823,
    F83,
    F831,
    F84,
    F841,
    F9,
    F90,
    F901,
    FBT,
    FBT0,
    FBT00,
    FBT001,
    FBT002,
    FBT003,
    I,
    I0,
    I00,
    I001,
    I2,
    I25,
    I252,
    N,
    N8,
    N80,
    N801,
    N802,
    N803,
    N804,
    N805,
    N806,
    N807,
    N81,
    N811,
    N812,
    N813,
    N814,
    N815,
    N816,
    N817,
    N818,
    PGH,
    PGH0,
    PGH00,
    PGH001,
    PLC,
    PLC0,
    PLC04,
    PLC041,
    PLC0414,
    PLC2,
    PLC22,
    PLC220,
    PLC2201,
    PLC3,
    PLC30,
    PLC300,
    PLC3002,
    PLE,
    PLE1,
    PLE11,
    PLE114,
    PLE1142,
    PLR,
    PLR0,
    PLR02,
    PLR020,
    PLR0206,
    PLR04,
    PLR040,
    PLR0402,
    PLR1,
    PLR17,
    PLR170,
    PLR1701,
    PLR172,
    PLR1722,
    PLW,
    PLW0,
    PLW01,
    PLW012,
    PLW0120,
    Q,
    Q0,
    Q00,
    Q000,
    Q001,
    Q002,
    Q003,
    RET,
    RET5,
    RET50,
    RET501,
    RET502,
    RET503,
    RET504,
    RET505,
    RET506,
    RET507,
    RET508,
    RUF,
    RUF0,
    RUF00,
    RUF001,
    RUF002,
    RUF003,
    RUF1,
    RUF10,
    RUF100,
    S,
    S1,
    S10,
    S101,
    S102,
    S104,
    S105,
    S106,
    S107,
    T,
    T1,
    T10,
    T100,
    T2,
    T20,
    T201,
    T203,
    U,
    U0,
    U00,
    U001,
    U003,
    U004,
    U005,
    U006,
    U007,
    U008,
    U009,
    U01,
    U010,
    U011,
    U012,
    U013,
    U014,
    U015,
    UP,
    UP0,
    UP00,
    UP001,
    UP003,
    UP004,
    UP005,
    UP006,
    UP007,
    UP008,
    UP009,
    UP01,
    UP010,
    UP011,
    UP012,
    UP013,
    UP014,
    UP015,
    W,
    W2,
    W29,
    W292,
    W6,
    W60,
    W605,
    YTT,
    YTT1,
    YTT10,
    YTT101,
    YTT102,
    YTT103,
    YTT2,
    YTT20,
    YTT201,
    YTT202,
    YTT203,
    YTT204,
    YTT3,
    YTT30,
    YTT301,
    YTT302,
    YTT303,
}

#[derive(PartialEq, Eq, PartialOrd, Ord)]
pub enum SuffixLength {
    Zero,
    One,
    Two,
    Three,
    Four,
}

impl CheckCodePrefix {
    pub fn codes(&self) -> Vec<CheckCode> {
        #[allow(clippy::match_same_arms)]
        match self {
            CheckCodePrefix::A => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A0 => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A00 => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A001 => vec![CheckCode::A001],
            CheckCodePrefix::A002 => vec![CheckCode::A002],
            CheckCodePrefix::A003 => vec![CheckCode::A003],
            CheckCodePrefix::ANN => vec![
                CheckCode::ANN001,
                CheckCode::ANN002,
                CheckCode::ANN003,
                CheckCode::ANN101,
                CheckCode::ANN102,
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
                CheckCode::ANN401,
            ],
            CheckCodePrefix::ANN0 => vec![CheckCode::ANN001, CheckCode::ANN002, CheckCode::ANN003],
            CheckCodePrefix::ANN00 => vec![CheckCode::ANN001, CheckCode::ANN002, CheckCode::ANN003],
            CheckCodePrefix::ANN001 => vec![CheckCode::ANN001],
            CheckCodePrefix::ANN002 => vec![CheckCode::ANN002],
            CheckCodePrefix::ANN003 => vec![CheckCode::ANN003],
            CheckCodePrefix::ANN1 => vec![CheckCode::ANN101, CheckCode::ANN102],
            CheckCodePrefix::ANN10 => vec![CheckCode::ANN101, CheckCode::ANN102],
            CheckCodePrefix::ANN101 => vec![CheckCode::ANN101],
            CheckCodePrefix::ANN102 => vec![CheckCode::ANN102],
            CheckCodePrefix::ANN2 => vec![
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
            ],
            CheckCodePrefix::ANN20 => vec![
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
            ],
            CheckCodePrefix::ANN201 => vec![CheckCode::ANN201],
            CheckCodePrefix::ANN202 => vec![CheckCode::ANN202],
            CheckCodePrefix::ANN204 => vec![CheckCode::ANN204],
            CheckCodePrefix::ANN205 => vec![CheckCode::ANN205],
            CheckCodePrefix::ANN206 => vec![CheckCode::ANN206],
            CheckCodePrefix::ANN4 => vec![CheckCode::ANN401],
            CheckCodePrefix::ANN40 => vec![CheckCode::ANN401],
            CheckCodePrefix::ANN401 => vec![CheckCode::ANN401],
            CheckCodePrefix::B => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
                CheckCode::B009,
                CheckCode::B010,
                CheckCode::B011,
                CheckCode::B012,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
                CheckCode::B019,
                CheckCode::B020,
                CheckCode::B021,
                CheckCode::B022,
                CheckCode::B023,
                CheckCode::B024,
                CheckCode::B025,
                CheckCode::B026,
                CheckCode::B027,
                CheckCode::B904,
            ],
            CheckCodePrefix::B0 => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
                CheckCode::B009,
                CheckCode::B010,
                CheckCode::B011,
                CheckCode::B012,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
                CheckCode::B019,
                CheckCode::B020,
                CheckCode::B021,
                CheckCode::B022,
                CheckCode::B023,
                CheckCode::B024,
                CheckCode::B025,
                CheckCode::B026,
                CheckCode::B027,
            ],
            CheckCodePrefix::B00 => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
                CheckCode::B009,
            ],
            CheckCodePrefix::B002 => vec![CheckCode::B002],
            CheckCodePrefix::B003 => vec![CheckCode::B003],
            CheckCodePrefix::B004 => vec![CheckCode::B004],
            CheckCodePrefix::B005 => vec![CheckCode::B005],
            CheckCodePrefix::B006 => vec![CheckCode::B006],
            CheckCodePrefix::B007 => vec![CheckCode::B007],
            CheckCodePrefix::B008 => vec![CheckCode::B008],
            CheckCodePrefix::B009 => vec![CheckCode::B009],
            CheckCodePrefix::B01 => vec![
                CheckCode::B010,
                CheckCode::B011,
                CheckCode::B012,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
                CheckCode::B019,
            ],
            CheckCodePrefix::B010 => vec![CheckCode::B010],
            CheckCodePrefix::B011 => vec![CheckCode::B011],
            CheckCodePrefix::B012 => vec![CheckCode::B012],
            CheckCodePrefix::B013 => vec![CheckCode::B013],
            CheckCodePrefix::B014 => vec![CheckCode::B014],
            CheckCodePrefix::B015 => vec![CheckCode::B015],
            CheckCodePrefix::B016 => vec![CheckCode::B016],
            CheckCodePrefix::B017 => vec![CheckCode::B017],
            CheckCodePrefix::B018 => vec![CheckCode::B018],
            CheckCodePrefix::B019 => vec![CheckCode::B019],
            CheckCodePrefix::B02 => vec![
                CheckCode::B020,
                CheckCode::B021,
                CheckCode::B022,
                CheckCode::B023,
                CheckCode::B024,
                CheckCode::B025,
                CheckCode::B026,
                CheckCode::B027,
            ],
            CheckCodePrefix::B020 => vec![CheckCode::B020],
            CheckCodePrefix::B021 => vec![CheckCode::B021],
            CheckCodePrefix::B022 => vec![CheckCode::B022],
            CheckCodePrefix::B023 => vec![CheckCode::B023],
            CheckCodePrefix::B024 => vec![CheckCode::B024],
            CheckCodePrefix::B025 => vec![CheckCode::B025],
            CheckCodePrefix::B026 => vec![CheckCode::B026],
            CheckCodePrefix::B027 => vec![CheckCode::B027],
            CheckCodePrefix::B9 => vec![CheckCode::B904],
            CheckCodePrefix::B90 => vec![CheckCode::B904],
            CheckCodePrefix::B904 => vec![CheckCode::B904],
            CheckCodePrefix::BLE => vec![CheckCode::BLE001],
            CheckCodePrefix::BLE0 => vec![CheckCode::BLE001],
            CheckCodePrefix::BLE00 => vec![CheckCode::BLE001],
            CheckCodePrefix::BLE001 => vec![CheckCode::BLE001],
            CheckCodePrefix::C => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
                CheckCode::C901,
            ],
            CheckCodePrefix::C4 => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
            ],
            CheckCodePrefix::C40 => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
            ],
            CheckCodePrefix::C400 => vec![CheckCode::C400],
            CheckCodePrefix::C401 => vec![CheckCode::C401],
            CheckCodePrefix::C402 => vec![CheckCode::C402],
            CheckCodePrefix::C403 => vec![CheckCode::C403],
            CheckCodePrefix::C404 => vec![CheckCode::C404],
            CheckCodePrefix::C405 => vec![CheckCode::C405],
            CheckCodePrefix::C406 => vec![CheckCode::C406],
            CheckCodePrefix::C408 => vec![CheckCode::C408],
            CheckCodePrefix::C409 => vec![CheckCode::C409],
            CheckCodePrefix::C41 => vec![
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
            ],
            CheckCodePrefix::C410 => vec![CheckCode::C410],
            CheckCodePrefix::C411 => vec![CheckCode::C411],
            CheckCodePrefix::C413 => vec![CheckCode::C413],
            CheckCodePrefix::C414 => vec![CheckCode::C414],
            CheckCodePrefix::C415 => vec![CheckCode::C415],
            CheckCodePrefix::C416 => vec![CheckCode::C416],
            CheckCodePrefix::C417 => vec![CheckCode::C417],
            CheckCodePrefix::C9 => vec![CheckCode::C901],
            CheckCodePrefix::C90 => vec![CheckCode::C901],
            CheckCodePrefix::C901 => vec![CheckCode::C901],
            CheckCodePrefix::D => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
                CheckCode::D300,
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D1 => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
            ],
            CheckCodePrefix::D10 => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
            ],
            CheckCodePrefix::D100 => vec![CheckCode::D100],
            CheckCodePrefix::D101 => vec![CheckCode::D101],
            CheckCodePrefix::D102 => vec![CheckCode::D102],
            CheckCodePrefix::D103 => vec![CheckCode::D103],
            CheckCodePrefix::D104 => vec![CheckCode::D104],
            CheckCodePrefix::D105 => vec![CheckCode::D105],
            CheckCodePrefix::D106 => vec![CheckCode::D106],
            CheckCodePrefix::D107 => vec![CheckCode::D107],
            CheckCodePrefix::D2 => vec![
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
            ],
            CheckCodePrefix::D20 => vec![
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
            ],
            CheckCodePrefix::D200 => vec![CheckCode::D200],
            CheckCodePrefix::D201 => vec![CheckCode::D201],
            CheckCodePrefix::D202 => vec![CheckCode::D202],
            CheckCodePrefix::D203 => vec![CheckCode::D203],
            CheckCodePrefix::D204 => vec![CheckCode::D204],
            CheckCodePrefix::D205 => vec![CheckCode::D205],
            CheckCodePrefix::D206 => vec![CheckCode::D206],
            CheckCodePrefix::D207 => vec![CheckCode::D207],
            CheckCodePrefix::D208 => vec![CheckCode::D208],
            CheckCodePrefix::D209 => vec![CheckCode::D209],
            CheckCodePrefix::D21 => vec![
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
            ],
            CheckCodePrefix::D210 => vec![CheckCode::D210],
            CheckCodePrefix::D211 => vec![CheckCode::D211],
            CheckCodePrefix::D212 => vec![CheckCode::D212],
            CheckCodePrefix::D213 => vec![CheckCode::D213],
            CheckCodePrefix::D214 => vec![CheckCode::D214],
            CheckCodePrefix::D215 => vec![CheckCode::D215],
            CheckCodePrefix::D3 => vec![CheckCode::D300],
            CheckCodePrefix::D30 => vec![CheckCode::D300],
            CheckCodePrefix::D300 => vec![CheckCode::D300],
            CheckCodePrefix::D4 => vec![
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D40 => vec![
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
            ],
            CheckCodePrefix::D400 => vec![CheckCode::D400],
            CheckCodePrefix::D402 => vec![CheckCode::D402],
            CheckCodePrefix::D403 => vec![CheckCode::D403],
            CheckCodePrefix::D404 => vec![CheckCode::D404],
            CheckCodePrefix::D405 => vec![CheckCode::D405],
            CheckCodePrefix::D406 => vec![CheckCode::D406],
            CheckCodePrefix::D407 => vec![CheckCode::D407],
            CheckCodePrefix::D408 => vec![CheckCode::D408],
            CheckCodePrefix::D409 => vec![CheckCode::D409],
            CheckCodePrefix::D41 => vec![
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D410 => vec![CheckCode::D410],
            CheckCodePrefix::D411 => vec![CheckCode::D411],
            CheckCodePrefix::D412 => vec![CheckCode::D412],
            CheckCodePrefix::D413 => vec![CheckCode::D413],
            CheckCodePrefix::D414 => vec![CheckCode::D414],
            CheckCodePrefix::D415 => vec![CheckCode::D415],
            CheckCodePrefix::D416 => vec![CheckCode::D416],
            CheckCodePrefix::D417 => vec![CheckCode::D417],
            CheckCodePrefix::D418 => vec![CheckCode::D418],
            CheckCodePrefix::D419 => vec![CheckCode::D419],
            CheckCodePrefix::E => vec![
                CheckCode::E402,
                CheckCode::E501,
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
                CheckCode::E721,
                CheckCode::E722,
                CheckCode::E731,
                CheckCode::E741,
                CheckCode::E742,
                CheckCode::E743,
                CheckCode::E902,
                CheckCode::E999,
            ],
            CheckCodePrefix::E4 => vec![CheckCode::E402],
            CheckCodePrefix::E40 => vec![CheckCode::E402],
            CheckCodePrefix::E402 => vec![CheckCode::E402],
            CheckCodePrefix::E5 => vec![CheckCode::E501],
            CheckCodePrefix::E50 => vec![CheckCode::E501],
            CheckCodePrefix::E501 => vec![CheckCode::E501],
            CheckCodePrefix::E7 => vec![
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
                CheckCode::E721,
                CheckCode::E722,
                CheckCode::E731,
                CheckCode::E741,
                CheckCode::E742,
                CheckCode::E743,
            ],
            CheckCodePrefix::E71 => vec![
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
            ],
            CheckCodePrefix::E711 => vec![CheckCode::E711],
            CheckCodePrefix::E712 => vec![CheckCode::E712],
            CheckCodePrefix::E713 => vec![CheckCode::E713],
            CheckCodePrefix::E714 => vec![CheckCode::E714],
            CheckCodePrefix::E72 => vec![CheckCode::E721, CheckCode::E722],
            CheckCodePrefix::E721 => vec![CheckCode::E721],
            CheckCodePrefix::E722 => vec![CheckCode::E722],
            CheckCodePrefix::E73 => vec![CheckCode::E731],
            CheckCodePrefix::E731 => vec![CheckCode::E731],
            CheckCodePrefix::E74 => vec![CheckCode::E741, CheckCode::E742, CheckCode::E743],
            CheckCodePrefix::E741 => vec![CheckCode::E741],
            CheckCodePrefix::E742 => vec![CheckCode::E742],
            CheckCodePrefix::E743 => vec![CheckCode::E743],
            CheckCodePrefix::E9 => vec![CheckCode::E902, CheckCode::E999],
            CheckCodePrefix::E90 => vec![CheckCode::E902],
            CheckCodePrefix::E902 => vec![CheckCode::E902],
            CheckCodePrefix::E99 => vec![CheckCode::E999],
            CheckCodePrefix::E999 => vec![CheckCode::E999],
            CheckCodePrefix::ERA => vec![CheckCode::ERA001],
            CheckCodePrefix::ERA0 => vec![CheckCode::ERA001],
            CheckCodePrefix::ERA00 => vec![CheckCode::ERA001],
            CheckCodePrefix::ERA001 => vec![CheckCode::ERA001],
            CheckCodePrefix::F => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
                CheckCode::F501,
                CheckCode::F502,
                CheckCode::F503,
                CheckCode::F504,
                CheckCode::F505,
                CheckCode::F506,
                CheckCode::F507,
                CheckCode::F508,
                CheckCode::F509,
                CheckCode::F521,
                CheckCode::F522,
                CheckCode::F523,
                CheckCode::F524,
                CheckCode::F525,
                CheckCode::F541,
                CheckCode::F601,
                CheckCode::F602,
                CheckCode::F621,
                CheckCode::F622,
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
                CheckCode::F722,
                CheckCode::F821,
                CheckCode::F822,
                CheckCode::F823,
                CheckCode::F831,
                CheckCode::F841,
                CheckCode::F901,
            ],
            CheckCodePrefix::F4 => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
            ],
            CheckCodePrefix::F40 => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
            ],
            CheckCodePrefix::F401 => vec![CheckCode::F401],
            CheckCodePrefix::F402 => vec![CheckCode::F402],
            CheckCodePrefix::F403 => vec![CheckCode::F403],
            CheckCodePrefix::F404 => vec![CheckCode::F404],
            CheckCodePrefix::F405 => vec![CheckCode::F405],
            CheckCodePrefix::F406 => vec![CheckCode::F406],
            CheckCodePrefix::F407 => vec![CheckCode::F407],
            CheckCodePrefix::F5 => vec![
                CheckCode::F501,
                CheckCode::F502,
                CheckCode::F503,
                CheckCode::F504,
                CheckCode::F505,
                CheckCode::F506,
                CheckCode::F507,
                CheckCode::F508,
                CheckCode::F509,
                CheckCode::F521,
                CheckCode::F522,
                CheckCode::F523,
                CheckCode::F524,
                CheckCode::F525,
                CheckCode::F541,
            ],
            CheckCodePrefix::F50 => vec![
                CheckCode::F501,
                CheckCode::F502,
                CheckCode::F503,
                CheckCode::F504,
                CheckCode::F505,
                CheckCode::F506,
                CheckCode::F507,
                CheckCode::F508,
                CheckCode::F509,
            ],
            CheckCodePrefix::F501 => vec![CheckCode::F501],
            CheckCodePrefix::F502 => vec![CheckCode::F502],
            CheckCodePrefix::F503 => vec![CheckCode::F503],
            CheckCodePrefix::F504 => vec![CheckCode::F504],
            CheckCodePrefix::F505 => vec![CheckCode::F505],
            CheckCodePrefix::F506 => vec![CheckCode::F506],
            CheckCodePrefix::F507 => vec![CheckCode::F507],
            CheckCodePrefix::F508 => vec![CheckCode::F508],
            CheckCodePrefix::F509 => vec![CheckCode::F509],
            CheckCodePrefix::F52 => vec![
                CheckCode::F521,
                CheckCode::F522,
                CheckCode::F523,
                CheckCode::F524,
                CheckCode::F525,
            ],
            CheckCodePrefix::F521 => vec![CheckCode::F521],
            CheckCodePrefix::F522 => vec![CheckCode::F522],
            CheckCodePrefix::F523 => vec![CheckCode::F523],
            CheckCodePrefix::F524 => vec![CheckCode::F524],
            CheckCodePrefix::F525 => vec![CheckCode::F525],
            CheckCodePrefix::F54 => vec![CheckCode::F541],
            CheckCodePrefix::F541 => vec![CheckCode::F541],
            CheckCodePrefix::F6 => vec![
                CheckCode::F601,
                CheckCode::F602,
                CheckCode::F621,
                CheckCode::F622,
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
            ],
            CheckCodePrefix::F60 => vec![CheckCode::F601, CheckCode::F602],
            CheckCodePrefix::F601 => vec![CheckCode::F601],
            CheckCodePrefix::F602 => vec![CheckCode::F602],
            CheckCodePrefix::F62 => vec![CheckCode::F621, CheckCode::F622],
            CheckCodePrefix::F621 => vec![CheckCode::F621],
            CheckCodePrefix::F622 => vec![CheckCode::F622],
            CheckCodePrefix::F63 => vec![
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
            ],
            CheckCodePrefix::F631 => vec![CheckCode::F631],
            CheckCodePrefix::F632 => vec![CheckCode::F632],
            CheckCodePrefix::F633 => vec![CheckCode::F633],
            CheckCodePrefix::F634 => vec![CheckCode::F634],
            CheckCodePrefix::F7 => vec![
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
                CheckCode::F722,
            ],
            CheckCodePrefix::F70 => vec![
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
            ],
            CheckCodePrefix::F701 => vec![CheckCode::F701],
            CheckCodePrefix::F702 => vec![CheckCode::F702],
            CheckCodePrefix::F704 => vec![CheckCode::F704],
            CheckCodePrefix::F706 => vec![CheckCode::F706],
            CheckCodePrefix::F707 => vec![CheckCode::F707],
            CheckCodePrefix::F72 => vec![CheckCode::F722],
            CheckCodePrefix::F722 => vec![CheckCode::F722],
            CheckCodePrefix::F8 => vec![
                CheckCode::F821,
                CheckCode::F822,
                CheckCode::F823,
                CheckCode::F831,
                CheckCode::F841,
            ],
            CheckCodePrefix::F82 => vec![CheckCode::F821, CheckCode::F822, CheckCode::F823],
            CheckCodePrefix::F821 => vec![CheckCode::F821],
            CheckCodePrefix::F822 => vec![CheckCode::F822],
            CheckCodePrefix::F823 => vec![CheckCode::F823],
            CheckCodePrefix::F83 => vec![CheckCode::F831],
            CheckCodePrefix::F831 => vec![CheckCode::F831],
            CheckCodePrefix::F84 => vec![CheckCode::F841],
            CheckCodePrefix::F841 => vec![CheckCode::F841],
            CheckCodePrefix::F9 => vec![CheckCode::F901],
            CheckCodePrefix::F90 => vec![CheckCode::F901],
            CheckCodePrefix::F901 => vec![CheckCode::F901],
            CheckCodePrefix::FBT => vec![CheckCode::FBT001, CheckCode::FBT002, CheckCode::FBT003],
            CheckCodePrefix::FBT0 => vec![CheckCode::FBT001, CheckCode::FBT002, CheckCode::FBT003],
            CheckCodePrefix::FBT00 => vec![CheckCode::FBT001, CheckCode::FBT002, CheckCode::FBT003],
            CheckCodePrefix::FBT001 => vec![CheckCode::FBT001],
            CheckCodePrefix::FBT002 => vec![CheckCode::FBT002],
            CheckCodePrefix::FBT003 => vec![CheckCode::FBT003],
            CheckCodePrefix::I => vec![CheckCode::I252, CheckCode::I001],
            CheckCodePrefix::I0 => vec![CheckCode::I001],
            CheckCodePrefix::I00 => vec![CheckCode::I001],
            CheckCodePrefix::I001 => vec![CheckCode::I001],
            CheckCodePrefix::I2 => vec![CheckCode::I252],
            CheckCodePrefix::I25 => vec![CheckCode::I252],
            CheckCodePrefix::I252 => vec![CheckCode::I252],
            CheckCodePrefix::N => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N8 => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N80 => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
            ],
            CheckCodePrefix::N801 => vec![CheckCode::N801],
            CheckCodePrefix::N802 => vec![CheckCode::N802],
            CheckCodePrefix::N803 => vec![CheckCode::N803],
            CheckCodePrefix::N804 => vec![CheckCode::N804],
            CheckCodePrefix::N805 => vec![CheckCode::N805],
            CheckCodePrefix::N806 => vec![CheckCode::N806],
            CheckCodePrefix::N807 => vec![CheckCode::N807],
            CheckCodePrefix::N81 => vec![
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N811 => vec![CheckCode::N811],
            CheckCodePrefix::N812 => vec![CheckCode::N812],
            CheckCodePrefix::N813 => vec![CheckCode::N813],
            CheckCodePrefix::N814 => vec![CheckCode::N814],
            CheckCodePrefix::N815 => vec![CheckCode::N815],
            CheckCodePrefix::N816 => vec![CheckCode::N816],
            CheckCodePrefix::N817 => vec![CheckCode::N817],
            CheckCodePrefix::N818 => vec![CheckCode::N818],
            CheckCodePrefix::PGH => vec![CheckCode::PGH001],
            CheckCodePrefix::PGH0 => vec![CheckCode::PGH001],
            CheckCodePrefix::PGH00 => vec![CheckCode::PGH001],
            CheckCodePrefix::PGH001 => vec![CheckCode::PGH001],
            CheckCodePrefix::PLC => {
                vec![CheckCode::PLC0414, CheckCode::PLC2201, CheckCode::PLC3002]
            }
            CheckCodePrefix::PLC0 => vec![CheckCode::PLC0414],
            CheckCodePrefix::PLC04 => vec![CheckCode::PLC0414],
            CheckCodePrefix::PLC041 => vec![CheckCode::PLC0414],
            CheckCodePrefix::PLC0414 => vec![CheckCode::PLC0414],
            CheckCodePrefix::PLC2 => vec![CheckCode::PLC2201],
            CheckCodePrefix::PLC22 => vec![CheckCode::PLC2201],
            CheckCodePrefix::PLC220 => vec![CheckCode::PLC2201],
            CheckCodePrefix::PLC2201 => vec![CheckCode::PLC2201],
            CheckCodePrefix::PLC3 => vec![CheckCode::PLC3002],
            CheckCodePrefix::PLC30 => vec![CheckCode::PLC3002],
            CheckCodePrefix::PLC300 => vec![CheckCode::PLC3002],
            CheckCodePrefix::PLC3002 => vec![CheckCode::PLC3002],
            CheckCodePrefix::PLE => vec![CheckCode::PLE1142],
            CheckCodePrefix::PLE1 => vec![CheckCode::PLE1142],
            CheckCodePrefix::PLE11 => vec![CheckCode::PLE1142],
            CheckCodePrefix::PLE114 => vec![CheckCode::PLE1142],
            CheckCodePrefix::PLE1142 => vec![CheckCode::PLE1142],
            CheckCodePrefix::PLR => vec![
                CheckCode::PLR0206,
                CheckCode::PLR0402,
                CheckCode::PLR1701,
                CheckCode::PLR1722,
            ],
            CheckCodePrefix::PLR0 => vec![CheckCode::PLR0206, CheckCode::PLR0402],
            CheckCodePrefix::PLR02 => vec![CheckCode::PLR0206],
            CheckCodePrefix::PLR020 => vec![CheckCode::PLR0206],
            CheckCodePrefix::PLR0206 => vec![CheckCode::PLR0206],
            CheckCodePrefix::PLR04 => vec![CheckCode::PLR0402],
            CheckCodePrefix::PLR040 => vec![CheckCode::PLR0402],
            CheckCodePrefix::PLR0402 => vec![CheckCode::PLR0402],
            CheckCodePrefix::PLR1 => vec![CheckCode::PLR1701, CheckCode::PLR1722],
            CheckCodePrefix::PLR17 => vec![CheckCode::PLR1701, CheckCode::PLR1722],
            CheckCodePrefix::PLR170 => vec![CheckCode::PLR1701],
            CheckCodePrefix::PLR1701 => vec![CheckCode::PLR1701],
            CheckCodePrefix::PLR172 => vec![CheckCode::PLR1722],
            CheckCodePrefix::PLR1722 => vec![CheckCode::PLR1722],
            CheckCodePrefix::PLW => vec![CheckCode::PLW0120],
            CheckCodePrefix::PLW0 => vec![CheckCode::PLW0120],
            CheckCodePrefix::PLW01 => vec![CheckCode::PLW0120],
            CheckCodePrefix::PLW012 => vec![CheckCode::PLW0120],
            CheckCodePrefix::PLW0120 => vec![CheckCode::PLW0120],
            CheckCodePrefix::Q => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q0 => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q00 => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q000 => vec![CheckCode::Q000],
            CheckCodePrefix::Q001 => vec![CheckCode::Q001],
            CheckCodePrefix::Q002 => vec![CheckCode::Q002],
            CheckCodePrefix::Q003 => vec![CheckCode::Q003],
            CheckCodePrefix::RET => vec![
                CheckCode::RET501,
                CheckCode::RET502,
                CheckCode::RET503,
                CheckCode::RET504,
                CheckCode::RET505,
                CheckCode::RET506,
                CheckCode::RET507,
                CheckCode::RET508,
            ],
            CheckCodePrefix::RET5 => vec![
                CheckCode::RET501,
                CheckCode::RET502,
                CheckCode::RET503,
                CheckCode::RET504,
                CheckCode::RET505,
                CheckCode::RET506,
                CheckCode::RET507,
                CheckCode::RET508,
            ],
            CheckCodePrefix::RET50 => vec![
                CheckCode::RET501,
                CheckCode::RET502,
                CheckCode::RET503,
                CheckCode::RET504,
                CheckCode::RET505,
                CheckCode::RET506,
                CheckCode::RET507,
                CheckCode::RET508,
            ],
            CheckCodePrefix::RET501 => vec![CheckCode::RET501],
            CheckCodePrefix::RET502 => vec![CheckCode::RET502],
            CheckCodePrefix::RET503 => vec![CheckCode::RET503],
            CheckCodePrefix::RET504 => vec![CheckCode::RET504],
            CheckCodePrefix::RET505 => vec![CheckCode::RET505],
            CheckCodePrefix::RET506 => vec![CheckCode::RET506],
            CheckCodePrefix::RET507 => vec![CheckCode::RET507],
            CheckCodePrefix::RET508 => vec![CheckCode::RET508],
            CheckCodePrefix::RUF => vec![
                CheckCode::RUF001,
                CheckCode::RUF002,
                CheckCode::RUF003,
                CheckCode::RUF100,
            ],
            CheckCodePrefix::RUF0 => vec![CheckCode::RUF001, CheckCode::RUF002, CheckCode::RUF003],
            CheckCodePrefix::RUF00 => vec![CheckCode::RUF001, CheckCode::RUF002, CheckCode::RUF003],
            CheckCodePrefix::RUF001 => vec![CheckCode::RUF001],
            CheckCodePrefix::RUF002 => vec![CheckCode::RUF002],
            CheckCodePrefix::RUF003 => vec![CheckCode::RUF003],
            CheckCodePrefix::RUF1 => vec![CheckCode::RUF100],
            CheckCodePrefix::RUF10 => vec![CheckCode::RUF100],
            CheckCodePrefix::RUF100 => vec![CheckCode::RUF100],
            CheckCodePrefix::S => vec![
                CheckCode::S101,
                CheckCode::S102,
                CheckCode::S104,
                CheckCode::S105,
                CheckCode::S106,
                CheckCode::S107,
            ],
            CheckCodePrefix::S1 => vec![
                CheckCode::S101,
                CheckCode::S102,
                CheckCode::S104,
                CheckCode::S105,
                CheckCode::S106,
                CheckCode::S107,
            ],
            CheckCodePrefix::S10 => vec![
                CheckCode::S101,
                CheckCode::S102,
                CheckCode::S104,
                CheckCode::S105,
                CheckCode::S106,
                CheckCode::S107,
            ],
            CheckCodePrefix::S101 => vec![CheckCode::S101],
            CheckCodePrefix::S102 => vec![CheckCode::S102],
            CheckCodePrefix::S104 => vec![CheckCode::S104],
            CheckCodePrefix::S105 => vec![CheckCode::S105],
            CheckCodePrefix::S106 => vec![CheckCode::S106],
            CheckCodePrefix::S107 => vec![CheckCode::S107],
            CheckCodePrefix::T => vec![CheckCode::T100, CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T1 => vec![CheckCode::T100],
            CheckCodePrefix::T10 => vec![CheckCode::T100],
            CheckCodePrefix::T100 => vec![CheckCode::T100],
            CheckCodePrefix::T2 => vec![CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T20 => vec![CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T201 => vec![CheckCode::T201],
            CheckCodePrefix::T203 => vec![CheckCode::T203],
            CheckCodePrefix::U => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::U0 => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::U00 => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
            ],
            CheckCodePrefix::U001 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U001` has been renamed to `UP001`".bold()
                );
                vec![CheckCode::UP001]
            }
            CheckCodePrefix::U003 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U003` has been renamed to `UP003`".bold()
                );
                vec![CheckCode::UP003]
            }
            CheckCodePrefix::U004 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U004` has been renamed to `UP004`".bold()
                );
                vec![CheckCode::UP004]
            }
            CheckCodePrefix::U005 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U005` has been renamed to `UP005`".bold()
                );
                vec![CheckCode::UP005]
            }
            CheckCodePrefix::U006 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U006` has been renamed to `UP006`".bold()
                );
                vec![CheckCode::UP006]
            }
            CheckCodePrefix::U007 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U007` has been renamed to `UP007`".bold()
                );
                vec![CheckCode::UP007]
            }
            CheckCodePrefix::U008 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U008` has been renamed to `UP008`".bold()
                );
                vec![CheckCode::UP008]
            }
            CheckCodePrefix::U009 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U009` has been renamed to `UP009`".bold()
                );
                vec![CheckCode::UP009]
            }
            CheckCodePrefix::U01 => vec![
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::U010 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U010` has been renamed to `UP010`".bold()
                );
                vec![CheckCode::UP010]
            }
            CheckCodePrefix::U011 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U011` has been renamed to `UP011`".bold()
                );
                vec![CheckCode::UP011]
            }
            CheckCodePrefix::U012 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U012` has been renamed to `UP012`".bold()
                );
                vec![CheckCode::UP012]
            }
            CheckCodePrefix::U013 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U013` has been renamed to `UP013`".bold()
                );
                vec![CheckCode::UP013]
            }
            CheckCodePrefix::U014 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U014` has been renamed to `UP014`".bold()
                );
                vec![CheckCode::UP014]
            }
            CheckCodePrefix::U015 => {
                eprintln!(
                    "{}{} {}",
                    "warning".yellow().bold(),
                    ":".bold(),
                    "`U015` has been renamed to `UP015`".bold()
                );
                vec![CheckCode::UP015]
            }
            CheckCodePrefix::UP => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::UP0 => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::UP00 => vec![
                CheckCode::UP001,
                CheckCode::UP003,
                CheckCode::UP004,
                CheckCode::UP005,
                CheckCode::UP006,
                CheckCode::UP007,
                CheckCode::UP008,
                CheckCode::UP009,
            ],
            CheckCodePrefix::UP001 => vec![CheckCode::UP001],
            CheckCodePrefix::UP003 => vec![CheckCode::UP003],
            CheckCodePrefix::UP004 => vec![CheckCode::UP004],
            CheckCodePrefix::UP005 => vec![CheckCode::UP005],
            CheckCodePrefix::UP006 => vec![CheckCode::UP006],
            CheckCodePrefix::UP007 => vec![CheckCode::UP007],
            CheckCodePrefix::UP008 => vec![CheckCode::UP008],
            CheckCodePrefix::UP009 => vec![CheckCode::UP009],
            CheckCodePrefix::UP01 => vec![
                CheckCode::UP010,
                CheckCode::UP011,
                CheckCode::UP012,
                CheckCode::UP013,
                CheckCode::UP014,
                CheckCode::UP015,
            ],
            CheckCodePrefix::UP010 => vec![CheckCode::UP010],
            CheckCodePrefix::UP011 => vec![CheckCode::UP011],
            CheckCodePrefix::UP012 => vec![CheckCode::UP012],
            CheckCodePrefix::UP013 => vec![CheckCode::UP013],
            CheckCodePrefix::UP014 => vec![CheckCode::UP014],
            CheckCodePrefix::UP015 => vec![CheckCode::UP015],
            CheckCodePrefix::W => vec![CheckCode::W292, CheckCode::W605],
            CheckCodePrefix::W2 => vec![CheckCode::W292],
            CheckCodePrefix::W29 => vec![CheckCode::W292],
            CheckCodePrefix::W292 => vec![CheckCode::W292],
            CheckCodePrefix::W6 => vec![CheckCode::W605],
            CheckCodePrefix::W60 => vec![CheckCode::W605],
            CheckCodePrefix::W605 => vec![CheckCode::W605],
            CheckCodePrefix::YTT => vec![
                CheckCode::YTT101,
                CheckCode::YTT102,
                CheckCode::YTT103,
                CheckCode::YTT201,
                CheckCode::YTT202,
                CheckCode::YTT203,
                CheckCode::YTT204,
                CheckCode::YTT301,
                CheckCode::YTT302,
                CheckCode::YTT303,
            ],
            CheckCodePrefix::YTT1 => vec![CheckCode::YTT101, CheckCode::YTT102, CheckCode::YTT103],
            CheckCodePrefix::YTT10 => vec![CheckCode::YTT101, CheckCode::YTT102, CheckCode::YTT103],
            CheckCodePrefix::YTT101 => vec![CheckCode::YTT101],
            CheckCodePrefix::YTT102 => vec![CheckCode::YTT102],
            CheckCodePrefix::YTT103 => vec![CheckCode::YTT103],
            CheckCodePrefix::YTT2 => vec![
                CheckCode::YTT201,
                CheckCode::YTT202,
                CheckCode::YTT203,
                CheckCode::YTT204,
            ],
            CheckCodePrefix::YTT20 => vec![
                CheckCode::YTT201,
                CheckCode::YTT202,
                CheckCode::YTT203,
                CheckCode::YTT204,
            ],
            CheckCodePrefix::YTT201 => vec![CheckCode::YTT201],
            CheckCodePrefix::YTT202 => vec![CheckCode::YTT202],
            CheckCodePrefix::YTT203 => vec![CheckCode::YTT203],
            CheckCodePrefix::YTT204 => vec![CheckCode::YTT204],
            CheckCodePrefix::YTT3 => vec![CheckCode::YTT301, CheckCode::YTT302, CheckCode::YTT303],
            CheckCodePrefix::YTT30 => vec![CheckCode::YTT301, CheckCode::YTT302, CheckCode::YTT303],
            CheckCodePrefix::YTT301 => vec![CheckCode::YTT301],
            CheckCodePrefix::YTT302 => vec![CheckCode::YTT302],
            CheckCodePrefix::YTT303 => vec![CheckCode::YTT303],
        }
    }
}

impl CheckCodePrefix {
    pub fn specificity(&self) -> SuffixLength {
        #[allow(clippy::match_same_arms)]
        match self {
            CheckCodePrefix::A => SuffixLength::Zero,
            CheckCodePrefix::A0 => SuffixLength::One,
            CheckCodePrefix::A00 => SuffixLength::Two,
            CheckCodePrefix::A001 => SuffixLength::Three,
            CheckCodePrefix::A002 => SuffixLength::Three,
            CheckCodePrefix::A003 => SuffixLength::Three,
            CheckCodePrefix::ANN => SuffixLength::Zero,
            CheckCodePrefix::ANN0 => SuffixLength::One,
            CheckCodePrefix::ANN00 => SuffixLength::Two,
            CheckCodePrefix::ANN001 => SuffixLength::Three,
            CheckCodePrefix::ANN002 => SuffixLength::Three,
            CheckCodePrefix::ANN003 => SuffixLength::Three,
            CheckCodePrefix::ANN1 => SuffixLength::One,
            CheckCodePrefix::ANN10 => SuffixLength::Two,
            CheckCodePrefix::ANN101 => SuffixLength::Three,
            CheckCodePrefix::ANN102 => SuffixLength::Three,
            CheckCodePrefix::ANN2 => SuffixLength::One,
            CheckCodePrefix::ANN20 => SuffixLength::Two,
            CheckCodePrefix::ANN201 => SuffixLength::Three,
            CheckCodePrefix::ANN202 => SuffixLength::Three,
            CheckCodePrefix::ANN204 => SuffixLength::Three,
            CheckCodePrefix::ANN205 => SuffixLength::Three,
            CheckCodePrefix::ANN206 => SuffixLength::Three,
            CheckCodePrefix::ANN4 => SuffixLength::One,
            CheckCodePrefix::ANN40 => SuffixLength::Two,
            CheckCodePrefix::ANN401 => SuffixLength::Three,
            CheckCodePrefix::B => SuffixLength::Zero,
            CheckCodePrefix::B0 => SuffixLength::One,
            CheckCodePrefix::B00 => SuffixLength::Two,
            CheckCodePrefix::B002 => SuffixLength::Three,
            CheckCodePrefix::B003 => SuffixLength::Three,
            CheckCodePrefix::B004 => SuffixLength::Three,
            CheckCodePrefix::B005 => SuffixLength::Three,
            CheckCodePrefix::B006 => SuffixLength::Three,
            CheckCodePrefix::B007 => SuffixLength::Three,
            CheckCodePrefix::B008 => SuffixLength::Three,
            CheckCodePrefix::B009 => SuffixLength::Three,
            CheckCodePrefix::B01 => SuffixLength::Two,
            CheckCodePrefix::B010 => SuffixLength::Three,
            CheckCodePrefix::B011 => SuffixLength::Three,
            CheckCodePrefix::B012 => SuffixLength::Three,
            CheckCodePrefix::B013 => SuffixLength::Three,
            CheckCodePrefix::B014 => SuffixLength::Three,
            CheckCodePrefix::B015 => SuffixLength::Three,
            CheckCodePrefix::B016 => SuffixLength::Three,
            CheckCodePrefix::B017 => SuffixLength::Three,
            CheckCodePrefix::B018 => SuffixLength::Three,
            CheckCodePrefix::B019 => SuffixLength::Three,
            CheckCodePrefix::B02 => SuffixLength::Two,
            CheckCodePrefix::B020 => SuffixLength::Three,
            CheckCodePrefix::B021 => SuffixLength::Three,
            CheckCodePrefix::B022 => SuffixLength::Three,
            CheckCodePrefix::B023 => SuffixLength::Three,
            CheckCodePrefix::B024 => SuffixLength::Three,
            CheckCodePrefix::B025 => SuffixLength::Three,
            CheckCodePrefix::B026 => SuffixLength::Three,
            CheckCodePrefix::B027 => SuffixLength::Three,
            CheckCodePrefix::B9 => SuffixLength::One,
            CheckCodePrefix::B90 => SuffixLength::Two,
            CheckCodePrefix::B904 => SuffixLength::Three,
            CheckCodePrefix::BLE => SuffixLength::Zero,
            CheckCodePrefix::BLE0 => SuffixLength::One,
            CheckCodePrefix::BLE00 => SuffixLength::Two,
            CheckCodePrefix::BLE001 => SuffixLength::Three,
            CheckCodePrefix::C => SuffixLength::Zero,
            CheckCodePrefix::C4 => SuffixLength::One,
            CheckCodePrefix::C40 => SuffixLength::Two,
            CheckCodePrefix::C400 => SuffixLength::Three,
            CheckCodePrefix::C401 => SuffixLength::Three,
            CheckCodePrefix::C402 => SuffixLength::Three,
            CheckCodePrefix::C403 => SuffixLength::Three,
            CheckCodePrefix::C404 => SuffixLength::Three,
            CheckCodePrefix::C405 => SuffixLength::Three,
            CheckCodePrefix::C406 => SuffixLength::Three,
            CheckCodePrefix::C408 => SuffixLength::Three,
            CheckCodePrefix::C409 => SuffixLength::Three,
            CheckCodePrefix::C41 => SuffixLength::Two,
            CheckCodePrefix::C410 => SuffixLength::Three,
            CheckCodePrefix::C411 => SuffixLength::Three,
            CheckCodePrefix::C413 => SuffixLength::Three,
            CheckCodePrefix::C414 => SuffixLength::Three,
            CheckCodePrefix::C415 => SuffixLength::Three,
            CheckCodePrefix::C416 => SuffixLength::Three,
            CheckCodePrefix::C417 => SuffixLength::Three,
            CheckCodePrefix::C9 => SuffixLength::One,
            CheckCodePrefix::C90 => SuffixLength::Two,
            CheckCodePrefix::C901 => SuffixLength::Three,
            CheckCodePrefix::D => SuffixLength::Zero,
            CheckCodePrefix::D1 => SuffixLength::One,
            CheckCodePrefix::D10 => SuffixLength::Two,
            CheckCodePrefix::D100 => SuffixLength::Three,
            CheckCodePrefix::D101 => SuffixLength::Three,
            CheckCodePrefix::D102 => SuffixLength::Three,
            CheckCodePrefix::D103 => SuffixLength::Three,
            CheckCodePrefix::D104 => SuffixLength::Three,
            CheckCodePrefix::D105 => SuffixLength::Three,
            CheckCodePrefix::D106 => SuffixLength::Three,
            CheckCodePrefix::D107 => SuffixLength::Three,
            CheckCodePrefix::D2 => SuffixLength::One,
            CheckCodePrefix::D20 => SuffixLength::Two,
            CheckCodePrefix::D200 => SuffixLength::Three,
            CheckCodePrefix::D201 => SuffixLength::Three,
            CheckCodePrefix::D202 => SuffixLength::Three,
            CheckCodePrefix::D203 => SuffixLength::Three,
            CheckCodePrefix::D204 => SuffixLength::Three,
            CheckCodePrefix::D205 => SuffixLength::Three,
            CheckCodePrefix::D206 => SuffixLength::Three,
            CheckCodePrefix::D207 => SuffixLength::Three,
            CheckCodePrefix::D208 => SuffixLength::Three,
            CheckCodePrefix::D209 => SuffixLength::Three,
            CheckCodePrefix::D21 => SuffixLength::Two,
            CheckCodePrefix::D210 => SuffixLength::Three,
            CheckCodePrefix::D211 => SuffixLength::Three,
            CheckCodePrefix::D212 => SuffixLength::Three,
            CheckCodePrefix::D213 => SuffixLength::Three,
            CheckCodePrefix::D214 => SuffixLength::Three,
            CheckCodePrefix::D215 => SuffixLength::Three,
            CheckCodePrefix::D3 => SuffixLength::One,
            CheckCodePrefix::D30 => SuffixLength::Two,
            CheckCodePrefix::D300 => SuffixLength::Three,
            CheckCodePrefix::D4 => SuffixLength::One,
            CheckCodePrefix::D40 => SuffixLength::Two,
            CheckCodePrefix::D400 => SuffixLength::Three,
            CheckCodePrefix::D402 => SuffixLength::Three,
            CheckCodePrefix::D403 => SuffixLength::Three,
            CheckCodePrefix::D404 => SuffixLength::Three,
            CheckCodePrefix::D405 => SuffixLength::Three,
            CheckCodePrefix::D406 => SuffixLength::Three,
            CheckCodePrefix::D407 => SuffixLength::Three,
            CheckCodePrefix::D408 => SuffixLength::Three,
            CheckCodePrefix::D409 => SuffixLength::Three,
            CheckCodePrefix::D41 => SuffixLength::Two,
            CheckCodePrefix::D410 => SuffixLength::Three,
            CheckCodePrefix::D411 => SuffixLength::Three,
            CheckCodePrefix::D412 => SuffixLength::Three,
            CheckCodePrefix::D413 => SuffixLength::Three,
            CheckCodePrefix::D414 => SuffixLength::Three,
            CheckCodePrefix::D415 => SuffixLength::Three,
            CheckCodePrefix::D416 => SuffixLength::Three,
            CheckCodePrefix::D417 => SuffixLength::Three,
            CheckCodePrefix::D418 => SuffixLength::Three,
            CheckCodePrefix::D419 => SuffixLength::Three,
            CheckCodePrefix::E => SuffixLength::Zero,
            CheckCodePrefix::E4 => SuffixLength::One,
            CheckCodePrefix::E40 => SuffixLength::Two,
            CheckCodePrefix::E402 => SuffixLength::Three,
            CheckCodePrefix::E5 => SuffixLength::One,
            CheckCodePrefix::E50 => SuffixLength::Two,
            CheckCodePrefix::E501 => SuffixLength::Three,
            CheckCodePrefix::E7 => SuffixLength::One,
            CheckCodePrefix::E71 => SuffixLength::Two,
            CheckCodePrefix::E711 => SuffixLength::Three,
            CheckCodePrefix::E712 => SuffixLength::Three,
            CheckCodePrefix::E713 => SuffixLength::Three,
            CheckCodePrefix::E714 => SuffixLength::Three,
            CheckCodePrefix::E72 => SuffixLength::Two,
            CheckCodePrefix::E721 => SuffixLength::Three,
            CheckCodePrefix::E722 => SuffixLength::Three,
            CheckCodePrefix::E73 => SuffixLength::Two,
            CheckCodePrefix::E731 => SuffixLength::Three,
            CheckCodePrefix::E74 => SuffixLength::Two,
            CheckCodePrefix::E741 => SuffixLength::Three,
            CheckCodePrefix::E742 => SuffixLength::Three,
            CheckCodePrefix::E743 => SuffixLength::Three,
            CheckCodePrefix::E9 => SuffixLength::One,
            CheckCodePrefix::E90 => SuffixLength::Two,
            CheckCodePrefix::E902 => SuffixLength::Three,
            CheckCodePrefix::E99 => SuffixLength::Two,
            CheckCodePrefix::E999 => SuffixLength::Three,
            CheckCodePrefix::ERA => SuffixLength::Zero,
            CheckCodePrefix::ERA0 => SuffixLength::One,
            CheckCodePrefix::ERA00 => SuffixLength::Two,
            CheckCodePrefix::ERA001 => SuffixLength::Three,
            CheckCodePrefix::F => SuffixLength::Zero,
            CheckCodePrefix::F4 => SuffixLength::One,
            CheckCodePrefix::F40 => SuffixLength::Two,
            CheckCodePrefix::F401 => SuffixLength::Three,
            CheckCodePrefix::F402 => SuffixLength::Three,
            CheckCodePrefix::F403 => SuffixLength::Three,
            CheckCodePrefix::F404 => SuffixLength::Three,
            CheckCodePrefix::F405 => SuffixLength::Three,
            CheckCodePrefix::F406 => SuffixLength::Three,
            CheckCodePrefix::F407 => SuffixLength::Three,
            CheckCodePrefix::F5 => SuffixLength::One,
            CheckCodePrefix::F50 => SuffixLength::Two,
            CheckCodePrefix::F501 => SuffixLength::Three,
            CheckCodePrefix::F502 => SuffixLength::Three,
            CheckCodePrefix::F503 => SuffixLength::Three,
            CheckCodePrefix::F504 => SuffixLength::Three,
            CheckCodePrefix::F505 => SuffixLength::Three,
            CheckCodePrefix::F506 => SuffixLength::Three,
            CheckCodePrefix::F507 => SuffixLength::Three,
            CheckCodePrefix::F508 => SuffixLength::Three,
            CheckCodePrefix::F509 => SuffixLength::Three,
            CheckCodePrefix::F52 => SuffixLength::Two,
            CheckCodePrefix::F521 => SuffixLength::Three,
            CheckCodePrefix::F522 => SuffixLength::Three,
            CheckCodePrefix::F523 => SuffixLength::Three,
            CheckCodePrefix::F524 => SuffixLength::Three,
            CheckCodePrefix::F525 => SuffixLength::Three,
            CheckCodePrefix::F54 => SuffixLength::Two,
            CheckCodePrefix::F541 => SuffixLength::Three,
            CheckCodePrefix::F6 => SuffixLength::One,
            CheckCodePrefix::F60 => SuffixLength::Two,
            CheckCodePrefix::F601 => SuffixLength::Three,
            CheckCodePrefix::F602 => SuffixLength::Three,
            CheckCodePrefix::F62 => SuffixLength::Two,
            CheckCodePrefix::F621 => SuffixLength::Three,
            CheckCodePrefix::F622 => SuffixLength::Three,
            CheckCodePrefix::F63 => SuffixLength::Two,
            CheckCodePrefix::F631 => SuffixLength::Three,
            CheckCodePrefix::F632 => SuffixLength::Three,
            CheckCodePrefix::F633 => SuffixLength::Three,
            CheckCodePrefix::F634 => SuffixLength::Three,
            CheckCodePrefix::F7 => SuffixLength::One,
            CheckCodePrefix::F70 => SuffixLength::Two,
            CheckCodePrefix::F701 => SuffixLength::Three,
            CheckCodePrefix::F702 => SuffixLength::Three,
            CheckCodePrefix::F704 => SuffixLength::Three,
            CheckCodePrefix::F706 => SuffixLength::Three,
            CheckCodePrefix::F707 => SuffixLength::Three,
            CheckCodePrefix::F72 => SuffixLength::Two,
            CheckCodePrefix::F722 => SuffixLength::Three,
            CheckCodePrefix::F8 => SuffixLength::One,
            CheckCodePrefix::F82 => SuffixLength::Two,
            CheckCodePrefix::F821 => SuffixLength::Three,
            CheckCodePrefix::F822 => SuffixLength::Three,
            CheckCodePrefix::F823 => SuffixLength::Three,
            CheckCodePrefix::F83 => SuffixLength::Two,
            CheckCodePrefix::F831 => SuffixLength::Three,
            CheckCodePrefix::F84 => SuffixLength::Two,
            CheckCodePrefix::F841 => SuffixLength::Three,
            CheckCodePrefix::F9 => SuffixLength::One,
            CheckCodePrefix::F90 => SuffixLength::Two,
            CheckCodePrefix::F901 => SuffixLength::Three,
            CheckCodePrefix::FBT => SuffixLength::Zero,
            CheckCodePrefix::FBT0 => SuffixLength::One,
            CheckCodePrefix::FBT00 => SuffixLength::Two,
            CheckCodePrefix::FBT001 => SuffixLength::Three,
            CheckCodePrefix::FBT002 => SuffixLength::Three,
            CheckCodePrefix::FBT003 => SuffixLength::Three,
            CheckCodePrefix::I => SuffixLength::Zero,
            CheckCodePrefix::I0 => SuffixLength::One,
            CheckCodePrefix::I00 => SuffixLength::Two,
            CheckCodePrefix::I001 => SuffixLength::Three,
            CheckCodePrefix::I2 => SuffixLength::One,
            CheckCodePrefix::I25 => SuffixLength::Two,
            CheckCodePrefix::I252 => SuffixLength::Three,
            CheckCodePrefix::N => SuffixLength::Zero,
            CheckCodePrefix::N8 => SuffixLength::One,
            CheckCodePrefix::N80 => SuffixLength::Two,
            CheckCodePrefix::N801 => SuffixLength::Three,
            CheckCodePrefix::N802 => SuffixLength::Three,
            CheckCodePrefix::N803 => SuffixLength::Three,
            CheckCodePrefix::N804 => SuffixLength::Three,
            CheckCodePrefix::N805 => SuffixLength::Three,
            CheckCodePrefix::N806 => SuffixLength::Three,
            CheckCodePrefix::N807 => SuffixLength::Three,
            CheckCodePrefix::N81 => SuffixLength::Two,
            CheckCodePrefix::N811 => SuffixLength::Three,
            CheckCodePrefix::N812 => SuffixLength::Three,
            CheckCodePrefix::N813 => SuffixLength::Three,
            CheckCodePrefix::N814 => SuffixLength::Three,
            CheckCodePrefix::N815 => SuffixLength::Three,
            CheckCodePrefix::N816 => SuffixLength::Three,
            CheckCodePrefix::N817 => SuffixLength::Three,
            CheckCodePrefix::N818 => SuffixLength::Three,
            CheckCodePrefix::PGH => SuffixLength::Zero,
            CheckCodePrefix::PGH0 => SuffixLength::One,
            CheckCodePrefix::PGH00 => SuffixLength::Two,
            CheckCodePrefix::PGH001 => SuffixLength::Three,
            CheckCodePrefix::PLC => SuffixLength::Zero,
            CheckCodePrefix::PLC0 => SuffixLength::One,
            CheckCodePrefix::PLC04 => SuffixLength::Two,
            CheckCodePrefix::PLC041 => SuffixLength::Three,
            CheckCodePrefix::PLC0414 => SuffixLength::Four,
            CheckCodePrefix::PLC2 => SuffixLength::One,
            CheckCodePrefix::PLC22 => SuffixLength::Two,
            CheckCodePrefix::PLC220 => SuffixLength::Three,
            CheckCodePrefix::PLC2201 => SuffixLength::Four,
            CheckCodePrefix::PLC3 => SuffixLength::One,
            CheckCodePrefix::PLC30 => SuffixLength::Two,
            CheckCodePrefix::PLC300 => SuffixLength::Three,
            CheckCodePrefix::PLC3002 => SuffixLength::Four,
            CheckCodePrefix::PLE => SuffixLength::Zero,
            CheckCodePrefix::PLE1 => SuffixLength::One,
            CheckCodePrefix::PLE11 => SuffixLength::Two,
            CheckCodePrefix::PLE114 => SuffixLength::Three,
            CheckCodePrefix::PLE1142 => SuffixLength::Four,
            CheckCodePrefix::PLR => SuffixLength::Zero,
            CheckCodePrefix::PLR0 => SuffixLength::One,
            CheckCodePrefix::PLR02 => SuffixLength::Two,
            CheckCodePrefix::PLR020 => SuffixLength::Three,
            CheckCodePrefix::PLR0206 => SuffixLength::Four,
            CheckCodePrefix::PLR04 => SuffixLength::Two,
            CheckCodePrefix::PLR040 => SuffixLength::Three,
            CheckCodePrefix::PLR0402 => SuffixLength::Four,
            CheckCodePrefix::PLR1 => SuffixLength::One,
            CheckCodePrefix::PLR17 => SuffixLength::Two,
            CheckCodePrefix::PLR170 => SuffixLength::Three,
            CheckCodePrefix::PLR1701 => SuffixLength::Four,
            CheckCodePrefix::PLR172 => SuffixLength::Three,
            CheckCodePrefix::PLR1722 => SuffixLength::Four,
            CheckCodePrefix::PLW => SuffixLength::Zero,
            CheckCodePrefix::PLW0 => SuffixLength::One,
            CheckCodePrefix::PLW01 => SuffixLength::Two,
            CheckCodePrefix::PLW012 => SuffixLength::Three,
            CheckCodePrefix::PLW0120 => SuffixLength::Four,
            CheckCodePrefix::Q => SuffixLength::Zero,
            CheckCodePrefix::Q0 => SuffixLength::One,
            CheckCodePrefix::Q00 => SuffixLength::Two,
            CheckCodePrefix::Q000 => SuffixLength::Three,
            CheckCodePrefix::Q001 => SuffixLength::Three,
            CheckCodePrefix::Q002 => SuffixLength::Three,
            CheckCodePrefix::Q003 => SuffixLength::Three,
            CheckCodePrefix::RET => SuffixLength::Zero,
            CheckCodePrefix::RET5 => SuffixLength::One,
            CheckCodePrefix::RET50 => SuffixLength::Two,
            CheckCodePrefix::RET501 => SuffixLength::Three,
            CheckCodePrefix::RET502 => SuffixLength::Three,
            CheckCodePrefix::RET503 => SuffixLength::Three,
            CheckCodePrefix::RET504 => SuffixLength::Three,
            CheckCodePrefix::RET505 => SuffixLength::Three,
            CheckCodePrefix::RET506 => SuffixLength::Three,
            CheckCodePrefix::RET507 => SuffixLength::Three,
            CheckCodePrefix::RET508 => SuffixLength::Three,
            CheckCodePrefix::RUF => SuffixLength::Zero,
            CheckCodePrefix::RUF0 => SuffixLength::One,
            CheckCodePrefix::RUF00 => SuffixLength::Two,
            CheckCodePrefix::RUF001 => SuffixLength::Three,
            CheckCodePrefix::RUF002 => SuffixLength::Three,
            CheckCodePrefix::RUF003 => SuffixLength::Three,
            CheckCodePrefix::RUF1 => SuffixLength::One,
            CheckCodePrefix::RUF10 => SuffixLength::Two,
            CheckCodePrefix::RUF100 => SuffixLength::Three,
            CheckCodePrefix::S => SuffixLength::Zero,
            CheckCodePrefix::S1 => SuffixLength::One,
            CheckCodePrefix::S10 => SuffixLength::Two,
            CheckCodePrefix::S101 => SuffixLength::Three,
            CheckCodePrefix::S102 => SuffixLength::Three,
            CheckCodePrefix::S104 => SuffixLength::Three,
            CheckCodePrefix::S105 => SuffixLength::Three,
            CheckCodePrefix::S106 => SuffixLength::Three,
            CheckCodePrefix::S107 => SuffixLength::Three,
            CheckCodePrefix::T => SuffixLength::Zero,
            CheckCodePrefix::T1 => SuffixLength::One,
            CheckCodePrefix::T10 => SuffixLength::Two,
            CheckCodePrefix::T100 => SuffixLength::Three,
            CheckCodePrefix::T2 => SuffixLength::One,
            CheckCodePrefix::T20 => SuffixLength::Two,
            CheckCodePrefix::T201 => SuffixLength::Three,
            CheckCodePrefix::T203 => SuffixLength::Three,
            CheckCodePrefix::U => SuffixLength::Zero,
            CheckCodePrefix::U0 => SuffixLength::One,
            CheckCodePrefix::U00 => SuffixLength::Two,
            CheckCodePrefix::U001 => SuffixLength::Three,
            CheckCodePrefix::U003 => SuffixLength::Three,
            CheckCodePrefix::U004 => SuffixLength::Three,
            CheckCodePrefix::U005 => SuffixLength::Three,
            CheckCodePrefix::U006 => SuffixLength::Three,
            CheckCodePrefix::U007 => SuffixLength::Three,
            CheckCodePrefix::U008 => SuffixLength::Three,
            CheckCodePrefix::U009 => SuffixLength::Three,
            CheckCodePrefix::U01 => SuffixLength::Two,
            CheckCodePrefix::U010 => SuffixLength::Three,
            CheckCodePrefix::U011 => SuffixLength::Three,
            CheckCodePrefix::U012 => SuffixLength::Three,
            CheckCodePrefix::U013 => SuffixLength::Three,
            CheckCodePrefix::U014 => SuffixLength::Three,
            CheckCodePrefix::U015 => SuffixLength::Three,
            CheckCodePrefix::UP => SuffixLength::Zero,
            CheckCodePrefix::UP0 => SuffixLength::One,
            CheckCodePrefix::UP00 => SuffixLength::Two,
            CheckCodePrefix::UP001 => SuffixLength::Three,
            CheckCodePrefix::UP003 => SuffixLength::Three,
            CheckCodePrefix::UP004 => SuffixLength::Three,
            CheckCodePrefix::UP005 => SuffixLength::Three,
            CheckCodePrefix::UP006 => SuffixLength::Three,
            CheckCodePrefix::UP007 => SuffixLength::Three,
            CheckCodePrefix::UP008 => SuffixLength::Three,
            CheckCodePrefix::UP009 => SuffixLength::Three,
            CheckCodePrefix::UP01 => SuffixLength::Two,
            CheckCodePrefix::UP010 => SuffixLength::Three,
            CheckCodePrefix::UP011 => SuffixLength::Three,
            CheckCodePrefix::UP012 => SuffixLength::Three,
            CheckCodePrefix::UP013 => SuffixLength::Three,
            CheckCodePrefix::UP014 => SuffixLength::Three,
            CheckCodePrefix::UP015 => SuffixLength::Three,
            CheckCodePrefix::W => SuffixLength::Zero,
            CheckCodePrefix::W2 => SuffixLength::One,
            CheckCodePrefix::W29 => SuffixLength::Two,
            CheckCodePrefix::W292 => SuffixLength::Three,
            CheckCodePrefix::W6 => SuffixLength::One,
            CheckCodePrefix::W60 => SuffixLength::Two,
            CheckCodePrefix::W605 => SuffixLength::Three,
            CheckCodePrefix::YTT => SuffixLength::Zero,
            CheckCodePrefix::YTT1 => SuffixLength::One,
            CheckCodePrefix::YTT10 => SuffixLength::Two,
            CheckCodePrefix::YTT101 => SuffixLength::Three,
            CheckCodePrefix::YTT102 => SuffixLength::Three,
            CheckCodePrefix::YTT103 => SuffixLength::Three,
            CheckCodePrefix::YTT2 => SuffixLength::One,
            CheckCodePrefix::YTT20 => SuffixLength::Two,
            CheckCodePrefix::YTT201 => SuffixLength::Three,
            CheckCodePrefix::YTT202 => SuffixLength::Three,
            CheckCodePrefix::YTT203 => SuffixLength::Three,
            CheckCodePrefix::YTT204 => SuffixLength::Three,
            CheckCodePrefix::YTT3 => SuffixLength::One,
            CheckCodePrefix::YTT30 => SuffixLength::Two,
            CheckCodePrefix::YTT301 => SuffixLength::Three,
            CheckCodePrefix::YTT302 => SuffixLength::Three,
            CheckCodePrefix::YTT303 => SuffixLength::Three,
        }
    }
}

pub const CATEGORIES: &[CheckCodePrefix] = &[
    CheckCodePrefix::A,
    CheckCodePrefix::ANN,
    CheckCodePrefix::B,
    CheckCodePrefix::BLE,
    CheckCodePrefix::C,
    CheckCodePrefix::D,
    CheckCodePrefix::E,
    CheckCodePrefix::ERA,
    CheckCodePrefix::F,
    CheckCodePrefix::FBT,
    CheckCodePrefix::I,
    CheckCodePrefix::N,
    CheckCodePrefix::PGH,
    CheckCodePrefix::PLC,
    CheckCodePrefix::PLE,
    CheckCodePrefix::PLR,
    CheckCodePrefix::PLW,
    CheckCodePrefix::Q,
    CheckCodePrefix::RET,
    CheckCodePrefix::RUF,
    CheckCodePrefix::S,
    CheckCodePrefix::T,
    CheckCodePrefix::U,
    CheckCodePrefix::UP,
    CheckCodePrefix::W,
    CheckCodePrefix::YTT,
];
