def init_params_dict(itk_viewer):
    return {
        'annotations': itk_viewer.setAnnotationsEnabled,
        'axes': itk_viewer.setAxesEnabled,
        'bg_color': itk_viewer.setBackgroundColor,
        'blend_mode': itk_viewer.setImageBlendMode,
        'cmap': itk_viewer.setImageColorMap,
        'color_range': itk_viewer.setImageColorRange,
        'color_bounds': itk_viewer.setImageColorRangeBounds,
        'component_visible': itk_viewer.setImageComponentVisibility,
        'gradient_opacity': itk_viewer.setImageGradientOpacity,
        'gradient_opacity_scale': itk_viewer.setImageGradientOpacityScale,
        'interpolation': itk_viewer.setImageInterpolationEnabled,
        'gaussians': itk_viewer.setImagePiecewiseFunctionGaussians,
        'shadow_enabled': itk_viewer.setImageShadowEnabled,
        'sample_distance': itk_viewer.setImageVolumeSampleDistance,
        'label_blend': itk_viewer.setLabelImageBlend,
        'label_names': itk_viewer.setLabelImageLabelNames,
        'label_lut': itk_viewer.setLabelImageLookupTable,
        'label_weights': itk_viewer.setLabelImageWeights,
        'layer': itk_viewer.selectLayer,
        'layer_visible': itk_viewer.setLayerVisibility,
        'container_style': itk_viewer.setRenderingViewContainerStyle,
        'rotate': itk_viewer.setRotateEnabled,
        'ui_collapsed': itk_viewer.setUICollapsed,
        'units': itk_viewer.setUnits,
        'view_mode': itk_viewer.setViewMode,
        'x_slice': itk_viewer.setXSlice,
        'y_slice': itk_viewer.setYSlice,
        'z_slice': itk_viewer.setZSlice,
    }

def init_key_aliases():
    return {
        'data': 'image',
        'image': 'image',
        'label_image': 'labelImage',
        'point_sets': 'pointSets',
    }
