import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BasicSiteConfiguration {
    /**
     * local path to the website folder you want to deploy on S3.
     *
     * @stability stable
     */
    readonly websiteFolder: string;
    /**
     * the index docuement of your S3 Bucket.
     *
     * @stability stable
     */
    readonly indexDoc: string;
    /**
     * the error document of your S3 Bucket.
     *
     * @stability stable
     */
    readonly errorDoc?: string;
    /**
     * enable encryption for files in your S3 Bucket.
     *
     * @stability stable
     */
    readonly encryptBucket?: boolean;
    /**
     * the domain you want to deploy to.
     *
     * @stability stable
     */
    readonly websiteDomain?: string;
    /**
     * the subdomain you want to deploy to.
     *
     * @stability stable
     */
    readonly websiteSubDomain?: string;
}
/**
 * @stability stable
 */
export interface CloudfrontSiteConfiguration {
    /**
     * local path to the website folder you want to deploy on S3.
     *
     * @stability stable
     */
    readonly websiteFolder: string;
    /**
     * the index docuement of your CloudFront distribution.
     *
     * @stability stable
     */
    readonly indexDoc: string;
    /**
     * the error document of your CloudFront distribution.
     *
     * @stability stable
     */
    readonly errorDoc?: string;
    /**
     * enable encryption for files in your S3 Bucket.
     *
     * @stability stable
     */
    readonly encryptBucket?: boolean;
    /**
     * hosted zone used to create the DNS record of your CloudFront distribution.
     *
     * @stability stable
     */
    readonly hostedZoneDomain: string;
    /**
     * the domain you want to deploy to.
     *
     * @stability stable
     */
    readonly websiteDomain: string;
    /**
     * the price class determines how many edge locations CloudFront will use for your distribution.
     *
     * default value is PriceClass_100.
     * See https://aws.amazon.com/cloudfront/pricing/ for full list of supported regions.
     *
     * @stability stable
     */
    readonly priceClass?: cloudfront.PriceClass;
}
/**
 * @stability stable
 */
export declare class CreateBasicSite extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: BasicSiteConfiguration);
}
/**
 * @stability stable
 */
export declare class CreateCloudfrontSite extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: CloudfrontSiteConfiguration);
}
