# -*- coding: utf-8 -*-
"""`Concordance between SKD2002 and NACE2 <https://www.stat.si/dokument/5636/SKD2002-SKD2008-EN.xls>`_.
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import SKD2002

SKD2002_to_NACE2 = Concordance(
    src=SKD2002,
    dst=NACE2,
    concordances=[
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.11")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.12")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.13")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.14")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.15")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.16")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.19")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.28")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.63")),
        ((Standards.SKD2002, "01.110"), (Standards.NACE2, "01.64")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.11")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.13")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.19")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.25")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.28")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.30")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "01.64")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "02.10")),
        ((Standards.SKD2002, "01.120"), (Standards.NACE2, "02.30")),
        ((Standards.SKD2002, "01.131"), (Standards.NACE2, "01.21")),
        ((Standards.SKD2002, "01.131"), (Standards.NACE2, "11.02")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.22")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.23")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.24")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.25")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.26")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.27")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.28")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "01.64")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "02.30")),
        ((Standards.SKD2002, "01.132"), (Standards.NACE2, "10.41")),
        ((Standards.SKD2002, "01.210"), (Standards.NACE2, "01.41")),
        ((Standards.SKD2002, "01.210"), (Standards.NACE2, "01.42")),
        ((Standards.SKD2002, "01.220"), (Standards.NACE2, "01.43")),
        ((Standards.SKD2002, "01.220"), (Standards.NACE2, "01.45")),
        ((Standards.SKD2002, "01.230"), (Standards.NACE2, "01.46")),
        ((Standards.SKD2002, "01.240"), (Standards.NACE2, "01.47")),
        ((Standards.SKD2002, "01.250"), (Standards.NACE2, "01.44")),
        ((Standards.SKD2002, "01.250"), (Standards.NACE2, "01.49")),
        ((Standards.SKD2002, "01.250"), (Standards.NACE2, "03.22")),
        ((Standards.SKD2002, "01.300"), (Standards.NACE2, "01.50")),
        ((Standards.SKD2002, "01.411"), (Standards.NACE2, "81.30")),
        ((Standards.SKD2002, "01.412"), (Standards.NACE2, "01.61")),
        ((Standards.SKD2002, "01.412"), (Standards.NACE2, "01.63")),
        ((Standards.SKD2002, "01.412"), (Standards.NACE2, "01.64")),
        ((Standards.SKD2002, "01.412"), (Standards.NACE2, "10.39")),
        ((Standards.SKD2002, "01.420"), (Standards.NACE2, "01.62")),
        ((Standards.SKD2002, "01.500"), (Standards.NACE2, "01.70")),
        ((Standards.SKD2002, "01.500"), (Standards.NACE2, "94.99")),
        ((Standards.SKD2002, "02.010"), (Standards.NACE2, "01.29")),
        ((Standards.SKD2002, "02.010"), (Standards.NACE2, "02.10")),
        ((Standards.SKD2002, "02.010"), (Standards.NACE2, "02.20")),
        ((Standards.SKD2002, "02.010"), (Standards.NACE2, "02.30")),
        ((Standards.SKD2002, "02.010"), (Standards.NACE2, "16.10")),
        ((Standards.SKD2002, "02.020"), (Standards.NACE2, "02.40")),
        ((Standards.SKD2002, "05.010"), (Standards.NACE2, "03.11")),
        ((Standards.SKD2002, "05.010"), (Standards.NACE2, "03.12")),
        ((Standards.SKD2002, "05.020"), (Standards.NACE2, "03.21")),
        ((Standards.SKD2002, "05.020"), (Standards.NACE2, "03.22")),
        ((Standards.SKD2002, "10.100"), (Standards.NACE2, "05.10")),
        ((Standards.SKD2002, "10.100"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "10.100"), (Standards.NACE2, "19.20")),
        ((Standards.SKD2002, "10.200"), (Standards.NACE2, "05.20")),
        ((Standards.SKD2002, "10.200"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "10.200"), (Standards.NACE2, "19.20")),
        ((Standards.SKD2002, "10.300"), (Standards.NACE2, "08.92")),
        ((Standards.SKD2002, "10.300"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "10.300"), (Standards.NACE2, "19.20")),
        ((Standards.SKD2002, "11.100"), (Standards.NACE2, "06.10")),
        ((Standards.SKD2002, "11.100"), (Standards.NACE2, "06.20")),
        ((Standards.SKD2002, "11.100"), (Standards.NACE2, "09.10")),
        ((Standards.SKD2002, "11.200"), (Standards.NACE2, "09.10")),
        ((Standards.SKD2002, "12.000"), (Standards.NACE2, "07.21")),
        ((Standards.SKD2002, "12.000"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "13.100"), (Standards.NACE2, "07.10")),
        ((Standards.SKD2002, "13.100"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "13.200"), (Standards.NACE2, "07.29")),
        ((Standards.SKD2002, "13.200"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.110"), (Standards.NACE2, "08.11")),
        ((Standards.SKD2002, "14.110"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.120"), (Standards.NACE2, "08.11")),
        ((Standards.SKD2002, "14.120"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.130"), (Standards.NACE2, "08.11")),
        ((Standards.SKD2002, "14.130"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.210"), (Standards.NACE2, "08.12")),
        ((Standards.SKD2002, "14.210"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.220"), (Standards.NACE2, "08.12")),
        ((Standards.SKD2002, "14.220"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.300"), (Standards.NACE2, "08.91")),
        ((Standards.SKD2002, "14.300"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.400"), (Standards.NACE2, "08.93")),
        ((Standards.SKD2002, "14.400"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "14.400"), (Standards.NACE2, "10.84")),
        ((Standards.SKD2002, "14.500"), (Standards.NACE2, "08.99")),
        ((Standards.SKD2002, "14.500"), (Standards.NACE2, "09.90")),
        ((Standards.SKD2002, "15.110"), (Standards.NACE2, "10.11")),
        ((Standards.SKD2002, "15.120"), (Standards.NACE2, "10.11")),
        ((Standards.SKD2002, "15.120"), (Standards.NACE2, "10.12")),
        ((Standards.SKD2002, "15.130"), (Standards.NACE2, "10.13")),
        ((Standards.SKD2002, "15.130"), (Standards.NACE2, "10.85")),
        ((Standards.SKD2002, "15.130"), (Standards.NACE2, "10.89")),
        ((Standards.SKD2002, "15.200"), (Standards.NACE2, "10.20")),
        ((Standards.SKD2002, "15.200"), (Standards.NACE2, "10.85")),
        ((Standards.SKD2002, "15.310"), (Standards.NACE2, "10.31")),
        ((Standards.SKD2002, "15.320"), (Standards.NACE2, "10.32")),
        ((Standards.SKD2002, "15.330"), (Standards.NACE2, "10.39")),
        ((Standards.SKD2002, "15.330"), (Standards.NACE2, "10.85")),
        ((Standards.SKD2002, "15.410"), (Standards.NACE2, "10.41")),
        ((Standards.SKD2002, "15.420"), (Standards.NACE2, "10.41")),
        ((Standards.SKD2002, "15.430"), (Standards.NACE2, "10.42")),
        ((Standards.SKD2002, "15.510"), (Standards.NACE2, "10.51")),
        ((Standards.SKD2002, "15.520"), (Standards.NACE2, "10.52")),
        ((Standards.SKD2002, "15.610"), (Standards.NACE2, "10.61")),
        ((Standards.SKD2002, "15.710"), (Standards.NACE2, "10.91")),
        ((Standards.SKD2002, "15.720"), (Standards.NACE2, "10.92")),
        ((Standards.SKD2002, "15.810"), (Standards.NACE2, "10.71")),
        ((Standards.SKD2002, "15.810"), (Standards.NACE2, "10.85")),
        ((Standards.SKD2002, "15.820"), (Standards.NACE2, "10.72")),
        ((Standards.SKD2002, "15.830"), (Standards.NACE2, "10.81")),
        ((Standards.SKD2002, "15.840"), (Standards.NACE2, "10.82")),
        ((Standards.SKD2002, "15.850"), (Standards.NACE2, "10.73")),
        ((Standards.SKD2002, "15.860"), (Standards.NACE2, "10.83")),
        ((Standards.SKD2002, "15.870"), (Standards.NACE2, "10.84")),
        ((Standards.SKD2002, "15.880"), (Standards.NACE2, "10.86")),
        ((Standards.SKD2002, "15.890"), (Standards.NACE2, "10.89")),
        ((Standards.SKD2002, "15.910"), (Standards.NACE2, "11.01")),
        ((Standards.SKD2002, "15.920"), (Standards.NACE2, "20.14")),
        ((Standards.SKD2002, "15.930"), (Standards.NACE2, "11.02")),
        ((Standards.SKD2002, "15.940"), (Standards.NACE2, "11.03")),
        ((Standards.SKD2002, "15.950"), (Standards.NACE2, "11.04")),
        ((Standards.SKD2002, "15.960"), (Standards.NACE2, "11.05")),
        ((Standards.SKD2002, "15.970"), (Standards.NACE2, "11.06")),
        ((Standards.SKD2002, "15.980"), (Standards.NACE2, "11.07")),
        ((Standards.SKD2002, "16.000"), (Standards.NACE2, "12.00")),
        ((Standards.SKD2002, "17.100"), (Standards.NACE2, "13.10")),
        ((Standards.SKD2002, "17.20"), (Standards.NACE2, "13.20")),
        ((Standards.SKD2002, "17.300"), (Standards.NACE2, "13.30")),
        ((Standards.SKD2002, "17.400"), (Standards.NACE2, "13.92")),
        ((Standards.SKD2002, "17.400"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "17.400"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "17.400"), (Standards.NACE2, "95.29")),
        ((Standards.SKD2002, "17.510"), (Standards.NACE2, "13.93")),
        ((Standards.SKD2002, "17.520"), (Standards.NACE2, "13.94")),
        ((Standards.SKD2002, "17.520"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "17.530"), (Standards.NACE2, "13.95")),
        ((Standards.SKD2002, "17.540"), (Standards.NACE2, "13.96")),
        ((Standards.SKD2002, "17.540"), (Standards.NACE2, "13.99")),
        ((Standards.SKD2002, "17.540"), (Standards.NACE2, "17.22")),
        ((Standards.SKD2002, "17.600"), (Standards.NACE2, "13.91")),
        ((Standards.SKD2002, "17.710"), (Standards.NACE2, "14.19")),
        ((Standards.SKD2002, "17.710"), (Standards.NACE2, "14.31")),
        ((Standards.SKD2002, "17.720"), (Standards.NACE2, "14.39")),
        ((Standards.SKD2002, "18.100"), (Standards.NACE2, "14.11")),
        ((Standards.SKD2002, "18.100"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "18.210"), (Standards.NACE2, "14.12")),
        ((Standards.SKD2002, "18.220"), (Standards.NACE2, "14.13")),
        ((Standards.SKD2002, "18.230"), (Standards.NACE2, "14.14")),
        ((Standards.SKD2002, "18.240"), (Standards.NACE2, "14.19")),
        ((Standards.SKD2002, "18.240"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "18.300"), (Standards.NACE2, "13.20")),
        ((Standards.SKD2002, "18.300"), (Standards.NACE2, "13.91")),
        ((Standards.SKD2002, "18.300"), (Standards.NACE2, "14.20")),
        ((Standards.SKD2002, "18.300"), (Standards.NACE2, "15.11")),
        ((Standards.SKD2002, "19.100"), (Standards.NACE2, "15.11")),
        ((Standards.SKD2002, "19.200"), (Standards.NACE2, "15.12")),
        ((Standards.SKD2002, "19.200"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "19.300"), (Standards.NACE2, "15.20")),
        ((Standards.SKD2002, "19.300"), (Standards.NACE2, "16.29")),
        ((Standards.SKD2002, "19.300"), (Standards.NACE2, "22.19")),
        ((Standards.SKD2002, "19.300"), (Standards.NACE2, "22.29")),
        ((Standards.SKD2002, "20.100"), (Standards.NACE2, "16.10")),
        ((Standards.SKD2002, "20.200"), (Standards.NACE2, "16.21")),
        ((Standards.SKD2002, "20.300"), (Standards.NACE2, "16.22")),
        ((Standards.SKD2002, "20.300"), (Standards.NACE2, "16.23")),
        ((Standards.SKD2002, "20.300"), (Standards.NACE2, "43.32")),
        ((Standards.SKD2002, "20.400"), (Standards.NACE2, "16.24")),
        ((Standards.SKD2002, "20.400"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "20.510"), (Standards.NACE2, "16.29")),
        ((Standards.SKD2002, "20.510"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "20.510"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "21.110"), (Standards.NACE2, "17.11")),
        ((Standards.SKD2002, "21.120"), (Standards.NACE2, "17.12")),
        ((Standards.SKD2002, "21.210"), (Standards.NACE2, "17.21")),
        ((Standards.SKD2002, "21.220"), (Standards.NACE2, "17.22")),
        ((Standards.SKD2002, "21.230"), (Standards.NACE2, "17.23")),
        ((Standards.SKD2002, "21.240"), (Standards.NACE2, "17.24")),
        ((Standards.SKD2002, "21.250"), (Standards.NACE2, "17.29")),
        ((Standards.SKD2002, "21.250"), (Standards.NACE2, "18.12")),
        ((Standards.SKD2002, "22.110"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "22.110"), (Standards.NACE2, "58.11")),
        ((Standards.SKD2002, "22.110"), (Standards.NACE2, "58.12")),
        ((Standards.SKD2002, "22.120"), (Standards.NACE2, "58.13")),
        ((Standards.SKD2002, "22.130"), (Standards.NACE2, "58.14")),
        ((Standards.SKD2002, "22.140"), (Standards.NACE2, "59.20")),
        ((Standards.SKD2002, "22.150"), (Standards.NACE2, "58.19")),
        ((Standards.SKD2002, "22.210"), (Standards.NACE2, "18.11")),
        ((Standards.SKD2002, "22.220"), (Standards.NACE2, "17.23")),
        ((Standards.SKD2002, "22.220"), (Standards.NACE2, "18.12")),
        ((Standards.SKD2002, "22.220"), (Standards.NACE2, "58.19")),
        ((Standards.SKD2002, "22.230"), (Standards.NACE2, "18.14")),
        ((Standards.SKD2002, "22.240"), (Standards.NACE2, "18.13")),
        ((Standards.SKD2002, "22.250"), (Standards.NACE2, "18.13")),
        ((Standards.SKD2002, "22.310"), (Standards.NACE2, "18.20")),
        ((Standards.SKD2002, "22.320"), (Standards.NACE2, "18.20")),
        ((Standards.SKD2002, "22.330"), (Standards.NACE2, "18.20")),
        ((Standards.SKD2002, "23.100"), (Standards.NACE2, "19.10")),
        ((Standards.SKD2002, "23.200"), (Standards.NACE2, "19.20")),
        ((Standards.SKD2002, "23.300"), (Standards.NACE2, "20.13")),
        ((Standards.SKD2002, "23.300"), (Standards.NACE2, "24.46")),
        ((Standards.SKD2002, "23.300"), (Standards.NACE2, "38.12")),
        ((Standards.SKD2002, "23.300"), (Standards.NACE2, "38.22")),
        ((Standards.SKD2002, "24.110"), (Standards.NACE2, "20.11")),
        ((Standards.SKD2002, "24.120"), (Standards.NACE2, "20.12")),
        ((Standards.SKD2002, "24.130"), (Standards.NACE2, "20.13")),
        ((Standards.SKD2002, "24.140"), (Standards.NACE2, "19.10")),
        ((Standards.SKD2002, "24.140"), (Standards.NACE2, "20.14")),
        ((Standards.SKD2002, "24.150"), (Standards.NACE2, "20.15")),
        ((Standards.SKD2002, "24.150"), (Standards.NACE2, "38.32")),
        ((Standards.SKD2002, "24.160"), (Standards.NACE2, "20.16")),
        ((Standards.SKD2002, "24.170"), (Standards.NACE2, "20.17")),
        ((Standards.SKD2002, "24.200"), (Standards.NACE2, "20.20")),
        ((Standards.SKD2002, "24.300"), (Standards.NACE2, "20.30")),
        ((Standards.SKD2002, "24.410"), (Standards.NACE2, "21.10")),
        ((Standards.SKD2002, "24.420"), (Standards.NACE2, "21.20")),
        ((Standards.SKD2002, "24.420"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "24.510"), (Standards.NACE2, "20.41")),
        ((Standards.SKD2002, "24.510"), (Standards.NACE2, "20.42")),
        ((Standards.SKD2002, "24.520"), (Standards.NACE2, "20.42")),
        ((Standards.SKD2002, "24.610"), (Standards.NACE2, "20.51")),
        ((Standards.SKD2002, "24.620"), (Standards.NACE2, "20.52")),
        ((Standards.SKD2002, "24.620"), (Standards.NACE2, "20.59")),
        ((Standards.SKD2002, "24.630"), (Standards.NACE2, "20.53")),
        ((Standards.SKD2002, "24.640"), (Standards.NACE2, "20.59")),
        ((Standards.SKD2002, "24.650"), (Standards.NACE2, "26.80")),
        ((Standards.SKD2002, "24.660"), (Standards.NACE2, "20.59")),
        ((Standards.SKD2002, "24.660"), (Standards.NACE2, "26.11")),
        ((Standards.SKD2002, "24.700"), (Standards.NACE2, "20.60")),
        ((Standards.SKD2002, "25.110"), (Standards.NACE2, "22.11")),
        ((Standards.SKD2002, "25.120"), (Standards.NACE2, "22.11")),
        ((Standards.SKD2002, "25.130"), (Standards.NACE2, "22.19")),
        ((Standards.SKD2002, "25.130"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "25.130"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "25.210"), (Standards.NACE2, "22.21")),
        ((Standards.SKD2002, "25.210"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "25.210"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "25.220"), (Standards.NACE2, "22.22")),
        ((Standards.SKD2002, "25.230"), (Standards.NACE2, "22.23")),
        ((Standards.SKD2002, "25.230"), (Standards.NACE2, "43.32")),
        ((Standards.SKD2002, "25.240"), (Standards.NACE2, "22.29")),
        ((Standards.SKD2002, "25.240"), (Standards.NACE2, "26.11")),
        ((Standards.SKD2002, "25.240"), (Standards.NACE2, "27.32")),
        ((Standards.SKD2002, "25.240"), (Standards.NACE2, "27.33")),
        ((Standards.SKD2002, "25.240"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "26.110"), (Standards.NACE2, "23.11")),
        ((Standards.SKD2002, "26.120"), (Standards.NACE2, "23.12")),
        ((Standards.SKD2002, "26.130"), (Standards.NACE2, "23.13")),
        ((Standards.SKD2002, "26.140"), (Standards.NACE2, "23.14")),
        ((Standards.SKD2002, "26.150"), (Standards.NACE2, "23.19")),
        ((Standards.SKD2002, "26.150"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "26.150"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "26.210"), (Standards.NACE2, "23.41")),
        ((Standards.SKD2002, "26.220"), (Standards.NACE2, "23.42")),
        ((Standards.SKD2002, "26.230"), (Standards.NACE2, "23.43")),
        ((Standards.SKD2002, "26.240"), (Standards.NACE2, "23.44")),
        ((Standards.SKD2002, "26.250"), (Standards.NACE2, "23.49")),
        ((Standards.SKD2002, "26.260"), (Standards.NACE2, "23.20")),
        ((Standards.SKD2002, "26.300"), (Standards.NACE2, "23.31")),
        ((Standards.SKD2002, "26.400"), (Standards.NACE2, "23.32")),
        ((Standards.SKD2002, "26.400"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "26.400"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "26.510"), (Standards.NACE2, "23.51")),
        ((Standards.SKD2002, "26.520"), (Standards.NACE2, "23.52")),
        ((Standards.SKD2002, "26.530"), (Standards.NACE2, "23.52")),
        ((Standards.SKD2002, "26.610"), (Standards.NACE2, "23.61")),
        ((Standards.SKD2002, "26.620"), (Standards.NACE2, "23.62")),
        ((Standards.SKD2002, "26.630"), (Standards.NACE2, "23.63")),
        ((Standards.SKD2002, "26.640"), (Standards.NACE2, "23.64")),
        ((Standards.SKD2002, "26.650"), (Standards.NACE2, "23.65")),
        ((Standards.SKD2002, "26.660"), (Standards.NACE2, "23.69")),
        ((Standards.SKD2002, "26.700"), (Standards.NACE2, "23.70")),
        ((Standards.SKD2002, "26.810"), (Standards.NACE2, "23.91")),
        ((Standards.SKD2002, "26.810"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "26.810"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "26.820"), (Standards.NACE2, "23.99")),
        ((Standards.SKD2002, "27.100"), (Standards.NACE2, "24.10")),
        ((Standards.SKD2002, "27.210"), (Standards.NACE2, "24.51")),
        ((Standards.SKD2002, "27.220"), (Standards.NACE2, "24.20")),
        ((Standards.SKD2002, "27.310"), (Standards.NACE2, "24.31")),
        ((Standards.SKD2002, "27.320"), (Standards.NACE2, "24.32")),
        ((Standards.SKD2002, "27.330"), (Standards.NACE2, "24.33")),
        ((Standards.SKD2002, "27.340"), (Standards.NACE2, "24.34")),
        ((Standards.SKD2002, "27.410"), (Standards.NACE2, "24.41")),
        ((Standards.SKD2002, "27.420"), (Standards.NACE2, "24.42")),
        ((Standards.SKD2002, "27.430"), (Standards.NACE2, "24.43")),
        ((Standards.SKD2002, "27.440"), (Standards.NACE2, "24.44")),
        ((Standards.SKD2002, "27.450"), (Standards.NACE2, "24.45")),
        ((Standards.SKD2002, "27.510"), (Standards.NACE2, "24.51")),
        ((Standards.SKD2002, "27.520"), (Standards.NACE2, "24.52")),
        ((Standards.SKD2002, "27.530"), (Standards.NACE2, "24.53")),
        ((Standards.SKD2002, "27.540"), (Standards.NACE2, "24.54")),
        ((Standards.SKD2002, "28.110"), (Standards.NACE2, "25.11")),
        ((Standards.SKD2002, "28.110"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.120"), (Standards.NACE2, "25.12")),
        ((Standards.SKD2002, "28.120"), (Standards.NACE2, "43.32")),
        ((Standards.SKD2002, "28.210"), (Standards.NACE2, "25.29")),
        ((Standards.SKD2002, "28.210"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.220"), (Standards.NACE2, "25.21")),
        ((Standards.SKD2002, "28.220"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.300"), (Standards.NACE2, "25.30")),
        ((Standards.SKD2002, "28.300"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.400"), (Standards.NACE2, "25.50")),
        ((Standards.SKD2002, "28.511"), (Standards.NACE2, "25.61")),
        ((Standards.SKD2002, "28.512"), (Standards.NACE2, "25.61")),
        ((Standards.SKD2002, "28.520"), (Standards.NACE2, "25.62")),
        ((Standards.SKD2002, "28.610"), (Standards.NACE2, "25.71")),
        ((Standards.SKD2002, "28.610"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.621"), (Standards.NACE2, "25.73")),
        ((Standards.SKD2002, "28.621"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.622"), (Standards.NACE2, "25.73")),
        ((Standards.SKD2002, "28.630"), (Standards.NACE2, "25.72")),
        ((Standards.SKD2002, "28.630"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.710"), (Standards.NACE2, "25.91")),
        ((Standards.SKD2002, "28.710"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "28.720"), (Standards.NACE2, "25.92")),
        ((Standards.SKD2002, "28.730"), (Standards.NACE2, "25.93")),
        ((Standards.SKD2002, "28.740"), (Standards.NACE2, "25.93")),
        ((Standards.SKD2002, "28.740"), (Standards.NACE2, "25.94")),
        ((Standards.SKD2002, "28.750"), (Standards.NACE2, "25.71")),
        ((Standards.SKD2002, "28.750"), (Standards.NACE2, "25.99")),
        ((Standards.SKD2002, "28.750"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "28.750"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "29.110"), (Standards.NACE2, "28.11")),
        ((Standards.SKD2002, "29.110"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.120"), (Standards.NACE2, "28.12")),
        ((Standards.SKD2002, "29.120"), (Standards.NACE2, "28.13")),
        ((Standards.SKD2002, "29.120"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.130"), (Standards.NACE2, "28.12")),
        ((Standards.SKD2002, "29.130"), (Standards.NACE2, "28.14")),
        ((Standards.SKD2002, "29.130"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.140"), (Standards.NACE2, "28.15")),
        ((Standards.SKD2002, "29.140"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.210"), (Standards.NACE2, "28.21")),
        ((Standards.SKD2002, "29.210"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.220"), (Standards.NACE2, "28.22")),
        ((Standards.SKD2002, "29.220"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.230"), (Standards.NACE2, "28.25")),
        ((Standards.SKD2002, "29.230"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.240"), (Standards.NACE2, "28.29")),
        ((Standards.SKD2002, "29.240"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "29.240"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.240"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "29.310"), (Standards.NACE2, "28.30")),
        ((Standards.SKD2002, "29.310"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.320"), (Standards.NACE2, "28.30")),
        ((Standards.SKD2002, "29.320"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.320"), (Standards.NACE2, "95.22")),
        ((Standards.SKD2002, "29.410"), (Standards.NACE2, "28.24")),
        ((Standards.SKD2002, "29.410"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.420"), (Standards.NACE2, "28.41")),
        ((Standards.SKD2002, "29.420"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.430"), (Standards.NACE2, "27.90")),
        ((Standards.SKD2002, "29.430"), (Standards.NACE2, "28.29")),
        ((Standards.SKD2002, "29.430"), (Standards.NACE2, "28.49")),
        ((Standards.SKD2002, "29.430"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.510"), (Standards.NACE2, "28.91")),
        ((Standards.SKD2002, "29.510"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.520"), (Standards.NACE2, "28.92")),
        ((Standards.SKD2002, "29.520"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.530"), (Standards.NACE2, "28.93")),
        ((Standards.SKD2002, "29.530"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.540"), (Standards.NACE2, "28.94")),
        ((Standards.SKD2002, "29.540"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.550"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.560"), (Standards.NACE2, "25.73")),
        ((Standards.SKD2002, "29.560"), (Standards.NACE2, "28.94")),
        ((Standards.SKD2002, "29.560"), (Standards.NACE2, "28.96")),
        ((Standards.SKD2002, "29.560"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "29.560"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.600"), (Standards.NACE2, "25.40")),
        ((Standards.SKD2002, "29.600"), (Standards.NACE2, "30.40")),
        ((Standards.SKD2002, "29.600"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "29.710"), (Standards.NACE2, "27.51")),
        ((Standards.SKD2002, "29.710"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "29.720"), (Standards.NACE2, "27.52")),
        ((Standards.SKD2002, "29.720"), (Standards.NACE2, "28.21")),
        ((Standards.SKD2002, "30.010"), (Standards.NACE2, "28.23")),
        ((Standards.SKD2002, "30.020"), (Standards.NACE2, "26.20")),
        ((Standards.SKD2002, "30.020"), (Standards.NACE2, "95.11")),
        ((Standards.SKD2002, "31.100"), (Standards.NACE2, "27.11")),
        ((Standards.SKD2002, "31.100"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "31.200"), (Standards.NACE2, "27.12")),
        ((Standards.SKD2002, "31.200"), (Standards.NACE2, "27.33")),
        ((Standards.SKD2002, "31.200"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "31.300"), (Standards.NACE2, "27.31")),
        ((Standards.SKD2002, "31.300"), (Standards.NACE2, "27.32")),
        ((Standards.SKD2002, "31.300"), (Standards.NACE2, "27.90")),
        ((Standards.SKD2002, "31.400"), (Standards.NACE2, "27.20")),
        ((Standards.SKD2002, "31.500"), (Standards.NACE2, "27.40")),
        ((Standards.SKD2002, "31.610"), (Standards.NACE2, "27.40")),
        ((Standards.SKD2002, "31.610"), (Standards.NACE2, "27.90")),
        ((Standards.SKD2002, "31.610"), (Standards.NACE2, "29.31")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "25.99")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "26.30")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "26.51")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "27.32")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "27.90")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "28.49")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "30.20")),
        ((Standards.SKD2002, "31.620"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "32.100"), (Standards.NACE2, "26.11")),
        ((Standards.SKD2002, "32.100"), (Standards.NACE2, "26.12")),
        ((Standards.SKD2002, "32.100"), (Standards.NACE2, "27.90")),
        ((Standards.SKD2002, "32.100"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "32.200"), (Standards.NACE2, "26.30")),
        ((Standards.SKD2002, "32.200"), (Standards.NACE2, "95.12")),
        ((Standards.SKD2002, "32.300"), (Standards.NACE2, "26.20")),
        ((Standards.SKD2002, "32.300"), (Standards.NACE2, "26.30")),
        ((Standards.SKD2002, "32.300"), (Standards.NACE2, "26.40")),
        ((Standards.SKD2002, "32.300"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "33.100"), (Standards.NACE2, "26.60")),
        ((Standards.SKD2002, "33.100"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "33.100"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "33.100"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "33.100"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "26.51")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "26.70")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "28.29")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "33.14")),
        ((Standards.SKD2002, "33.200"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "33.300"), (Standards.NACE2, "33.20")),
        ((Standards.SKD2002, "33.400"), (Standards.NACE2, "26.70")),
        ((Standards.SKD2002, "33.400"), (Standards.NACE2, "27.31")),
        ((Standards.SKD2002, "33.400"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "33.400"), (Standards.NACE2, "32.50")),
        ((Standards.SKD2002, "33.400"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "33.500"), (Standards.NACE2, "26.52")),
        ((Standards.SKD2002, "33.500"), (Standards.NACE2, "32.12")),
        ((Standards.SKD2002, "33.500"), (Standards.NACE2, "32.13")),
        ((Standards.SKD2002, "33.500"), (Standards.NACE2, "33.13")),
        ((Standards.SKD2002, "34.100"), (Standards.NACE2, "28.92")),
        ((Standards.SKD2002, "34.100"), (Standards.NACE2, "29.10")),
        ((Standards.SKD2002, "34.100"), (Standards.NACE2, "30.91")),
        ((Standards.SKD2002, "34.200"), (Standards.NACE2, "29.20")),
        ((Standards.SKD2002, "34.200"), (Standards.NACE2, "33.11")),
        ((Standards.SKD2002, "34.300"), (Standards.NACE2, "28.11")),
        ((Standards.SKD2002, "34.300"), (Standards.NACE2, "29.32")),
        ((Standards.SKD2002, "35.110"), (Standards.NACE2, "30.11")),
        ((Standards.SKD2002, "35.110"), (Standards.NACE2, "33.15")),
        ((Standards.SKD2002, "35.120"), (Standards.NACE2, "30.12")),
        ((Standards.SKD2002, "35.120"), (Standards.NACE2, "33.15")),
        ((Standards.SKD2002, "35.200"), (Standards.NACE2, "30.20")),
        ((Standards.SKD2002, "35.200"), (Standards.NACE2, "33.17")),
        ((Standards.SKD2002, "35.300"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "35.300"), (Standards.NACE2, "30.30")),
        ((Standards.SKD2002, "35.300"), (Standards.NACE2, "33.16")),
        ((Standards.SKD2002, "35.410"), (Standards.NACE2, "30.91")),
        ((Standards.SKD2002, "35.420"), (Standards.NACE2, "30.92")),
        ((Standards.SKD2002, "35.430"), (Standards.NACE2, "30.92")),
        ((Standards.SKD2002, "35.430"), (Standards.NACE2, "33.17")),
        ((Standards.SKD2002, "35.500"), (Standards.NACE2, "30.99")),
        ((Standards.SKD2002, "35.500"), (Standards.NACE2, "33.17")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "29.32")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "30.11")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "30.20")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "30.30")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "31.01")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "31.02")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "31.09")),
        ((Standards.SKD2002, "36.110"), (Standards.NACE2, "95.24")),
        ((Standards.SKD2002, "36.120"), (Standards.NACE2, "31.01")),
        ((Standards.SKD2002, "36.120"), (Standards.NACE2, "95.24")),
        ((Standards.SKD2002, "36.130"), (Standards.NACE2, "31.02")),
        ((Standards.SKD2002, "36.130"), (Standards.NACE2, "95.24")),
        ((Standards.SKD2002, "36.140"), (Standards.NACE2, "31.09")),
        ((Standards.SKD2002, "36.140"), (Standards.NACE2, "95.24")),
        ((Standards.SKD2002, "36.150"), (Standards.NACE2, "31.03")),
        ((Standards.SKD2002, "36.210"), (Standards.NACE2, "32.11")),
        ((Standards.SKD2002, "36.220"), (Standards.NACE2, "32.12")),
        ((Standards.SKD2002, "36.300"), (Standards.NACE2, "32.20")),
        ((Standards.SKD2002, "36.300"), (Standards.NACE2, "95.29")),
        ((Standards.SKD2002, "36.400"), (Standards.NACE2, "32.30")),
        ((Standards.SKD2002, "36.400"), (Standards.NACE2, "95.29")),
        ((Standards.SKD2002, "36.500"), (Standards.NACE2, "26.40")),
        ((Standards.SKD2002, "36.500"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "36.500"), (Standards.NACE2, "32.40")),
        ((Standards.SKD2002, "36.500"), (Standards.NACE2, "33.19")),
        ((Standards.SKD2002, "36.610"), (Standards.NACE2, "32.13")),
        ((Standards.SKD2002, "36.620"), (Standards.NACE2, "32.91")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "15.12")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "17.29")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "20.51")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "22.19")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "22.23")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "22.29")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "25.99")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "28.99")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "30.92")),
        ((Standards.SKD2002, "36.630"), (Standards.NACE2, "32.99")),
        ((Standards.SKD2002, "37.100"), (Standards.NACE2, "38.31")),
        ((Standards.SKD2002, "37.100"), (Standards.NACE2, "38.32")),
        ((Standards.SKD2002, "37.200"), (Standards.NACE2, "38.32")),
        ((Standards.SKD2002, "40.111"), (Standards.NACE2, "35.11")),
        ((Standards.SKD2002, "40.112"), (Standards.NACE2, "35.11")),
        ((Standards.SKD2002, "40.113"), (Standards.NACE2, "35.11")),
        ((Standards.SKD2002, "40.120"), (Standards.NACE2, "35.12")),
        ((Standards.SKD2002, "40.131"), (Standards.NACE2, "35.13")),
        ((Standards.SKD2002, "40.132"), (Standards.NACE2, "35.14")),
        ((Standards.SKD2002, "40.210"), (Standards.NACE2, "35.21")),
        ((Standards.SKD2002, "40.221"), (Standards.NACE2, "35.22")),
        ((Standards.SKD2002, "40.222"), (Standards.NACE2, "35.23")),
        ((Standards.SKD2002, "40.300"), (Standards.NACE2, "35.30")),
        ((Standards.SKD2002, "41.000"), (Standards.NACE2, "36.00")),
        ((Standards.SKD2002, "45.110"), (Standards.NACE2, "43.11")),
        ((Standards.SKD2002, "45.110"), (Standards.NACE2, "43.12")),
        ((Standards.SKD2002, "45.120"), (Standards.NACE2, "43.13")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "41.20")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "42.12")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "42.13")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "42.21")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "42.22")),
        ((Standards.SKD2002, "45.210"), (Standards.NACE2, "42.99")),
        ((Standards.SKD2002, "45.220"), (Standards.NACE2, "43.91")),
        ((Standards.SKD2002, "45.220"), (Standards.NACE2, "43.99")),
        ((Standards.SKD2002, "45.230"), (Standards.NACE2, "41.20")),
        ((Standards.SKD2002, "45.230"), (Standards.NACE2, "42.11")),
        ((Standards.SKD2002, "45.230"), (Standards.NACE2, "42.12")),
        ((Standards.SKD2002, "45.230"), (Standards.NACE2, "42.99")),
        ((Standards.SKD2002, "45.240"), (Standards.NACE2, "42.21")),
        ((Standards.SKD2002, "45.240"), (Standards.NACE2, "42.91")),
        ((Standards.SKD2002, "45.240"), (Standards.NACE2, "43.99")),
        ((Standards.SKD2002, "45.250"), (Standards.NACE2, "42.21")),
        ((Standards.SKD2002, "45.250"), (Standards.NACE2, "43.99")),
        ((Standards.SKD2002, "45.310"), (Standards.NACE2, "43.21")),
        ((Standards.SKD2002, "45.310"), (Standards.NACE2, "43.22")),
        ((Standards.SKD2002, "45.310"), (Standards.NACE2, "43.29")),
        ((Standards.SKD2002, "45.320"), (Standards.NACE2, "43.29")),
        ((Standards.SKD2002, "45.330"), (Standards.NACE2, "43.22")),
        ((Standards.SKD2002, "45.340"), (Standards.NACE2, "43.21")),
        ((Standards.SKD2002, "45.340"), (Standards.NACE2, "43.29")),
        ((Standards.SKD2002, "45.410"), (Standards.NACE2, "43.31")),
        ((Standards.SKD2002, "45.420"), (Standards.NACE2, "43.32")),
        ((Standards.SKD2002, "45.430"), (Standards.NACE2, "43.33")),
        ((Standards.SKD2002, "45.441"), (Standards.NACE2, "43.34")),
        ((Standards.SKD2002, "45.442"), (Standards.NACE2, "43.34")),
        ((Standards.SKD2002, "45.450"), (Standards.NACE2, "43.39")),
        ((Standards.SKD2002, "45.450"), (Standards.NACE2, "43.99")),
        ((Standards.SKD2002, "45.500"), (Standards.NACE2, "43.99")),
        ((Standards.SKD2002, "50.101"), (Standards.NACE2, "45.11")),
        ((Standards.SKD2002, "50.101"), (Standards.NACE2, "45.19")),
        ((Standards.SKD2002, "50.102"), (Standards.NACE2, "45.11")),
        ((Standards.SKD2002, "50.102"), (Standards.NACE2, "45.19")),
        ((Standards.SKD2002, "50.103"), (Standards.NACE2, "45.11")),
        ((Standards.SKD2002, "50.103"), (Standards.NACE2, "45.19")),
        ((Standards.SKD2002, "50.200"), (Standards.NACE2, "45.20")),
        ((Standards.SKD2002, "50.200"), (Standards.NACE2, "52.21")),
        ((Standards.SKD2002, "50.301"), (Standards.NACE2, "45.31")),
        ((Standards.SKD2002, "50.302"), (Standards.NACE2, "45.32")),
        ((Standards.SKD2002, "50.303"), (Standards.NACE2, "45.31")),
        ((Standards.SKD2002, "50.401"), (Standards.NACE2, "45.40")),
        ((Standards.SKD2002, "50.402"), (Standards.NACE2, "45.40")),
        ((Standards.SKD2002, "50.403"), (Standards.NACE2, "45.40")),
        ((Standards.SKD2002, "50.404"), (Standards.NACE2, "45.40")),
        ((Standards.SKD2002, "50.501"), (Standards.NACE2, "47.30")),
        ((Standards.SKD2002, "50.502"), (Standards.NACE2, "47.30")),
        ((Standards.SKD2002, "51.110"), (Standards.NACE2, "46.11")),
        ((Standards.SKD2002, "51.120"), (Standards.NACE2, "46.12")),
        ((Standards.SKD2002, "51.130"), (Standards.NACE2, "46.13")),
        ((Standards.SKD2002, "51.140"), (Standards.NACE2, "46.14")),
        ((Standards.SKD2002, "51.150"), (Standards.NACE2, "46.15")),
        ((Standards.SKD2002, "51.160"), (Standards.NACE2, "46.16")),
        ((Standards.SKD2002, "51.170"), (Standards.NACE2, "46.17")),
        ((Standards.SKD2002, "51.180"), (Standards.NACE2, "46.18")),
        ((Standards.SKD2002, "51.190"), (Standards.NACE2, "46.19")),
        ((Standards.SKD2002, "51.210"), (Standards.NACE2, "46.21")),
        ((Standards.SKD2002, "51.220"), (Standards.NACE2, "46.22")),
        ((Standards.SKD2002, "51.230"), (Standards.NACE2, "46.23")),
        ((Standards.SKD2002, "51.240"), (Standards.NACE2, "46.24")),
        ((Standards.SKD2002, "51.250"), (Standards.NACE2, "46.21")),
        ((Standards.SKD2002, "51.310"), (Standards.NACE2, "46.31")),
        ((Standards.SKD2002, "51.320"), (Standards.NACE2, "46.32")),
        ((Standards.SKD2002, "51.330"), (Standards.NACE2, "46.33")),
        ((Standards.SKD2002, "51.340"), (Standards.NACE2, "11.02")),
        ((Standards.SKD2002, "51.340"), (Standards.NACE2, "46.34")),
        ((Standards.SKD2002, "51.350"), (Standards.NACE2, "46.35")),
        ((Standards.SKD2002, "51.360"), (Standards.NACE2, "46.36")),
        ((Standards.SKD2002, "51.370"), (Standards.NACE2, "46.37")),
        ((Standards.SKD2002, "51.380"), (Standards.NACE2, "46.31")),
        ((Standards.SKD2002, "51.380"), (Standards.NACE2, "46.38")),
        ((Standards.SKD2002, "51.390"), (Standards.NACE2, "46.39")),
        ((Standards.SKD2002, "51.410"), (Standards.NACE2, "46.41")),
        ((Standards.SKD2002, "51.420"), (Standards.NACE2, "46.42")),
        ((Standards.SKD2002, "51.430"), (Standards.NACE2, "46.43")),
        ((Standards.SKD2002, "51.430"), (Standards.NACE2, "46.47")),
        ((Standards.SKD2002, "51.430"), (Standards.NACE2, "46.52")),
        ((Standards.SKD2002, "51.440"), (Standards.NACE2, "46.44")),
        ((Standards.SKD2002, "51.440"), (Standards.NACE2, "46.49")),
        ((Standards.SKD2002, "51.440"), (Standards.NACE2, "46.73")),
        ((Standards.SKD2002, "51.450"), (Standards.NACE2, "46.45")),
        ((Standards.SKD2002, "51.460"), (Standards.NACE2, "46.46")),
        ((Standards.SKD2002, "51.470"), (Standards.NACE2, "46.43")),
        ((Standards.SKD2002, "51.470"), (Standards.NACE2, "46.47")),
        ((Standards.SKD2002, "51.470"), (Standards.NACE2, "46.48")),
        ((Standards.SKD2002, "51.470"), (Standards.NACE2, "46.49")),
        ((Standards.SKD2002, "51.470"), (Standards.NACE2, "46.73")),
        ((Standards.SKD2002, "51.510"), (Standards.NACE2, "46.71")),
        ((Standards.SKD2002, "51.520"), (Standards.NACE2, "46.72")),
        ((Standards.SKD2002, "51.530"), (Standards.NACE2, "46.73")),
        ((Standards.SKD2002, "51.540"), (Standards.NACE2, "46.74")),
        ((Standards.SKD2002, "51.550"), (Standards.NACE2, "46.75")),
        ((Standards.SKD2002, "51.550"), (Standards.NACE2, "46.76")),
        ((Standards.SKD2002, "51.560"), (Standards.NACE2, "46.76")),
        ((Standards.SKD2002, "51.570"), (Standards.NACE2, "46.77")),
        ((Standards.SKD2002, "51.810"), (Standards.NACE2, "46.62")),
        ((Standards.SKD2002, "51.820"), (Standards.NACE2, "46.63")),
        ((Standards.SKD2002, "51.830"), (Standards.NACE2, "46.64")),
        ((Standards.SKD2002, "51.840"), (Standards.NACE2, "46.51")),
        ((Standards.SKD2002, "51.850"), (Standards.NACE2, "46.65")),
        ((Standards.SKD2002, "51.850"), (Standards.NACE2, "46.66")),
        ((Standards.SKD2002, "51.860"), (Standards.NACE2, "46.52")),
        ((Standards.SKD2002, "51.870"), (Standards.NACE2, "46.69")),
        ((Standards.SKD2002, "51.880"), (Standards.NACE2, "46.61")),
        ((Standards.SKD2002, "51.900"), (Standards.NACE2, "46.90")),
        ((Standards.SKD2002, "52.110"), (Standards.NACE2, "47.11")),
        ((Standards.SKD2002, "52.120"), (Standards.NACE2, "47.19")),
        ((Standards.SKD2002, "52.210"), (Standards.NACE2, "47.21")),
        ((Standards.SKD2002, "52.220"), (Standards.NACE2, "47.22")),
        ((Standards.SKD2002, "52.230"), (Standards.NACE2, "47.23")),
        ((Standards.SKD2002, "52.240"), (Standards.NACE2, "47.24")),
        ((Standards.SKD2002, "52.250"), (Standards.NACE2, "47.25")),
        ((Standards.SKD2002, "52.260"), (Standards.NACE2, "47.26")),
        ((Standards.SKD2002, "52.270"), (Standards.NACE2, "47.21")),
        ((Standards.SKD2002, "52.270"), (Standards.NACE2, "47.29")),
        ((Standards.SKD2002, "52.310"), (Standards.NACE2, "47.73")),
        ((Standards.SKD2002, "52.320"), (Standards.NACE2, "47.74")),
        ((Standards.SKD2002, "52.330"), (Standards.NACE2, "47.75")),
        ((Standards.SKD2002, "52.410"), (Standards.NACE2, "47.51")),
        ((Standards.SKD2002, "52.420"), (Standards.NACE2, "47.71")),
        ((Standards.SKD2002, "52.430"), (Standards.NACE2, "47.72")),
        ((Standards.SKD2002, "52.440"), (Standards.NACE2, "47.53")),
        ((Standards.SKD2002, "52.440"), (Standards.NACE2, "47.59")),
        ((Standards.SKD2002, "52.450"), (Standards.NACE2, "47.43")),
        ((Standards.SKD2002, "52.450"), (Standards.NACE2, "47.54")),
        ((Standards.SKD2002, "52.450"), (Standards.NACE2, "47.59")),
        ((Standards.SKD2002, "52.450"), (Standards.NACE2, "47.63")),
        ((Standards.SKD2002, "52.461"), (Standards.NACE2, "47.52")),
        ((Standards.SKD2002, "52.462"), (Standards.NACE2, "47.52")),
        ((Standards.SKD2002, "52.463"), (Standards.NACE2, "47.52")),
        ((Standards.SKD2002, "52.471"), (Standards.NACE2, "47.61")),
        ((Standards.SKD2002, "52.472"), (Standards.NACE2, "47.62")),
        ((Standards.SKD2002, "52.473"), (Standards.NACE2, "47.62")),
        ((Standards.SKD2002, "52.481"), (Standards.NACE2, "47.64")),
        ((Standards.SKD2002, "52.482"), (Standards.NACE2, "47.76")),
        ((Standards.SKD2002, "52.483"), (Standards.NACE2, "47.76")),
        ((Standards.SKD2002, "52.484"), (Standards.NACE2, "47.78")),
        ((Standards.SKD2002, "52.485"), (Standards.NACE2, "47.77")),
        ((Standards.SKD2002, "52.486"), (Standards.NACE2, "47.78")),
        ((Standards.SKD2002, "52.487"), (Standards.NACE2, "47.65")),
        ((Standards.SKD2002, "52.488"), (Standards.NACE2, "47.41")),
        ((Standards.SKD2002, "52.488"), (Standards.NACE2, "47.42")),
        ((Standards.SKD2002, "52.488"), (Standards.NACE2, "47.53")),
        ((Standards.SKD2002, "52.488"), (Standards.NACE2, "47.59")),
        ((Standards.SKD2002, "52.488"), (Standards.NACE2, "47.78")),
        ((Standards.SKD2002, "52.500"), (Standards.NACE2, "47.79")),
        ((Standards.SKD2002, "52.610"), (Standards.NACE2, "47.91")),
        ((Standards.SKD2002, "52.620"), (Standards.NACE2, "47.81")),
        ((Standards.SKD2002, "52.620"), (Standards.NACE2, "47.82")),
        ((Standards.SKD2002, "52.620"), (Standards.NACE2, "47.89")),
        ((Standards.SKD2002, "52.630"), (Standards.NACE2, "47.79")),
        ((Standards.SKD2002, "52.630"), (Standards.NACE2, "47.91")),
        ((Standards.SKD2002, "52.630"), (Standards.NACE2, "47.99")),
        ((Standards.SKD2002, "52.710"), (Standards.NACE2, "95.23")),
        ((Standards.SKD2002, "52.720"), (Standards.NACE2, "95.21")),
        ((Standards.SKD2002, "52.720"), (Standards.NACE2, "95.22")),
        ((Standards.SKD2002, "52.730"), (Standards.NACE2, "95.25")),
        ((Standards.SKD2002, "52.740"), (Standards.NACE2, "13.30")),
        ((Standards.SKD2002, "52.740"), (Standards.NACE2, "95.12")),
        ((Standards.SKD2002, "52.740"), (Standards.NACE2, "95.23")),
        ((Standards.SKD2002, "52.740"), (Standards.NACE2, "95.29")),
        ((Standards.SKD2002, "52.740"), (Standards.NACE2, "96.09")),
        ((Standards.SKD2002, "55.100"), (Standards.NACE2, "55.10")),
        ((Standards.SKD2002, "55.210"), (Standards.NACE2, "55.20")),
        ((Standards.SKD2002, "55.220"), (Standards.NACE2, "55.30")),
        ((Standards.SKD2002, "55.231"), (Standards.NACE2, "55.20")),
        ((Standards.SKD2002, "55.232"), (Standards.NACE2, "55.20")),
        ((Standards.SKD2002, "55.233"), (Standards.NACE2, "55.20")),
        ((Standards.SKD2002, "55.234"), (Standards.NACE2, "55.90")),
        ((Standards.SKD2002, "55.239"), (Standards.NACE2, "55.20")),
        ((Standards.SKD2002, "55.301"), (Standards.NACE2, "56.10")),
        ((Standards.SKD2002, "55.302"), (Standards.NACE2, "56.10")),
        ((Standards.SKD2002, "55.303"), (Standards.NACE2, "56.10")),
        ((Standards.SKD2002, "55.304"), (Standards.NACE2, "56.10")),
        ((Standards.SKD2002, "55.305"), (Standards.NACE2, "56.10")),
        ((Standards.SKD2002, "55.400"), (Standards.NACE2, "56.30")),
        ((Standards.SKD2002, "55.510"), (Standards.NACE2, "56.29")),
        ((Standards.SKD2002, "55.520"), (Standards.NACE2, "56.21")),
        ((Standards.SKD2002, "55.520"), (Standards.NACE2, "56.29")),
        ((Standards.SKD2002, "60.100"), (Standards.NACE2, "49.10")),
        ((Standards.SKD2002, "60.100"), (Standards.NACE2, "49.20")),
        ((Standards.SKD2002, "60.211"), (Standards.NACE2, "49.31")),
        ((Standards.SKD2002, "60.212"), (Standards.NACE2, "49.39")),
        ((Standards.SKD2002, "60.213"), (Standards.NACE2, "49.39")),
        ((Standards.SKD2002, "60.220"), (Standards.NACE2, "49.32")),
        ((Standards.SKD2002, "60.230"), (Standards.NACE2, "49.39")),
        ((Standards.SKD2002, "60.240"), (Standards.NACE2, "49.41")),
        ((Standards.SKD2002, "60.240"), (Standards.NACE2, "49.42")),
        ((Standards.SKD2002, "60.300"), (Standards.NACE2, "49.50")),
        ((Standards.SKD2002, "61.100"), (Standards.NACE2, "50.10")),
        ((Standards.SKD2002, "61.100"), (Standards.NACE2, "50.20")),
        ((Standards.SKD2002, "61.200"), (Standards.NACE2, "50.30")),
        ((Standards.SKD2002, "61.200"), (Standards.NACE2, "50.40")),
        ((Standards.SKD2002, "62.100"), (Standards.NACE2, "51.10")),
        ((Standards.SKD2002, "62.100"), (Standards.NACE2, "51.21")),
        ((Standards.SKD2002, "62.200"), (Standards.NACE2, "51.10")),
        ((Standards.SKD2002, "62.200"), (Standards.NACE2, "51.21")),
        ((Standards.SKD2002, "63.110"), (Standards.NACE2, "52.24")),
        ((Standards.SKD2002, "63.120"), (Standards.NACE2, "52.10")),
        ((Standards.SKD2002, "63.210"), (Standards.NACE2, "52.21")),
        ((Standards.SKD2002, "63.220"), (Standards.NACE2, "52.22")),
        ((Standards.SKD2002, "63.230"), (Standards.NACE2, "52.23")),
        ((Standards.SKD2002, "63.300"), (Standards.NACE2, "79.11")),
        ((Standards.SKD2002, "63.300"), (Standards.NACE2, "79.12")),
        ((Standards.SKD2002, "63.300"), (Standards.NACE2, "79.90")),
        ((Standards.SKD2002, "64.120"), (Standards.NACE2, "53.20")),
        ((Standards.SKD2002, "64.200"), (Standards.NACE2, "60.20")),
        ((Standards.SKD2002, "64.200"), (Standards.NACE2, "61.10")),
        ((Standards.SKD2002, "64.200"), (Standards.NACE2, "61.20")),
        ((Standards.SKD2002, "64.200"), (Standards.NACE2, "61.30")),
        ((Standards.SKD2002, "64.200"), (Standards.NACE2, "61.90")),
        ((Standards.SKD2002, "65.110"), (Standards.NACE2, "64.11")),
        ((Standards.SKD2002, "65.121"), (Standards.NACE2, "64.19")),
        ((Standards.SKD2002, "65.122"), (Standards.NACE2, "64.19")),
        ((Standards.SKD2002, "65.210"), (Standards.NACE2, "64.91")),
        ((Standards.SKD2002, "65.220"), (Standards.NACE2, "64.92")),
        ((Standards.SKD2002, "65.220"), (Standards.NACE2, "64.99")),
        ((Standards.SKD2002, "65.230"), (Standards.NACE2, "64.20")),
        ((Standards.SKD2002, "65.230"), (Standards.NACE2, "64.30")),
        ((Standards.SKD2002, "65.230"), (Standards.NACE2, "64.99")),
        ((Standards.SKD2002, "66.010"), (Standards.NACE2, "65.11")),
        ((Standards.SKD2002, "66.010"), (Standards.NACE2, "65.20")),
        ((Standards.SKD2002, "66.020"), (Standards.NACE2, "65.20")),
        ((Standards.SKD2002, "66.020"), (Standards.NACE2, "65.30")),
        ((Standards.SKD2002, "66.030"), (Standards.NACE2, "65.12")),
        ((Standards.SKD2002, "66.030"), (Standards.NACE2, "65.20")),
        ((Standards.SKD2002, "67.110"), (Standards.NACE2, "66.11")),
        ((Standards.SKD2002, "67.120"), (Standards.NACE2, "66.12")),
        ((Standards.SKD2002, "67.120"), (Standards.NACE2, "66.30")),
        ((Standards.SKD2002, "67.130"), (Standards.NACE2, "66.12")),
        ((Standards.SKD2002, "67.130"), (Standards.NACE2, "66.19")),
        ((Standards.SKD2002, "67.200"), (Standards.NACE2, "66.21")),
        ((Standards.SKD2002, "67.200"), (Standards.NACE2, "66.22")),
        ((Standards.SKD2002, "67.200"), (Standards.NACE2, "66.29")),
        ((Standards.SKD2002, "70.110"), (Standards.NACE2, "41.10")),
        ((Standards.SKD2002, "70.120"), (Standards.NACE2, "68.10")),
        ((Standards.SKD2002, "70.200"), (Standards.NACE2, "68.20")),
        ((Standards.SKD2002, "70.310"), (Standards.NACE2, "68.31")),
        ((Standards.SKD2002, "70.320"), (Standards.NACE2, "68.32")),
        ((Standards.SKD2002, "70.320"), (Standards.NACE2, "81.10")),
        ((Standards.SKD2002, "71.100"), (Standards.NACE2, "77.11")),
        ((Standards.SKD2002, "71.210"), (Standards.NACE2, "77.12")),
        ((Standards.SKD2002, "71.210"), (Standards.NACE2, "77.39")),
        ((Standards.SKD2002, "71.220"), (Standards.NACE2, "77.34")),
        ((Standards.SKD2002, "71.230"), (Standards.NACE2, "77.35")),
        ((Standards.SKD2002, "71.310"), (Standards.NACE2, "77.31")),
        ((Standards.SKD2002, "71.320"), (Standards.NACE2, "77.32")),
        ((Standards.SKD2002, "71.320"), (Standards.NACE2, "77.39")),
        ((Standards.SKD2002, "71.330"), (Standards.NACE2, "77.33")),
        ((Standards.SKD2002, "71.340"), (Standards.NACE2, "77.39")),
        ((Standards.SKD2002, "71.401"), (Standards.NACE2, "77.21")),
        ((Standards.SKD2002, "71.402"), (Standards.NACE2, "77.22")),
        ((Standards.SKD2002, "71.403"), (Standards.NACE2, "77.29")),
        ((Standards.SKD2002, "72.100"), (Standards.NACE2, "62.02")),
        ((Standards.SKD2002, "72.210"), (Standards.NACE2, "58.21")),
        ((Standards.SKD2002, "72.210"), (Standards.NACE2, "58.29")),
        ((Standards.SKD2002, "72.220"), (Standards.NACE2, "62.01")),
        ((Standards.SKD2002, "72.220"), (Standards.NACE2, "62.02")),
        ((Standards.SKD2002, "72.300"), (Standards.NACE2, "62.03")),
        ((Standards.SKD2002, "72.300"), (Standards.NACE2, "63.11")),
        ((Standards.SKD2002, "72.400"), (Standards.NACE2, "58.12")),
        ((Standards.SKD2002, "72.400"), (Standards.NACE2, "63.11")),
        ((Standards.SKD2002, "72.400"), (Standards.NACE2, "63.12")),
        ((Standards.SKD2002, "72.500"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "72.500"), (Standards.NACE2, "95.11")),
        ((Standards.SKD2002, "72.600"), (Standards.NACE2, "62.09")),
        ((Standards.SKD2002, "73.101"), (Standards.NACE2, "72.11")),
        ((Standards.SKD2002, "73.101"), (Standards.NACE2, "72.19")),
        ((Standards.SKD2002, "73.102"), (Standards.NACE2, "72.11")),
        ((Standards.SKD2002, "73.102"), (Standards.NACE2, "72.19")),
        ((Standards.SKD2002, "73.103"), (Standards.NACE2, "72.11")),
        ((Standards.SKD2002, "73.103"), (Standards.NACE2, "72.19")),
        ((Standards.SKD2002, "73.104"), (Standards.NACE2, "72.11")),
        ((Standards.SKD2002, "73.104"), (Standards.NACE2, "72.19")),
        ((Standards.SKD2002, "73.201"), (Standards.NACE2, "72.20")),
        ((Standards.SKD2002, "73.202"), (Standards.NACE2, "72.20")),
        ((Standards.SKD2002, "74.110"), (Standards.NACE2, "69.10")),
        ((Standards.SKD2002, "74.120"), (Standards.NACE2, "69.20")),
        ((Standards.SKD2002, "74.130"), (Standards.NACE2, "73.20")),
        ((Standards.SKD2002, "74.140"), (Standards.NACE2, "70.21")),
        ((Standards.SKD2002, "74.140"), (Standards.NACE2, "70.22")),
        ((Standards.SKD2002, "74.140"), (Standards.NACE2, "74.90")),
        ((Standards.SKD2002, "74.150"), (Standards.NACE2, "64.20")),
        ((Standards.SKD2002, "74.150"), (Standards.NACE2, "70.10")),
        ((Standards.SKD2002, "74.201"), (Standards.NACE2, "71.12")),
        ((Standards.SKD2002, "74.201"), (Standards.NACE2, "74.90")),
        ((Standards.SKD2002, "74.202"), (Standards.NACE2, "71.11")),
        ((Standards.SKD2002, "74.203"), (Standards.NACE2, "71.11")),
        ((Standards.SKD2002, "74.204"), (Standards.NACE2, "71.12")),
        ((Standards.SKD2002, "74.300"), (Standards.NACE2, "71.20")),
        ((Standards.SKD2002, "74.400"), (Standards.NACE2, "73.11")),
        ((Standards.SKD2002, "74.400"), (Standards.NACE2, "73.12")),
        ((Standards.SKD2002, "74.500"), (Standards.NACE2, "78.10")),
        ((Standards.SKD2002, "74.500"), (Standards.NACE2, "78.20")),
        ((Standards.SKD2002, "74.500"), (Standards.NACE2, "78.30")),
        ((Standards.SKD2002, "74.600"), (Standards.NACE2, "74.90")),
        ((Standards.SKD2002, "74.600"), (Standards.NACE2, "80.10")),
        ((Standards.SKD2002, "74.600"), (Standards.NACE2, "80.20")),
        ((Standards.SKD2002, "74.600"), (Standards.NACE2, "80.30")),
        ((Standards.SKD2002, "74.700"), (Standards.NACE2, "81.21")),
        ((Standards.SKD2002, "74.700"), (Standards.NACE2, "81.22")),
        ((Standards.SKD2002, "74.700"), (Standards.NACE2, "81.29")),
        ((Standards.SKD2002, "74.810"), (Standards.NACE2, "74.20")),
        ((Standards.SKD2002, "74.820"), (Standards.NACE2, "82.92")),
        ((Standards.SKD2002, "74.851"), (Standards.NACE2, "74.30")),
        ((Standards.SKD2002, "74.852"), (Standards.NACE2, "82.19")),
        ((Standards.SKD2002, "74.853"), (Standards.NACE2, "82.11")),
        ((Standards.SKD2002, "74.860"), (Standards.NACE2, "82.20")),
        ((Standards.SKD2002, "74.871"), (Standards.NACE2, "82.30")),
        ((Standards.SKD2002, "74.872"), (Standards.NACE2, "74.10")),
        ((Standards.SKD2002, "74.873"), (Standards.NACE2, "59.20")),
        ((Standards.SKD2002, "74.873"), (Standards.NACE2, "74.90")),
        ((Standards.SKD2002, "75.110"), (Standards.NACE2, "84.11")),
        ((Standards.SKD2002, "75.120"), (Standards.NACE2, "84.12")),
        ((Standards.SKD2002, "75.130"), (Standards.NACE2, "84.13")),
        ((Standards.SKD2002, "75.140"), (Standards.NACE2, "81.10")),
        ((Standards.SKD2002, "75.140"), (Standards.NACE2, "84.11")),
        ((Standards.SKD2002, "75.140"), (Standards.NACE2, "91.01")),
        ((Standards.SKD2002, "75.210"), (Standards.NACE2, "84.21")),
        ((Standards.SKD2002, "75.210"), (Standards.NACE2, "88.99")),
        ((Standards.SKD2002, "75.220"), (Standards.NACE2, "84.22")),
        ((Standards.SKD2002, "75.230"), (Standards.NACE2, "84.23")),
        ((Standards.SKD2002, "75.240"), (Standards.NACE2, "84.24")),
        ((Standards.SKD2002, "75.250"), (Standards.NACE2, "84.25")),
        ((Standards.SKD2002, "75.300"), (Standards.NACE2, "84.30")),
        ((Standards.SKD2002, "80.101"), (Standards.NACE2, "85.10")),
        ((Standards.SKD2002, "80.102"), (Standards.NACE2, "85.20")),
        ((Standards.SKD2002, "80.103"), (Standards.NACE2, "85.20")),
        ((Standards.SKD2002, "80.210"), (Standards.NACE2, "85.31")),
        ((Standards.SKD2002, "80.220"), (Standards.NACE2, "85.32")),
        ((Standards.SKD2002, "80.301"), (Standards.NACE2, "85.42")),
        ((Standards.SKD2002, "80.302"), (Standards.NACE2, "85.42")),
        ((Standards.SKD2002, "80.303"), (Standards.NACE2, "85.42")),
        ((Standards.SKD2002, "80.410"), (Standards.NACE2, "85.53")),
        ((Standards.SKD2002, "80.421"), (Standards.NACE2, "85.52")),
        ((Standards.SKD2002, "80.422"), (Standards.NACE2, "85.59")),
        ((Standards.SKD2002, "85.110"), (Standards.NACE2, "87.20")),
        ((Standards.SKD2002, "85.121"), (Standards.NACE2, "86.21")),
        ((Standards.SKD2002, "85.122"), (Standards.NACE2, "86.22")),
        ((Standards.SKD2002, "85.130"), (Standards.NACE2, "86.23")),
        ((Standards.SKD2002, "85.141"), (Standards.NACE2, "86.90")),
        ((Standards.SKD2002, "85.142"), (Standards.NACE2, "86.90")),
        ((Standards.SKD2002, "85.143"), (Standards.NACE2, "86.90")),
        ((Standards.SKD2002, "85.200"), (Standards.NACE2, "75.00")),
        ((Standards.SKD2002, "85.311"), (Standards.NACE2, "87.30")),
        ((Standards.SKD2002, "85.319"), (Standards.NACE2, "87.20")),
        ((Standards.SKD2002, "85.319"), (Standards.NACE2, "87.90")),
        ((Standards.SKD2002, "85.321"), (Standards.NACE2, "88.10")),
        ((Standards.SKD2002, "85.322"), (Standards.NACE2, "88.10")),
        ((Standards.SKD2002, "85.323"), (Standards.NACE2, "88.99")),
        ((Standards.SKD2002, "85.324"), (Standards.NACE2, "88.10")),
        ((Standards.SKD2002, "85.329"), (Standards.NACE2, "88.10")),
        ((Standards.SKD2002, "85.329"), (Standards.NACE2, "88.99")),
        ((Standards.SKD2002, "90.010"), (Standards.NACE2, "37.00")),
        ((Standards.SKD2002, "90.021"), (Standards.NACE2, "38.11")),
        ((Standards.SKD2002, "90.021"), (Standards.NACE2, "38.12")),
        ((Standards.SKD2002, "90.022"), (Standards.NACE2, "38.21")),
        ((Standards.SKD2002, "90.022"), (Standards.NACE2, "38.22")),
        ((Standards.SKD2002, "90.023"), (Standards.NACE2, "38.21")),
        ((Standards.SKD2002, "90.023"), (Standards.NACE2, "38.22")),
        ((Standards.SKD2002, "90.031"), (Standards.NACE2, "39.00")),
        ((Standards.SKD2002, "90.032"), (Standards.NACE2, "81.29")),
        ((Standards.SKD2002, "91.110"), (Standards.NACE2, "94.11")),
        ((Standards.SKD2002, "91.120"), (Standards.NACE2, "94.12")),
        ((Standards.SKD2002, "91.200"), (Standards.NACE2, "94.20")),
        ((Standards.SKD2002, "91.310"), (Standards.NACE2, "94.91")),
        ((Standards.SKD2002, "91.320"), (Standards.NACE2, "94.92")),
        ((Standards.SKD2002, "91.330"), (Standards.NACE2, "94.99")),
        ((Standards.SKD2002, "92.110"), (Standards.NACE2, "59.11")),
        ((Standards.SKD2002, "92.110"), (Standards.NACE2, "59.12")),
        ((Standards.SKD2002, "92.110"), (Standards.NACE2, "59.20")),
        ((Standards.SKD2002, "92.120"), (Standards.NACE2, "59.13")),
        ((Standards.SKD2002, "92.130"), (Standards.NACE2, "59.14")),
        ((Standards.SKD2002, "92.200"), (Standards.NACE2, "59.11")),
        ((Standards.SKD2002, "92.200"), (Standards.NACE2, "59.12")),
        ((Standards.SKD2002, "92.200"), (Standards.NACE2, "59.20")),
        ((Standards.SKD2002, "92.200"), (Standards.NACE2, "60.10")),
        ((Standards.SKD2002, "92.200"), (Standards.NACE2, "60.20")),
        ((Standards.SKD2002, "92.310"), (Standards.NACE2, "90.01")),
        ((Standards.SKD2002, "92.310"), (Standards.NACE2, "90.02")),
        ((Standards.SKD2002, "92.310"), (Standards.NACE2, "90.03")),
        ((Standards.SKD2002, "92.320"), (Standards.NACE2, "90.02")),
        ((Standards.SKD2002, "92.320"), (Standards.NACE2, "90.04")),
        ((Standards.SKD2002, "92.330"), (Standards.NACE2, "93.21")),
        ((Standards.SKD2002, "92.340"), (Standards.NACE2, "85.52")),
        ((Standards.SKD2002, "92.340"), (Standards.NACE2, "90.01")),
        ((Standards.SKD2002, "92.340"), (Standards.NACE2, "93.29")),
        ((Standards.SKD2002, "92.400"), (Standards.NACE2, "63.91")),
        ((Standards.SKD2002, "92.400"), (Standards.NACE2, "74.20")),
        ((Standards.SKD2002, "92.400"), (Standards.NACE2, "90.03")),
        ((Standards.SKD2002, "92.511"), (Standards.NACE2, "91.01")),
        ((Standards.SKD2002, "92.512"), (Standards.NACE2, "91.01")),
        ((Standards.SKD2002, "92.521"), (Standards.NACE2, "91.02")),
        ((Standards.SKD2002, "92.522"), (Standards.NACE2, "91.03")),
        ((Standards.SKD2002, "92.530"), (Standards.NACE2, "91.04")),
        ((Standards.SKD2002, "92.610"), (Standards.NACE2, "93.11")),
        ((Standards.SKD2002, "92.621"), (Standards.NACE2, "93.29")),
        ((Standards.SKD2002, "92.622"), (Standards.NACE2, "93.29")),
        ((Standards.SKD2002, "92.623"), (Standards.NACE2, "85.51")),
        ((Standards.SKD2002, "92.623"), (Standards.NACE2, "93.12")),
        ((Standards.SKD2002, "92.623"), (Standards.NACE2, "93.19")),
        ((Standards.SKD2002, "92.711"), (Standards.NACE2, "92.00")),
        ((Standards.SKD2002, "92.712"), (Standards.NACE2, "92.00")),
        ((Standards.SKD2002, "92.720"), (Standards.NACE2, "93.29")),
        ((Standards.SKD2002, "93.010"), (Standards.NACE2, "96.01")),
        ((Standards.SKD2002, "93.021"), (Standards.NACE2, "96.02")),
        ((Standards.SKD2002, "93.022"), (Standards.NACE2, "96.02")),
        ((Standards.SKD2002, "93.023"), (Standards.NACE2, "96.02")),
        ((Standards.SKD2002, "93.030"), (Standards.NACE2, "96.03")),
        ((Standards.SKD2002, "93.040"), (Standards.NACE2, "93.13")),
        ((Standards.SKD2002, "93.040"), (Standards.NACE2, "96.04")),
        ((Standards.SKD2002, "93.050"), (Standards.NACE2, "85.51")),
        ((Standards.SKD2002, "93.050"), (Standards.NACE2, "96.09")),
        ((Standards.SKD2002, "95.000"), (Standards.NACE2, "97.00")),
        ((Standards.SKD2002, "99.000"), (Standards.NACE2, "99.00")),
        ((Standards.SKD2002, "74.203"), (Standards.NACE2, "71.12")),
        ((Standards.SKD2002, "93.050"), (Standards.NACE2, "88.91")),
        ((Standards.SKD2002, "15.810"), (Standards.NACE2, "10.89")),
        ((Standards.SKD2002, "20.100"), (Standards.NACE2, "16.29")),
        ((Standards.SKD2002, "28.520"), (Standards.NACE2, "33.12")),
        ((Standards.SKD2002, "29.550"), (Standards.NACE2, "28.95")),
    ],
)
