# -*- coding: utf-8 -*-
"""`SKD 2002 - Standard Classification of Activities 2002 <https://www.stat.si/statweb/en/methods/classifications>`_.
"""
from ...types import Category, Classification, Standard, Standards

SKD2002 = Standard(
    standard=Standards.SKD2002,
    classes=[
        Classification("01.110", "Pridelovanje žit in drugih poljščin", Category.CLASS),
        Classification("01.120", "Pridelovanje vrtnin, okrasnih rastlin, semen in sadik", Category.CLASS),
        Classification("01.131", "Vinogradništvo", Category.CLASS),
        Classification("01.132", "Sadjarstvo", Category.CLASS),
        Classification("01.210", "Reja govedi", Category.CLASS),
        Classification("01.220", "Reja ovac, koz, konj, oslov, mul in mezgov", Category.CLASS),
        Classification("01.230", "Reja prašičev", Category.CLASS),
        Classification("01.240", "Reja perutnine", Category.CLASS),
        Classification("01.250", "Reja drugih živali", Category.CLASS),
        Classification("01.300", "Mešano kmetijstvo", Category.CLASS),
        Classification("01.411", "Urejanje in vzdrževanje parkov, vrtov in zelenih športnih površin", Category.CLASS),
        Classification("01.412", "Druge storitve za rastlinsko pridelavo", Category.CLASS),
        Classification("01.420", "Storitve za živinorejo, razen veterinarskih storitev", Category.CLASS),
        Classification("01.500", "Lov in lovske storitve", Category.CLASS),
        Classification("02.010", "Gozdarstvo", Category.CLASS),
        Classification("02.020", "Gozdarske storitve", Category.CLASS),
        Classification("05.010", "Ribolov", Category.CLASS),
        Classification("05.020", "Ribogojstvo", Category.CLASS),
        Classification("10.100", "Pridobivanje črnega premoga", Category.CLASS),
        Classification("10.200", "Pridobivanje rjavega premoga in lignita", Category.CLASS),
        Classification("10.300", "Pridobivanje šote", Category.CLASS),
        Classification("11.100", "Pridobivanje surove nafte in zemeljskega plina", Category.CLASS),
        Classification(
            "11.200",
            "Storitve v zvezi s pridobivanjem surove nafte in zemeljskega plina, brez iskanja nahajališč",
            Category.CLASS,
        ),
        Classification("12.000", "Pridobivanje uranovih in torijevih rud", Category.CLASS),
        Classification("13.100", "Pridobivanje železove rude", Category.CLASS),
        Classification("13.200", "Pridobivanje rud neželeznih kovin, razen uranove in torijeve rude", Category.CLASS),
        Classification("14.110", "Pridobivanje okrasnega in gradbenega kamna", Category.CLASS),
        Classification("14.120", "Pridobivanje apnenca, sadre in krede", Category.CLASS),
        Classification("14.130", "Pridobivanje skrilavcev", Category.CLASS),
        Classification("14.210", "Pridobivanje gramoza in peska", Category.CLASS),
        Classification("14.220", "Pridobivanje gline in kaolina", Category.CLASS),
        Classification(
            "14.300", "Pridobivanje mineralov za kemijsko proizvodnjo in proizvodnjo mineralnih gnojil", Category.CLASS
        ),
        Classification("14.400", "Pridobivanje soli", Category.CLASS),
        Classification("14.500", "Pridobivanje drugih rudnin in kamnin", Category.CLASS),
        Classification("15.110", "Proizvodnja in konzerviranje mesa, razen perutninskega", Category.CLASS),
        Classification("15.120", "Proizvodnja in konzerviranje perutninskega mesa", Category.CLASS),
        Classification("15.130", "Proizvodnja mesnih izdelkov, tudi iz perutninskega mesa", Category.CLASS),
        Classification("15.200", "Predelava in konzerviranje rib, proizvodnja ribjih izdelkov", Category.CLASS),
        Classification("15.310", "Predelava in konzerviranje krompirja", Category.CLASS),
        Classification("15.320", "Proizvodnja sadnih in zelenjavnih sokov", Category.CLASS),
        Classification("15.330", "Druga predelava in konzerviranje sadja in zelenjave", Category.CLASS),
        Classification("15.410", "Proizvodnja surovega olja in maščob", Category.CLASS),
        Classification("15.420", "Proizvodnja rafiniranega olja in maščob", Category.CLASS),
        Classification("15.430", "Proizvodnja margarine in podobnih jedilnih maščob", Category.CLASS),
        Classification("15.510", "Mlekarstvo in sirarstvo, proizvodnja mlečnih izdelkov", Category.CLASS),
        Classification("15.520", "Proizvodnja sladoleda", Category.CLASS),
        Classification("15.610", "Mlinarstvo", Category.CLASS),
        Classification("15.710", "Proizvodnja krmil", Category.CLASS),
        Classification("15.720", "Proizvodnja hrane za hišne živali", Category.CLASS),
        Classification("15.810", "Proizvodnja kruha, svežega peciva in slaščic", Category.CLASS),
        Classification(
            "15.820", "Proizvodnja prepečenca in piškotov; proizvodnja trajnega peciva in slaščic", Category.CLASS
        ),
        Classification("15.830", "Proizvodnja sladkorja", Category.CLASS),
        Classification("15.840", "Proizvodnja kakava, čokolade in sladkornih izdelkov", Category.CLASS),
        Classification("15.850", "Proizvodnja testenin", Category.CLASS),
        Classification("15.860", "Predelava čaja in kave", Category.CLASS),
        Classification("15.870", "Proizvodnja različnih začimb, dišav in drugih dodatkov", Category.CLASS),
        Classification("15.880", "Proizvodnja homogeniziranih živil in dietetične hrane", Category.CLASS),
        Classification("15.890", "Proizvodnja drugih živil, d. n.", Category.CLASS),
        Classification("15.910", "Proizvodnja žganih pijač", Category.CLASS),
        Classification("15.920", "Proizvodnja etilnega alkohola", Category.CLASS),
        Classification("15.930", "Proizvodnja vina iz grozdja", Category.CLASS),
        Classification("15.940", "Proizvodnja drugih fermentiranih pijač in sadnih vin", Category.CLASS),
        Classification("15.950", "Proizvodnja aromatiziranih vin iz svežega grozdja", Category.CLASS),
        Classification("15.960", "Proizvodnja piva", Category.CLASS),
        Classification("15.970", "Proizvodnja slada", Category.CLASS),
        Classification("15.980", "Proizvodnja mineralnih vod in brezalkoholnih pijač", Category.CLASS),
        Classification("16.000", "Proizvodnja tobačnih izdelkov", Category.CLASS),
        Classification("17.100", "Priprava in predenje tekstilnih vlaken", Category.CLASS),
        Classification("17.20", "Tkanje tekstilij", Category.CLASS),
        Classification("17.300", "Plemenitenje tekstilij", Category.CLASS),
        Classification("17.400", "Proizvodnja tekstilnih izdelkov, razen oblačil", Category.CLASS),
        Classification("17.510", "Proizvodnja preprog in talnih oblog", Category.CLASS),
        Classification("17.520", "Proizvodnja vrvi, vrvic in mrež", Category.CLASS),
        Classification("17.530", "Proizvodnja netkanih tekstilij in izdelkov iz njih, razen oblačil", Category.CLASS),
        Classification("17.540", "Proizvodnja drugih tekstilij, d. n.", Category.CLASS),
        Classification("17.600", "Proizvodnja pletenih in kvačkanih materialov", Category.CLASS),
        Classification("17.710", "Proizvodnja nogavic", Category.CLASS),
        Classification("17.720", "Proizvodnja pletenih in kvačkanih oblačil", Category.CLASS),
        Classification("18.100", "Proizvodnja usnjenih oblačil", Category.CLASS),
        Classification("18.210", "Proizvodnja delovnih oblačil", Category.CLASS),
        Classification("18.220", "Proizvodnja drugih vrhnjih oblačil", Category.CLASS),
        Classification("18.230", "Proizvodnja spodnjega perila", Category.CLASS),
        Classification("18.240", "Proizvodnja športnih in drugih oblačil, pokrival ter dodatkov", Category.CLASS),
        Classification("18.300", "Strojenje in dodelava krzna; proizvodnja krznenih izdelkov", Category.CLASS),
        Classification("19.100", "Strojenje in dodelava usnja", Category.CLASS),
        Classification(
            "19.200", "Proizvodnja potovalne galanterije, sedlarskih in jermenarskih izdelkov", Category.CLASS
        ),
        Classification("19.300", "Proizvodnja obutve", Category.CLASS),
        Classification("20.100", "Žaganje in skobljanje lesa ter impregniranje lesa", Category.CLASS),
        Classification(
            "20.200",
            "Proizvodnja furnirja, vezanega in slojastega lesa, ivernih, vlaknenih in drugih plošč",
            Category.CLASS,
        ),
        Classification("20.300", "Stavbno mizarstvo", Category.CLASS),
        Classification("20.400", "Proizvodnja lesene embalaže", Category.CLASS),
        Classification("20.510", "Proizvodnja drugih izdelkov iz lesa", Category.CLASS),
        Classification("21.110", "Proizvodnja vlaknin", Category.CLASS),
        Classification("21.120", "Proizvodnja papirja in kartona", Category.CLASS),
        Classification(
            "21.210", "Proizvodnja valovitega papirja in kartona ter papirne in kartonske embalaže", Category.CLASS
        ),
        Classification(
            "21.220", "Proizvodnja gospodinjskih, higienskih in toaletnih potrebščin iz papirja", Category.CLASS
        ),
        Classification("21.230", "Proizvodnja pisarniških potrebščin iz papirja", Category.CLASS),
        Classification("21.240", "Proizvodnja tapet", Category.CLASS),
        Classification("21.250", "Proizvodnja drugih izdelkov iz papirja in kartona", Category.CLASS),
        Classification("22.110", "Izdajanje knjig", Category.CLASS),
        Classification("22.120", "Izdajanje časopisov", Category.CLASS),
        Classification("22.130", "Izdajanje revij in periodike", Category.CLASS),
        Classification("22.140", "Izdajanje posnetih nosilcev zvočnega zapisa", Category.CLASS),
        Classification("22.150", "Drugo založništvo", Category.CLASS),
        Classification("22.210", "Tiskanje časopisov", Category.CLASS),
        Classification("22.220", "Drugo tiskarstvo", Category.CLASS),
        Classification("22.230", "Knjigoveštvo", Category.CLASS),
        Classification("22.240", "Priprava za tisk", Category.CLASS),
        Classification("22.250", "Druge dejavnosti, povezane s tiskarstvom", Category.CLASS),
        Classification("22.310", "Razmnoževanje zvočnih zapisov", Category.CLASS),
        Classification("22.320", "Razmnoževanje video zapisov", Category.CLASS),
        Classification("22.330", "Razmnoževanje računalniških zapisov", Category.CLASS),
        Classification("23.100", "Proizvodnja koksa", Category.CLASS),
        Classification("23.200", "Proizvodnja naftnih derivatov", Category.CLASS),
        Classification("23.300", "Proizvodnja jedrskega goriva", Category.CLASS),
        Classification("24.110", "Proizvodnja tehničnih plinov", Category.CLASS),
        Classification("24.120", "Proizvodnja barvil in pigmentov", Category.CLASS),
        Classification("24.130", "Proizvodnja drugih anorganskih osnovnih kemikalij", Category.CLASS),
        Classification("24.140", "Proizvodnja drugih organskih osnovnih kemikalij", Category.CLASS),
        Classification("24.150", "Proizvodnja gnojil in dušikovih spojin", Category.CLASS),
        Classification("24.160", "Proizvodnja plastičnih mas v primarni obliki", Category.CLASS),
        Classification("24.170", "Proizvodnja sintetičnega kavčuka v primarni obliki", Category.CLASS),
        Classification("24.200", "Proizvodnja razkužil, pesticidov in drugih agrokemičnih izdelkov", Category.CLASS),
        Classification(
            "24.300", "Proizvodnja kritnih barv, lakov in podobnih premazov, tiskarskih barv in kitov", Category.CLASS
        ),
        Classification("24.410", "Proizvodnja farmacevtskih surovin", Category.CLASS),
        Classification("24.420", "Proizvodnja farmacevtskih preparatov", Category.CLASS),
        Classification("24.510", "Proizvodnja mil in pralnih sredstev, čistilnih in polirnih sredstev", Category.CLASS),
        Classification("24.520", "Proizvodnja parfumov in toaletnih sredstev", Category.CLASS),
        Classification("24.610", "Proizvodnja razstreliv", Category.CLASS),
        Classification("24.620", "Proizvodnja sredstev za lepljenje", Category.CLASS),
        Classification("24.630", "Proizvodnja eteričnih olj", Category.CLASS),
        Classification("24.640", "Proizvodnja fotografskih kemikalij", Category.CLASS),
        Classification("24.650", "Proizvodnja neposnetih nosilcev zapisa", Category.CLASS),
        Classification("24.660", "Proizvodnja drugih kemičnih izdelkov", Category.CLASS),
        Classification("24.700", "Proizvodnja umetnih vlaken", Category.CLASS),
        Classification("25.110", "Proizvodnja plaščev in zračnic za vozila", Category.CLASS),
        Classification("25.120", "Obnavljanje in protektiranje gum za vozila", Category.CLASS),
        Classification("25.130", "Proizvodnja drugih izdelkov iz gume", Category.CLASS),
        Classification("25.210", "Proizvodnja plošč, folij, cevi in profilov iz plastičnih mas", Category.CLASS),
        Classification("25.220", "Proizvodnja embalaže iz plastičnih mas", Category.CLASS),
        Classification("25.230", "Proizvodnja izdelkov iz plastičnih mas za gradbeništvo", Category.CLASS),
        Classification("25.240", "Proizvodnja drugih izdelkov iz plastičnih mas", Category.CLASS),
        Classification("26.110", "Proizvodnja ravnega stekla", Category.CLASS),
        Classification("26.120", "Oblikovanje in obdelava ravnega stekla", Category.CLASS),
        Classification("26.130", "Proizvodnja votlega stekla", Category.CLASS),
        Classification("26.140", "Proizvodnja steklenih vlaken", Category.CLASS),
        Classification(
            "26.150", "Proizvodnja in oblikovanje drugih vrst stekla ter tehničnih steklenih izdelkov", Category.CLASS
        ),
        Classification("26.210", "Proizvodnja gospodinjske in okrasne keramike", Category.CLASS),
        Classification("26.220", "Proizvodnja sanitarne keramike", Category.CLASS),
        Classification("26.230", "Proizvodnja izolatorjev in izolacijskih elementov iz keramike", Category.CLASS),
        Classification("26.240", "Proizvodnja druge tehnične keramike", Category.CLASS),
        Classification("26.250", "Proizvodnja drugih keramičnih izdelkov", Category.CLASS),
        Classification("26.260", "Proizvodnja ognjevzdržne keramike", Category.CLASS),
        Classification("26.300", "Proizvodnja zidnih in talnih keramičnih ploščic", Category.CLASS),
        Classification(
            "26.400", "Proizvodnja strešnikov, opeke in drugih keramičnih materialov za gradbeništvo", Category.CLASS
        ),
        Classification("26.510", "Proizvodnja cementa", Category.CLASS),
        Classification("26.520", "Proizvodnja apna", Category.CLASS),
        Classification("26.530", "Proizvodnja mavca", Category.CLASS),
        Classification("26.610", "Proizvodnja betonskih izdelkov za gradbeništvo", Category.CLASS),
        Classification("26.620", "Proizvodnja izdelkov iz mavca za gradbeništvo", Category.CLASS),
        Classification("26.630", "Proizvodnja sveže betonske mešanice", Category.CLASS),
        Classification("26.640", "Proizvodnja malte", Category.CLASS),
        Classification("26.650", "Proizvodnja izdelkov iz vlaknatega cementa", Category.CLASS),
        Classification("26.660", "Proizvodnja drugih izdelkov iz betona, cementa, mavca", Category.CLASS),
        Classification("26.700", "Obdelava naravnega kamna", Category.CLASS),
        Classification("26.810", "Proizvodnja brusilnih sredstev", Category.CLASS),
        Classification("26.820", "Proizvodnja drugih nekovinskih mineralnih izdelkov", Category.CLASS),
        Classification("27.100", "Proizvodnja železa, jekla, ferozlitin", Category.CLASS),
        Classification("27.210", "Proizvodnja litoželeznih cevi", Category.CLASS),
        Classification("27.220", "Proizvodnja jeklenih cevi", Category.CLASS),
        Classification("27.310", "Hladno vlečenje", Category.CLASS),
        Classification("27.320", "Hladno valjanje ozkega traku", Category.CLASS),
        Classification("27.330", "Hladno profiliranje", Category.CLASS),
        Classification("27.340", "Vlečenje žice", Category.CLASS),
        Classification("27.410", "Proizvodnja plemenitih kovin", Category.CLASS),
        Classification("27.420", "Proizvodnja aluminija", Category.CLASS),
        Classification("27.430", "Proizvodnja svinca, cinka in kositra", Category.CLASS),
        Classification("27.440", "Proizvodnja bakra", Category.CLASS),
        Classification("27.450", "Proizvodnja drugih neželeznih kovin", Category.CLASS),
        Classification("27.510", "Litje železa", Category.CLASS),
        Classification("27.520", "Litje jekla", Category.CLASS),
        Classification("27.530", "Litje lahkih kovin", Category.CLASS),
        Classification("27.540", "Litje drugih neželeznih kovin", Category.CLASS),
        Classification("28.110", "Proizvodnja kovinskih konstrukcij in njihovih delov", Category.CLASS),
        Classification("28.120", "Proizvodnja kovinskega stavbnega pohištva", Category.CLASS),
        Classification("28.210", "Proizvodnja kovinskih rezervoarjev, cistern, kontejnerjev", Category.CLASS),
        Classification("28.220", "Proizvodnja radiatorjev in kotlov za centralno ogrevanje", Category.CLASS),
        Classification("28.300", "Proizvodnja parnih kotlov, razen kotlov za centralno ogrevanje", Category.CLASS),
        Classification(
            "28.400", "Kovanje, stiskanje, vtiskovanje in valjanje kovin; prašna metalurgija", Category.CLASS
        ),
        Classification("28.511", "Prekrivanje kovin s kovino", Category.CLASS),
        Classification("28.512", "Druga površinska in toplotna obdelava kovin", Category.CLASS),
        Classification("28.520", "Splošna mehanična dela", Category.CLASS),
        Classification("28.610", "Proizvodnja rezilnega orodja", Category.CLASS),
        Classification("28.621", "Proizvodnja ročnega orodja", Category.CLASS),
        Classification("28.622", "Proizvodnja orodja za stroje", Category.CLASS),
        Classification("28.630", "Proizvodnja ključavnic, okovja", Category.CLASS),
        Classification("28.710", "Proizvodnja jeklenih bobnov, sodov in podobnih posod", Category.CLASS),
        Classification("28.720", "Proizvodnja lahke kovinske embalaže", Category.CLASS),
        Classification("28.730", "Proizvodnja izdelkov iz žice", Category.CLASS),
        Classification("28.740", "Proizvodnja vijačnega materiala, vezi, verig, vzmeti", Category.CLASS),
        Classification("28.750", "Proizvodnja drugih kovinskih izdelkov, d. n.", Category.CLASS),
        Classification("29.110", "Proizvodnja motorjev in turbin, razen za letala in motorna vozila", Category.CLASS),
        Classification("29.120", "Proizvodnja črpalk in kompresorjev", Category.CLASS),
        Classification("29.130", "Proizvodnja pip in ventilov", Category.CLASS),
        Classification(
            "29.140", "Proizvodnja ležajev, zobnikov in elementov za mehanski prenos energije", Category.CLASS
        ),
        Classification("29.210", "Proizvodnja peči in gorilnikov", Category.CLASS),
        Classification("29.220", "Proizvodnja dvigalnih in transportnih naprav", Category.CLASS),
        Classification(
            "29.230", "Proizvodnja hladilnih in prezračevalnih naprav, razen za gospodinjstva", Category.CLASS
        ),
        Classification("29.240", "Proizvodnja drugih naprav za splošno rabo", Category.CLASS),
        Classification("29.310", "Proizvodnja traktorjev", Category.CLASS),
        Classification("29.320", "Proizvodnja drugih kmetijskih in gozdarskih strojev", Category.CLASS),
        Classification("29.410", "Proizvodnja ročnih prenosnih obdelovalnih strojev", Category.CLASS),
        Classification("29.420", "Proizvodnja drugih strojev za obdelavo kovin", Category.CLASS),
        Classification("29.430", "Proizvodnja drugih obdelovalnih strojev", Category.CLASS),
        Classification("29.510", "Proizvodnja metalurških strojev", Category.CLASS),
        Classification("29.520", "Proizvodnja rudarskih in gradbenih strojev", Category.CLASS),
        Classification("29.530", "Proizvodnja strojev za živilsko in tobačno industrijo", Category.CLASS),
        Classification("29.540", "Proizvodnja strojev za tekstilno, oblačilno in usnjarsko industrijo", Category.CLASS),
        Classification("29.550", "Proizvodnja strojev za industrijo papirja in kartona", Category.CLASS),
        Classification("29.560", "Proizvodnja strojev za druge posebne namene", Category.CLASS),
        Classification("29.600", "Proizvodnja orožja in streliva", Category.CLASS),
        Classification("29.710", "Proizvodnja električnih gospodinjskih strojev", Category.CLASS),
        Classification("29.720", "Proizvodnja neelektričnih gospodinjskih strojev in naprav", Category.CLASS),
        Classification("30.010", "Proizvodnja pisarniških strojev", Category.CLASS),
        Classification("30.020", "Proizvodnja računalnikov in druge opreme za obdelavo podatkov", Category.CLASS),
        Classification("31.100", "Proizvodnja elektromotorjev, generatorjev in transformatorjev", Category.CLASS),
        Classification("31.200", "Proizvodnja naprav za distribucijo in krmiljenje elektrike", Category.CLASS),
        Classification("31.300", "Proizvodnja izoliranih električnih kablov in žic", Category.CLASS),
        Classification("31.400", "Proizvodnja akumulatorjev, primarnih členov in baterij", Category.CLASS),
        Classification("31.500", "Proizvodnja opreme za razsvetljavo in električnih svetilk", Category.CLASS),
        Classification("31.610", "Proizvodnja električne opreme za stroje in vozila", Category.CLASS),
        Classification("31.620", "Proizvodnja druge električne opreme", Category.CLASS),
        Classification(
            "32.100", "Proizvodnja elektronk, elektronskih ventilov in drugih elektronskih komponent", Category.CLASS
        ),
        Classification(
            "32.200",
            "Proizvodnja radijskih in televizijskih oddajnikov, telefonskih in telegrafskih naprav",
            Category.CLASS,
        ),
        Classification(
            "32.300",
            "Proizvodnja radijskih in televizijskih sprejemnikov, naprav in opreme za snemanje in predvajanje zvoka in slike",
            Category.CLASS,
        ),
        Classification(
            "33.100", "Proizvodnja medicinske in kirurške opreme in ortopedskih pripomočkov", Category.CLASS
        ),
        Classification(
            "33.200",
            "Proizvodnja merilnih, kontrolnih, preizkuševalnih, navigacijskih in drugih instrumentov in naprav, razen opreme za industrijsko procesno krmiljenje",
            Category.CLASS,
        ),
        Classification("33.300", "Proizvodnja opreme za industrijsko procesno krmiljenje", Category.CLASS),
        Classification("33.400", "Proizvodnja optičnih instrumentov in fotografske opreme", Category.CLASS),
        Classification("33.500", "Proizvodnja ur", Category.CLASS),
        Classification("34.100", "Proizvodnja motornih vozil", Category.CLASS),
        Classification(
            "34.200", "Proizvodnja karoserij za vozila; proizvodnja prikolic in polprikolic", Category.CLASS
        ),
        Classification(
            "34.300", "Proizvodnja delov in dodatne opreme za motorna vozila in njihove motorje", Category.CLASS
        ),
        Classification("35.110", "Gradnja in popravilo ladij", Category.CLASS),
        Classification("35.120", "Proizvodnja in popravilo čolnov za razvedrilo in šport", Category.CLASS),
        Classification("35.200", "Proizvodnja železniških in drugih tirnih vozil", Category.CLASS),
        Classification("35.300", "Proizvodnja zračnih in vesoljskih plovil", Category.CLASS),
        Classification("35.410", "Proizvodnja motornih koles", Category.CLASS),
        Classification("35.420", "Proizvodnja koles", Category.CLASS),
        Classification("35.430", "Proizvodnja vozil za invalide", Category.CLASS),
        Classification("35.500", "Proizvodnja drugih vozil", Category.CLASS),
        Classification("36.110", "Proizvodnja sedežnega pohištva", Category.CLASS),
        Classification(
            "36.120", "Proizvodnja pohištva za poslovne in prodajne prostore, razen sedežnega", Category.CLASS
        ),
        Classification("36.130", "Proizvodnja kuhinjskega pohištva, razen sedežnega", Category.CLASS),
        Classification("36.140", "Proizvodnja drugega pohištva", Category.CLASS),
        Classification("36.150", "Proizvodnja žimnic", Category.CLASS),
        Classification("36.210", "Kovanje kovancev", Category.CLASS),
        Classification("36.220", "Proizvodnja nakita in podobnih izdelkov", Category.CLASS),
        Classification("36.300", "Proizvodnja glasbil", Category.CLASS),
        Classification("36.400", "Proizvodnja športnih izdelkov", Category.CLASS),
        Classification("36.500", "Proizvodnja igralnih pripomočkov in igrač", Category.CLASS),
        Classification("36.610", "Proizvodnja bižuterije", Category.CLASS),
        Classification("36.620", "Proizvodnja metel in krtač", Category.CLASS),
        Classification("36.630", "Proizvodnja drugih izdelkov", Category.CLASS),
        Classification("37.100", "Reciklaža kovinskih ostankov in odpadkov", Category.CLASS),
        Classification("37.200", "Reciklaža nekovinskih ostankov in odpadkov", Category.CLASS),
        Classification("40.111", "Proizvodnja električne energije v HE", Category.CLASS),
        Classification("40.112", "Proizvodnja električne energije v TE in JE", Category.CLASS),
        Classification("40.113", "Druga proizvodnja električne energije", Category.CLASS),
        Classification("40.120", "Prenos električne energije", Category.CLASS),
        Classification("40.131", "Distribucija električne energije", Category.CLASS),
        Classification("40.132", "Trgovanje z električno energijo", Category.CLASS),
        Classification("40.210", "Proizvodnja plina", Category.CLASS),
        Classification("40.221", "Distribucija plinastih goriv po plinovodni mreži", Category.CLASS),
        Classification("40.222", "Trgovanje s plinastimi gorivi po plinovodni mreži", Category.CLASS),
        Classification("40.300", "Oskrba s paro in toplo vodo", Category.CLASS),
        Classification("41.000", "Zbiranje, čiščenje in distribucija vode", Category.CLASS),
        Classification("45.110", "Rušenje objektov in zemeljska dela", Category.CLASS),
        Classification("45.120", "Raziskovalno vrtanje in sondiranje", Category.CLASS),
        Classification("45.210", "Splošna gradbena dela", Category.CLASS),
        Classification("45.220", "Postavljanje ostrešij in krovska dela", Category.CLASS),
        Classification("45.230", "Gradnja cest, železniških prog, letališč in športnih objektov", Category.CLASS),
        Classification("45.240", "Gradnja vodnih objektov", Category.CLASS),
        Classification("45.250", "Druga gradbena dela, tudi dela specialnih strok", Category.CLASS),
        Classification("45.310", "Električne inštalacije", Category.CLASS),
        Classification("45.320", "Izolacijska dela", Category.CLASS),
        Classification("45.330", "Vodovodne, plinske in sanitarne inštalacije", Category.CLASS),
        Classification("45.340", "Druge inštalacije pri gradnjah", Category.CLASS),
        Classification("45.410", "Fasaderska in štukaterska dela", Category.CLASS),
        Classification("45.420", "Vgrajevanje stavbnega in drugega pohištva", Category.CLASS),
        Classification("45.430", "Oblaganje tal in sten", Category.CLASS),
        Classification("45.441", "Steklarska dela", Category.CLASS),
        Classification("45.442", "Pleskarska dela", Category.CLASS),
        Classification("45.450", "Druga zaključna gradbena dela", Category.CLASS),
        Classification(
            "45.500",
            "Dajanje strojev in naprav za gradnjo in rušenje v najem, skupaj z upravljalci strojev",
            Category.CLASS,
        ),
        Classification("50.101", "Trgovina na debelo z motornimi vozili", Category.CLASS),
        Classification("50.102", "Trgovina na drobno z motornimi vozili", Category.CLASS),
        Classification("50.103", "Posredništvo pri trgovini z motornimi vozili", Category.CLASS),
        Classification("50.200", "Vzdrževanje in popravila motornih vozil", Category.CLASS),
        Classification(
            "50.301", "Trgovina na debelo z rezervnimi deli in dodatno opremo za motorna vozila", Category.CLASS
        ),
        Classification(
            "50.302", "Trgovina na drobno z rezervnimi deli in dodatno opremo za motorna vozila", Category.CLASS
        ),
        Classification(
            "50.303", "Posredništvo pri trgovini z rezervnimi deli in dodatno opremo za motorna vozila", Category.CLASS
        ),
        Classification("50.401", "Trgovina na debelo z motornimi kolesi, deli in opremo", Category.CLASS),
        Classification("50.402", "Trgovina na drobno z motornimi kolesi, deli in opremo", Category.CLASS),
        Classification("50.403", "Posredništvo pri trgovini z motornimi kolesi, deli in opremo", Category.CLASS),
        Classification("50.404", "Vzdrževanje in popravila motornih koles", Category.CLASS),
        Classification("50.501", "Trgovina na drobno z lastnimi motornimi gorivi", Category.CLASS),
        Classification("50.502", "Posredništvo pri trgovini na drobno z motornimi gorivi", Category.CLASS),
        Classification(
            "51.110",
            "Posredništvo pri prodaji kmetijskih surovin, živali, tekstilnih surovin, polizdelkov",
            Category.CLASS,
        ),
        Classification("51.120", "Posredništvo pri prodaji goriv, rud, kovin, tehničnih kemikalij", Category.CLASS),
        Classification("51.130", "Posredništvo pri prodaji lesa in gradbenega materiala", Category.CLASS),
        Classification("51.140", "Posredništvo pri prodaji strojev, industrijske opreme, ladij, letal", Category.CLASS),
        Classification(
            "51.150",
            "Posredništvo pri prodaji pohištva, gospodinjskih predmetov in naprav, drugih  kovinskih izdelkov",
            Category.CLASS,
        ),
        Classification(
            "51.160", "Posredništvo pri prodaji tekstila, oblačil, obutve, usnjenih izdelkov", Category.CLASS
        ),
        Classification("51.170", "Posredništvo pri prodaji živil, pijač, tobačnih izdelkov", Category.CLASS),
        Classification("51.180", "Posredništvo, specializirano za prodajo drugih določenih izdelkov", Category.CLASS),
        Classification("51.190", "Posredništvo pri prodaji raznovrstnih izdelkov", Category.CLASS),
        Classification("51.210", "Trgovina na debelo z žiti, semeni in krmo", Category.CLASS),
        Classification("51.220", "Trgovina na debelo s cvetjem in rastlinami", Category.CLASS),
        Classification("51.230", "Trgovina na debelo z živimi živalmi", Category.CLASS),
        Classification("51.240", "Trgovina na debelo s kožami, usnjem", Category.CLASS),
        Classification("51.250", "Trgovina na debelo s surovim tobakom", Category.CLASS),
        Classification("51.310", "Trgovina na debelo s sadjem in vrtninami", Category.CLASS),
        Classification("51.320", "Trgovina na debelo z mesom in mesnimi izdelki", Category.CLASS),
        Classification(
            "51.330", "Trgovina na debelo z mlekom, mlečnimi izdelki, jajci, jedilnim oljem, maščobami", Category.CLASS
        ),
        Classification("51.340", "Trgovina na debelo z alkoholnimi in brezalkoholnimi pijačami", Category.CLASS),
        Classification("51.350", "Trgovina na debelo s tobačnimi izdelki", Category.CLASS),
        Classification("51.360", "Trgovina na debelo s sladkorjem, čokolado, sladkornimi izdelki", Category.CLASS),
        Classification("51.370", "Trgovina na debelo s kavo, čajem, kakavom, začimbami", Category.CLASS),
        Classification("51.380", "Trgovina na debelo z drugimi živili, tudi z ribami, raki, mehkužci", Category.CLASS),
        Classification(
            "51.390", "Nespecializirana trgovina na debelo z živili, pijačami, tobačnimi izdelki", Category.CLASS
        ),
        Classification("51.410", "Trgovina na debelo s tekstilom", Category.CLASS),
        Classification("51.420", "Trgovina na debelo z oblačili in obutvijo", Category.CLASS),
        Classification(
            "51.430", "Trgovina na debelo z električnimi gospodinjskimi, radijskimi in TV napravami", Category.CLASS
        ),
        Classification("51.440", "Trgovina na debelo s porcelanom, steklenino, tapetami, čistili", Category.CLASS),
        Classification("51.450", "Trgovina na debelo s parfumi in kozmetiko", Category.CLASS),
        Classification(
            "51.460", "Trgovina na debelo s farmacevtskimi izdelki in medicinskimi pripomočki", Category.CLASS
        ),
        Classification("51.470", "Trgovina na debelo z drugimi izdelki široke porabe", Category.CLASS),
        Classification("51.510", "Trgovina na debelo s trdimi, tekočimi in plinastimi gorivi", Category.CLASS),
        Classification("51.520", "Trgovina na debelo s kovinami in rudami", Category.CLASS),
        Classification(
            "51.530", "Trgovina na debelo z lesom, gradbenim materialom in sanitarno opremo", Category.CLASS
        ),
        Classification(
            "51.540",
            "Trgovina na debelo s kovinskimi proizvodi, inštalacijskim materialom, napravami za ogrevanje",
            Category.CLASS,
        ),
        Classification("51.550", "Trgovina na debelo s kemičnimi proizvodi", Category.CLASS),
        Classification("51.560", "Trgovina na debelo z drugimi polizdelki", Category.CLASS),
        Classification("51.570", "Trgovina na debelo z ostanki in odpadki", Category.CLASS),
        Classification("51.810", "Trgovina na debelo z obdelovalnimi stroji", Category.CLASS),
        Classification("51.820", "Trgovina na debelo z gradbenimi stroji", Category.CLASS),
        Classification("51.830", "Trgovina na debelo s stroji za tekstilno industrijo", Category.CLASS),
        Classification("51.840", "Trgovina na debelo z računalniško opremo", Category.CLASS),
        Classification("51.850", "Trgovina na debelo s pisarniškimi stroji in opremo", Category.CLASS),
        Classification("51.860", "Trgovina na debelo z elektronskimi deli in opremo", Category.CLASS),
        Classification(
            "51.870",
            "Trgovina na debelo z drugimi stroji in napravami za industrijo, trgovino, navigacijo",
            Category.CLASS,
        ),
        Classification(
            "51.880", "Trgovina na debelo s kmetijskimi stroji, priključki, kmetijskim orodjem", Category.CLASS
        ),
        Classification("51.900", "Druga trgovina na debelo", Category.CLASS),
        Classification(
            "52.110", "Trgovina na drobno v nespecializiranih prodajalnah, pretežno z živili", Category.CLASS
        ),
        Classification("52.120", "Trgovina na drobno v drugih nespecializiranih prodajalnah", Category.CLASS),
        Classification("52.210", "Trgovina na drobno s svežim sadjem in zelenjavo", Category.CLASS),
        Classification("52.220", "Trgovina na drobno z mesom in mesnimi izdelki", Category.CLASS),
        Classification("52.230", "Trgovina na drobno z ribami, raki, mehkužci", Category.CLASS),
        Classification(
            "52.240", "Trgovina na drobno s kruhom, pecivom, testeninami, sladkornimi izdelki", Category.CLASS
        ),
        Classification("52.250", "Trgovina na drobno z alkoholnimi in brezalkoholnimi pijačami", Category.CLASS),
        Classification("52.260", "Trgovina na drobno s tobačnimi izdelki", Category.CLASS),
        Classification("52.270", "Trgovina na drobno v drugih specializiranih prodajalnah z živili", Category.CLASS),
        Classification("52.310", "Dejavnost lekarn", Category.CLASS),
        Classification("52.320", "Trgovina na drobno z medicinskimi in ortopedskimi izdelki", Category.CLASS),
        Classification("52.330", "Trgovina na drobno s kozmetičnimi in toaletnimi izdelki", Category.CLASS),
        Classification("52.410", "Trgovina na drobno s tekstilom", Category.CLASS),
        Classification("52.420", "Trgovina na drobno z oblačili", Category.CLASS),
        Classification("52.430", "Trgovina na drobno z obutvijo in usnjenimi izdelki", Category.CLASS),
        Classification(
            "52.440", "Trgovina na drobno s pohištvom, svetili in drugimi predmeti za gospodinjstvo", Category.CLASS
        ),
        Classification(
            "52.450", "Trgovina na drobno z električnimi gospodinjskimi, radijskimi in TV napravami", Category.CLASS
        ),
        Classification("52.461", "Trgovina na drobno s kovinskimi izdelki", Category.CLASS),
        Classification("52.462", "Trgovina na drobno z barvami, laki in drugimi kemičnimi sredstvi", Category.CLASS),
        Classification("52.463", "Trgovina na drobno z gradbenim materialom", Category.CLASS),
        Classification("52.471", "Dejavnost knjigarn", Category.CLASS),
        Classification("52.472", "Trgovina na drobno s časopisi, revijami", Category.CLASS),
        Classification("52.473", "Dejavnost papirnic", Category.CLASS),
        Classification("52.481", "Trgovina na drobno s športno opremo", Category.CLASS),
        Classification("52.482", "Dejavnost cvetličarn", Category.CLASS),
        Classification("52.483", "Trgovina na drobno z vrtnarsko opremo in hišnimi živalmi", Category.CLASS),
        Classification("52.484", "Trgovina na drobno s kurivom", Category.CLASS),
        Classification("52.485", "Trgovina na drobno z urami, nakitom, bižuterijo", Category.CLASS),
        Classification("52.486", "Trgovina na drobno z umetniškimi izdelki", Category.CLASS),
        Classification("52.487", "Trgovina na drobno z igračami, otroško opremo", Category.CLASS),
        Classification("52.488", "Trgovina na drobno v drugih specializiranih prodajalnah, d. n.", Category.CLASS),
        Classification("52.500", "Trgovina na drobno z rabljenim blagom", Category.CLASS),
        Classification("52.610", "Trgovina na drobno po pošti", Category.CLASS),
        Classification("52.620", "Trgovina na drobno na tržnicah in stojnicah", Category.CLASS),
        Classification("52.630", "Druga trgovina na drobno zunaj prodajaln", Category.CLASS),
        Classification("52.710", "Popravilo obutve in drugih usnjenih izdelkov", Category.CLASS),
        Classification("52.720", "Popravilo električnih gospodinjskih naprav", Category.CLASS),
        Classification("52.730", "Popravilo ur, nakita", Category.CLASS),
        Classification("52.740", "Druga popravila izdelkov široke porabe", Category.CLASS),
        Classification("55.100", "Dejavnost hotelov in podobnih obratov", Category.CLASS),
        Classification("55.210", "Dejavnost planinskih domov in mladinskih prenočišč", Category.CLASS),
        Classification("55.220", "Dejavnost kampov", Category.CLASS),
        Classification("55.231", "Dejavnost otroških letovišč, počitniških in sindikalnih domov", Category.CLASS),
        Classification("55.232", "Dejavnost turističnih kmetij z nastanitvijo", Category.CLASS),
        Classification("55.233", "Oddajanje sob gospodinjstev gostom", Category.CLASS),
        Classification("55.234", "Dejavnost dijaških, študentskih domov, internatov", Category.CLASS),
        Classification("55.239", "Druge nastanitve za krajši čas", Category.CLASS),
        Classification("55.301", "Dejavnost restavracij in gostiln", Category.CLASS),
        Classification("55.302", "Dejavnost okrepčevalnic, samopostrežnih restavracij", Category.CLASS),
        Classification("55.303", "Dejavnost slaščičarn, kavarn", Category.CLASS),
        Classification("55.304", "Dejavnost premičnih in provizoričnih gostinskih obratov", Category.CLASS),
        Classification("55.305", "Dejavnost turističnih kmetij brez nastanitve", Category.CLASS),
        Classification("55.400", "Točenje pijač", Category.CLASS),
        Classification("55.510", "Dejavnost menz", Category.CLASS),
        Classification("55.520", "Priprava in dostava hrane (catering)", Category.CLASS),
        Classification("60.100", "Železniški promet", Category.CLASS),
        Classification("60.211", "Mestni in primestni potniški promet na rednih linijah", Category.CLASS),
        Classification("60.212", "Medkrajevni potniški cestni promet na rednih linijah", Category.CLASS),
        Classification("60.213", "Dejavnost žičnic, vlečnic", Category.CLASS),
        Classification("60.220", "Dejavnost taksistov", Category.CLASS),
        Classification("60.230", "Drug kopenski potniški promet", Category.CLASS),
        Classification("60.240", "Cestni tovorni promet", Category.CLASS),
        Classification("60.300", "Cevovodni transport", Category.CLASS),
        Classification("61.100", "Pomorski promet", Category.CLASS),
        Classification("61.200", "Promet po rekah, jezerih, prekopih", Category.CLASS),
        Classification("62.100", "Zračni promet na rednih linijah", Category.CLASS),
        Classification("62.200", "Izredni zračni promet", Category.CLASS),
        Classification("63.110", "Prekladanje", Category.CLASS),
        Classification("63.120", "Skladiščenje", Category.CLASS),
        Classification("63.210", "Druge pomožne dejavnosti v kopenskem prometu", Category.CLASS),
        Classification("63.220", "Druge pomožne dejavnosti v vodnem prometu", Category.CLASS),
        Classification("63.230", "Druge pomožne dejavnosti v zračnem prometu", Category.CLASS),
        Classification(
            "63.300",
            "Dejavnost potovalnih agencij in organizatorjev potovanj; s turizmom povezane dejavnosti",
            Category.CLASS,
        ),
        Classification("64.120", "Kurirska dejavnost, razen javne pošte", Category.CLASS),
        Classification("64.200", "Telekomunikacije", Category.CLASS),
        Classification("65.110", "Dejavnost centralne banke", Category.CLASS),
        Classification("65.121", "Dejavnost bank", Category.CLASS),
        Classification("65.122", "Dejavnost hranilnic", Category.CLASS),
        Classification("65.210", "Finančni zakup (leasing)", Category.CLASS),
        Classification("65.220", "Drugo kreditiranje", Category.CLASS),
        Classification("65.230", "Drugo finančno posredništvo, d. n.", Category.CLASS),
        Classification("66.010", "Življenjsko zavarovanje", Category.CLASS),
        Classification("66.020", "Dejavnost pokojninskih skladov", Category.CLASS),
        Classification("66.030", "Druga zavarovanja, razen življenjskega", Category.CLASS),
        Classification("67.110", "Dejavnost finančnih trgov", Category.CLASS),
        Classification("67.120", "Posredništvo z vrednostnimi papirji", Category.CLASS),
        Classification("67.130", "Pomožne dejavnosti, povezane s finančnim posredništvom", Category.CLASS),
        Classification("67.200", "Pomožne dejavnosti v zavarovalništvu in pokojninskih skladih", Category.CLASS),
        Classification("70.110", "Organizacija izvedbe nepremičninskih projektov za trg", Category.CLASS),
        Classification("70.120", "Trgovanje z lastnimi nepremičninami", Category.CLASS),
        Classification("70.200", "Dajanje lastnih nepremičnin v najem", Category.CLASS),
        Classification("70.310", "Dejavnost agencij za posredništvo v prometu z nepremičninami", Category.CLASS),
        Classification("70.320", "Upravljanje z nepremičninami za plačilo ali po pogodbi", Category.CLASS),
        Classification("71.100", "Dajanje avtomobilov v najem", Category.CLASS),
        Classification("71.210", "Dajanje drugih kopenskih vozil v najem", Category.CLASS),
        Classification("71.220", "Dajanje ladij  v najem", Category.CLASS),
        Classification("71.230", "Dajanje zračnih plovil v najem", Category.CLASS),
        Classification("71.310", "Dajanje kmetijskih strojev in opreme v najem", Category.CLASS),
        Classification("71.320", "Dajanje gradbenih strojev in opreme v najem", Category.CLASS),
        Classification("71.330", "Dajanje pisarniške in računalniške opreme v najem", Category.CLASS),
        Classification("71.340", "Dajanje drugih strojev in opreme v najem", Category.CLASS),
        Classification("71.401", "Izposojanje športne opreme", Category.CLASS),
        Classification("71.402", "Dejavnost videotek", Category.CLASS),
        Classification("71.403", "Izposojanje drugih izdelkov široke porabe", Category.CLASS),
        Classification("72.100", "Svetovanje o računalniških napravah", Category.CLASS),
        Classification("72.210", "Razvoj in založba programskih paketov", Category.CLASS),
        Classification("72.220", "Oskrba z računalniškimi programi in svetovanje", Category.CLASS),
        Classification("72.300", "Obdelava podatkov", Category.CLASS),
        Classification("72.400", "Omrežne podatkovne storitve", Category.CLASS),
        Classification(
            "72.500",
            "Vzdrževanje in popravila pisarniških in računskih strojev ter računalniških naprav",
            Category.CLASS,
        ),
        Classification("72.600", "Druge računalniške dejavnosti", Category.CLASS),
        Classification("73.101", "Raziskovanje in eksperimentalni razvoj na področju naravoslovja", Category.CLASS),
        Classification("73.102", "Raziskovanje in eksperimentalni razvoj na področju tehnologije", Category.CLASS),
        Classification(
            "73.103",
            "Raziskovanje in eksperimentalni razvoj na področju kmetijstva in sorodnih dejavnosti",
            Category.CLASS,
        ),
        Classification("73.104", "Raziskovanje in eksperimentalni razvoj na področju medicine", Category.CLASS),
        Classification("73.201", "Raziskovanje in eksperimentalni razvoj na področju družboslovja", Category.CLASS),
        Classification("73.202", "Raziskovanje in eksperimentalni razvoj na področju humanistike", Category.CLASS),
        Classification("74.110", "Pravno svetovanje", Category.CLASS),
        Classification(
            "74.120", "Računovodske, knjigovodske in revizijske dejavnosti, davčno svetovanje", Category.CLASS
        ),
        Classification("74.130", "Raziskovanje trga in javnega mnenja", Category.CLASS),
        Classification("74.140", "Podjetniško in poslovno svetovanje", Category.CLASS),
        Classification("74.150", "Dejavnost holdingov", Category.CLASS),
        Classification(
            "74.201",
            "Geodetsko, geološko, geofizikalno, geokemično in drugo opazovanje, meritve, kartiranje",
            Category.CLASS,
        ),
        Classification("74.202", "Prostorsko, urbanistično in krajinsko načrtovanje", Category.CLASS),
        Classification(
            "74.203", "Arhitekturno in gradbeno projektiranje in z njim povezano tehnično svetovanje", Category.CLASS
        ),
        Classification("74.204", "Drugo projektiranje in tehnično svetovanje", Category.CLASS),
        Classification("74.300", "Tehnično preizkušanje in analiziranje", Category.CLASS),
        Classification("74.400", "Oglaševanje", Category.CLASS),
        Classification("74.500", "Dejavnost posredovanja in zaposlovanja delovne sile", Category.CLASS),
        Classification("74.600", "Poizvedovalne dejavnosti in varovanje", Category.CLASS),
        Classification("74.700", "Čiščenje objektov in opreme", Category.CLASS),
        Classification("74.810", "Fotografska dejavnost", Category.CLASS),
        Classification("74.820", "Pakiranje", Category.CLASS),
        Classification("74.851", "Prevajanje", Category.CLASS),
        Classification("74.852", "Fotokopiranje in drugo razmnoževanje", Category.CLASS),
        Classification("74.853", "Druga splošna tajniška opravila", Category.CLASS),
        Classification("74.860", "Dejavnost klicnih centrov", Category.CLASS),
        Classification("74.871", "Prirejanje razstav, sejmov in kongresov", Category.CLASS),
        Classification("74.872", "Oblikovanje, aranžerstvo, dekoraterstvo", Category.CLASS),
        Classification("74.873", "Druge poslovne dejavnosti, d. n.", Category.CLASS),
        Classification("75.110", "Splošna dejavnost javne uprave", Category.CLASS),
        Classification(
            "75.120",
            "Urejanje zdravstva, izobraževanja, kulture in drugih socialnih storitev, razen obveznega socialnega zavarovanja",
            Category.CLASS,
        ),
        Classification("75.130", "Urejanje gospodarskih področij za učinkovitejše poslovanje", Category.CLASS),
        Classification("75.140", "Dejavnost pomožnih služb vlade", Category.CLASS),
        Classification("75.210", "Zunanje zadeve", Category.CLASS),
        Classification("75.220", "Obramba", Category.CLASS),
        Classification("75.230", "Pravosodje", Category.CLASS),
        Classification("75.240", "Javna varnost, zakonitost in red", Category.CLASS),
        Classification("75.250", "Zaščita in reševanje pri požarih in nesrečah", Category.CLASS),
        Classification("75.300", "Obvezno socialno zavarovanje", Category.CLASS),
        Classification("80.101", "Dejavnost vrtcev in predšolsko izobraževanje", Category.CLASS),
        Classification("80.102", "Osnovnošolsko splošno izobraževanje", Category.CLASS),
        Classification("80.103", "Dejavnost zavodov za izobraževanje otrok z motnjami v razvoju", Category.CLASS),
        Classification("80.210", "Srednješolsko splošno izobraževanje", Category.CLASS),
        Classification("80.220", "Srednješolsko poklicno in strokovno izobraževanje", Category.CLASS),
        Classification("80.301", "Višje strokovno izobraževanje", Category.CLASS),
        Classification("80.302", "Visoko strokovno izobraževanje", Category.CLASS),
        Classification("80.303", "Univerzitetno izobraževanje", Category.CLASS),
        Classification("80.410", "Dejavnost vozniških šol", Category.CLASS),
        Classification("80.421", "Dejavnost glasbenih in drugih umetniških šol", Category.CLASS),
        Classification("80.422", "Drugo izobraževanje, izpopolnjevanje in usposabljanje, d. n.", Category.CLASS),
        Classification("85.110", "Bolnišnična zdravstvena dejavnost", Category.CLASS),
        Classification("85.121", "Splošna izvenbolnišnična zdravstvena dejavnost", Category.CLASS),
        Classification("85.122", "Specialistična izvenbolnišnična zdravstvena dejavnost", Category.CLASS),
        Classification("85.130", "Zobozdravstvena dejavnost", Category.CLASS),
        Classification("85.141", "Samostojne zdravstvene dejavnosti, ki jih ne opravljajo zdravniki", Category.CLASS),
        Classification("85.142", "Alternativne oblike zdravljenja", Category.CLASS),
        Classification("85.143", "Druge zdravstvene dejavnosti, d. n.", Category.CLASS),
        Classification("85.200", "Veterinarstvo", Category.CLASS),
        Classification("85.311", "Dejavnost domov za starejše", Category.CLASS),
        Classification("85.319", "Drugo socialno varstvo z nastanitvijo", Category.CLASS),
        Classification("85.321", "Dejavnost centrov za socialno delo", Category.CLASS),
        Classification("85.322", "Dejavnost invalidskih organizacij", Category.CLASS),
        Classification("85.323", "Dejavnost dobrodelnih organizacij", Category.CLASS),
        Classification("85.324", "Dejavnost varstveno delovnih centrov", Category.CLASS),
        Classification("85.329", "Druge socialne dejavnosti", Category.CLASS),
        Classification("90.010", "Ravnanje z odplakami", Category.CLASS),
        Classification("90.021", "Zbiranje in odvoz odpadkov", Category.CLASS),
        Classification(
            "90.022", "Dejavnost deponij, sežiganje in drugi načini odstranjevanja trdnih odpadkov", Category.CLASS
        ),
        Classification("90.023", "Ravnanje z nevarnimi odpadki", Category.CLASS),
        Classification("90.031", "Čiščenje okolja", Category.CLASS),
        Classification("90.032", "Druge dejavnosti javne higiene", Category.CLASS),
        Classification("91.110", "Dejavnost poslovnih in delodajalskih združenj", Category.CLASS),
        Classification("91.120", "Dejavnost strokovnih združenj", Category.CLASS),
        Classification("91.200", "Dejavnost sindikatov", Category.CLASS),
        Classification("91.310", "Dejavnost verskih organizacij", Category.CLASS),
        Classification("91.320", "Dejavnost političnih organizacij", Category.CLASS),
        Classification("91.330", "Dejavnost drugih članskih organizacij", Category.CLASS),
        Classification("92.110", "Snemanje filmov in video filmov", Category.CLASS),
        Classification("92.120", "Distribucija filmov in video filmov", Category.CLASS),
        Classification("92.130", "Kinematografska dejavnost", Category.CLASS),
        Classification("92.200", "Radijska in televizijska dejavnost", Category.CLASS),
        Classification("92.310", "Umetniško ustvarjanje in poustvarjanje", Category.CLASS),
        Classification("92.320", "Obratovanje objektov za kulturne prireditve", Category.CLASS),
        Classification("92.330", "Dejavnost sejmišč in zabaviščnih parkov", Category.CLASS),
        Classification("92.340", "Druge razvedrilne dejavnosti", Category.CLASS),
        Classification("92.400", "Dejavnost tiskovnih agencij", Category.CLASS),
        Classification("92.511", "Dejavnost knjižnic", Category.CLASS),
        Classification("92.512", "Dejavnost arhivov", Category.CLASS),
        Classification("92.521", "Dejavnost muzejev", Category.CLASS),
        Classification("92.522", "Varstvo kulturne dediščine", Category.CLASS),
        Classification("92.530", "Dejavnost botaničnih in živalskih vrtov ter naravnih rezervatov", Category.CLASS),
        Classification("92.610", "Obratovanje športnih objektov", Category.CLASS),
        Classification("92.621", "Dejavnost marin", Category.CLASS),
        Classification("92.622", "Dejavnost smučarskih centrov in smučišč", Category.CLASS),
        Classification("92.623", "Druge športne dejavnosti", Category.CLASS),
        Classification("92.711", "Prirejanje klasičnih iger na srečo", Category.CLASS),
        Classification("92.712", "Dejavnost igralnic", Category.CLASS),
        Classification("92.720", "Druge dejavnosti za sprostitev, d. n.", Category.CLASS),
        Classification("93.010", "Dejavnost pralnic in kemičnih čistilnic", Category.CLASS),
        Classification("93.021", "Frizerska dejavnost", Category.CLASS),
        Classification("93.022", "Kozmetična dejavnost", Category.CLASS),
        Classification("93.023", "Pedikerska dejavnost", Category.CLASS),
        Classification("93.030", "Pogrebna dejavnost", Category.CLASS),
        Classification("93.040", "Dejavnost salonov za nego telesa", Category.CLASS),
        Classification("93.050", "Druge osebne storitve", Category.CLASS),
        Classification("95.000", "Zasebna gospodinjstva z zaposlenim osebjem", Category.CLASS),
        Classification("99.000", "Eksteritorialne organizacije in združenja", Category.CLASS),
        Classification("15.810", "Proizvodnja kruha,svežega peciva in slaščic", Category.CLASS),
        Classification("20.100", "Žaganje in skobljanje lesa ter impregniranje", Category.CLASS),
    ],
)
