# -*- coding: utf-8 -*-
"""`NAICS2017 Standard <https://www.census.gov/eos/www/naics/2017NAICS/6-digit_2017_Codes.xlsx>`_.
"""
from ...types import Classification, Standard, Standards

NAICS2017 = Standard(
    standard=Standards.NAICS2017,
    classes=[
        Classification("111110", "Soybean Farming"),
        Classification("111120", "Oilseed (except Soybean) Farming"),
        Classification("111130", "Dry Pea and Bean Farming"),
        Classification("111140", "Wheat Farming"),
        Classification("111150", "Corn Farming"),
        Classification("111160", "Rice Farming"),
        Classification("111191", "Oilseed and Grain Combination Farming"),
        Classification("111199", "All Other Grain Farming"),
        Classification("111211", "Potato Farming"),
        Classification("111219", "Other Vegetable (except Potato) and Melon Farming"),
        Classification("111310", "Orange Groves"),
        Classification("111320", "Citrus (except Orange) Groves"),
        Classification("111331", "Apple Orchards"),
        Classification("111332", "Grape Vineyards"),
        Classification("111333", "Strawberry Farming"),
        Classification("111334", "Berry (except Strawberry) Farming"),
        Classification("111335", "Tree Nut Farming"),
        Classification("111336", "Fruit and Tree Nut Combination Farming"),
        Classification("111339", "Other Noncitrus Fruit Farming"),
        Classification("111411", "Mushroom Production"),
        Classification("111419", "Other Food Crops Grown Under Cover"),
        Classification("111421", "Nursery and Tree Production"),
        Classification("111422", "Floriculture Production"),
        Classification("111910", "Tobacco Farming"),
        Classification("111920", "Cotton Farming"),
        Classification("111930", "Sugarcane Farming"),
        Classification("111940", "Hay Farming"),
        Classification("111991", "Sugar Beet Farming"),
        Classification("111992", "Peanut Farming"),
        Classification("111998", "All Other Miscellaneous Crop Farming"),
        Classification("112111", "Beef Cattle Ranching and Farming"),
        Classification("112112", "Cattle Feedlots"),
        Classification("112120", "Dairy Cattle and Milk Production"),
        Classification("112130", "Dual-Purpose Cattle Ranching and Farming"),
        Classification("112210", "Hog and Pig Farming"),
        Classification("112310", "Chicken Egg Production"),
        Classification("112320", "Broilers and Other Meat Type Chicken Production"),
        Classification("112330", "Turkey Production"),
        Classification("112340", "Poultry Hatcheries"),
        Classification("112390", "Other Poultry Production"),
        Classification("112410", "Sheep Farming"),
        Classification("112420", "Goat Farming"),
        Classification("112511", "Finfish Farming and Fish Hatcheries"),
        Classification("112512", "Shellfish Farming"),
        Classification("112519", "Other Aquaculture"),
        Classification("112910", "Apiculture"),
        Classification("112920", "Horses and Other Equine Production"),
        Classification("112930", "Fur-Bearing Animal and Rabbit Production"),
        Classification("112990", "All Other Animal Production"),
        Classification("113110", "Timber Tract Operations"),
        Classification("113210", "Forest Nurseries and Gathering of Forest Products"),
        Classification("113310", "Logging"),
        Classification("114111", "Finfish Fishing"),
        Classification("114112", "Shellfish Fishing"),
        Classification("114119", "Other Marine Fishing"),
        Classification("114210", "Hunting and Trapping"),
        Classification("115111", "Cotton Ginning"),
        Classification("115112", "Soil Preparation, Planting, and Cultivating"),
        Classification("115113", "Crop Harvesting, Primarily by Machine"),
        Classification("115114", "Postharvest Crop Activities (except Cotton Ginning)"),
        Classification("115115", "Farm Labor Contractors and Crew Leaders"),
        Classification("115116", "Farm Management Services"),
        Classification("115210", "Support Activities for Animal Production"),
        Classification("115310", "Support Activities for Forestry"),
        Classification("211120", "Crude Petroleum Extraction"),
        Classification("211130", "Natural Gas Extraction"),
        Classification("212111", "Bituminous Coal and Lignite Surface Mining"),
        Classification("212112", "Bituminous Coal Underground Mining"),
        Classification("212113", "Anthracite Mining"),
        Classification("212210", "Iron Ore Mining"),
        Classification("212221", "Gold Ore Mining"),
        Classification("212222", "Silver Ore Mining"),
        Classification("212230", "Copper, Nickel, Lead, and Zinc Mining"),
        Classification("212291", "Uranium-Radium-Vanadium Ore Mining"),
        Classification("212299", "All Other Metal Ore Mining"),
        Classification("212311", "Dimension Stone Mining and Quarrying"),
        Classification("212312", "Crushed and Broken Limestone Mining and Quarrying"),
        Classification("212313", "Crushed and Broken Granite Mining and Quarrying"),
        Classification("212319", "Other Crushed and Broken Stone Mining and Quarrying"),
        Classification("212321", "Construction Sand and Gravel Mining"),
        Classification("212322", "Industrial Sand Mining"),
        Classification("212324", "Kaolin and Ball Clay Mining"),
        Classification("212325", "Clay and Ceramic and Refractory Minerals Mining"),
        Classification("212391", "Potash, Soda, and Borate Mineral Mining"),
        Classification("212392", "Phosphate Rock Mining"),
        Classification("212393", "Other Chemical and Fertilizer Mineral Mining"),
        Classification("212399", "All Other Nonmetallic Mineral Mining"),
        Classification("213111", "Drilling Oil and Gas Wells"),
        Classification("213112", "Support Activities for Oil and Gas Operations"),
        Classification("213113", "Support Activities for Coal Mining"),
        Classification("213114", "Support Activities for Metal Mining"),
        Classification(
            "213115",
            "Support Activities for Nonmetallic Minerals (except Fuels) Mining",
        ),
        Classification("221111", "Hydroelectric Power Generation"),
        Classification("221112", "Fossil Fuel Electric Power Generation"),
        Classification("221113", "Nuclear Electric Power Generation"),
        Classification("221114", "Solar Electric Power Generation"),
        Classification("221115", "Wind Electric Power Generation"),
        Classification("221116", "Geothermal Electric Power Generation"),
        Classification("221117", "Biomass Electric Power Generation"),
        Classification("221118", "Other Electric Power Generation"),
        Classification("221121", "Electric Bulk Power Transmission and Control"),
        Classification("221122", "Electric Power Distribution"),
        Classification("221210", "Natural Gas Distribution"),
        Classification("221310", "Water Supply and Irrigation Systems"),
        Classification("221320", "Sewage Treatment Facilities"),
        Classification("221330", "Steam and Air-Conditioning Supply"),
        Classification(
            "236115",
            "New Single-Family Housing Construction (except For-Sale Builders)",
        ),
        Classification("236116", "New Multifamily Housing Construction (except For-Sale Builders)"),
        Classification("236117", "New Housing For-Sale Builders"),
        Classification("236118", "Residential Remodelers"),
        Classification("236210", "Industrial Building Construction"),
        Classification("236220", "Commercial and Institutional Building Construction"),
        Classification("237110", "Water and Sewer Line and Related Structures Construction"),
        Classification("237120", "Oil and Gas Pipeline and Related Structures Construction"),
        Classification("237130", "Power and Communication Line and Related Structures Construction"),
        Classification("237210", "Land Subdivision"),
        Classification("237310", "Highway, Street, and Bridge Construction"),
        Classification("237990", "Other Heavy and Civil Engineering Construction"),
        Classification("238110", "Poured Concrete Foundation and Structure Contractors"),
        Classification("238120", "Structural Steel and Precast Concrete Contractors"),
        Classification("238130", "Framing Contractors"),
        Classification("238140", "Masonry Contractors"),
        Classification("238150", "Glass and Glazing Contractors"),
        Classification("238160", "Roofing Contractors"),
        Classification("238170", "Siding Contractors"),
        Classification("238190", "Other Foundation, Structure, and Building Exterior Contractors"),
        Classification("238210", "Electrical Contractors and Other Wiring Installation Contractors"),
        Classification("238220", "Plumbing, Heating, and Air-Conditioning Contractors"),
        Classification("238290", "Other Building Equipment Contractors"),
        Classification("238310", "Drywall and Insulation Contractors"),
        Classification("238320", "Painting and Wall Covering Contractors"),
        Classification("238330", "Flooring Contractors"),
        Classification("238340", "Tile and Terrazzo Contractors"),
        Classification("238350", "Finish Carpentry Contractors"),
        Classification("238390", "Other Building Finishing Contractors"),
        Classification("238910", "Site Preparation Contractors"),
        Classification("238990", "All Other Specialty Trade Contractors"),
        Classification("311111", "Dog and Cat Food Manufacturing"),
        Classification("311119", "Other Animal Food Manufacturing"),
        Classification("311211", "Flour Milling"),
        Classification("311212", "Rice Milling"),
        Classification("311213", "Malt Manufacturing"),
        Classification("311221", "Wet Corn Milling"),
        Classification("311224", "Soybean and Other Oilseed Processing"),
        Classification("311225", "Fats and Oils Refining and Blending"),
        Classification("311230", "Breakfast Cereal Manufacturing"),
        Classification("311313", "Beet Sugar Manufacturing"),
        Classification("311314", "Cane Sugar Manufacturing"),
        Classification("311340", "Nonchocolate Confectionery Manufacturing"),
        Classification("311351", "Chocolate and Confectionery Manufacturing from Cacao Beans"),
        Classification("311352", "Confectionery Manufacturing from Purchased Chocolate"),
        Classification("311411", "Frozen Fruit, Juice, and Vegetable Manufacturing"),
        Classification("311412", "Frozen Specialty Food Manufacturing"),
        Classification("311421", "Fruit and Vegetable Canning"),
        Classification("311422", "Specialty Canning"),
        Classification("311423", "Dried and Dehydrated Food Manufacturing"),
        Classification("311511", "Fluid Milk Manufacturing"),
        Classification("311512", "Creamery Butter Manufacturing"),
        Classification("311513", "Cheese Manufacturing"),
        Classification("311514", "Dry, Condensed, and Evaporated Dairy Product Manufacturing"),
        Classification("311520", "Ice Cream and Frozen Dessert Manufacturing"),
        Classification("311611", "Animal (except Poultry) Slaughtering"),
        Classification("311612", "Meat Processed from Carcasses"),
        Classification("311613", "Rendering and Meat Byproduct Processing"),
        Classification("311615", "Poultry Processing"),
        Classification("311710", "Seafood Product Preparation and Packaging"),
        Classification("311811", "Retail Bakeries"),
        Classification("311812", "Commercial Bakeries"),
        Classification("311813", "Frozen Cakes, Pies, and Other Pastries Manufacturing"),
        Classification("311821", "Cookie and Cracker Manufacturing"),
        Classification(
            "311824",
            "Dry Pasta, Dough, and Flour Mixes Manufacturing from Purchased Flour",
        ),
        Classification("311830", "Tortilla Manufacturing"),
        Classification("311911", "Roasted Nuts and Peanut Butter Manufacturing"),
        Classification("311919", "Other Snack Food Manufacturing"),
        Classification("311920", "Coffee and Tea Manufacturing"),
        Classification("311930", "Flavoring Syrup and Concentrate Manufacturing"),
        Classification("311941", "Mayonnaise, Dressing, and Other Prepared Sauce Manufacturing"),
        Classification("311942", "Spice and Extract Manufacturing"),
        Classification("311991", "Perishable Prepared Food Manufacturing"),
        Classification("311999", "All Other Miscellaneous Food Manufacturing"),
        Classification("312111", "Soft Drink Manufacturing"),
        Classification("312112", "Bottled Water Manufacturing"),
        Classification("312113", "Ice Manufacturing"),
        Classification("312120", "Breweries"),
        Classification("312130", "Wineries"),
        Classification("312140", "Distilleries"),
        Classification("312230", "Tobacco Manufacturing"),
        Classification("313110", "Fiber, Yarn, and Thread Mills"),
        Classification("313210", "Broadwoven Fabric Mills"),
        Classification("313220", "Narrow Fabric Mills and Schiffli Machine Embroidery"),
        Classification("313230", "Nonwoven Fabric Mills"),
        Classification("313240", "Knit Fabric Mills"),
        Classification("313310", "Textile and Fabric Finishing Mills"),
        Classification("313320", "Fabric Coating Mills"),
        Classification("314110", "Carpet and Rug Mills"),
        Classification("314120", "Curtain and Linen Mills"),
        Classification("314910", "Textile Bag and Canvas Mills"),
        Classification("314994", "Rope, Cordage, Twine, Tire Cord, and Tire Fabric Mills"),
        Classification("314999", "All Other Miscellaneous Textile Product Mills"),
        Classification("315110", "Hosiery and Sock Mills"),
        Classification("315190", "Other Apparel Knitting Mills"),
        Classification("315210", "Cut and Sew Apparel Contractors"),
        Classification("315220", "Men’s and Boys’ Cut and Sew Apparel Manufacturing"),
        Classification("315240", "Women’s, Girls’, and Infants’ Cut and Sew Apparel Manufacturing"),
        Classification("315280", "Other Cut and Sew Apparel Manufacturing"),
        Classification("315990", "Apparel Accessories and Other Apparel Manufacturing"),
        Classification("316110", "Leather and Hide Tanning and Finishing"),
        Classification("316210", "Footwear Manufacturing"),
        Classification("316992", "Women's Handbag and Purse Manufacturing"),
        Classification("316998", "All Other Leather Good and Allied Product Manufacturing"),
        Classification("321113", "Sawmills"),
        Classification("321114", "Wood Preservation"),
        Classification("321211", "Hardwood Veneer and Plywood Manufacturing"),
        Classification("321212", "Softwood Veneer and Plywood Manufacturing"),
        Classification("321213", "Engineered Wood Member (except Truss) Manufacturing"),
        Classification("321214", "Truss Manufacturing"),
        Classification("321219", "Reconstituted Wood Product Manufacturing"),
        Classification("321911", "Wood Window and Door Manufacturing"),
        Classification("321912", "Cut Stock, Resawing Lumber, and Planing"),
        Classification("321918", "Other Millwork (including Flooring)"),
        Classification("321920", "Wood Container and Pallet Manufacturing"),
        Classification("321991", "Manufactured Home (Mobile Home) Manufacturing"),
        Classification("321992", "Prefabricated Wood Building Manufacturing"),
        Classification("321999", "All Other Miscellaneous Wood Product Manufacturing"),
        Classification("322110", "Pulp Mills"),
        Classification("322121", "Paper (except Newsprint) Mills"),
        Classification("322122", "Newsprint Mills"),
        Classification("322130", "Paperboard Mills"),
        Classification("322211", "Corrugated and Solid Fiber Box Manufacturing"),
        Classification("322212", "Folding Paperboard Box Manufacturing"),
        Classification("322219", "Other Paperboard Container Manufacturing"),
        Classification("322220", "Paper Bag and Coated and Treated Paper Manufacturing"),
        Classification("322230", "Stationery Product Manufacturing"),
        Classification("322291", "Sanitary Paper Product Manufacturing"),
        Classification("322299", "All Other Converted Paper Product Manufacturing"),
        Classification("323111", "Commercial Printing (except Screen and Books)"),
        Classification("323113", "Commercial Screen Printing"),
        Classification("323117", "Books Printing"),
        Classification("323120", "Support Activities for Printing"),
        Classification("324110", "Petroleum Refineries"),
        Classification("324121", "Asphalt Paving Mixture and Block Manufacturing"),
        Classification("324122", "Asphalt Shingle and Coating Materials Manufacturing"),
        Classification("324191", "Petroleum Lubricating Oil and Grease Manufacturing"),
        Classification("324199", "All Other Petroleum and Coal Products Manufacturing"),
        Classification("325110", "Petrochemical Manufacturing"),
        Classification("325120", "Industrial Gas Manufacturing"),
        Classification("325130", "Synthetic Dye and Pigment Manufacturing"),
        Classification("325180", "Other Basic Inorganic Chemical Manufacturing"),
        Classification("325193", "Ethyl Alcohol Manufacturing"),
        Classification(
            "325194",
            "Cyclic Crude, Intermediate, and Gum and Wood Chemical Manufacturing",
        ),
        Classification("325199", "All Other Basic Organic Chemical Manufacturing"),
        Classification("325211", "Plastics Material and Resin Manufacturing"),
        Classification("325212", "Synthetic Rubber Manufacturing"),
        Classification("325220", "Artificial and Synthetic Fibers and Filaments Manufacturing"),
        Classification("325311", "Nitrogenous Fertilizer Manufacturing"),
        Classification("325312", "Phosphatic Fertilizer Manufacturing"),
        Classification("325314", "Fertilizer (Mixing Only) Manufacturing"),
        Classification("325320", "Pesticide and Other Agricultural Chemical Manufacturing"),
        Classification("325411", "Medicinal and Botanical Manufacturing"),
        Classification("325412", "Pharmaceutical Preparation Manufacturing"),
        Classification("325413", "In-Vitro Diagnostic Substance Manufacturing"),
        Classification("325414", "Biological Product (except Diagnostic) Manufacturing"),
        Classification("325510", "Paint and Coating Manufacturing"),
        Classification("325520", "Adhesive Manufacturing"),
        Classification("325611", "Soap and Other Detergent Manufacturing"),
        Classification("325612", "Polish and Other Sanitation Good Manufacturing"),
        Classification("325613", "Surface Active Agent Manufacturing"),
        Classification("325620", "Toilet Preparation Manufacturing"),
        Classification("325910", "Printing Ink Manufacturing"),
        Classification("325920", "Explosives Manufacturing"),
        Classification("325991", "Custom Compounding of Purchased Resins"),
        Classification("325992", "Photographic Film, Paper, Plate, and Chemical Manufacturing"),
        Classification(
            "325998",
            "All Other Miscellaneous Chemical Product and Preparation Manufacturing",
        ),
        Classification("326111", "Plastics Bag and Pouch Manufacturing"),
        Classification(
            "326112",
            "Plastics Packaging Film and Sheet (including Laminated) Manufacturing",
        ),
        Classification(
            "326113",
            "Unlaminated Plastics Film and Sheet (except Packaging) Manufacturing",
        ),
        Classification("326121", "Unlaminated Plastics Profile Shape Manufacturing"),
        Classification("326122", "Plastics Pipe and Pipe Fitting Manufacturing"),
        Classification(
            "326130",
            "Laminated Plastics Plate, Sheet (except Packaging), and Shape Manufacturing",
        ),
        Classification("326140", "Polystyrene Foam Product Manufacturing"),
        Classification(
            "326150",
            "Urethane and Other Foam Product (except Polystyrene) Manufacturing",
        ),
        Classification("326160", "Plastics Bottle Manufacturing"),
        Classification("326191", "Plastics Plumbing Fixture Manufacturing"),
        Classification("326199", "All Other Plastics Product Manufacturing"),
        Classification("326211", "Tire Manufacturing (except Retreading)"),
        Classification("326212", "Tire Retreading"),
        Classification("326220", "Rubber and Plastics Hoses and Belting Manufacturing"),
        Classification("326291", "Rubber Product Manufacturing for Mechanical Use"),
        Classification("326299", "All Other Rubber Product Manufacturing"),
        Classification("327110", "Pottery, Ceramics, and Plumbing Fixture Manufacturing"),
        Classification("327120", "Clay Building Material and Refractories Manufacturing"),
        Classification("327211", "Flat Glass Manufacturing"),
        Classification("327212", "Other Pressed and Blown Glass and Glassware Manufacturing"),
        Classification("327213", "Glass Container Manufacturing"),
        Classification("327215", "Glass Product Manufacturing Made of Purchased Glass"),
        Classification("327310", "Cement Manufacturing"),
        Classification("327320", "Ready-Mix Concrete Manufacturing"),
        Classification("327331", "Concrete Block and Brick Manufacturing"),
        Classification("327332", "Concrete Pipe Manufacturing"),
        Classification("327390", "Other Concrete Product Manufacturing"),
        Classification("327410", "Lime Manufacturing"),
        Classification("327420", "Gypsum Product Manufacturing"),
        Classification("327910", "Abrasive Product Manufacturing"),
        Classification("327991", "Cut Stone and Stone Product Manufacturing"),
        Classification("327992", "Ground or Treated Mineral and Earth Manufacturing"),
        Classification("327993", "Mineral Wool Manufacturing"),
        Classification(
            "327999",
            "All Other Miscellaneous Nonmetallic Mineral Product Manufacturing",
        ),
        Classification("331110", "Iron and Steel Mills and Ferroalloy Manufacturing"),
        Classification("331210", "Iron and Steel Pipe and Tube Manufacturing from Purchased Steel"),
        Classification("331221", "Rolled Steel Shape Manufacturing"),
        Classification("331222", "Steel Wire Drawing"),
        Classification("331313", "Alumina Refining and Primary Aluminum Production"),
        Classification("331314", "Secondary Smelting and Alloying of Aluminum"),
        Classification("331315", "Aluminum Sheet, Plate, and Foil Manufacturing"),
        Classification("331318", "Other Aluminum Rolling, Drawing, and Extruding"),
        Classification("331410", "Nonferrous Metal (except Aluminum) Smelting and Refining"),
        Classification("331420", "Copper Rolling, Drawing, Extruding, and Alloying"),
        Classification(
            "331491",
            "Nonferrous Metal (except Copper and Aluminum) Rolling, Drawing, and Extruding",
        ),
        Classification(
            "331492",
            "Secondary Smelting, Refining, and Alloying of Nonferrous Metal (except Copper and Aluminum)",
        ),
        Classification("331511", "Iron Foundries"),
        Classification("331512", "Steel Investment Foundries"),
        Classification("331513", "Steel Foundries (except Investment)"),
        Classification("331523", "Nonferrous Metal Die-Casting Foundries"),
        Classification("331524", "Aluminum Foundries (except Die-Casting)"),
        Classification("331529", "Other Nonferrous Metal Foundries (except Die-Casting)"),
        Classification("332111", "Iron and Steel Forging"),
        Classification("332112", "Nonferrous Forging"),
        Classification("332114", "Custom Roll Forming"),
        Classification("332117", "Powder Metallurgy Part Manufacturing"),
        Classification(
            "332119",
            "Metal Crown, Closure, and Other Metal Stamping (except Automotive)",
        ),
        Classification(
            "332215",
            "Metal Kitchen Cookware, Utensil, Cutlery, and Flatware (except Precious) Manufacturing",
        ),
        Classification("332216", "Saw Blade and Handtool Manufacturing"),
        Classification("332311", "Prefabricated Metal Building and Component Manufacturing"),
        Classification("332312", "Fabricated Structural Metal Manufacturing"),
        Classification("332313", "Plate Work Manufacturing"),
        Classification("332321", "Metal Window and Door Manufacturing"),
        Classification("332322", "Sheet Metal Work Manufacturing"),
        Classification("332323", "Ornamental and Architectural Metal Work Manufacturing"),
        Classification("332410", "Power Boiler and Heat Exchanger Manufacturing"),
        Classification("332420", "Metal Tank (Heavy Gauge) Manufacturing"),
        Classification("332431", "Metal Can Manufacturing"),
        Classification("332439", "Other Metal Container Manufacturing"),
        Classification("332510", "Hardware Manufacturing"),
        Classification("332613", "Spring Manufacturing"),
        Classification("332618", "Other Fabricated Wire Product Manufacturing"),
        Classification("332710", "Machine Shops"),
        Classification("332721", "Precision Turned Product Manufacturing"),
        Classification("332722", "Bolt, Nut, Screw, Rivet, and Washer Manufacturing"),
        Classification("332811", "Metal Heat Treating"),
        Classification(
            "332812",
            "Metal Coating, Engraving (except Jewelry and Silverware), and Allied Services to Manufacturers",
        ),
        Classification("332813", "Electroplating, Plating, Polishing, Anodizing, and Coloring"),
        Classification("332911", "Industrial Valve Manufacturing"),
        Classification("332912", "Fluid Power Valve and Hose Fitting Manufacturing"),
        Classification("332913", "Plumbing Fixture Fitting and Trim Manufacturing"),
        Classification("332919", "Other Metal Valve and Pipe Fitting Manufacturing"),
        Classification("332991", "Ball and Roller Bearing Manufacturing"),
        Classification("332992", "Small Arms Ammunition Manufacturing"),
        Classification("332993", "Ammunition (except Small Arms) Manufacturing"),
        Classification("332994", "Small Arms, Ordnance, and Ordnance Accessories Manufacturing"),
        Classification("332996", "Fabricated Pipe and Pipe Fitting Manufacturing"),
        Classification("332999", "All Other Miscellaneous Fabricated Metal Product Manufacturing"),
        Classification("333111", "Farm Machinery and Equipment Manufacturing"),
        Classification(
            "333112",
            "Lawn and Garden Tractor and Home Lawn and Garden Equipment Manufacturing",
        ),
        Classification("333120", "Construction Machinery Manufacturing"),
        Classification("333131", "Mining Machinery and Equipment Manufacturing"),
        Classification("333132", "Oil and Gas Field Machinery and Equipment Manufacturing"),
        Classification("333241", "Food Product Machinery Manufacturing"),
        Classification("333242", "Semiconductor Machinery Manufacturing"),
        Classification("333243", "Sawmill, Woodworking, and Paper Machinery Manufacturing"),
        Classification("333244", "Printing Machinery and Equipment Manufacturing"),
        Classification("333249", "Other Industrial Machinery Manufacturing"),
        Classification("333314", "Optical Instrument and Lens Manufacturing"),
        Classification("333316", "Photographic and Photocopying Equipment Manufacturing"),
        Classification("333318", "Other Commercial and Service Industry Machinery Manufacturing"),
        Classification(
            "333413",
            "Industrial and Commercial Fan and Blower and Air Purification Equipment Manufacturing",
        ),
        Classification("333414", "Heating Equipment (except Warm Air Furnaces) Manufacturing"),
        Classification(
            "333415",
            "Air-Conditioning and Warm Air Heating Equipment and Commercial and Industrial Refrigeration Equipment Manufacturing",
        ),
        Classification("333511", "Industrial Mold Manufacturing"),
        Classification("333514", "Special Die and Tool, Die Set, Jig, and Fixture Manufacturing"),
        Classification("333515", "Cutting Tool and Machine Tool Accessory Manufacturing"),
        Classification("333517", "Machine Tool Manufacturing"),
        Classification("333519", "Rolling Mill and Other Metalworking Machinery Manufacturing"),
        Classification("333611", "Turbine and Turbine Generator Set Units Manufacturing"),
        Classification(
            "333612",
            "Speed Changer, Industrial High-Speed Drive, and Gear Manufacturing",
        ),
        Classification("333613", "Mechanical Power Transmission Equipment Manufacturing"),
        Classification("333618", "Other Engine Equipment Manufacturing"),
        Classification("333912", "Air and Gas Compressor Manufacturing"),
        Classification("333914", "Measuring, Dispensing, and Other Pumping Equipment Manufacturing"),
        Classification("333921", "Elevator and Moving Stairway Manufacturing"),
        Classification("333922", "Conveyor and Conveying Equipment Manufacturing"),
        Classification(
            "333923",
            "Overhead Traveling Crane, Hoist, and Monorail System Manufacturing",
        ),
        Classification(
            "333924",
            "Industrial Truck, Tractor, Trailer, and Stacker Machinery Manufacturing",
        ),
        Classification("333991", "Power-Driven Handtool Manufacturing"),
        Classification("333992", "Welding and Soldering Equipment Manufacturing"),
        Classification("333993", "Packaging Machinery Manufacturing"),
        Classification("333994", "Industrial Process Furnace and Oven Manufacturing"),
        Classification("333995", "Fluid Power Cylinder and Actuator Manufacturing"),
        Classification("333996", "Fluid Power Pump and Motor Manufacturing"),
        Classification("333997", "Scale and Balance Manufacturing"),
        Classification("333999", "All Other Miscellaneous General Purpose Machinery Manufacturing"),
        Classification("334111", "Electronic Computer Manufacturing"),
        Classification("334112", "Computer Storage Device Manufacturing"),
        Classification(
            "334118",
            "Computer Terminal and Other Computer Peripheral Equipment Manufacturing",
        ),
        Classification("334210", "Telephone Apparatus Manufacturing"),
        Classification(
            "334220",
            "Radio and Television Broadcasting and Wireless Communications Equipment Manufacturing",
        ),
        Classification("334290", "Other Communications Equipment Manufacturing"),
        Classification("334310", "Audio and Video Equipment Manufacturing"),
        Classification("334412", "Bare Printed Circuit Board Manufacturing"),
        Classification("334413", "Semiconductor and Related Device Manufacturing"),
        Classification(
            "334416",
            "Capacitor, Resistor, Coil, Transformer, and Other Inductor Manufacturing",
        ),
        Classification("334417", "Electronic Connector Manufacturing"),
        Classification("334418", "Printed Circuit Assembly (Electronic Assembly) Manufacturing"),
        Classification("334419", "Other Electronic Component Manufacturing"),
        Classification("334510", "Electromedical and Electrotherapeutic Apparatus Manufacturing"),
        Classification(
            "334511",
            "Search, Detection, Navigation, Guidance, Aeronautical, and Nautical System and Instrument Manufacturing",
        ),
        Classification(
            "334512",
            "Automatic Environmental Control Manufacturing for Residential, Commercial, and Appliance Use",
        ),
        Classification(
            "334513",
            "Instruments and Related Products Manufacturing for Measuring, Displaying, and Controlling Industrial Process Variables",
        ),
        Classification("334514", "Totalizing Fluid Meter and Counting Device Manufacturing"),
        Classification(
            "334515",
            "Instrument Manufacturing for Measuring and Testing Electricity and Electrical Signals",
        ),
        Classification("334516", "Analytical Laboratory Instrument Manufacturing"),
        Classification("334517", "Irradiation Apparatus Manufacturing"),
        Classification("334519", "Other Measuring and Controlling Device Manufacturing"),
        Classification("334613", "Blank Magnetic and Optical Recording Media Manufacturing"),
        Classification(
            "334614",
            "Software and Other Prerecorded Compact Disc, Tape, and Record Reproducing",
        ),
        Classification("335110", "Electric Lamp Bulb and Part Manufacturing"),
        Classification("335121", "Residential Electric Lighting Fixture Manufacturing"),
        Classification(
            "335122",
            "Commercial, Industrial, and Institutional Electric Lighting Fixture Manufacturing",
        ),
        Classification("335129", "Other Lighting Equipment Manufacturing"),
        Classification("335210", "Small Electrical Appliance Manufacturing"),
        Classification("335220", "Major Household Appliance Manufacturing"),
        Classification("335311", "Power, Distribution, and Specialty Transformer Manufacturing"),
        Classification("335312", "Motor and Generator Manufacturing"),
        Classification("335313", "Switchgear and Switchboard Apparatus Manufacturing"),
        Classification("335314", "Relay and Industrial Control Manufacturing"),
        Classification("335911", "Storage Battery Manufacturing"),
        Classification("335912", "Primary Battery Manufacturing"),
        Classification("335921", "Fiber Optic Cable Manufacturing"),
        Classification("335929", "Other Communication and Energy Wire Manufacturing"),
        Classification("335931", "Current-Carrying Wiring Device Manufacturing"),
        Classification("335932", "Noncurrent-Carrying Wiring Device Manufacturing"),
        Classification("335991", "Carbon and Graphite Product Manufacturing"),
        Classification(
            "335999",
            "All Other Miscellaneous Electrical Equipment and Component Manufacturing",
        ),
        Classification("336111", "Automobile Manufacturing"),
        Classification("336112", "Light Truck and Utility Vehicle Manufacturing"),
        Classification("336120", "Heavy Duty Truck Manufacturing"),
        Classification("336211", "Motor Vehicle Body Manufacturing"),
        Classification("336212", "Truck Trailer Manufacturing"),
        Classification("336213", "Motor Home Manufacturing"),
        Classification("336214", "Travel Trailer and Camper Manufacturing"),
        Classification("336310", "Motor Vehicle Gasoline Engine and Engine Parts Manufacturing"),
        Classification("336320", "Motor Vehicle Electrical and Electronic Equipment Manufacturing"),
        Classification(
            "336330",
            "Motor Vehicle Steering and Suspension Components (except Spring) Manufacturing",
        ),
        Classification("336340", "Motor Vehicle Brake System Manufacturing"),
        Classification("336350", "Motor Vehicle Transmission and Power Train Parts Manufacturing"),
        Classification("336360", "Motor Vehicle Seating and Interior Trim Manufacturing"),
        Classification("336370", "Motor Vehicle Metal Stamping"),
        Classification("336390", "Other Motor Vehicle Parts Manufacturing"),
        Classification("336411", "Aircraft Manufacturing"),
        Classification("336412", "Aircraft Engine and Engine Parts Manufacturing"),
        Classification("336413", "Other Aircraft Parts and Auxiliary Equipment Manufacturing"),
        Classification("336414", "Guided Missile and Space Vehicle Manufacturing"),
        Classification(
            "336415",
            "Guided Missile and Space Vehicle Propulsion Unit and Propulsion Unit Parts Manufacturing",
        ),
        Classification(
            "336419",
            "Other Guided Missile and Space Vehicle Parts and Auxiliary Equipment Manufacturing",
        ),
        Classification("336510", "Railroad Rolling Stock Manufacturing"),
        Classification("336611", "Ship Building and Repairing"),
        Classification("336612", "Boat Building"),
        Classification("336991", "Motorcycle, Bicycle, and Parts Manufacturing"),
        Classification("336992", "Military Armored Vehicle, Tank, and Tank Component Manufacturing"),
        Classification("336999", "All Other Transportation Equipment Manufacturing"),
        Classification("337110", "Wood Kitchen Cabinet and Countertop Manufacturing"),
        Classification("337121", "Upholstered Household Furniture Manufacturing"),
        Classification("337122", "Nonupholstered Wood Household Furniture Manufacturing"),
        Classification("337124", "Metal Household Furniture Manufacturing"),
        Classification("337125", "Household Furniture (except Wood and Metal) Manufacturing"),
        Classification("337127", "Institutional Furniture Manufacturing"),
        Classification("337211", "Wood Office Furniture Manufacturing"),
        Classification("337212", "Custom Architectural Woodwork and Millwork Manufacturing"),
        Classification("337214", "Office Furniture (except Wood) Manufacturing"),
        Classification("337215", "Showcase, Partition, Shelving, and Locker Manufacturing"),
        Classification("337910", "Mattress Manufacturing"),
        Classification("337920", "Blind and Shade Manufacturing"),
        Classification("339112", "Surgical and Medical Instrument Manufacturing"),
        Classification("339113", "Surgical Appliance and Supplies Manufacturing"),
        Classification("339114", "Dental Equipment and Supplies Manufacturing"),
        Classification("339115", "Ophthalmic Goods Manufacturing"),
        Classification("339116", "Dental Laboratories"),
        Classification("339910", "Jewelry and Silverware Manufacturing"),
        Classification("339920", "Sporting and Athletic Goods Manufacturing"),
        Classification("339930", "Doll, Toy, and Game Manufacturing"),
        Classification("339940", "Office Supplies (except Paper) Manufacturing"),
        Classification("339950", "Sign Manufacturing"),
        Classification("339991", "Gasket, Packing, and Sealing Device Manufacturing"),
        Classification("339992", "Musical Instrument Manufacturing"),
        Classification("339993", "Fastener, Button, Needle, and Pin Manufacturing"),
        Classification("339994", "Broom, Brush, and Mop Manufacturing"),
        Classification("339995", "Burial Casket Manufacturing"),
        Classification("339999", "All Other Miscellaneous Manufacturing"),
        Classification("423110", "Automobile and Other Motor Vehicle Merchant Wholesalers"),
        Classification("423120", "Motor Vehicle Supplies and New Parts Merchant Wholesalers"),
        Classification("423130", "Tire and Tube Merchant Wholesalers"),
        Classification("423140", "Motor Vehicle Parts (Used) Merchant Wholesalers"),
        Classification("423210", "Furniture Merchant Wholesalers"),
        Classification("423220", "Home Furnishing Merchant Wholesalers"),
        Classification("423310", "Lumber, Plywood, Millwork, and Wood Panel Merchant Wholesalers"),
        Classification(
            "423320",
            "Brick, Stone, and Related Construction Material Merchant Wholesalers",
        ),
        Classification("423330", "Roofing, Siding, and Insulation Material Merchant Wholesalers"),
        Classification("423390", "Other Construction Material Merchant Wholesalers"),
        Classification("423410", "Photographic Equipment and Supplies Merchant Wholesalers"),
        Classification("423420", "Office Equipment Merchant Wholesalers"),
        Classification(
            "423430",
            "Computer and Computer Peripheral Equipment and Software Merchant Wholesalers",
        ),
        Classification("423440", "Other Commercial Equipment Merchant Wholesalers"),
        Classification(
            "423450",
            "Medical, Dental, and Hospital Equipment and Supplies Merchant Wholesalers",
        ),
        Classification("423460", "Ophthalmic Goods Merchant Wholesalers"),
        Classification("423490", "Other Professional Equipment and Supplies Merchant Wholesalers"),
        Classification("423510", "Metal Service Centers and Other Metal Merchant Wholesalers"),
        Classification("423520", "Coal and Other Mineral and Ore Merchant Wholesalers"),
        Classification(
            "423610",
            "Electrical Apparatus and Equipment, Wiring Supplies, and Related Equipment Merchant Wholesalers",
        ),
        Classification(
            "423620",
            "Household Appliances, Electric Housewares, and Consumer Electronics Merchant Wholesalers",
        ),
        Classification("423690", "Other Electronic Parts and Equipment Merchant Wholesalers"),
        Classification("423710", "Hardware Merchant Wholesalers"),
        Classification(
            "423720",
            "Plumbing and Heating Equipment and Supplies (Hydronics) Merchant Wholesalers",
        ),
        Classification(
            "423730",
            "Warm Air Heating and Air-Conditioning Equipment and Supplies Merchant Wholesalers",
        ),
        Classification("423740", "Refrigeration Equipment and Supplies Merchant Wholesalers"),
        Classification(
            "423810",
            "Construction and Mining (except Oil Well) Machinery and Equipment Merchant Wholesalers",
        ),
        Classification("423820", "Farm and Garden Machinery and Equipment Merchant Wholesalers"),
        Classification("423830", "Industrial Machinery and Equipment Merchant Wholesalers"),
        Classification("423840", "Industrial Supplies Merchant Wholesalers"),
        Classification(
            "423850",
            "Service Establishment Equipment and Supplies Merchant Wholesalers",
        ),
        Classification(
            "423860",
            "Transportation Equipment and Supplies (except Motor Vehicle) Merchant Wholesalers",
        ),
        Classification(
            "423910",
            "Sporting and Recreational Goods and Supplies Merchant Wholesalers",
        ),
        Classification("423920", "Toy and Hobby Goods and Supplies Merchant Wholesalers"),
        Classification("423930", "Recyclable Material Merchant Wholesalers"),
        Classification(
            "423940",
            "Jewelry, Watch, Precious Stone, and Precious Metal Merchant Wholesalers",
        ),
        Classification("423990", "Other Miscellaneous Durable Goods Merchant Wholesalers"),
        Classification("424110", "Printing and Writing Paper Merchant Wholesalers"),
        Classification("424120", "Stationery and Office Supplies Merchant Wholesalers"),
        Classification("424130", "Industrial and Personal Service Paper Merchant Wholesalers"),
        Classification("424210", "Drugs and Druggists' Sundries Merchant Wholesalers"),
        Classification("424310", "Piece Goods, Notions, and Other Dry Goods Merchant Wholesalers"),
        Classification("424320", "Men's and Boys' Clothing and Furnishings Merchant Wholesalers"),
        Classification(
            "424330",
            "Women's, Children's, and Infants' Clothing and Accessories Merchant Wholesalers",
        ),
        Classification("424340", "Footwear Merchant Wholesalers"),
        Classification("424410", "General Line Grocery Merchant Wholesalers"),
        Classification("424420", "Packaged Frozen Food Merchant Wholesalers"),
        Classification("424430", "Dairy Product (except Dried or Canned) Merchant Wholesalers"),
        Classification("424440", "Poultry and Poultry Product Merchant Wholesalers"),
        Classification("424450", "Confectionery Merchant Wholesalers"),
        Classification("424460", "Fish and Seafood Merchant Wholesalers"),
        Classification("424470", "Meat and Meat Product Merchant Wholesalers"),
        Classification("424480", "Fresh Fruit and Vegetable Merchant Wholesalers"),
        Classification("424490", "Other Grocery and Related Products Merchant Wholesalers"),
        Classification("424510", "Grain and Field Bean Merchant Wholesalers"),
        Classification("424520", "Livestock Merchant Wholesalers"),
        Classification("424590", "Other Farm Product Raw Material Merchant Wholesalers"),
        Classification(
            "424610",
            "Plastics Materials and Basic Forms and Shapes Merchant Wholesalers",
        ),
        Classification("424690", "Other Chemical and Allied Products Merchant Wholesalers"),
        Classification("424710", "Petroleum Bulk Stations and Terminals"),
        Classification(
            "424720",
            "Petroleum and Petroleum Products Merchant Wholesalers (except Bulk Stations and Terminals)",
        ),
        Classification("424810", "Beer and Ale Merchant Wholesalers"),
        Classification("424820", "Wine and Distilled Alcoholic Beverage Merchant Wholesalers"),
        Classification("424910", "Farm Supplies Merchant Wholesalers"),
        Classification("424920", "Book, Periodical, and Newspaper Merchant Wholesalers"),
        Classification(
            "424930",
            "Flower, Nursery Stock, and Florists' Supplies Merchant Wholesalers",
        ),
        Classification("424940", "Tobacco and Tobacco Product Merchant Wholesalers"),
        Classification("424950", "Paint, Varnish, and Supplies Merchant Wholesalers"),
        Classification("424990", "Other Miscellaneous Nondurable Goods Merchant Wholesalers"),
        Classification("425110", "Business to Business Electronic Markets"),
        Classification("425120", "Wholesale Trade Agents and Brokers"),
        Classification("441110", "New Car Dealers"),
        Classification("441120", "Used Car Dealers"),
        Classification("441210", "Recreational Vehicle Dealers"),
        Classification("441222", "Boat Dealers"),
        Classification("441228", "Motorcycle, ATV, and All Other Motor Vehicle Dealers"),
        Classification("441310", "Automotive Parts and Accessories Stores"),
        Classification("441320", "Tire Dealers"),
        Classification("442110", "Furniture Stores"),
        Classification("442210", "Floor Covering Stores"),
        Classification("442291", "Window Treatment Stores"),
        Classification("442299", "All Other Home Furnishings Stores"),
        Classification("443141", "Household Appliance Stores"),
        Classification("443142", "Electronics Stores"),
        Classification("444110", "Home Centers"),
        Classification("444120", "Paint and Wallpaper Stores"),
        Classification("444130", "Hardware Stores"),
        Classification("444190", "Other Building Material Dealers"),
        Classification("444210", "Outdoor Power Equipment Stores"),
        Classification("444220", "Nursery, Garden Center, and Farm Supply Stores"),
        Classification("445110", "Supermarkets and Other Grocery (except Convenience) Stores"),
        Classification("445120", "Convenience Stores"),
        Classification("445210", "Meat Markets"),
        Classification("445220", "Fish and Seafood Markets"),
        Classification("445230", "Fruit and Vegetable Markets"),
        Classification("445291", "Baked Goods Stores"),
        Classification("445292", "Confectionery and Nut Stores"),
        Classification("445299", "All Other Specialty Food Stores"),
        Classification("445310", "Beer, Wine, and Liquor Stores"),
        Classification("446110", "Pharmacies and Drug Stores"),
        Classification("446120", "Cosmetics, Beauty Supplies, and Perfume Stores"),
        Classification("446130", "Optical Goods Stores"),
        Classification("446191", "Food (Health) Supplement Stores"),
        Classification("446199", "All Other Health and Personal Care Stores"),
        Classification("447110", "Gasoline Stations with Convenience Stores"),
        Classification("447190", "Other Gasoline Stations"),
        Classification("448110", "Men's Clothing Stores"),
        Classification("448120", "Women's Clothing Stores"),
        Classification("448130", "Children's and Infants' Clothing Stores"),
        Classification("448140", "Family Clothing Stores"),
        Classification("448150", "Clothing Accessories Stores"),
        Classification("448190", "Other Clothing Stores"),
        Classification("448210", "Shoe Stores"),
        Classification("448310", "Jewelry Stores"),
        Classification("448320", "Luggage and Leather Goods Stores"),
        Classification("451110", "Sporting Goods Stores"),
        Classification("451120", "Hobby, Toy, and Game Stores"),
        Classification("451130", "Sewing, Needlework, and Piece Goods Stores"),
        Classification("451140", "Musical Instrument and Supplies Stores"),
        Classification("451211", "Book Stores"),
        Classification("451212", "News Dealers and Newsstands"),
        Classification("452210", "Department Stores"),
        Classification("452311", "Warehouse Clubs and Supercenters"),
        Classification("452319", "All Other General Merchandise Stores"),
        Classification("453110", "Florists"),
        Classification("453210", "Office Supplies and Stationery Stores"),
        Classification("453220", "Gift, Novelty, and Souvenir Stores"),
        Classification("453310", "Used Merchandise Stores"),
        Classification("453910", "Pet and Pet Supplies Stores"),
        Classification("453920", "Art Dealers"),
        Classification("453930", "Manufactured (Mobile) Home Dealers"),
        Classification("453991", "Tobacco Stores"),
        Classification("453998", "All Other Miscellaneous Store Retailers (except Tobacco Stores)"),
        Classification("454110", "Electronic Shopping and Mail-Order Houses"),
        Classification("454210", "Vending Machine Operators"),
        Classification("454310", "Fuel Dealers"),
        Classification("454390", "Other Direct Selling Establishments"),
        Classification("481111", "Scheduled Passenger Air Transportation"),
        Classification("481112", "Scheduled Freight Air Transportation"),
        Classification("481211", "Nonscheduled Chartered Passenger Air Transportation"),
        Classification("481212", "Nonscheduled Chartered Freight Air Transportation"),
        Classification("481219", "Other Nonscheduled Air Transportation"),
        Classification("482111", "Line-Haul Railroads"),
        Classification("482112", "Short Line Railroads"),
        Classification("483111", "Deep Sea Freight Transportation"),
        Classification("483112", "Deep Sea Passenger Transportation"),
        Classification("483113", "Coastal and Great Lakes Freight Transportation"),
        Classification("483114", "Coastal and Great Lakes Passenger Transportation"),
        Classification("483211", "Inland Water Freight Transportation"),
        Classification("483212", "Inland Water Passenger Transportation"),
        Classification("484110", "General Freight Trucking, Local"),
        Classification("484121", "General Freight Trucking, Long-Distance, Truckload"),
        Classification("484122", "General Freight Trucking, Long-Distance, Less Than Truckload"),
        Classification("484210", "Used Household and Office Goods Moving"),
        Classification("484220", "Specialized Freight (except Used Goods) Trucking, Local"),
        Classification("484230", "Specialized Freight (except Used Goods) Trucking, Long-Distance"),
        Classification("485111", "Mixed Mode Transit Systems"),
        Classification("485112", "Commuter Rail Systems"),
        Classification("485113", "Bus and Other Motor Vehicle Transit Systems"),
        Classification("485119", "Other Urban Transit Systems"),
        Classification("485210", "Interurban and Rural Bus Transportation"),
        Classification("485310", "Taxi Service"),
        Classification("485320", "Limousine Service"),
        Classification("485410", "School and Employee Bus Transportation"),
        Classification("485510", "Charter Bus Industry"),
        Classification("485991", "Special Needs Transportation"),
        Classification("485999", "All Other Transit and Ground Passenger Transportation"),
        Classification("486110", "Pipeline Transportation of Crude Oil"),
        Classification("486210", "Pipeline Transportation of Natural Gas"),
        Classification("486910", "Pipeline Transportation of Refined Petroleum Products"),
        Classification("486990", "All Other Pipeline Transportation"),
        Classification("487110", "Scenic and Sightseeing Transportation, Land"),
        Classification("487210", "Scenic and Sightseeing Transportation, Water"),
        Classification("487990", "Scenic and Sightseeing Transportation, Other"),
        Classification("488111", "Air Traffic Control"),
        Classification("488119", "Other Airport Operations"),
        Classification("488190", "Other Support Activities for Air Transportation"),
        Classification("488210", "Support Activities for Rail Transportation"),
        Classification("488310", "Port and Harbor Operations"),
        Classification("488320", "Marine Cargo Handling"),
        Classification("488330", "Navigational Services to Shipping"),
        Classification("488390", "Other Support Activities for Water Transportation"),
        Classification("488410", "Motor Vehicle Towing"),
        Classification("488490", "Other Support Activities for Road Transportation"),
        Classification("488510", "Freight Transportation Arrangement"),
        Classification("488991", "Packing and Crating"),
        Classification("488999", "All Other Support Activities for Transportation"),
        Classification("491110", "Postal Service"),
        Classification("492110", "Couriers and Express Delivery Services"),
        Classification("492210", "Local Messengers and Local Delivery"),
        Classification("493110", "General Warehousing and Storage"),
        Classification("493120", "Refrigerated Warehousing and Storage"),
        Classification("493130", "Farm Product Warehousing and Storage"),
        Classification("493190", "Other Warehousing and Storage"),
        Classification("511110", "Newspaper Publishers"),
        Classification("511120", "Periodical Publishers"),
        Classification("511130", "Book Publishers"),
        Classification("511140", "Directory and Mailing List Publishers"),
        Classification("511191", "Greeting Card Publishers"),
        Classification("511199", "All Other Publishers"),
        Classification("511210", "Software Publishers"),
        Classification("512110", "Motion Picture and Video Production"),
        Classification("512120", "Motion Picture and Video Distribution"),
        Classification("512131", "Motion Picture Theaters (except Drive-Ins)"),
        Classification("512132", "Drive-In Motion Picture Theaters"),
        Classification("512191", "Teleproduction and Other Postproduction Services"),
        Classification("512199", "Other Motion Picture and Video Industries"),
        Classification("512230", "Music Publishers"),
        Classification("512240", "Sound Recording Studios"),
        Classification("512250", "Record Production and Distribution"),
        Classification("512290", "Other Sound Recording Industries"),
        Classification("515111", "Radio Networks"),
        Classification("515112", "Radio Stations"),
        Classification("515120", "Television Broadcasting"),
        Classification("515210", "Cable and Other Subscription Programming"),
        Classification("517311", "Wired Telecommunications Carriers"),
        Classification("517312", "Wireless Telecommunications Carriers (except Satellite)"),
        Classification("517410", "Satellite Telecommunications"),
        Classification("517911", "Telecommunications Resellers"),
        Classification("517919", "All Other Telecommunications"),
        Classification("518210", "Data Processing, Hosting, and Related Services"),
        Classification("519110", "News Syndicates"),
        Classification("519120", "Libraries and Archives"),
        Classification("519130", "Internet Publishing and Broadcasting and Web Search Portals"),
        Classification("519190", "All Other Information Services"),
        Classification("521110", "Monetary Authorities-Central Bank"),
        Classification("522110", "Commercial Banking"),
        Classification("522120", "Savings Institutions"),
        Classification("522130", "Credit Unions"),
        Classification("522190", "Other Depository Credit Intermediation"),
        Classification("522210", "Credit Card Issuing"),
        Classification("522220", "Sales Financing"),
        Classification("522291", "Consumer Lending"),
        Classification("522292", "Real Estate Credit"),
        Classification("522293", "International Trade Financing"),
        Classification("522294", "Secondary Market Financing"),
        Classification("522298", "All Other Nondepository Credit Intermediation"),
        Classification("522310", "Mortgage and Nonmortgage Loan Brokers"),
        Classification(
            "522320",
            "Financial Transactions Processing, Reserve, and Clearinghouse Activities",
        ),
        Classification("522390", "Other Activities Related to Credit Intermediation"),
        Classification("523110", "Investment Banking and Securities Dealing"),
        Classification("523120", "Securities Brokerage"),
        Classification("523130", "Commodity Contracts Dealing"),
        Classification("523140", "Commodity Contracts Brokerage"),
        Classification("523210", "Securities and Commodity Exchanges"),
        Classification("523910", "Miscellaneous Intermediation"),
        Classification("523920", "Portfolio Management"),
        Classification("523930", "Investment Advice"),
        Classification("523991", "Trust, Fiduciary, and Custody Activities"),
        Classification("523999", "Miscellaneous Financial Investment Activities"),
        Classification("524113", "Direct Life Insurance Carriers"),
        Classification("524114", "Direct Health and Medical Insurance Carriers"),
        Classification("524126", "Direct Property and Casualty Insurance Carriers"),
        Classification("524127", "Direct Title Insurance Carriers"),
        Classification(
            "524128",
            "Other Direct Insurance (except Life, Health, and Medical) Carriers",
        ),
        Classification("524130", "Reinsurance Carriers"),
        Classification("524210", "Insurance Agencies and Brokerages"),
        Classification("524291", "Claims Adjusting"),
        Classification("524292", "Third Party Administration of Insurance and Pension Funds"),
        Classification("524298", "All Other Insurance Related Activities"),
        Classification("525110", "Pension Funds"),
        Classification("525120", "Health and Welfare Funds"),
        Classification("525190", "Other Insurance Funds"),
        Classification("525910", "Open-End Investment Funds"),
        Classification("525920", "Trusts, Estates, and Agency Accounts"),
        Classification("525990", "Other Financial Vehicles"),
        Classification("531110", "Lessors of Residential Buildings and Dwellings"),
        Classification("531120", "Lessors of Nonresidential Buildings (except Miniwarehouses)"),
        Classification("531130", "Lessors of Miniwarehouses and Self-Storage Units"),
        Classification("531190", "Lessors of Other Real Estate Property"),
        Classification("531210", "Offices of Real Estate Agents and Brokers"),
        Classification("531311", "Residential Property Managers"),
        Classification("531312", "Nonresidential Property Managers"),
        Classification("531320", "Offices of Real Estate Appraisers"),
        Classification("531390", "Other Activities Related to Real Estate"),
        Classification("532111", "Passenger Car Rental"),
        Classification("532112", "Passenger Car Leasing"),
        Classification(
            "532120",
            "Truck, Utility Trailer, and RV (Recreational Vehicle) Rental and Leasing",
        ),
        Classification("532210", "Consumer Electronics and Appliances Rental"),
        Classification("532281", "Formal Wear and Costume Rental"),
        Classification("532282", "Video Tape and Disc Rental"),
        Classification("532283", "Home Health Equipment Rental"),
        Classification("532284", "Recreational Goods Rental"),
        Classification("532289", "All Other Consumer Goods Rental"),
        Classification("532310", "General Rental Centers"),
        Classification(
            "532411",
            "Commercial Air, Rail, and Water Transportation Equipment Rental and Leasing",
        ),
        Classification(
            "532412",
            "Construction, Mining, and Forestry Machinery and Equipment Rental and Leasing",
        ),
        Classification("532420", "Office Machinery and Equipment Rental and Leasing"),
        Classification(
            "532490",
            "Other Commercial and Industrial Machinery and Equipment Rental and Leasing",
        ),
        Classification(
            "533110",
            "Lessors of Nonfinancial Intangible Assets (except Copyrighted Works)",
        ),
        Classification("541110", "Offices of Lawyers"),
        Classification("541120", "Offices of Notaries"),
        Classification("541191", "Title Abstract and Settlement Offices"),
        Classification("541199", "All Other Legal Services"),
        Classification("541211", "Offices of Certified Public Accountants"),
        Classification("541213", "Tax Preparation Services"),
        Classification("541214", "Payroll Services"),
        Classification("541219", "Other Accounting Services"),
        Classification("541310", "Architectural Services"),
        Classification("541320", "Landscape Architectural Services"),
        Classification("541330", "Engineering Services"),
        Classification("541340", "Drafting Services"),
        Classification("541350", "Building Inspection Services"),
        Classification("541360", "Geophysical Surveying and Mapping Services"),
        Classification("541370", "Surveying and Mapping (except Geophysical) Services"),
        Classification("541380", "Testing Laboratories"),
        Classification("541410", "Interior Design Services"),
        Classification("541420", "Industrial Design Services"),
        Classification("541430", "Graphic Design Services"),
        Classification("541490", "Other Specialized Design Services"),
        Classification("541511", "Custom Computer Programming Services"),
        Classification("541512", "Computer Systems Design Services"),
        Classification("541513", "Computer Facilities Management Services"),
        Classification("541519", "Other Computer Related Services"),
        Classification(
            "541611",
            "Administrative Management and General Management Consulting Services",
        ),
        Classification("541612", "Human Resources Consulting Services"),
        Classification("541613", "Marketing Consulting Services"),
        Classification(
            "541614",
            "Process, Physical Distribution, and Logistics Consulting Services",
        ),
        Classification("541618", "Other Management Consulting Services"),
        Classification("541620", "Environmental Consulting Services"),
        Classification("541690", "Other Scientific and Technical Consulting Services"),
        Classification("541713", "Research and Development in Nanotechnology"),
        Classification(
            "541714",
            "Research and Development in Biotechnology (except Nanobiotechnology)",
        ),
        Classification(
            "541715",
            "Research and Development in the Physical, Engineering, and Life Sciences (except Nanotechnology and Biotechnology)",
        ),
        Classification("541720", "Research and Development in the Social Sciences and Humanities"),
        Classification("541810", "Advertising Agencies"),
        Classification("541820", "Public Relations Agencies"),
        Classification("541830", "Media Buying Agencies"),
        Classification("541840", "Media Representatives"),
        Classification("541850", "Outdoor Advertising"),
        Classification("541860", "Direct Mail Advertising"),
        Classification("541870", "Advertising Material Distribution Services"),
        Classification("541890", "Other Services Related to Advertising"),
        Classification("541910", "Marketing Research and Public Opinion Polling"),
        Classification("541921", "Photography Studios, Portrait"),
        Classification("541922", "Commercial Photography"),
        Classification("541930", "Translation and Interpretation Services"),
        Classification("541940", "Veterinary Services"),
        Classification("541990", "All Other Professional, Scientific, and Technical Services"),
        Classification("551111", "Offices of Bank Holding Companies"),
        Classification("551112", "Offices of Other Holding Companies"),
        Classification("551114", "Corporate, Subsidiary, and Regional Managing Offices"),
        Classification("561110", "Office Administrative Services"),
        Classification("561210", "Facilities Support Services"),
        Classification("561311", "Employment Placement Agencies"),
        Classification("561312", "Executive Search Services"),
        Classification("561320", "Temporary Help Services"),
        Classification("561330", "Professional Employer Organizations"),
        Classification("561410", "Document Preparation Services"),
        Classification("561421", "Telephone Answering Services"),
        Classification("561422", "Telemarketing Bureaus and Other Contact Centers"),
        Classification("561431", "Private Mail Centers"),
        Classification("561439", "Other Business Service Centers (including Copy Shops)"),
        Classification("561440", "Collection Agencies"),
        Classification("561450", "Credit Bureaus"),
        Classification("561491", "Repossession Services"),
        Classification("561492", "Court Reporting and Stenotype Services"),
        Classification("561499", "All Other Business Support Services"),
        Classification("561510", "Travel Agencies"),
        Classification("561520", "Tour Operators"),
        Classification("561591", "Convention and Visitors Bureaus"),
        Classification("561599", "All Other Travel Arrangement and Reservation Services"),
        Classification("561611", "Investigation Services"),
        Classification("561612", "Security Guards and Patrol Services"),
        Classification("561613", "Armored Car Services"),
        Classification("561621", "Security Systems Services (except Locksmiths)"),
        Classification("561622", "Locksmiths"),
        Classification("561710", "Exterminating and Pest Control Services"),
        Classification("561720", "Janitorial Services"),
        Classification("561730", "Landscaping Services"),
        Classification("561740", "Carpet and Upholstery Cleaning Services"),
        Classification("561790", "Other Services to Buildings and Dwellings"),
        Classification("561910", "Packaging and Labeling Services"),
        Classification("561920", "Convention and Trade Show Organizers"),
        Classification("561990", "All Other Support Services"),
        Classification("562111", "Solid Waste Collection"),
        Classification("562112", "Hazardous Waste Collection"),
        Classification("562119", "Other Waste Collection"),
        Classification("562211", "Hazardous Waste Treatment and Disposal"),
        Classification("562212", "Solid Waste Landfill"),
        Classification("562213", "Solid Waste Combustors and Incinerators"),
        Classification("562219", "Other Nonhazardous Waste Treatment and Disposal"),
        Classification("562910", "Remediation Services"),
        Classification("562920", "Materials Recovery Facilities"),
        Classification("562991", "Septic Tank and Related Services"),
        Classification("562998", "All Other Miscellaneous Waste Management Services"),
        Classification("611110", "Elementary and Secondary Schools"),
        Classification("611210", "Junior Colleges"),
        Classification("611310", "Colleges, Universities, and Professional Schools"),
        Classification("611410", "Business and Secretarial Schools"),
        Classification("611420", "Computer Training"),
        Classification("611430", "Professional and Management Development Training"),
        Classification("611511", "Cosmetology and Barber Schools"),
        Classification("611512", "Flight Training"),
        Classification("611513", "Apprenticeship Training"),
        Classification("611519", "Other Technical and Trade Schools"),
        Classification("611610", "Fine Arts Schools"),
        Classification("611620", "Sports and Recreation Instruction"),
        Classification("611630", "Language Schools"),
        Classification("611691", "Exam Preparation and Tutoring"),
        Classification("611692", "Automobile Driving Schools"),
        Classification("611699", "All Other Miscellaneous Schools and Instruction"),
        Classification("611710", "Educational Support Services"),
        Classification("621111", "Offices of Physicians (except Mental Health Specialists)"),
        Classification("621112", "Offices of Physicians, Mental Health Specialists"),
        Classification("621210", "Offices of Dentists"),
        Classification("621310", "Offices of Chiropractors"),
        Classification("621320", "Offices of Optometrists"),
        Classification("621330", "Offices of Mental Health Practitioners (except Physicians)"),
        Classification(
            "621340",
            "Offices of Physical, Occupational and Speech Therapists, and Audiologists",
        ),
        Classification("621391", "Offices of Podiatrists"),
        Classification("621399", "Offices of All Other Miscellaneous Health Practitioners"),
        Classification("621410", "Family Planning Centers"),
        Classification("621420", "Outpatient Mental Health and Substance Abuse Centers"),
        Classification("621491", "HMO Medical Centers"),
        Classification("621492", "Kidney Dialysis Centers"),
        Classification("621493", "Freestanding Ambulatory Surgical and Emergency Centers"),
        Classification("621498", "All Other Outpatient Care Centers"),
        Classification("621511", "Medical Laboratories"),
        Classification("621512", "Diagnostic Imaging Centers"),
        Classification("621610", "Home Health Care Services"),
        Classification("621910", "Ambulance Services"),
        Classification("621991", "Blood and Organ Banks"),
        Classification("621999", "All Other Miscellaneous Ambulatory Health Care Services"),
        Classification("622110", "General Medical and Surgical Hospitals"),
        Classification("622210", "Psychiatric and Substance Abuse Hospitals"),
        Classification("622310", "Specialty (except Psychiatric and Substance Abuse) Hospitals"),
        Classification("623110", "Nursing Care Facilities (Skilled Nursing Facilities)"),
        Classification("623210", "Residential Intellectual and Developmental Disability Facilities"),
        Classification("623220", "Residential Mental Health and Substance Abuse Facilities"),
        Classification("623311", "Continuing Care Retirement Communities"),
        Classification("623312", "Assisted Living Facilities for the Elderly"),
        Classification("623990", "Other Residential Care Facilities"),
        Classification("624110", "Child and Youth Services"),
        Classification("624120", "Services for the Elderly and Persons with Disabilities"),
        Classification("624190", "Other Individual and Family Services"),
        Classification("624210", "Community Food Services"),
        Classification("624221", "Temporary Shelters"),
        Classification("624229", "Other Community Housing Services"),
        Classification("624230", "Emergency and Other Relief Services"),
        Classification("624310", "Vocational Rehabilitation Services"),
        Classification("624410", "Child Day Care Services"),
        Classification("711110", "Theater Companies and Dinner Theaters"),
        Classification("711120", "Dance Companies"),
        Classification("711130", "Musical Groups and Artists"),
        Classification("711190", "Other Performing Arts Companies"),
        Classification("711211", "Sports Teams and Clubs"),
        Classification("711212", "Racetracks"),
        Classification("711219", "Other Spectator Sports"),
        Classification(
            "711310",
            "Promoters of Performing Arts, Sports, and Similar Events with Facilities",
        ),
        Classification(
            "711320",
            "Promoters of Performing Arts, Sports, and Similar Events without Facilities",
        ),
        Classification(
            "711410",
            "Agents and Managers for Artists, Athletes, Entertainers, and Other Public Figures",
        ),
        Classification("711510", "Independent Artists, Writers, and Performers"),
        Classification("712110", "Museums"),
        Classification("712120", "Historical Sites"),
        Classification("712130", "Zoos and Botanical Gardens"),
        Classification("712190", "Nature Parks and Other Similar Institutions"),
        Classification("713110", "Amusement and Theme Parks"),
        Classification("713120", "Amusement Arcades"),
        Classification("713210", "Casinos (except Casino Hotels)"),
        Classification("713290", "Other Gambling Industries"),
        Classification("713910", "Golf Courses and Country Clubs"),
        Classification("713920", "Skiing Facilities"),
        Classification("713930", "Marinas"),
        Classification("713940", "Fitness and Recreational Sports Centers"),
        Classification("713950", "Bowling Centers"),
        Classification("713990", "All Other Amusement and Recreation Industries"),
        Classification("721110", "Hotels (except Casino Hotels) and Motels"),
        Classification("721120", "Casino Hotels"),
        Classification("721191", "Bed-and-Breakfast Inns"),
        Classification("721199", "All Other Traveler Accommodation"),
        Classification("721211", "RV (Recreational Vehicle) Parks and Campgrounds"),
        Classification("721214", "Recreational and Vacation Camps (except Campgrounds)"),
        Classification("721310", "Rooming and Boarding Houses, Dormitories, and Workers' Camps"),
        Classification("722310", "Food Service Contractors"),
        Classification("722320", "Caterers"),
        Classification("722330", "Mobile Food Services"),
        Classification("722410", "Drinking Places (Alcoholic Beverages)"),
        Classification("722511", "Full-Service Restaurants"),
        Classification("722513", "Limited-Service Restaurants"),
        Classification("722514", "Cafeterias, Grill Buffets, and Buffets"),
        Classification("722515", "Snack and Nonalcoholic Beverage Bars"),
        Classification("811111", "General Automotive Repair"),
        Classification("811112", "Automotive Exhaust System Repair"),
        Classification("811113", "Automotive Transmission Repair"),
        Classification(
            "811118",
            "Other Automotive Mechanical and Electrical Repair and Maintenance",
        ),
        Classification("811121", "Automotive Body, Paint, and Interior Repair and Maintenance"),
        Classification("811122", "Automotive Glass Replacement Shops"),
        Classification("811191", "Automotive Oil Change and Lubrication Shops"),
        Classification("811192", "Car Washes"),
        Classification("811198", "All Other Automotive Repair and Maintenance"),
        Classification("811211", "Consumer Electronics Repair and Maintenance"),
        Classification("811212", "Computer and Office Machine Repair and Maintenance"),
        Classification("811213", "Communication Equipment Repair and Maintenance"),
        Classification("811219", "Other Electronic and Precision Equipment Repair and Maintenance"),
        Classification(
            "811310",
            "Commercial and Industrial Machinery and Equipment (except Automotive and Electronic) Repair and Maintenance",
        ),
        Classification("811411", "Home and Garden Equipment Repair and Maintenance"),
        Classification("811412", "Appliance Repair and Maintenance"),
        Classification("811420", "Reupholstery and Furniture Repair"),
        Classification("811430", "Footwear and Leather Goods Repair"),
        Classification("811490", "Other Personal and Household Goods Repair and Maintenance"),
        Classification("812111", "Barber Shops"),
        Classification("812112", "Beauty Salons"),
        Classification("812113", "Nail Salons"),
        Classification("812191", "Diet and Weight Reducing Centers"),
        Classification("812199", "Other Personal Care Services"),
        Classification("812210", "Funeral Homes and Funeral Services"),
        Classification("812220", "Cemeteries and Crematories"),
        Classification("812310", "Coin-Operated Laundries and Drycleaners"),
        Classification("812320", "Drycleaning and Laundry Services (except Coin-Operated)"),
        Classification("812331", "Linen Supply"),
        Classification("812332", "Industrial Launderers"),
        Classification("812910", "Pet Care (except Veterinary) Services"),
        Classification("812921", "Photofinishing Laboratories (except One-Hour)"),
        Classification("812922", "One-Hour Photofinishing"),
        Classification("812930", "Parking Lots and Garages"),
        Classification("812990", "All Other Personal Services"),
        Classification("813110", "Religious Organizations"),
        Classification("813211", "Grantmaking Foundations"),
        Classification("813212", "Voluntary Health Organizations"),
        Classification("813219", "Other Grantmaking and Giving Services"),
        Classification("813311", "Human Rights Organizations"),
        Classification("813312", "Environment, Conservation and Wildlife Organizations"),
        Classification("813319", "Other Social Advocacy Organizations"),
        Classification("813410", "Civic and Social Organizations"),
        Classification("813910", "Business Associations"),
        Classification("813920", "Professional Organizations"),
        Classification("813930", "Labor Unions and Similar Labor Organizations"),
        Classification("813940", "Political Organizations"),
        Classification(
            "813990",
            "Other Similar Organizations (except Business, Professional, Labor, and Political Organizations)",
        ),
        Classification("814110", "Private Households"),
        Classification("921110", "Executive Offices"),
        Classification("921120", "Legislative Bodies"),
        Classification("921130", "Public Finance Activities"),
        Classification("921140", "Executive and Legislative Offices, Combined"),
        Classification("921150", "American Indian and Alaska Native Tribal Governments"),
        Classification("921190", "Other General Government Support"),
        Classification("922110", "Courts"),
        Classification("922120", "Police Protection"),
        Classification("922130", "Legal Counsel and Prosecution"),
        Classification("922140", "Correctional Institutions"),
        Classification("922150", "Parole Offices and Probation Offices"),
        Classification("922160", "Fire Protection"),
        Classification("922190", "Other Justice, Public Order, and Safety Activities"),
        Classification("923110", "Administration of Education Programs"),
        Classification("923120", "Administration of Public Health Programs"),
        Classification(
            "923130",
            "Administration of Human Resource Programs (except Education, Public Health, and Veterans' Affairs Programs)",
        ),
        Classification("923140", "Administration of Veterans' Affairs"),
        Classification(
            "924110",
            "Administration of Air and Water Resource and Solid Waste Management Programs",
        ),
        Classification("924120", "Administration of Conservation Programs"),
        Classification("925110", "Administration of Housing Programs"),
        Classification(
            "925120",
            "Administration of Urban Planning and Community and Rural Development",
        ),
        Classification("926110", "Administration of General Economic Programs"),
        Classification("926120", "Regulation and Administration of Transportation Programs"),
        Classification(
            "926130",
            "Regulation and Administration of Communications, Electric, Gas, and Other Utilities",
        ),
        Classification("926140", "Regulation of Agricultural Marketing and Commodities"),
        Classification(
            "926150",
            "Regulation, Licensing, and Inspection of Miscellaneous Commercial Sectors",
        ),
        Classification("927110", "Space Research and Technology"),
        Classification("928110", "National Security"),
        Classification("928120", "International Affairs"),
    ],
)
