# -*- coding: utf-8 -*-
"""`Concordance between NAF2 and NACE2 <https://www.insee.fr/fr/information/2406147>`_.

NAF2 codes map directly to NACE2 codes, except for subclasses.
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import NAF2

NAF2_to_NACE2 = Concordance(
    src=NAF2,
    dst=NACE2,
    concordances=[
        ((Standards.NAF2, "A"), (Standards.NACE2, "A")),
        ((Standards.NAF2, "01"), (Standards.NACE2, "01")),
        ((Standards.NAF2, "01.1"), (Standards.NACE2, "01.1")),
        ((Standards.NAF2, "01.11"), (Standards.NACE2, "01.11")),
        ((Standards.NAF2, "01.12"), (Standards.NACE2, "01.12")),
        ((Standards.NAF2, "01.13"), (Standards.NACE2, "01.13")),
        ((Standards.NAF2, "01.14"), (Standards.NACE2, "01.14")),
        ((Standards.NAF2, "01.15"), (Standards.NACE2, "01.15")),
        ((Standards.NAF2, "01.16"), (Standards.NACE2, "01.16")),
        ((Standards.NAF2, "01.19"), (Standards.NACE2, "01.19")),
        ((Standards.NAF2, "01.2"), (Standards.NACE2, "01.2")),
        ((Standards.NAF2, "01.21"), (Standards.NACE2, "01.21")),
        ((Standards.NAF2, "01.22"), (Standards.NACE2, "01.22")),
        ((Standards.NAF2, "01.23"), (Standards.NACE2, "01.23")),
        ((Standards.NAF2, "01.24"), (Standards.NACE2, "01.24")),
        ((Standards.NAF2, "01.25"), (Standards.NACE2, "01.25")),
        ((Standards.NAF2, "01.26"), (Standards.NACE2, "01.26")),
        ((Standards.NAF2, "01.27"), (Standards.NACE2, "01.27")),
        ((Standards.NAF2, "01.28"), (Standards.NACE2, "01.28")),
        ((Standards.NAF2, "01.29"), (Standards.NACE2, "01.29")),
        ((Standards.NAF2, "01.3"), (Standards.NACE2, "01.3")),
        ((Standards.NAF2, "01.30"), (Standards.NACE2, "01.30")),
        ((Standards.NAF2, "01.4"), (Standards.NACE2, "01.4")),
        ((Standards.NAF2, "01.41"), (Standards.NACE2, "01.41")),
        ((Standards.NAF2, "01.42"), (Standards.NACE2, "01.42")),
        ((Standards.NAF2, "01.43"), (Standards.NACE2, "01.43")),
        ((Standards.NAF2, "01.44"), (Standards.NACE2, "01.44")),
        ((Standards.NAF2, "01.45"), (Standards.NACE2, "01.45")),
        ((Standards.NAF2, "01.46"), (Standards.NACE2, "01.46")),
        ((Standards.NAF2, "01.47"), (Standards.NACE2, "01.47")),
        ((Standards.NAF2, "01.49"), (Standards.NACE2, "01.49")),
        ((Standards.NAF2, "01.5"), (Standards.NACE2, "01.5")),
        ((Standards.NAF2, "01.50"), (Standards.NACE2, "01.50")),
        ((Standards.NAF2, "01.6"), (Standards.NACE2, "01.6")),
        ((Standards.NAF2, "01.61"), (Standards.NACE2, "01.61")),
        ((Standards.NAF2, "01.62"), (Standards.NACE2, "01.62")),
        ((Standards.NAF2, "01.63"), (Standards.NACE2, "01.63")),
        ((Standards.NAF2, "01.64"), (Standards.NACE2, "01.64")),
        ((Standards.NAF2, "01.7"), (Standards.NACE2, "01.7")),
        ((Standards.NAF2, "01.70"), (Standards.NACE2, "01.70")),
        ((Standards.NAF2, "02"), (Standards.NACE2, "02")),
        ((Standards.NAF2, "02.1"), (Standards.NACE2, "02.1")),
        ((Standards.NAF2, "02.10"), (Standards.NACE2, "02.10")),
        ((Standards.NAF2, "02.2"), (Standards.NACE2, "02.2")),
        ((Standards.NAF2, "02.20"), (Standards.NACE2, "02.20")),
        ((Standards.NAF2, "02.3"), (Standards.NACE2, "02.3")),
        ((Standards.NAF2, "02.30"), (Standards.NACE2, "02.30")),
        ((Standards.NAF2, "02.4"), (Standards.NACE2, "02.4")),
        ((Standards.NAF2, "02.40"), (Standards.NACE2, "02.40")),
        ((Standards.NAF2, "03"), (Standards.NACE2, "03")),
        ((Standards.NAF2, "03.1"), (Standards.NACE2, "03.1")),
        ((Standards.NAF2, "03.11"), (Standards.NACE2, "03.11")),
        ((Standards.NAF2, "03.12"), (Standards.NACE2, "03.12")),
        ((Standards.NAF2, "03.2"), (Standards.NACE2, "03.2")),
        ((Standards.NAF2, "03.21"), (Standards.NACE2, "03.21")),
        ((Standards.NAF2, "03.22"), (Standards.NACE2, "03.22")),
        ((Standards.NAF2, "B"), (Standards.NACE2, "B")),
        ((Standards.NAF2, "05"), (Standards.NACE2, "05")),
        ((Standards.NAF2, "05.1"), (Standards.NACE2, "05.1")),
        ((Standards.NAF2, "05.10"), (Standards.NACE2, "05.10")),
        ((Standards.NAF2, "05.2"), (Standards.NACE2, "05.2")),
        ((Standards.NAF2, "05.20"), (Standards.NACE2, "05.20")),
        ((Standards.NAF2, "06"), (Standards.NACE2, "06")),
        ((Standards.NAF2, "06.1"), (Standards.NACE2, "06.1")),
        ((Standards.NAF2, "06.10"), (Standards.NACE2, "06.10")),
        ((Standards.NAF2, "06.2"), (Standards.NACE2, "06.2")),
        ((Standards.NAF2, "06.20"), (Standards.NACE2, "06.20")),
        ((Standards.NAF2, "07"), (Standards.NACE2, "07")),
        ((Standards.NAF2, "07.1"), (Standards.NACE2, "07.1")),
        ((Standards.NAF2, "07.10"), (Standards.NACE2, "07.10")),
        ((Standards.NAF2, "07.2"), (Standards.NACE2, "07.2")),
        ((Standards.NAF2, "07.21"), (Standards.NACE2, "07.21")),
        ((Standards.NAF2, "07.29"), (Standards.NACE2, "07.29")),
        ((Standards.NAF2, "08"), (Standards.NACE2, "08")),
        ((Standards.NAF2, "08.1"), (Standards.NACE2, "08.1")),
        ((Standards.NAF2, "08.11"), (Standards.NACE2, "08.11")),
        ((Standards.NAF2, "08.12"), (Standards.NACE2, "08.12")),
        ((Standards.NAF2, "08.9"), (Standards.NACE2, "08.9")),
        ((Standards.NAF2, "08.91"), (Standards.NACE2, "08.91")),
        ((Standards.NAF2, "08.92"), (Standards.NACE2, "08.92")),
        ((Standards.NAF2, "08.93"), (Standards.NACE2, "08.93")),
        ((Standards.NAF2, "08.99"), (Standards.NACE2, "08.99")),
        ((Standards.NAF2, "09"), (Standards.NACE2, "09")),
        ((Standards.NAF2, "09.1"), (Standards.NACE2, "09.1")),
        ((Standards.NAF2, "09.10"), (Standards.NACE2, "09.10")),
        ((Standards.NAF2, "09.9"), (Standards.NACE2, "09.9")),
        ((Standards.NAF2, "09.90"), (Standards.NACE2, "09.90")),
        ((Standards.NAF2, "C"), (Standards.NACE2, "C")),
        ((Standards.NAF2, "10"), (Standards.NACE2, "10")),
        ((Standards.NAF2, "10.1"), (Standards.NACE2, "10.1")),
        ((Standards.NAF2, "10.11"), (Standards.NACE2, "10.11")),
        ((Standards.NAF2, "10.12"), (Standards.NACE2, "10.12")),
        ((Standards.NAF2, "10.13"), (Standards.NACE2, "10.13")),
        ((Standards.NAF2, "10.2"), (Standards.NACE2, "10.2")),
        ((Standards.NAF2, "10.20"), (Standards.NACE2, "10.20")),
        ((Standards.NAF2, "10.3"), (Standards.NACE2, "10.3")),
        ((Standards.NAF2, "10.31"), (Standards.NACE2, "10.31")),
        ((Standards.NAF2, "10.32"), (Standards.NACE2, "10.32")),
        ((Standards.NAF2, "10.39"), (Standards.NACE2, "10.39")),
        ((Standards.NAF2, "10.4"), (Standards.NACE2, "10.4")),
        ((Standards.NAF2, "10.41"), (Standards.NACE2, "10.41")),
        ((Standards.NAF2, "10.42"), (Standards.NACE2, "10.42")),
        ((Standards.NAF2, "10.5"), (Standards.NACE2, "10.5")),
        ((Standards.NAF2, "10.51"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.52"), (Standards.NACE2, "10.52")),
        ((Standards.NAF2, "10.6"), (Standards.NACE2, "10.6")),
        ((Standards.NAF2, "10.61"), (Standards.NACE2, "10.61")),
        ((Standards.NAF2, "10.62"), (Standards.NACE2, "10.62")),
        ((Standards.NAF2, "10.7"), (Standards.NACE2, "10.7")),
        ((Standards.NAF2, "10.71"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.72"), (Standards.NACE2, "10.72")),
        ((Standards.NAF2, "10.73"), (Standards.NACE2, "10.73")),
        ((Standards.NAF2, "10.8"), (Standards.NACE2, "10.8")),
        ((Standards.NAF2, "10.81"), (Standards.NACE2, "10.81")),
        ((Standards.NAF2, "10.82"), (Standards.NACE2, "10.82")),
        ((Standards.NAF2, "10.83"), (Standards.NACE2, "10.83")),
        ((Standards.NAF2, "10.84"), (Standards.NACE2, "10.84")),
        ((Standards.NAF2, "10.85"), (Standards.NACE2, "10.85")),
        ((Standards.NAF2, "10.86"), (Standards.NACE2, "10.86")),
        ((Standards.NAF2, "10.89"), (Standards.NACE2, "10.89")),
        ((Standards.NAF2, "10.9"), (Standards.NACE2, "10.9")),
        ((Standards.NAF2, "10.91"), (Standards.NACE2, "10.91")),
        ((Standards.NAF2, "10.92"), (Standards.NACE2, "10.92")),
        ((Standards.NAF2, "11"), (Standards.NACE2, "11")),
        ((Standards.NAF2, "11.0"), (Standards.NACE2, "11.0")),
        ((Standards.NAF2, "11.01"), (Standards.NACE2, "11.01")),
        ((Standards.NAF2, "11.02"), (Standards.NACE2, "11.02")),
        ((Standards.NAF2, "11.03"), (Standards.NACE2, "11.03")),
        ((Standards.NAF2, "11.04"), (Standards.NACE2, "11.04")),
        ((Standards.NAF2, "11.05"), (Standards.NACE2, "11.05")),
        ((Standards.NAF2, "11.06"), (Standards.NACE2, "11.06")),
        ((Standards.NAF2, "11.07"), (Standards.NACE2, "11.07")),
        ((Standards.NAF2, "12"), (Standards.NACE2, "12")),
        ((Standards.NAF2, "12.0"), (Standards.NACE2, "12.0")),
        ((Standards.NAF2, "12.00"), (Standards.NACE2, "12.00")),
        ((Standards.NAF2, "13"), (Standards.NACE2, "13")),
        ((Standards.NAF2, "13.1"), (Standards.NACE2, "13.1")),
        ((Standards.NAF2, "13.10"), (Standards.NACE2, "13.10")),
        ((Standards.NAF2, "13.2"), (Standards.NACE2, "13.2")),
        ((Standards.NAF2, "13.20"), (Standards.NACE2, "13.20")),
        ((Standards.NAF2, "13.3"), (Standards.NACE2, "13.3")),
        ((Standards.NAF2, "13.30"), (Standards.NACE2, "13.30")),
        ((Standards.NAF2, "13.9"), (Standards.NACE2, "13.9")),
        ((Standards.NAF2, "13.91"), (Standards.NACE2, "13.91")),
        ((Standards.NAF2, "13.92"), (Standards.NACE2, "13.92")),
        ((Standards.NAF2, "13.93"), (Standards.NACE2, "13.93")),
        ((Standards.NAF2, "13.94"), (Standards.NACE2, "13.94")),
        ((Standards.NAF2, "13.95"), (Standards.NACE2, "13.95")),
        ((Standards.NAF2, "13.96"), (Standards.NACE2, "13.96")),
        ((Standards.NAF2, "13.99"), (Standards.NACE2, "13.99")),
        ((Standards.NAF2, "14"), (Standards.NACE2, "14")),
        ((Standards.NAF2, "14.1"), (Standards.NACE2, "14.1")),
        ((Standards.NAF2, "14.11"), (Standards.NACE2, "14.11")),
        ((Standards.NAF2, "14.12"), (Standards.NACE2, "14.12")),
        ((Standards.NAF2, "14.13"), (Standards.NACE2, "14.13")),
        ((Standards.NAF2, "14.14"), (Standards.NACE2, "14.14")),
        ((Standards.NAF2, "14.19"), (Standards.NACE2, "14.19")),
        ((Standards.NAF2, "14.2"), (Standards.NACE2, "14.2")),
        ((Standards.NAF2, "14.20"), (Standards.NACE2, "14.20")),
        ((Standards.NAF2, "14.3"), (Standards.NACE2, "14.3")),
        ((Standards.NAF2, "14.31"), (Standards.NACE2, "14.31")),
        ((Standards.NAF2, "14.39"), (Standards.NACE2, "14.39")),
        ((Standards.NAF2, "15"), (Standards.NACE2, "15")),
        ((Standards.NAF2, "15.1"), (Standards.NACE2, "15.1")),
        ((Standards.NAF2, "15.11"), (Standards.NACE2, "15.11")),
        ((Standards.NAF2, "15.12"), (Standards.NACE2, "15.12")),
        ((Standards.NAF2, "15.2"), (Standards.NACE2, "15.2")),
        ((Standards.NAF2, "15.20"), (Standards.NACE2, "15.20")),
        ((Standards.NAF2, "16"), (Standards.NACE2, "16")),
        ((Standards.NAF2, "16.1"), (Standards.NACE2, "16.1")),
        ((Standards.NAF2, "16.10"), (Standards.NACE2, "16.10")),
        ((Standards.NAF2, "16.2"), (Standards.NACE2, "16.2")),
        ((Standards.NAF2, "16.21"), (Standards.NACE2, "16.21")),
        ((Standards.NAF2, "16.22"), (Standards.NACE2, "16.22")),
        ((Standards.NAF2, "16.23"), (Standards.NACE2, "16.23")),
        ((Standards.NAF2, "16.24"), (Standards.NACE2, "16.24")),
        ((Standards.NAF2, "16.29"), (Standards.NACE2, "16.29")),
        ((Standards.NAF2, "17"), (Standards.NACE2, "17")),
        ((Standards.NAF2, "17.1"), (Standards.NACE2, "17.1")),
        ((Standards.NAF2, "17.11"), (Standards.NACE2, "17.11")),
        ((Standards.NAF2, "17.12"), (Standards.NACE2, "17.12")),
        ((Standards.NAF2, "17.2"), (Standards.NACE2, "17.2")),
        ((Standards.NAF2, "17.21"), (Standards.NACE2, "17.21")),
        ((Standards.NAF2, "17.22"), (Standards.NACE2, "17.22")),
        ((Standards.NAF2, "17.23"), (Standards.NACE2, "17.23")),
        ((Standards.NAF2, "17.24"), (Standards.NACE2, "17.24")),
        ((Standards.NAF2, "17.29"), (Standards.NACE2, "17.29")),
        ((Standards.NAF2, "18"), (Standards.NACE2, "18")),
        ((Standards.NAF2, "18.1"), (Standards.NACE2, "18.1")),
        ((Standards.NAF2, "18.11"), (Standards.NACE2, "18.11")),
        ((Standards.NAF2, "18.12"), (Standards.NACE2, "18.12")),
        ((Standards.NAF2, "18.13"), (Standards.NACE2, "18.13")),
        ((Standards.NAF2, "18.14"), (Standards.NACE2, "18.14")),
        ((Standards.NAF2, "18.2"), (Standards.NACE2, "18.2")),
        ((Standards.NAF2, "18.20"), (Standards.NACE2, "18.20")),
        ((Standards.NAF2, "19"), (Standards.NACE2, "19")),
        ((Standards.NAF2, "19.1"), (Standards.NACE2, "19.1")),
        ((Standards.NAF2, "19.10"), (Standards.NACE2, "19.10")),
        ((Standards.NAF2, "19.2"), (Standards.NACE2, "19.2")),
        ((Standards.NAF2, "19.20"), (Standards.NACE2, "19.20")),
        ((Standards.NAF2, "20"), (Standards.NACE2, "20")),
        ((Standards.NAF2, "20.1"), (Standards.NACE2, "20.1")),
        ((Standards.NAF2, "20.11"), (Standards.NACE2, "20.11")),
        ((Standards.NAF2, "20.12"), (Standards.NACE2, "20.12")),
        ((Standards.NAF2, "20.13"), (Standards.NACE2, "20.13")),
        ((Standards.NAF2, "20.14"), (Standards.NACE2, "20.14")),
        ((Standards.NAF2, "20.15"), (Standards.NACE2, "20.15")),
        ((Standards.NAF2, "20.16"), (Standards.NACE2, "20.16")),
        ((Standards.NAF2, "20.17"), (Standards.NACE2, "20.17")),
        ((Standards.NAF2, "20.2"), (Standards.NACE2, "20.2")),
        ((Standards.NAF2, "20.20"), (Standards.NACE2, "20.20")),
        ((Standards.NAF2, "20.3"), (Standards.NACE2, "20.3")),
        ((Standards.NAF2, "20.30"), (Standards.NACE2, "20.30")),
        ((Standards.NAF2, "20.4"), (Standards.NACE2, "20.4")),
        ((Standards.NAF2, "20.41"), (Standards.NACE2, "20.41")),
        ((Standards.NAF2, "20.42"), (Standards.NACE2, "20.42")),
        ((Standards.NAF2, "20.5"), (Standards.NACE2, "20.5")),
        ((Standards.NAF2, "20.51"), (Standards.NACE2, "20.51")),
        ((Standards.NAF2, "20.52"), (Standards.NACE2, "20.52")),
        ((Standards.NAF2, "20.53"), (Standards.NACE2, "20.53")),
        ((Standards.NAF2, "20.59"), (Standards.NACE2, "20.59")),
        ((Standards.NAF2, "20.6"), (Standards.NACE2, "20.6")),
        ((Standards.NAF2, "20.60"), (Standards.NACE2, "20.60")),
        ((Standards.NAF2, "21"), (Standards.NACE2, "21")),
        ((Standards.NAF2, "21.1"), (Standards.NACE2, "21.1")),
        ((Standards.NAF2, "21.10"), (Standards.NACE2, "21.10")),
        ((Standards.NAF2, "21.2"), (Standards.NACE2, "21.2")),
        ((Standards.NAF2, "21.20"), (Standards.NACE2, "21.20")),
        ((Standards.NAF2, "22"), (Standards.NACE2, "22")),
        ((Standards.NAF2, "22.1"), (Standards.NACE2, "22.1")),
        ((Standards.NAF2, "22.11"), (Standards.NACE2, "22.11")),
        ((Standards.NAF2, "22.19"), (Standards.NACE2, "22.19")),
        ((Standards.NAF2, "22.2"), (Standards.NACE2, "22.2")),
        ((Standards.NAF2, "22.21"), (Standards.NACE2, "22.21")),
        ((Standards.NAF2, "22.22"), (Standards.NACE2, "22.22")),
        ((Standards.NAF2, "22.23"), (Standards.NACE2, "22.23")),
        ((Standards.NAF2, "22.29"), (Standards.NACE2, "22.29")),
        ((Standards.NAF2, "23"), (Standards.NACE2, "23")),
        ((Standards.NAF2, "23.1"), (Standards.NACE2, "23.1")),
        ((Standards.NAF2, "23.11"), (Standards.NACE2, "23.11")),
        ((Standards.NAF2, "23.12"), (Standards.NACE2, "23.12")),
        ((Standards.NAF2, "23.13"), (Standards.NACE2, "23.13")),
        ((Standards.NAF2, "23.14"), (Standards.NACE2, "23.14")),
        ((Standards.NAF2, "23.19"), (Standards.NACE2, "23.19")),
        ((Standards.NAF2, "23.2"), (Standards.NACE2, "23.2")),
        ((Standards.NAF2, "23.20"), (Standards.NACE2, "23.20")),
        ((Standards.NAF2, "23.3"), (Standards.NACE2, "23.3")),
        ((Standards.NAF2, "23.31"), (Standards.NACE2, "23.31")),
        ((Standards.NAF2, "23.32"), (Standards.NACE2, "23.32")),
        ((Standards.NAF2, "23.4"), (Standards.NACE2, "23.4")),
        ((Standards.NAF2, "23.41"), (Standards.NACE2, "23.41")),
        ((Standards.NAF2, "23.42"), (Standards.NACE2, "23.42")),
        ((Standards.NAF2, "23.43"), (Standards.NACE2, "23.43")),
        ((Standards.NAF2, "23.44"), (Standards.NACE2, "23.44")),
        ((Standards.NAF2, "23.49"), (Standards.NACE2, "23.49")),
        ((Standards.NAF2, "23.5"), (Standards.NACE2, "23.5")),
        ((Standards.NAF2, "23.51"), (Standards.NACE2, "23.51")),
        ((Standards.NAF2, "23.52"), (Standards.NACE2, "23.52")),
        ((Standards.NAF2, "23.6"), (Standards.NACE2, "23.6")),
        ((Standards.NAF2, "23.61"), (Standards.NACE2, "23.61")),
        ((Standards.NAF2, "23.62"), (Standards.NACE2, "23.62")),
        ((Standards.NAF2, "23.63"), (Standards.NACE2, "23.63")),
        ((Standards.NAF2, "23.64"), (Standards.NACE2, "23.64")),
        ((Standards.NAF2, "23.65"), (Standards.NACE2, "23.65")),
        ((Standards.NAF2, "23.69"), (Standards.NACE2, "23.69")),
        ((Standards.NAF2, "23.7"), (Standards.NACE2, "23.7")),
        ((Standards.NAF2, "23.70"), (Standards.NACE2, "23.70")),
        ((Standards.NAF2, "23.9"), (Standards.NACE2, "23.9")),
        ((Standards.NAF2, "23.91"), (Standards.NACE2, "23.91")),
        ((Standards.NAF2, "23.99"), (Standards.NACE2, "23.99")),
        ((Standards.NAF2, "24"), (Standards.NACE2, "24")),
        ((Standards.NAF2, "24.1"), (Standards.NACE2, "24.1")),
        ((Standards.NAF2, "24.10"), (Standards.NACE2, "24.10")),
        ((Standards.NAF2, "24.2"), (Standards.NACE2, "24.2")),
        ((Standards.NAF2, "24.20"), (Standards.NACE2, "24.20")),
        ((Standards.NAF2, "24.3"), (Standards.NACE2, "24.3")),
        ((Standards.NAF2, "24.31"), (Standards.NACE2, "24.31")),
        ((Standards.NAF2, "24.32"), (Standards.NACE2, "24.32")),
        ((Standards.NAF2, "24.33"), (Standards.NACE2, "24.33")),
        ((Standards.NAF2, "24.34"), (Standards.NACE2, "24.34")),
        ((Standards.NAF2, "24.4"), (Standards.NACE2, "24.4")),
        ((Standards.NAF2, "24.41"), (Standards.NACE2, "24.41")),
        ((Standards.NAF2, "24.42"), (Standards.NACE2, "24.42")),
        ((Standards.NAF2, "24.43"), (Standards.NACE2, "24.43")),
        ((Standards.NAF2, "24.44"), (Standards.NACE2, "24.44")),
        ((Standards.NAF2, "24.45"), (Standards.NACE2, "24.45")),
        ((Standards.NAF2, "24.46"), (Standards.NACE2, "24.46")),
        ((Standards.NAF2, "24.5"), (Standards.NACE2, "24.5")),
        ((Standards.NAF2, "24.51"), (Standards.NACE2, "24.51")),
        ((Standards.NAF2, "24.52"), (Standards.NACE2, "24.52")),
        ((Standards.NAF2, "24.53"), (Standards.NACE2, "24.53")),
        ((Standards.NAF2, "24.54"), (Standards.NACE2, "24.54")),
        ((Standards.NAF2, "25"), (Standards.NACE2, "25")),
        ((Standards.NAF2, "25.1"), (Standards.NACE2, "25.1")),
        ((Standards.NAF2, "25.11"), (Standards.NACE2, "25.11")),
        ((Standards.NAF2, "25.12"), (Standards.NACE2, "25.12")),
        ((Standards.NAF2, "25.2"), (Standards.NACE2, "25.2")),
        ((Standards.NAF2, "25.21"), (Standards.NACE2, "25.21")),
        ((Standards.NAF2, "25.29"), (Standards.NACE2, "25.29")),
        ((Standards.NAF2, "25.3"), (Standards.NACE2, "25.3")),
        ((Standards.NAF2, "25.30"), (Standards.NACE2, "25.30")),
        ((Standards.NAF2, "25.4"), (Standards.NACE2, "25.4")),
        ((Standards.NAF2, "25.40"), (Standards.NACE2, "25.40")),
        ((Standards.NAF2, "25.5"), (Standards.NACE2, "25.5")),
        ((Standards.NAF2, "25.50"), (Standards.NACE2, "25.50")),
        ((Standards.NAF2, "25.6"), (Standards.NACE2, "25.6")),
        ((Standards.NAF2, "25.61"), (Standards.NACE2, "25.61")),
        ((Standards.NAF2, "25.62"), (Standards.NACE2, "25.62")),
        ((Standards.NAF2, "25.7"), (Standards.NACE2, "25.7")),
        ((Standards.NAF2, "25.71"), (Standards.NACE2, "25.71")),
        ((Standards.NAF2, "25.72"), (Standards.NACE2, "25.72")),
        ((Standards.NAF2, "25.73"), (Standards.NACE2, "25.73")),
        ((Standards.NAF2, "25.9"), (Standards.NACE2, "25.9")),
        ((Standards.NAF2, "25.91"), (Standards.NACE2, "25.91")),
        ((Standards.NAF2, "25.92"), (Standards.NACE2, "25.92")),
        ((Standards.NAF2, "25.93"), (Standards.NACE2, "25.93")),
        ((Standards.NAF2, "25.94"), (Standards.NACE2, "25.94")),
        ((Standards.NAF2, "25.99"), (Standards.NACE2, "25.99")),
        ((Standards.NAF2, "26"), (Standards.NACE2, "26")),
        ((Standards.NAF2, "26.1"), (Standards.NACE2, "26.1")),
        ((Standards.NAF2, "26.11"), (Standards.NACE2, "26.11")),
        ((Standards.NAF2, "26.12"), (Standards.NACE2, "26.12")),
        ((Standards.NAF2, "26.2"), (Standards.NACE2, "26.2")),
        ((Standards.NAF2, "26.20"), (Standards.NACE2, "26.20")),
        ((Standards.NAF2, "26.3"), (Standards.NACE2, "26.3")),
        ((Standards.NAF2, "26.30"), (Standards.NACE2, "26.30")),
        ((Standards.NAF2, "26.4"), (Standards.NACE2, "26.4")),
        ((Standards.NAF2, "26.40"), (Standards.NACE2, "26.40")),
        ((Standards.NAF2, "26.5"), (Standards.NACE2, "26.5")),
        ((Standards.NAF2, "26.51"), (Standards.NACE2, "26.51")),
        ((Standards.NAF2, "26.52"), (Standards.NACE2, "26.52")),
        ((Standards.NAF2, "26.6"), (Standards.NACE2, "26.6")),
        ((Standards.NAF2, "26.60"), (Standards.NACE2, "26.60")),
        ((Standards.NAF2, "26.7"), (Standards.NACE2, "26.7")),
        ((Standards.NAF2, "26.70"), (Standards.NACE2, "26.70")),
        ((Standards.NAF2, "26.8"), (Standards.NACE2, "26.8")),
        ((Standards.NAF2, "26.80"), (Standards.NACE2, "26.80")),
        ((Standards.NAF2, "27"), (Standards.NACE2, "27")),
        ((Standards.NAF2, "27.1"), (Standards.NACE2, "27.1")),
        ((Standards.NAF2, "27.11"), (Standards.NACE2, "27.11")),
        ((Standards.NAF2, "27.12"), (Standards.NACE2, "27.12")),
        ((Standards.NAF2, "27.2"), (Standards.NACE2, "27.2")),
        ((Standards.NAF2, "27.20"), (Standards.NACE2, "27.20")),
        ((Standards.NAF2, "27.3"), (Standards.NACE2, "27.3")),
        ((Standards.NAF2, "27.31"), (Standards.NACE2, "27.31")),
        ((Standards.NAF2, "27.32"), (Standards.NACE2, "27.32")),
        ((Standards.NAF2, "27.33"), (Standards.NACE2, "27.33")),
        ((Standards.NAF2, "27.4"), (Standards.NACE2, "27.4")),
        ((Standards.NAF2, "27.40"), (Standards.NACE2, "27.40")),
        ((Standards.NAF2, "27.5"), (Standards.NACE2, "27.5")),
        ((Standards.NAF2, "27.51"), (Standards.NACE2, "27.51")),
        ((Standards.NAF2, "27.52"), (Standards.NACE2, "27.52")),
        ((Standards.NAF2, "27.9"), (Standards.NACE2, "27.9")),
        ((Standards.NAF2, "27.90"), (Standards.NACE2, "27.90")),
        ((Standards.NAF2, "28"), (Standards.NACE2, "28")),
        ((Standards.NAF2, "28.1"), (Standards.NACE2, "28.1")),
        ((Standards.NAF2, "28.11"), (Standards.NACE2, "28.11")),
        ((Standards.NAF2, "28.12"), (Standards.NACE2, "28.12")),
        ((Standards.NAF2, "28.13"), (Standards.NACE2, "28.13")),
        ((Standards.NAF2, "28.14"), (Standards.NACE2, "28.14")),
        ((Standards.NAF2, "28.15"), (Standards.NACE2, "28.15")),
        ((Standards.NAF2, "28.2"), (Standards.NACE2, "28.2")),
        ((Standards.NAF2, "28.21"), (Standards.NACE2, "28.21")),
        ((Standards.NAF2, "28.22"), (Standards.NACE2, "28.22")),
        ((Standards.NAF2, "28.23"), (Standards.NACE2, "28.23")),
        ((Standards.NAF2, "28.24"), (Standards.NACE2, "28.24")),
        ((Standards.NAF2, "28.25"), (Standards.NACE2, "28.25")),
        ((Standards.NAF2, "28.29"), (Standards.NACE2, "28.29")),
        ((Standards.NAF2, "28.3"), (Standards.NACE2, "28.3")),
        ((Standards.NAF2, "28.30"), (Standards.NACE2, "28.30")),
        ((Standards.NAF2, "28.4"), (Standards.NACE2, "28.4")),
        ((Standards.NAF2, "28.41"), (Standards.NACE2, "28.41")),
        ((Standards.NAF2, "28.49"), (Standards.NACE2, "28.49")),
        ((Standards.NAF2, "28.9"), (Standards.NACE2, "28.9")),
        ((Standards.NAF2, "28.91"), (Standards.NACE2, "28.91")),
        ((Standards.NAF2, "28.92"), (Standards.NACE2, "28.92")),
        ((Standards.NAF2, "28.93"), (Standards.NACE2, "28.93")),
        ((Standards.NAF2, "28.94"), (Standards.NACE2, "28.94")),
        ((Standards.NAF2, "28.95"), (Standards.NACE2, "28.95")),
        ((Standards.NAF2, "28.96"), (Standards.NACE2, "28.96")),
        ((Standards.NAF2, "28.99"), (Standards.NACE2, "28.99")),
        ((Standards.NAF2, "29"), (Standards.NACE2, "29")),
        ((Standards.NAF2, "29.1"), (Standards.NACE2, "29.1")),
        ((Standards.NAF2, "29.10"), (Standards.NACE2, "29.10")),
        ((Standards.NAF2, "29.2"), (Standards.NACE2, "29.2")),
        ((Standards.NAF2, "29.20"), (Standards.NACE2, "29.20")),
        ((Standards.NAF2, "29.3"), (Standards.NACE2, "29.3")),
        ((Standards.NAF2, "29.31"), (Standards.NACE2, "29.31")),
        ((Standards.NAF2, "29.32"), (Standards.NACE2, "29.32")),
        ((Standards.NAF2, "30"), (Standards.NACE2, "30")),
        ((Standards.NAF2, "30.1"), (Standards.NACE2, "30.1")),
        ((Standards.NAF2, "30.11"), (Standards.NACE2, "30.11")),
        ((Standards.NAF2, "30.12"), (Standards.NACE2, "30.12")),
        ((Standards.NAF2, "30.2"), (Standards.NACE2, "30.2")),
        ((Standards.NAF2, "30.20"), (Standards.NACE2, "30.20")),
        ((Standards.NAF2, "30.3"), (Standards.NACE2, "30.3")),
        ((Standards.NAF2, "30.30"), (Standards.NACE2, "30.30")),
        ((Standards.NAF2, "30.4"), (Standards.NACE2, "30.4")),
        ((Standards.NAF2, "30.40"), (Standards.NACE2, "30.40")),
        ((Standards.NAF2, "30.9"), (Standards.NACE2, "30.9")),
        ((Standards.NAF2, "30.91"), (Standards.NACE2, "30.91")),
        ((Standards.NAF2, "30.92"), (Standards.NACE2, "30.92")),
        ((Standards.NAF2, "30.99"), (Standards.NACE2, "30.99")),
        ((Standards.NAF2, "31"), (Standards.NACE2, "31")),
        ((Standards.NAF2, "31.0"), (Standards.NACE2, "31.0")),
        ((Standards.NAF2, "31.01"), (Standards.NACE2, "31.01")),
        ((Standards.NAF2, "31.02"), (Standards.NACE2, "31.02")),
        ((Standards.NAF2, "31.03"), (Standards.NACE2, "31.03")),
        ((Standards.NAF2, "31.09"), (Standards.NACE2, "31.09")),
        ((Standards.NAF2, "32"), (Standards.NACE2, "32")),
        ((Standards.NAF2, "32.1"), (Standards.NACE2, "32.1")),
        ((Standards.NAF2, "32.11"), (Standards.NACE2, "32.11")),
        ((Standards.NAF2, "32.12"), (Standards.NACE2, "32.12")),
        ((Standards.NAF2, "32.13"), (Standards.NACE2, "32.13")),
        ((Standards.NAF2, "32.2"), (Standards.NACE2, "32.2")),
        ((Standards.NAF2, "32.20"), (Standards.NACE2, "32.20")),
        ((Standards.NAF2, "32.3"), (Standards.NACE2, "32.3")),
        ((Standards.NAF2, "32.30"), (Standards.NACE2, "32.30")),
        ((Standards.NAF2, "32.4"), (Standards.NACE2, "32.4")),
        ((Standards.NAF2, "32.40"), (Standards.NACE2, "32.40")),
        ((Standards.NAF2, "32.5"), (Standards.NACE2, "32.5")),
        ((Standards.NAF2, "32.50"), (Standards.NACE2, "32.50")),
        ((Standards.NAF2, "32.9"), (Standards.NACE2, "32.9")),
        ((Standards.NAF2, "32.91"), (Standards.NACE2, "32.91")),
        ((Standards.NAF2, "32.99"), (Standards.NACE2, "32.99")),
        ((Standards.NAF2, "33"), (Standards.NACE2, "33")),
        ((Standards.NAF2, "33.1"), (Standards.NACE2, "33.1")),
        ((Standards.NAF2, "33.11"), (Standards.NACE2, "33.11")),
        ((Standards.NAF2, "33.12"), (Standards.NACE2, "33.12")),
        ((Standards.NAF2, "33.13"), (Standards.NACE2, "33.13")),
        ((Standards.NAF2, "33.14"), (Standards.NACE2, "33.14")),
        ((Standards.NAF2, "33.15"), (Standards.NACE2, "33.15")),
        ((Standards.NAF2, "33.16"), (Standards.NACE2, "33.16")),
        ((Standards.NAF2, "33.17"), (Standards.NACE2, "33.17")),
        ((Standards.NAF2, "33.19"), (Standards.NACE2, "33.19")),
        ((Standards.NAF2, "33.2"), (Standards.NACE2, "33.2")),
        ((Standards.NAF2, "33.20"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "D"), (Standards.NACE2, "D")),
        ((Standards.NAF2, "35"), (Standards.NACE2, "35")),
        ((Standards.NAF2, "35.1"), (Standards.NACE2, "35.1")),
        ((Standards.NAF2, "35.11"), (Standards.NACE2, "35.11")),
        ((Standards.NAF2, "35.12"), (Standards.NACE2, "35.12")),
        ((Standards.NAF2, "35.13"), (Standards.NACE2, "35.13")),
        ((Standards.NAF2, "35.14"), (Standards.NACE2, "35.14")),
        ((Standards.NAF2, "35.2"), (Standards.NACE2, "35.2")),
        ((Standards.NAF2, "35.21"), (Standards.NACE2, "35.21")),
        ((Standards.NAF2, "35.22"), (Standards.NACE2, "35.22")),
        ((Standards.NAF2, "35.23"), (Standards.NACE2, "35.23")),
        ((Standards.NAF2, "35.3"), (Standards.NACE2, "35.3")),
        ((Standards.NAF2, "35.30"), (Standards.NACE2, "35.30")),
        ((Standards.NAF2, "E"), (Standards.NACE2, "E")),
        ((Standards.NAF2, "36"), (Standards.NACE2, "36")),
        ((Standards.NAF2, "36.0"), (Standards.NACE2, "36.0")),
        ((Standards.NAF2, "36.00"), (Standards.NACE2, "36.00")),
        ((Standards.NAF2, "37"), (Standards.NACE2, "37")),
        ((Standards.NAF2, "37.0"), (Standards.NACE2, "37.0")),
        ((Standards.NAF2, "37.00"), (Standards.NACE2, "37.00")),
        ((Standards.NAF2, "38"), (Standards.NACE2, "38")),
        ((Standards.NAF2, "38.1"), (Standards.NACE2, "38.1")),
        ((Standards.NAF2, "38.11"), (Standards.NACE2, "38.11")),
        ((Standards.NAF2, "38.12"), (Standards.NACE2, "38.12")),
        ((Standards.NAF2, "38.2"), (Standards.NACE2, "38.2")),
        ((Standards.NAF2, "38.21"), (Standards.NACE2, "38.21")),
        ((Standards.NAF2, "38.22"), (Standards.NACE2, "38.22")),
        ((Standards.NAF2, "38.3"), (Standards.NACE2, "38.3")),
        ((Standards.NAF2, "38.31"), (Standards.NACE2, "38.31")),
        ((Standards.NAF2, "38.32"), (Standards.NACE2, "38.32")),
        ((Standards.NAF2, "39"), (Standards.NACE2, "39")),
        ((Standards.NAF2, "39.0"), (Standards.NACE2, "39.0")),
        ((Standards.NAF2, "39.00"), (Standards.NACE2, "39.00")),
        ((Standards.NAF2, "F"), (Standards.NACE2, "F")),
        ((Standards.NAF2, "41"), (Standards.NACE2, "41")),
        ((Standards.NAF2, "41.1"), (Standards.NACE2, "41.1")),
        ((Standards.NAF2, "41.10"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.2"), (Standards.NACE2, "41.2")),
        ((Standards.NAF2, "41.20"), (Standards.NACE2, "41.20")),
        ((Standards.NAF2, "42"), (Standards.NACE2, "42")),
        ((Standards.NAF2, "42.1"), (Standards.NACE2, "42.1")),
        ((Standards.NAF2, "42.11"), (Standards.NACE2, "42.11")),
        ((Standards.NAF2, "42.12"), (Standards.NACE2, "42.12")),
        ((Standards.NAF2, "42.13"), (Standards.NACE2, "42.13")),
        ((Standards.NAF2, "42.2"), (Standards.NACE2, "42.2")),
        ((Standards.NAF2, "42.21"), (Standards.NACE2, "42.21")),
        ((Standards.NAF2, "42.22"), (Standards.NACE2, "42.22")),
        ((Standards.NAF2, "42.9"), (Standards.NACE2, "42.9")),
        ((Standards.NAF2, "42.91"), (Standards.NACE2, "42.91")),
        ((Standards.NAF2, "42.99"), (Standards.NACE2, "42.99")),
        ((Standards.NAF2, "43"), (Standards.NACE2, "43")),
        ((Standards.NAF2, "43.1"), (Standards.NACE2, "43.1")),
        ((Standards.NAF2, "43.11"), (Standards.NACE2, "43.11")),
        ((Standards.NAF2, "43.12"), (Standards.NACE2, "43.12")),
        ((Standards.NAF2, "43.13"), (Standards.NACE2, "43.13")),
        ((Standards.NAF2, "43.2"), (Standards.NACE2, "43.2")),
        ((Standards.NAF2, "43.21"), (Standards.NACE2, "43.21")),
        ((Standards.NAF2, "43.22"), (Standards.NACE2, "43.22")),
        ((Standards.NAF2, "43.29"), (Standards.NACE2, "43.29")),
        ((Standards.NAF2, "43.3"), (Standards.NACE2, "43.3")),
        ((Standards.NAF2, "43.31"), (Standards.NACE2, "43.31")),
        ((Standards.NAF2, "43.32"), (Standards.NACE2, "43.32")),
        ((Standards.NAF2, "43.33"), (Standards.NACE2, "43.33")),
        ((Standards.NAF2, "43.34"), (Standards.NACE2, "43.34")),
        ((Standards.NAF2, "43.39"), (Standards.NACE2, "43.39")),
        ((Standards.NAF2, "43.9"), (Standards.NACE2, "43.9")),
        ((Standards.NAF2, "43.91"), (Standards.NACE2, "43.91")),
        ((Standards.NAF2, "43.99"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "G"), (Standards.NACE2, "G")),
        ((Standards.NAF2, "45"), (Standards.NACE2, "45")),
        ((Standards.NAF2, "45.1"), (Standards.NACE2, "45.1")),
        ((Standards.NAF2, "45.11"), (Standards.NACE2, "45.11")),
        ((Standards.NAF2, "45.19"), (Standards.NACE2, "45.19")),
        ((Standards.NAF2, "45.2"), (Standards.NACE2, "45.2")),
        ((Standards.NAF2, "45.20"), (Standards.NACE2, "45.20")),
        ((Standards.NAF2, "45.3"), (Standards.NACE2, "45.3")),
        ((Standards.NAF2, "45.31"), (Standards.NACE2, "45.31")),
        ((Standards.NAF2, "45.32"), (Standards.NACE2, "45.32")),
        ((Standards.NAF2, "45.4"), (Standards.NACE2, "45.4")),
        ((Standards.NAF2, "45.40"), (Standards.NACE2, "45.40")),
        ((Standards.NAF2, "46"), (Standards.NACE2, "46")),
        ((Standards.NAF2, "46.1"), (Standards.NACE2, "46.1")),
        ((Standards.NAF2, "46.11"), (Standards.NACE2, "46.11")),
        ((Standards.NAF2, "46.12"), (Standards.NACE2, "46.12")),
        ((Standards.NAF2, "46.13"), (Standards.NACE2, "46.13")),
        ((Standards.NAF2, "46.14"), (Standards.NACE2, "46.14")),
        ((Standards.NAF2, "46.15"), (Standards.NACE2, "46.15")),
        ((Standards.NAF2, "46.16"), (Standards.NACE2, "46.16")),
        ((Standards.NAF2, "46.17"), (Standards.NACE2, "46.17")),
        ((Standards.NAF2, "46.18"), (Standards.NACE2, "46.18")),
        ((Standards.NAF2, "46.19"), (Standards.NACE2, "46.19")),
        ((Standards.NAF2, "46.2"), (Standards.NACE2, "46.2")),
        ((Standards.NAF2, "46.21"), (Standards.NACE2, "46.21")),
        ((Standards.NAF2, "46.22"), (Standards.NACE2, "46.22")),
        ((Standards.NAF2, "46.23"), (Standards.NACE2, "46.23")),
        ((Standards.NAF2, "46.24"), (Standards.NACE2, "46.24")),
        ((Standards.NAF2, "46.3"), (Standards.NACE2, "46.3")),
        ((Standards.NAF2, "46.31"), (Standards.NACE2, "46.31")),
        ((Standards.NAF2, "46.32"), (Standards.NACE2, "46.32")),
        ((Standards.NAF2, "46.33"), (Standards.NACE2, "46.33")),
        ((Standards.NAF2, "46.34"), (Standards.NACE2, "46.34")),
        ((Standards.NAF2, "46.35"), (Standards.NACE2, "46.35")),
        ((Standards.NAF2, "46.36"), (Standards.NACE2, "46.36")),
        ((Standards.NAF2, "46.37"), (Standards.NACE2, "46.37")),
        ((Standards.NAF2, "46.38"), (Standards.NACE2, "46.38")),
        ((Standards.NAF2, "46.39"), (Standards.NACE2, "46.39")),
        ((Standards.NAF2, "46.4"), (Standards.NACE2, "46.4")),
        ((Standards.NAF2, "46.41"), (Standards.NACE2, "46.41")),
        ((Standards.NAF2, "46.42"), (Standards.NACE2, "46.42")),
        ((Standards.NAF2, "46.43"), (Standards.NACE2, "46.43")),
        ((Standards.NAF2, "46.44"), (Standards.NACE2, "46.44")),
        ((Standards.NAF2, "46.45"), (Standards.NACE2, "46.45")),
        ((Standards.NAF2, "46.46"), (Standards.NACE2, "46.46")),
        ((Standards.NAF2, "46.47"), (Standards.NACE2, "46.47")),
        ((Standards.NAF2, "46.48"), (Standards.NACE2, "46.48")),
        ((Standards.NAF2, "46.49"), (Standards.NACE2, "46.49")),
        ((Standards.NAF2, "46.5"), (Standards.NACE2, "46.5")),
        ((Standards.NAF2, "46.51"), (Standards.NACE2, "46.51")),
        ((Standards.NAF2, "46.52"), (Standards.NACE2, "46.52")),
        ((Standards.NAF2, "46.6"), (Standards.NACE2, "46.6")),
        ((Standards.NAF2, "46.61"), (Standards.NACE2, "46.61")),
        ((Standards.NAF2, "46.62"), (Standards.NACE2, "46.62")),
        ((Standards.NAF2, "46.63"), (Standards.NACE2, "46.63")),
        ((Standards.NAF2, "46.64"), (Standards.NACE2, "46.64")),
        ((Standards.NAF2, "46.65"), (Standards.NACE2, "46.65")),
        ((Standards.NAF2, "46.66"), (Standards.NACE2, "46.66")),
        ((Standards.NAF2, "46.69"), (Standards.NACE2, "46.69")),
        ((Standards.NAF2, "46.7"), (Standards.NACE2, "46.7")),
        ((Standards.NAF2, "46.71"), (Standards.NACE2, "46.71")),
        ((Standards.NAF2, "46.72"), (Standards.NACE2, "46.72")),
        ((Standards.NAF2, "46.73"), (Standards.NACE2, "46.73")),
        ((Standards.NAF2, "46.74"), (Standards.NACE2, "46.74")),
        ((Standards.NAF2, "46.75"), (Standards.NACE2, "46.75")),
        ((Standards.NAF2, "46.76"), (Standards.NACE2, "46.76")),
        ((Standards.NAF2, "46.77"), (Standards.NACE2, "46.77")),
        ((Standards.NAF2, "46.9"), (Standards.NACE2, "46.9")),
        ((Standards.NAF2, "46.90"), (Standards.NACE2, "46.90")),
        ((Standards.NAF2, "47"), (Standards.NACE2, "47")),
        ((Standards.NAF2, "47.1"), (Standards.NACE2, "47.1")),
        ((Standards.NAF2, "47.11"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.19"), (Standards.NACE2, "47.19")),
        ((Standards.NAF2, "47.2"), (Standards.NACE2, "47.2")),
        ((Standards.NAF2, "47.21"), (Standards.NACE2, "47.21")),
        ((Standards.NAF2, "47.22"), (Standards.NACE2, "47.22")),
        ((Standards.NAF2, "47.23"), (Standards.NACE2, "47.23")),
        ((Standards.NAF2, "47.24"), (Standards.NACE2, "47.24")),
        ((Standards.NAF2, "47.25"), (Standards.NACE2, "47.25")),
        ((Standards.NAF2, "47.26"), (Standards.NACE2, "47.26")),
        ((Standards.NAF2, "47.29"), (Standards.NACE2, "47.29")),
        ((Standards.NAF2, "47.3"), (Standards.NACE2, "47.3")),
        ((Standards.NAF2, "47.30"), (Standards.NACE2, "47.30")),
        ((Standards.NAF2, "47.4"), (Standards.NACE2, "47.4")),
        ((Standards.NAF2, "47.41"), (Standards.NACE2, "47.41")),
        ((Standards.NAF2, "47.42"), (Standards.NACE2, "47.42")),
        ((Standards.NAF2, "47.43"), (Standards.NACE2, "47.43")),
        ((Standards.NAF2, "47.5"), (Standards.NACE2, "47.5")),
        ((Standards.NAF2, "47.51"), (Standards.NACE2, "47.51")),
        ((Standards.NAF2, "47.52"), (Standards.NACE2, "47.52")),
        ((Standards.NAF2, "47.53"), (Standards.NACE2, "47.53")),
        ((Standards.NAF2, "47.54"), (Standards.NACE2, "47.54")),
        ((Standards.NAF2, "47.59"), (Standards.NACE2, "47.59")),
        ((Standards.NAF2, "47.6"), (Standards.NACE2, "47.6")),
        ((Standards.NAF2, "47.61"), (Standards.NACE2, "47.61")),
        ((Standards.NAF2, "47.62"), (Standards.NACE2, "47.62")),
        ((Standards.NAF2, "47.63"), (Standards.NACE2, "47.63")),
        ((Standards.NAF2, "47.64"), (Standards.NACE2, "47.64")),
        ((Standards.NAF2, "47.65"), (Standards.NACE2, "47.65")),
        ((Standards.NAF2, "47.7"), (Standards.NACE2, "47.7")),
        ((Standards.NAF2, "47.71"), (Standards.NACE2, "47.71")),
        ((Standards.NAF2, "47.72"), (Standards.NACE2, "47.72")),
        ((Standards.NAF2, "47.73"), (Standards.NACE2, "47.73")),
        ((Standards.NAF2, "47.74"), (Standards.NACE2, "47.74")),
        ((Standards.NAF2, "47.75"), (Standards.NACE2, "47.75")),
        ((Standards.NAF2, "47.76"), (Standards.NACE2, "47.76")),
        ((Standards.NAF2, "47.77"), (Standards.NACE2, "47.77")),
        ((Standards.NAF2, "47.78"), (Standards.NACE2, "47.78")),
        ((Standards.NAF2, "47.79"), (Standards.NACE2, "47.79")),
        ((Standards.NAF2, "47.8"), (Standards.NACE2, "47.8")),
        ((Standards.NAF2, "47.81"), (Standards.NACE2, "47.81")),
        ((Standards.NAF2, "47.82"), (Standards.NACE2, "47.82")),
        ((Standards.NAF2, "47.89"), (Standards.NACE2, "47.89")),
        ((Standards.NAF2, "47.9"), (Standards.NACE2, "47.9")),
        ((Standards.NAF2, "47.91"), (Standards.NACE2, "47.91")),
        ((Standards.NAF2, "47.99"), (Standards.NACE2, "47.99")),
        ((Standards.NAF2, "H"), (Standards.NACE2, "H")),
        ((Standards.NAF2, "49"), (Standards.NACE2, "49")),
        ((Standards.NAF2, "49.1"), (Standards.NACE2, "49.1")),
        ((Standards.NAF2, "49.10"), (Standards.NACE2, "49.10")),
        ((Standards.NAF2, "49.2"), (Standards.NACE2, "49.2")),
        ((Standards.NAF2, "49.20"), (Standards.NACE2, "49.20")),
        ((Standards.NAF2, "49.3"), (Standards.NACE2, "49.3")),
        ((Standards.NAF2, "49.31"), (Standards.NACE2, "49.31")),
        ((Standards.NAF2, "49.32"), (Standards.NACE2, "49.32")),
        ((Standards.NAF2, "49.39"), (Standards.NACE2, "49.39")),
        ((Standards.NAF2, "49.4"), (Standards.NACE2, "49.4")),
        ((Standards.NAF2, "49.41"), (Standards.NACE2, "49.41")),
        ((Standards.NAF2, "49.42"), (Standards.NACE2, "49.42")),
        ((Standards.NAF2, "49.5"), (Standards.NACE2, "49.5")),
        ((Standards.NAF2, "49.50"), (Standards.NACE2, "49.50")),
        ((Standards.NAF2, "50"), (Standards.NACE2, "50")),
        ((Standards.NAF2, "50.1"), (Standards.NACE2, "50.1")),
        ((Standards.NAF2, "50.10"), (Standards.NACE2, "50.10")),
        ((Standards.NAF2, "50.2"), (Standards.NACE2, "50.2")),
        ((Standards.NAF2, "50.20"), (Standards.NACE2, "50.20")),
        ((Standards.NAF2, "50.3"), (Standards.NACE2, "50.3")),
        ((Standards.NAF2, "50.30"), (Standards.NACE2, "50.30")),
        ((Standards.NAF2, "50.4"), (Standards.NACE2, "50.4")),
        ((Standards.NAF2, "50.40"), (Standards.NACE2, "50.40")),
        ((Standards.NAF2, "51"), (Standards.NACE2, "51")),
        ((Standards.NAF2, "51.1"), (Standards.NACE2, "51.1")),
        ((Standards.NAF2, "51.10"), (Standards.NACE2, "51.10")),
        ((Standards.NAF2, "51.2"), (Standards.NACE2, "51.2")),
        ((Standards.NAF2, "51.21"), (Standards.NACE2, "51.21")),
        ((Standards.NAF2, "51.22"), (Standards.NACE2, "51.22")),
        ((Standards.NAF2, "52"), (Standards.NACE2, "52")),
        ((Standards.NAF2, "52.1"), (Standards.NACE2, "52.1")),
        ((Standards.NAF2, "52.10"), (Standards.NACE2, "52.10")),
        ((Standards.NAF2, "52.2"), (Standards.NACE2, "52.2")),
        ((Standards.NAF2, "52.21"), (Standards.NACE2, "52.21")),
        ((Standards.NAF2, "52.22"), (Standards.NACE2, "52.22")),
        ((Standards.NAF2, "52.23"), (Standards.NACE2, "52.23")),
        ((Standards.NAF2, "52.24"), (Standards.NACE2, "52.24")),
        ((Standards.NAF2, "52.29"), (Standards.NACE2, "52.29")),
        ((Standards.NAF2, "53"), (Standards.NACE2, "53")),
        ((Standards.NAF2, "53.1"), (Standards.NACE2, "53.1")),
        ((Standards.NAF2, "53.10"), (Standards.NACE2, "53.10")),
        ((Standards.NAF2, "53.2"), (Standards.NACE2, "53.2")),
        ((Standards.NAF2, "53.20"), (Standards.NACE2, "53.20")),
        ((Standards.NAF2, "I"), (Standards.NACE2, "I")),
        ((Standards.NAF2, "55"), (Standards.NACE2, "55")),
        ((Standards.NAF2, "55.1"), (Standards.NACE2, "55.1")),
        ((Standards.NAF2, "55.10"), (Standards.NACE2, "55.10")),
        ((Standards.NAF2, "55.2"), (Standards.NACE2, "55.2")),
        ((Standards.NAF2, "55.20"), (Standards.NACE2, "55.20")),
        ((Standards.NAF2, "55.3"), (Standards.NACE2, "55.3")),
        ((Standards.NAF2, "55.30"), (Standards.NACE2, "55.30")),
        ((Standards.NAF2, "55.9"), (Standards.NACE2, "55.9")),
        ((Standards.NAF2, "55.90"), (Standards.NACE2, "55.90")),
        ((Standards.NAF2, "56"), (Standards.NACE2, "56")),
        ((Standards.NAF2, "56.1"), (Standards.NACE2, "56.1")),
        ((Standards.NAF2, "56.10"), (Standards.NACE2, "56.10")),
        ((Standards.NAF2, "56.2"), (Standards.NACE2, "56.2")),
        ((Standards.NAF2, "56.21"), (Standards.NACE2, "56.21")),
        ((Standards.NAF2, "56.29"), (Standards.NACE2, "56.29")),
        ((Standards.NAF2, "56.3"), (Standards.NACE2, "56.3")),
        ((Standards.NAF2, "56.30"), (Standards.NACE2, "56.30")),
        ((Standards.NAF2, "J"), (Standards.NACE2, "J")),
        ((Standards.NAF2, "58"), (Standards.NACE2, "58")),
        ((Standards.NAF2, "58.1"), (Standards.NACE2, "58.1")),
        ((Standards.NAF2, "58.11"), (Standards.NACE2, "58.11")),
        ((Standards.NAF2, "58.12"), (Standards.NACE2, "58.12")),
        ((Standards.NAF2, "58.13"), (Standards.NACE2, "58.13")),
        ((Standards.NAF2, "58.14"), (Standards.NACE2, "58.14")),
        ((Standards.NAF2, "58.19"), (Standards.NACE2, "58.19")),
        ((Standards.NAF2, "58.2"), (Standards.NACE2, "58.2")),
        ((Standards.NAF2, "58.21"), (Standards.NACE2, "58.21")),
        ((Standards.NAF2, "58.29"), (Standards.NACE2, "58.29")),
        ((Standards.NAF2, "59"), (Standards.NACE2, "59")),
        ((Standards.NAF2, "59.1"), (Standards.NACE2, "59.1")),
        ((Standards.NAF2, "59.11"), (Standards.NACE2, "59.11")),
        ((Standards.NAF2, "59.12"), (Standards.NACE2, "59.12")),
        ((Standards.NAF2, "59.13"), (Standards.NACE2, "59.13")),
        ((Standards.NAF2, "59.14"), (Standards.NACE2, "59.14")),
        ((Standards.NAF2, "59.2"), (Standards.NACE2, "59.2")),
        ((Standards.NAF2, "59.20"), (Standards.NACE2, "59.20")),
        ((Standards.NAF2, "60"), (Standards.NACE2, "60")),
        ((Standards.NAF2, "60.1"), (Standards.NACE2, "60.1")),
        ((Standards.NAF2, "60.10"), (Standards.NACE2, "60.10")),
        ((Standards.NAF2, "60.2"), (Standards.NACE2, "60.2")),
        ((Standards.NAF2, "60.20"), (Standards.NACE2, "60.20")),
        ((Standards.NAF2, "61"), (Standards.NACE2, "61")),
        ((Standards.NAF2, "61.1"), (Standards.NACE2, "61.1")),
        ((Standards.NAF2, "61.10"), (Standards.NACE2, "61.10")),
        ((Standards.NAF2, "61.2"), (Standards.NACE2, "61.2")),
        ((Standards.NAF2, "61.20"), (Standards.NACE2, "61.20")),
        ((Standards.NAF2, "61.3"), (Standards.NACE2, "61.3")),
        ((Standards.NAF2, "61.30"), (Standards.NACE2, "61.30")),
        ((Standards.NAF2, "61.9"), (Standards.NACE2, "61.9")),
        ((Standards.NAF2, "61.90"), (Standards.NACE2, "61.90")),
        ((Standards.NAF2, "62"), (Standards.NACE2, "62")),
        ((Standards.NAF2, "62.0"), (Standards.NACE2, "62.0")),
        ((Standards.NAF2, "62.01"), (Standards.NACE2, "62.01")),
        ((Standards.NAF2, "62.02"), (Standards.NACE2, "62.02")),
        ((Standards.NAF2, "62.03"), (Standards.NACE2, "62.03")),
        ((Standards.NAF2, "62.09"), (Standards.NACE2, "62.09")),
        ((Standards.NAF2, "63"), (Standards.NACE2, "63")),
        ((Standards.NAF2, "63.1"), (Standards.NACE2, "63.1")),
        ((Standards.NAF2, "63.11"), (Standards.NACE2, "63.11")),
        ((Standards.NAF2, "63.12"), (Standards.NACE2, "63.12")),
        ((Standards.NAF2, "63.9"), (Standards.NACE2, "63.9")),
        ((Standards.NAF2, "63.91"), (Standards.NACE2, "63.91")),
        ((Standards.NAF2, "63.99"), (Standards.NACE2, "63.99")),
        ((Standards.NAF2, "K"), (Standards.NACE2, "K")),
        ((Standards.NAF2, "64"), (Standards.NACE2, "64")),
        ((Standards.NAF2, "64.1"), (Standards.NACE2, "64.1")),
        ((Standards.NAF2, "64.11"), (Standards.NACE2, "64.11")),
        ((Standards.NAF2, "64.19"), (Standards.NACE2, "64.19")),
        ((Standards.NAF2, "64.2"), (Standards.NACE2, "64.2")),
        ((Standards.NAF2, "64.20"), (Standards.NACE2, "64.20")),
        ((Standards.NAF2, "64.3"), (Standards.NACE2, "64.3")),
        ((Standards.NAF2, "64.30"), (Standards.NACE2, "64.30")),
        ((Standards.NAF2, "64.9"), (Standards.NACE2, "64.9")),
        ((Standards.NAF2, "64.91"), (Standards.NACE2, "64.91")),
        ((Standards.NAF2, "64.92"), (Standards.NACE2, "64.92")),
        ((Standards.NAF2, "64.99"), (Standards.NACE2, "64.99")),
        ((Standards.NAF2, "65"), (Standards.NACE2, "65")),
        ((Standards.NAF2, "65.1"), (Standards.NACE2, "65.1")),
        ((Standards.NAF2, "65.11"), (Standards.NACE2, "65.11")),
        ((Standards.NAF2, "65.12"), (Standards.NACE2, "65.12")),
        ((Standards.NAF2, "65.2"), (Standards.NACE2, "65.2")),
        ((Standards.NAF2, "65.20"), (Standards.NACE2, "65.20")),
        ((Standards.NAF2, "65.3"), (Standards.NACE2, "65.3")),
        ((Standards.NAF2, "65.30"), (Standards.NACE2, "65.30")),
        ((Standards.NAF2, "66"), (Standards.NACE2, "66")),
        ((Standards.NAF2, "66.1"), (Standards.NACE2, "66.1")),
        ((Standards.NAF2, "66.11"), (Standards.NACE2, "66.11")),
        ((Standards.NAF2, "66.12"), (Standards.NACE2, "66.12")),
        ((Standards.NAF2, "66.19"), (Standards.NACE2, "66.19")),
        ((Standards.NAF2, "66.2"), (Standards.NACE2, "66.2")),
        ((Standards.NAF2, "66.21"), (Standards.NACE2, "66.21")),
        ((Standards.NAF2, "66.22"), (Standards.NACE2, "66.22")),
        ((Standards.NAF2, "66.29"), (Standards.NACE2, "66.29")),
        ((Standards.NAF2, "66.3"), (Standards.NACE2, "66.3")),
        ((Standards.NAF2, "66.30"), (Standards.NACE2, "66.30")),
        ((Standards.NAF2, "L"), (Standards.NACE2, "L")),
        ((Standards.NAF2, "68"), (Standards.NACE2, "68")),
        ((Standards.NAF2, "68.1"), (Standards.NACE2, "68.1")),
        ((Standards.NAF2, "68.10"), (Standards.NACE2, "68.10")),
        ((Standards.NAF2, "68.2"), (Standards.NACE2, "68.2")),
        ((Standards.NAF2, "68.20"), (Standards.NACE2, "68.20")),
        ((Standards.NAF2, "68.3"), (Standards.NACE2, "68.3")),
        ((Standards.NAF2, "68.31"), (Standards.NACE2, "68.31")),
        ((Standards.NAF2, "68.32"), (Standards.NACE2, "68.32")),
        ((Standards.NAF2, "M"), (Standards.NACE2, "M")),
        ((Standards.NAF2, "69"), (Standards.NACE2, "69")),
        ((Standards.NAF2, "69.1"), (Standards.NACE2, "69.1")),
        ((Standards.NAF2, "69.10"), (Standards.NACE2, "69.10")),
        ((Standards.NAF2, "69.2"), (Standards.NACE2, "69.2")),
        ((Standards.NAF2, "69.20"), (Standards.NACE2, "69.20")),
        ((Standards.NAF2, "70"), (Standards.NACE2, "70")),
        ((Standards.NAF2, "70.1"), (Standards.NACE2, "70.1")),
        ((Standards.NAF2, "70.10"), (Standards.NACE2, "70.10")),
        ((Standards.NAF2, "70.2"), (Standards.NACE2, "70.2")),
        ((Standards.NAF2, "70.21"), (Standards.NACE2, "70.21")),
        ((Standards.NAF2, "70.22"), (Standards.NACE2, "70.22")),
        ((Standards.NAF2, "71"), (Standards.NACE2, "71")),
        ((Standards.NAF2, "71.1"), (Standards.NACE2, "71.1")),
        ((Standards.NAF2, "71.11"), (Standards.NACE2, "71.11")),
        ((Standards.NAF2, "71.12"), (Standards.NACE2, "71.12")),
        ((Standards.NAF2, "71.2"), (Standards.NACE2, "71.2")),
        ((Standards.NAF2, "71.20"), (Standards.NACE2, "71.20")),
        ((Standards.NAF2, "72"), (Standards.NACE2, "72")),
        ((Standards.NAF2, "72.1"), (Standards.NACE2, "72.1")),
        ((Standards.NAF2, "72.11"), (Standards.NACE2, "72.11")),
        ((Standards.NAF2, "72.19"), (Standards.NACE2, "72.19")),
        ((Standards.NAF2, "72.2"), (Standards.NACE2, "72.2")),
        ((Standards.NAF2, "72.20"), (Standards.NACE2, "72.20")),
        ((Standards.NAF2, "73"), (Standards.NACE2, "73")),
        ((Standards.NAF2, "73.1"), (Standards.NACE2, "73.1")),
        ((Standards.NAF2, "73.11"), (Standards.NACE2, "73.11")),
        ((Standards.NAF2, "73.12"), (Standards.NACE2, "73.12")),
        ((Standards.NAF2, "73.2"), (Standards.NACE2, "73.2")),
        ((Standards.NAF2, "73.20"), (Standards.NACE2, "73.20")),
        ((Standards.NAF2, "74"), (Standards.NACE2, "74")),
        ((Standards.NAF2, "74.1"), (Standards.NACE2, "74.1")),
        ((Standards.NAF2, "74.10"), (Standards.NACE2, "74.10")),
        ((Standards.NAF2, "74.2"), (Standards.NACE2, "74.2")),
        ((Standards.NAF2, "74.20"), (Standards.NACE2, "74.20")),
        ((Standards.NAF2, "74.3"), (Standards.NACE2, "74.3")),
        ((Standards.NAF2, "74.30"), (Standards.NACE2, "74.30")),
        ((Standards.NAF2, "74.9"), (Standards.NACE2, "74.9")),
        ((Standards.NAF2, "74.90"), (Standards.NACE2, "74.90")),
        ((Standards.NAF2, "75"), (Standards.NACE2, "75")),
        ((Standards.NAF2, "75.0"), (Standards.NACE2, "75.0")),
        ((Standards.NAF2, "75.00"), (Standards.NACE2, "75.00")),
        ((Standards.NAF2, "N"), (Standards.NACE2, "N")),
        ((Standards.NAF2, "77"), (Standards.NACE2, "77")),
        ((Standards.NAF2, "77.1"), (Standards.NACE2, "77.1")),
        ((Standards.NAF2, "77.11"), (Standards.NACE2, "77.11")),
        ((Standards.NAF2, "77.12"), (Standards.NACE2, "77.12")),
        ((Standards.NAF2, "77.2"), (Standards.NACE2, "77.2")),
        ((Standards.NAF2, "77.21"), (Standards.NACE2, "77.21")),
        ((Standards.NAF2, "77.22"), (Standards.NACE2, "77.22")),
        ((Standards.NAF2, "77.29"), (Standards.NACE2, "77.29")),
        ((Standards.NAF2, "77.3"), (Standards.NACE2, "77.3")),
        ((Standards.NAF2, "77.31"), (Standards.NACE2, "77.31")),
        ((Standards.NAF2, "77.32"), (Standards.NACE2, "77.32")),
        ((Standards.NAF2, "77.33"), (Standards.NACE2, "77.33")),
        ((Standards.NAF2, "77.34"), (Standards.NACE2, "77.34")),
        ((Standards.NAF2, "77.35"), (Standards.NACE2, "77.35")),
        ((Standards.NAF2, "77.39"), (Standards.NACE2, "77.39")),
        ((Standards.NAF2, "77.4"), (Standards.NACE2, "77.4")),
        ((Standards.NAF2, "77.40"), (Standards.NACE2, "77.40")),
        ((Standards.NAF2, "78"), (Standards.NACE2, "78")),
        ((Standards.NAF2, "78.1"), (Standards.NACE2, "78.1")),
        ((Standards.NAF2, "78.10"), (Standards.NACE2, "78.10")),
        ((Standards.NAF2, "78.2"), (Standards.NACE2, "78.2")),
        ((Standards.NAF2, "78.20"), (Standards.NACE2, "78.20")),
        ((Standards.NAF2, "78.3"), (Standards.NACE2, "78.3")),
        ((Standards.NAF2, "78.30"), (Standards.NACE2, "78.30")),
        ((Standards.NAF2, "79"), (Standards.NACE2, "79")),
        ((Standards.NAF2, "79.1"), (Standards.NACE2, "79.1")),
        ((Standards.NAF2, "79.11"), (Standards.NACE2, "79.11")),
        ((Standards.NAF2, "79.12"), (Standards.NACE2, "79.12")),
        ((Standards.NAF2, "79.9"), (Standards.NACE2, "79.9")),
        ((Standards.NAF2, "79.90"), (Standards.NACE2, "79.90")),
        ((Standards.NAF2, "80"), (Standards.NACE2, "80")),
        ((Standards.NAF2, "80.1"), (Standards.NACE2, "80.1")),
        ((Standards.NAF2, "80.10"), (Standards.NACE2, "80.10")),
        ((Standards.NAF2, "80.2"), (Standards.NACE2, "80.2")),
        ((Standards.NAF2, "80.20"), (Standards.NACE2, "80.20")),
        ((Standards.NAF2, "80.3"), (Standards.NACE2, "80.3")),
        ((Standards.NAF2, "80.30"), (Standards.NACE2, "80.30")),
        ((Standards.NAF2, "81"), (Standards.NACE2, "81")),
        ((Standards.NAF2, "81.1"), (Standards.NACE2, "81.1")),
        ((Standards.NAF2, "81.10"), (Standards.NACE2, "81.10")),
        ((Standards.NAF2, "81.2"), (Standards.NACE2, "81.2")),
        ((Standards.NAF2, "81.21"), (Standards.NACE2, "81.21")),
        ((Standards.NAF2, "81.22"), (Standards.NACE2, "81.22")),
        ((Standards.NAF2, "81.29"), (Standards.NACE2, "81.29")),
        ((Standards.NAF2, "81.3"), (Standards.NACE2, "81.3")),
        ((Standards.NAF2, "81.30"), (Standards.NACE2, "81.30")),
        ((Standards.NAF2, "82"), (Standards.NACE2, "82")),
        ((Standards.NAF2, "82.1"), (Standards.NACE2, "82.1")),
        ((Standards.NAF2, "82.11"), (Standards.NACE2, "82.11")),
        ((Standards.NAF2, "82.19"), (Standards.NACE2, "82.19")),
        ((Standards.NAF2, "82.2"), (Standards.NACE2, "82.2")),
        ((Standards.NAF2, "82.20"), (Standards.NACE2, "82.20")),
        ((Standards.NAF2, "82.3"), (Standards.NACE2, "82.3")),
        ((Standards.NAF2, "82.30"), (Standards.NACE2, "82.30")),
        ((Standards.NAF2, "82.9"), (Standards.NACE2, "82.9")),
        ((Standards.NAF2, "82.91"), (Standards.NACE2, "82.91")),
        ((Standards.NAF2, "82.92"), (Standards.NACE2, "82.92")),
        ((Standards.NAF2, "82.99"), (Standards.NACE2, "82.99")),
        ((Standards.NAF2, "O"), (Standards.NACE2, "O")),
        ((Standards.NAF2, "84"), (Standards.NACE2, "84")),
        ((Standards.NAF2, "84.1"), (Standards.NACE2, "84.1")),
        ((Standards.NAF2, "84.11"), (Standards.NACE2, "84.11")),
        ((Standards.NAF2, "84.12"), (Standards.NACE2, "84.12")),
        ((Standards.NAF2, "84.13"), (Standards.NACE2, "84.13")),
        ((Standards.NAF2, "84.2"), (Standards.NACE2, "84.2")),
        ((Standards.NAF2, "84.21"), (Standards.NACE2, "84.21")),
        ((Standards.NAF2, "84.22"), (Standards.NACE2, "84.22")),
        ((Standards.NAF2, "84.23"), (Standards.NACE2, "84.23")),
        ((Standards.NAF2, "84.24"), (Standards.NACE2, "84.24")),
        ((Standards.NAF2, "84.25"), (Standards.NACE2, "84.25")),
        ((Standards.NAF2, "84.3"), (Standards.NACE2, "84.3")),
        ((Standards.NAF2, "84.30"), (Standards.NACE2, "84.30")),
        ((Standards.NAF2, "P"), (Standards.NACE2, "P")),
        ((Standards.NAF2, "85"), (Standards.NACE2, "85")),
        ((Standards.NAF2, "85.1"), (Standards.NACE2, "85.1")),
        ((Standards.NAF2, "85.10"), (Standards.NACE2, "85.10")),
        ((Standards.NAF2, "85.2"), (Standards.NACE2, "85.2")),
        ((Standards.NAF2, "85.20"), (Standards.NACE2, "85.20")),
        ((Standards.NAF2, "85.3"), (Standards.NACE2, "85.3")),
        ((Standards.NAF2, "85.31"), (Standards.NACE2, "85.31")),
        ((Standards.NAF2, "85.32"), (Standards.NACE2, "85.32")),
        ((Standards.NAF2, "85.4"), (Standards.NACE2, "85.4")),
        ((Standards.NAF2, "85.41"), (Standards.NACE2, "85.41")),
        ((Standards.NAF2, "85.42"), (Standards.NACE2, "85.42")),
        ((Standards.NAF2, "85.5"), (Standards.NACE2, "85.5")),
        ((Standards.NAF2, "85.51"), (Standards.NACE2, "85.51")),
        ((Standards.NAF2, "85.52"), (Standards.NACE2, "85.52")),
        ((Standards.NAF2, "85.53"), (Standards.NACE2, "85.53")),
        ((Standards.NAF2, "85.59"), (Standards.NACE2, "85.59")),
        ((Standards.NAF2, "85.6"), (Standards.NACE2, "85.6")),
        ((Standards.NAF2, "85.60"), (Standards.NACE2, "85.60")),
        ((Standards.NAF2, "Q"), (Standards.NACE2, "Q")),
        ((Standards.NAF2, "86"), (Standards.NACE2, "86")),
        ((Standards.NAF2, "86.1"), (Standards.NACE2, "86.1")),
        ((Standards.NAF2, "86.10"), (Standards.NACE2, "86.10")),
        ((Standards.NAF2, "86.2"), (Standards.NACE2, "86.2")),
        ((Standards.NAF2, "86.21"), (Standards.NACE2, "86.21")),
        ((Standards.NAF2, "86.22"), (Standards.NACE2, "86.22")),
        ((Standards.NAF2, "86.23"), (Standards.NACE2, "86.23")),
        ((Standards.NAF2, "86.9"), (Standards.NACE2, "86.9")),
        ((Standards.NAF2, "86.90"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "87"), (Standards.NACE2, "87")),
        ((Standards.NAF2, "87.1"), (Standards.NACE2, "87.1")),
        ((Standards.NAF2, "87.10"), (Standards.NACE2, "87.10")),
        ((Standards.NAF2, "87.2"), (Standards.NACE2, "87.2")),
        ((Standards.NAF2, "87.20"), (Standards.NACE2, "87.20")),
        ((Standards.NAF2, "87.3"), (Standards.NACE2, "87.3")),
        ((Standards.NAF2, "87.30"), (Standards.NACE2, "87.30")),
        ((Standards.NAF2, "87.9"), (Standards.NACE2, "87.9")),
        ((Standards.NAF2, "87.90"), (Standards.NACE2, "87.90")),
        ((Standards.NAF2, "88"), (Standards.NACE2, "88")),
        ((Standards.NAF2, "88.1"), (Standards.NACE2, "88.1")),
        ((Standards.NAF2, "88.10"), (Standards.NACE2, "88.10")),
        ((Standards.NAF2, "88.9"), (Standards.NACE2, "88.9")),
        ((Standards.NAF2, "88.91"), (Standards.NACE2, "88.91")),
        ((Standards.NAF2, "88.99"), (Standards.NACE2, "88.99")),
        ((Standards.NAF2, "R"), (Standards.NACE2, "R")),
        ((Standards.NAF2, "90"), (Standards.NACE2, "90")),
        ((Standards.NAF2, "90.0"), (Standards.NACE2, "90.0")),
        ((Standards.NAF2, "90.01"), (Standards.NACE2, "90.01")),
        ((Standards.NAF2, "90.02"), (Standards.NACE2, "90.02")),
        ((Standards.NAF2, "90.03"), (Standards.NACE2, "90.03")),
        ((Standards.NAF2, "90.04"), (Standards.NACE2, "90.04")),
        ((Standards.NAF2, "91"), (Standards.NACE2, "91")),
        ((Standards.NAF2, "91.0"), (Standards.NACE2, "91.0")),
        ((Standards.NAF2, "91.01"), (Standards.NACE2, "91.01")),
        ((Standards.NAF2, "91.02"), (Standards.NACE2, "91.02")),
        ((Standards.NAF2, "91.03"), (Standards.NACE2, "91.03")),
        ((Standards.NAF2, "91.04"), (Standards.NACE2, "91.04")),
        ((Standards.NAF2, "92"), (Standards.NACE2, "92")),
        ((Standards.NAF2, "92.0"), (Standards.NACE2, "92.0")),
        ((Standards.NAF2, "92.00"), (Standards.NACE2, "92.00")),
        ((Standards.NAF2, "93"), (Standards.NACE2, "93")),
        ((Standards.NAF2, "93.1"), (Standards.NACE2, "93.1")),
        ((Standards.NAF2, "93.11"), (Standards.NACE2, "93.11")),
        ((Standards.NAF2, "93.12"), (Standards.NACE2, "93.12")),
        ((Standards.NAF2, "93.13"), (Standards.NACE2, "93.13")),
        ((Standards.NAF2, "93.19"), (Standards.NACE2, "93.19")),
        ((Standards.NAF2, "93.2"), (Standards.NACE2, "93.2")),
        ((Standards.NAF2, "93.21"), (Standards.NACE2, "93.21")),
        ((Standards.NAF2, "93.29"), (Standards.NACE2, "93.29")),
        ((Standards.NAF2, "S"), (Standards.NACE2, "S")),
        ((Standards.NAF2, "94"), (Standards.NACE2, "94")),
        ((Standards.NAF2, "94.1"), (Standards.NACE2, "94.1")),
        ((Standards.NAF2, "94.11"), (Standards.NACE2, "94.11")),
        ((Standards.NAF2, "94.12"), (Standards.NACE2, "94.12")),
        ((Standards.NAF2, "94.2"), (Standards.NACE2, "94.2")),
        ((Standards.NAF2, "94.20"), (Standards.NACE2, "94.20")),
        ((Standards.NAF2, "94.9"), (Standards.NACE2, "94.9")),
        ((Standards.NAF2, "94.91"), (Standards.NACE2, "94.91")),
        ((Standards.NAF2, "94.92"), (Standards.NACE2, "94.92")),
        ((Standards.NAF2, "94.99"), (Standards.NACE2, "94.99")),
        ((Standards.NAF2, "95"), (Standards.NACE2, "95")),
        ((Standards.NAF2, "95.1"), (Standards.NACE2, "95.1")),
        ((Standards.NAF2, "95.11"), (Standards.NACE2, "95.11")),
        ((Standards.NAF2, "95.12"), (Standards.NACE2, "95.12")),
        ((Standards.NAF2, "95.2"), (Standards.NACE2, "95.2")),
        ((Standards.NAF2, "95.21"), (Standards.NACE2, "95.21")),
        ((Standards.NAF2, "95.22"), (Standards.NACE2, "95.22")),
        ((Standards.NAF2, "95.23"), (Standards.NACE2, "95.23")),
        ((Standards.NAF2, "95.24"), (Standards.NACE2, "95.24")),
        ((Standards.NAF2, "95.25"), (Standards.NACE2, "95.25")),
        ((Standards.NAF2, "95.29"), (Standards.NACE2, "95.29")),
        ((Standards.NAF2, "96"), (Standards.NACE2, "96")),
        ((Standards.NAF2, "96.0"), (Standards.NACE2, "96.0")),
        ((Standards.NAF2, "96.01"), (Standards.NACE2, "96.01")),
        ((Standards.NAF2, "96.02"), (Standards.NACE2, "96.02")),
        ((Standards.NAF2, "96.03"), (Standards.NACE2, "96.03")),
        ((Standards.NAF2, "96.04"), (Standards.NACE2, "96.04")),
        ((Standards.NAF2, "96.09"), (Standards.NACE2, "96.09")),
        ((Standards.NAF2, "T"), (Standards.NACE2, "T")),
        ((Standards.NAF2, "97"), (Standards.NACE2, "97")),
        ((Standards.NAF2, "97.0"), (Standards.NACE2, "97.0")),
        ((Standards.NAF2, "97.00"), (Standards.NACE2, "97.00")),
        ((Standards.NAF2, "98"), (Standards.NACE2, "98")),
        ((Standards.NAF2, "98.1"), (Standards.NACE2, "98.1")),
        ((Standards.NAF2, "98.10"), (Standards.NACE2, "98.10")),
        ((Standards.NAF2, "98.2"), (Standards.NACE2, "98.2")),
        ((Standards.NAF2, "98.20"), (Standards.NACE2, "98.20")),
        ((Standards.NAF2, "U"), (Standards.NACE2, "U")),
        ((Standards.NAF2, "99"), (Standards.NACE2, "99")),
        ((Standards.NAF2, "99.0"), (Standards.NACE2, "99.0")),
        ((Standards.NAF2, "99.00"), (Standards.NACE2, "99.00")),
    ],
)
