# -*- coding: utf-8 -*-
"""`NAF2 Standard <https://www.insee.fr/fr/information/2120875>`_.
"""
from ...types import Category, Classification, Standard, Standards

NAF2 = Standard(
    standard=Standards.NAF2,
    classes=[
        Classification("A", "AGRICULTURE, SYLVICULTURE ET PÊCHE", Category.SECTION),
        Classification("01", "Culture et production animale, chasse et services annexes", Category.DIVISION),
        Classification("01.1", "Cultures non permanentes", Category.GROUP),
        Classification(
            "01.11",
            "Culture de céréales (à l'exception du riz), de légumineuses et de graines oléagineuses",
            Category.CLASS,
        ),
        Classification(
            "01.11Z",
            "Culture de céréales (à l'exception du riz), de légumineuses et de graines oléagineuses",
            Category.SUBCLASS,
        ),
        Classification("01.12", "Culture du riz", Category.CLASS),
        Classification("01.12Z", "Culture du riz", Category.SUBCLASS),
        Classification("01.13", "Culture de légumes, de melons, de racines et de tubercules", Category.CLASS),
        Classification("01.13Z", "Culture de légumes, de melons, de racines et de tubercules", Category.SUBCLASS),
        Classification("01.14", "Culture de la canne à sucre", Category.CLASS),
        Classification("01.14Z", "Culture de la canne à sucre", Category.SUBCLASS),
        Classification("01.15", "Culture du tabac", Category.CLASS),
        Classification("01.15Z", "Culture du tabac", Category.SUBCLASS),
        Classification("01.16", "Culture de plantes à fibres", Category.CLASS),
        Classification("01.16Z", "Culture de plantes à fibres", Category.SUBCLASS),
        Classification("01.19", "Autres cultures non permanentes", Category.CLASS),
        Classification("01.19Z", "Autres cultures non permanentes", Category.SUBCLASS),
        Classification("01.2", "Cultures permanentes", Category.GROUP),
        Classification("01.21", "Culture de la vigne", Category.CLASS),
        Classification("01.21Z", "Culture de la vigne", Category.SUBCLASS),
        Classification("01.22", "Culture de fruits tropicaux et subtropicaux", Category.CLASS),
        Classification("01.22Z", "Culture de fruits tropicaux et subtropicaux", Category.SUBCLASS),
        Classification("01.23", "Culture d'agrumes", Category.CLASS),
        Classification("01.23Z", "Culture d'agrumes", Category.SUBCLASS),
        Classification("01.24", "Culture de fruits à pépins et à noyau", Category.CLASS),
        Classification("01.24Z", "Culture de fruits à pépins et à noyau", Category.SUBCLASS),
        Classification("01.25", "Culture d'autres fruits d'arbres ou d'arbustes et de fruits à coque", Category.CLASS),
        Classification(
            "01.25Z", "Culture d'autres fruits d'arbres ou d'arbustes et de fruits à coque", Category.SUBCLASS
        ),
        Classification("01.26", "Culture de fruits oléagineux", Category.CLASS),
        Classification("01.26Z", "Culture de fruits oléagineux", Category.SUBCLASS),
        Classification("01.27", "Culture de plantes à boissons", Category.CLASS),
        Classification("01.27Z", "Culture de plantes à boissons", Category.SUBCLASS),
        Classification(
            "01.28", "Culture de plantes à épices, aromatiques, médicinales et pharmaceutiques", Category.CLASS
        ),
        Classification(
            "01.28Z", "Culture de plantes à épices, aromatiques, médicinales et pharmaceutiques", Category.SUBCLASS
        ),
        Classification("01.29", "Autres cultures permanentes", Category.CLASS),
        Classification("01.29Z", "Autres cultures permanentes", Category.SUBCLASS),
        Classification("01.3", "Reproduction de plantes", Category.GROUP),
        Classification("01.30", "Reproduction de plantes", Category.CLASS),
        Classification("01.30Z", "Reproduction de plantes", Category.SUBCLASS),
        Classification("01.4", "Production animale", Category.GROUP),
        Classification("01.41", "Élevage de vaches laitières", Category.CLASS),
        Classification("01.41Z", "Élevage de vaches laitières", Category.SUBCLASS),
        Classification("01.42", "Élevage d'autres bovins et de buffles", Category.CLASS),
        Classification("01.42Z", "Élevage d'autres bovins et de buffles", Category.SUBCLASS),
        Classification("01.43", "Élevage de chevaux et d'autres équidés", Category.CLASS),
        Classification("01.43Z", "Élevage de chevaux et d'autres équidés", Category.SUBCLASS),
        Classification("01.44", "Élevage de chameaux et d'autres camélidés", Category.CLASS),
        Classification("01.44Z", "Élevage de chameaux et d'autres camélidés", Category.SUBCLASS),
        Classification("01.45", "Élevage d'ovins et de caprins", Category.CLASS),
        Classification("01.45Z", "Élevage d'ovins et de caprins", Category.SUBCLASS),
        Classification("01.46", "Élevage de porcins", Category.CLASS),
        Classification("01.46Z", "Élevage de porcins", Category.SUBCLASS),
        Classification("01.47", "Élevage de volailles", Category.CLASS),
        Classification("01.47Z", "Élevage de volailles", Category.SUBCLASS),
        Classification("01.49", "Élevage d'autres animaux", Category.CLASS),
        Classification("01.49Z", "Élevage d'autres animaux", Category.SUBCLASS),
        Classification("01.5", "Culture et élevage associés", Category.GROUP),
        Classification("01.50", "Culture et élevage associés", Category.CLASS),
        Classification("01.50Z", "Culture et élevage associés", Category.SUBCLASS),
        Classification(
            "01.6", "Activités de soutien à l'agriculture et traitement primaire des récoltes", Category.GROUP
        ),
        Classification("01.61", "Activités de soutien aux cultures", Category.CLASS),
        Classification("01.61Z", "Activités de soutien aux cultures", Category.SUBCLASS),
        Classification("01.62", "Activités de soutien à la production animale", Category.CLASS),
        Classification("01.62Z", "Activités de soutien à la production animale", Category.SUBCLASS),
        Classification("01.63", "Traitement primaire des récoltes", Category.CLASS),
        Classification("01.63Z", "Traitement primaire des récoltes", Category.SUBCLASS),
        Classification("01.64", "Traitement des semences", Category.CLASS),
        Classification("01.64Z", "Traitement des semences", Category.SUBCLASS),
        Classification("01.7", "Chasse, piégeage et services annexes", Category.GROUP),
        Classification("01.70", "Chasse, piégeage et services annexes", Category.CLASS),
        Classification("01.70Z", "Chasse, piégeage et services annexes", Category.SUBCLASS),
        Classification("02", "Sylviculture et exploitation forestière", Category.DIVISION),
        Classification("02.1", "Sylviculture et autres activités forestières", Category.GROUP),
        Classification("02.10", "Sylviculture et autres activités forestières", Category.CLASS),
        Classification("02.10Z", "Sylviculture et autres activités forestières", Category.SUBCLASS),
        Classification("02.2", "Exploitation forestière", Category.GROUP),
        Classification("02.20", "Exploitation forestière", Category.CLASS),
        Classification("02.20Z", "Exploitation forestière", Category.SUBCLASS),
        Classification("02.3", "Récolte de produits forestiers non ligneux poussant à l'état sauvage", Category.GROUP),
        Classification("02.30", "Récolte de produits forestiers non ligneux poussant à l'état sauvage", Category.CLASS),
        Classification(
            "02.30Z", "Récolte de produits forestiers non ligneux poussant à l'état sauvage", Category.SUBCLASS
        ),
        Classification("02.4", "Services de soutien à l'exploitation forestière", Category.GROUP),
        Classification("02.40", "Services de soutien à l'exploitation forestière", Category.CLASS),
        Classification("02.40Z", "Services de soutien à l'exploitation forestière", Category.SUBCLASS),
        Classification("03", "Pêche et aquaculture", Category.DIVISION),
        Classification("03.1", "Pêche", Category.GROUP),
        Classification("03.11", "Pêche en mer", Category.CLASS),
        Classification("03.11Z", "Pêche en mer", Category.SUBCLASS),
        Classification("03.12", "Pêche en eau douce", Category.CLASS),
        Classification("03.12Z", "Pêche en eau douce", Category.SUBCLASS),
        Classification("03.2", "Aquaculture", Category.GROUP),
        Classification("03.21", "Aquaculture en mer", Category.CLASS),
        Classification("03.21Z", "Aquaculture en mer", Category.SUBCLASS),
        Classification("03.22", "Aquaculture en eau douce", Category.CLASS),
        Classification("03.22Z", "Aquaculture en eau douce", Category.SUBCLASS),
        Classification("B", "INDUSTRIES EXTRACTIVES", Category.SECTION),
        Classification("05", "Extraction de houille et de lignite", Category.DIVISION),
        Classification("05.1", "Extraction de houille", Category.GROUP),
        Classification("05.10", "Extraction de houille", Category.CLASS),
        Classification("05.10Z", "Extraction de houille", Category.SUBCLASS),
        Classification("05.2", "Extraction de lignite", Category.GROUP),
        Classification("05.20", "Extraction de lignite", Category.CLASS),
        Classification("05.20Z", "Extraction de lignite", Category.SUBCLASS),
        Classification("06", "Extraction d'hydrocarbures", Category.DIVISION),
        Classification("06.1", "Extraction de pétrole brut", Category.GROUP),
        Classification("06.10", "Extraction de pétrole brut", Category.CLASS),
        Classification("06.10Z", "Extraction de pétrole brut", Category.SUBCLASS),
        Classification("06.2", "Extraction de gaz naturel", Category.GROUP),
        Classification("06.20", "Extraction de gaz naturel", Category.CLASS),
        Classification("06.20Z", "Extraction de gaz naturel", Category.SUBCLASS),
        Classification("07", "Extraction de minerais métalliques", Category.DIVISION),
        Classification("07.1", "Extraction de minerais de fer", Category.GROUP),
        Classification("07.10", "Extraction de minerais de fer", Category.CLASS),
        Classification("07.10Z", "Extraction de minerais de fer", Category.SUBCLASS),
        Classification("07.2", "Extraction de minerais de métaux non ferreux", Category.GROUP),
        Classification("07.21", "Extraction de minerais d'uranium et de thorium", Category.CLASS),
        Classification("07.21Z", "Extraction de minerais d'uranium et de thorium", Category.SUBCLASS),
        Classification("07.29", "Extraction d'autres minerais de métaux non ferreux", Category.CLASS),
        Classification("07.29Z", "Extraction d'autres minerais de métaux non ferreux", Category.SUBCLASS),
        Classification("08", "Autres industries extractives", Category.DIVISION),
        Classification("08.1", "Extraction de pierres, de sables et d'argiles", Category.GROUP),
        Classification(
            "08.11",
            "Extraction de pierres ornementales et de construction, de calcaire industriel, de gypse, de craie et d'ardoise",
            Category.CLASS,
        ),
        Classification(
            "08.11Z",
            "Extraction de pierres ornementales et de construction, de calcaire industriel, de gypse, de craie et d'ardoise",
            Category.SUBCLASS,
        ),
        Classification(
            "08.12", "Exploitation de gravières et sablières, extraction d’argiles et de kaolin", Category.CLASS
        ),
        Classification(
            "08.12Z", "Exploitation de gravières et sablières, extraction d’argiles et de kaolin", Category.SUBCLASS
        ),
        Classification("08.9", "Activités extractives n.c.a.", Category.GROUP),
        Classification("08.91", "Extraction des minéraux chimiques et d'engrais minéraux ", Category.CLASS),
        Classification("08.91Z", "Extraction des minéraux chimiques et d'engrais minéraux ", Category.SUBCLASS),
        Classification("08.92", "Extraction de tourbe", Category.CLASS),
        Classification("08.92Z", "Extraction de tourbe", Category.SUBCLASS),
        Classification("08.93", "Production de sel ", Category.CLASS),
        Classification("08.93Z", "Production de sel ", Category.SUBCLASS),
        Classification("08.99", "Autres activités extractives n.c.a.", Category.CLASS),
        Classification("08.99Z", "Autres activités extractives n.c.a.", Category.SUBCLASS),
        Classification("09", "Services de soutien aux industries extractives", Category.DIVISION),
        Classification("09.1", "Activités de soutien à l'extraction d'hydrocarbures", Category.GROUP),
        Classification("09.10", "Activités de soutien à l'extraction d'hydrocarbures", Category.CLASS),
        Classification("09.10Z", "Activités de soutien à l'extraction d'hydrocarbures", Category.SUBCLASS),
        Classification("09.9", "Activités de soutien aux autres industries extractives", Category.GROUP),
        Classification("09.90", "Activités de soutien aux autres industries extractives ", Category.CLASS),
        Classification("09.90Z", "Activités de soutien aux autres industries extractives ", Category.SUBCLASS),
        Classification("C", "INDUSTRIE MANUFACTURIÈRE", Category.SECTION),
        Classification("10", "Industries alimentaires", Category.DIVISION),
        Classification(
            "10.1",
            "Transformation et conservation de la viande et préparation de produits à base de viande",
            Category.GROUP,
        ),
        Classification("10.11", "Transformation et conservation de la viande de boucherie", Category.CLASS),
        Classification("10.11Z", "Transformation et conservation de la viande de boucherie", Category.SUBCLASS),
        Classification("10.12", "Transformation et conservation de la viande de volaille", Category.CLASS),
        Classification("10.12Z", "Transformation et conservation de la viande de volaille", Category.SUBCLASS),
        Classification("10.13", "Préparation de produits à base de viande", Category.CLASS),
        Classification("10.13A", "Préparation industrielle de produits à base de viande", Category.SUBCLASS),
        Classification("10.13B", "Charcuterie", Category.SUBCLASS),
        Classification(
            "10.2", "Transformation et conservation de poisson, de crustacés et de mollusques", Category.GROUP
        ),
        Classification(
            "10.20", "Transformation et conservation de poisson, de crustacés et de mollusques", Category.CLASS
        ),
        Classification(
            "10.20Z", "Transformation et conservation de poisson, de crustacés et de mollusques", Category.SUBCLASS
        ),
        Classification("10.3", "Transformation et conservation de fruits et légumes", Category.GROUP),
        Classification("10.31", "Transformation et conservation de pommes de terre", Category.CLASS),
        Classification("10.31Z", "Transformation et conservation de pommes de terre", Category.SUBCLASS),
        Classification("10.32", "Préparation de jus de fruits et légumes", Category.CLASS),
        Classification("10.32Z", "Préparation de jus de fruits et légumes", Category.SUBCLASS),
        Classification("10.39", "Autre transformation et conservation de fruits et légumes", Category.CLASS),
        Classification("10.39A", "Autre transformation et conservation de légumes", Category.SUBCLASS),
        Classification("10.39B", "Transformation et conservation de fruits", Category.SUBCLASS),
        Classification("10.4", "Fabrication d’huiles et graisses végétales et animales", Category.GROUP),
        Classification("10.41", "Fabrication d'huiles et graisses", Category.CLASS),
        Classification("10.41A", "Fabrication d'huiles et graisses brutes", Category.SUBCLASS),
        Classification("10.41B", "Fabrication d'huiles et graisses raffinées", Category.SUBCLASS),
        Classification("10.42", "Fabrication de margarine et graisses comestibles similaires", Category.CLASS),
        Classification("10.42Z", "Fabrication de margarine et graisses comestibles similaires", Category.SUBCLASS),
        Classification("10.5", "Fabrication de produits laitiers", Category.GROUP),
        Classification("10.51", "Exploitation de laiteries et fabrication de fromage", Category.CLASS),
        Classification("10.51A", "Fabrication de lait liquide et de produits frais", Category.SUBCLASS),
        Classification("10.51B", "Fabrication de beurre", Category.SUBCLASS),
        Classification("10.51C", "Fabrication de fromage", Category.SUBCLASS),
        Classification("10.51D", "Fabrication d'autres produits laitiers", Category.SUBCLASS),
        Classification("10.52", "Fabrication de glaces et sorbets", Category.CLASS),
        Classification("10.52Z", "Fabrication de glaces et sorbets", Category.SUBCLASS),
        Classification("10.6", "Travail des grains ; fabrication de produits amylacés", Category.GROUP),
        Classification("10.61", "Travail des grains", Category.CLASS),
        Classification("10.61A", "Meunerie", Category.SUBCLASS),
        Classification("10.61B", "Autres activités du travail des grains", Category.SUBCLASS),
        Classification("10.62", "Fabrication de produits amylacés", Category.CLASS),
        Classification("10.62Z", "Fabrication de produits amylacés", Category.SUBCLASS),
        Classification(
            "10.7", "Fabrication de produits de boulangerie-pâtisserie et de pâtes alimentaires", Category.GROUP
        ),
        Classification("10.71", "Fabrication de pain et de pâtisserie fraîche", Category.CLASS),
        Classification("10.71A", "Fabrication industrielle de pain et de pâtisserie fraîche", Category.SUBCLASS),
        Classification("10.71B", "Cuisson de produits de boulangerie", Category.SUBCLASS),
        Classification("10.71C", "Boulangerie et boulangerie-pâtisserie", Category.SUBCLASS),
        Classification("10.71D", "Pâtisserie", Category.SUBCLASS),
        Classification("10.72", "Fabrication de biscuits, biscottes et pâtisseries de conservation", Category.CLASS),
        Classification(
            "10.72Z", "Fabrication de biscuits, biscottes et pâtisseries de conservation", Category.SUBCLASS
        ),
        Classification("10.73", "Fabrication de pâtes alimentaires", Category.CLASS),
        Classification("10.73Z", "Fabrication de pâtes alimentaires", Category.SUBCLASS),
        Classification("10.8", "Fabrication d'autres produits alimentaires", Category.GROUP),
        Classification("10.81", "Fabrication de sucre", Category.CLASS),
        Classification("10.81Z", "Fabrication de sucre", Category.SUBCLASS),
        Classification("10.82", "Fabrication de cacao, chocolat et de produits de confiserie", Category.CLASS),
        Classification("10.82Z", "Fabrication de cacao, chocolat et de produits de confiserie", Category.SUBCLASS),
        Classification("10.83", "Transformation du thé et du café", Category.CLASS),
        Classification("10.83Z", "Transformation du thé et du café", Category.SUBCLASS),
        Classification("10.84", "Fabrication de condiments et assaisonnements", Category.CLASS),
        Classification("10.84Z", "Fabrication de condiments et assaisonnements", Category.SUBCLASS),
        Classification("10.85", "Fabrication de plats préparés", Category.CLASS),
        Classification("10.85Z", "Fabrication de plats préparés", Category.SUBCLASS),
        Classification("10.86", "Fabrication d'aliments homogénéisés et diététiques", Category.CLASS),
        Classification("10.86Z", "Fabrication d'aliments homogénéisés et diététiques", Category.SUBCLASS),
        Classification("10.89", "Fabrication d'autres produits alimentaires n.c.a.", Category.CLASS),
        Classification("10.89Z", "Fabrication d'autres produits alimentaires n.c.a.", Category.SUBCLASS),
        Classification("10.9", "Fabrication d'aliments pour animaux", Category.GROUP),
        Classification("10.91", "Fabrication d'aliments pour animaux de ferme", Category.CLASS),
        Classification("10.91Z", "Fabrication d'aliments pour animaux de ferme", Category.SUBCLASS),
        Classification("10.92", "Fabrication d'aliments pour animaux de compagnie", Category.CLASS),
        Classification("10.92Z", "Fabrication d'aliments pour animaux de compagnie", Category.SUBCLASS),
        Classification("11", "Fabrication de boissons", Category.DIVISION),
        Classification("11.0", "Fabrication de boissons", Category.GROUP),
        Classification("11.01", "Production de boissons alcooliques distillées", Category.CLASS),
        Classification("11.01Z", "Production de boissons alcooliques distillées", Category.SUBCLASS),
        Classification("11.02", "Production de vin (de raisin)", Category.CLASS),
        Classification("11.02A", "Fabrication de vins effervescents", Category.SUBCLASS),
        Classification("11.02B", "Vinification", Category.SUBCLASS),
        Classification("11.03", "Fabrication de cidre et de vins de fruits  ", Category.CLASS),
        Classification("11.03Z", "Fabrication de cidre et de vins de fruits ", Category.SUBCLASS),
        Classification("11.04", "Production d'autres boissons fermentées non distillées", Category.CLASS),
        Classification("11.04Z", "Production d'autres boissons fermentées non distillées", Category.SUBCLASS),
        Classification("11.05", "Fabrication de bière", Category.CLASS),
        Classification("11.05Z", "Fabrication de bière", Category.SUBCLASS),
        Classification("11.06", "Fabrication de malt", Category.CLASS),
        Classification("11.06Z", "Fabrication de malt", Category.SUBCLASS),
        Classification(
            "11.07",
            "Industrie des eaux minérales et autres eaux embouteillées et des boissons rafraîchissantes",
            Category.CLASS,
        ),
        Classification("11.07A", "Industrie des eaux de table", Category.SUBCLASS),
        Classification("11.07B", "Production de boissons rafraîchissantes", Category.SUBCLASS),
        Classification("12", "Fabrication de produits à base de tabac", Category.DIVISION),
        Classification("12.0", "Fabrication de produits à base de tabac", Category.GROUP),
        Classification("12.00", "Fabrication de produits à base de tabac", Category.CLASS),
        Classification("12.00Z", "Fabrication de produits à base de tabac", Category.SUBCLASS),
        Classification("13", "Fabrication de textiles", Category.DIVISION),
        Classification("13.1", "Préparation de fibres textiles et filature", Category.GROUP),
        Classification("13.10", "Préparation de fibres textiles et filature", Category.CLASS),
        Classification("13.10Z", "Préparation de fibres textiles et filature", Category.SUBCLASS),
        Classification("13.2", "Tissage", Category.GROUP),
        Classification("13.20", "Tissage", Category.CLASS),
        Classification("13.20Z", "Tissage", Category.SUBCLASS),
        Classification("13.3", "Ennoblissement textile", Category.GROUP),
        Classification("13.30", "Ennoblissement textile", Category.CLASS),
        Classification("13.30Z", "Ennoblissement textile", Category.SUBCLASS),
        Classification("13.9", "Fabrication d'autres textiles", Category.GROUP),
        Classification("13.91", "Fabrication d'étoffes à mailles", Category.CLASS),
        Classification("13.91Z", "Fabrication d'étoffes à mailles", Category.SUBCLASS),
        Classification("13.92", "Fabrication d'articles textiles, sauf habillement", Category.CLASS),
        Classification("13.92Z", "Fabrication d'articles textiles, sauf habillement", Category.SUBCLASS),
        Classification("13.93", "Fabrication de tapis et moquettes", Category.CLASS),
        Classification("13.93Z", "Fabrication de tapis et moquettes", Category.SUBCLASS),
        Classification("13.94", "Fabrication de ficelles, cordes et filets", Category.CLASS),
        Classification("13.94Z", "Fabrication de ficelles, cordes et filets", Category.SUBCLASS),
        Classification("13.95", "Fabrication de non-tissés, sauf habillement", Category.CLASS),
        Classification("13.95Z", "Fabrication de non-tissés, sauf habillement", Category.SUBCLASS),
        Classification("13.96", "Fabrication d'autres textiles techniques et industriels", Category.CLASS),
        Classification("13.96Z", "Fabrication d'autres textiles techniques et industriels", Category.SUBCLASS),
        Classification("13.99", "Fabrication d'autres textiles n.c.a.", Category.CLASS),
        Classification("13.99Z", "Fabrication d'autres textiles n.c.a.", Category.SUBCLASS),
        Classification("14", "Industrie de l'habillement", Category.DIVISION),
        Classification("14.1", "Fabrication de vêtements, autres qu'en fourrure", Category.GROUP),
        Classification("14.11", "Fabrication de vêtements en cuir", Category.CLASS),
        Classification("14.11Z", "Fabrication de vêtements en cuir", Category.SUBCLASS),
        Classification("14.12", "Fabrication de vêtements de travail", Category.CLASS),
        Classification("14.12Z", "Fabrication de vêtements de travail", Category.SUBCLASS),
        Classification("14.13", "Fabrication de vêtements de dessus", Category.CLASS),
        Classification("14.13Z", "Fabrication de vêtements de dessus", Category.SUBCLASS),
        Classification("14.14", "Fabrication de vêtements de dessous", Category.CLASS),
        Classification("14.14Z", "Fabrication de vêtements de dessous", Category.SUBCLASS),
        Classification("14.19", "Fabrication d'autres vêtements et accessoires", Category.CLASS),
        Classification("14.19Z", "Fabrication d'autres vêtements et accessoires", Category.SUBCLASS),
        Classification("14.2", "Fabrication d'articles en fourrure", Category.GROUP),
        Classification("14.20", "Fabrication d'articles en fourrure", Category.CLASS),
        Classification("14.20Z", "Fabrication d'articles en fourrure", Category.SUBCLASS),
        Classification("14.3", "Fabrication d'articles à mailles", Category.GROUP),
        Classification("14.31", "Fabrication d'articles chaussants à mailles", Category.CLASS),
        Classification("14.31Z", "Fabrication d'articles chaussants à mailles", Category.SUBCLASS),
        Classification("14.39", "Fabrication d'autres articles à mailles", Category.CLASS),
        Classification("14.39Z", "Fabrication d'autres articles à mailles", Category.SUBCLASS),
        Classification("15", "Industrie du cuir et de la chaussure", Category.DIVISION),
        Classification(
            "15.1",
            "Apprêt et tannage des cuirs ; préparation et teinture des fourrures ; fabrication d'articles de voyage, de maroquinerie et de sellerie",
            Category.GROUP,
        ),
        Classification("15.11", "Apprêt et tannage des cuirs ; préparation et teinture des fourrures", Category.CLASS),
        Classification(
            "15.11Z", "Apprêt et tannage des cuirs ; préparation et teinture des fourrures", Category.SUBCLASS
        ),
        Classification("15.12", "Fabrication d'articles de voyage, de maroquinerie et de sellerie", Category.CLASS),
        Classification("15.12Z", "Fabrication d'articles de voyage, de maroquinerie et de sellerie", Category.SUBCLASS),
        Classification("15.2", "Fabrication de chaussures", Category.GROUP),
        Classification("15.20", "Fabrication de chaussures", Category.CLASS),
        Classification("15.20Z", "Fabrication de chaussures", Category.SUBCLASS),
        Classification(
            "16",
            "Travail du bois et fabrication d'articles en bois et en liège, à l’exception des meubles ; fabrication d’articles en vannerie et sparterie",
            Category.DIVISION,
        ),
        Classification("16.1", "Sciage et rabotage du bois", Category.GROUP),
        Classification("16.10", "Sciage et rabotage du bois", Category.CLASS),
        Classification("16.10A", "Sciage et rabotage du bois, hors imprégnation", Category.SUBCLASS),
        Classification("16.10B", "Imprégnation du bois", Category.SUBCLASS),
        Classification("16.2", "Fabrication d'articles en bois, liège, vannerie et sparterie", Category.GROUP),
        Classification("16.21", "Fabrication de placage et de panneaux de bois", Category.CLASS),
        Classification("16.21Z", "Fabrication de placage et de panneaux de bois", Category.SUBCLASS),
        Classification("16.22", "Fabrication de parquets assemblés", Category.CLASS),
        Classification("16.22Z", "Fabrication de parquets assemblés", Category.SUBCLASS),
        Classification("16.23", "Fabrication de charpentes et d'autres menuiseries", Category.CLASS),
        Classification("16.23Z", "Fabrication de charpentes et d'autres menuiseries", Category.SUBCLASS),
        Classification("16.24", "Fabrication d'emballages en bois", Category.CLASS),
        Classification("16.24Z", "Fabrication d'emballages en bois", Category.SUBCLASS),
        Classification(
            "16.29",
            "Fabrication d'objets divers en bois ; fabrication d'objets en liège, vannerie et sparterie",
            Category.CLASS,
        ),
        Classification(
            "16.29Z",
            "Fabrication d'objets divers en bois ; fabrication d'objets en liège, vannerie et sparterie",
            Category.SUBCLASS,
        ),
        Classification("17", "Industrie du papier et du carton", Category.DIVISION),
        Classification("17.1", "Fabrication de pâte à papier, de papier et de carton", Category.GROUP),
        Classification("17.11", "Fabrication de pâte à papier", Category.CLASS),
        Classification("17.11Z", "Fabrication de pâte à papier", Category.SUBCLASS),
        Classification("17.12", "Fabrication de papier et de carton", Category.CLASS),
        Classification("17.12Z", "Fabrication de papier et de carton", Category.SUBCLASS),
        Classification("17.2", "Fabrication d'articles en papier ou en carton", Category.GROUP),
        Classification(
            "17.21", "Fabrication de papier et carton ondulés et d'emballages en papier ou en carton", Category.CLASS
        ),
        Classification("17.21A", "Fabrication de carton ondulé", Category.SUBCLASS),
        Classification("17.21B", "Fabrication de cartonnages ", Category.SUBCLASS),
        Classification("17.21C", "Fabrication d'emballages en papier", Category.SUBCLASS),
        Classification("17.22", "Fabrication d'articles en papier à usage sanitaire ou domestique", Category.CLASS),
        Classification("17.22Z", "Fabrication d'articles en papier à usage sanitaire ou domestique", Category.SUBCLASS),
        Classification("17.23", "Fabrication d'articles de papeterie", Category.CLASS),
        Classification("17.23Z", "Fabrication d'articles de papeterie", Category.SUBCLASS),
        Classification("17.24", "Fabrication de papiers peints", Category.CLASS),
        Classification("17.24Z", "Fabrication de papiers peints", Category.SUBCLASS),
        Classification("17.29", "Fabrication d'autres articles en papier ou en carton", Category.CLASS),
        Classification("17.29Z", "Fabrication d'autres articles en papier ou en carton", Category.SUBCLASS),
        Classification("18", "Imprimerie et reproduction d'enregistrements", Category.DIVISION),
        Classification("18.1", "Imprimerie et services annexes", Category.GROUP),
        Classification("18.11", "Imprimerie de journaux", Category.CLASS),
        Classification("18.11Z", "Imprimerie de journaux", Category.SUBCLASS),
        Classification("18.12", "Autre imprimerie (labeur)", Category.CLASS),
        Classification("18.12Z", "Autre imprimerie (labeur)", Category.SUBCLASS),
        Classification("18.13", "Activités de pré-presse ", Category.CLASS),
        Classification("18.13Z", "Activités de pré-presse ", Category.SUBCLASS),
        Classification("18.14", "Reliure et activités connexes", Category.CLASS),
        Classification("18.14Z", "Reliure et activités connexes", Category.SUBCLASS),
        Classification("18.2", "Reproduction d'enregistrements", Category.GROUP),
        Classification("18.20", "Reproduction d'enregistrements", Category.CLASS),
        Classification("18.20Z", "Reproduction d'enregistrements", Category.SUBCLASS),
        Classification("19", "Cokéfaction et raffinage", Category.DIVISION),
        Classification("19.1", "Cokéfaction", Category.GROUP),
        Classification("19.10", "Cokéfaction", Category.CLASS),
        Classification("19.10Z", "Cokéfaction", Category.SUBCLASS),
        Classification("19.2", "Raffinage du pétrole", Category.GROUP),
        Classification("19.20", "Raffinage du pétrole", Category.CLASS),
        Classification("19.20Z", "Raffinage du pétrole", Category.SUBCLASS),
        Classification("20", "Industrie chimique", Category.DIVISION),
        Classification(
            "20.1",
            "Fabrication de produits chimiques de base, de produits azotés et d'engrais, de matières plastiques de base et de caoutchouc synthétique",
            Category.GROUP,
        ),
        Classification("20.11", "Fabrication de gaz industriels", Category.CLASS),
        Classification("20.11Z", "Fabrication de gaz industriels", Category.SUBCLASS),
        Classification("20.12", "Fabrication de colorants et de pigments", Category.CLASS),
        Classification("20.12Z", "Fabrication de colorants et de pigments", Category.SUBCLASS),
        Classification("20.13", "Fabrication d'autres produits chimiques inorganiques de base", Category.CLASS),
        Classification("20.13A", "Enrichissement et  retraitement de matières nucléaires", Category.SUBCLASS),
        Classification(
            "20.13B", "Fabrication d'autres produits chimiques inorganiques de base n.c.a.", Category.SUBCLASS
        ),
        Classification("20.14", "Fabrication d'autres produits chimiques organiques de base", Category.CLASS),
        Classification("20.14Z", "Fabrication d'autres produits chimiques organiques de base", Category.SUBCLASS),
        Classification("20.15", "Fabrication de produits azotés et d'engrais", Category.CLASS),
        Classification("20.15Z", "Fabrication de produits azotés et d'engrais", Category.SUBCLASS),
        Classification("20.16", "Fabrication de matières plastiques de base", Category.CLASS),
        Classification("20.16Z", "Fabrication de matières plastiques de base", Category.SUBCLASS),
        Classification("20.17", "Fabrication de caoutchouc synthétique", Category.CLASS),
        Classification("20.17Z", "Fabrication de caoutchouc synthétique", Category.SUBCLASS),
        Classification("20.2", "Fabrication de pesticides et d’autres produits agrochimiques ", Category.GROUP),
        Classification("20.20", "Fabrication de pesticides et d’autres produits agrochimiques", Category.CLASS),
        Classification("20.20Z", "Fabrication de pesticides et d’autres produits agrochimiques", Category.SUBCLASS),
        Classification("20.3", "Fabrication de peintures, vernis, encres et mastics", Category.GROUP),
        Classification("20.30", "Fabrication de peintures, vernis, encres et mastics", Category.CLASS),
        Classification("20.30Z", "Fabrication de peintures, vernis, encres et mastics", Category.SUBCLASS),
        Classification("20.4", "Fabrication de savons, de produits d'entretien et de parfums", Category.GROUP),
        Classification("20.41", "Fabrication de savons, détergents et produits d'entretien", Category.CLASS),
        Classification("20.41Z", "Fabrication de savons, détergents et produits d'entretien", Category.SUBCLASS),
        Classification("20.42", "Fabrication de parfums et de produits pour la toilette", Category.CLASS),
        Classification("20.42Z", "Fabrication de parfums et de produits pour la toilette", Category.SUBCLASS),
        Classification("20.5", "Fabrication d'autres produits chimiques", Category.GROUP),
        Classification("20.51", "Fabrication de produits explosifs", Category.CLASS),
        Classification("20.51Z", "Fabrication de produits explosifs", Category.SUBCLASS),
        Classification("20.52", "Fabrication de colles", Category.CLASS),
        Classification("20.52Z", "Fabrication de colles", Category.SUBCLASS),
        Classification("20.53", "Fabrication d'huiles essentielles", Category.CLASS),
        Classification("20.53Z", "Fabrication d'huiles essentielles", Category.SUBCLASS),
        Classification("20.59", "Fabrication d'autres produits chimiques n.c.a.", Category.CLASS),
        Classification("20.59Z", "Fabrication d'autres produits chimiques n.c.a.", Category.SUBCLASS),
        Classification("20.6", "Fabrication de fibres artificielles ou synthétiques", Category.GROUP),
        Classification("20.60", "Fabrication de fibres artificielles ou synthétiques", Category.CLASS),
        Classification("20.60Z", "Fabrication de fibres artificielles ou synthétiques", Category.SUBCLASS),
        Classification("21", "Industrie pharmaceutique", Category.DIVISION),
        Classification("21.1", "Fabrication de produits pharmaceutiques de base", Category.GROUP),
        Classification("21.10", "Fabrication de produits pharmaceutiques de base", Category.CLASS),
        Classification("21.10Z", "Fabrication de produits pharmaceutiques de base", Category.SUBCLASS),
        Classification("21.2", "Fabrication de préparations pharmaceutiques", Category.GROUP),
        Classification("21.20", "Fabrication de préparations pharmaceutiques", Category.CLASS),
        Classification("21.20Z", "Fabrication de préparations pharmaceutiques", Category.SUBCLASS),
        Classification("22", "Fabrication de produits en caoutchouc et en plastique", Category.DIVISION),
        Classification("22.1", "Fabrication de produits en caoutchouc", Category.GROUP),
        Classification("22.11", "Fabrication et rechapage de pneumatiques", Category.CLASS),
        Classification("22.11Z", "Fabrication et rechapage de pneumatiques", Category.SUBCLASS),
        Classification("22.19", "Fabrication d'autres articles en caoutchouc", Category.CLASS),
        Classification("22.19Z", "Fabrication d'autres articles en caoutchouc", Category.SUBCLASS),
        Classification("22.2", "Fabrication  de produits en plastique", Category.GROUP),
        Classification(
            "22.21", "Fabrication de plaques, feuilles, tubes et profilés en matières plastiques", Category.CLASS
        ),
        Classification(
            "22.21Z", "Fabrication de plaques, feuilles, tubes et profilés en matières plastiques", Category.SUBCLASS
        ),
        Classification("22.22", "Fabrication d'emballages en matières plastiques", Category.CLASS),
        Classification("22.22Z", "Fabrication d'emballages en matières plastiques", Category.SUBCLASS),
        Classification("22.23", "Fabrication d'éléments en matières plastiques pour la construction", Category.CLASS),
        Classification(
            "22.23Z", "Fabrication d'éléments en matières plastiques pour la construction", Category.SUBCLASS
        ),
        Classification("22.29", "Fabrication d'autres articles en matières plastiques", Category.CLASS),
        Classification("22.29A", "Fabrication de pièces techniques à base de matières plastiques", Category.SUBCLASS),
        Classification(
            "22.29B", "Fabrication de produits de consommation courante en matières plastiques", Category.SUBCLASS
        ),
        Classification("23", "Fabrication d'autres produits minéraux non métalliques", Category.DIVISION),
        Classification("23.1", "Fabrication de verre et d'articles en verre", Category.GROUP),
        Classification("23.11", "Fabrication de verre plat", Category.CLASS),
        Classification("23.11Z", "Fabrication de verre plat", Category.SUBCLASS),
        Classification("23.12", "Façonnage et transformation du verre plat", Category.CLASS),
        Classification("23.12Z", "Façonnage et transformation du verre plat", Category.SUBCLASS),
        Classification("23.13", "Fabrication de verre creux", Category.CLASS),
        Classification("23.13Z", "Fabrication de verre creux", Category.SUBCLASS),
        Classification("23.14", "Fabrication de fibres de verre", Category.CLASS),
        Classification("23.14Z", "Fabrication de fibres de verre", Category.SUBCLASS),
        Classification(
            "23.19", "Fabrication et façonnage d'autres articles en verre, y compris verre technique", Category.CLASS
        ),
        Classification(
            "23.19Z",
            "Fabrication et façonnage d'autres articles en verre, y compris verre technique",
            Category.SUBCLASS,
        ),
        Classification("23.2", "Fabrication de produits réfractaires", Category.GROUP),
        Classification("23.20", "Fabrication de produits réfractaires", Category.CLASS),
        Classification("23.20Z", "Fabrication de produits réfractaires", Category.SUBCLASS),
        Classification("23.3", "Fabrication de matériaux de construction en terre cuite", Category.GROUP),
        Classification("23.31", "Fabrication de carreaux en céramique", Category.CLASS),
        Classification("23.31Z", "Fabrication de carreaux en céramique", Category.SUBCLASS),
        Classification(
            "23.32", "Fabrication de briques, tuiles et produits de construction, en terre cuite", Category.CLASS
        ),
        Classification(
            "23.32Z", "Fabrication de briques, tuiles et produits de construction, en terre cuite", Category.SUBCLASS
        ),
        Classification("23.4", "Fabrication d'autres produits en céramique et en porcelaine ", Category.GROUP),
        Classification("23.41", "Fabrication d'articles céramiques à usage domestique ou ornemental", Category.CLASS),
        Classification(
            "23.41Z", "Fabrication d'articles céramiques à usage domestique ou ornemental", Category.SUBCLASS
        ),
        Classification("23.42", "Fabrication d'appareils sanitaires en céramique", Category.CLASS),
        Classification("23.42Z", "Fabrication d'appareils sanitaires en céramique", Category.SUBCLASS),
        Classification("23.43", "Fabrication d'isolateurs et pièces isolantes en céramique", Category.CLASS),
        Classification("23.43Z", "Fabrication d'isolateurs et pièces isolantes en céramique", Category.SUBCLASS),
        Classification("23.44", "Fabrication d'autres produits céramiques à usage technique", Category.CLASS),
        Classification("23.44Z", "Fabrication d'autres produits céramiques à usage technique", Category.SUBCLASS),
        Classification("23.49", "Fabrication d'autres produits céramiques ", Category.CLASS),
        Classification("23.49Z", "Fabrication d'autres produits céramiques", Category.SUBCLASS),
        Classification("23.5", "Fabrication de ciment, chaux et plâtre", Category.GROUP),
        Classification("23.51", "Fabrication de ciment", Category.CLASS),
        Classification("23.51Z", "Fabrication de ciment", Category.SUBCLASS),
        Classification("23.52", "Fabrication de chaux et plâtre", Category.CLASS),
        Classification("23.52Z", "Fabrication de chaux et plâtre", Category.SUBCLASS),
        Classification("23.6", "Fabrication d'ouvrages en béton, en ciment ou en plâtre", Category.GROUP),
        Classification("23.61", "Fabrication d'éléments en béton pour la construction", Category.CLASS),
        Classification("23.61Z", "Fabrication d'éléments en béton pour la construction", Category.SUBCLASS),
        Classification("23.62", "Fabrication d'éléments en plâtre pour la construction", Category.CLASS),
        Classification("23.62Z", "Fabrication d'éléments en plâtre pour la construction", Category.SUBCLASS),
        Classification("23.63", "Fabrication de béton prêt à l'emploi", Category.CLASS),
        Classification("23.63Z", "Fabrication de béton prêt à l'emploi", Category.SUBCLASS),
        Classification("23.64", "Fabrication de mortiers et bétons secs", Category.CLASS),
        Classification("23.64Z", "Fabrication de mortiers et bétons secs", Category.SUBCLASS),
        Classification("23.65", "Fabrication d'ouvrages en fibre-ciment", Category.CLASS),
        Classification("23.65Z", "Fabrication d'ouvrages en fibre-ciment", Category.SUBCLASS),
        Classification("23.69", "Fabrication d'autres ouvrages en béton, en ciment ou en plâtre", Category.CLASS),
        Classification("23.69Z", "Fabrication d'autres ouvrages en béton, en ciment ou en plâtre", Category.SUBCLASS),
        Classification("23.7", "Taille, façonnage et finissage de pierres ", Category.GROUP),
        Classification("23.70", "Taille, façonnage et finissage de pierres", Category.CLASS),
        Classification("23.70Z", "Taille, façonnage et finissage de pierres", Category.SUBCLASS),
        Classification(
            "23.9", "Fabrication de produits abrasifs et de produits minéraux non métalliques n.c.a.", Category.GROUP
        ),
        Classification("23.91", "Fabrication de produits abrasifs", Category.CLASS),
        Classification("23.91Z", "Fabrication de produits abrasifs", Category.SUBCLASS),
        Classification("23.99", "Fabrication d'autres produits minéraux non métalliques n.c.a.", Category.CLASS),
        Classification("23.99Z", "Fabrication d'autres produits minéraux non métalliques n.c.a.", Category.SUBCLASS),
        Classification("24", "Métallurgie", Category.DIVISION),
        Classification("24.1", "Sidérurgie", Category.GROUP),
        Classification("24.10", "Sidérurgie", Category.CLASS),
        Classification("24.10Z", "Sidérurgie", Category.SUBCLASS),
        Classification(
            "24.2",
            "Fabrication de tubes, tuyaux, profilés creux et accessoires correspondants en acier ",
            Category.GROUP,
        ),
        Classification(
            "24.20",
            "Fabrication de tubes, tuyaux, profilés creux et accessoires correspondants en acier ",
            Category.CLASS,
        ),
        Classification(
            "24.20Z",
            "Fabrication de tubes, tuyaux, profilés creux et accessoires correspondants en acier ",
            Category.SUBCLASS,
        ),
        Classification("24.3", "Fabrication d'autres produits de première transformation de l'acier", Category.GROUP),
        Classification("24.31", "Étirage à froid de barres", Category.CLASS),
        Classification("24.31Z", "Étirage à froid de barres", Category.SUBCLASS),
        Classification("24.32", "Laminage à froid de feuillards", Category.CLASS),
        Classification("24.32Z", "Laminage à froid de feuillards", Category.SUBCLASS),
        Classification("24.33", "Profilage à froid par formage ou pliage", Category.CLASS),
        Classification("24.33Z", "Profilage à froid par formage ou pliage", Category.SUBCLASS),
        Classification("24.34", "Tréfilage à froid", Category.CLASS),
        Classification("24.34Z", "Tréfilage à froid", Category.SUBCLASS),
        Classification("24.4", "Production de métaux précieux et d'autres métaux non ferreux", Category.GROUP),
        Classification("24.41", "Production de métaux précieux", Category.CLASS),
        Classification("24.41Z", "Production de métaux précieux", Category.SUBCLASS),
        Classification("24.42", "Métallurgie de l'aluminium", Category.CLASS),
        Classification("24.42Z", "Métallurgie de l'aluminium", Category.SUBCLASS),
        Classification("24.43", "Métallurgie du plomb, du zinc ou de l'étain", Category.CLASS),
        Classification("24.43Z", "Métallurgie du plomb, du zinc ou de l'étain", Category.SUBCLASS),
        Classification("24.44", "Métallurgie du cuivre", Category.CLASS),
        Classification("24.44Z", "Métallurgie du cuivre", Category.SUBCLASS),
        Classification("24.45", "Métallurgie des autres métaux non ferreux", Category.CLASS),
        Classification("24.45Z", "Métallurgie des autres métaux non ferreux", Category.SUBCLASS),
        Classification("24.46", "Élaboration et transformation de matières nucléaires", Category.CLASS),
        Classification("24.46Z", "Élaboration et transformation de matières nucléaires", Category.SUBCLASS),
        Classification("24.5", "Fonderie", Category.GROUP),
        Classification("24.51", "Fonderie de fonte", Category.CLASS),
        Classification("24.51Z", "Fonderie de fonte", Category.SUBCLASS),
        Classification("24.52", "Fonderie d'acier", Category.CLASS),
        Classification("24.52Z", "Fonderie d'acier", Category.SUBCLASS),
        Classification("24.53", "Fonderie de métaux légers", Category.CLASS),
        Classification("24.53Z", "Fonderie de métaux légers", Category.SUBCLASS),
        Classification("24.54", "Fonderie d'autres métaux non ferreux", Category.CLASS),
        Classification("24.54Z", "Fonderie d'autres métaux non ferreux", Category.SUBCLASS),
        Classification(
            "25",
            "Fabrication de produits métalliques, à l’exception des machines et des équipements",
            Category.DIVISION,
        ),
        Classification("25.1", "Fabrication d'éléments en métal pour la construction", Category.GROUP),
        Classification("25.11", "Fabrication de structures métalliques et de parties de structures", Category.CLASS),
        Classification(
            "25.11Z", "Fabrication de structures métalliques et de parties de structures", Category.SUBCLASS
        ),
        Classification("25.12", "Fabrication de portes et fenêtres en métal", Category.CLASS),
        Classification("25.12Z", "Fabrication de portes et fenêtres en métal", Category.SUBCLASS),
        Classification("25.2", "Fabrication de réservoirs, citernes et conteneurs métalliques", Category.GROUP),
        Classification("25.21", "Fabrication de radiateurs et de chaudières pour le chauffage central", Category.CLASS),
        Classification(
            "25.21Z", "Fabrication de radiateurs et de chaudières pour le chauffage central", Category.SUBCLASS
        ),
        Classification("25.29", "Fabrication d'autres réservoirs, citernes et conteneurs métalliques", Category.CLASS),
        Classification(
            "25.29Z", "Fabrication d'autres réservoirs, citernes et conteneurs métalliques", Category.SUBCLASS
        ),
        Classification(
            "25.3",
            "Fabrication de générateurs de vapeur, à l'exception des chaudières pour le chauffage central",
            Category.GROUP,
        ),
        Classification(
            "25.30",
            "Fabrication de générateurs de vapeur, à l'exception des chaudières pour le chauffage central",
            Category.CLASS,
        ),
        Classification(
            "25.30Z",
            "Fabrication de générateurs de vapeur, à l'exception des chaudières pour le chauffage central",
            Category.SUBCLASS,
        ),
        Classification("25.4", "Fabrication d'armes et de munitions", Category.GROUP),
        Classification("25.40", "Fabrication d'armes et de munitions", Category.CLASS),
        Classification("25.40Z", "Fabrication d'armes et de munitions", Category.SUBCLASS),
        Classification("25.5", "Forge, emboutissage, estampage ; métallurgie des poudres", Category.GROUP),
        Classification("25.50", "Forge, emboutissage, estampage ; métallurgie des poudres", Category.CLASS),
        Classification("25.50A", "Forge, estampage, matriçage ; métallurgie des poudres", Category.SUBCLASS),
        Classification("25.50B", "Découpage, emboutissage", Category.SUBCLASS),
        Classification("25.6", "Traitement et revêtement des métaux ; usinage", Category.GROUP),
        Classification("25.61", "Traitement et revêtement des métaux", Category.CLASS),
        Classification("25.61Z", "Traitement et revêtement des métaux", Category.SUBCLASS),
        Classification("25.62", "Usinage", Category.CLASS),
        Classification("25.62A", "Décolletage", Category.SUBCLASS),
        Classification("25.62B", "Mécanique industrielle", Category.SUBCLASS),
        Classification("25.7", "Fabrication de coutellerie, d'outillage et de quincaillerie", Category.GROUP),
        Classification("25.71", "Fabrication de coutellerie", Category.CLASS),
        Classification("25.71Z", "Fabrication de coutellerie", Category.SUBCLASS),
        Classification("25.72", "Fabrication de serrures et de ferrures", Category.CLASS),
        Classification("25.72Z", "Fabrication de serrures et de ferrures", Category.SUBCLASS),
        Classification("25.73", "Fabrication d'outillage", Category.CLASS),
        Classification("25.73A", "Fabrication de moules et modèles", Category.SUBCLASS),
        Classification("25.73B", "Fabrication d'autres outillages", Category.SUBCLASS),
        Classification("25.9", "Fabrication d'autres ouvrages en métaux", Category.GROUP),
        Classification("25.91", "Fabrication de fûts et emballages métalliques similaires", Category.CLASS),
        Classification("25.91Z", "Fabrication de fûts et emballages métalliques similaires", Category.SUBCLASS),
        Classification("25.92", "Fabrication d'emballages métalliques légers", Category.CLASS),
        Classification("25.92Z", "Fabrication d'emballages métalliques légers", Category.SUBCLASS),
        Classification(
            "25.93", "Fabrication d'articles en fils métalliques, de chaînes et de ressorts", Category.CLASS
        ),
        Classification(
            "25.93Z", "Fabrication d'articles en fils métalliques, de chaînes et de ressorts", Category.SUBCLASS
        ),
        Classification("25.94", "Fabrication de vis et de boulons", Category.CLASS),
        Classification("25.94Z", "Fabrication de vis et de boulons", Category.SUBCLASS),
        Classification("25.99", "Fabrication d'autres produits métalliques n.c.a.", Category.CLASS),
        Classification("25.99A", "Fabrication d'articles métalliques ménagers", Category.SUBCLASS),
        Classification("25.99B", "Fabrication d'autres articles métalliques", Category.SUBCLASS),
        Classification("26", "Fabrication de produits informatiques, électroniques et optiques", Category.DIVISION),
        Classification("26.1", "Fabrication de composants et cartes électroniques", Category.GROUP),
        Classification("26.11", "Fabrication de composants électroniques", Category.CLASS),
        Classification("26.11Z", "Fabrication de composants électroniques", Category.SUBCLASS),
        Classification("26.12", "Fabrication de cartes électroniques assemblées", Category.CLASS),
        Classification("26.12Z", "Fabrication de cartes électroniques assemblées", Category.SUBCLASS),
        Classification("26.2", "Fabrication d'ordinateurs et d'équipements périphériques", Category.GROUP),
        Classification("26.20", "Fabrication d'ordinateurs et d'équipements périphériques", Category.CLASS),
        Classification("26.20Z", "Fabrication d'ordinateurs et d'équipements périphériques", Category.SUBCLASS),
        Classification("26.3", "Fabrication d'équipements de communication", Category.GROUP),
        Classification("26.30", "Fabrication d'équipements de communication ", Category.CLASS),
        Classification("26.30Z", "Fabrication d'équipements de communication ", Category.SUBCLASS),
        Classification("26.4", "Fabrication de produits électroniques grand public", Category.GROUP),
        Classification("26.40", "Fabrication de produits électroniques grand public", Category.CLASS),
        Classification("26.40Z", "Fabrication de produits électroniques grand public", Category.SUBCLASS),
        Classification(
            "26.5",
            "Fabrication d'instruments et d'appareils de mesure, d'essai et de navigation ; horlogerie",
            Category.GROUP,
        ),
        Classification(
            "26.51", "Fabrication d'instruments et d'appareils de mesure, d'essai et de navigation", Category.CLASS
        ),
        Classification("26.51A", "Fabrication d'équipements d'aide à la navigation", Category.SUBCLASS),
        Classification("26.51B", "Fabrication d'instrumentation scientifique et technique", Category.SUBCLASS),
        Classification("26.52", "Horlogerie", Category.CLASS),
        Classification("26.52Z", "Horlogerie", Category.SUBCLASS),
        Classification(
            "26.6",
            "Fabrication d'équipements d'irradiation médicale, d'équipements électromédicaux et électrothérapeutiques",
            Category.GROUP,
        ),
        Classification(
            "26.60",
            "Fabrication d'équipements d'irradiation médicale, d'équipements électromédicaux et électrothérapeutiques ",
            Category.CLASS,
        ),
        Classification(
            "26.60Z",
            "Fabrication d'équipements d'irradiation médicale, d'équipements électromédicaux et électrothérapeutiques ",
            Category.SUBCLASS,
        ),
        Classification("26.7", "Fabrication de matériels optique et photographique", Category.GROUP),
        Classification("26.70", "Fabrication de matériels optique et photographique", Category.CLASS),
        Classification("26.70Z", "Fabrication de matériels optique et photographique", Category.SUBCLASS),
        Classification("26.8", "Fabrication de supports magnétiques et optiques", Category.GROUP),
        Classification("26.80", "Fabrication de supports magnétiques et optiques", Category.CLASS),
        Classification("26.80Z", "Fabrication de supports magnétiques et optiques", Category.SUBCLASS),
        Classification("27", "Fabrication d'équipements électriques", Category.DIVISION),
        Classification(
            "27.1",
            "Fabrication de moteurs, génératrices et transformateurs électriques et de matériel de distribution et de commande électrique",
            Category.GROUP,
        ),
        Classification("27.11", "Fabrication de moteurs, génératrices et transformateurs électriques", Category.CLASS),
        Classification(
            "27.11Z", "Fabrication de moteurs, génératrices et transformateurs électriques", Category.SUBCLASS
        ),
        Classification("27.12", "Fabrication de matériel de distribution et de commande électrique", Category.CLASS),
        Classification(
            "27.12Z", "Fabrication de matériel de distribution et de commande électrique", Category.SUBCLASS
        ),
        Classification("27.2", "Fabrication de piles et d'accumulateurs électriques", Category.GROUP),
        Classification("27.20", "Fabrication de piles et d'accumulateurs électriques", Category.CLASS),
        Classification("27.20Z", "Fabrication de piles et d'accumulateurs électriques", Category.SUBCLASS),
        Classification(
            "27.3", "Fabrication de fils et câbles et de matériel d'installation électrique", Category.GROUP
        ),
        Classification("27.31", "Fabrication de câbles de fibres optiques", Category.CLASS),
        Classification("27.31Z", "Fabrication de câbles de fibres optiques", Category.SUBCLASS),
        Classification("27.32", "Fabrication d'autres fils et câbles électroniques ou électriques", Category.CLASS),
        Classification("27.32Z", "Fabrication d'autres fils et câbles électroniques ou électriques", Category.SUBCLASS),
        Classification("27.33", "Fabrication de matériel d'installation électrique", Category.CLASS),
        Classification("27.33Z", "Fabrication de matériel d'installation électrique", Category.SUBCLASS),
        Classification("27.4", "Fabrication d'appareils d'éclairage électrique", Category.GROUP),
        Classification("27.40", "Fabrication d'appareils d'éclairage électrique", Category.CLASS),
        Classification("27.40Z", "Fabrication d'appareils d'éclairage électrique", Category.SUBCLASS),
        Classification("27.5", "Fabrication d'appareils ménagers", Category.GROUP),
        Classification("27.51", "Fabrication d'appareils électroménagers", Category.CLASS),
        Classification("27.51Z", "Fabrication d'appareils électroménagers", Category.SUBCLASS),
        Classification("27.52", "Fabrication d'appareils ménagers non électriques", Category.CLASS),
        Classification("27.52Z", "Fabrication d'appareils ménagers non électriques", Category.SUBCLASS),
        Classification("27.9", "Fabrication d'autres matériels électriques", Category.GROUP),
        Classification("27.90", "Fabrication d'autres matériels électriques", Category.CLASS),
        Classification("27.90Z", "Fabrication d'autres matériels électriques", Category.SUBCLASS),
        Classification("28", "Fabrication de machines et équipements n.c.a.", Category.DIVISION),
        Classification("28.1", "Fabrication de machines d'usage général", Category.GROUP),
        Classification(
            "28.11",
            "Fabrication de moteurs et turbines, à l'exception des moteurs d’avions et de véhicules",
            Category.CLASS,
        ),
        Classification(
            "28.11Z",
            "Fabrication de moteurs et turbines, à l'exception des moteurs d’avions et de véhicules",
            Category.SUBCLASS,
        ),
        Classification("28.12", "Fabrication d'équipements hydrauliques et pneumatiques", Category.CLASS),
        Classification("28.12Z", "Fabrication d'équipements hydrauliques et pneumatiques", Category.SUBCLASS),
        Classification("28.13", "Fabrication d'autres pompes et compresseurs", Category.CLASS),
        Classification("28.13Z", "Fabrication d'autres pompes et compresseurs", Category.SUBCLASS),
        Classification("28.14", "Fabrication d'autres articles de robinetterie", Category.CLASS),
        Classification("28.14Z", "Fabrication d'autres articles de robinetterie", Category.SUBCLASS),
        Classification("28.15", "Fabrication d'engrenages et d'organes mécaniques de transmission", Category.CLASS),
        Classification("28.15Z", "Fabrication d'engrenages et d'organes mécaniques de transmission", Category.SUBCLASS),
        Classification("28.2", "Fabrication d'autres machines d'usage général", Category.GROUP),
        Classification("28.21", "Fabrication de fours et brûleurs", Category.CLASS),
        Classification("28.21Z", "Fabrication de fours et brûleurs", Category.SUBCLASS),
        Classification("28.22", "Fabrication de matériel de levage et de manutention", Category.CLASS),
        Classification("28.22Z", "Fabrication de matériel de levage et de manutention", Category.SUBCLASS),
        Classification(
            "28.23",
            "Fabrication de machines et d'équipements de bureau (à l'exception des ordinateurs et équipements périphériques)",
            Category.CLASS,
        ),
        Classification(
            "28.23Z",
            "Fabrication de machines et d'équipements de bureau (à l'exception des ordinateurs et équipements périphériques)",
            Category.SUBCLASS,
        ),
        Classification("28.24", "Fabrication d'outillage portatif à moteur incorporé", Category.CLASS),
        Classification("28.24Z", "Fabrication d'outillage portatif à moteur incorporé", Category.SUBCLASS),
        Classification("28.25", "Fabrication d'équipements aérauliques et frigorifiques industriels", Category.CLASS),
        Classification(
            "28.25Z", "Fabrication d'équipements aérauliques et frigorifiques industriels", Category.SUBCLASS
        ),
        Classification("28.29", "Fabrication de machines diverses d'usage général", Category.CLASS),
        Classification(
            "28.29A", "Fabrication d'équipements d'emballage, de conditionnement et de pesage ", Category.SUBCLASS
        ),
        Classification("28.29B", "Fabrication d'autres machines d'usage général", Category.SUBCLASS),
        Classification("28.3", "Fabrication de machines agricoles et forestières", Category.GROUP),
        Classification("28.30", "Fabrication de machines agricoles et forestières", Category.CLASS),
        Classification("28.30Z", "Fabrication de machines agricoles et forestières", Category.SUBCLASS),
        Classification("28.4", "Fabrication de machines de formage des métaux et de machines-outils", Category.GROUP),
        Classification("28.41", "Fabrication de machines de formage des métaux", Category.CLASS),
        Classification("28.41Z", "Fabrication de machines-outils pour le travail des métaux", Category.SUBCLASS),
        Classification("28.49", "Fabrication d'autres machines-outils ", Category.CLASS),
        Classification("28.49Z", "Fabrication d'autres machines-outils ", Category.SUBCLASS),
        Classification("28.9", "Fabrication d'autres machines d'usage spécifique", Category.GROUP),
        Classification("28.91", "Fabrication de machines pour la métallurgie", Category.CLASS),
        Classification("28.91Z", "Fabrication de machines pour la métallurgie", Category.SUBCLASS),
        Classification("28.92", "Fabrication de machines pour l'extraction ou la construction", Category.CLASS),
        Classification("28.92Z", "Fabrication de machines pour l'extraction ou la construction", Category.SUBCLASS),
        Classification("28.93", "Fabrication de machines pour l'industrie agro-alimentaire", Category.CLASS),
        Classification("28.93Z", "Fabrication de machines pour l'industrie agro-alimentaire", Category.SUBCLASS),
        Classification("28.94", "Fabrication de machines pour les industries textiles", Category.CLASS),
        Classification("28.94Z", "Fabrication de machines pour les industries textiles", Category.SUBCLASS),
        Classification("28.95", "Fabrication de machines pour les industries du papier et du carton", Category.CLASS),
        Classification(
            "28.95Z", "Fabrication de machines pour les industries du papier et du carton", Category.SUBCLASS
        ),
        Classification(
            "28.96", "Fabrication de machines pour le travail du caoutchouc ou des plastiques", Category.CLASS
        ),
        Classification(
            "28.96Z", "Fabrication de machines pour le travail du caoutchouc ou des plastiques", Category.SUBCLASS
        ),
        Classification("28.99", "Fabrication d'autres machines d'usage spécifique n.c.a.", Category.CLASS),
        Classification("28.99A", "Fabrication de machines d'imprimerie", Category.SUBCLASS),
        Classification("28.99B", "Fabrication d'autres machines spécialisées", Category.SUBCLASS),
        Classification("29", "Industrie automobile", Category.DIVISION),
        Classification("29.1", "Construction de véhicules automobiles", Category.GROUP),
        Classification("29.10", "Construction de véhicules automobiles", Category.CLASS),
        Classification("29.10Z", "Construction de véhicules automobiles", Category.SUBCLASS),
        Classification("29.2", "Fabrication de carrosseries et remorques", Category.GROUP),
        Classification("29.20", "Fabrication de carrosseries et remorques", Category.CLASS),
        Classification("29.20Z", "Fabrication de carrosseries et remorques", Category.SUBCLASS),
        Classification("29.3", "Fabrication d'équipements automobiles", Category.GROUP),
        Classification("29.31", "Fabrication d'équipements électriques et électroniques automobiles", Category.CLASS),
        Classification(
            "29.31Z", "Fabrication d'équipements électriques et électroniques automobiles", Category.SUBCLASS
        ),
        Classification("29.32", "Fabrication d'autres équipements automobiles", Category.CLASS),
        Classification("29.32Z", "Fabrication d'autres équipements automobiles", Category.SUBCLASS),
        Classification("30", "Fabrication d'autres matériels de transport", Category.DIVISION),
        Classification("30.1", "Construction navale", Category.GROUP),
        Classification("30.11", "Construction de navires et de structures flottantes", Category.CLASS),
        Classification("30.11Z", "Construction de navires et de structures flottantes", Category.SUBCLASS),
        Classification("30.12", "Construction de bateaux de plaisance", Category.CLASS),
        Classification("30.12Z", "Construction de bateaux de plaisance", Category.SUBCLASS),
        Classification("30.2", "Construction de locomotives et d'autre matériel ferroviaire roulant", Category.GROUP),
        Classification("30.20", "Construction de locomotives et d'autre matériel ferroviaire roulant ", Category.CLASS),
        Classification(
            "30.20Z", "Construction de locomotives et d'autre matériel ferroviaire roulant ", Category.SUBCLASS
        ),
        Classification("30.3", "Construction aéronautique et spatiale ", Category.GROUP),
        Classification("30.30", "Construction aéronautique et spatiale ", Category.CLASS),
        Classification("30.30Z", "Construction aéronautique et spatiale ", Category.SUBCLASS),
        Classification("30.4", "Construction de véhicules militaires de combat", Category.GROUP),
        Classification("30.40", "Construction de véhicules militaires de combat ", Category.CLASS),
        Classification("30.40Z", "Construction de véhicules militaires de combat ", Category.SUBCLASS),
        Classification("30.9", "Fabrication de matériels de transport n.c.a.", Category.GROUP),
        Classification("30.91", "Fabrication de motocycles", Category.CLASS),
        Classification("30.91Z", "Fabrication de motocycles", Category.SUBCLASS),
        Classification("30.92", "Fabrication de bicyclettes et de véhicules pour invalides", Category.CLASS),
        Classification("30.92Z", "Fabrication de bicyclettes et de véhicules pour invalides", Category.SUBCLASS),
        Classification("30.99", "Fabrication d’autres équipements de transport n.c.a.", Category.CLASS),
        Classification("30.99Z", "Fabrication d’autres équipements de transport n.c.a.", Category.SUBCLASS),
        Classification("31", "Fabrication de meubles", Category.DIVISION),
        Classification("31.0", "Fabrication de meubles", Category.GROUP),
        Classification("31.01", "Fabrication de meubles de bureau et de magasin", Category.CLASS),
        Classification("31.01Z", "Fabrication de meubles de bureau et de magasin", Category.SUBCLASS),
        Classification("31.02", "Fabrication de meubles de cuisine ", Category.CLASS),
        Classification("31.02Z", "Fabrication de meubles de cuisine ", Category.SUBCLASS),
        Classification("31.03", "Fabrication de matelas", Category.CLASS),
        Classification("31.03Z", "Fabrication de matelas", Category.SUBCLASS),
        Classification("31.09", "Fabrication d'autres meubles", Category.CLASS),
        Classification("31.09A", "Fabrication de sièges d'ameublement d'intérieur", Category.SUBCLASS),
        Classification(
            "31.09B", "Fabrication d’autres meubles et industries connexes de l’ameublement", Category.SUBCLASS
        ),
        Classification("32", "Autres industries manufacturières", Category.DIVISION),
        Classification(
            "32.1", "Fabrication d’articles de joaillerie, bijouterie et articles similaires", Category.GROUP
        ),
        Classification("32.11", "Frappe de monnaie", Category.CLASS),
        Classification("32.11Z", "Frappe de monnaie", Category.SUBCLASS),
        Classification("32.12", "Fabrication d’articles de joaillerie et bijouterie", Category.CLASS),
        Classification("32.12Z", "Fabrication d’articles de joaillerie et bijouterie", Category.SUBCLASS),
        Classification(
            "32.13", "Fabrication d’articles de bijouterie fantaisie et articles similaires", Category.CLASS
        ),
        Classification(
            "32.13Z", "Fabrication d’articles de bijouterie fantaisie et articles similaires", Category.SUBCLASS
        ),
        Classification("32.2", "Fabrication d'instruments de musique", Category.GROUP),
        Classification("32.20", "Fabrication d'instruments de musique", Category.CLASS),
        Classification("32.20Z", "Fabrication d'instruments de musique", Category.SUBCLASS),
        Classification("32.3", "Fabrication d'articles de sport", Category.GROUP),
        Classification("32.30", "Fabrication d'articles de sport", Category.CLASS),
        Classification("32.30Z", "Fabrication d'articles de sport", Category.SUBCLASS),
        Classification("32.4", "Fabrication de jeux et jouets", Category.GROUP),
        Classification("32.40", "Fabrication de jeux et jouets", Category.CLASS),
        Classification("32.40Z", "Fabrication de jeux et jouets", Category.SUBCLASS),
        Classification(
            "32.5", "Fabrication d'instruments et de fournitures à usage médical et dentaire", Category.GROUP
        ),
        Classification(
            "32.50", "Fabrication d'instruments et de fournitures à usage médical et dentaire ", Category.CLASS
        ),
        Classification("32.50A", "Fabrication de matériel médico-chirurgical et dentaire", Category.SUBCLASS),
        Classification("32.50B", "Fabrication de lunettes", Category.SUBCLASS),
        Classification("32.9", "Activités manufacturières n.c.a.", Category.GROUP),
        Classification("32.91", "Fabrication d’articles de brosserie", Category.CLASS),
        Classification("32.91Z", "Fabrication d’articles de brosserie", Category.SUBCLASS),
        Classification("32.99", "Autres activités manufacturières n.c.a. ", Category.CLASS),
        Classification("32.99Z", "Autres activités manufacturières n.c.a. ", Category.SUBCLASS),
        Classification("33", "Réparation et installation de machines et d'équipements ", Category.DIVISION),
        Classification("33.1", "Réparation d'ouvrages en métaux, de machines et d'équipements", Category.GROUP),
        Classification("33.11", "Réparation d'ouvrages en métaux", Category.CLASS),
        Classification("33.11Z", "Réparation d'ouvrages en métaux", Category.SUBCLASS),
        Classification("33.12", "Réparation de machines et équipements mécaniques", Category.CLASS),
        Classification("33.12Z", "Réparation de machines et équipements mécaniques", Category.SUBCLASS),
        Classification("33.13", "Réparation de matériels électroniques et optiques", Category.CLASS),
        Classification("33.13Z", "Réparation de matériels électroniques et optiques", Category.SUBCLASS),
        Classification("33.14", "Réparation d'équipements électriques", Category.CLASS),
        Classification("33.14Z", "Réparation d'équipements électriques", Category.SUBCLASS),
        Classification("33.15", "Réparation et maintenance navale", Category.CLASS),
        Classification("33.15Z", "Réparation et maintenance navale", Category.SUBCLASS),
        Classification("33.16", "Réparation et maintenance d'aéronefs et d'engins spatiaux ", Category.CLASS),
        Classification("33.16Z", "Réparation et maintenance d'aéronefs et d'engins spatiaux ", Category.SUBCLASS),
        Classification("33.17", "Réparation et maintenance d'autres équipements de transport", Category.CLASS),
        Classification("33.17Z", "Réparation et maintenance d'autres équipements de transport", Category.SUBCLASS),
        Classification("33.19", "Réparation d'autres équipements", Category.CLASS),
        Classification("33.19Z", "Réparation d'autres équipements", Category.SUBCLASS),
        Classification("33.2", "Installation de machines et d'équipements industriels", Category.GROUP),
        Classification("33.20", "Installation de machines et d'équipements industriels", Category.CLASS),
        Classification(
            "33.20A", "Installation de structures métalliques, chaudronnées et de tuyauterie", Category.SUBCLASS
        ),
        Classification("33.20B", "Installation de machines et équipements mécaniques", Category.SUBCLASS),
        Classification(
            "33.20C",
            "Conception d'ensemble et assemblage sur site industriel d'équipements de contrôle des processus industriels ",
            Category.SUBCLASS,
        ),
        Classification(
            "33.20D",
            "Installation d'équipements électriques, de matériels électroniques et optiques ou d'autres matériels",
            Category.SUBCLASS,
        ),
        Classification(
            "D", "PRODUCTION ET DISTRIBUTION D'ÉLECTRICITÉ, DE GAZ, DE VAPEUR ET D'AIR CONDITIONNÉ", Category.SECTION
        ),
        Classification(
            "35", "Production et distribution d'électricité, de gaz, de vapeur et d'air conditionné", Category.DIVISION
        ),
        Classification("35.1", "Production, transport et distribution d'électricité", Category.GROUP),
        Classification("35.11", "Production d'électricité", Category.CLASS),
        Classification("35.11Z", "Production d'électricité", Category.SUBCLASS),
        Classification("35.12", "Transport d'électricité", Category.CLASS),
        Classification("35.12Z", "Transport d'électricité", Category.SUBCLASS),
        Classification("35.13", "Distribution d'électricité", Category.CLASS),
        Classification("35.13Z", "Distribution d'électricité", Category.SUBCLASS),
        Classification("35.14", "Commerce d'électricité", Category.CLASS),
        Classification("35.14Z", "Commerce d'électricité", Category.SUBCLASS),
        Classification("35.2", "Production et distribution de combustibles gazeux", Category.GROUP),
        Classification("35.21", "Production de combustibles gazeux", Category.CLASS),
        Classification("35.21Z", "Production de combustibles gazeux", Category.SUBCLASS),
        Classification("35.22", "Distribution de combustibles gazeux par conduites", Category.CLASS),
        Classification("35.22Z", "Distribution de combustibles gazeux par conduites", Category.SUBCLASS),
        Classification("35.23", "Commerce de combustibles gazeux par conduites", Category.CLASS),
        Classification("35.23Z", "Commerce de combustibles gazeux par conduites", Category.SUBCLASS),
        Classification("35.3", "Production et distribution de vapeur et d'air conditionné", Category.GROUP),
        Classification("35.30", "Production et distribution de vapeur et d'air conditionné ", Category.CLASS),
        Classification("35.30Z", "Production et distribution de vapeur et d'air conditionné ", Category.SUBCLASS),
        Classification(
            "E",
            "PRODUCTION ET DISTRIBUTION D'EAU ; ASSAINISSEMENT, GESTION DES DÉCHETS ET DÉPOLLUTION",
            Category.SECTION,
        ),
        Classification("36", "Captage, traitement et distribution d'eau ", Category.DIVISION),
        Classification("36.0", "Captage, traitement et distribution d'eau", Category.GROUP),
        Classification("36.00", "Captage, traitement et distribution d'eau", Category.CLASS),
        Classification("36.00Z", "Captage, traitement et distribution d'eau", Category.SUBCLASS),
        Classification("37", "Collecte et traitement des eaux usées", Category.DIVISION),
        Classification("37.0", "Collecte et traitement des eaux usées", Category.GROUP),
        Classification("37.00", "Collecte et traitement des eaux usées", Category.CLASS),
        Classification("37.00Z", "Collecte et traitement des eaux usées", Category.SUBCLASS),
        Classification("38", "Collecte, traitement et élimination des déchets ; récupération", Category.DIVISION),
        Classification("38.1", "Collecte des déchets", Category.GROUP),
        Classification("38.11", "Collecte des déchets non dangereux", Category.CLASS),
        Classification("38.11Z", "Collecte des déchets non dangereux", Category.SUBCLASS),
        Classification("38.12", "Collecte des déchets dangereux", Category.CLASS),
        Classification("38.12Z", "Collecte des déchets dangereux", Category.SUBCLASS),
        Classification("38.2", "Traitement et élimination des déchets", Category.GROUP),
        Classification("38.21", "Traitement et élimination des déchets non dangereux", Category.CLASS),
        Classification("38.21Z", "Traitement et élimination des déchets non dangereux", Category.SUBCLASS),
        Classification("38.22", "Traitement et élimination des déchets dangereux", Category.CLASS),
        Classification("38.22Z", "Traitement et élimination des déchets dangereux", Category.SUBCLASS),
        Classification("38.3", "Récupération", Category.GROUP),
        Classification("38.31", "Démantèlement d'épaves", Category.CLASS),
        Classification("38.31Z", "Démantèlement d'épaves", Category.SUBCLASS),
        Classification("38.32", "Récupération de déchets triés", Category.CLASS),
        Classification("38.32Z", "Récupération de déchets triés", Category.SUBCLASS),
        Classification("39", "Dépollution et autres services de gestion des déchets", Category.DIVISION),
        Classification("39.0", "Dépollution et autres services de gestion des déchets", Category.GROUP),
        Classification("39.00", "Dépollution et autres services de gestion des déchets", Category.CLASS),
        Classification("39.00Z", "Dépollution et autres services de gestion des déchets", Category.SUBCLASS),
        Classification("F", "CONSTRUCTION", Category.SECTION),
        Classification("41", "Construction de bâtiments ", Category.DIVISION),
        Classification("41.1", "Promotion immobilière", Category.GROUP),
        Classification("41.10", "Promotion immobilière", Category.CLASS),
        Classification("41.10A", "Promotion immobilière de logements", Category.SUBCLASS),
        Classification("41.10B", "Promotion immobilière de bureaux", Category.SUBCLASS),
        Classification("41.10C", "Promotion immobilière d'autres bâtiments", Category.SUBCLASS),
        Classification("41.10D", "Supports juridiques de programmes", Category.SUBCLASS),
        Classification("41.2", "Construction de bâtiments résidentiels et non résidentiels", Category.GROUP),
        Classification("41.20", "Construction de bâtiments résidentiels et non résidentiels", Category.CLASS),
        Classification("41.20A", "Construction de maisons individuelles", Category.SUBCLASS),
        Classification("41.20B", "Construction d'autres bâtiments", Category.SUBCLASS),
        Classification("42", "Génie civil", Category.DIVISION),
        Classification("42.1", "Construction de routes et de voies ferrées ", Category.GROUP),
        Classification("42.11", "Construction de routes et autoroutes", Category.CLASS),
        Classification("42.11Z", "Construction de routes et autoroutes", Category.SUBCLASS),
        Classification("42.12", "Construction de voies ferrées de surface et souterraines", Category.CLASS),
        Classification("42.12Z", "Construction de voies ferrées de surface et souterraines", Category.SUBCLASS),
        Classification("42.13", "Construction de ponts et tunnels", Category.CLASS),
        Classification("42.13A", "Construction d'ouvrages d'art", Category.SUBCLASS),
        Classification("42.13B", "Construction et entretien de tunnels", Category.SUBCLASS),
        Classification("42.2", "Construction de réseaux et de lignes", Category.GROUP),
        Classification("42.21", "Construction de réseaux pour fluides", Category.CLASS),
        Classification("42.21Z", "Construction de réseaux pour fluides", Category.SUBCLASS),
        Classification("42.22", "Construction de réseaux électriques et de télécommunications", Category.CLASS),
        Classification("42.22Z", "Construction de réseaux électriques et de télécommunications", Category.SUBCLASS),
        Classification("42.9", "Construction d'autres ouvrages de génie civil ", Category.GROUP),
        Classification("42.91", "Construction d'ouvrages maritimes et fluviaux", Category.CLASS),
        Classification("42.91Z", "Construction d'ouvrages maritimes et fluviaux", Category.SUBCLASS),
        Classification("42.99", "Construction d'autres ouvrages de génie civil n.c.a.", Category.CLASS),
        Classification("42.99Z", "Construction d'autres ouvrages de génie civil n.c.a.", Category.SUBCLASS),
        Classification("43", "Travaux de construction spécialisés ", Category.DIVISION),
        Classification("43.1", "Démolition et préparation des sites", Category.GROUP),
        Classification("43.11", "Travaux de démolition", Category.CLASS),
        Classification("43.11Z", "Travaux de démolition", Category.SUBCLASS),
        Classification("43.12", "Travaux de préparation des sites", Category.CLASS),
        Classification("43.12A", "Travaux de terrassement courants et travaux préparatoires", Category.SUBCLASS),
        Classification("43.12B", "Travaux de terrassement spécialisés ou de grande masse", Category.SUBCLASS),
        Classification("43.13", "Forages et sondages", Category.CLASS),
        Classification("43.13Z", "Forages et sondages", Category.SUBCLASS),
        Classification(
            "43.2", "Travaux d'installation électrique, plomberie et autres travaux d'installation", Category.GROUP
        ),
        Classification("43.21", "Installation électrique", Category.CLASS),
        Classification("43.21A", "Travaux d'installation électrique dans tous locaux", Category.SUBCLASS),
        Classification("43.21B", "Travaux d'installation électrique sur la voie publique", Category.SUBCLASS),
        Classification(
            "43.22", "Travaux de plomberie et installation de chauffage et de conditionnement d'air", Category.CLASS
        ),
        Classification("43.22A", "Travaux d'installation d'eau et de gaz en tous locaux", Category.SUBCLASS),
        Classification(
            "43.22B", "Travaux d'installation d'équipements thermiques et de climatisation", Category.SUBCLASS
        ),
        Classification("43.29", "Autres travaux d'installation", Category.CLASS),
        Classification("43.29A", "Travaux d'isolation", Category.SUBCLASS),
        Classification("43.29B", "Autres travaux d'installation n.c.a.", Category.SUBCLASS),
        Classification("43.3", "Travaux de finition", Category.GROUP),
        Classification("43.31", "Travaux de plâtrerie", Category.CLASS),
        Classification("43.31Z", "Travaux de plâtrerie", Category.SUBCLASS),
        Classification("43.32", "Travaux de menuiserie", Category.CLASS),
        Classification("43.32A", "Travaux de menuiserie bois et PVC", Category.SUBCLASS),
        Classification("43.32B", "Travaux de menuiserie métallique et serrurerie", Category.SUBCLASS),
        Classification("43.32C", "Agencement de lieux de vente", Category.SUBCLASS),
        Classification("43.33", "Travaux de revêtement des sols et des murs", Category.CLASS),
        Classification("43.33Z", "Travaux de revêtement des sols et des murs", Category.SUBCLASS),
        Classification("43.34", "Travaux de peinture et vitrerie", Category.CLASS),
        Classification("43.34Z", "Travaux de peinture et vitrerie", Category.SUBCLASS),
        Classification("43.39", "Autres travaux de finition", Category.CLASS),
        Classification("43.39Z", "Autres travaux de finition", Category.SUBCLASS),
        Classification("43.9", "Autres travaux de construction spécialisés", Category.GROUP),
        Classification("43.91", "Travaux de couverture", Category.CLASS),
        Classification("43.91A", "Travaux de charpente", Category.SUBCLASS),
        Classification("43.91B", "Travaux de couverture par éléments", Category.SUBCLASS),
        Classification("43.99", "Autres travaux de construction spécialisés n.c.a.", Category.CLASS),
        Classification("43.99A", "Travaux d'étanchéification", Category.SUBCLASS),
        Classification("43.99B", "Travaux de montage de structures métalliques", Category.SUBCLASS),
        Classification("43.99C", "Travaux de maçonnerie générale et gros œuvre de bâtiment", Category.SUBCLASS),
        Classification("43.99D", "Autres travaux spécialisés de construction", Category.SUBCLASS),
        Classification("43.99E", "Location avec opérateur de matériel de construction", Category.SUBCLASS),
        Classification("G", "COMMERCE ; RÉPARATION D'AUTOMOBILES ET DE MOTOCYCLES", Category.SECTION),
        Classification("45", "Commerce et réparation d'automobiles et de motocycles", Category.DIVISION),
        Classification("45.1", "Commerce de véhicules automobiles", Category.GROUP),
        Classification("45.11", "Commerce de voitures et de véhicules automobiles légers", Category.CLASS),
        Classification("45.11Z", "Commerce de voitures et de véhicules automobiles légers", Category.SUBCLASS),
        Classification("45.19", "Commerce d'autres véhicules automobiles", Category.CLASS),
        Classification("45.19Z", "Commerce d'autres véhicules automobiles", Category.SUBCLASS),
        Classification("45.2", "Entretien et réparation de véhicules automobiles", Category.GROUP),
        Classification("45.20", "Entretien et réparation de véhicules automobiles", Category.CLASS),
        Classification("45.20A", "Entretien et réparation de véhicules automobiles légers", Category.SUBCLASS),
        Classification("45.20B", "Entretien et réparation d'autres véhicules automobiles", Category.SUBCLASS),
        Classification("45.3", "Commerce d'équipements automobiles", Category.GROUP),
        Classification("45.31", "Commerce de gros d'équipements automobiles", Category.CLASS),
        Classification("45.31Z", "Commerce de gros d'équipements automobiles", Category.SUBCLASS),
        Classification("45.32", "Commerce de détail d'équipements automobiles", Category.CLASS),
        Classification("45.32Z", "Commerce de détail d'équipements automobiles", Category.SUBCLASS),
        Classification("45.4", "Commerce et réparation de motocycles", Category.GROUP),
        Classification("45.40", "Commerce et réparation de motocycles", Category.CLASS),
        Classification("45.40Z", "Commerce et réparation de motocycles", Category.SUBCLASS),
        Classification("46", "Commerce de gros, à l’exception des automobiles et des motocycles", Category.DIVISION),
        Classification("46.1", "Intermédiaires du commerce de gros", Category.GROUP),
        Classification(
            "46.11",
            "Intermédiaires du commerce en matières premières agricoles, animaux vivants, matières premières textiles et produits semi-finis",
            Category.CLASS,
        ),
        Classification(
            "46.11Z",
            "Intermédiaires du commerce en matières premières agricoles, animaux vivants, matières premières textiles et produits semi-finis",
            Category.SUBCLASS,
        ),
        Classification(
            "46.12",
            "Intermédiaires du commerce en combustibles, métaux, minéraux et produits chimiques",
            Category.CLASS,
        ),
        Classification("46.12A", "Centrales d'achat de carburant", Category.SUBCLASS),
        Classification(
            "46.12B",
            "Autres intermédiaires du commerce en combustibles, métaux, minéraux et produits chimiques",
            Category.SUBCLASS,
        ),
        Classification("46.13", "Intermédiaires du commerce en bois et matériaux de construction", Category.CLASS),
        Classification("46.13Z", "Intermédiaires du commerce en bois et matériaux de construction", Category.SUBCLASS),
        Classification(
            "46.14",
            "Intermédiaires du commerce en machines, équipements industriels, navires et avions",
            Category.CLASS,
        ),
        Classification(
            "46.14Z",
            "Intermédiaires du commerce en machines, équipements industriels, navires et avions",
            Category.SUBCLASS,
        ),
        Classification(
            "46.15", "Intermédiaires du commerce en meubles, articles de ménage et quincaillerie", Category.CLASS
        ),
        Classification(
            "46.15Z", "Intermédiaires du commerce en meubles, articles de ménage et quincaillerie", Category.SUBCLASS
        ),
        Classification(
            "46.16",
            "Intermédiaires du commerce en textiles, habillement, fourrures, chaussures et articles en cuir",
            Category.CLASS,
        ),
        Classification(
            "46.16Z",
            "Intermédiaires du commerce en textiles, habillement, fourrures, chaussures et articles en cuir",
            Category.SUBCLASS,
        ),
        Classification("46.17", "Intermédiaires du commerce en denrées, boissons et tabac", Category.CLASS),
        Classification("46.17A", "Centrales d'achat alimentaires", Category.SUBCLASS),
        Classification("46.17B", "Autres intermédiaires du commerce en denrées, boissons et tabac", Category.SUBCLASS),
        Classification(
            "46.18", "Intermédiaires spécialisés dans le commerce d'autres produits spécifiques", Category.CLASS
        ),
        Classification(
            "46.18Z", "Intermédiaires spécialisés dans le commerce d'autres produits spécifiques", Category.SUBCLASS
        ),
        Classification("46.19", "Intermédiaires du commerce en produits divers", Category.CLASS),
        Classification("46.19A", "Centrales d'achat non alimentaires", Category.SUBCLASS),
        Classification("46.19B", "Autres intermédiaires du commerce en produits divers", Category.SUBCLASS),
        Classification("46.2", "Commerce de gros de produits agricoles bruts et d'animaux vivants", Category.GROUP),
        Classification(
            "46.21",
            "Commerce de gros de céréales, de tabac non manufacturé, de semences et d'aliments pour le bétail ",
            Category.CLASS,
        ),
        Classification(
            "46.21Z",
            "Commerce de gros (commerce interentreprises) de céréales, de tabac non manufacturé, de semences et d'aliments pour le bétail ",
            Category.SUBCLASS,
        ),
        Classification("46.22", "Commerce de gros de fleurs et plantes", Category.CLASS),
        Classification(
            "46.22Z", "Commerce de gros (commerce interentreprises) de fleurs et plantes", Category.SUBCLASS
        ),
        Classification("46.23", "Commerce de gros d'animaux vivants", Category.CLASS),
        Classification("46.23Z", "Commerce de gros (commerce interentreprises) d'animaux vivants", Category.SUBCLASS),
        Classification("46.24", "Commerce de gros de cuirs et peaux", Category.CLASS),
        Classification("46.24Z", "Commerce de gros (commerce interentreprises) de cuirs et peaux", Category.SUBCLASS),
        Classification("46.3", "Commerce de gros de produits alimentaires, de boissons et de tabac", Category.GROUP),
        Classification("46.31", "Commerce de gros de fruits et légumes", Category.CLASS),
        Classification(
            "46.31Z", "Commerce de gros (commerce interentreprises) de fruits et légumes", Category.SUBCLASS
        ),
        Classification("46.32", "Commerce de gros de viandes et de produits à base de viande", Category.CLASS),
        Classification(
            "46.32A", "Commerce de gros (commerce interentreprises) de viandes de boucherie", Category.SUBCLASS
        ),
        Classification(
            "46.32B", "Commerce de gros (commerce interentreprises) de produits à base de viande", Category.SUBCLASS
        ),
        Classification(
            "46.32C", "Commerce de gros (commerce interentreprises) de volailles et gibier", Category.SUBCLASS
        ),
        Classification(
            "46.33",
            "Commerce de gros de produits laitiers, œufs, huiles et matières grasses comestibles",
            Category.CLASS,
        ),
        Classification(
            "46.33Z",
            "Commerce de gros (commerce interentreprises) de produits laitiers, œufs, huiles et matières grasses comestibles",
            Category.SUBCLASS,
        ),
        Classification("46.34", "Commerce de gros de boissons", Category.CLASS),
        Classification("46.34Z", "Commerce de gros (commerce interentreprises) de boissons", Category.SUBCLASS),
        Classification("46.35", "Commerce de gros de produits à base de tabac", Category.CLASS),
        Classification(
            "46.35Z", "Commerce de gros (commerce interentreprises) de produits à base de tabac", Category.SUBCLASS
        ),
        Classification("46.36", "Commerce de gros de sucre, chocolat et confiserie", Category.CLASS),
        Classification(
            "46.36Z", "Commerce de gros (commerce interentreprises) de sucre, chocolat et confiserie", Category.SUBCLASS
        ),
        Classification("46.37", "Commerce de gros de café, thé, cacao et épices", Category.CLASS),
        Classification(
            "46.37Z", "Commerce de gros (commerce interentreprises) de café, thé, cacao et épices", Category.SUBCLASS
        ),
        Classification(
            "46.38",
            "Commerce de gros d'autres produits alimentaires, y compris poissons, crustacés et mollusques",
            Category.CLASS,
        ),
        Classification(
            "46.38A",
            "Commerce de gros (commerce interentreprises) de poissons, crustacés et mollusques",
            Category.SUBCLASS,
        ),
        Classification(
            "46.38B", "Commerce de gros (commerce interentreprises) alimentaire spécialisé divers", Category.SUBCLASS
        ),
        Classification("46.39", "Commerce de gros non spécialisé de denrées, boissons et tabac", Category.CLASS),
        Classification(
            "46.39A", "Commerce de gros (commerce interentreprises) de produits surgelés", Category.SUBCLASS
        ),
        Classification(
            "46.39B", "Commerce de gros (commerce interentreprises) alimentaire non spécialisé", Category.SUBCLASS
        ),
        Classification("46.4", "Commerce de gros de biens domestiques", Category.GROUP),
        Classification("46.41", "Commerce de gros de textiles", Category.CLASS),
        Classification("46.41Z", "Commerce de gros (commerce interentreprises) de textiles", Category.SUBCLASS),
        Classification("46.42", "Commerce de gros d'habillement et de chaussures", Category.CLASS),
        Classification(
            "46.42Z", "Commerce de gros (commerce interentreprises) d'habillement et de chaussures", Category.SUBCLASS
        ),
        Classification("46.43", "Commerce de gros d'appareils électroménagers", Category.CLASS),
        Classification(
            "46.43Z", "Commerce de gros (commerce interentreprises) d'appareils électroménagers", Category.SUBCLASS
        ),
        Classification("46.44", "Commerce de gros de vaisselle, verrerie et produits d'entretien", Category.CLASS),
        Classification(
            "46.44Z",
            "Commerce de gros (commerce interentreprises) de vaisselle, verrerie et produits d'entretien",
            Category.SUBCLASS,
        ),
        Classification("46.45", "Commerce de gros de parfumerie et de produits de beauté", Category.CLASS),
        Classification(
            "46.45Z",
            "Commerce de gros (commerce interentreprises) de parfumerie et de produits de beauté",
            Category.SUBCLASS,
        ),
        Classification("46.46", "Commerce de gros de produits pharmaceutiques", Category.CLASS),
        Classification(
            "46.46Z", "Commerce de gros (commerce interentreprises) de produits pharmaceutiques", Category.SUBCLASS
        ),
        Classification("46.47", "Commerce de gros de meubles, de tapis et d'appareils d'éclairage ", Category.CLASS),
        Classification(
            "46.47Z",
            "Commerce de gros (commerce interentreprises) de meubles, de tapis et d'appareils d'éclairage ",
            Category.SUBCLASS,
        ),
        Classification("46.48", "Commerce de gros d'articles d'horlogerie et de bijouterie", Category.CLASS),
        Classification(
            "46.48Z",
            "Commerce de gros (commerce interentreprises) d'articles d'horlogerie et de bijouterie",
            Category.SUBCLASS,
        ),
        Classification("46.49", "Commerce de gros d'autres biens domestiques", Category.CLASS),
        Classification(
            "46.49Z", "Commerce de gros (commerce interentreprises) d'autres biens domestiques ", Category.SUBCLASS
        ),
        Classification(
            "46.5", "Commerce de gros d'équipements de l'information et de la communication ", Category.GROUP
        ),
        Classification(
            "46.51",
            "Commerce de gros d'ordinateurs, d'équipements informatiques périphériques et de logiciels",
            Category.CLASS,
        ),
        Classification(
            "46.51Z",
            "Commerce de gros (commerce interentreprises) d'ordinateurs, d'équipements informatiques périphériques et de logiciels",
            Category.SUBCLASS,
        ),
        Classification(
            "46.52",
            "Commerce de gros de composants et d'équipements électroniques et de télécommunication",
            Category.CLASS,
        ),
        Classification(
            "46.52Z",
            "Commerce de gros (commerce interentreprises) de composants et d'équipements électroniques et de télécommunication",
            Category.SUBCLASS,
        ),
        Classification("46.6", "Commerce de gros d'autres équipements industriels", Category.GROUP),
        Classification("46.61", "Commerce de gros de matériel agricole", Category.CLASS),
        Classification(
            "46.61Z", "Commerce de gros (commerce interentreprises) de matériel agricole", Category.SUBCLASS
        ),
        Classification("46.62", "Commerce de gros de machines-outils", Category.CLASS),
        Classification("46.62Z", "Commerce de gros (commerce interentreprises) de machines-outils", Category.SUBCLASS),
        Classification(
            "46.63",
            "Commerce de gros de machines pour l'extraction, la construction et le génie civil ",
            Category.CLASS,
        ),
        Classification(
            "46.63Z",
            "Commerce de gros (commerce interentreprises) de machines pour l'extraction, la construction et le génie civil ",
            Category.SUBCLASS,
        ),
        Classification(
            "46.64", "Commerce de gros de machines pour l'industrie textile et l'habillement", Category.CLASS
        ),
        Classification(
            "46.64Z",
            "Commerce de gros (commerce interentreprises) de machines pour l'industrie textile et l'habillement",
            Category.SUBCLASS,
        ),
        Classification("46.65", "Commerce de gros de mobilier de bureau", Category.CLASS),
        Classification(
            "46.65Z", "Commerce de gros (commerce interentreprises) de mobilier de bureau", Category.SUBCLASS
        ),
        Classification("46.66", "Commerce de gros d'autres machines et équipements de bureau ", Category.CLASS),
        Classification(
            "46.66Z",
            "Commerce de gros (commerce interentreprises) d'autres machines et équipements de bureau ",
            Category.SUBCLASS,
        ),
        Classification("46.69", "Commerce de gros d'autres machines et équipements", Category.CLASS),
        Classification(
            "46.69A", "Commerce de gros (commerce interentreprises) de matériel électrique", Category.SUBCLASS
        ),
        Classification(
            "46.69B",
            "Commerce de gros (commerce interentreprises) de fournitures et équipements industriels divers",
            Category.SUBCLASS,
        ),
        Classification(
            "46.69C",
            "Commerce de gros (commerce interentreprises) de fournitures et équipements divers pour le commerce et les services",
            Category.SUBCLASS,
        ),
        Classification("46.7", "Autres commerces de gros spécialisés", Category.GROUP),
        Classification("46.71", "Commerce de gros de combustibles et de produits annexes", Category.CLASS),
        Classification(
            "46.71Z",
            "Commerce de gros (commerce interentreprises) de combustibles et de produits annexes",
            Category.SUBCLASS,
        ),
        Classification("46.72", "Commerce de gros de minerais et métaux", Category.CLASS),
        Classification(
            "46.72Z", "Commerce de gros (commerce interentreprises) de minerais et métaux", Category.SUBCLASS
        ),
        Classification(
            "46.73", "Commerce de gros de bois, de matériaux de construction et d'appareils sanitaires ", Category.CLASS
        ),
        Classification(
            "46.73A",
            "Commerce de gros (commerce interentreprises) de bois et de matériaux de construction ",
            Category.SUBCLASS,
        ),
        Classification(
            "46.73B",
            "Commerce de gros (commerce interentreprises) d'appareils sanitaires et de produits de décoration",
            Category.SUBCLASS,
        ),
        Classification(
            "46.74", "Commerce de gros de quincaillerie et fournitures pour plomberie et chauffage", Category.CLASS
        ),
        Classification("46.74A", "Commerce de gros (commerce interentreprises) de quincaillerie", Category.SUBCLASS),
        Classification(
            "46.74B",
            "Commerce de gros (commerce interentreprises) de fournitures pour la plomberie et le chauffage",
            Category.SUBCLASS,
        ),
        Classification("46.75", "Commerce de gros de produits chimiques", Category.CLASS),
        Classification(
            "46.75Z", "Commerce de gros (commerce interentreprises) de produits chimiques", Category.SUBCLASS
        ),
        Classification("46.76", "Commerce de gros d'autres produits intermédiaires", Category.CLASS),
        Classification(
            "46.76Z", "Commerce de gros (commerce interentreprises) d'autres produits intermédiaires", Category.SUBCLASS
        ),
        Classification("46.77", "Commerce de gros de déchets et débris", Category.CLASS),
        Classification(
            "46.77Z", "Commerce de gros (commerce interentreprises) de déchets et débris", Category.SUBCLASS
        ),
        Classification("46.9", "Commerce de gros non spécialisé", Category.GROUP),
        Classification("46.90", "Commerce de gros non spécialisé", Category.CLASS),
        Classification("46.90Z", "Commerce de gros (commerce interentreprises) non spécialisé", Category.SUBCLASS),
        Classification("47", "Commerce de détail, à l’exception des automobiles et des motocycles", Category.DIVISION),
        Classification("47.1", "Commerce de détail en magasin non spécialisé", Category.GROUP),
        Classification(
            "47.11", "Commerce de détail en magasin non spécialisé à prédominance alimentaire", Category.CLASS
        ),
        Classification("47.11A", "Commerce de détail de produits surgelés", Category.SUBCLASS),
        Classification("47.11B", "Commerce d'alimentation générale", Category.SUBCLASS),
        Classification("47.11C", "Supérettes", Category.SUBCLASS),
        Classification("47.11D", "Supermarchés", Category.SUBCLASS),
        Classification("47.11E", "Magasins multi-commerces", Category.SUBCLASS),
        Classification("47.11F", "Hypermarchés", Category.SUBCLASS),
        Classification("47.19", "Autre commerce de détail en magasin non spécialisé", Category.CLASS),
        Classification("47.19A", "Grands magasins", Category.SUBCLASS),
        Classification("47.19B", "Autres commerces de détail en magasin non spécialisé", Category.SUBCLASS),
        Classification("47.2", "Commerce de détail alimentaire en magasin spécialisé", Category.GROUP),
        Classification("47.21", "Commerce de détail de fruits et légumes en magasin spécialisé", Category.CLASS),
        Classification("47.21Z", "Commerce de détail de fruits et légumes en magasin spécialisé", Category.SUBCLASS),
        Classification(
            "47.22",
            "Commerce de détail de viandes et de produits à base de viande en magasin spécialisé",
            Category.CLASS,
        ),
        Classification(
            "47.22Z",
            "Commerce de détail de viandes et de produits à base de viande en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification(
            "47.23", "Commerce de détail de poissons, crustacés et mollusques en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.23Z", "Commerce de détail de poissons, crustacés et mollusques en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.24", "Commerce de détail de pain, pâtisserie et confiserie en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.24Z", "Commerce de détail de pain, pâtisserie et confiserie en magasin spécialisé", Category.SUBCLASS
        ),
        Classification("47.25", "Commerce de détail de boissons en magasin spécialisé", Category.CLASS),
        Classification("47.25Z", "Commerce de détail de boissons en magasin spécialisé", Category.SUBCLASS),
        Classification("47.26", "Commerce de détail de produits à base de tabac en magasin spécialisé", Category.CLASS),
        Classification(
            "47.26Z", "Commerce de détail de produits à base de tabac en magasin spécialisé", Category.SUBCLASS
        ),
        Classification("47.29", "Autres commerces de détail alimentaires en magasin spécialisé ", Category.CLASS),
        Classification("47.29Z", "Autres commerces de détail alimentaires en magasin spécialisé ", Category.SUBCLASS),
        Classification("47.3", "Commerce de détail de carburants en magasin spécialisé", Category.GROUP),
        Classification("47.30", "Commerce de détail de carburants en magasin spécialisé", Category.CLASS),
        Classification("47.30Z", "Commerce de détail de carburants en magasin spécialisé", Category.SUBCLASS),
        Classification(
            "47.4",
            "Commerce de détail d'équipements de l'information et de la communication en magasin spécialisé",
            Category.GROUP,
        ),
        Classification(
            "47.41",
            "Commerce de détail d'ordinateurs, d'unités périphériques et de logiciels en magasin spécialisé",
            Category.CLASS,
        ),
        Classification(
            "47.41Z",
            "Commerce de détail d'ordinateurs, d'unités périphériques et de logiciels en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification(
            "47.42", "Commerce de détail de matériels de télécommunication en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.42Z", "Commerce de détail de matériels de télécommunication en magasin spécialisé", Category.SUBCLASS
        ),
        Classification("47.43", "Commerce de détail de matériels audio/vidéo en magasin spécialisé", Category.CLASS),
        Classification(
            "47.43Z", "Commerce de détail de matériels audio et vidéo en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.5", "Commerce de détail d'autres équipements du foyer en magasin spécialisé", Category.GROUP
        ),
        Classification("47.51", "Commerce de détail de textiles en magasin spécialisé", Category.CLASS),
        Classification("47.51Z", "Commerce de détail de textiles en magasin spécialisé", Category.SUBCLASS),
        Classification(
            "47.52", "Commerce de détail de quincaillerie, peintures et verres en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.52A",
            "Commerce de détail de quincaillerie, peintures et verres en petites surfaces (moins de 400 m2)",
            Category.SUBCLASS,
        ),
        Classification(
            "47.52B",
            "Commerce de détail de quincaillerie, peintures et verres en grandes surfaces (400 m2et plus)",
            Category.SUBCLASS,
        ),
        Classification(
            "47.53",
            "Commerce de détail de tapis, moquettes et revêtements de murs et de sols en magasin spécialisé",
            Category.CLASS,
        ),
        Classification(
            "47.53Z",
            "Commerce de détail de tapis, moquettes et revêtements de murs et de sols en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification("47.54", "Commerce de détail d'appareils électroménagers en magasin spécialisé", Category.CLASS),
        Classification(
            "47.54Z", "Commerce de détail d'appareils électroménagers en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.59",
            "Commerce de détail de meubles, appareils d'éclairage et autres articles de ménage en magasin spécialisé",
            Category.CLASS,
        ),
        Classification("47.59A", "Commerce de détail de meubles", Category.SUBCLASS),
        Classification("47.59B", "Commerce de détail d'autres équipements du foyer", Category.SUBCLASS),
        Classification(
            "47.6", "Commerce de détail de biens culturels et de loisirs en magasin spécialisé", Category.GROUP
        ),
        Classification("47.61", "Commerce de détail de livres en magasin spécialisé", Category.CLASS),
        Classification("47.61Z", "Commerce de détail de livres en magasin spécialisé", Category.SUBCLASS),
        Classification("47.62", "Commerce de détail de journaux et papeterie en magasin spécialisé", Category.CLASS),
        Classification(
            "47.62Z", "Commerce de détail de journaux et papeterie en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.63", "Commerce de détail d'enregistrements musicaux et vidéo en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.63Z", "Commerce de détail d'enregistrements musicaux et vidéo en magasin spécialisé", Category.SUBCLASS
        ),
        Classification("47.64", "Commerce de détail d'articles de sport en magasin spécialisé", Category.CLASS),
        Classification("47.64Z", "Commerce de détail d'articles de sport en magasin spécialisé", Category.SUBCLASS),
        Classification("47.65", "Commerce de détail de jeux et jouets en magasin spécialisé", Category.CLASS),
        Classification("47.65Z", "Commerce de détail de jeux et jouets en magasin spécialisé", Category.SUBCLASS),
        Classification("47.7", "Autres commerces de détail en magasin spécialisé", Category.GROUP),
        Classification("47.71", "Commerce de détail d'habillement en magasin spécialisé", Category.CLASS),
        Classification("47.71Z", "Commerce de détail d'habillement en magasin spécialisé", Category.SUBCLASS),
        Classification(
            "47.72", "Commerce de détail de chaussures et d'articles en cuir en magasin spécialisé", Category.CLASS
        ),
        Classification("47.72A", "Commerce de détail de la chaussure", Category.SUBCLASS),
        Classification("47.72B", "Commerce de détail de maroquinerie et d'articles de voyage", Category.SUBCLASS),
        Classification("47.73", "Commerce de détail de produits pharmaceutiques en magasin spécialisé", Category.CLASS),
        Classification(
            "47.73Z", "Commerce de détail de produits pharmaceutiques en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.74", "Commerce de détail d'articles médicaux et orthopédiques en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.74Z", "Commerce de détail d'articles médicaux et orthopédiques en magasin spécialisé", Category.SUBCLASS
        ),
        Classification(
            "47.75", "Commerce de détail de parfumerie et de produits de beauté en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.75Z",
            "Commerce de détail de parfumerie et de produits de beauté en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification(
            "47.76",
            "Commerce de détail de fleurs, plantes, graines, engrais, animaux de compagnie et aliments pour ces animaux en magasin spécialisé",
            Category.CLASS,
        ),
        Classification(
            "47.76Z",
            "Commerce de détail de fleurs, plantes, graines, engrais, animaux de compagnie et aliments pour ces animaux en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification(
            "47.77", "Commerce de détail d'articles d'horlogerie et de bijouterie en magasin spécialisé", Category.CLASS
        ),
        Classification(
            "47.77Z",
            "Commerce de détail d'articles d'horlogerie et de bijouterie en magasin spécialisé",
            Category.SUBCLASS,
        ),
        Classification("47.78", "Autre commerce de détail de biens neufs en magasin spécialisé", Category.CLASS),
        Classification("47.78A", "Commerces de détail d'optique", Category.SUBCLASS),
        Classification("47.78B", "Commerces de détail de charbons et combustibles", Category.SUBCLASS),
        Classification("47.78C", "Autres commerces de détail spécialisés divers", Category.SUBCLASS),
        Classification("47.79", "Commerce de détail de biens d'occasion en magasin", Category.CLASS),
        Classification("47.79Z", "Commerce de détail de biens d'occasion en magasin", Category.SUBCLASS),
        Classification("47.8", "Commerce de détail sur éventaires et marchés", Category.GROUP),
        Classification("47.81", "Commerce de détail alimentaire sur éventaires et marchés", Category.CLASS),
        Classification("47.81Z", "Commerce de détail alimentaire sur éventaires et marchés", Category.SUBCLASS),
        Classification(
            "47.82",
            "Commerce de détail de textiles, d'habillement et de chaussures sur éventaires et marchés",
            Category.CLASS,
        ),
        Classification(
            "47.82Z",
            "Commerce de détail de textiles, d'habillement et de chaussures sur éventaires et marchés",
            Category.SUBCLASS,
        ),
        Classification("47.89", "Autres commerces de détail sur éventaires et marchés", Category.CLASS),
        Classification("47.89Z", "Autres commerces de détail sur éventaires et marchés", Category.SUBCLASS),
        Classification("47.9", "Commerce de détail hors magasin, éventaires ou marchés", Category.GROUP),
        Classification("47.91", "Vente à distance", Category.CLASS),
        Classification("47.91A", "Vente à distance sur catalogue général", Category.SUBCLASS),
        Classification("47.91B", "Vente à distance sur catalogue spécialisé", Category.SUBCLASS),
        Classification("47.99", "Autres commerces de détail hors magasin, éventaires ou marchés", Category.CLASS),
        Classification("47.99A", "Vente à domicile", Category.SUBCLASS),
        Classification(
            "47.99B",
            "Vente par automates et autres commerces de détail hors magasin, éventaires ou marchés n.c.a.",
            Category.SUBCLASS,
        ),
        Classification("H", "TRANSPORTS ET ENTREPOSAGE", Category.SECTION),
        Classification("49", "Transports terrestres et transport par conduites", Category.DIVISION),
        Classification("49.1", "Transport ferroviaire interurbain de voyageurs", Category.GROUP),
        Classification("49.10", "Transport ferroviaire interurbain de voyageurs", Category.CLASS),
        Classification("49.10Z", "Transport ferroviaire interurbain de voyageurs", Category.SUBCLASS),
        Classification("49.2", "Transports ferroviaires de fret", Category.GROUP),
        Classification("49.20", "Transports ferroviaires de fret ", Category.CLASS),
        Classification("49.20Z", "Transports ferroviaires de fret ", Category.SUBCLASS),
        Classification("49.3", "Autres transports terrestres de voyageurs", Category.GROUP),
        Classification("49.31", "Transports urbains et suburbains de voyageurs", Category.CLASS),
        Classification("49.31Z", "Transports urbains et suburbains de voyageurs", Category.SUBCLASS),
        Classification("49.32", "Transports de voyageurs par taxis", Category.CLASS),
        Classification("49.32Z", "Transports de voyageurs par taxis", Category.SUBCLASS),
        Classification("49.39", "Autres transports terrestres de voyageurs n.c.a.", Category.CLASS),
        Classification("49.39A", "Transports routiers réguliers de voyageurs", Category.SUBCLASS),
        Classification("49.39B", "Autres transports routiers de voyageurs ", Category.SUBCLASS),
        Classification("49.39C", "Téléphériques et remontées mécaniques", Category.SUBCLASS),
        Classification("49.4", "Transports routiers de fret et services de déménagement", Category.GROUP),
        Classification("49.41", "Transports routiers de fret", Category.CLASS),
        Classification("49.41A", "Transports routiers de fret interurbains", Category.SUBCLASS),
        Classification("49.41B", "Transports routiers de fret de proximité", Category.SUBCLASS),
        Classification("49.41C", "Location de camions avec chauffeur", Category.SUBCLASS),
        Classification("49.42", "Services de déménagement", Category.CLASS),
        Classification("49.42Z", "Services de déménagement", Category.SUBCLASS),
        Classification("49.5", "Transports par conduites", Category.GROUP),
        Classification("49.50", "Transports par conduites", Category.CLASS),
        Classification("49.50Z", "Transports par conduites", Category.SUBCLASS),
        Classification("50", "Transports par eau", Category.DIVISION),
        Classification("50.1", "Transports maritimes et côtiers de passagers", Category.GROUP),
        Classification("50.10", "Transports maritimes et côtiers de passagers", Category.CLASS),
        Classification("50.10Z", "Transports maritimes et côtiers de passagers", Category.SUBCLASS),
        Classification("50.2", "Transports maritimes et côtiers de fret", Category.GROUP),
        Classification("50.20", "Transports maritimes et côtiers de fret", Category.CLASS),
        Classification("50.20Z", "Transports maritimes et côtiers de fret", Category.SUBCLASS),
        Classification("50.3", "Transports fluviaux de passagers", Category.GROUP),
        Classification("50.30", "Transports fluviaux de passagers", Category.CLASS),
        Classification("50.30Z", "Transports fluviaux de passagers", Category.SUBCLASS),
        Classification("50.4", "Transports fluviaux de fret", Category.GROUP),
        Classification("50.40", "Transports fluviaux de fret ", Category.CLASS),
        Classification("50.40Z", "Transports fluviaux de fret ", Category.SUBCLASS),
        Classification("51", "Transports aériens", Category.DIVISION),
        Classification("51.1", "Transports aériens de passagers", Category.GROUP),
        Classification("51.10", "Transports aériens de passagers", Category.CLASS),
        Classification("51.10Z", "Transports aériens de passagers", Category.SUBCLASS),
        Classification("51.2", "Transports aériens de fret et transports spatiaux", Category.GROUP),
        Classification("51.21", "Transports aériens de fret", Category.CLASS),
        Classification("51.21Z", "Transports aériens de fret", Category.SUBCLASS),
        Classification("51.22", "Transports spatiaux", Category.CLASS),
        Classification("51.22Z", "Transports spatiaux", Category.SUBCLASS),
        Classification("52", "Entreposage et services auxiliaires des transports", Category.DIVISION),
        Classification("52.1", "Entreposage et stockage", Category.GROUP),
        Classification("52.10", "Entreposage et stockage", Category.CLASS),
        Classification("52.10A", "Entreposage et stockage frigorifique", Category.SUBCLASS),
        Classification("52.10B", "Entreposage et stockage non frigorifique", Category.SUBCLASS),
        Classification("52.2", "Services auxiliaires des transports", Category.GROUP),
        Classification("52.21", "Services auxiliaires des transports terrestres", Category.CLASS),
        Classification("52.21Z", "Services auxiliaires des transports terrestres", Category.SUBCLASS),
        Classification("52.22", "Services auxiliaires des transports par eau", Category.CLASS),
        Classification("52.22Z", "Services auxiliaires des transports par eau", Category.SUBCLASS),
        Classification("52.23", "Services auxiliaires des transports aériens", Category.CLASS),
        Classification("52.23Z", "Services auxiliaires des transports aériens", Category.SUBCLASS),
        Classification("52.24", "Manutention", Category.CLASS),
        Classification("52.24A", "Manutention portuaire", Category.SUBCLASS),
        Classification("52.24B", "Manutention non portuaire", Category.SUBCLASS),
        Classification("52.29", "Autres services auxiliaires des transports ", Category.CLASS),
        Classification("52.29A", "Messagerie, fret express", Category.SUBCLASS),
        Classification("52.29B", "Affrètement et organisation des transports ", Category.SUBCLASS),
        Classification("53", "Activités de poste et de courrier", Category.DIVISION),
        Classification(
            "53.1", "Activités de poste dans le cadre d'une obligation de service universel", Category.GROUP
        ),
        Classification(
            "53.10", "Activités de poste dans le cadre d'une obligation de service universel ", Category.CLASS
        ),
        Classification(
            "53.10Z", "Activités de poste dans le cadre d'une obligation de service universel ", Category.SUBCLASS
        ),
        Classification("53.2", "Autres activités de poste et de courrier", Category.GROUP),
        Classification("53.20", "Autres activités de poste et de courrier", Category.CLASS),
        Classification("53.20Z", "Autres activités de poste et de courrier", Category.SUBCLASS),
        Classification("I", "HÉBERGEMENT ET RESTAURATION", Category.SECTION),
        Classification("55", "Hébergement", Category.DIVISION),
        Classification("55.1", "Hôtels et hébergement similaire", Category.GROUP),
        Classification("55.10", "Hôtels et hébergement similaire ", Category.CLASS),
        Classification("55.10Z", "Hôtels et hébergement similaire ", Category.SUBCLASS),
        Classification("55.2", "Hébergement touristique et autre hébergement de courte durée ", Category.GROUP),
        Classification("55.20", "Hébergement touristique et autre hébergement de courte durée ", Category.CLASS),
        Classification("55.20Z", "Hébergement touristique et autre hébergement de courte durée ", Category.SUBCLASS),
        Classification("55.3", "Terrains de camping et parcs pour caravanes ou véhicules de loisirs", Category.GROUP),
        Classification("55.30", "Terrains de camping et parcs pour caravanes ou véhicules de loisirs", Category.CLASS),
        Classification(
            "55.30Z", "Terrains de camping et parcs pour caravanes ou véhicules de loisirs", Category.SUBCLASS
        ),
        Classification("55.9", "Autres hébergements ", Category.GROUP),
        Classification("55.90", "Autres hébergements ", Category.CLASS),
        Classification("55.90Z", "Autres hébergements ", Category.SUBCLASS),
        Classification("56", "Restauration", Category.DIVISION),
        Classification("56.1", "Restaurants et services de restauration mobile", Category.GROUP),
        Classification("56.10", "Restaurants et services de restauration mobile", Category.CLASS),
        Classification("56.10A", "Restauration traditionnelle", Category.SUBCLASS),
        Classification("56.10B", "Cafétérias et autres libres-services", Category.SUBCLASS),
        Classification("56.10C", "Restauration de type rapide", Category.SUBCLASS),
        Classification("56.2", "Traiteurs et autres services de restauration", Category.GROUP),
        Classification("56.21", "Services des traiteurs ", Category.CLASS),
        Classification("56.21Z", "Services des traiteurs ", Category.SUBCLASS),
        Classification("56.29", "Autres services de restauration ", Category.CLASS),
        Classification("56.29A", "Restauration collective sous contrat", Category.SUBCLASS),
        Classification("56.29B", "Autres services de restauration n.c.a.", Category.SUBCLASS),
        Classification("56.3", "Débits de boissons", Category.GROUP),
        Classification("56.30", "Débits de boissons", Category.CLASS),
        Classification("56.30Z", "Débits de boissons", Category.SUBCLASS),
        Classification("J", "INFORMATION ET COMMUNICATION", Category.SECTION),
        Classification("58", "Édition", Category.DIVISION),
        Classification("58.1", "Édition de livres et périodiques et autres activités d'édition ", Category.GROUP),
        Classification("58.11", "Édition de livres", Category.CLASS),
        Classification("58.11Z", "Édition de livres", Category.SUBCLASS),
        Classification("58.12", "Édition de répertoires et de fichiers d'adresses", Category.CLASS),
        Classification("58.12Z", "Édition de répertoires et de fichiers d'adresses", Category.SUBCLASS),
        Classification("58.13", "Édition de journaux", Category.CLASS),
        Classification("58.13Z", "Édition de journaux", Category.SUBCLASS),
        Classification("58.14", "Édition de revues et périodiques", Category.CLASS),
        Classification("58.14Z", "Édition de revues et périodiques", Category.SUBCLASS),
        Classification("58.19", "Autres activités d'édition", Category.CLASS),
        Classification("58.19Z", "Autres activités d'édition", Category.SUBCLASS),
        Classification("58.2", "Édition de logiciels", Category.GROUP),
        Classification("58.21", "Édition de jeux électroniques", Category.CLASS),
        Classification("58.21Z", "Édition de jeux électroniques", Category.SUBCLASS),
        Classification("58.29", "Édition d'autres logiciels", Category.CLASS),
        Classification("58.29A", "Édition de logiciels système et de réseau", Category.SUBCLASS),
        Classification("58.29B", "Edition de logiciels outils de développement et de langages", Category.SUBCLASS),
        Classification("58.29C", "Edition de logiciels applicatifs", Category.SUBCLASS),
        Classification(
            "59",
            "Production de films cinématographiques, de vidéo et de programmes de télévision ; enregistrement sonore et édition musicale",
            Category.DIVISION,
        ),
        Classification("59.1", "Activités cinématographiques, vidéo et de télévision", Category.GROUP),
        Classification(
            "59.11", "Production de films cinématographiques, de vidéo et de programmes de télévision ", Category.CLASS
        ),
        Classification("59.11A", "Production de films et de programmes pour la télévision ", Category.SUBCLASS),
        Classification("59.11B", "Production de films institutionnels et publicitaires", Category.SUBCLASS),
        Classification("59.11C", "Production de films pour le cinéma", Category.SUBCLASS),
        Classification(
            "59.12",
            "Post-production de films cinématographiques, de vidéo et de programmes de télévision",
            Category.CLASS,
        ),
        Classification(
            "59.12Z",
            "Post-production de films cinématographiques, de vidéo et de programmes de télévision",
            Category.SUBCLASS,
        ),
        Classification(
            "59.13",
            "Distribution de films cinématographiques, de vidéo et de programmes de télévision ",
            Category.CLASS,
        ),
        Classification("59.13A", "Distribution de films cinématographiques", Category.SUBCLASS),
        Classification("59.13B", "Edition et distribution vidéo", Category.SUBCLASS),
        Classification("59.14", "Projection de films cinématographiques", Category.CLASS),
        Classification("59.14Z", "Projection de films cinématographiques", Category.SUBCLASS),
        Classification("59.2", "Enregistrement sonore et édition musicale", Category.GROUP),
        Classification("59.20", "Enregistrement sonore et édition musicale ", Category.CLASS),
        Classification("59.20Z", "Enregistrement sonore et édition musicale ", Category.SUBCLASS),
        Classification("60", "Programmation et diffusion", Category.DIVISION),
        Classification("60.1", "Édition et diffusion de programmes radio", Category.GROUP),
        Classification("60.10", "Édition et diffusion de programmes radio", Category.CLASS),
        Classification("60.10Z", "Édition et diffusion de programmes radio", Category.SUBCLASS),
        Classification("60.2", "Programmation de télévision et télédiffusion", Category.GROUP),
        Classification("60.20", "Programmation de télévision et télédiffusion", Category.CLASS),
        Classification("60.20A", "Edition de chaînes généralistes", Category.SUBCLASS),
        Classification("60.20B", "Edition de chaînes thématiques", Category.SUBCLASS),
        Classification("61", "Télécommunications", Category.DIVISION),
        Classification("61.1", "Télécommunications filaires", Category.GROUP),
        Classification("61.10", "Télécommunications filaires", Category.CLASS),
        Classification("61.10Z", "Télécommunications filaires", Category.SUBCLASS),
        Classification("61.2", "Télécommunications sans fil ", Category.GROUP),
        Classification("61.20", "Télécommunications sans fil ", Category.CLASS),
        Classification("61.20Z", "Télécommunications sans fil ", Category.SUBCLASS),
        Classification("61.3", "Télécommunications par satellite", Category.GROUP),
        Classification("61.30", "Télécommunications par satellite", Category.CLASS),
        Classification("61.30Z", "Télécommunications par satellite", Category.SUBCLASS),
        Classification("61.9", "Autres activités de télécommunication", Category.GROUP),
        Classification("61.90", "Autres activités de télécommunication ", Category.CLASS),
        Classification("61.90Z", "Autres activités de télécommunication ", Category.SUBCLASS),
        Classification("62", "Programmation, conseil et autres activités informatiques ", Category.DIVISION),
        Classification("62.0", "Programmation, conseil et autres activités informatiques ", Category.GROUP),
        Classification("62.01", "Programmation informatique", Category.CLASS),
        Classification("62.01Z", "Programmation informatique", Category.SUBCLASS),
        Classification("62.02", "Conseil informatique ", Category.CLASS),
        Classification("62.02A", "Conseil en systèmes et logiciels informatiques", Category.SUBCLASS),
        Classification("62.02B", "Tierce maintenance de systèmes et d’applications informatiques", Category.SUBCLASS),
        Classification("62.03", "Gestion d'installations informatiques", Category.CLASS),
        Classification("62.03Z", "Gestion d'installations informatiques", Category.SUBCLASS),
        Classification("62.09", "Autres activités informatiques", Category.CLASS),
        Classification("62.09Z", "Autres activités informatiques", Category.SUBCLASS),
        Classification("63", "Services d'information", Category.DIVISION),
        Classification(
            "63.1", "Traitement de données, hébergement et activités connexes ; portails Internet", Category.GROUP
        ),
        Classification("63.11", "Traitement de données, hébergement et activités connexes", Category.CLASS),
        Classification("63.11Z", "Traitement de données, hébergement et activités connexes", Category.SUBCLASS),
        Classification("63.12", "Portails Internet", Category.CLASS),
        Classification("63.12Z", "Portails Internet", Category.SUBCLASS),
        Classification("63.9", "Autres services d'information", Category.GROUP),
        Classification("63.91", "Activités des agences de presse", Category.CLASS),
        Classification("63.91Z", "Activités des agences de presse", Category.SUBCLASS),
        Classification("63.99", "Autres services d'information n.c.a.", Category.CLASS),
        Classification("63.99Z", "Autres services d'information n.c.a.", Category.SUBCLASS),
        Classification("K", "ACTIVITÉS FINANCIÈRES ET D'ASSURANCE", Category.SECTION),
        Classification(
            "64", "Activités des services financiers, hors assurance et caisses de retraite", Category.DIVISION
        ),
        Classification("64.1", "Intermédiation monétaire", Category.GROUP),
        Classification("64.11", "Activités de banque centrale", Category.CLASS),
        Classification("64.11Z", "Activités de banque centrale", Category.SUBCLASS),
        Classification("64.19", "Autres intermédiations monétaires", Category.CLASS),
        Classification("64.19Z", "Autres intermédiations monétaires", Category.SUBCLASS),
        Classification("64.2", "Activités des sociétés holding", Category.GROUP),
        Classification("64.20", "Activités des sociétés holding", Category.CLASS),
        Classification("64.20Z", "Activités des sociétés holding", Category.SUBCLASS),
        Classification("64.3", "Fonds de placement et entités financières similaires", Category.GROUP),
        Classification("64.30", "Fonds de placement et entités financières similaires", Category.CLASS),
        Classification("64.30Z", "Fonds de placement et entités financières similaires", Category.SUBCLASS),
        Classification(
            "64.9", "Autres activités des services financiers, hors assurance et caisses de retraite", Category.GROUP
        ),
        Classification("64.91", "Crédit-bail ", Category.CLASS),
        Classification("64.91Z", "Crédit-bail ", Category.SUBCLASS),
        Classification("64.92", "Autre distribution de crédit", Category.CLASS),
        Classification("64.92Z", "Autre distribution de crédit", Category.SUBCLASS),
        Classification(
            "64.99",
            "Autres activités des services financiers, hors assurance et caisses de retraite, n.c.a.",
            Category.CLASS,
        ),
        Classification(
            "64.99Z",
            "Autres activités des services financiers, hors assurance et caisses de retraite, n.c.a.",
            Category.SUBCLASS,
        ),
        Classification("65", "Assurance", Category.DIVISION),
        Classification("65.1", "Assurance", Category.GROUP),
        Classification("65.11", "Assurance vie ", Category.CLASS),
        Classification("65.11Z", "Assurance vie", Category.SUBCLASS),
        Classification("65.12", "Autres assurances", Category.CLASS),
        Classification("65.12Z", "Autres assurances", Category.SUBCLASS),
        Classification("65.2", "Réassurance", Category.GROUP),
        Classification("65.20", "Réassurance", Category.CLASS),
        Classification("65.20Z", "Réassurance", Category.SUBCLASS),
        Classification("65.3", "Caisses de retraite", Category.GROUP),
        Classification("65.30", "Caisses de retraite", Category.CLASS),
        Classification("65.30Z", "Caisses de retraite", Category.SUBCLASS),
        Classification("66", "Activités auxiliaires de services financiers et d'assurance ", Category.DIVISION),
        Classification(
            "66.1",
            "Activités auxiliaires de services financiers, hors assurance et caisses de retraite",
            Category.GROUP,
        ),
        Classification("66.11", "Administration de marchés financiers", Category.CLASS),
        Classification("66.11Z", "Administration de marchés financiers", Category.SUBCLASS),
        Classification("66.12", "Courtage de valeurs mobilières et de marchandises", Category.CLASS),
        Classification("66.12Z", "Courtage de valeurs mobilières et de marchandises", Category.SUBCLASS),
        Classification(
            "66.19",
            "Autres activités auxiliaires de services financiers, hors assurance et caisses de retraite",
            Category.CLASS,
        ),
        Classification("66.19A", "Supports juridiques de gestion de patrimoine mobilier", Category.SUBCLASS),
        Classification(
            "66.19B",
            "Autres activités auxiliaires de services financiers, hors assurance et caisses de retraite, n.c.a.",
            Category.SUBCLASS,
        ),
        Classification("66.2", "Activités auxiliaires d'assurance et de caisses de retraite", Category.GROUP),
        Classification("66.21", "Évaluation des risques et dommages", Category.CLASS),
        Classification("66.21Z", "Évaluation des risques et dommages", Category.SUBCLASS),
        Classification("66.22", "Activités des agents et courtiers d'assurances", Category.CLASS),
        Classification("66.22Z", "Activités des agents et courtiers d'assurances", Category.SUBCLASS),
        Classification("66.29", "Autres activités auxiliaires d'assurance et de caisses de retraite", Category.CLASS),
        Classification(
            "66.29Z", "Autres activités auxiliaires d'assurance et de caisses de retraite", Category.SUBCLASS
        ),
        Classification("66.3", "Gestion de fonds", Category.GROUP),
        Classification("66.30", "Gestion de fonds", Category.CLASS),
        Classification("66.30Z", "Gestion de fonds", Category.SUBCLASS),
        Classification("L", "ACTIVITÉS IMMOBILIÈRES", Category.SECTION),
        Classification("68", "Activités immobilières", Category.DIVISION),
        Classification("68.1", "Activités des marchands de biens immobiliers", Category.GROUP),
        Classification("68.10", "Activités des marchands de biens immobiliers", Category.CLASS),
        Classification("68.10Z", "Activités des marchands de biens immobiliers", Category.SUBCLASS),
        Classification("68.2", "Location et exploitation de biens immobiliers propres ou loués", Category.GROUP),
        Classification("68.20", "Location et exploitation de biens immobiliers propres ou loués ", Category.CLASS),
        Classification("68.20A", "Location de logements", Category.SUBCLASS),
        Classification("68.20B", "Location de terrains et d'autres biens immobiliers", Category.SUBCLASS),
        Classification("68.3", "Activités immobilières pour compte de tiers", Category.GROUP),
        Classification("68.31", "Agences immobilières", Category.CLASS),
        Classification("68.31Z", "Agences immobilières", Category.SUBCLASS),
        Classification("68.32", "Administration de biens immobiliers", Category.CLASS),
        Classification("68.32A", "Administration d'immeubles et autres biens immobiliers", Category.SUBCLASS),
        Classification("68.32B", "Supports juridiques de gestion de patrimoine immobilier", Category.SUBCLASS),
        Classification("M", "ACTIVITÉS SPÉCIALISÉES, SCIENTIFIQUES ET TECHNIQUES", Category.SECTION),
        Classification("69", "Activités juridiques et comptables", Category.DIVISION),
        Classification("69.1", "Activités juridiques", Category.GROUP),
        Classification("69.10", "Activités juridiques", Category.CLASS),
        Classification("69.10Z", "Activités juridiques", Category.SUBCLASS),
        Classification("69.2", "Activités comptables", Category.GROUP),
        Classification("69.20", "Activités comptables", Category.CLASS),
        Classification("69.20Z", "Activités comptables", Category.SUBCLASS),
        Classification("70", "Activités des sièges sociaux ; conseil de gestion", Category.DIVISION),
        Classification("70.1", "Activités des sièges sociaux", Category.GROUP),
        Classification("70.10", "Activités des sièges sociaux", Category.CLASS),
        Classification("70.10Z", "Activités des sièges sociaux", Category.SUBCLASS),
        Classification("70.2", "Conseil de gestion", Category.GROUP),
        Classification("70.21", "Conseil en relations publiques et communication", Category.CLASS),
        Classification("70.21Z", "Conseil en relations publiques et communication", Category.SUBCLASS),
        Classification("70.22", "Conseil pour les affaires et autres conseils de gestion", Category.CLASS),
        Classification("70.22Z", "Conseil pour les affaires et autres conseils de gestion", Category.SUBCLASS),
        Classification(
            "71",
            "Activités d'architecture et d'ingénierie ; activités de contrôle et analyses techniques",
            Category.DIVISION,
        ),
        Classification("71.1", "Activités d'architecture et d'ingénierie", Category.GROUP),
        Classification("71.11", "Activités d'architecture ", Category.CLASS),
        Classification("71.11Z", "Activités d'architecture ", Category.SUBCLASS),
        Classification("71.12", "Activités d'ingénierie", Category.CLASS),
        Classification("71.12A", "Activité des géomètres", Category.SUBCLASS),
        Classification("71.12B", "Ingénierie, études techniques", Category.SUBCLASS),
        Classification("71.2", "Activités de contrôle et analyses techniques", Category.GROUP),
        Classification("71.20", "Activités de contrôle et analyses techniques", Category.CLASS),
        Classification("71.20A", "Contrôle technique automobile", Category.SUBCLASS),
        Classification("71.20B", "Analyses, essais et inspections techniques", Category.SUBCLASS),
        Classification("72", "Recherche-développement scientifique", Category.DIVISION),
        Classification("72.1", "Recherche-développement en sciences physiques et naturelles", Category.GROUP),
        Classification("72.11", "Recherche-développement en biotechnologie", Category.CLASS),
        Classification("72.11Z", "Recherche-développement en biotechnologie", Category.SUBCLASS),
        Classification("72.19", "Recherche-développement en autres sciences physiques et naturelles", Category.CLASS),
        Classification(
            "72.19Z", "Recherche-développement en autres sciences physiques et naturelles", Category.SUBCLASS
        ),
        Classification("72.2", "Recherche-développement en sciences humaines et sociales", Category.GROUP),
        Classification("72.20", "Recherche-développement en sciences humaines et sociales", Category.CLASS),
        Classification("72.20Z", "Recherche-développement en sciences humaines et sociales", Category.SUBCLASS),
        Classification("73", "Publicité et études de marché", Category.DIVISION),
        Classification("73.1", "Publicité", Category.GROUP),
        Classification("73.11", "Activités des agences de publicité", Category.CLASS),
        Classification("73.11Z", "Activités des agences de publicité", Category.SUBCLASS),
        Classification("73.12", "Régie publicitaire de médias", Category.CLASS),
        Classification("73.12Z", "Régie publicitaire de médias", Category.SUBCLASS),
        Classification("73.2", "Études de marché et sondages", Category.GROUP),
        Classification("73.20", "Études de marché et sondages", Category.CLASS),
        Classification("73.20Z", "Études de marché et sondages", Category.SUBCLASS),
        Classification("74", "Autres activités spécialisées, scientifiques et techniques", Category.DIVISION),
        Classification("74.1", "Activités spécialisées de design", Category.GROUP),
        Classification("74.10", "Activités spécialisées de design", Category.CLASS),
        Classification("74.10Z", "Activités spécialisées de design", Category.SUBCLASS),
        Classification("74.2", "Activités photographiques", Category.GROUP),
        Classification("74.20", "Activités photographiques", Category.CLASS),
        Classification("74.20Z", "Activités photographiques", Category.SUBCLASS),
        Classification("74.3", "Traduction et interprétation", Category.GROUP),
        Classification("74.30", "Traduction et interprétation", Category.CLASS),
        Classification("74.30Z", "Traduction et interprétation", Category.SUBCLASS),
        Classification("74.9", "Autres activités spécialisées, scientifiques et techniques n.c.a.", Category.GROUP),
        Classification("74.90", "Autres activités spécialisées, scientifiques et techniques n.c.a.", Category.CLASS),
        Classification("74.90A", "Activité des économistes de la construction", Category.SUBCLASS),
        Classification("74.90B", "Activités spécialisées, scientifiques et techniques diverses", Category.SUBCLASS),
        Classification("75", "Activités vétérinaires", Category.DIVISION),
        Classification("75.0", "Activités vétérinaires", Category.GROUP),
        Classification("75.00", "Activités vétérinaires", Category.CLASS),
        Classification("75.00Z", "Activités vétérinaires", Category.SUBCLASS),
        Classification("N", "ACTIVITÉS DE SERVICES ADMINISTRATIFS ET DE SOUTIEN", Category.SECTION),
        Classification("77", "Activités de location et location-bail", Category.DIVISION),
        Classification("77.1", "Location et location-bail de véhicules automobiles", Category.GROUP),
        Classification(
            "77.11", "Location et location-bail de voitures et de véhicules automobiles légers", Category.CLASS
        ),
        Classification(
            "77.11A", "Location de courte durée de voitures et de véhicules automobiles légers", Category.SUBCLASS
        ),
        Classification(
            "77.11B", "Location de longue durée de voitures et de véhicules automobiles légers", Category.SUBCLASS
        ),
        Classification("77.12", "Location et location-bail de camions", Category.CLASS),
        Classification("77.12Z", "Location et location-bail de camions", Category.SUBCLASS),
        Classification("77.2", "Location et location-bail de biens personnels et domestiques", Category.GROUP),
        Classification("77.21", "Location et location-bail d'articles de loisirs et de sport ", Category.CLASS),
        Classification("77.21Z", "Location et location-bail d'articles de loisirs et de sport ", Category.SUBCLASS),
        Classification("77.22", "Location de vidéocassettes et disques vidéo", Category.CLASS),
        Classification("77.22Z", "Location de vidéocassettes et disques vidéo", Category.SUBCLASS),
        Classification("77.29", "Location et location-bail d'autres biens personnels et domestiques", Category.CLASS),
        Classification(
            "77.29Z", "Location et location-bail d'autres biens personnels et domestiques", Category.SUBCLASS
        ),
        Classification("77.3", "Location et location-bail d'autres machines, équipements et biens", Category.GROUP),
        Classification("77.31", "Location et location-bail de machines et équipements agricoles", Category.CLASS),
        Classification("77.31Z", "Location et location-bail de machines et équipements agricoles", Category.SUBCLASS),
        Classification(
            "77.32", "Location et location-bail de machines et équipements pour la construction", Category.CLASS
        ),
        Classification(
            "77.32Z", "Location et location-bail de machines et équipements pour la construction", Category.SUBCLASS
        ),
        Classification(
            "77.33", "Location et location-bail de machines de bureau et de matériel informatique", Category.CLASS
        ),
        Classification(
            "77.33Z", "Location et location-bail de machines de bureau et de matériel informatique", Category.SUBCLASS
        ),
        Classification("77.34", "Location et location-bail de matériels de transport par eau", Category.CLASS),
        Classification("77.34Z", "Location et location-bail de matériels de transport par eau", Category.SUBCLASS),
        Classification("77.35", "Location et location-bail de matériels de transport aérien", Category.CLASS),
        Classification("77.35Z", "Location et location-bail de matériels de transport aérien", Category.SUBCLASS),
        Classification(
            "77.39",
            "Location et location-bail d'autres machines, équipements et biens matériels n.c.a. ",
            Category.CLASS,
        ),
        Classification(
            "77.39Z",
            "Location et location-bail d'autres machines, équipements et biens matériels n.c.a. ",
            Category.SUBCLASS,
        ),
        Classification(
            "77.4",
            "Location-bail de propriété intellectuelle et de produits similaires, à l'exception des œuvres soumises à copyright",
            Category.GROUP,
        ),
        Classification(
            "77.40",
            "Location-bail de propriété intellectuelle et de produits similaires, à l'exception des œuvres soumises à copyright",
            Category.CLASS,
        ),
        Classification(
            "77.40Z",
            "Location-bail de propriété intellectuelle et de produits similaires, à l'exception des œuvres soumises à copyright",
            Category.SUBCLASS,
        ),
        Classification("78", "Activités liées à l'emploi", Category.DIVISION),
        Classification("78.1", "Activités des agences de placement de main-d'œuvre", Category.GROUP),
        Classification("78.10", "Activités des agences de placement de main-d'œuvre ", Category.CLASS),
        Classification("78.10Z", "Activités des agences de placement de main-d'œuvre ", Category.SUBCLASS),
        Classification("78.2", "Activités des agences de travail temporaire", Category.GROUP),
        Classification("78.20", "Activités des agences de travail temporaire ", Category.CLASS),
        Classification("78.20Z", "Activités des agences de travail temporaire ", Category.SUBCLASS),
        Classification("78.3", "Autre mise à disposition de ressources humaines", Category.GROUP),
        Classification("78.30", "Autre mise à disposition de ressources humaines", Category.CLASS),
        Classification("78.30Z", "Autre mise à disposition de ressources humaines", Category.SUBCLASS),
        Classification(
            "79",
            "Activités des agences de voyage, voyagistes, services de réservation et activités connexes",
            Category.DIVISION,
        ),
        Classification("79.1", "Activités des agences de voyage et voyagistes", Category.GROUP),
        Classification("79.11", "Activités des agences de voyage", Category.CLASS),
        Classification("79.11Z", "Activités des agences de voyage", Category.SUBCLASS),
        Classification("79.12", "Activités des voyagistes", Category.CLASS),
        Classification("79.12Z", "Activités des voyagistes", Category.SUBCLASS),
        Classification("79.9", "Autres services de réservation et activités connexes", Category.GROUP),
        Classification("79.90", "Autres services de réservation et activités connexes", Category.CLASS),
        Classification("79.90Z", "Autres services de réservation et activités connexes", Category.SUBCLASS),
        Classification("80", "Enquêtes et sécurité", Category.DIVISION),
        Classification("80.1", "Activités de sécurité privée", Category.GROUP),
        Classification("80.10", "Activités de sécurité privée ", Category.CLASS),
        Classification("80.10Z", "Activités de sécurité privée ", Category.SUBCLASS),
        Classification("80.2", "Activités liées aux systèmes de sécurité", Category.GROUP),
        Classification("80.20", "Activités liées aux systèmes de sécurité ", Category.CLASS),
        Classification("80.20Z", "Activités liées aux systèmes de sécurité ", Category.SUBCLASS),
        Classification("80.3", "Activités d'enquête", Category.GROUP),
        Classification("80.30", "Activités d'enquête", Category.CLASS),
        Classification("80.30Z", "Activités d'enquête", Category.SUBCLASS),
        Classification("81", "Services relatifs aux bâtiments et aménagement paysager", Category.DIVISION),
        Classification("81.1", "Activités combinées de soutien lié aux bâtiments", Category.GROUP),
        Classification("81.10", "Activités combinées de soutien lié aux bâtiments ", Category.CLASS),
        Classification("81.10Z", "Activités combinées de soutien lié aux bâtiments ", Category.SUBCLASS),
        Classification("81.2", "Activités de nettoyage", Category.GROUP),
        Classification("81.21", "Nettoyage courant des bâtiments", Category.CLASS),
        Classification("81.21Z", "Nettoyage courant des bâtiments", Category.SUBCLASS),
        Classification("81.22", "Autres activités de nettoyage des bâtiments et nettoyage industriel", Category.CLASS),
        Classification(
            "81.22Z", "Autres activités de nettoyage des bâtiments et nettoyage industriel", Category.SUBCLASS
        ),
        Classification("81.29", "Autres activités de nettoyage", Category.CLASS),
        Classification("81.29A", "Désinfection, désinsectisation, dératisation", Category.SUBCLASS),
        Classification("81.29B", "Autres activités de nettoyage n.c.a.", Category.SUBCLASS),
        Classification("81.3", "Services d'aménagement paysager", Category.GROUP),
        Classification("81.30", "Services d'aménagement paysager ", Category.CLASS),
        Classification("81.30Z", "Services d'aménagement paysager ", Category.SUBCLASS),
        Classification(
            "82", "Activités administratives et autres activités de soutien aux entreprises", Category.DIVISION
        ),
        Classification("82.1", "Activités administratives ", Category.GROUP),
        Classification("82.11", "Services administratifs combinés de bureau", Category.CLASS),
        Classification("82.11Z", "Services administratifs combinés de bureau", Category.SUBCLASS),
        Classification(
            "82.19",
            "Photocopie, préparation de documents et autres activités spécialisées de soutien de bureau",
            Category.CLASS,
        ),
        Classification(
            "82.19Z",
            "Photocopie, préparation de documents et autres activités spécialisées de soutien de bureau",
            Category.SUBCLASS,
        ),
        Classification("82.2", "Activités de centres d'appels", Category.GROUP),
        Classification("82.20", "Activités de centres d'appels", Category.CLASS),
        Classification("82.20Z", "Activités de centres d'appels", Category.SUBCLASS),
        Classification("82.3", "Organisation de salons professionnels et congrès", Category.GROUP),
        Classification("82.30", "Organisation de salons professionnels et congrès", Category.CLASS),
        Classification("82.30Z", "Organisation de foires, salons professionnels et congrès", Category.SUBCLASS),
        Classification("82.9", "Activités de soutien aux entreprises n.c.a.", Category.GROUP),
        Classification(
            "82.91",
            "Activités des agences de recouvrement de factures et des sociétés d'information financière sur la clientèle",
            Category.CLASS,
        ),
        Classification(
            "82.91Z",
            "Activités des agences de recouvrement de factures et des sociétés d'information financière sur la clientèle",
            Category.SUBCLASS,
        ),
        Classification("82.92", "Activités de conditionnement", Category.CLASS),
        Classification("82.92Z", "Activités de conditionnement", Category.SUBCLASS),
        Classification("82.99", "Autres activités de soutien aux entreprises n.c.a.", Category.CLASS),
        Classification("82.99Z", "Autres activités de soutien aux entreprises n.c.a.", Category.SUBCLASS),
        Classification("O", "ADMINISTRATION PUBLIQUE ", Category.SECTION),
        Classification("84", "Administration publique et défense ; sécurité sociale obligatoire", Category.DIVISION),
        Classification("84.1", "Administration générale, économique et sociale", Category.GROUP),
        Classification("84.11", "Administration publique générale", Category.CLASS),
        Classification("84.11Z", "Administration publique générale", Category.SUBCLASS),
        Classification(
            "84.12",
            "Administration publique (tutelle) de la santé, de la formation, de la culture et des services sociaux, autre que sécurité sociale ",
            Category.CLASS,
        ),
        Classification(
            "84.12Z",
            "Administration publique (tutelle) de la santé, de la formation, de la culture et des services sociaux, autre que sécurité sociale ",
            Category.SUBCLASS,
        ),
        Classification("84.13", "Administration publique (tutelle) des activités économiques", Category.CLASS),
        Classification("84.13Z", "Administration publique (tutelle) des activités économiques", Category.SUBCLASS),
        Classification("84.2", "Services de prérogative publique", Category.GROUP),
        Classification("84.21", "Affaires étrangères", Category.CLASS),
        Classification("84.21Z", "Affaires étrangères", Category.SUBCLASS),
        Classification("84.22", "Défense", Category.CLASS),
        Classification("84.22Z", "Défense", Category.SUBCLASS),
        Classification("84.23", "Justice", Category.CLASS),
        Classification("84.23Z", "Justice", Category.SUBCLASS),
        Classification("84.24", "Activités d’ordre public et de sécurité", Category.CLASS),
        Classification("84.24Z", "Activités d’ordre public et de sécurité", Category.SUBCLASS),
        Classification("84.25", "Services du feu et de secours", Category.CLASS),
        Classification("84.25Z", "Services du feu et de secours", Category.SUBCLASS),
        Classification("84.3", "Sécurité sociale obligatoire", Category.GROUP),
        Classification("84.30", "Sécurité sociale obligatoire", Category.CLASS),
        Classification("84.30A", "Activités générales de sécurité sociale", Category.SUBCLASS),
        Classification("84.30B", "Gestion des retraites complémentaires", Category.SUBCLASS),
        Classification("84.30C", "Distribution sociale de revenus", Category.SUBCLASS),
        Classification("P", "ENSEIGNEMENT", Category.SECTION),
        Classification("85", "Enseignement", Category.DIVISION),
        Classification("85.1", "Enseignement pré-primaire", Category.GROUP),
        Classification("85.10", "Enseignement pré-primaire", Category.CLASS),
        Classification("85.10Z", "Enseignement pré-primaire", Category.SUBCLASS),
        Classification("85.2", "Enseignement primaire", Category.GROUP),
        Classification("85.20", "Enseignement primaire", Category.CLASS),
        Classification("85.20Z", "Enseignement primaire", Category.SUBCLASS),
        Classification("85.3", "Enseignement secondaire", Category.GROUP),
        Classification("85.31", "Enseignement secondaire général", Category.CLASS),
        Classification("85.31Z", "Enseignement secondaire général", Category.SUBCLASS),
        Classification("85.32", "Enseignement secondaire technique ou professionnel", Category.CLASS),
        Classification("85.32Z", "Enseignement secondaire technique ou professionnel", Category.SUBCLASS),
        Classification("85.4", "Enseignement supérieur et post-secondaire non supérieur", Category.GROUP),
        Classification("85.41", "Enseignement post-secondaire non supérieur", Category.CLASS),
        Classification("85.41Z", "Enseignement post-secondaire non supérieur", Category.SUBCLASS),
        Classification("85.42", "Enseignement supérieur", Category.CLASS),
        Classification("85.42Z", "Enseignement supérieur", Category.SUBCLASS),
        Classification("85.5", "Autres activités d'enseignement", Category.GROUP),
        Classification("85.51", "Enseignement de disciplines sportives et d'activités de loisirs", Category.CLASS),
        Classification("85.51Z", "Enseignement de disciplines sportives et d'activités de loisirs", Category.SUBCLASS),
        Classification("85.52", "Enseignement culturel", Category.CLASS),
        Classification("85.52Z", "Enseignement culturel", Category.SUBCLASS),
        Classification("85.53", "Enseignement de la conduite", Category.CLASS),
        Classification("85.53Z", "Enseignement de la conduite", Category.SUBCLASS),
        Classification("85.59", "Enseignements divers", Category.CLASS),
        Classification("85.59A", "Formation continue d'adultes", Category.SUBCLASS),
        Classification("85.59B", "Autres enseignements", Category.SUBCLASS),
        Classification("85.6", "Activités de soutien à l'enseignement", Category.GROUP),
        Classification("85.60", "Activités de soutien à l'enseignement", Category.CLASS),
        Classification("85.60Z", "Activités de soutien à l'enseignement", Category.SUBCLASS),
        Classification("Q", "SANTÉ HUMAINE ET ACTION SOCIALE", Category.SECTION),
        Classification("86", "Activités pour la santé humaine", Category.DIVISION),
        Classification("86.1", "Activités hospitalières", Category.GROUP),
        Classification("86.10", "Activités hospitalières", Category.CLASS),
        Classification("86.10Z", "Activités hospitalières", Category.SUBCLASS),
        Classification("86.2", "Activité des médecins et des dentistes", Category.GROUP),
        Classification("86.21", "Activité des médecins généralistes", Category.CLASS),
        Classification("86.21Z", "Activité des médecins généralistes", Category.SUBCLASS),
        Classification("86.22", "Activité des médecins spécialistes", Category.CLASS),
        Classification("86.22A", "Activités de radiodiagnostic et de radiothérapie", Category.SUBCLASS),
        Classification("86.22B", "Activités chirurgicales", Category.SUBCLASS),
        Classification("86.22C", "Autres activités des médecins spécialistes", Category.SUBCLASS),
        Classification("86.23", "Pratique dentaire", Category.CLASS),
        Classification("86.23Z", "Pratique dentaire", Category.SUBCLASS),
        Classification("86.9", "Autres activités pour la santé humaine", Category.GROUP),
        Classification("86.90", "Autres activités pour la santé humaine", Category.CLASS),
        Classification("86.90A", "Ambulances", Category.SUBCLASS),
        Classification("86.90B", "Laboratoires d'analyses médicales", Category.SUBCLASS),
        Classification("86.90C", "Centres de collecte et banques d'organes", Category.SUBCLASS),
        Classification("86.90D", "Activités des infirmiers et des sages-femmes", Category.SUBCLASS),
        Classification(
            "86.90E",
            "Activités des professionnels de la rééducation, de l’appareillage et des pédicures-podologues",
            Category.SUBCLASS,
        ),
        Classification("86.90F", "Activités de santé humaine non classées ailleurs", Category.SUBCLASS),
        Classification("87", "Hébergement médico-social et social", Category.DIVISION),
        Classification("87.1", "Hébergement médicalisé", Category.GROUP),
        Classification("87.10", "Hébergement médicalisé", Category.CLASS),
        Classification("87.10A", "Hébergement médicalisé pour personnes âgées", Category.SUBCLASS),
        Classification("87.10B", "Hébergement médicalisé pour enfants handicapés ", Category.SUBCLASS),
        Classification(
            "87.10C",
            "Hébergement médicalisé pour adultes handicapés et autre hébergement médicalisé",
            Category.SUBCLASS,
        ),
        Classification(
            "87.2",
            "Hébergement social pour personnes handicapées mentales, malades mentales et toxicomanes",
            Category.GROUP,
        ),
        Classification(
            "87.20",
            "Hébergement social pour personnes handicapées mentales, malades mentales et toxicomanes",
            Category.CLASS,
        ),
        Classification("87.20A", "Hébergement social pour handicapés mentaux et malades mentaux ", Category.SUBCLASS),
        Classification("87.20B", "Hébergement social pour toxicomanes", Category.SUBCLASS),
        Classification("87.3", "Hébergement social pour personnes âgées ou handicapées physiques ", Category.GROUP),
        Classification("87.30", "Hébergement social pour personnes âgées ou handicapées physiques ", Category.CLASS),
        Classification("87.30A", "Hébergement social pour personnes âgées", Category.SUBCLASS),
        Classification("87.30B", "Hébergement social pour handicapés  physiques", Category.SUBCLASS),
        Classification("87.9", "Autres activités d’hébergement social ", Category.GROUP),
        Classification("87.90", "Autres activités d’hébergement social ", Category.CLASS),
        Classification("87.90A", "Hébergement social pour enfants en difficultés ", Category.SUBCLASS),
        Classification(
            "87.90B",
            "Hébergement social pour adultes et familles en difficultés et autre hébergement social ",
            Category.SUBCLASS,
        ),
        Classification("88", "Action sociale sans hébergement", Category.DIVISION),
        Classification(
            "88.1",
            "Action sociale sans hébergement pour personnes âgées et pour personnes handicapées ",
            Category.GROUP,
        ),
        Classification(
            "88.10",
            "Action sociale sans hébergement pour personnes âgées et pour personnes handicapées ",
            Category.CLASS,
        ),
        Classification("88.10A", "Aide à domicile  ", Category.SUBCLASS),
        Classification(
            "88.10B",
            "Accueil ou accompagnement sans hébergement d’adultes handicapés ou de  personnes âgées",
            Category.SUBCLASS,
        ),
        Classification("88.10C", "Aide par le travail ", Category.SUBCLASS),
        Classification("88.9", "Autre action sociale sans hébergement", Category.GROUP),
        Classification("88.91", "Action sociale sans hébergement pour jeunes enfants", Category.CLASS),
        Classification("88.91A", "Accueil de jeunes enfants", Category.SUBCLASS),
        Classification("88.91B", "Accueil ou accompagnement sans hébergement d’enfants handicapés", Category.SUBCLASS),
        Classification("88.99", "Autre action sociale sans hébergement n.c.a.", Category.CLASS),
        Classification(
            "88.99A", "Autre accueil ou accompagnement sans hébergement d’enfants et d’adolescents", Category.SUBCLASS
        ),
        Classification("88.99B", "Action sociale sans hébergement n.c.a.", Category.SUBCLASS),
        Classification("R", "ARTS, SPECTACLES ET ACTIVITÉS RÉCRÉATIVES", Category.SECTION),
        Classification("90", "Activités créatives, artistiques et de spectacle ", Category.DIVISION),
        Classification("90.0", "Activités créatives, artistiques et de spectacle ", Category.GROUP),
        Classification("90.01", "Arts du spectacle vivant", Category.CLASS),
        Classification("90.01Z", "Arts du spectacle vivant", Category.SUBCLASS),
        Classification("90.02", "Activités de soutien au spectacle vivant", Category.CLASS),
        Classification("90.02Z", "Activités de soutien au spectacle vivant", Category.SUBCLASS),
        Classification("90.03", "Création artistique", Category.CLASS),
        Classification("90.03A", "Création artistique relevant des arts plastiques", Category.SUBCLASS),
        Classification("90.03B", "Autre création artistique", Category.SUBCLASS),
        Classification("90.04", "Gestion de salles de spectacles", Category.CLASS),
        Classification("90.04Z", "Gestion de salles de spectacles", Category.SUBCLASS),
        Classification("91", "Bibliothèques, archives, musées et autres activités culturelles", Category.DIVISION),
        Classification("91.0", "Bibliothèques, archives, musées et autres activités culturelles", Category.GROUP),
        Classification("91.01", "Gestion des bibliothèques et des archives", Category.CLASS),
        Classification("91.01Z", "Gestion des bibliothèques et des archives", Category.SUBCLASS),
        Classification("91.02", "Gestion des musées", Category.CLASS),
        Classification("91.02Z", "Gestion des musées", Category.SUBCLASS),
        Classification(
            "91.03",
            "Gestion des sites et monuments historiques et des attractions touristiques similaires",
            Category.CLASS,
        ),
        Classification(
            "91.03Z",
            "Gestion des sites et monuments historiques et des attractions touristiques similaires",
            Category.SUBCLASS,
        ),
        Classification(
            "91.04", "Gestion des jardins botaniques et zoologiques et des réserves naturelles", Category.CLASS
        ),
        Classification(
            "91.04Z", "Gestion des jardins botaniques et zoologiques et des réserves naturelles", Category.SUBCLASS
        ),
        Classification("92", "Organisation de jeux de hasard et d'argent", Category.DIVISION),
        Classification("92.0", "Organisation de jeux de hasard et d'argent", Category.GROUP),
        Classification("92.00", "Organisation de jeux de hasard et d'argent", Category.CLASS),
        Classification("92.00Z", "Organisation de jeux de hasard et d'argent", Category.SUBCLASS),
        Classification("93", "Activités sportives, récréatives et de loisirs", Category.DIVISION),
        Classification("93.1", "Activités liées au sport", Category.GROUP),
        Classification("93.11", "Gestion d'installations sportives", Category.CLASS),
        Classification("93.11Z", "Gestion d'installations sportives", Category.SUBCLASS),
        Classification("93.12", "Activités de clubs de sports", Category.CLASS),
        Classification("93.12Z", "Activités de clubs de sports", Category.SUBCLASS),
        Classification("93.13", "Activités des centres de culture physique", Category.CLASS),
        Classification("93.13Z", "Activités des centres de culture physique", Category.SUBCLASS),
        Classification("93.19", "Autres activités liées au sport", Category.CLASS),
        Classification("93.19Z", "Autres activités liées au sport", Category.SUBCLASS),
        Classification("93.2", "Activités récréatives et de loisirs", Category.GROUP),
        Classification("93.21", "Activités des parcs d'attractions et parcs à thèmes", Category.CLASS),
        Classification("93.21Z", "Activités des parcs d'attractions et parcs à thèmes", Category.SUBCLASS),
        Classification("93.29", "Autres activités récréatives et de loisirs ", Category.CLASS),
        Classification("93.29Z", "Autres activités récréatives et de loisirs", Category.SUBCLASS),
        Classification("S", "AUTRES ACTIVITÉS DE SERVICES", Category.SECTION),
        Classification("94", "Activités des organisations associatives", Category.DIVISION),
        Classification(
            "94.1", "Activités des organisations économiques, patronales et professionnelles", Category.GROUP
        ),
        Classification("94.11", "Activités des organisations patronales et consulaires", Category.CLASS),
        Classification("94.11Z", "Activités des organisations patronales et consulaires", Category.SUBCLASS),
        Classification("94.12", "Activités des organisations professionnelles", Category.CLASS),
        Classification("94.12Z", "Activités des organisations professionnelles", Category.SUBCLASS),
        Classification("94.2", "Activités des syndicats de salariés", Category.GROUP),
        Classification("94.20", "Activités des syndicats de salariés", Category.CLASS),
        Classification("94.20Z", "Activités des syndicats de salariés", Category.SUBCLASS),
        Classification("94.9", "Activités des autres organisations associatives", Category.GROUP),
        Classification("94.91", "Activités des organisations religieuses", Category.CLASS),
        Classification("94.91Z", "Activités des organisations religieuses", Category.SUBCLASS),
        Classification("94.92", "Activités des organisations politiques", Category.CLASS),
        Classification("94.92Z", "Activités des organisations politiques", Category.SUBCLASS),
        Classification("94.99", "Activités des organisations associatives n.c.a.", Category.CLASS),
        Classification("94.99Z", "Autres organisations fonctionnant par adhésion volontaire", Category.SUBCLASS),
        Classification("95", "Réparation d'ordinateurs et de biens personnels et domestiques", Category.DIVISION),
        Classification("95.1", "Réparation d'ordinateurs et d'équipements de communication ", Category.GROUP),
        Classification("95.11", "Réparation d'ordinateurs et d'équipements périphériques", Category.CLASS),
        Classification("95.11Z", "Réparation d'ordinateurs et d'équipements périphériques", Category.SUBCLASS),
        Classification("95.12", "Réparation d'équipements de communication", Category.CLASS),
        Classification("95.12Z", "Réparation d'équipements de communication", Category.SUBCLASS),
        Classification("95.2", "Réparation de biens personnels et domestiques", Category.GROUP),
        Classification("95.21", "Réparation de produits électroniques grand public", Category.CLASS),
        Classification("95.21Z", "Réparation de produits électroniques grand public", Category.SUBCLASS),
        Classification(
            "95.22",
            "Réparation d'appareils électroménagers et d'équipements pour la maison et le jardin",
            Category.CLASS,
        ),
        Classification(
            "95.22Z",
            "Réparation d'appareils électroménagers et d'équipements pour la maison et le jardin",
            Category.SUBCLASS,
        ),
        Classification("95.23", "Réparation de chaussures et d'articles en cuir", Category.CLASS),
        Classification("95.23Z", "Réparation de chaussures et d'articles en cuir", Category.SUBCLASS),
        Classification("95.24", "Réparation de meubles et d'équipements du foyer", Category.CLASS),
        Classification("95.24Z", "Réparation de meubles et d'équipements du foyer", Category.SUBCLASS),
        Classification("95.25", "Réparation d'articles d'horlogerie et de bijouterie", Category.CLASS),
        Classification("95.25Z", "Réparation d'articles d'horlogerie et de bijouterie", Category.SUBCLASS),
        Classification("95.29", "Réparation d'autres biens personnels et domestiques", Category.CLASS),
        Classification("95.29Z", "Réparation d'autres biens personnels et domestiques", Category.SUBCLASS),
        Classification("96", "Autres services personnels", Category.DIVISION),
        Classification("96.0", "Autres services personnels", Category.GROUP),
        Classification("96.01", "Blanchisserie-teinturerie", Category.CLASS),
        Classification("96.01A", "Blanchisserie-teinturerie de gros", Category.SUBCLASS),
        Classification("96.01B", "Blanchisserie-teinturerie de détail", Category.SUBCLASS),
        Classification("96.02", "Coiffure et soins de beauté", Category.CLASS),
        Classification("96.02A", "Coiffure", Category.SUBCLASS),
        Classification("96.02B", "Soins de beauté", Category.SUBCLASS),
        Classification("96.03", "Services funéraires", Category.CLASS),
        Classification("96.03Z", "Services funéraires", Category.SUBCLASS),
        Classification("96.04", "Entretien corporel", Category.CLASS),
        Classification("96.04Z", "Entretien corporel", Category.SUBCLASS),
        Classification("96.09", "Autres services personnels n.c.a.", Category.CLASS),
        Classification("96.09Z", "Autres services personnels n.c.a.", Category.SUBCLASS),
        Classification(
            "T",
            "ACTIVITÉS DES MÉNAGES EN TANT QU'EMPLOYEURS ; ACTIVITÉS INDIFFÉRENCIÉES DES MÉNAGES EN TANT QUE PRODUCTEURS DE BIENS ET SERVICES POUR USAGE PROPRE",
            Category.SECTION,
        ),
        Classification("97", "Activités des ménages en tant qu'employeurs de personnel domestique", Category.DIVISION),
        Classification("97.0", "Activités des ménages en tant qu'employeurs de personnel domestique", Category.GROUP),
        Classification("97.00", "Activités des ménages en tant qu'employeurs de personnel domestique", Category.CLASS),
        Classification(
            "97.00Z", "Activités des ménages en tant qu'employeurs de personnel domestique", Category.SUBCLASS
        ),
        Classification(
            "98",
            "Activités indifférenciées des ménages en tant que producteurs de biens et services pour usage propre",
            Category.DIVISION,
        ),
        Classification(
            "98.1",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.GROUP,
        ),
        Classification(
            "98.10",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.CLASS,
        ),
        Classification(
            "98.10Z",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.SUBCLASS,
        ),
        Classification(
            "98.2",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.GROUP,
        ),
        Classification(
            "98.20",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.CLASS,
        ),
        Classification(
            "98.20Z",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.SUBCLASS,
        ),
        Classification("U", "ACTIVITÉS EXTRA-TERRITORIALES", Category.SECTION),
        Classification("99", "Activités des organisations et organismes extraterritoriaux", Category.DIVISION),
        Classification("99.0", "Activités des organisations et organismes extraterritoriaux", Category.GROUP),
        Classification("99.00", "Activités des organisations et organismes extraterritoriaux", Category.CLASS),
        Classification("99.00Z", "Activités des organisations et organismes extraterritoriaux", Category.SUBCLASS),
    ],
)
