"""`Concordance between KSIC10 and ISIC4 <https://kosis.kr/eng/bulletinBoard/qnaView.do;jsessionid=I8KcwESVjkzNq7ZaYoiGeD4BbmudTn4AlBGH9H0yXiq71Vpu4Sznz5A1diF7KQ8C.STAT_WAS2_servlet_engine2?boardIdx=335027>`_ (concordance spreadsheet on this thread)."""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import KSIC10

KSIC10_to_ISIC4 = Concordance(
    src=KSIC10,
    dst=ISIC4,
    concordances=[
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01110"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0112")),
        ((Standards.KSIC10, "01110"), (Standards.ISIC4, "0112")),
        ((Standards.KSIC10, "01121"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01152"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01121"), (Standards.ISIC4, "0128")),
        ((Standards.KSIC10, "01121"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01151"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01159"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01131"), (Standards.ISIC4, "0122")),
        ((Standards.KSIC10, "01131"), (Standards.ISIC4, "0123")),
        ((Standards.KSIC10, "01152"), (Standards.ISIC4, "0123")),
        ((Standards.KSIC10, "01131"), (Standards.ISIC4, "0121")),
        ((Standards.KSIC10, "01131"), (Standards.ISIC4, "0124")),
        ((Standards.KSIC10, "01131"), (Standards.ISIC4, "0125")),
        ((Standards.KSIC10, "01152"), (Standards.ISIC4, "0230")),
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0125")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0126")),
        ((Standards.KSIC10, "01110"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01121"), (Standards.ISIC4, "0127")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0114")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0125")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0119")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0116")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0113")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0129")),
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0130")),
        ((Standards.KSIC10, "01122"), (Standards.ISIC4, "0119")),
        ((Standards.KSIC10, "01123"), (Standards.ISIC4, "0119")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "0115")),
        ((Standards.KSIC10, "01211"), (Standards.ISIC4, "0141")),
        ((Standards.KSIC10, "01299"), (Standards.ISIC4, "0143")),
        ((Standards.KSIC10, "01291"), (Standards.ISIC4, "0144")),
        ((Standards.KSIC10, "01299"), (Standards.ISIC4, "0149")),
        ((Standards.KSIC10, "01291"), (Standards.ISIC4, "0142")),
        ((Standards.KSIC10, "01220"), (Standards.ISIC4, "0145")),
        ((Standards.KSIC10, "01231"), (Standards.ISIC4, "0146")),
        ((Standards.KSIC10, "01239"), (Standards.ISIC4, "0146")),
        ((Standards.KSIC10, "01239"), (Standards.ISIC4, "0149")),
        ((Standards.KSIC10, "01299"), (Standards.ISIC4, "0141")),
        ((Standards.KSIC10, "01212"), (Standards.ISIC4, "0144")),
        ((Standards.KSIC10, "01291"), (Standards.ISIC4, "0149")),
        ((Standards.KSIC10, "01291"), (Standards.ISIC4, "0141")),
        ((Standards.KSIC10, "01500"), (Standards.ISIC4, "0144")),
        ((Standards.KSIC10, "10111"), (Standards.ISIC4, "1010")),
        ((Standards.KSIC10, "10401"), (Standards.ISIC4, "1040")),
        ((Standards.KSIC10, "02012"), (Standards.ISIC4, "0210")),
        ((Standards.KSIC10, "02020"), (Standards.ISIC4, "0220")),
        ((Standards.KSIC10, "02030"), (Standards.ISIC4, "0230")),
        ((Standards.KSIC10, "01122"), (Standards.ISIC4, "0230")),
        ((Standards.KSIC10, "03211"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "03212"), (Standards.ISIC4, "0312")),
        ((Standards.KSIC10, "03211"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "03212"), (Standards.ISIC4, "0322")),
        ((Standards.KSIC10, "03111"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "03112"), (Standards.ISIC4, "0312")),
        ((Standards.KSIC10, "03120"), (Standards.ISIC4, "0312")),
        ((Standards.KSIC10, "03212"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "03211"), (Standards.ISIC4, "0312")),
        ((Standards.KSIC10, "03111"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "03211"), (Standards.ISIC4, "0322")),
        ((Standards.KSIC10, "03120"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "03112"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "03112"), (Standards.ISIC4, "0322")),
        ((Standards.KSIC10, "05100"), (Standards.ISIC4, "0510")),
        ((Standards.KSIC10, "05100"), (Standards.ISIC4, "1920")),
        ((Standards.KSIC10, "05100"), (Standards.ISIC4, "0520")),
        ((Standards.KSIC10, "05100"), (Standards.ISIC4, "0892")),
        ((Standards.KSIC10, "05200"), (Standards.ISIC4, "0610")),
        ((Standards.KSIC10, "05200"), (Standards.ISIC4, "0620")),
        ((Standards.KSIC10, "06200"), (Standards.ISIC4, "0721")),
        ((Standards.KSIC10, "06200"), (Standards.ISIC4, "0729")),
        ((Standards.KSIC10, "07121"), (Standards.ISIC4, "0810")),
        ((Standards.KSIC10, "07110"), (Standards.ISIC4, "0810")),
        ((Standards.KSIC10, "07122"), (Standards.ISIC4, "0810")),
        ((Standards.KSIC10, "07290"), (Standards.ISIC4, "0899")),
        ((Standards.KSIC10, "07210"), (Standards.ISIC4, "0891")),
        ((Standards.KSIC10, "07220"), (Standards.ISIC4, "0893")),
        ((Standards.KSIC10, "35111"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35112"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35113"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35114"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35119"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35200"), (Standards.ISIC4, "3520")),
        ((Standards.KSIC10, "35300"), (Standards.ISIC4, "3530")),
        ((Standards.KSIC10, "06020"), (Standards.ISIC4, "3600")),
        ((Standards.KSIC10, "10112"), (Standards.ISIC4, "1010")),
        ((Standards.KSIC10, "10122"), (Standards.ISIC4, "1010")),
        ((Standards.KSIC10, "10121"), (Standards.ISIC4, "1010")),
        ((Standards.KSIC10, "10796"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10122"), (Standards.ISIC4, "1075")),
        ((Standards.KSIC10, "10213"), (Standards.ISIC4, "1020")),
        ((Standards.KSIC10, "10219"), (Standards.ISIC4, "1020")),
        ((Standards.KSIC10, "10212"), (Standards.ISIC4, "1020")),
        ((Standards.KSIC10, "10211"), (Standards.ISIC4, "1020")),
        ((Standards.KSIC10, "10211"), (Standards.ISIC4, "1075")),
        ((Standards.KSIC10, "10220"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "10219"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "10309"), (Standards.ISIC4, "1030")),
        ((Standards.KSIC10, "10302"), (Standards.ISIC4, "1030")),
        ((Standards.KSIC10, "10301"), (Standards.ISIC4, "1030")),
        ((Standards.KSIC10, "10309"), (Standards.ISIC4, "1075")),
        ((Standards.KSIC10, "10794"), (Standards.ISIC4, "1030")),
        ((Standards.KSIC10, "10401"), (Standards.ISIC4, "1010")),
        ((Standards.KSIC10, "10112"), (Standards.ISIC4, "1040")),
        ((Standards.KSIC10, "10403"), (Standards.ISIC4, "1040")),
        ((Standards.KSIC10, "10402"), (Standards.ISIC4, "1040")),
        ((Standards.KSIC10, "10403"), (Standards.ISIC4, "1062")),
        ((Standards.KSIC10, "10402"), (Standards.ISIC4, "1062")),
        ((Standards.KSIC10, "10501"), (Standards.ISIC4, "1050")),
        ((Standards.KSIC10, "10502"), (Standards.ISIC4, "1050")),
        ((Standards.KSIC10, "10799"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10612"), (Standards.ISIC4, "1061")),
        ((Standards.KSIC10, "10619"), (Standards.ISIC4, "1061")),
        ((Standards.KSIC10, "10611"), (Standards.ISIC4, "1061")),
        ((Standards.KSIC10, "10613"), (Standards.ISIC4, "1061")),
        ((Standards.KSIC10, "10620"), (Standards.ISIC4, "1050")),
        ((Standards.KSIC10, "10620"), (Standards.ISIC4, "1062")),
        ((Standards.KSIC10, "10801"), (Standards.ISIC4, "1080")),
        ((Standards.KSIC10, "10711"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10712"), (Standards.ISIC4, "1071")),
        ((Standards.KSIC10, "10720"), (Standards.ISIC4, "1072")),
        ((Standards.KSIC10, "10713"), (Standards.ISIC4, "1073")),
        ((Standards.KSIC10, "10730"), (Standards.ISIC4, "1074")),
        ((Standards.KSIC10, "10791"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10792"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10742"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10741"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10743"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "01140"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10795"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10793"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10749"), (Standards.ISIC4, "1079")),
        ((Standards.KSIC10, "10751"), (Standards.ISIC4, "1075")),
        ((Standards.KSIC10, "10759"), (Standards.ISIC4, "1075")),
        ((Standards.KSIC10, "11121"), (Standards.ISIC4, "1101")),
        ((Standards.KSIC10, "11122"), (Standards.ISIC4, "1101")),
        ((Standards.KSIC10, "11129"), (Standards.ISIC4, "1101")),
        ((Standards.KSIC10, "11111"), (Standards.ISIC4, "1102")),
        ((Standards.KSIC10, "11119"), (Standards.ISIC4, "1102")),
        ((Standards.KSIC10, "11112"), (Standards.ISIC4, "1103")),
        ((Standards.KSIC10, "11202"), (Standards.ISIC4, "1104")),
        ((Standards.KSIC10, "11201"), (Standards.ISIC4, "1050")),
        ((Standards.KSIC10, "11209"), (Standards.ISIC4, "1104")),
        ((Standards.KSIC10, "12000"), (Standards.ISIC4, "1200")),
        ((Standards.KSIC10, "13109"), (Standards.ISIC4, "1311")),
        ((Standards.KSIC10, "13102"), (Standards.ISIC4, "1311")),
        ((Standards.KSIC10, "13101"), (Standards.ISIC4, "1311")),
        ((Standards.KSIC10, "13103"), (Standards.ISIC4, "1311")),
        ((Standards.KSIC10, "13219"), (Standards.ISIC4, "1312")),
        ((Standards.KSIC10, "13212"), (Standards.ISIC4, "1312")),
        ((Standards.KSIC10, "13211"), (Standards.ISIC4, "1312")),
        ((Standards.KSIC10, "13213"), (Standards.ISIC4, "1312")),
        ((Standards.KSIC10, "13221"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13223"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13222"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13225"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13224"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13229"), (Standards.ISIC4, "1392")),
        ((Standards.KSIC10, "13910"), (Standards.ISIC4, "1393")),
        ((Standards.KSIC10, "13921"), (Standards.ISIC4, "1394")),
        ((Standards.KSIC10, "13922"), (Standards.ISIC4, "1394")),
        ((Standards.KSIC10, "13991"), (Standards.ISIC4, "1399")),
        ((Standards.KSIC10, "13999"), (Standards.ISIC4, "1399")),
        ((Standards.KSIC10, "13992"), (Standards.ISIC4, "1399")),
        ((Standards.KSIC10, "13994"), (Standards.ISIC4, "1399")),
        ((Standards.KSIC10, "13219"), (Standards.ISIC4, "1399")),
        ((Standards.KSIC10, "13300"), (Standards.ISIC4, "1391")),
        ((Standards.KSIC10, "14411"), (Standards.ISIC4, "1430")),
        ((Standards.KSIC10, "14300"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14419"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14111"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14120"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14112"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14194"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14192"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14130"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14499"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14193"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "22299"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "14199"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "14491"), (Standards.ISIC4, "1410")),
        ((Standards.KSIC10, "15110"), (Standards.ISIC4, "1511")),
        ((Standards.KSIC10, "14200"), (Standards.ISIC4, "1420")),
        ((Standards.KSIC10, "15121"), (Standards.ISIC4, "1512")),
        ((Standards.KSIC10, "15190"), (Standards.ISIC4, "1512")),
        ((Standards.KSIC10, "15219"), (Standards.ISIC4, "1520")),
        ((Standards.KSIC10, "15211"), (Standards.ISIC4, "1520")),
        ((Standards.KSIC10, "15219"), (Standards.ISIC4, "3230")),
        ((Standards.KSIC10, "15220"), (Standards.ISIC4, "1520")),
        ((Standards.KSIC10, "16101"), (Standards.ISIC4, "1610")),
        ((Standards.KSIC10, "16102"), (Standards.ISIC4, "1610")),
        ((Standards.KSIC10, "16103"), (Standards.ISIC4, "1610")),
        ((Standards.KSIC10, "16211"), (Standards.ISIC4, "1621")),
        ((Standards.KSIC10, "16212"), (Standards.ISIC4, "1621")),
        ((Standards.KSIC10, "16229"), (Standards.ISIC4, "1622")),
        ((Standards.KSIC10, "16221"), (Standards.ISIC4, "1622")),
        ((Standards.KSIC10, "16231"), (Standards.ISIC4, "1623")),
        ((Standards.KSIC10, "16232"), (Standards.ISIC4, "1623")),
        ((Standards.KSIC10, "16291"), (Standards.ISIC4, "1629")),
        ((Standards.KSIC10, "16292"), (Standards.ISIC4, "1629")),
        ((Standards.KSIC10, "16300"), (Standards.ISIC4, "1629")),
        ((Standards.KSIC10, "17110"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17121"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17129"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17122"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17125"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17123"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17124"), (Standards.ISIC4, "1701")),
        ((Standards.KSIC10, "17211"), (Standards.ISIC4, "1702")),
        ((Standards.KSIC10, "17221"), (Standards.ISIC4, "1702")),
        ((Standards.KSIC10, "17212"), (Standards.ISIC4, "1702")),
        ((Standards.KSIC10, "17222"), (Standards.ISIC4, "1702")),
        ((Standards.KSIC10, "17223"), (Standards.ISIC4, "1702")),
        ((Standards.KSIC10, "17902"), (Standards.ISIC4, "1709")),
        ((Standards.KSIC10, "17901"), (Standards.ISIC4, "1709")),
        ((Standards.KSIC10, "17903"), (Standards.ISIC4, "1709")),
        ((Standards.KSIC10, "17909"), (Standards.ISIC4, "1709")),
        ((Standards.KSIC10, "58111"), (Standards.ISIC4, "5811")),
        ((Standards.KSIC10, "58113"), (Standards.ISIC4, "5811")),
        ((Standards.KSIC10, "58113"), (Standards.ISIC4, "5812")),
        ((Standards.KSIC10, "58112"), (Standards.ISIC4, "5811")),
        ((Standards.KSIC10, "58121"), (Standards.ISIC4, "5813")),
        ((Standards.KSIC10, "58122"), (Standards.ISIC4, "5813")),
        ((Standards.KSIC10, "33932"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "59201"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "58190"), (Standards.ISIC4, "5819")),
        ((Standards.KSIC10, "58190"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "58190"), (Standards.ISIC4, "5310")),
        ((Standards.KSIC10, "18111"), (Standards.ISIC4, "1811")),
        ((Standards.KSIC10, "18121"), (Standards.ISIC4, "1812")),
        ((Standards.KSIC10, "19101"), (Standards.ISIC4, "1910")),
        ((Standards.KSIC10, "19210"), (Standards.ISIC4, "1920")),
        ((Standards.KSIC10, "19229"), (Standards.ISIC4, "1920")),
        ((Standards.KSIC10, "19221"), (Standards.ISIC4, "1920")),
        ((Standards.KSIC10, "20129"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20111"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20119"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20311"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20121"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20131"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20311"), (Standards.ISIC4, "2012")),
        ((Standards.KSIC10, "20132"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20112"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20112"), (Standards.ISIC4, "0220")),
        ((Standards.KSIC10, "20495"), (Standards.ISIC4, "2029")),
        ((Standards.KSIC10, "20129"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "20422"), (Standards.ISIC4, "2011")),
        ((Standards.KSIC10, "20311"), (Standards.ISIC4, "0891")),
        ((Standards.KSIC10, "20312"), (Standards.ISIC4, "2012")),
        ((Standards.KSIC10, "20129"), (Standards.ISIC4, "2012")),
        ((Standards.KSIC10, "20313"), (Standards.ISIC4, "0141")),
        ((Standards.KSIC10, "20321"), (Standards.ISIC4, "2021")),
        ((Standards.KSIC10, "20322"), (Standards.ISIC4, "2021")),
        ((Standards.KSIC10, "20202"), (Standards.ISIC4, "2013")),
        ((Standards.KSIC10, "20201"), (Standards.ISIC4, "2013")),
        ((Standards.KSIC10, "20411"), (Standards.ISIC4, "2022")),
        ((Standards.KSIC10, "20412"), (Standards.ISIC4, "2022")),
        ((Standards.KSIC10, "20413"), (Standards.ISIC4, "2022")),
        ((Standards.KSIC10, "20499"), (Standards.ISIC4, "2029")),
        ((Standards.KSIC10, "21101"), (Standards.ISIC4, "2100")),
        ((Standards.KSIC10, "21210"), (Standards.ISIC4, "2100")),
        ((Standards.KSIC10, "21102"), (Standards.ISIC4, "2100")),
        ((Standards.KSIC10, "20499"), (Standards.ISIC4, "2100")),
        ((Standards.KSIC10, "21300"), (Standards.ISIC4, "2100")),
        ((Standards.KSIC10, "21300"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "20421"), (Standards.ISIC4, "2023")),
        ((Standards.KSIC10, "20422"), (Standards.ISIC4, "2023")),
        ((Standards.KSIC10, "20423"), (Standards.ISIC4, "2023")),
        ((Standards.KSIC10, "20424"), (Standards.ISIC4, "2023")),
        ((Standards.KSIC10, "20493"), (Standards.ISIC4, "2029")),
        ((Standards.KSIC10, "20499"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "20494"), (Standards.ISIC4, "2029")),
        ((Standards.KSIC10, "20501"), (Standards.ISIC4, "2030")),
        ((Standards.KSIC10, "20502"), (Standards.ISIC4, "2030")),
        ((Standards.KSIC10, "22111"), (Standards.ISIC4, "2211")),
        ((Standards.KSIC10, "22112"), (Standards.ISIC4, "2211")),
        ((Standards.KSIC10, "22192"), (Standards.ISIC4, "3830")),
        ((Standards.KSIC10, "22192"), (Standards.ISIC4, "2219")),
        ((Standards.KSIC10, "22193"), (Standards.ISIC4, "2219")),
        ((Standards.KSIC10, "22199"), (Standards.ISIC4, "2219")),
        ((Standards.KSIC10, "22211"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22212"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22251"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22231"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22232"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22221"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22291"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22222"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22223"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22229"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22241"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "22299"), (Standards.ISIC4, "2219")),
        ((Standards.KSIC10, "22259"), (Standards.ISIC4, "2220")),
        ((Standards.KSIC10, "23121"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23111"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23122"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23119"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23112"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23129"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23192"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23191"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23199"), (Standards.ISIC4, "2310")),
        ((Standards.KSIC10, "23222"), (Standards.ISIC4, "2392")),
        ((Standards.KSIC10, "23221"), (Standards.ISIC4, "2393")),
        ((Standards.KSIC10, "23222"), (Standards.ISIC4, "2393")),
        ((Standards.KSIC10, "23229"), (Standards.ISIC4, "2393")),
        ((Standards.KSIC10, "23231"), (Standards.ISIC4, "2392")),
        ((Standards.KSIC10, "23211"), (Standards.ISIC4, "2391")),
        ((Standards.KSIC10, "23212"), (Standards.ISIC4, "2391")),
        ((Standards.KSIC10, "23239"), (Standards.ISIC4, "2392")),
        ((Standards.KSIC10, "23232"), (Standards.ISIC4, "2392")),
        ((Standards.KSIC10, "23312"), (Standards.ISIC4, "2394")),
        ((Standards.KSIC10, "23311"), (Standards.ISIC4, "2394")),
        ((Standards.KSIC10, "23321"), (Standards.ISIC4, "2395")),
        ((Standards.KSIC10, "23324"), (Standards.ISIC4, "2395")),
        ((Standards.KSIC10, "23323"), (Standards.ISIC4, "2395")),
        ((Standards.KSIC10, "23325"), (Standards.ISIC4, "2395")),
        ((Standards.KSIC10, "23911"), (Standards.ISIC4, "2396")),
        ((Standards.KSIC10, "23992"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "23999"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "23991"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "23995"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "23993"), (Standards.ISIC4, "2399")),
        ((Standards.KSIC10, "30393"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "31202"), (Standards.ISIC4, "3020")),
        ((Standards.KSIC10, "31322"), (Standards.ISIC4, "3030")),
        ((Standards.KSIC10, "32091"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "32029"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "32019"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "32091"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "32021"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "32099"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "32011"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "03112"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "33110"), (Standards.ISIC4, "3211")),
        ((Standards.KSIC10, "33120"), (Standards.ISIC4, "3212")),
        ((Standards.KSIC10, "33201"), (Standards.ISIC4, "3220")),
        ((Standards.KSIC10, "33209"), (Standards.ISIC4, "3220")),
        ((Standards.KSIC10, "33202"), (Standards.ISIC4, "3220")),
        ((Standards.KSIC10, "33309"), (Standards.ISIC4, "3230")),
        ((Standards.KSIC10, "33301"), (Standards.ISIC4, "3230")),
        ((Standards.KSIC10, "33302"), (Standards.ISIC4, "3230")),
        ((Standards.KSIC10, "33303"), (Standards.ISIC4, "3230")),
        ((Standards.KSIC10, "33401"), (Standards.ISIC4, "3240")),
        ((Standards.KSIC10, "33409"), (Standards.ISIC4, "3240")),
        ((Standards.KSIC10, "33402"), (Standards.ISIC4, "2640")),
        ((Standards.KSIC10, "58219"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "29299"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "25119"), (Standards.ISIC4, "2511")),
        ((Standards.KSIC10, "33920"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "33999"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "33991"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "73301"), (Standards.ISIC4, "7420")),
        ((Standards.KSIC10, "73303"), (Standards.ISIC4, "7420")),
        ((Standards.KSIC10, "59111"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "90132"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "61100"), (Standards.ISIC4, "5310")),
        ((Standards.KSIC10, "90221"), (Standards.ISIC4, "9102")),
        ((Standards.KSIC10, "33931"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "33992"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "31991"), (Standards.ISIC4, "3092")),
        ((Standards.KSIC10, "33993"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "24111"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24113"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24119"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24112"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24121"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24122"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24191"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24123"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24132"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24131"), (Standards.ISIC4, "2410")),
        ((Standards.KSIC10, "24132"), (Standards.ISIC4, "2431")),
        ((Standards.KSIC10, "24131"), (Standards.ISIC4, "2431")),
        ((Standards.KSIC10, "24219"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24221"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24211"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24212"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24213"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24290"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24229"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "24222"), (Standards.ISIC4, "2420")),
        ((Standards.KSIC10, "25113"), (Standards.ISIC4, "2511")),
        ((Standards.KSIC10, "25111"), (Standards.ISIC4, "2511")),
        ((Standards.KSIC10, "25112"), (Standards.ISIC4, "2511")),
        ((Standards.KSIC10, "25122"), (Standards.ISIC4, "2512")),
        ((Standards.KSIC10, "25130"), (Standards.ISIC4, "2513")),
        ((Standards.KSIC10, "25993"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25992"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25931"), (Standards.ISIC4, "2593")),
        ((Standards.KSIC10, "25933"), (Standards.ISIC4, "2593")),
        ((Standards.KSIC10, "25934"), (Standards.ISIC4, "2593")),
        ((Standards.KSIC10, "25991"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25944"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25941"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25943"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25999"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "25932"), (Standards.ISIC4, "2593")),
        ((Standards.KSIC10, "29111"), (Standards.ISIC4, "2811")),
        ((Standards.KSIC10, "30110"), (Standards.ISIC4, "2910")),
        ((Standards.KSIC10, "31321"), (Standards.ISIC4, "3030")),
        ((Standards.KSIC10, "29119"), (Standards.ISIC4, "2811")),
        ((Standards.KSIC10, "29111"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "29111"), (Standards.ISIC4, "3030")),
        ((Standards.KSIC10, "29120"), (Standards.ISIC4, "2812")),
        ((Standards.KSIC10, "29131"), (Standards.ISIC4, "2813")),
        ((Standards.KSIC10, "29132"), (Standards.ISIC4, "2813")),
        ((Standards.KSIC10, "29133"), (Standards.ISIC4, "2813")),
        ((Standards.KSIC10, "29141"), (Standards.ISIC4, "2814")),
        ((Standards.KSIC10, "29142"), (Standards.ISIC4, "2814")),
        ((Standards.KSIC10, "29150"), (Standards.ISIC4, "2815")),
        ((Standards.KSIC10, "29169"), (Standards.ISIC4, "2816")),
        ((Standards.KSIC10, "29161"), (Standards.ISIC4, "2816")),
        ((Standards.KSIC10, "29162"), (Standards.ISIC4, "2816")),
        ((Standards.KSIC10, "29176"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29172"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29171"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29175"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29174"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29192"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29191"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29193"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29199"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29210"), (Standards.ISIC4, "2821")),
        ((Standards.KSIC10, "29250"), (Standards.ISIC4, "2825")),
        ((Standards.KSIC10, "29210"), (Standards.ISIC4, "2824")),
        ((Standards.KSIC10, "29221"), (Standards.ISIC4, "2822")),
        ((Standards.KSIC10, "29223"), (Standards.ISIC4, "2822")),
        ((Standards.KSIC10, "29222"), (Standards.ISIC4, "2822")),
        ((Standards.KSIC10, "29229"), (Standards.ISIC4, "2822")),
        ((Standards.KSIC10, "29194"), (Standards.ISIC4, "2818")),
        ((Standards.KSIC10, "28909"), (Standards.ISIC4, "2790")),
        ((Standards.KSIC10, "29199"), (Standards.ISIC4, "2822")),
        ((Standards.KSIC10, "29224"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "29230"), (Standards.ISIC4, "2823")),
        ((Standards.KSIC10, "29242"), (Standards.ISIC4, "2824")),
        ((Standards.KSIC10, "29241"), (Standards.ISIC4, "2824")),
        ((Standards.KSIC10, "29269"), (Standards.ISIC4, "2826")),
        ((Standards.KSIC10, "29261"), (Standards.ISIC4, "2826")),
        ((Standards.KSIC10, "31910"), (Standards.ISIC4, "3040")),
        ((Standards.KSIC10, "25200"), (Standards.ISIC4, "2520")),
        ((Standards.KSIC10, "28511"), (Standards.ISIC4, "2750")),
        ((Standards.KSIC10, "28519"), (Standards.ISIC4, "2750")),
        ((Standards.KSIC10, "28512"), (Standards.ISIC4, "2750")),
        ((Standards.KSIC10, "28520"), (Standards.ISIC4, "2750")),
        ((Standards.KSIC10, "25121"), (Standards.ISIC4, "2512")),
        ((Standards.KSIC10, "28520"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "29299"), (Standards.ISIC4, "2826")),
        ((Standards.KSIC10, "29291"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "29293"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "29222"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "29294"), (Standards.ISIC4, "2593")),
        ((Standards.KSIC10, "29180"), (Standards.ISIC4, "2817")),
        ((Standards.KSIC10, "29271"), (Standards.ISIC4, "2829")),
        ((Standards.KSIC10, "26329"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26310"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26323"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26321"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26299"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "28111"), (Standards.ISIC4, "2710")),
        ((Standards.KSIC10, "28112"), (Standards.ISIC4, "2710")),
        ((Standards.KSIC10, "28113"), (Standards.ISIC4, "2710")),
        ((Standards.KSIC10, "28121"), (Standards.ISIC4, "2710")),
        ((Standards.KSIC10, "28123"), (Standards.ISIC4, "2710")),
        ((Standards.KSIC10, "28121"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "28302"), (Standards.ISIC4, "2732")),
        ((Standards.KSIC10, "30332"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "28303"), (Standards.ISIC4, "2732")),
        ((Standards.KSIC10, "28301"), (Standards.ISIC4, "2731")),
        ((Standards.KSIC10, "28201"), (Standards.ISIC4, "2720")),
        ((Standards.KSIC10, "28202"), (Standards.ISIC4, "2720")),
        ((Standards.KSIC10, "28410"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "28422"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "28423"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "28429"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "30332"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "30400"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "28421"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "28901"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "28901"), (Standards.ISIC4, "2790")),
        ((Standards.KSIC10, "28303"), (Standards.ISIC4, "2733")),
        ((Standards.KSIC10, "28902"), (Standards.ISIC4, "2790")),
        ((Standards.KSIC10, "28421"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "28901"), (Standards.ISIC4, "2740")),
        ((Standards.KSIC10, "28903"), (Standards.ISIC4, "2790")),
        ((Standards.KSIC10, "28909"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "26291"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "26292"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "28909"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "26221"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "26121"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "26111"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "26112"), (Standards.ISIC4, "2790")),
        ((Standards.KSIC10, "26421"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "26519"), (Standards.ISIC4, "2640")),
        ((Standards.KSIC10, "27302"), (Standards.ISIC4, "2670")),
        ((Standards.KSIC10, "26410"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "26422"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "26429"), (Standards.ISIC4, "2630")),
        ((Standards.KSIC10, "26521"), (Standards.ISIC4, "2640")),
        ((Standards.KSIC10, "26511"), (Standards.ISIC4, "2640")),
        ((Standards.KSIC10, "26519"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26529"), (Standards.ISIC4, "2640")),
        ((Standards.KSIC10, "26521"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "26600"), (Standards.ISIC4, "2680")),
        ((Standards.KSIC10, "26293"), (Standards.ISIC4, "2620")),
        ((Standards.KSIC10, "26299"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "58112"), (Standards.ISIC4, "5812")),
        ((Standards.KSIC10, "58113"), (Standards.ISIC4, "5813")),
        ((Standards.KSIC10, "58221"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "58222"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "58211"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "26293"), (Standards.ISIC4, "2680")),
        ((Standards.KSIC10, "26293"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "27111"), (Standards.ISIC4, "2660")),
        ((Standards.KSIC10, "27112"), (Standards.ISIC4, "2660")),
        ((Standards.KSIC10, "27191"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "27199"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "27192"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "27192"), (Standards.ISIC4, "2660")),
        ((Standards.KSIC10, "27194"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "27211"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27219"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27219"), (Standards.ISIC4, "2819")),
        ((Standards.KSIC10, "27212"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27213"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27214"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27215"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "26295"), (Standards.ISIC4, "2651")),
        ((Standards.KSIC10, "27301"), (Standards.ISIC4, "2670")),
        ((Standards.KSIC10, "28301"), (Standards.ISIC4, "2670")),
        ((Standards.KSIC10, "27193"), (Standards.ISIC4, "3250")),
        ((Standards.KSIC10, "27309"), (Standards.ISIC4, "2670")),
        ((Standards.KSIC10, "26211"), (Standards.ISIC4, "2610")),
        ((Standards.KSIC10, "20491"), (Standards.ISIC4, "2029")),
        ((Standards.KSIC10, "27400"), (Standards.ISIC4, "2652")),
        ((Standards.KSIC10, "30122"), (Standards.ISIC4, "2910")),
        ((Standards.KSIC10, "30121"), (Standards.ISIC4, "2910")),
        ((Standards.KSIC10, "30331"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "30201"), (Standards.ISIC4, "2920")),
        ((Standards.KSIC10, "30203"), (Standards.ISIC4, "2920")),
        ((Standards.KSIC10, "30320"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "30203"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "31111"), (Standards.ISIC4, "3011")),
        ((Standards.KSIC10, "31113"), (Standards.ISIC4, "3011")),
        ((Standards.KSIC10, "31120"), (Standards.ISIC4, "3012")),
        ((Standards.KSIC10, "31201"), (Standards.ISIC4, "3020")),
        ((Standards.KSIC10, "31202"), (Standards.ISIC4, "2599")),
        ((Standards.KSIC10, "31311"), (Standards.ISIC4, "3030")),
        ((Standards.KSIC10, "31920"), (Standards.ISIC4, "3091")),
        ((Standards.KSIC10, "31999"), (Standards.ISIC4, "2816")),
        ((Standards.KSIC10, "41111"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41112"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41119"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41122"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41121"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41129"), (Standards.ISIC4, "4100")),
        ((Standards.KSIC10, "41221"), (Standards.ISIC4, "4210")),
        ((Standards.KSIC10, "41222"), (Standards.ISIC4, "4210")),
        ((Standards.KSIC10, "41223"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "41223"), (Standards.ISIC4, "4290")),
        ((Standards.KSIC10, "41229"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "42321"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "41224"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "42121"), (Standards.ISIC4, "4290")),
        ((Standards.KSIC10, "41225"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "41225"), (Standards.ISIC4, "4290")),
        ((Standards.KSIC10, "41229"), (Standards.ISIC4, "4290")),
        ((Standards.KSIC10, "42110"), (Standards.ISIC4, "4311")),
        ((Standards.KSIC10, "42121"), (Standards.ISIC4, "4312")),
        ((Standards.KSIC10, "42122"), (Standards.ISIC4, "4312")),
        ((Standards.KSIC10, "42122"), (Standards.ISIC4, "4220")),
        ((Standards.KSIC10, "42123"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42131"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42137"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42138"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42132"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42492"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42133"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42136"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42499"), (Standards.ISIC4, "4390")),
        ((Standards.KSIC10, "42312"), (Standards.ISIC4, "4321")),
        ((Standards.KSIC10, "42322"), (Standards.ISIC4, "4321")),
        ((Standards.KSIC10, "42311"), (Standards.ISIC4, "3320")),
        ((Standards.KSIC10, "42201"), (Standards.ISIC4, "4322")),
        ((Standards.KSIC10, "42201"), (Standards.ISIC4, "4329")),
        ((Standards.KSIC10, "42202"), (Standards.ISIC4, "4329")),
        ((Standards.KSIC10, "42202"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42420"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42491"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42411"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42412"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42209"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "42499"), (Standards.ISIC4, "4330")),
        ((Standards.KSIC10, "55101"), (Standards.ISIC4, "5510")),
        ((Standards.KSIC10, "55102"), (Standards.ISIC4, "5510")),
        ((Standards.KSIC10, "55103"), (Standards.ISIC4, "5510")),
        ((Standards.KSIC10, "85614"), (Standards.ISIC4, "5510")),
        ((Standards.KSIC10, "55109"), (Standards.ISIC4, "5520")),
        ((Standards.KSIC10, "55104"), (Standards.ISIC4, "5520")),
        ((Standards.KSIC10, "55901"), (Standards.ISIC4, "5590")),
        ((Standards.KSIC10, "56111"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56112"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56113"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56114"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56121"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56122"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56123"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56129"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56130"), (Standards.ISIC4, "5629")),
        ((Standards.KSIC10, "56141"), (Standards.ISIC4, "5621")),
        ((Standards.KSIC10, "56142"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56191"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56192"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56193"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56194"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56199"), (Standards.ISIC4, "5610")),
        ((Standards.KSIC10, "56211"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "56212"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "56213"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "56219"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "56221"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "56229"), (Standards.ISIC4, "5630")),
        ((Standards.KSIC10, "49211"), (Standards.ISIC4, "4921")),
        ((Standards.KSIC10, "49212"), (Standards.ISIC4, "4921")),
        ((Standards.KSIC10, "49219"), (Standards.ISIC4, "4921")),
        ((Standards.KSIC10, "49219"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "49231"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "49232"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "49233"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "49239"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "50201"), (Standards.ISIC4, "5021")),
        ((Standards.KSIC10, "49101"), (Standards.ISIC4, "4911")),
        ((Standards.KSIC10, "50111"), (Standards.ISIC4, "5011")),
        ((Standards.KSIC10, "50121"), (Standards.ISIC4, "5021")),
        ((Standards.KSIC10, "50201"), (Standards.ISIC4, "5011")),
        ((Standards.KSIC10, "50202"), (Standards.ISIC4, "5011")),
        ((Standards.KSIC10, "51100"), (Standards.ISIC4, "5110")),
        ((Standards.KSIC10, "49220"), (Standards.ISIC4, "4922")),
        ((Standards.KSIC10, "50121"), (Standards.ISIC4, "5011")),
        ((Standards.KSIC10, "49301"), (Standards.ISIC4, "4923")),
        ((Standards.KSIC10, "49309"), (Standards.ISIC4, "4923")),
        ((Standards.KSIC10, "49302"), (Standards.ISIC4, "4923")),
        ((Standards.KSIC10, "49303"), (Standards.ISIC4, "4923")),
        ((Standards.KSIC10, "49102"), (Standards.ISIC4, "4912")),
        ((Standards.KSIC10, "49500"), (Standards.ISIC4, "4930")),
        ((Standards.KSIC10, "50112"), (Standards.ISIC4, "5012")),
        ((Standards.KSIC10, "50130"), (Standards.ISIC4, "5012")),
        ((Standards.KSIC10, "50201"), (Standards.ISIC4, "5022")),
        ((Standards.KSIC10, "50209"), (Standards.ISIC4, "5022")),
        ((Standards.KSIC10, "51200"), (Standards.ISIC4, "5120")),
        ((Standards.KSIC10, "51100"), (Standards.ISIC4, "5120")),
        ((Standards.KSIC10, "52941"), (Standards.ISIC4, "5224")),
        ((Standards.KSIC10, "52913"), (Standards.ISIC4, "5224")),
        ((Standards.KSIC10, "52102"), (Standards.ISIC4, "5210")),
        ((Standards.KSIC10, "52104"), (Standards.ISIC4, "5210")),
        ((Standards.KSIC10, "52101"), (Standards.ISIC4, "5210")),
        ((Standards.KSIC10, "52103"), (Standards.ISIC4, "5210")),
        ((Standards.KSIC10, "52109"), (Standards.ISIC4, "5210")),
        ((Standards.KSIC10, "52911"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52912"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52914"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52915"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "49301"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52913"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52921"), (Standards.ISIC4, "5222")),
        ((Standards.KSIC10, "52929"), (Standards.ISIC4, "5222")),
        ((Standards.KSIC10, "52931"), (Standards.ISIC4, "5223")),
        ((Standards.KSIC10, "52939"), (Standards.ISIC4, "5223")),
        ((Standards.KSIC10, "52991"), (Standards.ISIC4, "5229")),
        ((Standards.KSIC10, "52993"), (Standards.ISIC4, "5229")),
        ((Standards.KSIC10, "52919"), (Standards.ISIC4, "5221")),
        ((Standards.KSIC10, "52999"), (Standards.ISIC4, "5229")),
        ((Standards.KSIC10, "49401"), (Standards.ISIC4, "5320")),
        ((Standards.KSIC10, "49402"), (Standards.ISIC4, "5320")),
        ((Standards.KSIC10, "35120"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "35130"), (Standards.ISIC4, "3510")),
        ((Standards.KSIC10, "36010"), (Standards.ISIC4, "3600")),
        ((Standards.KSIC10, "64110"), (Standards.ISIC4, "6411")),
        ((Standards.KSIC10, "64121"), (Standards.ISIC4, "6419")),
        ((Standards.KSIC10, "64122"), (Standards.ISIC4, "6492")),
        ((Standards.KSIC10, "64121"), (Standards.ISIC4, "6492")),
        ((Standards.KSIC10, "64911"), (Standards.ISIC4, "6491")),
        ((Standards.KSIC10, "64991"), (Standards.ISIC4, "6499")),
        ((Standards.KSIC10, "64201"), (Standards.ISIC4, "6499")),
        ((Standards.KSIC10, "65110"), (Standards.ISIC4, "6511")),
        ((Standards.KSIC10, "65301"), (Standards.ISIC4, "6530")),
        ((Standards.KSIC10, "65302"), (Standards.ISIC4, "6530")),
        ((Standards.KSIC10, "65110"), (Standards.ISIC4, "6512")),
        ((Standards.KSIC10, "65121"), (Standards.ISIC4, "6512")),
        ((Standards.KSIC10, "65122"), (Standards.ISIC4, "6512")),
        ((Standards.KSIC10, "65200"), (Standards.ISIC4, "6520")),
        ((Standards.KSIC10, "64999"), (Standards.ISIC4, "6619")),
        ((Standards.KSIC10, "66121"), (Standards.ISIC4, "6612")),
        ((Standards.KSIC10, "66199"), (Standards.ISIC4, "6619")),
        ((Standards.KSIC10, "64209"), (Standards.ISIC4, "6630")),
        ((Standards.KSIC10, "66191"), (Standards.ISIC4, "6619")),
        ((Standards.KSIC10, "66110"), (Standards.ISIC4, "6611")),
        ((Standards.KSIC10, "66192"), (Standards.ISIC4, "6619")),
        ((Standards.KSIC10, "66199"), (Standards.ISIC4, "6612")),
        ((Standards.KSIC10, "66202"), (Standards.ISIC4, "6622")),
        ((Standards.KSIC10, "66201"), (Standards.ISIC4, "6621")),
        ((Standards.KSIC10, "66209"), (Standards.ISIC4, "6629")),
        ((Standards.KSIC10, "66209"), (Standards.ISIC4, "6630")),
        ((Standards.KSIC10, "66201"), (Standards.ISIC4, "6629")),
        ((Standards.KSIC10, "64992"), (Standards.ISIC4, "6420")),
        ((Standards.KSIC10, "64201"), (Standards.ISIC4, "6430")),
        ((Standards.KSIC10, "68111"), (Standards.ISIC4, "6810")),
        ((Standards.KSIC10, "68112"), (Standards.ISIC4, "6810")),
        ((Standards.KSIC10, "68121"), (Standards.ISIC4, "6810")),
        ((Standards.KSIC10, "68122"), (Standards.ISIC4, "6810")),
        ((Standards.KSIC10, "68129"), (Standards.ISIC4, "6810")),
        ((Standards.KSIC10, "68211"), (Standards.ISIC4, "6820")),
        ((Standards.KSIC10, "68212"), (Standards.ISIC4, "6820")),
        ((Standards.KSIC10, "68221"), (Standards.ISIC4, "6820")),
        ((Standards.KSIC10, "68223"), (Standards.ISIC4, "6820")),
        ((Standards.KSIC10, "68222"), (Standards.ISIC4, "6820")),
        ((Standards.KSIC10, "76110"), (Standards.ISIC4, "7710")),
        ((Standards.KSIC10, "76190"), (Standards.ISIC4, "7730")),
        ((Standards.KSIC10, "76190"), (Standards.ISIC4, "7710")),
        ((Standards.KSIC10, "76390"), (Standards.ISIC4, "7730")),
        ((Standards.KSIC10, "76310"), (Standards.ISIC4, "7730")),
        ((Standards.KSIC10, "76320"), (Standards.ISIC4, "7730")),
        ((Standards.KSIC10, "76299"), (Standards.ISIC4, "7729")),
        ((Standards.KSIC10, "76220"), (Standards.ISIC4, "7722")),
        ((Standards.KSIC10, "76210"), (Standards.ISIC4, "7721")),
        ((Standards.KSIC10, "76292"), (Standards.ISIC4, "7729")),
        ((Standards.KSIC10, "76291"), (Standards.ISIC4, "7729")),
        ((Standards.KSIC10, "58112"), (Standards.ISIC4, "5813")),
        ((Standards.KSIC10, "58113"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "58121"), (Standards.ISIC4, "5912")),
        ((Standards.KSIC10, "58122"), (Standards.ISIC4, "5913")),
        ((Standards.KSIC10, "58123"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "59111"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "76400"), (Standards.ISIC4, "7740")),
        ((Standards.KSIC10, "70111"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70129"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70121"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70113"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70112"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70119"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "70209"), (Standards.ISIC4, "7220")),
        ((Standards.KSIC10, "70201"), (Standards.ISIC4, "7220")),
        ((Standards.KSIC10, "70130"), (Standards.ISIC4, "7210")),
        ((Standards.KSIC10, "71101"), (Standards.ISIC4, "6910")),
        ((Standards.KSIC10, "71102"), (Standards.ISIC4, "6910")),
        ((Standards.KSIC10, "71103"), (Standards.ISIC4, "6910")),
        ((Standards.KSIC10, "71109"), (Standards.ISIC4, "6910")),
        ((Standards.KSIC10, "71201"), (Standards.ISIC4, "6920")),
        ((Standards.KSIC10, "71202"), (Standards.ISIC4, "6920")),
        ((Standards.KSIC10, "71209"), (Standards.ISIC4, "6920")),
        ((Standards.KSIC10, "71101"), (Standards.ISIC4, "7020")),
        ((Standards.KSIC10, "71531"), (Standards.ISIC4, "7020")),
        ((Standards.KSIC10, "71511"), (Standards.ISIC4, "7010")),
        ((Standards.KSIC10, "71519"), (Standards.ISIC4, "7020")),
        ((Standards.KSIC10, "71532"), (Standards.ISIC4, "7020")),
        ((Standards.KSIC10, "62021"), (Standards.ISIC4, "6202")),
        ((Standards.KSIC10, "62022"), (Standards.ISIC4, "6202")),
        ((Standards.KSIC10, "62010"), (Standards.ISIC4, "6201")),
        ((Standards.KSIC10, "63112"), (Standards.ISIC4, "6311")),
        ((Standards.KSIC10, "63111"), (Standards.ISIC4, "6311")),
        ((Standards.KSIC10, "72111"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72112"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72129"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72121"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72923"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72921"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "72924"), (Standards.ISIC4, "7110")),
        ((Standards.KSIC10, "73909"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "72911"), (Standards.ISIC4, "7120")),
        ((Standards.KSIC10, "72919"), (Standards.ISIC4, "7120")),
        ((Standards.KSIC10, "73100"), (Standards.ISIC4, "7500")),
        ((Standards.KSIC10, "71310"), (Standards.ISIC4, "7310")),
        ((Standards.KSIC10, "71391"), (Standards.ISIC4, "7310")),
        ((Standards.KSIC10, "71392"), (Standards.ISIC4, "7310")),
        ((Standards.KSIC10, "58123"), (Standards.ISIC4, "5813")),
        ((Standards.KSIC10, "60100"), (Standards.ISIC4, "6010")),
        ((Standards.KSIC10, "60210"), (Standards.ISIC4, "6020")),
        ((Standards.KSIC10, "63120"), (Standards.ISIC4, "6312")),
        ((Standards.KSIC10, "59113"), (Standards.ISIC4, "5811")),
        ((Standards.KSIC10, "71391"), (Standards.ISIC4, "5812")),
        ((Standards.KSIC10, "71400"), (Standards.ISIC4, "7320")),
        ((Standards.KSIC10, "73302"), (Standards.ISIC4, "7420")),
        ((Standards.KSIC10, "73201"), (Standards.ISIC4, "7410")),
        ((Standards.KSIC10, "73202"), (Standards.ISIC4, "7410")),
        ((Standards.KSIC10, "73209"), (Standards.ISIC4, "7410")),
        ((Standards.KSIC10, "73904"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "73902"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "73901"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "73903"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "61210"), (Standards.ISIC4, "6110")),
        ((Standards.KSIC10, "61210"), (Standards.ISIC4, "6120")),
        ((Standards.KSIC10, "61220"), (Standards.ISIC4, "6130")),
        ((Standards.KSIC10, "61299"), (Standards.ISIC4, "6190")),
        ((Standards.KSIC10, "61220"), (Standards.ISIC4, "6110")),
        ((Standards.KSIC10, "61299"), (Standards.ISIC4, "6130")),
        ((Standards.KSIC10, "61220"), (Standards.ISIC4, "6120")),
        ((Standards.KSIC10, "61299"), (Standards.ISIC4, "6120")),
        ((Standards.KSIC10, "61291"), (Standards.ISIC4, "6110")),
        ((Standards.KSIC10, "61291"), (Standards.ISIC4, "6120")),
        ((Standards.KSIC10, "61291"), (Standards.ISIC4, "6130")),
        ((Standards.KSIC10, "61291"), (Standards.ISIC4, "6190")),
        ((Standards.KSIC10, "61299"), (Standards.ISIC4, "6110")),
        ((Standards.KSIC10, "59112"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "58212"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "63910"), (Standards.ISIC4, "6391")),
        ((Standards.KSIC10, "90211"), (Standards.ISIC4, "9101")),
        ((Standards.KSIC10, "60210"), (Standards.ISIC4, "6010")),
        ((Standards.KSIC10, "60221"), (Standards.ISIC4, "6020")),
        ((Standards.KSIC10, "60222"), (Standards.ISIC4, "6010")),
        ((Standards.KSIC10, "60229"), (Standards.ISIC4, "6010")),
        ((Standards.KSIC10, "60221"), (Standards.ISIC4, "6010")),
        ((Standards.KSIC10, "75110"), (Standards.ISIC4, "7810")),
        ((Standards.KSIC10, "75121"), (Standards.ISIC4, "7810")),
        ((Standards.KSIC10, "75122"), (Standards.ISIC4, "7830")),
        ((Standards.KSIC10, "75330"), (Standards.ISIC4, "8030")),
        ((Standards.KSIC10, "75320"), (Standards.ISIC4, "8020")),
        ((Standards.KSIC10, "75310"), (Standards.ISIC4, "8010")),
        ((Standards.KSIC10, "74220"), (Standards.ISIC4, "8129")),
        ((Standards.KSIC10, "74212"), (Standards.ISIC4, "8129")),
        ((Standards.KSIC10, "74211"), (Standards.ISIC4, "8121")),
        ((Standards.KSIC10, "75994"), (Standards.ISIC4, "8292")),
        ((Standards.KSIC10, "75210"), (Standards.ISIC4, "7911")),
        ((Standards.KSIC10, "75210"), (Standards.ISIC4, "7990")),
        ((Standards.KSIC10, "75290"), (Standards.ISIC4, "7990")),
        ((Standards.KSIC10, "75992"), (Standards.ISIC4, "7990")),
        ((Standards.KSIC10, "75210"), (Standards.ISIC4, "7912")),
        ((Standards.KSIC10, "75993"), (Standards.ISIC4, "8291")),
        ((Standards.KSIC10, "75991"), (Standards.ISIC4, "8220")),
        ((Standards.KSIC10, "71600"), (Standards.ISIC4, "8211")),
        ((Standards.KSIC10, "75912"), (Standards.ISIC4, "8219")),
        ((Standards.KSIC10, "75999"), (Standards.ISIC4, "8299")),
        ((Standards.KSIC10, "75919"), (Standards.ISIC4, "8219")),
        ((Standards.KSIC10, "75911"), (Standards.ISIC4, "8219")),
        ((Standards.KSIC10, "75992"), (Standards.ISIC4, "8230")),
        ((Standards.KSIC10, "74300"), (Standards.ISIC4, "8130")),
        ((Standards.KSIC10, "74100"), (Standards.ISIC4, "7490")),
        ((Standards.KSIC10, "63991"), (Standards.ISIC4, "6399")),
        ((Standards.KSIC10, "73903"), (Standards.ISIC4, "8299")),
        ((Standards.KSIC10, "01412"), (Standards.ISIC4, "0163")),
        ((Standards.KSIC10, "01411"), (Standards.ISIC4, "0164")),
        ((Standards.KSIC10, "01411"), (Standards.ISIC4, "0111")),
        ((Standards.KSIC10, "01420"), (Standards.ISIC4, "0141")),
        ((Standards.KSIC10, "96995"), (Standards.ISIC4, "9609")),
        ((Standards.KSIC10, "01500"), (Standards.ISIC4, "0170")),
        ((Standards.KSIC10, "91199"), (Standards.ISIC4, "9319")),
        ((Standards.KSIC10, "02040"), (Standards.ISIC4, "0210")),
        ((Standards.KSIC10, "02040"), (Standards.ISIC4, "0240")),
        ((Standards.KSIC10, "03220"), (Standards.ISIC4, "0311")),
        ((Standards.KSIC10, "03220"), (Standards.ISIC4, "0321")),
        ((Standards.KSIC10, "08000"), (Standards.ISIC4, "0610")),
        ((Standards.KSIC10, "08000"), (Standards.ISIC4, "0510")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "3311")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "3312")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "9511")),
        ((Standards.KSIC10, "95211"), (Standards.ISIC4, "4520")),
        ((Standards.KSIC10, "95212"), (Standards.ISIC4, "4520")),
        ((Standards.KSIC10, "95213"), (Standards.ISIC4, "4520")),
        ((Standards.KSIC10, "95220"), (Standards.ISIC4, "4540")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "3315")),
        ((Standards.KSIC10, "95399"), (Standards.ISIC4, "9522")),
        ((Standards.KSIC10, "34020"), (Standards.ISIC4, "3314")),
        ((Standards.KSIC10, "95120"), (Standards.ISIC4, "9512")),
        ((Standards.KSIC10, "34020"), (Standards.ISIC4, "3313")),
        ((Standards.KSIC10, "95310"), (Standards.ISIC4, "9521")),
        ((Standards.KSIC10, "34011"), (Standards.ISIC4, "3312")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "4329")),
        ((Standards.KSIC10, "34019"), (Standards.ISIC4, "3319")),
        ((Standards.KSIC10, "95392"), (Standards.ISIC4, "9523")),
        ((Standards.KSIC10, "95393"), (Standards.ISIC4, "9529")),
        ((Standards.KSIC10, "95391"), (Standards.ISIC4, "9529")),
        ((Standards.KSIC10, "95399"), (Standards.ISIC4, "9524")),
        ((Standards.KSIC10, "95399"), (Standards.ISIC4, "3313")),
        ((Standards.KSIC10, "72129"), (Standards.ISIC4, "3320")),
        ((Standards.KSIC10, "62090"), (Standards.ISIC4, "6209")),
        ((Standards.KSIC10, "73909"), (Standards.ISIC4, "9521")),
        ((Standards.KSIC10, "10711"), (Standards.ISIC4, "1071")),
        ((Standards.KSIC10, "11201"), (Standards.ISIC4, "1104")),
        ((Standards.KSIC10, "13401"), (Standards.ISIC4, "1313")),
        ((Standards.KSIC10, "13402"), (Standards.ISIC4, "1313")),
        ((Standards.KSIC10, "13403"), (Standards.ISIC4, "1313")),
        ((Standards.KSIC10, "13409"), (Standards.ISIC4, "1313")),
        ((Standards.KSIC10, "14300"), (Standards.ISIC4, "1430")),
        ((Standards.KSIC10, "22191"), (Standards.ISIC4, "2219")),
        ((Standards.KSIC10, "25921"), (Standards.ISIC4, "2592")),
        ((Standards.KSIC10, "27193"), (Standards.ISIC4, "2670")),
        ((Standards.KSIC10, "30310"), (Standards.ISIC4, "2930")),
        ((Standards.KSIC10, "31999"), (Standards.ISIC4, "3099")),
        ((Standards.KSIC10, "30393"), (Standards.ISIC4, "3100")),
        ((Standards.KSIC10, "33402"), (Standards.ISIC4, "3240")),
        ((Standards.KSIC10, "33409"), (Standards.ISIC4, "3290")),
        ((Standards.KSIC10, "58121"), (Standards.ISIC4, "5819")),
        ((Standards.KSIC10, "58123"), (Standards.ISIC4, "5820")),
        ((Standards.KSIC10, "58190"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "18122"), (Standards.ISIC4, "1812")),
        ((Standards.KSIC10, "18200"), (Standards.ISIC4, "1820")),
        ((Standards.KSIC10, "24311"), (Standards.ISIC4, "2431")),
        ((Standards.KSIC10, "24321"), (Standards.ISIC4, "2432")),
        ((Standards.KSIC10, "25911"), (Standards.ISIC4, "2591")),
        ((Standards.KSIC10, "38311"), (Standards.ISIC4, "3830")),
        ((Standards.KSIC10, "38321"), (Standards.ISIC4, "3830")),
        ((Standards.KSIC10, "84111"), (Standards.ISIC4, "8411")),
        ((Standards.KSIC10, "84114"), (Standards.ISIC4, "8411")),
        ((Standards.KSIC10, "84119"), (Standards.ISIC4, "8411")),
        ((Standards.KSIC10, "84211"), (Standards.ISIC4, "8412")),
        ((Standards.KSIC10, "84214"), (Standards.ISIC4, "8412")),
        ((Standards.KSIC10, "84213"), (Standards.ISIC4, "8412")),
        ((Standards.KSIC10, "84212"), (Standards.ISIC4, "8412")),
        ((Standards.KSIC10, "84222"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84229"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84223"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84120"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84212"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84221"), (Standards.ISIC4, "8413")),
        ((Standards.KSIC10, "84120"), (Standards.ISIC4, "8411")),
        ((Standards.KSIC10, "84310"), (Standards.ISIC4, "8421")),
        ((Standards.KSIC10, "84320"), (Standards.ISIC4, "8422")),
        ((Standards.KSIC10, "84404"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "84405"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "84401"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "84402"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "84403"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "84409"), (Standards.ISIC4, "8423")),
        ((Standards.KSIC10, "65131"), (Standards.ISIC4, "8430")),
        ((Standards.KSIC10, "65303"), (Standards.ISIC4, "8430")),
        ((Standards.KSIC10, "65139"), (Standards.ISIC4, "8430")),
        ((Standards.KSIC10, "84500"), (Standards.ISIC4, "8430")),
        ((Standards.KSIC10, "85110"), (Standards.ISIC4, "8510")),
        ((Standards.KSIC10, "85120"), (Standards.ISIC4, "8510")),
        ((Standards.KSIC10, "85211"), (Standards.ISIC4, "8521")),
        ((Standards.KSIC10, "85212"), (Standards.ISIC4, "8521")),
        ((Standards.KSIC10, "85221"), (Standards.ISIC4, "8522")),
        ((Standards.KSIC10, "85222"), (Standards.ISIC4, "8522")),
        ((Standards.KSIC10, "85229"), (Standards.ISIC4, "8522")),
        ((Standards.KSIC10, "85301"), (Standards.ISIC4, "8530")),
        ((Standards.KSIC10, "85302"), (Standards.ISIC4, "8530")),
        ((Standards.KSIC10, "85621"), (Standards.ISIC4, "8542")),
        ((Standards.KSIC10, "85611"), (Standards.ISIC4, "8541")),
        ((Standards.KSIC10, "85613"), (Standards.ISIC4, "8541")),
        ((Standards.KSIC10, "85640"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85650"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85661"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85669"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85501"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85631"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85502"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85503"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85632"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85410"), (Standards.ISIC4, "8510")),
        ((Standards.KSIC10, "85420"), (Standards.ISIC4, "8510")),
        ((Standards.KSIC10, "85420"), (Standards.ISIC4, "8521")),
        ((Standards.KSIC10, "85430"), (Standards.ISIC4, "8510")),
        ((Standards.KSIC10, "85699"), (Standards.ISIC4, "8549")),
        ((Standards.KSIC10, "85701"), (Standards.ISIC4, "8550")),
        ((Standards.KSIC10, "85709"), (Standards.ISIC4, "8550")),
        ((Standards.KSIC10, "86101"), (Standards.ISIC4, "8610")),
        ((Standards.KSIC10, "86105"), (Standards.ISIC4, "8610")),
        ((Standards.KSIC10, "86201"), (Standards.ISIC4, "8620")),
        ((Standards.KSIC10, "86203"), (Standards.ISIC4, "8620")),
        ((Standards.KSIC10, "86202"), (Standards.ISIC4, "8620")),
        ((Standards.KSIC10, "86204"), (Standards.ISIC4, "8690")),
        ((Standards.KSIC10, "86909"), (Standards.ISIC4, "8690")),
        ((Standards.KSIC10, "86901"), (Standards.ISIC4, "8690")),
        ((Standards.KSIC10, "86902"), (Standards.ISIC4, "8690")),
        ((Standards.KSIC10, "87111"), (Standards.ISIC4, "8710")),
        ((Standards.KSIC10, "87112"), (Standards.ISIC4, "8710")),
        ((Standards.KSIC10, "87121"), (Standards.ISIC4, "8710")),
        ((Standards.KSIC10, "87121"), (Standards.ISIC4, "8730")),
        ((Standards.KSIC10, "87122"), (Standards.ISIC4, "8730")),
        ((Standards.KSIC10, "87122"), (Standards.ISIC4, "8720")),
        ((Standards.KSIC10, "87131"), (Standards.ISIC4, "8790")),
        ((Standards.KSIC10, "87139"), (Standards.ISIC4, "8790")),
        ((Standards.KSIC10, "87291"), (Standards.ISIC4, "8810")),
        ((Standards.KSIC10, "87293"), (Standards.ISIC4, "8810")),
        ((Standards.KSIC10, "87210"), (Standards.ISIC4, "8890")),
        ((Standards.KSIC10, "87293"), (Standards.ISIC4, "8890")),
        ((Standards.KSIC10, "87292"), (Standards.ISIC4, "8890")),
        ((Standards.KSIC10, "87294"), (Standards.ISIC4, "8890")),
        ((Standards.KSIC10, "87299"), (Standards.ISIC4, "8890")),
        ((Standards.KSIC10, "37011"), (Standards.ISIC4, "3700")),
        ((Standards.KSIC10, "37021"), (Standards.ISIC4, "3700")),
        ((Standards.KSIC10, "38120"), (Standards.ISIC4, "3812")),
        ((Standards.KSIC10, "38110"), (Standards.ISIC4, "3811")),
        ((Standards.KSIC10, "38220"), (Standards.ISIC4, "3812")),
        ((Standards.KSIC10, "38210"), (Standards.ISIC4, "3811")),
        ((Standards.KSIC10, "38220"), (Standards.ISIC4, "3822")),
        ((Standards.KSIC10, "38210"), (Standards.ISIC4, "3821")),
        ((Standards.KSIC10, "39009"), (Standards.ISIC4, "3900")),
        ((Standards.KSIC10, "39001"), (Standards.ISIC4, "3900")),
        ((Standards.KSIC10, "94110"), (Standards.ISIC4, "9411")),
        ((Standards.KSIC10, "94120"), (Standards.ISIC4, "9412")),
        ((Standards.KSIC10, "94200"), (Standards.ISIC4, "9420")),
        ((Standards.KSIC10, "94911"), (Standards.ISIC4, "9491")),
        ((Standards.KSIC10, "94920"), (Standards.ISIC4, "9492")),
        ((Standards.KSIC10, "94939"), (Standards.ISIC4, "9499")),
        ((Standards.KSIC10, "94931"), (Standards.ISIC4, "9499")),
        ((Standards.KSIC10, "94990"), (Standards.ISIC4, "9499")),
        ((Standards.KSIC10, "59202"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "59112"), (Standards.ISIC4, "6020")),
        ((Standards.KSIC10, "59112"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "59113"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "59114"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "59201"), (Standards.ISIC4, "5911")),
        ((Standards.KSIC10, "59120"), (Standards.ISIC4, "5912")),
        ((Standards.KSIC10, "59112"), (Standards.ISIC4, "5912")),
        ((Standards.KSIC10, "59120"), (Standards.ISIC4, "5920")),
        ((Standards.KSIC10, "59130"), (Standards.ISIC4, "5913")),
        ((Standards.KSIC10, "59141"), (Standards.ISIC4, "5914")),
        ((Standards.KSIC10, "59142"), (Standards.ISIC4, "5914")),
        ((Standards.KSIC10, "90191"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90121"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90110"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90199"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90131"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90192"), (Standards.ISIC4, "9000")),
        ((Standards.KSIC10, "90222"), (Standards.ISIC4, "9102")),
        ((Standards.KSIC10, "90231"), (Standards.ISIC4, "9103")),
        ((Standards.KSIC10, "91191"), (Standards.ISIC4, "9312")),
        ((Standards.KSIC10, "91111"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91113"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91121"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91131"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91132"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91133"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91134"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91136"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91139"), (Standards.ISIC4, "9311")),
        ((Standards.KSIC10, "91210"), (Standards.ISIC4, "9321")),
        ((Standards.KSIC10, "91249"), (Standards.ISIC4, "9200")),
        ((Standards.KSIC10, "91241"), (Standards.ISIC4, "9200")),
        ((Standards.KSIC10, "91221"), (Standards.ISIC4, "9329")),
        ((Standards.KSIC10, "91222"), (Standards.ISIC4, "9329")),
        ((Standards.KSIC10, "96912"), (Standards.ISIC4, "9601")),
        ((Standards.KSIC10, "96911"), (Standards.ISIC4, "9601")),
        ((Standards.KSIC10, "96913"), (Standards.ISIC4, "9601")),
        ((Standards.KSIC10, "96111"), (Standards.ISIC4, "9602")),
        ((Standards.KSIC10, "96112"), (Standards.ISIC4, "9602")),
        ((Standards.KSIC10, "96113"), (Standards.ISIC4, "9602")),
        ((Standards.KSIC10, "96121"), (Standards.ISIC4, "9609")),
        ((Standards.KSIC10, "96122"), (Standards.ISIC4, "9609")),
        ((Standards.KSIC10, "96119"), (Standards.ISIC4, "9602")),
        ((Standards.KSIC10, "96922"), (Standards.ISIC4, "9603")),
        ((Standards.KSIC10, "96921"), (Standards.ISIC4, "9603")),
        ((Standards.KSIC10, "75310"), (Standards.ISIC4, "9609")),
        ((Standards.KSIC10, "96991"), (Standards.ISIC4, "9609")),
        ((Standards.KSIC10, "97000"), (Standards.ISIC4, "9700")),
        ((Standards.KSIC10, "99001"), (Standards.ISIC4, "9900")),
    ],
)
