"""`Concordance between CNAE2 and ISIC4 <https://concla.ibge.gov.br/images/concla/documentacao/CNAE20_Correspondencia_Cnae20xIsic4.xls>`_."""

from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import CNAE2

CNAE2_to_ISIC4 = Concordance(
    src=CNAE2,
    dst=ISIC4,
    concordances=[
        ((Standards.CNAE2, "A"), (Standards.ISIC4, "A")),
        ((Standards.CNAE2, "01"), (Standards.ISIC4, "01")),
        ((Standards.CNAE2, "01.1"), (Standards.ISIC4, "011")),
        ((Standards.CNAE2, "01.1"), (Standards.ISIC4, "012")),
        ((Standards.CNAE2, "01.11-3"), (Standards.ISIC4, "0111")),
        ((Standards.CNAE2, "01.11-3"), (Standards.ISIC4, "0112")),
        ((Standards.CNAE2, "01.12-1"), (Standards.ISIC4, "0116")),
        ((Standards.CNAE2, "01.13-0"), (Standards.ISIC4, "0114")),
        ((Standards.CNAE2, "01.14-8"), (Standards.ISIC4, "0115")),
        ((Standards.CNAE2, "01.15-6"), (Standards.ISIC4, "0111")),
        ((Standards.CNAE2, "01.16-4"), (Standards.ISIC4, "0111")),
        ((Standards.CNAE2, "01.19-9"), (Standards.ISIC4, "0111")),
        ((Standards.CNAE2, "01.19-9"), (Standards.ISIC4, "0113")),
        ((Standards.CNAE2, "01.19-9"), (Standards.ISIC4, "0119")),
        ((Standards.CNAE2, "01.19-9"), (Standards.ISIC4, "0122")),
        ((Standards.CNAE2, "01.19-9"), (Standards.ISIC4, "0128")),
        ((Standards.CNAE2, "01.2"), (Standards.ISIC4, "011")),
        ((Standards.CNAE2, "01.2"), (Standards.ISIC4, "012")),
        ((Standards.CNAE2, "01.21-1"), (Standards.ISIC4, "0113")),
        ((Standards.CNAE2, "01.21-1"), (Standards.ISIC4, "0125")),
        ((Standards.CNAE2, "01.21-1"), (Standards.ISIC4, "0128")),
        ((Standards.CNAE2, "01.22-9"), (Standards.ISIC4, "0119")),
        ((Standards.CNAE2, "01.3"), (Standards.ISIC4, "011")),
        ((Standards.CNAE2, "01.3"), (Standards.ISIC4, "012")),
        ((Standards.CNAE2, "01.31-8"), (Standards.ISIC4, "0123")),
        ((Standards.CNAE2, "01.32-6"), (Standards.ISIC4, "0121")),
        ((Standards.CNAE2, "01.33-4"), (Standards.ISIC4, "0122")),
        ((Standards.CNAE2, "01.33-4"), (Standards.ISIC4, "0123")),
        ((Standards.CNAE2, "01.33-4"), (Standards.ISIC4, "0124")),
        ((Standards.CNAE2, "01.33-4"), (Standards.ISIC4, "0125")),
        ((Standards.CNAE2, "01.33-4"), (Standards.ISIC4, "0126")),
        ((Standards.CNAE2, "01.34-2"), (Standards.ISIC4, "0127")),
        ((Standards.CNAE2, "01.35-1"), (Standards.ISIC4, "0127")),
        ((Standards.CNAE2, "01.39-3"), (Standards.ISIC4, "0116")),
        ((Standards.CNAE2, "01.39-3"), (Standards.ISIC4, "0126")),
        ((Standards.CNAE2, "01.39-3"), (Standards.ISIC4, "0127")),
        ((Standards.CNAE2, "01.39-3"), (Standards.ISIC4, "0128")),
        ((Standards.CNAE2, "01.39-3"), (Standards.ISIC4, "0129")),
        ((Standards.CNAE2, "01.4"), (Standards.ISIC4, "011")),
        ((Standards.CNAE2, "01.4"), (Standards.ISIC4, "012")),
        ((Standards.CNAE2, "01.4"), (Standards.ISIC4, "013")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0111")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0112")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0113")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0115")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0116")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0119")),
        ((Standards.CNAE2, "01.41-5"), (Standards.ISIC4, "0128")),
        ((Standards.CNAE2, "01.42-3"), (Standards.ISIC4, "0130")),
        ((Standards.CNAE2, "01.5"), (Standards.ISIC4, "014")),
        ((Standards.CNAE2, "01.51-2"), (Standards.ISIC4, "0141")),
        ((Standards.CNAE2, "01.52-1"), (Standards.ISIC4, "0141")),
        ((Standards.CNAE2, "01.52-1"), (Standards.ISIC4, "0142")),
        ((Standards.CNAE2, "01.53-9"), (Standards.ISIC4, "0144")),
        ((Standards.CNAE2, "01.54-7"), (Standards.ISIC4, "0145")),
        ((Standards.CNAE2, "01.55-5"), (Standards.ISIC4, "0146")),
        ((Standards.CNAE2, "01.55-5"), (Standards.ISIC4, "0149")),
        ((Standards.CNAE2, "01.59-8"), (Standards.ISIC4, "0149")),
        ((Standards.CNAE2, "01.6"), (Standards.ISIC4, "016")),
        ((Standards.CNAE2, "01.61-0"), (Standards.ISIC4, "0161")),
        ((Standards.CNAE2, "01.62-8"), (Standards.ISIC4, "0162")),
        ((Standards.CNAE2, "01.63-6"), (Standards.ISIC4, "0163")),
        ((Standards.CNAE2, "01.63-6"), (Standards.ISIC4, "0164")),
        ((Standards.CNAE2, "01.7"), (Standards.ISIC4, "017")),
        ((Standards.CNAE2, "01.70-9"), (Standards.ISIC4, "0170")),
        ((Standards.CNAE2, "02"), (Standards.ISIC4, "02")),
        ((Standards.CNAE2, "02.1"), (Standards.ISIC4, "021")),
        ((Standards.CNAE2, "02.1"), (Standards.ISIC4, "022")),
        ((Standards.CNAE2, "02.1"), (Standards.ISIC4, "023")),
        ((Standards.CNAE2, "02.10-1"), (Standards.ISIC4, "0210")),
        ((Standards.CNAE2, "02.10-1"), (Standards.ISIC4, "0220")),
        ((Standards.CNAE2, "02.10-1"), (Standards.ISIC4, "0230")),
        ((Standards.CNAE2, "02.2"), (Standards.ISIC4, "021")),
        ((Standards.CNAE2, "02.2"), (Standards.ISIC4, "022")),
        ((Standards.CNAE2, "02.2"), (Standards.ISIC4, "023")),
        ((Standards.CNAE2, "02.20-9"), (Standards.ISIC4, "0210")),
        ((Standards.CNAE2, "02.20-9"), (Standards.ISIC4, "0220")),
        ((Standards.CNAE2, "02.20-9"), (Standards.ISIC4, "0230")),
        ((Standards.CNAE2, "02.3"), (Standards.ISIC4, "024")),
        ((Standards.CNAE2, "02.30-6"), (Standards.ISIC4, "0240")),
        ((Standards.CNAE2, "03"), (Standards.ISIC4, "03")),
        ((Standards.CNAE2, "03.1"), (Standards.ISIC4, "031")),
        ((Standards.CNAE2, "03.11-6"), (Standards.ISIC4, "0311")),
        ((Standards.CNAE2, "03.12-4"), (Standards.ISIC4, "0312")),
        ((Standards.CNAE2, "03.2"), (Standards.ISIC4, "032")),
        ((Standards.CNAE2, "03.21-3"), (Standards.ISIC4, "0321")),
        ((Standards.CNAE2, "03.22-1"), (Standards.ISIC4, "0322")),
        ((Standards.CNAE2, "B"), (Standards.ISIC4, "B")),
        ((Standards.CNAE2, "05"), (Standards.ISIC4, "05")),
        ((Standards.CNAE2, "05.0"), (Standards.ISIC4, "051")),
        ((Standards.CNAE2, "05.0"), (Standards.ISIC4, "052")),
        ((Standards.CNAE2, "05.00-3"), (Standards.ISIC4, "0510")),
        ((Standards.CNAE2, "05.00-3"), (Standards.ISIC4, "0520")),
        ((Standards.CNAE2, "06"), (Standards.ISIC4, "06")),
        ((Standards.CNAE2, "06.0"), (Standards.ISIC4, "061")),
        ((Standards.CNAE2, "06.0"), (Standards.ISIC4, "062")),
        ((Standards.CNAE2, "06.00-0"), (Standards.ISIC4, "0610")),
        ((Standards.CNAE2, "06.00-0"), (Standards.ISIC4, "0620")),
        ((Standards.CNAE2, "07"), (Standards.ISIC4, "07")),
        ((Standards.CNAE2, "07.1"), (Standards.ISIC4, "071")),
        ((Standards.CNAE2, "07.10-3"), (Standards.ISIC4, "0710")),
        ((Standards.CNAE2, "07.2"), (Standards.ISIC4, "072")),
        ((Standards.CNAE2, "07.21-9"), (Standards.ISIC4, "0729")),
        ((Standards.CNAE2, "07.22-7"), (Standards.ISIC4, "0729")),
        ((Standards.CNAE2, "07.23-5"), (Standards.ISIC4, "0729")),
        ((Standards.CNAE2, "07.24-3"), (Standards.ISIC4, "0729")),
        ((Standards.CNAE2, "07.25-1"), (Standards.ISIC4, "0721")),
        ((Standards.CNAE2, "07.29-4"), (Standards.ISIC4, "0729")),
        ((Standards.CNAE2, "08"), (Standards.ISIC4, "08")),
        ((Standards.CNAE2, "08.1"), (Standards.ISIC4, "081")),
        ((Standards.CNAE2, "08.10-0"), (Standards.ISIC4, "0810")),
        ((Standards.CNAE2, "08.9"), (Standards.ISIC4, "089")),
        ((Standards.CNAE2, "08.91-6"), (Standards.ISIC4, "0891")),
        ((Standards.CNAE2, "08.92-4"), (Standards.ISIC4, "0893")),
        ((Standards.CNAE2, "08.93-2"), (Standards.ISIC4, "0899")),
        ((Standards.CNAE2, "08.99-1"), (Standards.ISIC4, "0892")),
        ((Standards.CNAE2, "08.99-1"), (Standards.ISIC4, "0899")),
        ((Standards.CNAE2, "09"), (Standards.ISIC4, "09")),
        ((Standards.CNAE2, "09.1"), (Standards.ISIC4, "091")),
        ((Standards.CNAE2, "09.10-6"), (Standards.ISIC4, "0910")),
        ((Standards.CNAE2, "09.9"), (Standards.ISIC4, "099")),
        ((Standards.CNAE2, "09.90-4"), (Standards.ISIC4, "0990")),
        ((Standards.CNAE2, "C"), (Standards.ISIC4, "C")),
        ((Standards.CNAE2, "10"), (Standards.ISIC4, "10")),
        ((Standards.CNAE2, "10.1"), (Standards.ISIC4, "101")),
        ((Standards.CNAE2, "10.11-2"), (Standards.ISIC4, "1010")),
        ((Standards.CNAE2, "10.12-1"), (Standards.ISIC4, "1010")),
        ((Standards.CNAE2, "10.13-9"), (Standards.ISIC4, "1010")),
        ((Standards.CNAE2, "10.2"), (Standards.ISIC4, "102")),
        ((Standards.CNAE2, "10.20-1"), (Standards.ISIC4, "1020")),
        ((Standards.CNAE2, "10.3"), (Standards.ISIC4, "103")),
        ((Standards.CNAE2, "10.31-7"), (Standards.ISIC4, "1030")),
        ((Standards.CNAE2, "10.32-5"), (Standards.ISIC4, "1030")),
        ((Standards.CNAE2, "10.33-3"), (Standards.ISIC4, "1030")),
        ((Standards.CNAE2, "10.4"), (Standards.ISIC4, "104")),
        ((Standards.CNAE2, "10.41-4"), (Standards.ISIC4, "1040")),
        ((Standards.CNAE2, "10.42-2"), (Standards.ISIC4, "1040")),
        ((Standards.CNAE2, "10.43-1"), (Standards.ISIC4, "1040")),
        ((Standards.CNAE2, "10.5"), (Standards.ISIC4, "105")),
        ((Standards.CNAE2, "10.51-1"), (Standards.ISIC4, "1050")),
        ((Standards.CNAE2, "10.52-0"), (Standards.ISIC4, "1050")),
        ((Standards.CNAE2, "10.53-8"), (Standards.ISIC4, "1050")),
        ((Standards.CNAE2, "10.6"), (Standards.ISIC4, "106")),
        ((Standards.CNAE2, "10.6"), (Standards.ISIC4, "108")),
        ((Standards.CNAE2, "10.61-9"), (Standards.ISIC4, "1061")),
        ((Standards.CNAE2, "10.62-7"), (Standards.ISIC4, "1061")),
        ((Standards.CNAE2, "10.63-5"), (Standards.ISIC4, "1061")),
        ((Standards.CNAE2, "10.64-3"), (Standards.ISIC4, "1061")),
        ((Standards.CNAE2, "10.65-1"), (Standards.ISIC4, "1062")),
        ((Standards.CNAE2, "10.66-0"), (Standards.ISIC4, "1080")),
        ((Standards.CNAE2, "10.69-4"), (Standards.ISIC4, "1061")),
        ((Standards.CNAE2, "10.7"), (Standards.ISIC4, "107")),
        ((Standards.CNAE2, "10.71-6"), (Standards.ISIC4, "1072")),
        ((Standards.CNAE2, "10.72-4"), (Standards.ISIC4, "1072")),
        ((Standards.CNAE2, "10.8"), (Standards.ISIC4, "107")),
        ((Standards.CNAE2, "10.81-3"), (Standards.ISIC4, "1079")),
        ((Standards.CNAE2, "10.82-1"), (Standards.ISIC4, "1079")),
        ((Standards.CNAE2, "10.9"), (Standards.ISIC4, "107")),
        ((Standards.CNAE2, "10.91-1"), (Standards.ISIC4, "1071")),
        ((Standards.CNAE2, "10.92-9"), (Standards.ISIC4, "1071")),
        ((Standards.CNAE2, "10.93-7"), (Standards.ISIC4, "1073")),
        ((Standards.CNAE2, "10.94-5"), (Standards.ISIC4, "1074")),
        ((Standards.CNAE2, "10.95-3"), (Standards.ISIC4, "1079")),
        ((Standards.CNAE2, "10.96-1"), (Standards.ISIC4, "1075")),
        ((Standards.CNAE2, "10.99-6"), (Standards.ISIC4, "1079")),
        ((Standards.CNAE2, "11"), (Standards.ISIC4, "11")),
        ((Standards.CNAE2, "11.1"), (Standards.ISIC4, "110")),
        ((Standards.CNAE2, "11.11-9"), (Standards.ISIC4, "1101")),
        ((Standards.CNAE2, "11.12-7"), (Standards.ISIC4, "1102")),
        ((Standards.CNAE2, "11.13-5"), (Standards.ISIC4, "1103")),
        ((Standards.CNAE2, "11.2"), (Standards.ISIC4, "110")),
        ((Standards.CNAE2, "11.21-6"), (Standards.ISIC4, "1104")),
        ((Standards.CNAE2, "11.22-4"), (Standards.ISIC4, "1104")),
        ((Standards.CNAE2, "12"), (Standards.ISIC4, "12")),
        ((Standards.CNAE2, "12.1"), (Standards.ISIC4, "120")),
        ((Standards.CNAE2, "12.10-7"), (Standards.ISIC4, "1200")),
        ((Standards.CNAE2, "12.2"), (Standards.ISIC4, "120")),
        ((Standards.CNAE2, "12.20-4"), (Standards.ISIC4, "1200")),
        ((Standards.CNAE2, "13"), (Standards.ISIC4, "13")),
        ((Standards.CNAE2, "13.1"), (Standards.ISIC4, "131")),
        ((Standards.CNAE2, "13.11-1"), (Standards.ISIC4, "1311")),
        ((Standards.CNAE2, "13.12-0"), (Standards.ISIC4, "1311")),
        ((Standards.CNAE2, "13.13-8"), (Standards.ISIC4, "1311")),
        ((Standards.CNAE2, "13.14-6"), (Standards.ISIC4, "1311")),
        ((Standards.CNAE2, "13.2"), (Standards.ISIC4, "131")),
        ((Standards.CNAE2, "13.21-9"), (Standards.ISIC4, "1312")),
        ((Standards.CNAE2, "13.22-7"), (Standards.ISIC4, "1312")),
        ((Standards.CNAE2, "13.23-5"), (Standards.ISIC4, "1312")),
        ((Standards.CNAE2, "13.3"), (Standards.ISIC4, "139")),
        ((Standards.CNAE2, "13.30-8"), (Standards.ISIC4, "1391")),
        ((Standards.CNAE2, "13.4"), (Standards.ISIC4, "131")),
        ((Standards.CNAE2, "13.40-5"), (Standards.ISIC4, "1313")),
        ((Standards.CNAE2, "13.5"), (Standards.ISIC4, "139")),
        ((Standards.CNAE2, "13.51-1"), (Standards.ISIC4, "1392")),
        ((Standards.CNAE2, "13.52-9"), (Standards.ISIC4, "1393")),
        ((Standards.CNAE2, "13.53-7"), (Standards.ISIC4, "1394")),
        ((Standards.CNAE2, "13.54-5"), (Standards.ISIC4, "1399")),
        ((Standards.CNAE2, "13.59-6"), (Standards.ISIC4, "1399")),
        ((Standards.CNAE2, "14"), (Standards.ISIC4, "14")),
        ((Standards.CNAE2, "14.1"), (Standards.ISIC4, "141")),
        ((Standards.CNAE2, "14.1"), (Standards.ISIC4, "142")),
        ((Standards.CNAE2, "14.11-8"), (Standards.ISIC4, "1410")),
        ((Standards.CNAE2, "14.12-6"), (Standards.ISIC4, "1410")),
        ((Standards.CNAE2, "14.13-4"), (Standards.ISIC4, "1410")),
        ((Standards.CNAE2, "14.14-2"), (Standards.ISIC4, "1410")),
        ((Standards.CNAE2, "14.14-2"), (Standards.ISIC4, "1420")),
        ((Standards.CNAE2, "14.2"), (Standards.ISIC4, "143")),
        ((Standards.CNAE2, "14.21-5"), (Standards.ISIC4, "1430")),
        ((Standards.CNAE2, "14.22-3"), (Standards.ISIC4, "1430")),
        ((Standards.CNAE2, "15"), (Standards.ISIC4, "15")),
        ((Standards.CNAE2, "15"), (Standards.ISIC4, "16")),
        ((Standards.CNAE2, "15"), (Standards.ISIC4, "22")),
        ((Standards.CNAE2, "15.1"), (Standards.ISIC4, "151")),
        ((Standards.CNAE2, "15.10-6"), (Standards.ISIC4, "1511")),
        ((Standards.CNAE2, "15.2"), (Standards.ISIC4, "151")),
        ((Standards.CNAE2, "15.21-1"), (Standards.ISIC4, "1512")),
        ((Standards.CNAE2, "15.29-7"), (Standards.ISIC4, "1512")),
        ((Standards.CNAE2, "15.3"), (Standards.ISIC4, "152")),
        ((Standards.CNAE2, "15.31-9"), (Standards.ISIC4, "1520")),
        ((Standards.CNAE2, "15.32-7"), (Standards.ISIC4, "1520")),
        ((Standards.CNAE2, "15.33-5"), (Standards.ISIC4, "1520")),
        ((Standards.CNAE2, "15.39-4"), (Standards.ISIC4, "1520")),
        ((Standards.CNAE2, "15.4"), (Standards.ISIC4, "162")),
        ((Standards.CNAE2, "15.4"), (Standards.ISIC4, "221")),
        ((Standards.CNAE2, "15.4"), (Standards.ISIC4, "222")),
        ((Standards.CNAE2, "15.40-8"), (Standards.ISIC4, "1520")),
        ((Standards.CNAE2, "15.40-8"), (Standards.ISIC4, "1629")),
        ((Standards.CNAE2, "15.40-8"), (Standards.ISIC4, "2219")),
        ((Standards.CNAE2, "15.40-8"), (Standards.ISIC4, "2220")),
        ((Standards.CNAE2, "16"), (Standards.ISIC4, "16")),
        ((Standards.CNAE2, "16.1"), (Standards.ISIC4, "161")),
        ((Standards.CNAE2, "16.10-2"), (Standards.ISIC4, "1610")),
        ((Standards.CNAE2, "16.2"), (Standards.ISIC4, "162")),
        ((Standards.CNAE2, "16.21-8"), (Standards.ISIC4, "1621")),
        ((Standards.CNAE2, "16.22-6"), (Standards.ISIC4, "1622")),
        ((Standards.CNAE2, "16.23-4"), (Standards.ISIC4, "1623")),
        ((Standards.CNAE2, "16.29-3"), (Standards.ISIC4, "1629")),
        ((Standards.CNAE2, "17"), (Standards.ISIC4, "17")),
        ((Standards.CNAE2, "17.1"), (Standards.ISIC4, "170")),
        ((Standards.CNAE2, "17.10-9"), (Standards.ISIC4, "1701")),
        ((Standards.CNAE2, "17.2"), (Standards.ISIC4, "170")),
        ((Standards.CNAE2, "17.21-4"), (Standards.ISIC4, "1701")),
        ((Standards.CNAE2, "17.22-2"), (Standards.ISIC4, "1701")),
        ((Standards.CNAE2, "17.3"), (Standards.ISIC4, "170")),
        ((Standards.CNAE2, "17.31-1"), (Standards.ISIC4, "1702")),
        ((Standards.CNAE2, "17.32-0"), (Standards.ISIC4, "1702")),
        ((Standards.CNAE2, "17.33-8"), (Standards.ISIC4, "1702")),
        ((Standards.CNAE2, "17.4"), (Standards.ISIC4, "170")),
        ((Standards.CNAE2, "17.41-9"), (Standards.ISIC4, "1709")),
        ((Standards.CNAE2, "17.42-7"), (Standards.ISIC4, "1709")),
        ((Standards.CNAE2, "17.49-4"), (Standards.ISIC4, "1709")),
        ((Standards.CNAE2, "18"), (Standards.ISIC4, "18")),
        ((Standards.CNAE2, "18.1"), (Standards.ISIC4, "181")),
        ((Standards.CNAE2, "18.11-3"), (Standards.ISIC4, "1811")),
        ((Standards.CNAE2, "18.12-1"), (Standards.ISIC4, "1811")),
        ((Standards.CNAE2, "18.13-0"), (Standards.ISIC4, "1811")),
        ((Standards.CNAE2, "18.2"), (Standards.ISIC4, "181")),
        ((Standards.CNAE2, "18.21-1"), (Standards.ISIC4, "1812")),
        ((Standards.CNAE2, "18.22-9"), (Standards.ISIC4, "1812")),
        ((Standards.CNAE2, "18.3"), (Standards.ISIC4, "182")),
        ((Standards.CNAE2, "18.30-0"), (Standards.ISIC4, "1820")),
        ((Standards.CNAE2, "19"), (Standards.ISIC4, "19")),
        ((Standards.CNAE2, "19"), (Standards.ISIC4, "20")),
        ((Standards.CNAE2, "19.1"), (Standards.ISIC4, "191")),
        ((Standards.CNAE2, "19.10-1"), (Standards.ISIC4, "1910")),
        ((Standards.CNAE2, "19.2"), (Standards.ISIC4, "192")),
        ((Standards.CNAE2, "19.21-7"), (Standards.ISIC4, "1920")),
        ((Standards.CNAE2, "19.22-5"), (Standards.ISIC4, "1920")),
        ((Standards.CNAE2, "19.3"), (Standards.ISIC4, "201")),
        ((Standards.CNAE2, "19.31-4"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "19.32-2"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20"), (Standards.ISIC4, "20")),
        ((Standards.CNAE2, "20.1"), (Standards.ISIC4, "201")),
        ((Standards.CNAE2, "20.11-8"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.12-6"), (Standards.ISIC4, "2012")),
        ((Standards.CNAE2, "20.13-4"), (Standards.ISIC4, "2012")),
        ((Standards.CNAE2, "20.14-2"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.19-3"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.2"), (Standards.ISIC4, "201")),
        ((Standards.CNAE2, "20.21-5"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.22-3"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.29-1"), (Standards.ISIC4, "2011")),
        ((Standards.CNAE2, "20.29-1"), (Standards.ISIC4, "1910")),
        ((Standards.CNAE2, "20.3"), (Standards.ISIC4, "201")),
        ((Standards.CNAE2, "20.31-2"), (Standards.ISIC4, "2013")),
        ((Standards.CNAE2, "20.32-1"), (Standards.ISIC4, "2013")),
        ((Standards.CNAE2, "20.33-9"), (Standards.ISIC4, "2013")),
        ((Standards.CNAE2, "20.4"), (Standards.ISIC4, "203")),
        ((Standards.CNAE2, "20.40-1"), (Standards.ISIC4, "2030")),
        ((Standards.CNAE2, "20.5"), (Standards.ISIC4, "202")),
        ((Standards.CNAE2, "20.51-7"), (Standards.ISIC4, "2021")),
        ((Standards.CNAE2, "20.52-5"), (Standards.ISIC4, "2021")),
        ((Standards.CNAE2, "20.6"), (Standards.ISIC4, "202")),
        ((Standards.CNAE2, "20.61-4"), (Standards.ISIC4, "2023")),
        ((Standards.CNAE2, "20.62-2"), (Standards.ISIC4, "2023")),
        ((Standards.CNAE2, "20.63-1"), (Standards.ISIC4, "2023")),
        ((Standards.CNAE2, "20.7"), (Standards.ISIC4, "202")),
        ((Standards.CNAE2, "20.71-1"), (Standards.ISIC4, "2022")),
        ((Standards.CNAE2, "20.72-0"), (Standards.ISIC4, "2022")),
        ((Standards.CNAE2, "20.73-8"), (Standards.ISIC4, "2022")),
        ((Standards.CNAE2, "20.9"), (Standards.ISIC4, "202")),
        ((Standards.CNAE2, "20.91-6"), (Standards.ISIC4, "2029")),
        ((Standards.CNAE2, "20.92-4"), (Standards.ISIC4, "2029")),
        ((Standards.CNAE2, "20.93-2"), (Standards.ISIC4, "2029")),
        ((Standards.CNAE2, "20.94-1"), (Standards.ISIC4, "2029")),
        ((Standards.CNAE2, "20.99-1"), (Standards.ISIC4, "2029")),
        ((Standards.CNAE2, "21"), (Standards.ISIC4, "21")),
        ((Standards.CNAE2, "21.1"), (Standards.ISIC4, "210")),
        ((Standards.CNAE2, "21.10-6"), (Standards.ISIC4, "2100")),
        ((Standards.CNAE2, "21.2"), (Standards.ISIC4, "210")),
        ((Standards.CNAE2, "21.21-1"), (Standards.ISIC4, "2100")),
        ((Standards.CNAE2, "21.22-0"), (Standards.ISIC4, "2100")),
        ((Standards.CNAE2, "21.23-8"), (Standards.ISIC4, "2100")),
        ((Standards.CNAE2, "22"), (Standards.ISIC4, "22")),
        ((Standards.CNAE2, "22.1"), (Standards.ISIC4, "221")),
        ((Standards.CNAE2, "22.11-1"), (Standards.ISIC4, "2211")),
        ((Standards.CNAE2, "22.12-9"), (Standards.ISIC4, "2211")),
        ((Standards.CNAE2, "22.19-6"), (Standards.ISIC4, "2219")),
        ((Standards.CNAE2, "22.2"), (Standards.ISIC4, "222")),
        ((Standards.CNAE2, "22.21-8"), (Standards.ISIC4, "2220")),
        ((Standards.CNAE2, "22.22-6"), (Standards.ISIC4, "2220")),
        ((Standards.CNAE2, "22.23-4"), (Standards.ISIC4, "2220")),
        ((Standards.CNAE2, "22.29-3"), (Standards.ISIC4, "2220")),
        ((Standards.CNAE2, "23"), (Standards.ISIC4, "23")),
        ((Standards.CNAE2, "23.1"), (Standards.ISIC4, "231")),
        ((Standards.CNAE2, "23.11-7"), (Standards.ISIC4, "2310")),
        ((Standards.CNAE2, "23.12-5"), (Standards.ISIC4, "2310")),
        ((Standards.CNAE2, "23.19-2"), (Standards.ISIC4, "2310")),
        ((Standards.CNAE2, "23.2"), (Standards.ISIC4, "239")),
        ((Standards.CNAE2, "23.20-6"), (Standards.ISIC4, "2394")),
        ((Standards.CNAE2, "23.3"), (Standards.ISIC4, "239")),
        ((Standards.CNAE2, "23.30-3"), (Standards.ISIC4, "2395")),
        ((Standards.CNAE2, "23.4"), (Standards.ISIC4, "239")),
        ((Standards.CNAE2, "23.41-9"), (Standards.ISIC4, "2391")),
        ((Standards.CNAE2, "23.42-7"), (Standards.ISIC4, "2392")),
        ((Standards.CNAE2, "23.49-4"), (Standards.ISIC4, "2393")),
        ((Standards.CNAE2, "23.9"), (Standards.ISIC4, "239")),
        ((Standards.CNAE2, "23.91-5"), (Standards.ISIC4, "2396")),
        ((Standards.CNAE2, "23.92-3"), (Standards.ISIC4, "2394")),
        ((Standards.CNAE2, "23.99-1"), (Standards.ISIC4, "2399")),
        ((Standards.CNAE2, "24"), (Standards.ISIC4, "24")),
        ((Standards.CNAE2, "24.1"), (Standards.ISIC4, "241")),
        ((Standards.CNAE2, "24.11-3"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.12-1"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.2"), (Standards.ISIC4, "241")),
        ((Standards.CNAE2, "24.21-1"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.22-9"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.23-7"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.24-5"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.3"), (Standards.ISIC4, "241")),
        ((Standards.CNAE2, "24.31-8"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.39-3"), (Standards.ISIC4, "2410")),
        ((Standards.CNAE2, "24.4"), (Standards.ISIC4, "242")),
        ((Standards.CNAE2, "24.41-5"), (Standards.ISIC4, "2420")),
        ((Standards.CNAE2, "24.42-3"), (Standards.ISIC4, "2420")),
        ((Standards.CNAE2, "24.43-1"), (Standards.ISIC4, "2420")),
        ((Standards.CNAE2, "24.49-1"), (Standards.ISIC4, "2420")),
        ((Standards.CNAE2, "24.5"), (Standards.ISIC4, "243")),
        ((Standards.CNAE2, "24.51-2"), (Standards.ISIC4, "2431")),
        ((Standards.CNAE2, "24.52-1"), (Standards.ISIC4, "2432")),
        ((Standards.CNAE2, "25"), (Standards.ISIC4, "25")),
        ((Standards.CNAE2, "25.1"), (Standards.ISIC4, "251")),
        ((Standards.CNAE2, "25.11-0"), (Standards.ISIC4, "2511")),
        ((Standards.CNAE2, "25.12-8"), (Standards.ISIC4, "2511")),
        ((Standards.CNAE2, "25.13-6"), (Standards.ISIC4, "2511")),
        ((Standards.CNAE2, "25.2"), (Standards.ISIC4, "251")),
        ((Standards.CNAE2, "25.21-7"), (Standards.ISIC4, "2512")),
        ((Standards.CNAE2, "25.22-5"), (Standards.ISIC4, "2513")),
        ((Standards.CNAE2, "25.3"), (Standards.ISIC4, "259")),
        ((Standards.CNAE2, "25.31-4"), (Standards.ISIC4, "2591")),
        ((Standards.CNAE2, "25.32-2"), (Standards.ISIC4, "2591")),
        ((Standards.CNAE2, "25.39-0"), (Standards.ISIC4, "2592")),
        ((Standards.CNAE2, "25.4"), (Standards.ISIC4, "259")),
        ((Standards.CNAE2, "25.41-1"), (Standards.ISIC4, "2593")),
        ((Standards.CNAE2, "25.42-0"), (Standards.ISIC4, "2593")),
        ((Standards.CNAE2, "25.43-8"), (Standards.ISIC4, "2593")),
        ((Standards.CNAE2, "25.5"), (Standards.ISIC4, "252")),
        ((Standards.CNAE2, "25.50-1"), (Standards.ISIC4, "2520")),
        ((Standards.CNAE2, "25.9"), (Standards.ISIC4, "259")),
        ((Standards.CNAE2, "25.91-8"), (Standards.ISIC4, "2599")),
        ((Standards.CNAE2, "25.92-6"), (Standards.ISIC4, "2599")),
        ((Standards.CNAE2, "25.93-4"), (Standards.ISIC4, "2599")),
        ((Standards.CNAE2, "25.99-3"), (Standards.ISIC4, "2599")),
        ((Standards.CNAE2, "26"), (Standards.ISIC4, "26")),
        ((Standards.CNAE2, "26.1"), (Standards.ISIC4, "261")),
        ((Standards.CNAE2, "26.10-8"), (Standards.ISIC4, "2610")),
        ((Standards.CNAE2, "26.2"), (Standards.ISIC4, "262")),
        ((Standards.CNAE2, "26.21-3"), (Standards.ISIC4, "2620")),
        ((Standards.CNAE2, "26.22-1"), (Standards.ISIC4, "2620")),
        ((Standards.CNAE2, "26.3"), (Standards.ISIC4, "263")),
        ((Standards.CNAE2, "26.31-1"), (Standards.ISIC4, "2630")),
        ((Standards.CNAE2, "26.32-9"), (Standards.ISIC4, "2630")),
        ((Standards.CNAE2, "26.4"), (Standards.ISIC4, "264")),
        ((Standards.CNAE2, "26.40-0"), (Standards.ISIC4, "2640")),
        ((Standards.CNAE2, "26.5"), (Standards.ISIC4, "265")),
        ((Standards.CNAE2, "26.51-5"), (Standards.ISIC4, "2651")),
        ((Standards.CNAE2, "26.52-3"), (Standards.ISIC4, "2652")),
        ((Standards.CNAE2, "26.6"), (Standards.ISIC4, "266")),
        ((Standards.CNAE2, "26.60-4"), (Standards.ISIC4, "2660")),
        ((Standards.CNAE2, "26.7"), (Standards.ISIC4, "267")),
        ((Standards.CNAE2, "26.70-1"), (Standards.ISIC4, "2670")),
        ((Standards.CNAE2, "26.8"), (Standards.ISIC4, "268")),
        ((Standards.CNAE2, "26.80-9"), (Standards.ISIC4, "2680")),
        ((Standards.CNAE2, "27"), (Standards.ISIC4, "27")),
        ((Standards.CNAE2, "27.1"), (Standards.ISIC4, "271")),
        ((Standards.CNAE2, "27.10-4"), (Standards.ISIC4, "2710")),
        ((Standards.CNAE2, "27.2"), (Standards.ISIC4, "272")),
        ((Standards.CNAE2, "27.21-0"), (Standards.ISIC4, "2720")),
        ((Standards.CNAE2, "27.22-8"), (Standards.ISIC4, "2720")),
        ((Standards.CNAE2, "27.3"), (Standards.ISIC4, "271")),
        ((Standards.CNAE2, "27.3"), (Standards.ISIC4, "273")),
        ((Standards.CNAE2, "27.31-7"), (Standards.ISIC4, "2710")),
        ((Standards.CNAE2, "27.32-5"), (Standards.ISIC4, "2733")),
        ((Standards.CNAE2, "27.33-3"), (Standards.ISIC4, "2731")),
        ((Standards.CNAE2, "27.33-3"), (Standards.ISIC4, "2732")),
        ((Standards.CNAE2, "27.4"), (Standards.ISIC4, "274")),
        ((Standards.CNAE2, "27.40-6"), (Standards.ISIC4, "2740")),
        ((Standards.CNAE2, "27.5"), (Standards.ISIC4, "275")),
        ((Standards.CNAE2, "27.51-1"), (Standards.ISIC4, "2750")),
        ((Standards.CNAE2, "27.59-7"), (Standards.ISIC4, "2750")),
        ((Standards.CNAE2, "27.9"), (Standards.ISIC4, "279")),
        ((Standards.CNAE2, "27.90-2"), (Standards.ISIC4, "2790")),
        ((Standards.CNAE2, "28"), (Standards.ISIC4, "28")),
        ((Standards.CNAE2, "28.1"), (Standards.ISIC4, "281")),
        ((Standards.CNAE2, "28.11-9"), (Standards.ISIC4, "2811")),
        ((Standards.CNAE2, "28.12-7"), (Standards.ISIC4, "2812")),
        ((Standards.CNAE2, "28.12-7"), (Standards.ISIC4, "2813")),
        ((Standards.CNAE2, "28.13-5"), (Standards.ISIC4, "2813")),
        ((Standards.CNAE2, "28.14-3"), (Standards.ISIC4, "2813")),
        ((Standards.CNAE2, "28.15-1"), (Standards.ISIC4, "2814")),
        ((Standards.CNAE2, "28.2"), (Standards.ISIC4, "281")),
        ((Standards.CNAE2, "28.21-6"), (Standards.ISIC4, "2815")),
        ((Standards.CNAE2, "28.22-4"), (Standards.ISIC4, "2816")),
        ((Standards.CNAE2, "28.23-2"), (Standards.ISIC4, "2819")),
        ((Standards.CNAE2, "28.24-1"), (Standards.ISIC4, "2819")),
        ((Standards.CNAE2, "28.25-9"), (Standards.ISIC4, "2819")),
        ((Standards.CNAE2, "28.29-1"), (Standards.ISIC4, "2817")),
        ((Standards.CNAE2, "28.29-1"), (Standards.ISIC4, "2819")),
        ((Standards.CNAE2, "28.3"), (Standards.ISIC4, "282")),
        ((Standards.CNAE2, "28.31-3"), (Standards.ISIC4, "2821")),
        ((Standards.CNAE2, "28.32-1"), (Standards.ISIC4, "2821")),
        ((Standards.CNAE2, "28.33-0"), (Standards.ISIC4, "2821")),
        ((Standards.CNAE2, "28.4"), (Standards.ISIC4, "281")),
        ((Standards.CNAE2, "28.4"), (Standards.ISIC4, "282")),
        ((Standards.CNAE2, "28.40-2"), (Standards.ISIC4, "2818")),
        ((Standards.CNAE2, "28.40-2"), (Standards.ISIC4, "2822")),
        ((Standards.CNAE2, "28.5"), (Standards.ISIC4, "282")),
        ((Standards.CNAE2, "28.51-8"), (Standards.ISIC4, "2824")),
        ((Standards.CNAE2, "28.52-6"), (Standards.ISIC4, "2824")),
        ((Standards.CNAE2, "28.53-4"), (Standards.ISIC4, "2824")),
        ((Standards.CNAE2, "28.54-2"), (Standards.ISIC4, "2824")),
        ((Standards.CNAE2, "28.6"), (Standards.ISIC4, "282")),
        ((Standards.CNAE2, "28.61-5"), (Standards.ISIC4, "2823")),
        ((Standards.CNAE2, "28.62-3"), (Standards.ISIC4, "2825")),
        ((Standards.CNAE2, "28.63-1"), (Standards.ISIC4, "2826")),
        ((Standards.CNAE2, "28.64-0"), (Standards.ISIC4, "2826")),
        ((Standards.CNAE2, "28.65-8"), (Standards.ISIC4, "2829")),
        ((Standards.CNAE2, "28.66-6"), (Standards.ISIC4, "2829")),
        ((Standards.CNAE2, "28.69-1"), (Standards.ISIC4, "2829")),
        ((Standards.CNAE2, "29"), (Standards.ISIC4, "29")),
        ((Standards.CNAE2, "29.1"), (Standards.ISIC4, "291")),
        ((Standards.CNAE2, "29.10-7"), (Standards.ISIC4, "2910")),
        ((Standards.CNAE2, "29.2"), (Standards.ISIC4, "291")),
        ((Standards.CNAE2, "29.20-4"), (Standards.ISIC4, "2910")),
        ((Standards.CNAE2, "29.3"), (Standards.ISIC4, "292")),
        ((Standards.CNAE2, "29.30-1"), (Standards.ISIC4, "2920")),
        ((Standards.CNAE2, "29.4"), (Standards.ISIC4, "293")),
        ((Standards.CNAE2, "29.41-7"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.42-5"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.43-3"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.44-1"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.45-0"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.49-2"), (Standards.ISIC4, "2930")),
        ((Standards.CNAE2, "29.5"), (Standards.ISIC4, "291")),
        ((Standards.CNAE2, "29.50-6"), (Standards.ISIC4, "2910")),
        ((Standards.CNAE2, "30"), (Standards.ISIC4, "30")),
        ((Standards.CNAE2, "30"), (Standards.ISIC4, "33")),
        ((Standards.CNAE2, "30.1"), (Standards.ISIC4, "301")),
        ((Standards.CNAE2, "30.11-3"), (Standards.ISIC4, "3011")),
        ((Standards.CNAE2, "30.12-1"), (Standards.ISIC4, "3012")),
        ((Standards.CNAE2, "30.3"), (Standards.ISIC4, "302")),
        ((Standards.CNAE2, "30.31-8"), (Standards.ISIC4, "3020")),
        ((Standards.CNAE2, "30.32-6"), (Standards.ISIC4, "3020")),
        ((Standards.CNAE2, "30.4"), (Standards.ISIC4, "303")),
        ((Standards.CNAE2, "30.41-5"), (Standards.ISIC4, "3030")),
        ((Standards.CNAE2, "30.42-3"), (Standards.ISIC4, "3030")),
        ((Standards.CNAE2, "30.5"), (Standards.ISIC4, "304")),
        ((Standards.CNAE2, "30.50-4"), (Standards.ISIC4, "3040")),
        ((Standards.CNAE2, "30.9"), (Standards.ISIC4, "309")),
        ((Standards.CNAE2, "30.91-1"), (Standards.ISIC4, "3091")),
        ((Standards.CNAE2, "30.92-0"), (Standards.ISIC4, "3092")),
        ((Standards.CNAE2, "30.99-7"), (Standards.ISIC4, "3099")),
        ((Standards.CNAE2, "31"), (Standards.ISIC4, "31")),
        ((Standards.CNAE2, "31.0"), (Standards.ISIC4, "310")),
        ((Standards.CNAE2, "31.01-2"), (Standards.ISIC4, "3100")),
        ((Standards.CNAE2, "31.02-1"), (Standards.ISIC4, "3100")),
        ((Standards.CNAE2, "31.03-9"), (Standards.ISIC4, "3100")),
        ((Standards.CNAE2, "31.04-7"), (Standards.ISIC4, "3100")),
        ((Standards.CNAE2, "32"), (Standards.ISIC4, "32")),
        ((Standards.CNAE2, "32.1"), (Standards.ISIC4, "321")),
        ((Standards.CNAE2, "32.11-6"), (Standards.ISIC4, "3211")),
        ((Standards.CNAE2, "32.12-4"), (Standards.ISIC4, "3212")),
        ((Standards.CNAE2, "32.2"), (Standards.ISIC4, "322")),
        ((Standards.CNAE2, "32.20-5"), (Standards.ISIC4, "3220")),
        ((Standards.CNAE2, "32.3"), (Standards.ISIC4, "323")),
        ((Standards.CNAE2, "32.30-2"), (Standards.ISIC4, "3230")),
        ((Standards.CNAE2, "32.4"), (Standards.ISIC4, "324")),
        ((Standards.CNAE2, "32.40-0"), (Standards.ISIC4, "3240")),
        ((Standards.CNAE2, "32.5"), (Standards.ISIC4, "325")),
        ((Standards.CNAE2, "32.50-7"), (Standards.ISIC4, "3250")),
        ((Standards.CNAE2, "32.9"), (Standards.ISIC4, "329")),
        ((Standards.CNAE2, "32.91-4"), (Standards.ISIC4, "3290")),
        ((Standards.CNAE2, "32.92-2"), (Standards.ISIC4, "3290")),
        ((Standards.CNAE2, "32.99-0"), (Standards.ISIC4, "3290")),
        ((Standards.CNAE2, "33"), (Standards.ISIC4, "33")),
        ((Standards.CNAE2, "33.1"), (Standards.ISIC4, "331")),
        ((Standards.CNAE2, "33.11-2"), (Standards.ISIC4, "3311")),
        ((Standards.CNAE2, "33.12-1"), (Standards.ISIC4, "3313")),
        ((Standards.CNAE2, "33.13-9"), (Standards.ISIC4, "3314")),
        ((Standards.CNAE2, "33.14-7"), (Standards.ISIC4, "3312")),
        ((Standards.CNAE2, "33.15-5"), (Standards.ISIC4, "3315")),
        ((Standards.CNAE2, "33.16-3"), (Standards.ISIC4, "3315")),
        ((Standards.CNAE2, "33.17-1"), (Standards.ISIC4, "3315")),
        ((Standards.CNAE2, "33.19-8"), (Standards.ISIC4, "3319")),
        ((Standards.CNAE2, "33.2"), (Standards.ISIC4, "332")),
        ((Standards.CNAE2, "33.21-0"), (Standards.ISIC4, "3320")),
        ((Standards.CNAE2, "33.29-5"), (Standards.ISIC4, "3320")),
        ((Standards.CNAE2, "D"), (Standards.ISIC4, "D")),
        ((Standards.CNAE2, "35"), (Standards.ISIC4, "35")),
        ((Standards.CNAE2, "35.1"), (Standards.ISIC4, "351")),
        ((Standards.CNAE2, "35.11-5"), (Standards.ISIC4, "3510")),
        ((Standards.CNAE2, "35.12-3"), (Standards.ISIC4, "3510")),
        ((Standards.CNAE2, "35.13-1"), (Standards.ISIC4, "3510")),
        ((Standards.CNAE2, "35.14-0"), (Standards.ISIC4, "3510")),
        ((Standards.CNAE2, "35.2"), (Standards.ISIC4, "352")),
        ((Standards.CNAE2, "35.20-4"), (Standards.ISIC4, "3520")),
        ((Standards.CNAE2, "35.3"), (Standards.ISIC4, "353")),
        ((Standards.CNAE2, "35.30-1"), (Standards.ISIC4, "3530")),
        ((Standards.CNAE2, "E"), (Standards.ISIC4, "E")),
        ((Standards.CNAE2, "36"), (Standards.ISIC4, "36")),
        ((Standards.CNAE2, "36.0"), (Standards.ISIC4, "360")),
        ((Standards.CNAE2, "36.00-6"), (Standards.ISIC4, "3600")),
        ((Standards.CNAE2, "37"), (Standards.ISIC4, "37")),
        ((Standards.CNAE2, "37.0"), (Standards.ISIC4, "370")),
        ((Standards.CNAE2, "37.01-1"), (Standards.ISIC4, "3700")),
        ((Standards.CNAE2, "37.02-9"), (Standards.ISIC4, "3700")),
        ((Standards.CNAE2, "38"), (Standards.ISIC4, "38")),
        ((Standards.CNAE2, "38.1"), (Standards.ISIC4, "381")),
        ((Standards.CNAE2, "38.11-4"), (Standards.ISIC4, "3811")),
        ((Standards.CNAE2, "38.12-2"), (Standards.ISIC4, "3812")),
        ((Standards.CNAE2, "38.2"), (Standards.ISIC4, "382")),
        ((Standards.CNAE2, "38.21-1"), (Standards.ISIC4, "3821")),
        ((Standards.CNAE2, "38.22-0"), (Standards.ISIC4, "3822")),
        ((Standards.CNAE2, "38.3"), (Standards.ISIC4, "383")),
        ((Standards.CNAE2, "38.31-9"), (Standards.ISIC4, "3830")),
        ((Standards.CNAE2, "38.32-7"), (Standards.ISIC4, "3830")),
        ((Standards.CNAE2, "38.39-4"), (Standards.ISIC4, "3830")),
        ((Standards.CNAE2, "39"), (Standards.ISIC4, "39")),
        ((Standards.CNAE2, "39.0"), (Standards.ISIC4, "390")),
        ((Standards.CNAE2, "39.00-5"), (Standards.ISIC4, "3900")),
        ((Standards.CNAE2, "F"), (Standards.ISIC4, "F")),
        ((Standards.CNAE2, "41"), (Standards.ISIC4, "41")),
        ((Standards.CNAE2, "41.1"), (Standards.ISIC4, "410")),
        ((Standards.CNAE2, "41.10-7"), (Standards.ISIC4, "4100")),
        ((Standards.CNAE2, "41.2"), (Standards.ISIC4, "410")),
        ((Standards.CNAE2, "41.20-4"), (Standards.ISIC4, "4100")),
        ((Standards.CNAE2, "42"), (Standards.ISIC4, "42")),
        ((Standards.CNAE2, "42.1"), (Standards.ISIC4, "421")),
        ((Standards.CNAE2, "42.11-1"), (Standards.ISIC4, "4210")),
        ((Standards.CNAE2, "42.12-0"), (Standards.ISIC4, "4210")),
        ((Standards.CNAE2, "42.13-8"), (Standards.ISIC4, "4210")),
        ((Standards.CNAE2, "42.2"), (Standards.ISIC4, "422")),
        ((Standards.CNAE2, "42.21-9"), (Standards.ISIC4, "4220")),
        ((Standards.CNAE2, "42.22-7"), (Standards.ISIC4, "4220")),
        ((Standards.CNAE2, "42.23-5"), (Standards.ISIC4, "4220")),
        ((Standards.CNAE2, "42.9"), (Standards.ISIC4, "429")),
        ((Standards.CNAE2, "42.91-0"), (Standards.ISIC4, "4290")),
        ((Standards.CNAE2, "42.92-8"), (Standards.ISIC4, "4290")),
        ((Standards.CNAE2, "42.99-5"), (Standards.ISIC4, "4290")),
        ((Standards.CNAE2, "43"), (Standards.ISIC4, "43")),
        ((Standards.CNAE2, "43.1"), (Standards.ISIC4, "431")),
        ((Standards.CNAE2, "43.11-8"), (Standards.ISIC4, "4311")),
        ((Standards.CNAE2, "43.11-8"), (Standards.ISIC4, "4312")),
        ((Standards.CNAE2, "43.12-6"), (Standards.ISIC4, "4312")),
        ((Standards.CNAE2, "43.13-4"), (Standards.ISIC4, "4312")),
        ((Standards.CNAE2, "43.19-3"), (Standards.ISIC4, "4312")),
        ((Standards.CNAE2, "43.2"), (Standards.ISIC4, "432")),
        ((Standards.CNAE2, "43.21-5"), (Standards.ISIC4, "4321")),
        ((Standards.CNAE2, "43.22-3"), (Standards.ISIC4, "4322")),
        ((Standards.CNAE2, "43.29-1"), (Standards.ISIC4, "4329")),
        ((Standards.CNAE2, "43.3"), (Standards.ISIC4, "433")),
        ((Standards.CNAE2, "43.30-4"), (Standards.ISIC4, "4330")),
        ((Standards.CNAE2, "43.9"), (Standards.ISIC4, "439")),
        ((Standards.CNAE2, "43.91-6"), (Standards.ISIC4, "4390")),
        ((Standards.CNAE2, "43.99-1"), (Standards.ISIC4, "4390")),
        ((Standards.CNAE2, "G"), (Standards.ISIC4, "G")),
        ((Standards.CNAE2, "45"), (Standards.ISIC4, "45")),
        ((Standards.CNAE2, "45.1"), (Standards.ISIC4, "451")),
        ((Standards.CNAE2, "45.11-1"), (Standards.ISIC4, "4510")),
        ((Standards.CNAE2, "45.12-9"), (Standards.ISIC4, "4510")),
        ((Standards.CNAE2, "45.2"), (Standards.ISIC4, "452")),
        ((Standards.CNAE2, "45.20-0"), (Standards.ISIC4, "4520")),
        ((Standards.CNAE2, "45.3"), (Standards.ISIC4, "453")),
        ((Standards.CNAE2, "45.30-7"), (Standards.ISIC4, "4530")),
        ((Standards.CNAE2, "45.4"), (Standards.ISIC4, "454")),
        ((Standards.CNAE2, "45.41-2"), (Standards.ISIC4, "4540")),
        ((Standards.CNAE2, "45.42-1"), (Standards.ISIC4, "4540")),
        ((Standards.CNAE2, "45.43-9"), (Standards.ISIC4, "4540")),
        ((Standards.CNAE2, "46"), (Standards.ISIC4, "46")),
        ((Standards.CNAE2, "46.1"), (Standards.ISIC4, "461")),
        ((Standards.CNAE2, "46.11-7"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.12-5"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.13-3"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.14-1"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.15-0"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.16-8"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.17-6"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.18-4"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.19-2"), (Standards.ISIC4, "4610")),
        ((Standards.CNAE2, "46.2"), (Standards.ISIC4, "462")),
        ((Standards.CNAE2, "46.21-4"), (Standards.ISIC4, "4620")),
        ((Standards.CNAE2, "46.22-2"), (Standards.ISIC4, "4620")),
        ((Standards.CNAE2, "46.23-1"), (Standards.ISIC4, "4620")),
        ((Standards.CNAE2, "46.3"), (Standards.ISIC4, "463")),
        ((Standards.CNAE2, "46.31-1"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.32-0"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.33-8"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.34-6"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.35-4"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.36-2"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.37-1"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.39-7"), (Standards.ISIC4, "4630")),
        ((Standards.CNAE2, "46.4"), (Standards.ISIC4, "464")),
        ((Standards.CNAE2, "46.41-9"), (Standards.ISIC4, "4641")),
        ((Standards.CNAE2, "46.42-7"), (Standards.ISIC4, "4641")),
        ((Standards.CNAE2, "46.43-5"), (Standards.ISIC4, "4641")),
        ((Standards.CNAE2, "46.44-3"), (Standards.ISIC4, "4649")),
        ((Standards.CNAE2, "46.45-1"), (Standards.ISIC4, "4649")),
        ((Standards.CNAE2, "46.46-0"), (Standards.ISIC4, "4649")),
        ((Standards.CNAE2, "46.47-8"), (Standards.ISIC4, "4649")),
        ((Standards.CNAE2, "46.49-4"), (Standards.ISIC4, "4649")),
        ((Standards.CNAE2, "46.5"), (Standards.ISIC4, "465")),
        ((Standards.CNAE2, "46.51-6"), (Standards.ISIC4, "4651")),
        ((Standards.CNAE2, "46.52-4"), (Standards.ISIC4, "4652")),
        ((Standards.CNAE2, "46.6"), (Standards.ISIC4, "465")),
        ((Standards.CNAE2, "46.61-3"), (Standards.ISIC4, "4653")),
        ((Standards.CNAE2, "46.62-1"), (Standards.ISIC4, "4659")),
        ((Standards.CNAE2, "46.63-0"), (Standards.ISIC4, "4659")),
        ((Standards.CNAE2, "46.64-8"), (Standards.ISIC4, "4659")),
        ((Standards.CNAE2, "46.65-6"), (Standards.ISIC4, "4659")),
        ((Standards.CNAE2, "46.69-9"), (Standards.ISIC4, "4659")),
        ((Standards.CNAE2, "46.7"), (Standards.ISIC4, "466")),
        ((Standards.CNAE2, "46.71-1"), (Standards.ISIC4, "4663")),
        ((Standards.CNAE2, "46.72-9"), (Standards.ISIC4, "4663")),
        ((Standards.CNAE2, "46.73-7"), (Standards.ISIC4, "4663")),
        ((Standards.CNAE2, "46.74-5"), (Standards.ISIC4, "4663")),
        ((Standards.CNAE2, "46.79-6"), (Standards.ISIC4, "4663")),
        ((Standards.CNAE2, "46.8"), (Standards.ISIC4, "466")),
        ((Standards.CNAE2, "46.81-8"), (Standards.ISIC4, "4661")),
        ((Standards.CNAE2, "46.82-6"), (Standards.ISIC4, "4661")),
        ((Standards.CNAE2, "46.83-4"), (Standards.ISIC4, "4669")),
        ((Standards.CNAE2, "46.84-2"), (Standards.ISIC4, "4669")),
        ((Standards.CNAE2, "46.85-1"), (Standards.ISIC4, "4662")),
        ((Standards.CNAE2, "46.86-9"), (Standards.ISIC4, "4669")),
        ((Standards.CNAE2, "46.87-7"), (Standards.ISIC4, "4669")),
        ((Standards.CNAE2, "46.89-3"), (Standards.ISIC4, "4662")),
        ((Standards.CNAE2, "46.89-3"), (Standards.ISIC4, "4669")),
        ((Standards.CNAE2, "46.9"), (Standards.ISIC4, "469")),
        ((Standards.CNAE2, "46.91-5"), (Standards.ISIC4, "4690")),
        ((Standards.CNAE2, "46.92-3"), (Standards.ISIC4, "4690")),
        ((Standards.CNAE2, "46.93-1"), (Standards.ISIC4, "4690")),
        ((Standards.CNAE2, "47"), (Standards.ISIC4, "47")),
        ((Standards.CNAE2, "47.1"), (Standards.ISIC4, "471")),
        ((Standards.CNAE2, "47.1"), (Standards.ISIC4, "479")),
        ((Standards.CNAE2, "47.11-3"), (Standards.ISIC4, "4711")),
        ((Standards.CNAE2, "47.12-1"), (Standards.ISIC4, "4711")),
        ((Standards.CNAE2, "47.13-0"), (Standards.ISIC4, "4719")),
        ((Standards.CNAE2, "47.13-0"), (Standards.ISIC4, "4791")),
        ((Standards.CNAE2, "47.2"), (Standards.ISIC4, "472")),
        ((Standards.CNAE2, "47.21-1"), (Standards.ISIC4, "4721")),
        ((Standards.CNAE2, "47.22-9"), (Standards.ISIC4, "4721")),
        ((Standards.CNAE2, "47.23-7"), (Standards.ISIC4, "4722")),
        ((Standards.CNAE2, "47.24-5"), (Standards.ISIC4, "4721")),
        ((Standards.CNAE2, "47.29-6"), (Standards.ISIC4, "4721")),
        ((Standards.CNAE2, "47.29-6"), (Standards.ISIC4, "4723")),
        ((Standards.CNAE2, "47.3"), (Standards.ISIC4, "473")),
        ((Standards.CNAE2, "47.31-8"), (Standards.ISIC4, "4730")),
        ((Standards.CNAE2, "47.32-6"), (Standards.ISIC4, "4730")),
        ((Standards.CNAE2, "47.4"), (Standards.ISIC4, "475")),
        ((Standards.CNAE2, "47.41-5"), (Standards.ISIC4, "4752")),
        ((Standards.CNAE2, "47.42-3"), (Standards.ISIC4, "4752")),
        ((Standards.CNAE2, "47.43-1"), (Standards.ISIC4, "4752")),
        ((Standards.CNAE2, "47.44-0"), (Standards.ISIC4, "4752")),
        ((Standards.CNAE2, "47.5"), (Standards.ISIC4, "474")),
        ((Standards.CNAE2, "47.5"), (Standards.ISIC4, "475")),
        ((Standards.CNAE2, "47.51-2"), (Standards.ISIC4, "4741")),
        ((Standards.CNAE2, "47.52-1"), (Standards.ISIC4, "4741")),
        ((Standards.CNAE2, "47.53-9"), (Standards.ISIC4, "4742")),
        ((Standards.CNAE2, "47.53-9"), (Standards.ISIC4, "4759")),
        ((Standards.CNAE2, "47.54-7"), (Standards.ISIC4, "4759")),
        ((Standards.CNAE2, "47.55-5"), (Standards.ISIC4, "4751")),
        ((Standards.CNAE2, "47.56-3"), (Standards.ISIC4, "4759")),
        ((Standards.CNAE2, "47.57-1"), (Standards.ISIC4, "4742")),
        ((Standards.CNAE2, "47.59-8"), (Standards.ISIC4, "4753")),
        ((Standards.CNAE2, "47.59-8"), (Standards.ISIC4, "4759")),
        ((Standards.CNAE2, "47.6"), (Standards.ISIC4, "476")),
        ((Standards.CNAE2, "47.61-0"), (Standards.ISIC4, "4761")),
        ((Standards.CNAE2, "47.62-8"), (Standards.ISIC4, "4762")),
        ((Standards.CNAE2, "47.63-6"), (Standards.ISIC4, "4763")),
        ((Standards.CNAE2, "47.63-6"), (Standards.ISIC4, "4764")),
        ((Standards.CNAE2, "47.7"), (Standards.ISIC4, "477")),
        ((Standards.CNAE2, "47.71-7"), (Standards.ISIC4, "4772")),
        ((Standards.CNAE2, "47.72-5"), (Standards.ISIC4, "4772")),
        ((Standards.CNAE2, "47.73-3"), (Standards.ISIC4, "4772")),
        ((Standards.CNAE2, "47.74-1"), (Standards.ISIC4, "4773")),
        ((Standards.CNAE2, "47.8"), (Standards.ISIC4, "477")),
        ((Standards.CNAE2, "47.8"), (Standards.ISIC4, "478")),
        ((Standards.CNAE2, "47.81-4"), (Standards.ISIC4, "4771")),
        ((Standards.CNAE2, "47.82-2"), (Standards.ISIC4, "4771")),
        ((Standards.CNAE2, "47.83-1"), (Standards.ISIC4, "4773")),
        ((Standards.CNAE2, "47.84-9"), (Standards.ISIC4, "4773")),
        ((Standards.CNAE2, "47.85-7"), (Standards.ISIC4, "4774")),
        ((Standards.CNAE2, "47.89-0"), (Standards.ISIC4, "4789")),
        ((Standards.CNAE2, "47.9"), (Standards.ISIC4, "478")),
        ((Standards.CNAE2, "47.9"), (Standards.ISIC4, "479")),
        ((Standards.CNAE2, "47.90-3"), (Standards.ISIC4, "4799")),
        ((Standards.CNAE2, "47.90-3"), (Standards.ISIC4, "4781")),
        ((Standards.CNAE2, "47.90-3"), (Standards.ISIC4, "4782")),
        ((Standards.CNAE2, "47.90-3"), (Standards.ISIC4, "4789")),
        ((Standards.CNAE2, "H"), (Standards.ISIC4, "H")),
        ((Standards.CNAE2, "49"), (Standards.ISIC4, "49")),
        ((Standards.CNAE2, "49.1"), (Standards.ISIC4, "491")),
        ((Standards.CNAE2, "49.1"), (Standards.ISIC4, "492")),
        ((Standards.CNAE2, "49.11-6"), (Standards.ISIC4, "4912")),
        ((Standards.CNAE2, "49.12-4"), (Standards.ISIC4, "4911")),
        ((Standards.CNAE2, "49.12-4"), (Standards.ISIC4, "4921")),
        ((Standards.CNAE2, "49.2"), (Standards.ISIC4, "492")),
        ((Standards.CNAE2, "49.21-3"), (Standards.ISIC4, "4921")),
        ((Standards.CNAE2, "49.22-1"), (Standards.ISIC4, "4922")),
        ((Standards.CNAE2, "49.23-0"), (Standards.ISIC4, "4922")),
        ((Standards.CNAE2, "49.24-8"), (Standards.ISIC4, "4922")),
        ((Standards.CNAE2, "49.29-9"), (Standards.ISIC4, "4922")),
        ((Standards.CNAE2, "49.3"), (Standards.ISIC4, "492")),
        ((Standards.CNAE2, "49.30-2"), (Standards.ISIC4, "4923")),
        ((Standards.CNAE2, "49.4"), (Standards.ISIC4, "493")),
        ((Standards.CNAE2, "49.40-0"), (Standards.ISIC4, "4930")),
        ((Standards.CNAE2, "49.5"), (Standards.ISIC4, "492")),
        ((Standards.CNAE2, "49.50-7"), (Standards.ISIC4, "4922")),
        ((Standards.CNAE2, "50"), (Standards.ISIC4, "50")),
        ((Standards.CNAE2, "50.1"), (Standards.ISIC4, "501")),
        ((Standards.CNAE2, "50.11-4"), (Standards.ISIC4, "5011")),
        ((Standards.CNAE2, "50.11-4"), (Standards.ISIC4, "5012")),
        ((Standards.CNAE2, "50.12-2"), (Standards.ISIC4, "5011")),
        ((Standards.CNAE2, "50.12-2"), (Standards.ISIC4, "5012")),
        ((Standards.CNAE2, "50.2"), (Standards.ISIC4, "502")),
        ((Standards.CNAE2, "50.21-1"), (Standards.ISIC4, "5022")),
        ((Standards.CNAE2, "50.22-0"), (Standards.ISIC4, "5021")),
        ((Standards.CNAE2, "50.3"), (Standards.ISIC4, "501")),
        ((Standards.CNAE2, "50.30-1"), (Standards.ISIC4, "5012")),
        ((Standards.CNAE2, "50.9"), (Standards.ISIC4, "501")),
        ((Standards.CNAE2, "50.9"), (Standards.ISIC4, "502")),
        ((Standards.CNAE2, "50.91-2"), (Standards.ISIC4, "5021")),
        ((Standards.CNAE2, "50.91-2"), (Standards.ISIC4, "5022")),
        ((Standards.CNAE2, "50.99-8"), (Standards.ISIC4, "5011")),
        ((Standards.CNAE2, "50.99-8"), (Standards.ISIC4, "5012")),
        ((Standards.CNAE2, "50.99-8"), (Standards.ISIC4, "5021")),
        ((Standards.CNAE2, "50.99-8"), (Standards.ISIC4, "5022")),
        ((Standards.CNAE2, "51"), (Standards.ISIC4, "51")),
        ((Standards.CNAE2, "51.1"), (Standards.ISIC4, "511")),
        ((Standards.CNAE2, "51.11-1"), (Standards.ISIC4, "5110")),
        ((Standards.CNAE2, "51.12-9"), (Standards.ISIC4, "5110")),
        ((Standards.CNAE2, "51.2"), (Standards.ISIC4, "512")),
        ((Standards.CNAE2, "51.20-0"), (Standards.ISIC4, "5120")),
        ((Standards.CNAE2, "51.3"), (Standards.ISIC4, "512")),
        ((Standards.CNAE2, "51.30-7"), (Standards.ISIC4, "5120")),
        ((Standards.CNAE2, "52"), (Standards.ISIC4, "52")),
        ((Standards.CNAE2, "52.1"), (Standards.ISIC4, "521")),
        ((Standards.CNAE2, "52.1"), (Standards.ISIC4, "522")),
        ((Standards.CNAE2, "52.11-7"), (Standards.ISIC4, "5210")),
        ((Standards.CNAE2, "52.12-5"), (Standards.ISIC4, "5224")),
        ((Standards.CNAE2, "52.2"), (Standards.ISIC4, "522")),
        ((Standards.CNAE2, "52.21-4"), (Standards.ISIC4, "5221")),
        ((Standards.CNAE2, "52.22-2"), (Standards.ISIC4, "5221")),
        ((Standards.CNAE2, "52.23-1"), (Standards.ISIC4, "5221")),
        ((Standards.CNAE2, "52.29-0"), (Standards.ISIC4, "5221")),
        ((Standards.CNAE2, "52.3"), (Standards.ISIC4, "522")),
        ((Standards.CNAE2, "52.31-1"), (Standards.ISIC4, "5222")),
        ((Standards.CNAE2, "52.32-0"), (Standards.ISIC4, "5229")),
        ((Standards.CNAE2, "52.39-7"), (Standards.ISIC4, "5222")),
        ((Standards.CNAE2, "52.4"), (Standards.ISIC4, "522")),
        ((Standards.CNAE2, "52.40-1"), (Standards.ISIC4, "5223")),
        ((Standards.CNAE2, "52.5"), (Standards.ISIC4, "522")),
        ((Standards.CNAE2, "52.50-8"), (Standards.ISIC4, "5229")),
        ((Standards.CNAE2, "53"), (Standards.ISIC4, "53")),
        ((Standards.CNAE2, "53.1"), (Standards.ISIC4, "531")),
        ((Standards.CNAE2, "53.10-5"), (Standards.ISIC4, "5310")),
        ((Standards.CNAE2, "53.2"), (Standards.ISIC4, "532")),
        ((Standards.CNAE2, "53.20-2"), (Standards.ISIC4, "5320")),
        ((Standards.CNAE2, "I"), (Standards.ISIC4, "I")),
        ((Standards.CNAE2, "55"), (Standards.ISIC4, "55")),
        ((Standards.CNAE2, "55.1"), (Standards.ISIC4, "551")),
        ((Standards.CNAE2, "55.10-8"), (Standards.ISIC4, "5510")),
        ((Standards.CNAE2, "55.9"), (Standards.ISIC4, "552")),
        ((Standards.CNAE2, "55.9"), (Standards.ISIC4, "559")),
        ((Standards.CNAE2, "55.90-6"), (Standards.ISIC4, "5520")),
        ((Standards.CNAE2, "55.90-6"), (Standards.ISIC4, "5590")),
        ((Standards.CNAE2, "56"), (Standards.ISIC4, "56")),
        ((Standards.CNAE2, "56.1"), (Standards.ISIC4, "561")),
        ((Standards.CNAE2, "56.1"), (Standards.ISIC4, "563")),
        ((Standards.CNAE2, "56.11-2"), (Standards.ISIC4, "5610")),
        ((Standards.CNAE2, "56.11-2"), (Standards.ISIC4, "5630")),
        ((Standards.CNAE2, "56.12-1"), (Standards.ISIC4, "5610")),
        ((Standards.CNAE2, "56.2"), (Standards.ISIC4, "562")),
        ((Standards.CNAE2, "56.20-1"), (Standards.ISIC4, "5621")),
        ((Standards.CNAE2, "56.20-1"), (Standards.ISIC4, "5629")),
        ((Standards.CNAE2, "J"), (Standards.ISIC4, "J")),
        ((Standards.CNAE2, "58"), (Standards.ISIC4, "58")),
        ((Standards.CNAE2, "58.1"), (Standards.ISIC4, "581")),
        ((Standards.CNAE2, "58.11-5"), (Standards.ISIC4, "5811")),
        ((Standards.CNAE2, "58.12-3"), (Standards.ISIC4, "5813")),
        ((Standards.CNAE2, "58.13-1"), (Standards.ISIC4, "5813")),
        ((Standards.CNAE2, "58.19-1"), (Standards.ISIC4, "5812")),
        ((Standards.CNAE2, "58.19-1"), (Standards.ISIC4, "5819")),
        ((Standards.CNAE2, "58.2"), (Standards.ISIC4, "581")),
        ((Standards.CNAE2, "58.21-2"), (Standards.ISIC4, "5811")),
        ((Standards.CNAE2, "58.22-1"), (Standards.ISIC4, "5813")),
        ((Standards.CNAE2, "58.23-9"), (Standards.ISIC4, "5813")),
        ((Standards.CNAE2, "58.29-8"), (Standards.ISIC4, "5812")),
        ((Standards.CNAE2, "58.29-8"), (Standards.ISIC4, "5819")),
        ((Standards.CNAE2, "59"), (Standards.ISIC4, "59")),
        ((Standards.CNAE2, "59.1"), (Standards.ISIC4, "591")),
        ((Standards.CNAE2, "59.11-1"), (Standards.ISIC4, "5911")),
        ((Standards.CNAE2, "59.12-0"), (Standards.ISIC4, "5912")),
        ((Standards.CNAE2, "59.13-8"), (Standards.ISIC4, "5913")),
        ((Standards.CNAE2, "59.14-6"), (Standards.ISIC4, "5914")),
        ((Standards.CNAE2, "59.2"), (Standards.ISIC4, "592")),
        ((Standards.CNAE2, "59.20-1"), (Standards.ISIC4, "5920")),
        ((Standards.CNAE2, "60"), (Standards.ISIC4, "60")),
        ((Standards.CNAE2, "60.1"), (Standards.ISIC4, "601")),
        ((Standards.CNAE2, "60.10-1"), (Standards.ISIC4, "6010")),
        ((Standards.CNAE2, "60.2"), (Standards.ISIC4, "602")),
        ((Standards.CNAE2, "60.21-7"), (Standards.ISIC4, "6021")),
        ((Standards.CNAE2, "60.22-5"), (Standards.ISIC4, "6022")),
        ((Standards.CNAE2, "61"), (Standards.ISIC4, "61")),
        ((Standards.CNAE2, "61.1"), (Standards.ISIC4, "611")),
        ((Standards.CNAE2, "61.10-8"), (Standards.ISIC4, "6110")),
        ((Standards.CNAE2, "61.2"), (Standards.ISIC4, "612")),
        ((Standards.CNAE2, "61.20-5"), (Standards.ISIC4, "6120")),
        ((Standards.CNAE2, "61.3"), (Standards.ISIC4, "613")),
        ((Standards.CNAE2, "61.30-2"), (Standards.ISIC4, "6130")),
        ((Standards.CNAE2, "61.4"), (Standards.ISIC4, "611")),
        ((Standards.CNAE2, "61.4"), (Standards.ISIC4, "612")),
        ((Standards.CNAE2, "61.4"), (Standards.ISIC4, "613")),
        ((Standards.CNAE2, "61.41-8"), (Standards.ISIC4, "6110")),
        ((Standards.CNAE2, "61.42-6"), (Standards.ISIC4, "6120")),
        ((Standards.CNAE2, "61.43-4"), (Standards.ISIC4, "6130")),
        ((Standards.CNAE2, "61.9"), (Standards.ISIC4, "619")),
        ((Standards.CNAE2, "61.90-6"), (Standards.ISIC4, "6190")),
        ((Standards.CNAE2, "62"), (Standards.ISIC4, "58")),
        ((Standards.CNAE2, "62"), (Standards.ISIC4, "62")),
        ((Standards.CNAE2, "62.0"), (Standards.ISIC4, "582")),
        ((Standards.CNAE2, "62.0"), (Standards.ISIC4, "620")),
        ((Standards.CNAE2, "62.01-5"), (Standards.ISIC4, "6201")),
        ((Standards.CNAE2, "62.02-3"), (Standards.ISIC4, "5820")),
        ((Standards.CNAE2, "62.02-3"), (Standards.ISIC4, "6201")),
        ((Standards.CNAE2, "62.03-1"), (Standards.ISIC4, "5820")),
        ((Standards.CNAE2, "62.03-1"), (Standards.ISIC4, "6201")),
        ((Standards.CNAE2, "62.04-0"), (Standards.ISIC4, "6202")),
        ((Standards.CNAE2, "62.09-1"), (Standards.ISIC4, "6209")),
        ((Standards.CNAE2, "63"), (Standards.ISIC4, "63")),
        ((Standards.CNAE2, "63.1"), (Standards.ISIC4, "631")),
        ((Standards.CNAE2, "63.11-9"), (Standards.ISIC4, "6311")),
        ((Standards.CNAE2, "63.19-4"), (Standards.ISIC4, "6312")),
        ((Standards.CNAE2, "63.9"), (Standards.ISIC4, "639")),
        ((Standards.CNAE2, "63.91-7"), (Standards.ISIC4, "6391")),
        ((Standards.CNAE2, "63.99-2"), (Standards.ISIC4, "6399")),
        ((Standards.CNAE2, "K"), (Standards.ISIC4, "K")),
        ((Standards.CNAE2, "K"), (Standards.ISIC4, "M")),
        ((Standards.CNAE2, "64"), (Standards.ISIC4, "64")),
        ((Standards.CNAE2, "64"), (Standards.ISIC4, "70")),
        ((Standards.CNAE2, "64.1"), (Standards.ISIC4, "641")),
        ((Standards.CNAE2, "64.10-7"), (Standards.ISIC4, "6411")),
        ((Standards.CNAE2, "64.2"), (Standards.ISIC4, "641")),
        ((Standards.CNAE2, "64.21-2"), (Standards.ISIC4, "6419")),
        ((Standards.CNAE2, "64.22-1"), (Standards.ISIC4, "6419")),
        ((Standards.CNAE2, "64.23-9"), (Standards.ISIC4, "6419")),
        ((Standards.CNAE2, "64.24-7"), (Standards.ISIC4, "6419")),
        ((Standards.CNAE2, "64.3"), (Standards.ISIC4, "649")),
        ((Standards.CNAE2, "64.31-0"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.32-8"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.33-6"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.34-4"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.35-2"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.36-1"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.37-9"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.4"), (Standards.ISIC4, "649")),
        ((Standards.CNAE2, "64.40-9"), (Standards.ISIC4, "6491")),
        ((Standards.CNAE2, "64.5"), (Standards.ISIC4, "649")),
        ((Standards.CNAE2, "64.50-6"), (Standards.ISIC4, "6492")),
        ((Standards.CNAE2, "64.6"), (Standards.ISIC4, "642")),
        ((Standards.CNAE2, "64.6"), (Standards.ISIC4, "701")),
        ((Standards.CNAE2, "64.61-1"), (Standards.ISIC4, "6420")),
        ((Standards.CNAE2, "64.61-1"), (Standards.ISIC4, "7010")),
        ((Standards.CNAE2, "64.62-0"), (Standards.ISIC4, "6420")),
        ((Standards.CNAE2, "64.62-0"), (Standards.ISIC4, "7010")),
        ((Standards.CNAE2, "64.63-8"), (Standards.ISIC4, "6420")),
        ((Standards.CNAE2, "64.7"), (Standards.ISIC4, "643")),
        ((Standards.CNAE2, "64.70-1"), (Standards.ISIC4, "6430")),
        ((Standards.CNAE2, "64.9"), (Standards.ISIC4, "649")),
        ((Standards.CNAE2, "64.91-3"), (Standards.ISIC4, "6499")),
        ((Standards.CNAE2, "64.92-1"), (Standards.ISIC4, "6499")),
        ((Standards.CNAE2, "64.93-0"), (Standards.ISIC4, "6499")),
        ((Standards.CNAE2, "64.99-9"), (Standards.ISIC4, "6499")),
        ((Standards.CNAE2, "65"), (Standards.ISIC4, "65")),
        ((Standards.CNAE2, "65.1"), (Standards.ISIC4, "651")),
        ((Standards.CNAE2, "65.11-1"), (Standards.ISIC4, "6511")),
        ((Standards.CNAE2, "65.12-0"), (Standards.ISIC4, "6512")),
        ((Standards.CNAE2, "65.2"), (Standards.ISIC4, "651")),
        ((Standards.CNAE2, "65.20-1"), (Standards.ISIC4, "6512")),
        ((Standards.CNAE2, "65.3"), (Standards.ISIC4, "652")),
        ((Standards.CNAE2, "65.30-8"), (Standards.ISIC4, "6520")),
        ((Standards.CNAE2, "65.4"), (Standards.ISIC4, "653")),
        ((Standards.CNAE2, "65.41-3"), (Standards.ISIC4, "6530")),
        ((Standards.CNAE2, "65.42-1"), (Standards.ISIC4, "6530")),
        ((Standards.CNAE2, "65.5"), (Standards.ISIC4, "651")),
        ((Standards.CNAE2, "65.50-2"), (Standards.ISIC4, "6512")),
        ((Standards.CNAE2, "66"), (Standards.ISIC4, "66")),
        ((Standards.CNAE2, "66.1"), (Standards.ISIC4, "661")),
        ((Standards.CNAE2, "66.11-8"), (Standards.ISIC4, "6611")),
        ((Standards.CNAE2, "66.12-6"), (Standards.ISIC4, "6612")),
        ((Standards.CNAE2, "66.13-4"), (Standards.ISIC4, "6619")),
        ((Standards.CNAE2, "66.19-3"), (Standards.ISIC4, "6619")),
        ((Standards.CNAE2, "66.2"), (Standards.ISIC4, "662")),
        ((Standards.CNAE2, "66.21-5"), (Standards.ISIC4, "6621")),
        ((Standards.CNAE2, "66.22-3"), (Standards.ISIC4, "6622")),
        ((Standards.CNAE2, "66.29-1"), (Standards.ISIC4, "6629")),
        ((Standards.CNAE2, "66.3"), (Standards.ISIC4, "663")),
        ((Standards.CNAE2, "66.30-4"), (Standards.ISIC4, "6630")),
        ((Standards.CNAE2, "L"), (Standards.ISIC4, "L")),
        ((Standards.CNAE2, "68"), (Standards.ISIC4, "68")),
        ((Standards.CNAE2, "68.1"), (Standards.ISIC4, "681")),
        ((Standards.CNAE2, "68.10-2"), (Standards.ISIC4, "6810")),
        ((Standards.CNAE2, "68.2"), (Standards.ISIC4, "682")),
        ((Standards.CNAE2, "68.2"), (Standards.ISIC4, "681")),
        ((Standards.CNAE2, "68.21-8"), (Standards.ISIC4, "6820")),
        ((Standards.CNAE2, "68.22-6"), (Standards.ISIC4, "6810")),
        ((Standards.CNAE2, "M"), (Standards.ISIC4, "M")),
        ((Standards.CNAE2, "69"), (Standards.ISIC4, "69")),
        ((Standards.CNAE2, "69.1"), (Standards.ISIC4, "691")),
        ((Standards.CNAE2, "69.11-7"), (Standards.ISIC4, "6910")),
        ((Standards.CNAE2, "69.12-5"), (Standards.ISIC4, "6910")),
        ((Standards.CNAE2, "69.2"), (Standards.ISIC4, "692")),
        ((Standards.CNAE2, "69.20-6"), (Standards.ISIC4, "6920")),
        ((Standards.CNAE2, "70"), (Standards.ISIC4, "70")),
        ((Standards.CNAE2, "70.1"), (Standards.ISIC4, "701")),
        ((Standards.CNAE2, "70.10-7"), (Standards.ISIC4, "7010")),
        ((Standards.CNAE2, "70.2"), (Standards.ISIC4, "702")),
        ((Standards.CNAE2, "70.20-4"), (Standards.ISIC4, "7020")),
        ((Standards.CNAE2, "71"), (Standards.ISIC4, "71")),
        ((Standards.CNAE2, "71.1"), (Standards.ISIC4, "711")),
        ((Standards.CNAE2, "71.11-1"), (Standards.ISIC4, "7110")),
        ((Standards.CNAE2, "71.12-0"), (Standards.ISIC4, "7110")),
        ((Standards.CNAE2, "71.19-7"), (Standards.ISIC4, "7110")),
        ((Standards.CNAE2, "71.2"), (Standards.ISIC4, "712")),
        ((Standards.CNAE2, "71.20-1"), (Standards.ISIC4, "7120")),
        ((Standards.CNAE2, "72"), (Standards.ISIC4, "72")),
        ((Standards.CNAE2, "72.1"), (Standards.ISIC4, "721")),
        ((Standards.CNAE2, "72.10-0"), (Standards.ISIC4, "7210")),
        ((Standards.CNAE2, "72.2"), (Standards.ISIC4, "722")),
        ((Standards.CNAE2, "72.20-7"), (Standards.ISIC4, "7220")),
        ((Standards.CNAE2, "73"), (Standards.ISIC4, "73")),
        ((Standards.CNAE2, "73.1"), (Standards.ISIC4, "731")),
        ((Standards.CNAE2, "73.11-4"), (Standards.ISIC4, "7310")),
        ((Standards.CNAE2, "73.12-2"), (Standards.ISIC4, "7310")),
        ((Standards.CNAE2, "73.19-0"), (Standards.ISIC4, "7310")),
        ((Standards.CNAE2, "73.2"), (Standards.ISIC4, "732")),
        ((Standards.CNAE2, "73.20-3"), (Standards.ISIC4, "7320")),
        ((Standards.CNAE2, "74"), (Standards.ISIC4, "74")),
        ((Standards.CNAE2, "74.1"), (Standards.ISIC4, "741")),
        ((Standards.CNAE2, "74.10-2"), (Standards.ISIC4, "7410")),
        ((Standards.CNAE2, "74.2"), (Standards.ISIC4, "742")),
        ((Standards.CNAE2, "74.20-0"), (Standards.ISIC4, "7420")),
        ((Standards.CNAE2, "74.9"), (Standards.ISIC4, "749")),
        ((Standards.CNAE2, "74.90-1"), (Standards.ISIC4, "7490")),
        ((Standards.CNAE2, "75"), (Standards.ISIC4, "75")),
        ((Standards.CNAE2, "75.0"), (Standards.ISIC4, "750")),
        ((Standards.CNAE2, "75.00-1"), (Standards.ISIC4, "7500")),
        ((Standards.CNAE2, "N"), (Standards.ISIC4, "N")),
        ((Standards.CNAE2, "77"), (Standards.ISIC4, "77")),
        ((Standards.CNAE2, "77.1"), (Standards.ISIC4, "771")),
        ((Standards.CNAE2, "77.11-0"), (Standards.ISIC4, "7710")),
        ((Standards.CNAE2, "77.19-5"), (Standards.ISIC4, "7710")),
        ((Standards.CNAE2, "77.2"), (Standards.ISIC4, "772")),
        ((Standards.CNAE2, "77.21-7"), (Standards.ISIC4, "7721")),
        ((Standards.CNAE2, "77.22-5"), (Standards.ISIC4, "7722")),
        ((Standards.CNAE2, "77.23-3"), (Standards.ISIC4, "7729")),
        ((Standards.CNAE2, "77.29-2"), (Standards.ISIC4, "7729")),
        ((Standards.CNAE2, "77.3"), (Standards.ISIC4, "773")),
        ((Standards.CNAE2, "77.31-4"), (Standards.ISIC4, "7730")),
        ((Standards.CNAE2, "77.32-2"), (Standards.ISIC4, "7730")),
        ((Standards.CNAE2, "77.33-1"), (Standards.ISIC4, "7730")),
        ((Standards.CNAE2, "77.39-0"), (Standards.ISIC4, "7730")),
        ((Standards.CNAE2, "77.4"), (Standards.ISIC4, "774")),
        ((Standards.CNAE2, "77.40-3"), (Standards.ISIC4, "7740")),
        ((Standards.CNAE2, "78"), (Standards.ISIC4, "78")),
        ((Standards.CNAE2, "78.1"), (Standards.ISIC4, "781")),
        ((Standards.CNAE2, "78.10-8"), (Standards.ISIC4, "7810")),
        ((Standards.CNAE2, "78.2"), (Standards.ISIC4, "782")),
        ((Standards.CNAE2, "78.20-5"), (Standards.ISIC4, "7820")),
        ((Standards.CNAE2, "78.3"), (Standards.ISIC4, "783")),
        ((Standards.CNAE2, "78.30-2"), (Standards.ISIC4, "7830")),
        ((Standards.CNAE2, "79"), (Standards.ISIC4, "79")),
        ((Standards.CNAE2, "79.1"), (Standards.ISIC4, "791")),
        ((Standards.CNAE2, "79.11-2"), (Standards.ISIC4, "7911")),
        ((Standards.CNAE2, "79.12-1"), (Standards.ISIC4, "7912")),
        ((Standards.CNAE2, "79.9"), (Standards.ISIC4, "799")),
        ((Standards.CNAE2, "79.90-2"), (Standards.ISIC4, "7990")),
        ((Standards.CNAE2, "80"), (Standards.ISIC4, "80")),
        ((Standards.CNAE2, "80.1"), (Standards.ISIC4, "801")),
        ((Standards.CNAE2, "80.11-1"), (Standards.ISIC4, "8010")),
        ((Standards.CNAE2, "80.12-9"), (Standards.ISIC4, "8010")),
        ((Standards.CNAE2, "80.2"), (Standards.ISIC4, "802")),
        ((Standards.CNAE2, "80.20-0"), (Standards.ISIC4, "8020")),
        ((Standards.CNAE2, "80.3"), (Standards.ISIC4, "803")),
        ((Standards.CNAE2, "80.30-7"), (Standards.ISIC4, "8030")),
        ((Standards.CNAE2, "81"), (Standards.ISIC4, "81")),
        ((Standards.CNAE2, "81.1"), (Standards.ISIC4, "811")),
        ((Standards.CNAE2, "81.11-7"), (Standards.ISIC4, "8110")),
        ((Standards.CNAE2, "81.12-5"), (Standards.ISIC4, "8110")),
        ((Standards.CNAE2, "81.2"), (Standards.ISIC4, "812")),
        ((Standards.CNAE2, "81.21-4"), (Standards.ISIC4, "8121")),
        ((Standards.CNAE2, "81.22-2"), (Standards.ISIC4, "8129")),
        ((Standards.CNAE2, "81.29-0"), (Standards.ISIC4, "8129")),
        ((Standards.CNAE2, "81.3"), (Standards.ISIC4, "813")),
        ((Standards.CNAE2, "81.30-3"), (Standards.ISIC4, "8130")),
        ((Standards.CNAE2, "82"), (Standards.ISIC4, "82")),
        ((Standards.CNAE2, "82.1"), (Standards.ISIC4, "821")),
        ((Standards.CNAE2, "82.11-3"), (Standards.ISIC4, "8211")),
        ((Standards.CNAE2, "82.19-9"), (Standards.ISIC4, "8219")),
        ((Standards.CNAE2, "82.2"), (Standards.ISIC4, "822")),
        ((Standards.CNAE2, "82.20-2"), (Standards.ISIC4, "8220")),
        ((Standards.CNAE2, "82.3"), (Standards.ISIC4, "823")),
        ((Standards.CNAE2, "82.30-0"), (Standards.ISIC4, "8230")),
        ((Standards.CNAE2, "82.9"), (Standards.ISIC4, "829")),
        ((Standards.CNAE2, "82.91-1"), (Standards.ISIC4, "8291")),
        ((Standards.CNAE2, "82.92-0"), (Standards.ISIC4, "8292")),
        ((Standards.CNAE2, "82.99-7"), (Standards.ISIC4, "8299")),
        ((Standards.CNAE2, "O"), (Standards.ISIC4, "O")),
        ((Standards.CNAE2, "84"), (Standards.ISIC4, "84")),
        ((Standards.CNAE2, "84.1"), (Standards.ISIC4, "841")),
        ((Standards.CNAE2, "84.11-6"), (Standards.ISIC4, "8411")),
        ((Standards.CNAE2, "84.12-4"), (Standards.ISIC4, "8412")),
        ((Standards.CNAE2, "84.13-2"), (Standards.ISIC4, "8413")),
        ((Standards.CNAE2, "84.2"), (Standards.ISIC4, "842")),
        ((Standards.CNAE2, "84.21-3"), (Standards.ISIC4, "8421")),
        ((Standards.CNAE2, "84.22-1"), (Standards.ISIC4, "8422")),
        ((Standards.CNAE2, "84.23-0"), (Standards.ISIC4, "8423")),
        ((Standards.CNAE2, "84.24-8"), (Standards.ISIC4, "8423")),
        ((Standards.CNAE2, "84.25-6"), (Standards.ISIC4, "8423")),
        ((Standards.CNAE2, "84.3"), (Standards.ISIC4, "843")),
        ((Standards.CNAE2, "84.30-2"), (Standards.ISIC4, "8430")),
        ((Standards.CNAE2, "P"), (Standards.ISIC4, "P")),
        ((Standards.CNAE2, "P"), (Standards.ISIC4, "Q")),
        ((Standards.CNAE2, "85"), (Standards.ISIC4, "85")),
        ((Standards.CNAE2, "85"), (Standards.ISIC4, "88")),
        ((Standards.CNAE2, "85.1"), (Standards.ISIC4, "851")),
        ((Standards.CNAE2, "85.1"), (Standards.ISIC4, "889")),
        ((Standards.CNAE2, "85.11-2"), (Standards.ISIC4, "8890")),
        ((Standards.CNAE2, "85.12-1"), (Standards.ISIC4, "8510")),
        ((Standards.CNAE2, "85.13-9"), (Standards.ISIC4, "8510")),
        ((Standards.CNAE2, "85.2"), (Standards.ISIC4, "852")),
        ((Standards.CNAE2, "85.20-1"), (Standards.ISIC4, "8521")),
        ((Standards.CNAE2, "85.3"), (Standards.ISIC4, "853")),
        ((Standards.CNAE2, "85.31-7"), (Standards.ISIC4, "8530")),
        ((Standards.CNAE2, "85.32-5"), (Standards.ISIC4, "8530")),
        ((Standards.CNAE2, "85.33-3"), (Standards.ISIC4, "8530")),
        ((Standards.CNAE2, "85.4"), (Standards.ISIC4, "852")),
        ((Standards.CNAE2, "85.4"), (Standards.ISIC4, "853")),
        ((Standards.CNAE2, "85.41-4"), (Standards.ISIC4, "8522")),
        ((Standards.CNAE2, "85.42-2"), (Standards.ISIC4, "8530")),
        ((Standards.CNAE2, "85.5"), (Standards.ISIC4, "855")),
        ((Standards.CNAE2, "85.50-3"), (Standards.ISIC4, "8550")),
        ((Standards.CNAE2, "85.9"), (Standards.ISIC4, "854")),
        ((Standards.CNAE2, "85.91-1"), (Standards.ISIC4, "8541")),
        ((Standards.CNAE2, "85.92-9"), (Standards.ISIC4, "8542")),
        ((Standards.CNAE2, "85.93-7"), (Standards.ISIC4, "8549")),
        ((Standards.CNAE2, "85.99-6"), (Standards.ISIC4, "8549")),
        ((Standards.CNAE2, "Q"), (Standards.ISIC4, "Q")),
        ((Standards.CNAE2, "86"), (Standards.ISIC4, "86")),
        ((Standards.CNAE2, "86.1"), (Standards.ISIC4, "861")),
        ((Standards.CNAE2, "86.10-1"), (Standards.ISIC4, "8610")),
        ((Standards.CNAE2, "86.2"), (Standards.ISIC4, "869")),
        ((Standards.CNAE2, "86.21-6"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "86.22-4"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "86.3"), (Standards.ISIC4, "862")),
        ((Standards.CNAE2, "86.30-5"), (Standards.ISIC4, "8620")),
        ((Standards.CNAE2, "86.4"), (Standards.ISIC4, "869")),
        ((Standards.CNAE2, "86.40-2"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "86.5"), (Standards.ISIC4, "869")),
        ((Standards.CNAE2, "86.50-0"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "86.6"), (Standards.ISIC4, "869")),
        ((Standards.CNAE2, "86.60-7"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "86.9"), (Standards.ISIC4, "869")),
        ((Standards.CNAE2, "86.90-9"), (Standards.ISIC4, "8690")),
        ((Standards.CNAE2, "87"), (Standards.ISIC4, "87")),
        ((Standards.CNAE2, "87.1"), (Standards.ISIC4, "871")),
        ((Standards.CNAE2, "87.1"), (Standards.ISIC4, "873")),
        ((Standards.CNAE2, "87.11-5"), (Standards.ISIC4, "8710")),
        ((Standards.CNAE2, "87.11-5"), (Standards.ISIC4, "8730")),
        ((Standards.CNAE2, "87.12-3"), (Standards.ISIC4, "8710")),
        ((Standards.CNAE2, "87.2"), (Standards.ISIC4, "872")),
        ((Standards.CNAE2, "87.20-4"), (Standards.ISIC4, "8720")),
        ((Standards.CNAE2, "87.3"), (Standards.ISIC4, "879")),
        ((Standards.CNAE2, "87.30-1"), (Standards.ISIC4, "8790")),
        ((Standards.CNAE2, "88"), (Standards.ISIC4, "88")),
        ((Standards.CNAE2, "88.0"), (Standards.ISIC4, "881")),
        ((Standards.CNAE2, "88.0"), (Standards.ISIC4, "889")),
        ((Standards.CNAE2, "88.00-6"), (Standards.ISIC4, "8810")),
        ((Standards.CNAE2, "88.00-6"), (Standards.ISIC4, "8890")),
        ((Standards.CNAE2, "R"), (Standards.ISIC4, "R")),
        ((Standards.CNAE2, "90"), (Standards.ISIC4, "90")),
        ((Standards.CNAE2, "90.0"), (Standards.ISIC4, "900")),
        ((Standards.CNAE2, "90.01-9"), (Standards.ISIC4, "9000")),
        ((Standards.CNAE2, "90.02-7"), (Standards.ISIC4, "9000")),
        ((Standards.CNAE2, "90.03-5"), (Standards.ISIC4, "9000")),
        ((Standards.CNAE2, "91"), (Standards.ISIC4, "91")),
        ((Standards.CNAE2, "91.0"), (Standards.ISIC4, "910")),
        ((Standards.CNAE2, "91.01-5"), (Standards.ISIC4, "9101")),
        ((Standards.CNAE2, "91.02-3"), (Standards.ISIC4, "9102")),
        ((Standards.CNAE2, "91.03-1"), (Standards.ISIC4, "9103")),
        ((Standards.CNAE2, "92"), (Standards.ISIC4, "92")),
        ((Standards.CNAE2, "92.0"), (Standards.ISIC4, "920")),
        ((Standards.CNAE2, "92.00-3"), (Standards.ISIC4, "9200")),
        ((Standards.CNAE2, "93"), (Standards.ISIC4, "93")),
        ((Standards.CNAE2, "93.1"), (Standards.ISIC4, "931")),
        ((Standards.CNAE2, "93.11-5"), (Standards.ISIC4, "9311")),
        ((Standards.CNAE2, "93.12-3"), (Standards.ISIC4, "9312")),
        ((Standards.CNAE2, "93.13-1"), (Standards.ISIC4, "9311")),
        ((Standards.CNAE2, "93.19-1"), (Standards.ISIC4, "9319")),
        ((Standards.CNAE2, "93.2"), (Standards.ISIC4, "932")),
        ((Standards.CNAE2, "93.21-2"), (Standards.ISIC4, "9321")),
        ((Standards.CNAE2, "93.29-8"), (Standards.ISIC4, "9329")),
        ((Standards.CNAE2, "S"), (Standards.ISIC4, "S")),
        ((Standards.CNAE2, "94"), (Standards.ISIC4, "94")),
        ((Standards.CNAE2, "94.1"), (Standards.ISIC4, "941")),
        ((Standards.CNAE2, "94.11-1"), (Standards.ISIC4, "9411")),
        ((Standards.CNAE2, "94.12-0"), (Standards.ISIC4, "9412")),
        ((Standards.CNAE2, "94.2"), (Standards.ISIC4, "942")),
        ((Standards.CNAE2, "94.20-1"), (Standards.ISIC4, "9420")),
        ((Standards.CNAE2, "94.3"), (Standards.ISIC4, "949")),
        ((Standards.CNAE2, "94.30-8"), (Standards.ISIC4, "9499")),
        ((Standards.CNAE2, "94.9"), (Standards.ISIC4, "949")),
        ((Standards.CNAE2, "94.91-0"), (Standards.ISIC4, "9491")),
        ((Standards.CNAE2, "94.92-8"), (Standards.ISIC4, "9492")),
        ((Standards.CNAE2, "94.93-6"), (Standards.ISIC4, "9499")),
        ((Standards.CNAE2, "94.99-5"), (Standards.ISIC4, "9499")),
        ((Standards.CNAE2, "95"), (Standards.ISIC4, "95")),
        ((Standards.CNAE2, "95.1"), (Standards.ISIC4, "951")),
        ((Standards.CNAE2, "95.11-8"), (Standards.ISIC4, "9511")),
        ((Standards.CNAE2, "95.12-6"), (Standards.ISIC4, "9512")),
        ((Standards.CNAE2, "95.2"), (Standards.ISIC4, "952")),
        ((Standards.CNAE2, "95.21-5"), (Standards.ISIC4, "9521")),
        ((Standards.CNAE2, "95.21-5"), (Standards.ISIC4, "9522")),
        ((Standards.CNAE2, "95.29-1"), (Standards.ISIC4, "9523")),
        ((Standards.CNAE2, "95.29-1"), (Standards.ISIC4, "9524")),
        ((Standards.CNAE2, "95.29-1"), (Standards.ISIC4, "9529")),
        ((Standards.CNAE2, "96"), (Standards.ISIC4, "96")),
        ((Standards.CNAE2, "96.0"), (Standards.ISIC4, "960")),
        ((Standards.CNAE2, "96.01-7"), (Standards.ISIC4, "9601")),
        ((Standards.CNAE2, "96.02-5"), (Standards.ISIC4, "9602")),
        ((Standards.CNAE2, "96.03-3"), (Standards.ISIC4, "9603")),
        ((Standards.CNAE2, "96.09-2"), (Standards.ISIC4, "9609")),
        ((Standards.CNAE2, "T"), (Standards.ISIC4, "T")),
        ((Standards.CNAE2, "97"), (Standards.ISIC4, "97")),
        ((Standards.CNAE2, "97.0"), (Standards.ISIC4, "970")),
        ((Standards.CNAE2, "97.00-5"), (Standards.ISIC4, "9700")),
        ((Standards.CNAE2, "U"), (Standards.ISIC4, "U")),
        ((Standards.CNAE2, "99"), (Standards.ISIC4, "99")),
        ((Standards.CNAE2, "99.0"), (Standards.ISIC4, "990")),
        ((Standards.CNAE2, "99.00-8"), (Standards.ISIC4, "9900")),
    ],
)
