# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateSubnetRequest(JDCloudRequest):
    """
    创建子网
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateSubnetRequest, self).__init__(
            '/regions/{regionId}/subnets/', 'POST', header, version)
        self.parameters = parameters


class CreateSubnetParameters(object):

    def __init__(self,regionId, vpcId, subnetName, addressPrefix, ):
        """
        :param regionId: Region ID
        :param vpcId: 子网所属vpc的Id
        :param subnetName: 子网名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。
        :param addressPrefix: 子网网段，vpc内子网网段不能重叠，cidr的取值范围：10.0.0.0/8、172.16.0.0/12和192.168.0.0/16及它们包含的子网，且子网掩码长度为16-28之间，如果vpc含有cidr，则必须为vpc所在cidr的子网
        """

        self.regionId = regionId
        self.vpcId = vpcId
        self.subnetName = subnetName
        self.addressPrefix = addressPrefix
        self.routeTableId = None
        self.description = None
        self.ipMaskLen = None
        self.dryRun = None

    def setRouteTableId(self, routeTableId):
        """
        :param routeTableId: (Optional) 子网关联的路由表Id, 默认为vpc的默认路由表,子网关联路由表需检查路由表中已绑定的子网与本子网类型是否一致（一致标准为：或者都为标准子网，或者都为相同边缘可用区的边缘子网）
        """
        self.routeTableId = routeTableId

    def setDescription(self, description):
        """
        :param description: (Optional) 子网描述信息,允许输入UTF-8编码下的全部字符，不超过256字符。
        """
        self.description = description

    def setIpMaskLen(self, ipMaskLen):
        """
        :param ipMaskLen: (Optional) 子网内预留网段掩码长度，此网段IP地址按照单个申请，子网内其余部分IP地址以网段形式分配。此参数非必选，缺省值为0，代表子网内所有IP地址都按照单个申请
        """
        self.ipMaskLen = ipMaskLen

    def setDryRun(self, dryRun):
        """
        :param dryRun: (Optional) 是否只预检此次请求。true：不会创建子网，只会对参数进行校验；false：正常的创建请求。默认为false。
        """
        self.dryRun = dryRun

