# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ImportKeypairRequest(JDCloudRequest):
    """
    
导入密钥。

与创建密钥不同的是，导入的密钥是由用户生成的。生成之后将公钥部分导入到京东云。

详细操作说明请参考帮助文档：[创建密钥](https://docs.jdcloud.com/cn/virtual-machines/create-keypair)

## 接口说明
- 调用该接口导入由其他工具生成的密钥对的公钥部分。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ImportKeypairRequest, self).__init__(
            '/regions/{regionId}/keypairs:import', 'POST', header, version)
        self.parameters = parameters


class ImportKeypairParameters(object):

    def __init__(self,regionId, keyName, publicKey):
        """
        :param regionId: 地域ID。
        :param keyName: 密钥对名称，需要全局唯一。
只允许数字、大小写字母、下划线“_”及中划线“-”，不超过32个字符。

        :param publicKey: 密钥对的公钥部分。
        """

        self.regionId = regionId
        self.keyName = keyName
        self.publicKey = publicKey

