# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ExportImageRequest(JDCloudRequest):
    """
    
导出私有镜像。

将京东云私有镜像导出至京东云以外环境。

详细操作说明请参考帮助文档：[导出私有镜像](https://docs.jdcloud.com/cn/virtual-machines/export-private-image)

## 接口说明
- 调用此接口将私有镜像导出到京东云对象存储空间中。
- 仅支持系统盘镜像导出，即使镜像有关联的数据盘快照，也仅会导出系统盘镜像文件。
- 导出的镜像文件格式为QCOW2。
- `Windows Server` 操作系统的镜像不支持导出（若镜像来源为导入镜像，则无此限制）。
- 镜像必须为 `云硬盘系统盘` 镜像，如您的镜像是 `本地盘系统盘` 镜像，可以通过镜像类型转换功能转换为云盘系统盘镜像后再导出。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ExportImageRequest, self).__init__(
            '/regions/{regionId}/images/{imageId}:exportImage', 'POST', header, version)
        self.parameters = parameters


class ExportImageParameters(object):

    def __init__(self,regionId, imageId, roleName, ossUrl, ):
        """
        :param regionId: 地域ID。
        :param imageId: 镜像ID。
        :param roleName: 用户创建的服务角色名称。
        :param ossUrl: 存储导出镜像文件的 `oss bucket` 的域名，请填写以 https:// 开头的完整url。
        """

        self.regionId = regionId
        self.imageId = imageId
        self.roleName = roleName
        self.ossUrl = ossUrl
        self.ossPrefix = None
        self.clientToken = None

    def setOssPrefix(self, ossPrefix):
        """
        :param ossPrefix: (Optional) 导出镜像文件名前缀，仅支持英文字母和数字，不能超过32个字符。
        """
        self.ossPrefix = ossPrefix

    def setClientToken(self, clientToken):
        """
        :param clientToken: (Optional) 用户导出镜像的幂等性保证。每次导出请传入不同的值，如果传值与某次的clientToken相同，则返还同一个请求结果，不能超过64个字符。
        """
        self.clientToken = clientToken

