# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateIndividualFirewallRuleRequest(JDCloudRequest):
    """
    更新一个单独的现有防火墙规则。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateIndividualFirewallRuleRequest, self).__init__(
            '/zones/{zone_identifier}/firewall$$rules/{id}', 'PUT', header, version)
        self.parameters = parameters


class UpdateIndividualFirewallRuleParameters(object):

    def __init__(self,zone_identifier, id, ):
        """
        :param zone_identifier: 
        :param id: 
        """

        self.zone_identifier = zone_identifier
        self.id = id
        self.action = None
        self.filter = None
        self.products = None
        self.priority = None
        self.paused = None
        self.ref = None
        self.action_parameters = None
        self.description = None

    def setAction(self, action):
        """
        :param action: (Optional) 应用于匹配请求的行动。注意，行动 "log "只适用于企业客户。
        """
        self.action = action

    def setFilter(self, filter):
        """
        :param filter: (Optional) 
        """
        self.filter = filter

    def setProducts(self, products):
        """
        :param products: (Optional) 
        """
        self.products = products

    def setPriority(self, priority):
        """
        :param priority: (Optional) 规则的优先级，允许控制处理顺序。一个较小的数字表示高优先级。如果不提供，任何有优先权的规则将在没有优先权的规则之前排序。
        """
        self.priority = priority

    def setPaused(self, paused):
        """
        :param paused: (Optional) 此防火墙规则当前是否已暂停。
        """
        self.paused = paused

    def setRef(self, ref):
        """
        :param ref: (Optional) 短引用标记，用于快速选择相关规则。
        """
        self.ref = ref

    def setAction_parameters(self, action_parameters):
        """
        :param action_parameters: (Optional) 
        """
        self.action_parameters = action_parameters

    def setDescription(self, description):
        """
        :param description: (Optional) 对规则的描述，以帮助识别它。
        """
        self.description = description

