# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateDNSRecordRequest(JDCloudRequest):
    """
    创建DNS记录
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateDNSRecordRequest, self).__init__(
            '/zones/{zone_identifier}/dns_records', 'POST', header, version)
        self.parameters = parameters


class CreateDNSRecordParameters(object):

    def __init__(self,zone_identifier, name, content, ttl, ):
        """
        :param zone_identifier: 
        :param name: DNS记录名称
        :param content: DNS记录内容
        :param ttl: DNS记录的生存时间。值为1是 "自动"。
        """

        self.zone_identifier = zone_identifier
        self.ty_pe = None
        self.name = name
        self.content = content
        self.ttl = ttl
        self.priority = None
        self.proxied = None
        self.srvData = None
        self.caaData = None

    def setTy_pe(self, ty_pe):
        """
        :param ty_pe: (Optional) DNS记录类型
        """
        self.ty_pe = ty_pe

    def setPriority(self, priority):
        """
        :param priority: (Optional) 与一些记录如MX和SRV一起使用，以确定优先级。如果你没有为MX记录提供一个优先级，默认值为0将被设置。
        """
        self.priority = priority

    def setProxied(self, proxied):
        """
        :param proxied: (Optional) 是否利用星盾的性能和安全优势
        """
        self.proxied = proxied

    def setSrvData(self, srvData):
        """
        :param srvData: (Optional) 
        """
        self.srvData = srvData

    def setCaaData(self, caaData):
        """
        :param caaData: (Optional) 
        """
        self.caaData = caaData

