# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeSlowDigestLogRequest(JDCloudRequest):
    """
    获取当前实例指定时间的慢SQL统计
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(DescribeSlowDigestLogRequest, self).__init__(
            '/regions/{regionId}/instance/{instanceGid}/slowDigestLog', 'GET', header, version)
        self.parameters = parameters


class DescribeSlowDigestLogParameters(object):

    def __init__(self, regionId,instanceGid,startTime, endTime, ):
        """
        :param regionId: 地域代码
        :param instanceGid: 实例ID
        :param startTime: 查询开始时间，格式为：2006-01-02T15:04:05Z
        :param endTime: 查询截止时间，格式为：2006-01-02T15:04:05Z
        """

        self.regionId = regionId
        self.instanceGid = instanceGid
        self.startTime = startTime
        self.endTime = endTime
        self.dbName = None
        self.userName = None
        self.clientIP = None
        self.keyword4Search = None
        self.sort = None
        self.pageIndex = None
        self.pageSize = None

    def setDbName(self, dbName):
        """
        :param dbName: (Optional) 过滤条件：数据库名
        """
        self.dbName = dbName

    def setUserName(self, userName):
        """
        :param userName: (Optional) 过滤条件：client 用户名
        """
        self.userName = userName

    def setClientIP(self, clientIP):
        """
        :param clientIP: (Optional) 过滤条件：client IP
        """
        self.clientIP = clientIP

    def setKeyword4Search(self, keyword4Search):
        """
        :param keyword4Search: (Optional) 模糊查询关键字，只支持单个单词
        """
        self.keyword4Search = keyword4Search

    def setSort(self, sort):
        """
        :param sort: (Optional) 按queryCount的排序方式，默认desc
        """
        self.sort = sort

    def setPageIndex(self, pageIndex):
        """
        :param pageIndex: (Optional) 显示数据的页码，默认为1，取值范围：[-1,∞)。pageIndex 为-1时，返回所有数据页码；
        """
        self.pageIndex = pageIndex

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 每页显示的数据条数，默认为10，取值范围：[1,100]，用于查询列表的接口
        """
        self.pageSize = pageSize

