# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class CacheInstanceSpec(object):

    def __init__(self, vpcId, subnetId, cacheInstanceName, cacheInstanceClass, azId, password=None, cacheInstanceDescription=None, redisVersion=None, ipv6On=None, shardNumber=None, userTags=None, resourceGroupId=None, dbNum=None, slaveAppendonly=None, maxmemoryPolicy=None, cacheInstanceType=None, replicaNumber=None, enableSmartProxy=None, port=None, extension=None, cpuArchType=None):
        """
        :param vpcId:  缓存Redis实例所属的私有网络ID
        :param subnetId:  缓存Redis实例在私有网络下所属的子网ID
        :param cacheInstanceName:  缓存Redis实例名称，只支持数字、字母、英文下划线、中文，且不少于2字符不超过32字符
        :param cacheInstanceClass:  缓存Redis实例的规格代码（可调用describeInstanceClass接口获取），或者自定义分片实例的单分片规格代码（可调用describeSpecConfig接口获取）
        :param password: (Optional) 缓存Redis实例的连接密码，为空即为免密，包含且只支持字母及数字，不少于8字符不超过16字符
        :param azId:  缓存Redis实例所在区域的可用区ID
        :param cacheInstanceDescription: (Optional) 缓存Redis实例的描述，不能超过256个字符
        :param redisVersion: (Optional) 缓存Redis引擎主次版本号：目前支持2.8和4.0，默认为2.8
        :param ipv6On: (Optional) 是否支持IPv6，0或空表示不支持，1表示支持IPv6，注意不是所有区域都支持IPv6，且必须保证VPC支持IPv6
        :param shardNumber: (Optional) 分片数，自定义分片规格集群版实例必须有，且大于1。每种分片规格支持的分片数可调用describeSpecConfig接口获取
        :param userTags: (Optional) 用户普通标签
        :param resourceGroupId: (Optional) 缓存Redis实例所属的资源组ID
        :param dbNum: (Optional) db数量，默认为16，参数范围为16~256
        :param slaveAppendonly: (Optional) slave节点是否开启持久化
        :param maxmemoryPolicy: (Optional) 内存淘汰策略
        :param cacheInstanceType: (Optional) 缓存Redis实例类型，目前支持：master-slave（标准版）、cluster（代理集群版）、native-cluster（cluster集群版）
        :param replicaNumber: (Optional) 副本数，含主副本
        :param enableSmartProxy: (Optional) 实例是否开启SmartProxy，当架构类型为native-cluster时才有效，1表示开启，0表示不开启
        :param port: (Optional) 缓存Redis实例访问端口
        :param extension: (Optional) 扩展配置
        :param cpuArchType: (Optional) cpu架构类型:arm64、amd64
        """

        self.vpcId = vpcId
        self.subnetId = subnetId
        self.cacheInstanceName = cacheInstanceName
        self.cacheInstanceClass = cacheInstanceClass
        self.password = password
        self.azId = azId
        self.cacheInstanceDescription = cacheInstanceDescription
        self.redisVersion = redisVersion
        self.ipv6On = ipv6On
        self.shardNumber = shardNumber
        self.userTags = userTags
        self.resourceGroupId = resourceGroupId
        self.dbNum = dbNum
        self.slaveAppendonly = slaveAppendonly
        self.maxmemoryPolicy = maxmemoryPolicy
        self.cacheInstanceType = cacheInstanceType
        self.replicaNumber = replicaNumber
        self.enableSmartProxy = enableSmartProxy
        self.port = port
        self.extension = extension
        self.cpuArchType = cpuArchType
