# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class BindCertRequest(JDCloudRequest):
    """
    网站类规则绑定 SSL 证书
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(BindCertRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/webRules/{webRuleId}:bindCert', 'POST', header, version)
        self.parameters = parameters


class BindCertParameters(object):

    def __init__(self, regionId,instanceId,webRuleId,certId):
        """
        :param regionId: 区域 ID, 高防不区分区域, 传 cn-north-1 即可
        :param instanceId: 高防实例 Id
        :param webRuleId: 网站规则 Id
        :param certId: 证书 Id. 使用 <a href='https://docs.jdcloud.com/cn/ssl-certificate/api/describecerts'>describeCerts</a> 接口, 按照域名检索可绑定的证书, 域名不匹配将导致证书配置失败
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.webRuleId = webRuleId
        self.certId = certId

