# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeInstanceMonitorInfoRequest(JDCloudRequest):
    """
    查询云物理服务器监控信息
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeInstanceMonitorInfoRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/monitor', 'GET', header, version)
        self.parameters = parameters


class DescribeInstanceMonitorInfoParameters(object):

    def __init__(self, regionId, instanceId, ):
        """
        :param regionId: 地域ID，可调用接口（describeRegiones）获取云物理服务器支持的地域
        :param instanceId: 云物理服务器ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.startTime = None
        self.endTime = None
        self.filters = None

    def setStartTime(self, startTime):
        """
        :param startTime: (Optional) 开始时间的时间戳，格式：1562915166551
        """
        self.startTime = startTime

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 结束时间的时间戳，格式：1562915166551
        """
        self.endTime = endTime

    def setFilters(self, filters):
        """
        :param filters: (Optional) metric - 监控指标，精确匹配，支持多个，具体如下<br/>
cps.cpu.util - CPU使用率<br/>
cps.memory.util - 内存使用率<br/>
cps.memory.used - 内存使用量<br/>
cps.disk.used - 磁盘使用量<br/>
cps.disk.util - 磁盘使用率<br/>
cps.disk.bytes.read - 磁盘读流量<br/>
cps.disk.bytes.write - 磁盘写流量<br/>
cps.disk.counts.read - 磁盘读IOPS<br/>
cps.disk.counts.write - 磁盘写IOPS<br/>
cps.network.bytes.ingress - 网卡进流量<br/>
cps.network.bytes.egress - 网卡出流量<br/>
cps.network.packets.ingress - 网络进包量<br/>
cps.network.packets.egress - 网络出包量<br/>
cps.avg.load1 - CPU平均负载1min<br/>
cps.avg.load5 - CPU平均负载5min<br/>
cps.avg.load15 - CPU平均负载15min<br/>
cps.tcp.connect.total - TCP总连接数<br/>
cps.tcp.connect.established - TCP正常连接数<br/>
cps.process.total - 总进程数

        """
        self.filters = filters

