# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AsyncAudioScanV2Request(JDCloudRequest):
    """
    提交音频异步检测任务V2
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AsyncAudioScanV2Request, self).__init__(
            '/audio:asyncscanv2', 'POST', header, version)
        self.parameters = parameters


class AsyncAudioScanV2Parameters(object):

    def __init__(self, ):
        """
        """

        self.bizType = None
        self.url = None
        self.version = None
        self.title = None
        self.ip = None
        self.account = None
        self.deviceId = None
        self.deviceType = None
        self.callback = None
        self.callbackUrl = None

    def setBizType(self, bizType):
        """
        :param bizType: (Optional) 业务bizType，请联系客户经理获取
        """
        self.bizType = bizType

    def setUrl(self, url):
        """
        :param url: (Optional) 最大长度512, 语音文件url
        """
        self.url = url

    def setVersion(self, version):
        """
        :param version: (Optional) 最大长度4，接口版本号，可选值 v3.5
        """
        self.version = version

    def setTitle(self, title):
        """
        :param title: (Optional) 最大长度512，文件标题
        """
        self.title = title

    def setIp(self, ip):
        """
        :param ip: (Optional) 最大长度32，用户IP地址
        """
        self.ip = ip

    def setAccount(self, account):
        """
        :param account: (Optional) 最大长度128，用户唯一标识，如果无需登录则为空
        """
        self.account = account

    def setDeviceId(self, deviceId):
        """
        :param deviceId: (Optional) 最大长度128，用户设备 id，与设备画像库匹配，明文请转大写传入；MD5加密请明文转大写后MD5计算，再转大写传入，建议抄送
        """
        self.deviceId = deviceId

    def setDeviceType(self, deviceType):
        """
        :param deviceType: (Optional) 用户设备id的类型，0:其他，10:IMEI，11:AndroidID，12:IDFA，13:IDFV，14:MAC ，20:IMEI_MD5，21:AndroidID_MD5，22:IDFA_MD5，23:IDFV_MD5，24:MAC_MD5
        """
        self.deviceType = deviceType

    def setCallback(self, callback):
        """
        :param callback: (Optional) 最大长度2^16-1，数据回调参数，调用方根据业务情况自行设计，当调用离线结果获取接口时，该接口会原样返回该字段，详细见音频离线检测结果获取。作为数据处理标识，因此该字段应该设计为能唯一定位到该次请求的数据结构，如对用户的昵称进行检测，dataId可设为用户标识（用户ID），用户修改多次，每次请求数据的dataId可能一致，但是callback参数可以设计成定位该次请求的数据结构，比如callback字段设计成json，包含dataId和请求的时间戳等信息，当然如果不想做区分，也可以直接把callback设置成dataId的值。
        """
        self.callback = callback

    def setCallbackUrl(self, callbackUrl):
        """
        :param callbackUrl: (Optional) 最大长度256，离线结果回调通知到客户的URL。主动回调数据接口超时时间设置为2s，为了保证顺利接收数据，需保证接收接口性能稳定并且保证幂等性。
        """
        self.callbackUrl = callbackUrl

