# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreatePolicyRequest(JDCloudRequest):
    """
    创建策略，不同策略类型有不同的规则，具体如下。
- AutoImage: 自动创建镜像策略
    - fireCondition
        - 仅支持"interval"，执行周期仅支持"小时/天/周"，如: "interval 7d"
        - 两次执行时间间隔需要大于12小时
    - fireTime
        - 触发时间，首次创建时距离当前时间必须在30分钟以后至1年以内。
        - 若策略曾经执行过，再次修改该字段时必须满足距离上一次执行时间超过12小时
    - execResource
        - 哪些云主机需要制作镜像，可指定具体云主机ID列表，每个策略最多绑定100个。
        - 仅支持云盘系统盘的虚机
    - execConfig
        - 配置规则例子:
        - [{"key":"includeDeviceName","value":"vdb,vdc"},{"key":"imageLiveDays","10"}]
        - includeDeviceName说明：云主机中的哪些云盘需要制作镜像，可指定具体盘符列表，或指定为"all"。云主机中的vda系统盘不可改变，一定要参与制作镜像。
        - imageLiveDays说明：镜像保留时间，以天为单位，范围1-36500。不指定则永久有效。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreatePolicyRequest, self).__init__(
            '/regions/{regionId}/policy', 'POST', header, version)
        self.parameters = parameters


class CreatePolicyParameters(object):

    def __init__(self,regionId, policySpec):
        """
        :param regionId: 地域ID
        :param policySpec: 策略配置
        """

        self.regionId = regionId
        self.policySpec = policySpec

