# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class QueryAccessAuthsRequest(JDCloudRequest):
    """
    查询访问授权列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(QueryAccessAuthsRequest, self).__init__(
            '/regions/{regionId}/accessAuths', 'GET', header, version)
        self.parameters = parameters


class QueryAccessAuthsParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域ID
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码, 默认为1, 取值范围：[1,∞)
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小，默认为20，取值范围：[10,100]
        """
        self.pageSize = pageSize

    def setFilters(self, filters):
        """
        :param filters: (Optional) auth_user_type - 授权类型，默认为 全部类型
auth_user_id - 用户标识，精确匹配，jd_cloud（京东云用户）, jd_apikms（api网关签名密钥）, jd_subscription_key（订阅密钥）,jd_cloud_pin（激活用户）

        """
        self.filters = filters

