# The Nanocluster Interpolation Scheme Program (NISP)

[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/NISP)](https://docs.python.org/3/)
[![GitHub release (latest by date)](https://img.shields.io/github/v/release/GardenGroupUO/NISP)](https://github.com/GardenGroupUO/NISP)
[![PyPI](https://img.shields.io/pypi/v/NISP)](https://pypi.org/project/NISP/)
[![Conda](https://img.shields.io/conda/v/gardengroupuo/nisp)](https://anaconda.org/GardenGroupUO/nisp)
[![Documentation Status](https://readthedocs.org/projects/nisp/badge/?version=latest)](https://nisp.readthedocs.io/en/latest/)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/GardenGroupUO/NISP/main?urlpath=lab)
[![GitHub](https://img.shields.io/github/license/GardenGroupUO/NISP)](https://www.gnu.org/licenses/agpl-3.0.en.html)

The Nanocluster Interpolation Scheme Program (NISP) is designed to perform an interpolation scheme that can give an idea of icosahedral, decahedral, and octahedral clusters that can be formed with a given number of atoms. 

This scheme is based on the work by Garden *et al.* as described in "Reassignment of ‘magic numbers’ for Au clusters of decahedral and FCC structural motifs", 

	*A. L. Garden, A. Pedersen, H. Jónsson, “Reassignment of ‘magic numbers’ of decahdral and FCC structural motifs”, Nanoscale, 10, 5124-5132 (2018).*

See https://doi.org/10.1039/C7NR09440J for more information on this scheme.

**If you are new to NISP, it is recommended try it out by running NISP live on our interactive Jupyter+Binder page before you download it. On Jupyter+Binder, you can play around with NISP on the web. You do not need to install anything to try NISP out on Jupyter+Binder.** 

**Click the Binder button below to try NISP out on the web! (The Binder page may load quickly or may take 1 or 2 minutes to load)**

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/GardenGroupUO/NISP/main?urlpath=lab)

All the information about this program is found online at [nisp.readthedocs.io/en/latest/](https://nisp.readthedocs.io/en/latest/). It is recommended to read the installation page before using the algorithm ([nisp.readthedocs.io/en/latest/Installation.html](https://nisp.readthedocs.io/en/latest/Installation.html)). Note that you can install NISP through ``pip3`` and ``conda``. See the [installation instructions](https://nisp.readthedocs.io/en/latest/Installation.html) on how to do this. 