#: Boltzman constant in eV/K unit
kB = 8.6173303e-5
#: electron volt in J unit
eV = 1.60217733e-19
#: angstrom in meter unit
angstrom = 1.0e-10
#: fento second in second unit
fs = 1e-15
#: kcal/mol in electron volt unit
kcal = 0.04337209302
#: atomic mass in eV, angstrom, fs unit
au_mass = 1.67e-27 / (eV / angstrom * fs / angstrom * fs)
#: scaling for the Mueller-Brown potential
escale = 0.2
lscale = 16.0
