/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as waf from '@aws-cdk/aws-wafv2';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the WafwebaclToCloudFront class.
 */
export interface WafwebaclToCloudFrontProps {
    /**
     * The existing CloudFront instance that will be protected with the WAF web ACL.
     *
     * This construct changes the CloudFront distribution by directly manipulating
     * the CloudFormation output, so this must be the Construct and cannot be
     * changed to the Interface (IDistribution)
     */
    readonly existingCloudFrontWebDistribution: cloudfront.Distribution;
    /**
     * Existing instance of a WAF web ACL, an error will occur if this and props is set
     */
    readonly existingWebaclObj?: waf.CfnWebACL;
    /**
     * Optional user-provided props to override the default props for the AWS WAF web ACL.
     *
     * @default - Default properties are used.
     */
    readonly webaclProps?: waf.CfnWebACLProps;
}
/**
 * @summary The WafwebaclToCloudFront class.
 */
export declare class WafwebaclToCloudFront extends Construct {
    readonly webacl: waf.CfnWebACL;
    readonly cloudFrontWebDistribution: cloudfront.Distribution;
    /**
     * @summary Constructs a new instance of the WafwebaclToCloudFront class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToCloudFrontProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope: Construct, id: string, props: WafwebaclToCloudFrontProps);
}
//# sourceMappingURL=index.d.ts.map