from docutils import nodes

from added_value.pyobj_role import make_pyobj_role


def make_literal_repr_node(rawtext, app, prefixed_name, obj, parent, modname, options):
    """Render a Python object to text using the repr() function.

    :param rawtext: Text being replaced with link node.
    :param app: Sphinx application context
    :param prefixed_name: The dotted Python name for obj.
    :param obj: The Python object to be rendered to text.
    :param parent: The parent Python object of obj.
    :param module: The name of the module containing obj.
    :param options: Options dictionary passed to role func.
    """
    text = repr(obj)
    node = nodes.literal(text=text, rawsource=rawtext)
    return node


literal_repr_role = make_pyobj_role(make_literal_repr_node)
