# Release 2.2.0

## Summary
This release features work done by our GSoC 2020 interns: Abhay Katheria and Junlai Wang. Abhay created a new HTML format which greatly helps the readability of all the container image metadata Tern supports. He also made a significant effort in inventorying go applications that use go modules. Junlai greatly improved the parsing of RUN instructions, increasing Tern's accuracy in detecting binaries used to install packages. He also added initial functionality to analyze multistage Dockerfiles. Thanks Abhay and Junlai for your work towards this release!

In addition, we have enabled Tern to run in a container without the need for a Linux host. This feature allows Windows and Mac OS X users to run Tern natively if they have Docker installed.

At this point, we think that we are on our way to making the next release a Beta release. For this to happen, we need to do a few housekeeping tasks:
* Refactor the code to allow our community to make changes more easily.
* Allow our CI/CD pipeline to test our currently supported extensions.
* Increase our code coverage.

As always, we would like to thank our community for contributing to this release.

## New Features
* [HTML format](https://github.com/tern-tools/tern/issues/614): You can now create a browsable HTML document using `tern report -f html -i <image> -o image.html`. To view this document, just open it in your browser.
* [Run Tern in a Docker container on a non-Linux host](https://github.com/tern-tools/tern/issues/679): You can now run Tern in a Docker container on Windows and Mac OS X development environments that have Docker installed. Build the container image using `docker build -t tern:v2.2.0 -f Dockerfile .` to build the Docker container with Tern installed and run `docker run --privileged --device /dev/fuse -v /var/run/docker.sock:/var/run/docker.sock` or use the `docker_run.sh` script.
* [Better RUN instruction parser](https://github.com/tern-tools/tern/issues/521): Tern will now report any non-deterministic branching statements for which it is not known which branch was executed during container build. In general, the new shell script parser improves Tern's accuracy to determine what gets installed in complicated shell scripts used in the RUN instruction of a Dockerfile.
* [Go application support](https://github.com/tern-tools/tern/issues/695): Tern can now inventory Go applications which use Go modules. At this time, Tern does not support previous versions of Go dependency management like the vendor directory.
* [Collect package information using Scancode](https://github.com/tern-tools/tern/issues/790): Tern can now collect package information using the Scancode extension.
* [Support for openSUSE](https://github.com/tern-tools/tern/issues/693): Tern now supports openSUSE based images.
* [Support for microdnf](https://github.com/tern-tools/tern/issues/724): Tern now supports inventorying packages installed with microdnf.

## Deprecated Features
* [Instantiate only with image and tag or image and digest](https://github.com/tern-tools/tern/issues/747): Images on registries are either identified by the image name and tag or the image name and manifest digest. As this is the standard way of referencing images, the instatiation with image ID is not necessary.

## Bug Fixes
* [Replace YAML file cache with JSON for faster parsing](https://github.com/tern-tools/tern/issues/627)
* [Skip empty layers rather than exiting](https://github.com/tern-tools/tern/issues/686)
* [Fix absolute symlink to busybox in Alpine based images](https://github.com/tern-tools/issues/769)
* Fix SPDX tag-value validation errors
* [Fix inventorying images in a raw tarball format](https://github.com/tern-tools/issues/719)
* [Fix property name in output reporting](https://github.com/tern-tools/tern/issues/741)
* Some CI/CD fixes
* [Fix package version string reporting for Alpine](https://github.com/tern-tools/tern/issues/758)
* [Fix exit if the RUN instruction is too long](https://github.com/tern-tools/tern/issues/772)

## Resolved Technical Debt
* Moved license collection and printing to the report module.
* [Remove raise immediately statements](https://github.com/tern-tools/tern/issues/201)

## Future Work
* A code refactor to make it easy to make future changes.
* A "step" subcommand to step through container image layers and analyze them individually.
* Multistage Dockerfile analysis.
* Analysis for OCI style images.

The next release is slated for the end of November 2020. February 2021's release will be a small one due to winter holidays in the US. We will try to create more good-first-issues and hacktoberfest issues this time around. Watch the [project roadmap](/docs/project-roadmap.md) for updates.

## Changelog

Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.1.0..master`

```
a0dd8cd merge: Integrate package data from scancode
dfcacca Reconcile scancode packages with existing ones
f845ac3 Include packages collected by scancode in reports
888fb74 Split multistage dockerfile for building images
bd94e91 Enable golang package listing
b425819 Set environment vars before package collection
e291986 Add logic to find shell in Alpine images
f752cde Remove warning to Mac users in README
420fa38 Skip empty layers during analysis
5259e56 merge: Run in container on a non-linux host
cfb86a0 Update utilities to set working directory
e5bc4f8 Enable Terns run in a container for non-Linux host
cf1c707 Amend Dockerfile and docker_run for fuse-overlayfs
b6f353a Add support to execute commands from WORKDIR
ecad1cd Fixes exit with complicated RUN statement
92bca0e merge: Improve branch statement reporting
5d69043 Add test for get_shell_commands()
4ab945d Add report for branch statement
044dc47 Fix package version collection for Alpine
56a9a7a Update functions for shell script parser
6f9c73c Bump up prospector and bandit versions
3444740 github actions: Use a supported python version
f3f54fa Add docker APIError to list of possible exceptions
abf6e91 Removing multiple options to instantiate Image class
fd147bf Remove raise immediately statements
3d598b3 Use container image layer index
ad35588 Remove extra underscore in Image class properties
d8960bb Add CI test for HTML format
21fd581 Print report to console if no output file provided
465c1bc Remove failing CircleCI badge from README
6bb9179 Add HTML report format
aca49c6 Add new HTML report format
352e037 Move license collection reporting to content.py
dea53a8 Update GH Actions for better UI presentation
e7e3c80 Remove circleci from running on pull requests
cdf8f70 merge: Initial RUN shell script parser
c1f7e33 Quick fix on pipe symbol and export cmd
9a81523 Generate report.txt when no output file specified
c090e49 Add parse loop and use clean_command()
df38d0c Replace yaml file cache
d8a86c5 utils: Use JSON instead of YAML as cache
3151796 extensions: scancode: Store headers as a list
07279ca formats: spdxtagvalue: Fix missing LicenseRef
179df2e Using Regex to split shell script
535802e Adding microdnf package type
4c7ef6b formats: spdxtagvalue: Fix 2.2 validation errors
e463831 Don't set digest type for raw image tarballs
f3e4425 Adding zypper to analyze openSUSE images
e228afa Add test dockerfiles for split shell script.
fc5cc50 Allow for multiple snippet install and remove cmds
3ec6a98 Update README with support Docker image info
```

## Contributors

```
Abhay Katheria abhay.katheria1998@gmail.com
mukultaneja mtaneja@vmware.com
WangJL hazard15020@gmail.com
Yann Jorelle yann.jorelle@nokia.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
