# Release 2.0.0

## Summary
This is Tern's second major release. Our CLI has changed since the last release to account for a new feature and two new CLI options:
* The ability to "lock" a provided Dockerfile (`tern lock <path_to_Dockerfile>` will produce `Dockerfile.lock`). See "New Features" section below for more details.
* Enable logging capability by default (i.e. remove the `-l, --logging` CLI option) and instead add the ability to silence terminal output as an option (`-q, --quiet` option).
* Add new CLI option for user to set the working directory somewhere else besides the default location of the users home directory (`--wd, --working-dir` option)

We are still in alpha development mode, so the CLI might change in the future, in which case, expect another major release bump.

Apart from the addition of the new `Dockerfile lock` feature and CLI option changes, we have also included some bug fixes and work towards better test coverage. Significant improvements have been made to the way Tern runs with the Scancode extension and documentation has been improved.

We'd like to thank all those who contributed to this release, which ended up being a more signficant milestone than expected.

## New Features
* Dockerfile lock: This is new functionality that creates a "locked" Dockerfile in which the base image is pinned to a digest and the packages installed for each subsequent layer are pinned to their versions if they are known. Tern will also expand `ARG` and `ENV` variables and try to find information about git repositories that may be `ADD`ed within the Dockerfile provided. This helps create a Dockerfile from which a repeatable container image may be built. To utilize this feature, run `tern lock <path_to_Dockerfile> -o <output_file>`. Tern will try to first build your Dockerfile before creating the pinned output file. If there are artifacts not accessible to the build or the build fails for other reasons, Tern will only inspect the base image and therefore, won't be able to pin package information in the locked output file
* [Map Scancode's data into Tern's data model](https://github.com/vmware/tern/issues/480): This allows file level licenses found in Scancode's data collection to be reported in Tern's default report format when running with the `-x, --extend` CLI option.

## Bug Fixes
* [Only allow specifying an image and tag or an image digest](https://github.com/vmware/tern/issues/519)
* [Allow user to set working directory](https://github.com/vmware/tern/issues/523)
* [Allow Tern to save to and load from FileData information from the cache](https://github.com/vmware/tern/issues/574)
* [Fix reporting of file level data in defualt and SPDX reports](https://github.com/vmware/tern/issues/583)
* Fix file and base OS caching
* [Exit gracefully if Dockerfile base OS does not exist](https://github.com/vmware/tern/issues/610)
* [Update Scancode documentation](https://github.com/vmware/tern/issues/532)
* [Map Scancode's data into Tern's data model](https://github.com/vmware/tern/issues/480)

## Resolved Technical Debt
* [Replace homegrown Dockerfile parser with dockerfile-parse](https://github.com/vmware/tern/issues/522)
* [Parse version and arch when specified in the package name](https://github.com/vmware/tern/issues/2)
* Multiple commits that work towards [Increasing test coverage](https://github.com/vmware/tern/issues/539)
* Enable tox to run unit tests

## Future Work
* We will be focusing on adding support for language package managers.
* We will integrate Scancode file scanning output in to Tern's output reports.
* We will get two Google Summer of Code Interns to help us work towards our target milestones this summer.
* As usual, we will be refactoring code, addressing technical debt, and fixing bugs.

The next planned release will take place at the end of June 2020. Watch the [project roadmap](/docs/project-roadmap.md) for updates.

## Changelog

Note: This changelog will not include these release notes

Changelog produced by command: `git log --pretty=format:"%h %s" v1.0.1..master`

```
b626d60 Except 'NotFound' error if FROM image DNE
765b699 Fix file and base OS caching
60517eb merge: Dockerfile lock cleanup
3dc7f5d docs: Update scancode documentation
bd21eec Replace manual dfile parser with dockerfile-parse
8476d56 Update parsing functions to use dockerfile objects
0495eba Add dfile_lock & dfobj flags to analysis functions
559a685 analyze: Fix caching for base layer
f7e29ff Don't store multiple copies of notices
94626aa analyze: Resolve loading files and packages
6453df0 analyze: Find the base OS binary without mounting
1b0f454 Add quotations around Dockerfile name for clarity
5a07a79 Revert "Check cache before finding shell"
873094a Include base OS value in Tern's data model
22ec926 file_data.py: Add checksums property
101082e Fix TypeError for Dockerfile scratch base images
92e1971 analyze: docker: Check cache before finding shell
66f72e6 Include file level licenses in the default report
6de1f35 merge: Add dockerfile lock feature
7482f23 Add dockerfile lock functionality
7dda602 Include dockerfile lock in execute_dockerfile()
1a8bdb4 Change path to absolute when building from dfile
7425e70 Add function to return pinning_separator
a8499c4 Add locked dockerfile to constants
282ac28 Add Dockerfile lock functionality to Tern CLI
ef6e778 Record git project name and sha
f5875a8 CLI: Removed -l option add a --quiet option
aa87d3e merge: Integrate file level data from scancode
2c216e5 tests: test_analyze_common.py
69f1b45 Parsing ARG variables
9dc4f2c extensions:scancode: Only scan at directory level
d99461e Cache file level data
f0e5cae Update FileData object and scancode executor
6957e3a classes: Add merge method to FileData class
df58a64 extensions: scancode: Fix call to get_file_command
f73e6c0 Add .tox and .coverage to gitignore
a090517 Load FileData info from cache
c9ff72f Integrate scancode data
a4c107f Parse package name from version
403645f extensions: Integrate scancode results
b292aa6 classes: Add file_type setter to FileData
4d9efd9 image_layer.py: Extract file data attributes
191e6c5 tests: test_class_image
397ba9d Add --wd argument to change the working directory
a389f17 Document YAML data output that Tern produces
e919f2d classes: Add FileData object list to package class
cea8d43 classes: Added FileData object list to ImageLayer
1780b71 tox.ini: configure and run tox
3dbd5a0 Extract sha digest of Docker image
6edc4c8 container: close the client socket
ed2440a README: Clarified extensions usage
705327d Added --rm in docker_run.sh
874da23 Added conditional to check the mountpoints
3438a55 Cleanup README
8ca5287 formats: spdx: Add implementation for file_data
5726c87 Add new class FileData
9f037de tests: Fix reuse of python builtin id
1bca746 Add new class FileData
f6edaf2 Remove coverage --fail-under flag
3f93d66 config.yml: Add coverage
487af91 test_class_docker_image: Add a test image
8f843a0 ci/cd: Migrate Tern from CircleCI to GH Actions
a74ad06 Remove unwanted tests
6f09399 Use dockerfile_parse to get Dockerfile info
d18c4e1 __main__.py: Check docker image string
0c1a7b0 customizes usage instructions for MAC users
0939ffe Bump prospector version and disable pep8 N802
fce20eb extensions: scancode: Ignore stderr if json exists
aa016d7 Run extensions with sudo
28be825 Update copyright dates for 2020
1b76f65 analyze: use passthrough command full path
4583c5f utils: Update shell_command calls
241fbd0 Allow cve-bin-tool and scancode to run as root
0ea14f0 Allow plugin provided commands to run as root
c90a14f utils: Move check for userid to general
0a33246 circleci: Update prospector profile
2805884 merge: pep8/pylint fixes
b59b3b4 Fix pylint cyclic-import error
821dc08 Fix no-else-continue pylint error from prospector
08f2d7c Fix pep8 E121 linting error from prospector
6e7ae88 Remove semicolon from end of line
2c7150d Fix unnecessary-pass pylint error from prospector
a28f49c Fix N805 pep8 error from prospector
6b33637 Fix pep8 E126 and W293 errors from prospector
2c41e5a executor: scancode: Use pip package
2d1d12c docs: Update README project status
cc65fcb Corrections to release chklist and v101 rel. notes
```

## Contributors

```
abhay abhay.katheria1998@gmail.com
Malini Bhandaru mbhandaru@vmware.com
mukultaneja mukultaneja91@gmail.com
PrajwalM2212 prajwalmmath@gmail.com
Radmir Mukhambetov radmirnovii@gmail.com
WangJL hazard15020@gmail.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
