# Release 0.4.0

## Summary
Although the focus of this release was on enabling SPDX formatted reports, a good chunk of work went into resolving technical debt. Most notably Michael Rohan's work towards cleaning up code style and enabling a workflow for contributors to check for linting errors. There was also a lot of work by Santiago Torres towards making Tern pip installable.

Tern now supports the SPDX document format. As of this release the documents produced are valid SPDX. You can try it out by running `tern -l report -i <docker image> -m spdxtagvalue -f spdx-container-image.txt`. You can validate the document using [SPDX tools](https://github.com/spdx/tools). Note that python tools are still a work in progress but you can get on the [mailing list](https://lists.spdx.org/g/spdx-tech) and ask questions about the document there.

There is still work needed towards turning the license strings reported by the package managers into SPDX style license strings. The project is committed to working with SPDX towards finding a solution. A possible solution would be to query a database for the correct string, but this would have to be extra functionality to be added to the template. [This issue](https://github.com/spdx/tools-python/issues/106) tracks the progress on the module that will do the mapping. [This issue](https://github.com/vmware/tern/issues/281) tracks the progress of integrating that module into the Tern codebase.

We've added some new badges to the README. One of them is the [Core Infrastructure Initiative](https://www.coreinfrastructure.org/programs/badge-program/) which is an indication of how mature the project is in terms of secure Open Source development. Watch this badge to see Tern's progress in this area.

## New Features
* Support for Arch linux based container images
* Support for rpm based container images
* Prospector as a development tool to check for linting errors
* Make Tern pip installable
* Ground work for dynamically loadable reporting templates
* Enabling the SPDX tag-value template to create SPDX documents for container images

## Bug Fixes
* [Tern is not pulling data from cache](https://github.com/vmware/tern/issues/246)
* [Cannot retrieve full image metadata for Vagrant Image](https://github.com/vmware/tern/issues/220)

## Resolved Technical Debt
* Fixed broken class tests
* Fixed the verify_invoke.py script to help validate the scripts in the Command Library's base.yml and snippets.yml files
* Replaced `src_url` string to `proj_url` to be more accurate
* Renamed `id` and `license` class properties to something that is not a Python builtin
* Removed an unused argument in get_base_bin function

## Future Work
Release 0.5.0 will be a small release focusing on CI/CD enabling. So there may not be that much activity in the codebase during this time. Once we have some good tests to run for every PR submitted, a decent build and release pipeline and repositories to host the release artifacts, we will be ready to work on the codebase again. Enabling CI/CD this early in the project is crucial to its growth. So I am comfortable holding off on development for a little while until this is squared away.

## Changelog

Note: This changelog will not include these release notes

Changelog produced by command: `git log --pretty=format:"%h %s" v0.3.0..master`

```
99b46f3 report: spdxtagvalue: Generate license reference
29dce08 report: spdxtagvalue: Format license into SPDX format
e1c86eb report: spdxtagvalue: Added missing mandatory fields
d1c4ebd requirements: Bump up versions for all dependencies
02a36f2 docs: Fixed errors in steps to run
0a02c16 docs: Updated project roadmap
6fc1813 docs: Updated architecture documents
7f612c0 docs: Updated code navigation document
34085d4 cache: Removed unused cache.yml file
0a2e50f docs: Removed contributing-setup.md
3caf408 docs: README: Added new information with formatting
794d923 docs: Added section on development environment
e1e47e8 Added docs for SPDX tag-value proposal
9c03978 docs: Added docs for custom templating
4995bbd Tighten SPDX document reporting
a5c5b48 report: spdxtagvalue: Fix typo and add newline
e253677 report: spdxtagvalue: Reorder and format fixes
731088b report: spdxtagvalue: Fixes to formatting
4a4c146 Plugin SPDX formatting functionality
94b8f1f main: Move check_file_existence out of main
f4bcb83 main: Add argument for format type
0d6a7c7 report: spdxtagvalue: Full generator implementation
81c0317 report: content: Fixed unnecessary else
d5089f3 report: spdxtagvalue: Image level reporting
1f19a04 report: spdxtagvalue: Fixes to generator
4b92bde report: spdxtagvalue: Document level SPDX tag-value
a9ee220 classes: Added method to get an image name
3d8b95a refactor: Separate version reporting
af95a54 report: spdxtagvalue: Added formats for SPDX document
14debf5 report: Wrote up skeleton code for SPDX generator
9947516 report: Initial addition of SPDX doc generator
fd1e531 Rename 'src_url' to 'proj_url'
0dd323d Add test for get_package_id in the Package class
b369172 classes: Modified SPDX template to match spec
a90ec33 classes: Add download_url property to Package class
43c0236 Added get_package_id method to the Package class
3b7f645 merge: Allow for Copyright text metadata
5cb55a2 classes: Fix check for property filter
d074eab PEP8: Fix lines longer than 80 characters
d1ca7e7 report: Modify formatting to accomodate copyrights
c6935b2 refactor: Separate collecting and formatting metadata
601d7dd command_lib: Add copyright to base keys
f6d8fe3 classes: Check for missing properties in fill method
12a4e8e command_lib: Removed individual package collection
6226a2e classes: Added copyright property to Package class
a181c29 Fix to resolve inability to look up cached data
2dc4c13 report: updated package object's license property
4c09c08 utils: Fix functions to update the cache properly
9f90972 ISSUE_TEMPLATE: Added task and tinytask templates
1cd4267 tests: Removed unnecessary print statements
83049be Added encoding annotation to python source files (#238)
dacb085 Merge Custom templating - 3
5e5aeb6 Renaming license to pkg_license in all classes and tests
b7e75f5 tests: Added new test file for class Origins
611a756 classes: Allow Origins class to accept Template
14c3691 Accept Template object in class NoticeOrigin
a449276 classes: Removed 'levels' from dict object
e9f5614 Accept Template object in Notice class
010ff38 Groundwork for custom templating - 2
f168d64 Added test for templating in Image class
c72c76d classes: to_dict accepts Template for DockerImage
416e9f3 classes: Refactor to_dict for Package class
d1af787 classes: Refactor to_dict for ImageLayer
59f109d tests: Added more tests for Image class
87131e9 Image class's to_dict method takes Template object
3e3917f classes: Removed unnecessary redefined-builtin
1b2278b Renaming id to image_id in all classes and tests Resolves part of issue #213
5bbe788 Removing an unused argument from get_base_bin.
1347bb3 tests: dismiss warning for subprocess module
01db3f1 tests: Replace Copyright docstring with comments
44bb30c Merge pull request #225 from nishakm/174-SPDX-tag-value-doc
a9faee4 classes: Package: code, comments and tests cleanup
c069da7 classes: Modified to_dict method for ImageLayer
8982205 tests: Added template test to Package unittest
bdf9fc0 tests: Added tests for templates
94fa5a6 tests: Fixed Package class tests
b61f66c classes: Modified to_dict method to use template
3c5f75b utils: Added function to get object properties
a96abaa classes: Fixed method name image_layer
47c80d5 classes: Added initial template - SPDX
dd767aa classes: Added abstract class Template
a1f02d3 Adding 'attr' install in vagrant bootstrap.
92f5e29 Resolve code check issues for tern/utils/dockerfile.py
1dcf9cc Updated requirements to direct dependencies
75f2307 Resolve code check issue for tern/tools/verify_invoke.py
885a1cc Resolve code check issues for tern/__main__.py
b60cd58 Resolve code check issues for tern/common.py
bdb087e Resolve code check issues for tern/docker_helpers.py
34cb3d0 Resolve code check issues for tern/command_lib/command_lib.py
7eb8797 Minor edits to the README.md file
44d5525 Resolve code check issue for tern/classes/command.py
877e416 Resolve code check issues for tern/classes/docker_image.py
484a971 Resolve code check issues for tern/classes/image.py
ce3c690 Resolve code check issues for tern/classes/image_layer.py
267e4e1 Resolve code check issues for tern/classes/notice.py
a8c6efb Resolve code check issues for tern/classes/notice_origin.py
55efaa0 Resolve code check issues for tern/classes/origins.py
5beb5fb Resolve code check issues for tern/classes/package.py
95930ad Resolve code check issues for tern/report/errors.py
67f75b0 Resolve code check issues for tern/report/content.py
3c39ace Resolve code check issues for tern/report/formats.py
e30c709 Resolve code check issues for tern/report/report.py
a2da4e6 tests: Fixed some simple class tests
23c65b8 tools: Update verify_invoke.py script
b69ceb7 Add initial support for rpm based distros
4c33b30 Resolve code check issues for tern/utils/container.py
4e1bedf Resolve code check issues for tern/utils/constants.py
c4ef780 Resolve code check issues for tern/utils/cache.py
70796e8 Resolve code check issues for tern/utils/general.py
3b79932 Resolve code check issues for src/utils/metadata.py
cc7b64f Resolve code check isues for src/utils/rootfs.py
5d669ea README: modified install scripts to use pip
540f1e8 Make tern pypi installable
0aeb127 Dockerfile: remove WORKDIR instruction
e76cb57 travis: fix executable script
c845c8c Dockerfile: use the pip installable command
27e77ca utils:general: fix "not running inside a git repo"
2651b9e setup: bump version, make importable
ce19ad2 tern: use pkg_resources to do information lookup
865c3b0 setup: syntax fixes
862ef7b tern:main: factor main into a function
03fdccb tern: batch import fixes
d952d4d utils/cache: catch non-existing cache
4c68730 src -> tern
b08182b Add development requirements file
bd99e82 command_lib:base,snippets: add archlinux support
```

## Contributors

```
Santiago Torres santiago@archlinux.org/torresariass@gmail.com
Michael Rohan mrohan@vmware.com
Justin Garrison justinleegarrison@gmail.com
Ravi Parikh parikhr@vmware.com
Manisha Tripathy tripathym@vmware.com
Rose Judge rose.harber@gmail.com
Steve Winslow swinslow@gmail.com
```

## Contact the Maintainer

Email: nishak@vmware.com

Twitter: @nishakmr
