# Release v0.1.0

## Summary
This is Tern's first release.

## Notes
* Tern now uses Docker CLI only when working with Docker images. At this time, only images built by Docker are supported.
* Tern uses overlayfs to step through container image filesystem layers. OverlayFS is supported in kernel version 4.0 or higher.
* Tern requires root privileges to run because it needs to mount procfs in order to run commands within a chroot environment and call the Docker CLI. It is enough if you have configured sudo; Tern will ask for your password before running any priviledged commands.
* You can give Tern a Dockerfile to build and inspect the resulting image. This is helpful either in a development environment or during build and release. This gives you some understanding on how your Dockerfile affects the packages installed in your container during a build. 
```
$ ./tern report -d <path to Dockerfile>
```
* You can give Tern a local Docker image that you have pulled from a registry like Dockerhub. Tern will try to give as much information as it can obtain from the container image.
```
$ ./tern report -i <Docker image:tag>
```
* The Dockerfile and shell parser are still rudimentary. Please file an issue if it does not work for your Dockerfile or image.
* The Command Library is still small. If you would like to contribute to it, please read our [contributing guidelines](CONTRIBUTING.md) and [this document](docs/adding-to-command-library.md).
